using Microsoft.Diagnostics.Tracing.Parsers.Kernel;
using System;

// This code generated by TraceParserGen and then heavily modified to forward to the Kernel version of 
// these events.  
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
    public sealed class MicrosoftWindowsKernelFileTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "Microsoft-Windows-Kernel-File";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0xedd08927), unchecked((short)0x9cc4), unchecked((short)0x4e65), 0xb9, 0x70, 0xc2, 0x56, 0x0f, 0xb5, 0xc2, 0x89);
        public enum Keywords : long
        {
            Filename = 0x10,
            Fileio = 0x20,
            Opend = 0x40,
            Create = 0x80,
            Read = 0x100,
            Write = 0x200,
            Deletepath = 0x400,
            Renamesetlinkpath = 0x800,
            Createnewfile = 0x1000,
        };

        public MicrosoftWindowsKernelFileTraceEventParser(TraceEventSource source) : base(source)
        {
            StateObject = Source.Kernel.StateObject;
        }

        public event Action<FileIOCreateTraceData> Create
        {
            add
            {
                source.RegisterEventTemplate(CreateTemplate(value, Source.Kernel.State));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
            }
        }

        #region private

        protected override string GetProviderName() { return ProviderName; }

        static private FileIOCreateTraceData CreateTemplate(Action<FileIOCreateTraceData> action, KernelTraceEventParserState kernelState)
        {
            // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new FileIOCreateTraceData(action, 12, 12, "Create", Guid.Empty, 0, "", ProviderGuid, ProviderName, kernelState);
        }

        static private volatile TraceEvent[] s_templates;
        internal protected override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[1];
                templates[0] = CreateTemplate(null, null);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        #endregion
    }
}

