using Microsoft.Diagnostics.Tracing.Parsers.JScript;
using System;
using System.Diagnostics;
using System.Text;
using Address = System.UInt64;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "1.0")]
    public sealed class JScriptTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "Microsoft-JScript";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0x57277741), unchecked((short)0x3638), unchecked((short)0x4a4b), 0xbd, 0xba, 0x0a, 0xc6, 0xe4, 0x5d, 0xa5, 0x6c);
        public enum Keywords : long
        {
            JScriptRuntime = 0x1,
            JScriptStartRundown = 0x2,
            JScriptEndRundown = 0x4,
            JScriptProjection = 0x10,
            JScriptFrontend = 0x20,
            JScriptGarbageCollection = 0x40,
            JScriptProfile = 0x80,
            JscriptBackend = 0x100,
            JscriptJit = 0x200,
            JScriptMemoryTracing = 0x400,
            JScriptObjectAllocation = 0x800,
            JScriptExternalReference = 0x1000,
            JScriptObjectCleanup = 0x2000,
        };

        public JScriptTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<EmptyTraceData> MethodRundownDCStartInit
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 1, 3, "MethodRundown", new Guid(), 14, "DCStartInit", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MethodRundownDCStartComplete
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 2, 3, "MethodRundown", new Guid(), 12, "DCStartComplete", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MethodRundownDCStopInit
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 3, 3, "MethodRundown", new Guid(), 15, "DCStopInit", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MethodRundownDCStopComplete
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 4, 3, "MethodRundown", new Guid(), 13, "DCStopComplete", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4, ProviderGuid);
            }
        }
        public event Action<MethodLoadUnloadJSTraceData> MethodRundownMethodDCStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new MethodLoadUnloadJSTraceData(value, 5, 3, "MethodRundown", new Guid(), 10, "MethodDCStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5, ProviderGuid);
            }
        }
        public event Action<MethodLoadUnloadJSTraceData> MethodRundownMethodDCStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new MethodLoadUnloadJSTraceData(value, 6, 3, "MethodRundown", new Guid(), 11, "MethodDCStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 6, ProviderGuid);
            }
        }
        public event Action<ScriptContextLoadUnloadTraceData> ScriptContextRundownScriptContextDCStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ScriptContextLoadUnloadTraceData(value, 7, 4, "ScriptContextRundown", new Guid(), 10, "ScriptContextDCStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 7, ProviderGuid);
            }
        }
        public event Action<ScriptContextLoadUnloadTraceData> ScriptContextRundownScriptContextDCStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ScriptContextLoadUnloadTraceData(value, 8, 4, "ScriptContextRundown", new Guid(), 11, "ScriptContextDCStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 8, ProviderGuid);
            }
        }
        public event Action<MethodLoadUnloadJSTraceData> MethodRuntimeMethodLoad
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new MethodLoadUnloadJSTraceData(value, 9, 1, "MethodRuntime", new Guid(), 10, "MethodLoad", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 9, ProviderGuid);
            }
        }
        public event Action<MethodLoadUnloadJSTraceData> MethodRuntimeMethodUnload
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new MethodLoadUnloadJSTraceData(value, 10, 1, "MethodRuntime", new Guid(), 11, "MethodUnload", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, ProviderGuid);
            }
        }
        public event Action<ScriptContextLoadUnloadTraceData> ScriptContextRuntimeScriptContextLoad
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ScriptContextLoadUnloadTraceData(value, 11, 2, "ScriptContextRuntime", new Guid(), 10, "ScriptContextLoad", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, ProviderGuid);
            }
        }
        public event Action<ScriptContextLoadUnloadTraceData> ScriptContextRuntimeScriptContextUnload
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ScriptContextLoadUnloadTraceData(value, 12, 2, "ScriptContextRuntime", new Guid(), 11, "ScriptContextUnload", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_ResolveTypeStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 13, 5, "Jscript_Projection_ResolveType", Jscript_Projection_ResolveTypeTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_ResolveTypeTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_ResolveTypeStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 14, 5, "Jscript_Projection_ResolveType", Jscript_Projection_ResolveTypeTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 14, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_ResolveTypeTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_ConstructRuntimeClassStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 15, 6, "Jscript_Projection_ConstructRuntimeClass", Jscript_Projection_ConstructRuntimeClassTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 15, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_ConstructRuntimeClassTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_ConstructRuntimeClassStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 16, 6, "Jscript_Projection_ConstructRuntimeClass", Jscript_Projection_ConstructRuntimeClassTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 16, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_ConstructRuntimeClassTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_MethodCallStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 17, 7, "Jscript_Projection_MethodCall", Jscript_Projection_MethodCallTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 17, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_MethodCallTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_MethodCallStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 18, 7, "Jscript_Projection_MethodCall", Jscript_Projection_MethodCallTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 18, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_MethodCallTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_RawMethodCallStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 19, 8, "Jscript_Projection_RawMethodCall", Jscript_Projection_RawMethodCallTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 19, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_RawMethodCallTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_RawMethodCallStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 20, 8, "Jscript_Projection_RawMethodCall", Jscript_Projection_RawMethodCallTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 20, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_RawMethodCallTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_InvokesJsDelegateStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 21, 9, "Jscript_Projection_InvokesJsDelegate", Jscript_Projection_InvokesJsDelegateTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 21, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_InvokesJsDelegateTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_InvokesJsDelegateStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 22, 9, "Jscript_Projection_InvokesJsDelegate", Jscript_Projection_InvokesJsDelegateTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 22, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_InvokesJsDelegateTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_InvokeNativeDelegateStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 23, 10, "Jscript_Projection_InvokeNativeDelegate", Jscript_Projection_InvokeNativeDelegateTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 23, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_InvokeNativeDelegateTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_InvokeNativeDelegateStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 24, 10, "Jscript_Projection_InvokeNativeDelegate", Jscript_Projection_InvokeNativeDelegateTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 24, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_InvokeNativeDelegateTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_AddEventListenerStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 25, 11, "Jscript_Projection_AddEventListener", Jscript_Projection_AddEventListenerTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 25, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_AddEventListenerTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_AddEventListenerStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 26, 11, "Jscript_Projection_AddEventListener", Jscript_Projection_AddEventListenerTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 26, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_AddEventListenerTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_RemoveEventListenerStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 27, 12, "Jscript_Projection_RemoveEventListener", Jscript_Projection_RemoveEventListenerTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 27, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_RemoveEventListenerTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndMethodNameTraceData> Jscript_Projection_RemoveEventListenerStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndMethodNameTraceData(value, 28, 12, "Jscript_Projection_RemoveEventListener", Jscript_Projection_RemoveEventListenerTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 28, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_RemoveEventListenerTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetTypeMetaDataInformationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 29, 13, "Jscript_Projection_GetTypeMetaDataInformation", Jscript_Projection_GetTypeMetaDataInformationTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 29, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_GetTypeMetaDataInformationTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetTypeMetaDataInformationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 30, 13, "Jscript_Projection_GetTypeMetaDataInformation", Jscript_Projection_GetTypeMetaDataInformationTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 30, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_GetTypeMetaDataInformationTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndEventNameTraceData> Jscript_Projection_SetEventHandlerStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndEventNameTraceData(value, 31, 14, "Jscript_Projection_SetEventHandler", Jscript_Projection_SetEventHandlerTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 31, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_SetEventHandlerTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndEventNameTraceData> Jscript_Projection_SetEventHandlerStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndEventNameTraceData(value, 32, 14, "Jscript_Projection_SetEventHandler", Jscript_Projection_SetEventHandlerTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 32, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_SetEventHandlerTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_RemoveAllEventsAndEventHandlersStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 33, 15, "Jscript_Projection_RemoveAllEventsAndEventHandlers", Jscript_Projection_RemoveAllEventsAndEventHandlersTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 33, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_RemoveAllEventsAndEventHandlersTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_RemoveAllEventsAndEventHandlersStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 34, 15, "Jscript_Projection_RemoveAllEventsAndEventHandlers", Jscript_Projection_RemoveAllEventsAndEventHandlersTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 34, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_RemoveAllEventsAndEventHandlersTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndEventNameTraceData> Jscript_Projection_InvokeEventStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndEventNameTraceData(value, 35, 16, "Jscript_Projection_InvokeEvent", Jscript_Projection_InvokeEventTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 35, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_InvokeEventTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndEventNameTraceData> Jscript_Projection_InvokeEventStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndEventNameTraceData(value, 36, 16, "Jscript_Projection_InvokeEvent", Jscript_Projection_InvokeEventTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 36, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_InvokeEventTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndEventNameTraceData> Jscript_Projection_InvokeEventEvParamPrepStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndEventNameTraceData(value, 37, 17, "Jscript_Projection_InvokeEventEvParamPrep", Jscript_Projection_InvokeEventEvParamPrepTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 37, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_InvokeEventEvParamPrepTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameAndEventNameTraceData> Jscript_Projection_InvokeEventEvParamPrepStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameAndEventNameTraceData(value, 38, 17, "Jscript_Projection_InvokeEventEvParamPrep", Jscript_Projection_InvokeEventEvParamPrepTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 38, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_InvokeEventEvParamPrepTaskGuid);
            }
        }
        public event Action<SourceLoadUnloadTraceData> ScriptContextRundownSourceDCStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SourceLoadUnloadTraceData(value, 39, 4, "ScriptContextRundown", new Guid(), 12, "SourceDCStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 39, ProviderGuid);
            }
        }
        public event Action<SourceLoadUnloadTraceData> ScriptContextRundownSourceDCStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SourceLoadUnloadTraceData(value, 40, 4, "ScriptContextRundown", new Guid(), 13, "SourceDCStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 40, ProviderGuid);
            }
        }
        public event Action<SourceLoadUnloadTraceData> ScriptContextRuntimeSourceLoad
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SourceLoadUnloadTraceData(value, 41, 2, "ScriptContextRuntime", new Guid(), 12, "SourceLoad", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 41, ProviderGuid);
            }
        }
        public event Action<SourceLoadUnloadTraceData> ScriptContextRuntimeSourceUnload
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SourceLoadUnloadTraceData(value, 42, 2, "ScriptContextRuntime", new Guid(), 13, "SourceUnload", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 42, ProviderGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetExprFromConcreteTypeNameStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 43, 18, "Jscript_Projection_GetExprFromConcreteTypeName", Jscript_Projection_GetExprFromConcreteTypeNameTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 43, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_GetExprFromConcreteTypeNameTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetExprFromConcreteTypeNameStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 44, 18, "Jscript_Projection_GetExprFromConcreteTypeName", Jscript_Projection_GetExprFromConcreteTypeNameTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 44, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_GetExprFromConcreteTypeNameTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetTypeFromTypeNamePartsStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 45, 19, "Jscript_Projection_GetTypeFromTypeNameParts", Jscript_Projection_GetTypeFromTypeNamePartsTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 45, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_GetTypeFromTypeNamePartsTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetTypeFromTypeNamePartsStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 46, 19, "Jscript_Projection_GetTypeFromTypeNameParts", Jscript_Projection_GetTypeFromTypeNamePartsTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 46, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_GetTypeFromTypeNamePartsTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_ReferenceOrArrayGetValueStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 47, 20, "Jscript_Projection_ReferenceOrArrayGetValue", Jscript_Projection_ReferenceOrArrayGetValueTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 47, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_ReferenceOrArrayGetValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_ReferenceOrArrayGetValueStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 48, 20, "Jscript_Projection_ReferenceOrArrayGetValue", Jscript_Projection_ReferenceOrArrayGetValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 48, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_ReferenceOrArrayGetValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_PropertyValueVarFromGRCNStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 49, 21, "Jscript_Projection_PropertyValueVarFromGRCN", Jscript_Projection_PropertyValueVarFromGRCNTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 49, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_PropertyValueVarFromGRCNTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_PropertyValueVarFromGRCNStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 50, 21, "Jscript_Projection_PropertyValueVarFromGRCN", Jscript_Projection_PropertyValueVarFromGRCNTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 50, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_PropertyValueVarFromGRCNTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_VarFromGRCNStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 51, 22, "Jscript_Projection_VarFromGRCN", Jscript_Projection_VarFromGRCNTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 51, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_VarFromGRCNTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_VarFromGRCNStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 52, 22, "Jscript_Projection_VarFromGRCN", Jscript_Projection_VarFromGRCNTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 52, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_VarFromGRCNTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_WriteIReferenceStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 53, 23, "Jscript_Projection_WriteIReference", Jscript_Projection_WriteIReferenceTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 53, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_WriteIReferenceTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_WriteIReferenceStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 54, 23, "Jscript_Projection_WriteIReference", Jscript_Projection_WriteIReferenceTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 54, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_WriteIReferenceTaskGuid);
            }
        }
        public event Action<ProjectionIsBoxedInterfaceTraceData> Jscript_Projection_WriteInspectableStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionIsBoxedInterfaceTraceData(value, 55, 24, "Jscript_Projection_WriteInspectable", Jscript_Projection_WriteInspectableTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 55, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_WriteInspectableTaskGuid);
            }
        }
        public event Action<ProjectionIsBoxedInterfaceTraceData> Jscript_Projection_WriteInspectableStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionIsBoxedInterfaceTraceData(value, 56, 24, "Jscript_Projection_WriteInspectable", Jscript_Projection_WriteInspectableTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 56, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_WriteInspectableTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetNonArrayTypeAsPropertyValueStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 57, 25, "Jscript_Projection_GetNonArrayTypeAsPropertyValue", Jscript_Projection_GetNonArrayTypeAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 57, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_GetNonArrayTypeAsPropertyValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetNonArrayTypeAsPropertyValueStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 58, 25, "Jscript_Projection_GetNonArrayTypeAsPropertyValue", Jscript_Projection_GetNonArrayTypeAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 58, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_GetNonArrayTypeAsPropertyValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 59, 26, "Jscript_Projection_GetNonArrayBasicTypeAsPropertyValue", Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 59, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 60, 26, "Jscript_Projection_GetNonArrayBasicTypeAsPropertyValue", Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 60, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetTypedArrayAsPropertyValueStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 61, 27, "Jscript_Projection_GetTypedArrayAsPropertyValue", Jscript_Projection_GetTypedArrayAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 61, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_GetTypedArrayAsPropertyValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetTypedArrayAsPropertyValueStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 62, 27, "Jscript_Projection_GetTypedArrayAsPropertyValue", Jscript_Projection_GetTypedArrayAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 62, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_GetTypedArrayAsPropertyValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetBasicTypedArrayAsPropertyValueStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 63, 28, "Jscript_Projection_GetBasicTypedArrayAsPropertyValue", Jscript_Projection_GetBasicTypedArrayAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 63, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_Projection_GetBasicTypedArrayAsPropertyValueTaskGuid);
            }
        }
        public event Action<ProjectionTypeNameTraceData> Jscript_Projection_GetBasicTypedArrayAsPropertyValueStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProjectionTypeNameTraceData(value, 64, 28, "Jscript_Projection_GetBasicTypedArrayAsPropertyValue", Jscript_Projection_GetBasicTypedArrayAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 64, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_Projection_GetBasicTypedArrayAsPropertyValueTaskGuid);
            }
        }
        public event Action<ParseStartStopTraceData> ParseMethodStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ParseStartStopTraceData(value, 65, 30, "ParseMethod", new Guid(), 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 65, ProviderGuid);
            }
        }
        public event Action<ParseStartStopTraceData> ParseMethodStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ParseStartStopTraceData(value, 66, 30, "ParseMethod", new Guid(), 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 66, ProviderGuid);
            }
        }
        public event Action<BytecodeGenInfoTraceData> GenerateBytecodeMethod
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new BytecodeGenInfoTraceData(value, 67, 29, "GenerateBytecodeMethod", new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 67, ProviderGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ResetMarksStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 68, 31, "Jscript_GC_ResetMarks", Jscript_GC_ResetMarksTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 68, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_ResetMarksTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ResetMarksStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 69, 31, "Jscript_GC_ResetMarks", Jscript_GC_ResetMarksTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 69, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_ResetMarksTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ScanRootsStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 70, 32, "Jscript_GC_ScanRoots", Jscript_GC_ScanRootsTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 70, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_ScanRootsTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ScanRootsStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 71, 32, "Jscript_GC_ScanRoots", Jscript_GC_ScanRootsTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 71, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_ScanRootsTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ScanStackStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 72, 33, "Jscript_GC_ScanStack", Jscript_GC_ScanStackTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 72, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_ScanStackTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ScanStackStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 73, 33, "Jscript_GC_ScanStack", Jscript_GC_ScanStackTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 73, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_ScanStackTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_MarkStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 74, 34, "Jscript_GC_Mark", Jscript_GC_MarkTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 74, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_MarkTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_MarkStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 75, 34, "Jscript_GC_Mark", Jscript_GC_MarkTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 75, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_MarkTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_RescanStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 76, 35, "Jscript_GC_Rescan", Jscript_GC_RescanTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 76, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_RescanTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_RescanStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 77, 35, "Jscript_GC_Rescan", Jscript_GC_RescanTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 77, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_RescanTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_SweepStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 78, 36, "Jscript_GC_Sweep", Jscript_GC_SweepTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 78, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_SweepTaskGuid);
            }
        }
        public event Action<GCPhaseCollectTraceData> Jscript_GC_SweepStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseCollectTraceData(value, 79, 36, "Jscript_GC_Sweep", Jscript_GC_SweepTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 79, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_SweepTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_SetupBackgroundSweepStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 80, 37, "Jscript_GC_SetupBackgroundSweep", Jscript_GC_SetupBackgroundSweepTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 80, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_SetupBackgroundSweepTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_BackgroundSweepStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 82, 38, "Jscript_GC_BackgroundSweep", Jscript_GC_BackgroundSweepTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 82, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_BackgroundSweepTaskGuid);
            }
        }
        public event Action<GCPhaseCollectTraceData> Jscript_GC_BackgroundSweepStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseCollectTraceData(value, 83, 38, "Jscript_GC_BackgroundSweep", Jscript_GC_BackgroundSweepTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 83, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_BackgroundSweepTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_TransferSweptObjectsStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 84, 39, "Jscript_GC_TransferSweptObjects", Jscript_GC_TransferSweptObjectsTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 84, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_TransferSweptObjectsTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_TransferSweptObjectsStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 85, 39, "Jscript_GC_TransferSweptObjects", Jscript_GC_TransferSweptObjectsTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 85, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_TransferSweptObjectsTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_DisposeStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 86, 40, "Jscript_GC_Dispose", Jscript_GC_DisposeTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 86, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_DisposeTaskGuid);
            }
        }
        public event Action<GCPhaseCollectTraceData> Jscript_GC_DisposeStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseCollectTraceData(value, 87, 40, "Jscript_GC_Dispose", Jscript_GC_DisposeTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 87, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_DisposeTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_BackgroundMarkStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 88, 41, "Jscript_GC_BackgroundMark", Jscript_GC_BackgroundMarkTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 88, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_BackgroundMarkTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_BackgroundMarkStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 89, 41, "Jscript_GC_BackgroundMark", Jscript_GC_BackgroundMarkTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 89, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_BackgroundMarkTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ResetWriteWatchStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 90, 42, "Jscript_GC_ResetWriteWatch", Jscript_GC_ResetWriteWatchTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 90, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_ResetWriteWatchTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_ResetWriteWatchStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 91, 42, "Jscript_GC_ResetWriteWatch", Jscript_GC_ResetWriteWatchTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 91, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_ResetWriteWatchTaskGuid);
            }
        }
        public event Action<ProfileSaveTraceData> Jscript_Profile_PersistenceSave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProfileSaveTraceData(value, 92, 43, "Jscript_Profile_Persistence", new Guid(), 16, "Save", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 92, ProviderGuid);
            }
        }
        public event Action<StartupCompleteTraceData> ScriptContextRuntimeScriptContextOnStartupComplete
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new StartupCompleteTraceData(value, 93, 2, "ScriptContextRuntime", new Guid(), 14, "ScriptContextOnStartupComplete", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 93, ProviderGuid);
            }
        }
        public event Action<ProfileLoadTraceData> Jscript_Profile_PersistenceLoad
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProfileLoadTraceData(value, 94, 43, "Jscript_Profile_Persistence", new Guid(), 15, "Load", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 94, ProviderGuid);
            }
        }
        public event Action<InlineInfoTraceData> Jscript_Backend_Inline
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new InlineInfoTraceData(value, 95, 44, "Jscript_Backend_Inline", new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 95, ProviderGuid);
            }
        }
        public event Action<JitMethodStartTraceData> Jscript_Method_JitStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JitMethodStartTraceData(value, 96, 45, "Jscript_Method_Jit", new Guid(), 17, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 96, ProviderGuid);
            }
        }
        public event Action<JitMethodStopTraceData> Jscript_Method_JitStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JitMethodStopTraceData(value, 97, 45, "Jscript_Method_Jit", new Guid(), 18, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 97, ProviderGuid);
            }
        }
        public event Action<JitMethodQueueDequeueTraceData> Jscript_Method_JitQueue
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JitMethodQueueDequeueTraceData(value, 98, 45, "Jscript_Method_Jit", new Guid(), 19, "Queue", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 98, ProviderGuid);
            }
        }
        public event Action<JitMethodQueueDequeueTraceData> Jscript_Method_JitDequeue
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JitMethodQueueDequeueTraceData(value, 99, 45, "Jscript_Method_Jit", new Guid(), 20, "Dequeue", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 99, ProviderGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_IdleCollectStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 100, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 100, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, Jscript_GC_IdleCollectTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_IdleCollectCallbackFinish
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 101, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 0, "CallbackFinish", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 101, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, Jscript_GC_IdleCollectTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_IdleCollectScheduled
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 102, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 0, "Scheduled", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 102, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, Jscript_GC_IdleCollectTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_IdleCollectFinished
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 103, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 0, "Finished", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 103, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, Jscript_GC_IdleCollectTaskGuid);
            }
        }
        public event Action<GCPhaseTraceData> Jscript_GC_IdleCollectStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new GCPhaseTraceData(value, 104, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 104, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, Jscript_GC_IdleCollectTaskGuid);
            }
        }
        public event Action<JscriptSizeInBytesTraceData> Jscript_Page_Allocator_SizeUsedPageSize
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptSizeInBytesTraceData(value, 105, 47, "Jscript_Page_Allocator_Size", Jscript_Page_Allocator_SizeTaskGuid, 10, "UsedPageSize", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 105, ProviderGuid);
                source.UnregisterEventTemplate(value, 10, Jscript_Page_Allocator_SizeTaskGuid);
            }
        }
        public event Action<JscriptRecyclerFreeTraceData> Jscript_Recycler_AllocationFree_Memory
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptRecyclerFreeTraceData(value, 106, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 10, "Free_Memory", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 106, ProviderGuid);
                source.UnregisterEventTemplate(value, 10, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptRecyclerFreeBlockTraceData> Jscript_Recycler_AllocationFree_Memory_Block
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptRecyclerFreeBlockTraceData(value, 107, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 11, "Free_Memory_Block", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 107, ProviderGuid);
                source.UnregisterEventTemplate(value, 11, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptAllocationTraceData> Jscript_Recycler_AllocationAllocate_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptAllocationTraceData(value, 108, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 12, "Allocate_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 108, ProviderGuid);
                source.UnregisterEventTemplate(value, 12, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptAllocationTraceData> Jscript_Recycler_AllocationAllocate_Array
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptAllocationTraceData(value, 109, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 13, "Allocate_Array", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 109, ProviderGuid);
                source.UnregisterEventTemplate(value, 13, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptAllocateFunctionTraceData> Jscript_Recycler_AllocationAllocate_Function
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptAllocateFunctionTraceData(value, 110, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 14, "Allocate_Function", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 110, ProviderGuid);
                source.UnregisterEventTemplate(value, 14, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptDOMAllocationTraceData> Jscript_Recycler_AllocationAllocate_DOM_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptDOMAllocationTraceData(value, 111, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 15, "Allocate_DOM_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 111, ProviderGuid);
                source.UnregisterEventTemplate(value, 15, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JScriptWinRTObjectAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_JSProxy_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JScriptWinRTObjectAllocationTraceData(value, 112, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 16, "Allocate_WinRT_JSProxy_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 112, ProviderGuid);
                source.UnregisterEventTemplate(value, 16, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptAllocationTraceData> Jscript_Recycler_AllocationAllocate_PixelArray
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptAllocationTraceData(value, 113, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 17, "Allocate_PixelArray", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 113, ProviderGuid);
                source.UnregisterEventTemplate(value, 17, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptAllocationTraceData> Jscript_Recycler_AllocationExternal_AddRef
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptAllocationTraceData(value, 114, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 18, "External_AddRef", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 114, ProviderGuid);
                source.UnregisterEventTemplate(value, 18, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptAllocationTraceData> Jscript_Recycler_AllocationExternal_Release
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptAllocationTraceData(value, 115, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 19, "External_Release", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 115, ProviderGuid);
                source.UnregisterEventTemplate(value, 19, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JScriptWinRTObjectAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_RuntimeClass_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JScriptWinRTObjectAllocationTraceData(value, 116, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 20, "Allocate_WinRT_RuntimeClass_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 116, ProviderGuid);
                source.UnregisterEventTemplate(value, 20, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JScriptWinRTObjectAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_Namespace_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JScriptWinRTObjectAllocationTraceData(value, 117, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 21, "Allocate_WinRT_Namespace_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 117, ProviderGuid);
                source.UnregisterEventTemplate(value, 21, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JScriptWinRTObjectAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_Struct_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JScriptWinRTObjectAllocationTraceData(value, 118, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 22, "Allocate_WinRT_Struct_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 118, ProviderGuid);
                source.UnregisterEventTemplate(value, 22, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JScriptWinRTObjectAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_Enum_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JScriptWinRTObjectAllocationTraceData(value, 119, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 23, "Allocate_WinRT_Enum_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 119, ProviderGuid);
                source.UnregisterEventTemplate(value, 23, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JScriptWinRTObjectAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_TypedArray_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JScriptWinRTObjectAllocationTraceData(value, 120, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 24, "Allocate_WinRT_TypedArray_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 120, ProviderGuid);
                source.UnregisterEventTemplate(value, 24, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTWrapperAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_Delegate_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTWrapperAllocationTraceData(value, 121, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 25, "Allocate_WinRT_Delegate_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 121, ProviderGuid);
                source.UnregisterEventTemplate(value, 25, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTEventHandlerAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_EventHandler_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTEventHandlerAllocationTraceData(value, 122, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 26, "Allocate_WinRT_EventHandler_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 122, ProviderGuid);
                source.UnregisterEventTemplate(value, 26, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTWrapperAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_Collections_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTWrapperAllocationTraceData(value, 123, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 27, "Allocate_WinRT_Collections_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 123, ProviderGuid);
                source.UnregisterEventTemplate(value, 27, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTPropertyValueAllocationTraceData> Jscript_Recycler_AllocationAllocate_WinRT_PropertyValue_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTPropertyValueAllocationTraceData(value, 124, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 28, "Allocate_WinRT_PropertyValue_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 124, ProviderGuid);
                source.UnregisterEventTemplate(value, 28, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTWrapperFreeTraceData> Jscript_Recycler_AllocationFree_WinRT_Delegate_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTWrapperFreeTraceData(value, 125, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 29, "Free_WinRT_Delegate_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 125, ProviderGuid);
                source.UnregisterEventTemplate(value, 29, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTWrapperFreeTraceData> Jscript_Recycler_AllocationFree_WinRT_EventHandler_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTWrapperFreeTraceData(value, 126, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 30, "Free_WinRT_EventHandler_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 126, ProviderGuid);
                source.UnregisterEventTemplate(value, 30, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTWrapperFreeTraceData> Jscript_Recycler_AllocationFree_WinRT_Collections_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTWrapperFreeTraceData(value, 127, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 31, "Free_WinRT_Collections_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 127, ProviderGuid);
                source.UnregisterEventTemplate(value, 31, Jscript_Recycler_AllocationTaskGuid);
            }
        }
        public event Action<JscriptWinRTWrapperFreeTraceData> Jscript_Recycler_AllocationFree_WinRT_PropertyValue_Object
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new JscriptWinRTWrapperFreeTraceData(value, 128, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 32, "Free_WinRT_PropertyValue_Object", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 128, ProviderGuid);
                source.UnregisterEventTemplate(value, 32, Jscript_Recycler_AllocationTaskGuid);
            }
        }

        #region private
        protected override string GetProviderName() { return ProviderName; }
#if !PERFVIEW 
        static private volatile TraceEvent[] s_templates;
#endif
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            // TODO FIX NOW.   We don't actually register any templates here because we know we are out of date (this file needs to be refreshed)
            // In the mean time, we would rather fall back to the TDH registered templates instead since they will be more up to date.  
            // However because of this, if you want to programatically get all JScript events, you have to use the RegisteredTraceEventParser as well
            // and you won't get back the C# classes.   Thus this is OK for PerfView but not good for general usage.   
#if !PERFVIEW 
            if (s_templates == null)
            {
                var templates = new TraceEvent[127];
                templates[0] = new EmptyTraceData(null, 1, 3, "MethodRundown", new Guid(), 14, "DCStartInit", ProviderGuid, ProviderName);
                templates[1] = new EmptyTraceData(null, 2, 3, "MethodRundown", new Guid(), 12, "DCStartComplete", ProviderGuid, ProviderName);
                templates[2] = new EmptyTraceData(null, 3, 3, "MethodRundown", new Guid(), 15, "DCStopInit", ProviderGuid, ProviderName);
                templates[3] = new EmptyTraceData(null, 4, 3, "MethodRundown", new Guid(), 13, "DCStopComplete", ProviderGuid, ProviderName);
                templates[4] = new MethodLoadUnloadJSTraceData(null, 5, 3, "MethodRundown", new Guid(), 10, "MethodDCStart", ProviderGuid, ProviderName);
                templates[5] = new MethodLoadUnloadJSTraceData(null, 6, 3, "MethodRundown", new Guid(), 11, "MethodDCStop", ProviderGuid, ProviderName);
                templates[6] = new ScriptContextLoadUnloadTraceData(null, 7, 4, "ScriptContextRundown", new Guid(), 10, "ScriptContextDCStart", ProviderGuid, ProviderName);
                templates[7] = new ScriptContextLoadUnloadTraceData(null, 8, 4, "ScriptContextRundown", new Guid(), 11, "ScriptContextDCStop", ProviderGuid, ProviderName);
                templates[8] = new MethodLoadUnloadJSTraceData(null, 9, 1, "MethodRuntime", new Guid(), 10, "MethodLoad", ProviderGuid, ProviderName);
                templates[9] = new MethodLoadUnloadJSTraceData(null, 10, 1, "MethodRuntime", new Guid(), 11, "MethodUnload", ProviderGuid, ProviderName);
                templates[10] = new ScriptContextLoadUnloadTraceData(null, 11, 2, "ScriptContextRuntime", new Guid(), 10, "ScriptContextLoad", ProviderGuid, ProviderName);
                templates[11] = new ScriptContextLoadUnloadTraceData(null, 12, 2, "ScriptContextRuntime", new Guid(), 11, "ScriptContextUnload", ProviderGuid, ProviderName);
                templates[12] = new ProjectionTypeNameTraceData(null, 13, 5, "Jscript_Projection_ResolveType", Jscript_Projection_ResolveTypeTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[13] = new ProjectionTypeNameTraceData(null, 14, 5, "Jscript_Projection_ResolveType", Jscript_Projection_ResolveTypeTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[14] = new ProjectionTypeNameTraceData(null, 15, 6, "Jscript_Projection_ConstructRuntimeClass", Jscript_Projection_ConstructRuntimeClassTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[15] = new ProjectionTypeNameTraceData(null, 16, 6, "Jscript_Projection_ConstructRuntimeClass", Jscript_Projection_ConstructRuntimeClassTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[16] = new ProjectionTypeNameAndMethodNameTraceData(null, 17, 7, "Jscript_Projection_MethodCall", Jscript_Projection_MethodCallTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[17] = new ProjectionTypeNameAndMethodNameTraceData(null, 18, 7, "Jscript_Projection_MethodCall", Jscript_Projection_MethodCallTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[18] = new ProjectionTypeNameAndMethodNameTraceData(null, 19, 8, "Jscript_Projection_RawMethodCall", Jscript_Projection_RawMethodCallTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[19] = new ProjectionTypeNameAndMethodNameTraceData(null, 20, 8, "Jscript_Projection_RawMethodCall", Jscript_Projection_RawMethodCallTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[20] = new ProjectionTypeNameAndMethodNameTraceData(null, 21, 9, "Jscript_Projection_InvokesJsDelegate", Jscript_Projection_InvokesJsDelegateTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[21] = new ProjectionTypeNameAndMethodNameTraceData(null, 22, 9, "Jscript_Projection_InvokesJsDelegate", Jscript_Projection_InvokesJsDelegateTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[22] = new ProjectionTypeNameAndMethodNameTraceData(null, 23, 10, "Jscript_Projection_InvokeNativeDelegate", Jscript_Projection_InvokeNativeDelegateTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[23] = new ProjectionTypeNameAndMethodNameTraceData(null, 24, 10, "Jscript_Projection_InvokeNativeDelegate", Jscript_Projection_InvokeNativeDelegateTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[24] = new ProjectionTypeNameAndMethodNameTraceData(null, 25, 11, "Jscript_Projection_AddEventListener", Jscript_Projection_AddEventListenerTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[25] = new ProjectionTypeNameAndMethodNameTraceData(null, 26, 11, "Jscript_Projection_AddEventListener", Jscript_Projection_AddEventListenerTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[26] = new ProjectionTypeNameAndMethodNameTraceData(null, 27, 12, "Jscript_Projection_RemoveEventListener", Jscript_Projection_RemoveEventListenerTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[27] = new ProjectionTypeNameAndMethodNameTraceData(null, 28, 12, "Jscript_Projection_RemoveEventListener", Jscript_Projection_RemoveEventListenerTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[28] = new ProjectionTypeNameTraceData(null, 29, 13, "Jscript_Projection_GetTypeMetaDataInformation", Jscript_Projection_GetTypeMetaDataInformationTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[29] = new ProjectionTypeNameTraceData(null, 30, 13, "Jscript_Projection_GetTypeMetaDataInformation", Jscript_Projection_GetTypeMetaDataInformationTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[30] = new ProjectionTypeNameAndEventNameTraceData(null, 31, 14, "Jscript_Projection_SetEventHandler", Jscript_Projection_SetEventHandlerTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[31] = new ProjectionTypeNameAndEventNameTraceData(null, 32, 14, "Jscript_Projection_SetEventHandler", Jscript_Projection_SetEventHandlerTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[32] = new ProjectionTypeNameTraceData(null, 33, 15, "Jscript_Projection_RemoveAllEventsAndEventHandlers", Jscript_Projection_RemoveAllEventsAndEventHandlersTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[33] = new ProjectionTypeNameTraceData(null, 34, 15, "Jscript_Projection_RemoveAllEventsAndEventHandlers", Jscript_Projection_RemoveAllEventsAndEventHandlersTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[34] = new ProjectionTypeNameAndEventNameTraceData(null, 35, 16, "Jscript_Projection_InvokeEvent", Jscript_Projection_InvokeEventTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[35] = new ProjectionTypeNameAndEventNameTraceData(null, 36, 16, "Jscript_Projection_InvokeEvent", Jscript_Projection_InvokeEventTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[36] = new ProjectionTypeNameAndEventNameTraceData(null, 37, 17, "Jscript_Projection_InvokeEventEvParamPrep", Jscript_Projection_InvokeEventEvParamPrepTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[37] = new ProjectionTypeNameAndEventNameTraceData(null, 38, 17, "Jscript_Projection_InvokeEventEvParamPrep", Jscript_Projection_InvokeEventEvParamPrepTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[38] = new SourceLoadUnloadTraceData(null, 39, 4, "ScriptContextRundown", new Guid(), 12, "SourceDCStart", ProviderGuid, ProviderName);
                templates[39] = new SourceLoadUnloadTraceData(null, 40, 4, "ScriptContextRundown", new Guid(), 13, "SourceDCStop", ProviderGuid, ProviderName);
                templates[40] = new SourceLoadUnloadTraceData(null, 41, 2, "ScriptContextRuntime", new Guid(), 12, "SourceLoad", ProviderGuid, ProviderName);
                templates[41] = new SourceLoadUnloadTraceData(null, 42, 2, "ScriptContextRuntime", new Guid(), 13, "SourceUnload", ProviderGuid, ProviderName);
                templates[42] = new ProjectionTypeNameTraceData(null, 43, 18, "Jscript_Projection_GetExprFromConcreteTypeName", Jscript_Projection_GetExprFromConcreteTypeNameTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[43] = new ProjectionTypeNameTraceData(null, 44, 18, "Jscript_Projection_GetExprFromConcreteTypeName", Jscript_Projection_GetExprFromConcreteTypeNameTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[44] = new ProjectionTypeNameTraceData(null, 45, 19, "Jscript_Projection_GetTypeFromTypeNameParts", Jscript_Projection_GetTypeFromTypeNamePartsTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[45] = new ProjectionTypeNameTraceData(null, 46, 19, "Jscript_Projection_GetTypeFromTypeNameParts", Jscript_Projection_GetTypeFromTypeNamePartsTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[46] = new ProjectionTypeNameTraceData(null, 47, 20, "Jscript_Projection_ReferenceOrArrayGetValue", Jscript_Projection_ReferenceOrArrayGetValueTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[47] = new ProjectionTypeNameTraceData(null, 48, 20, "Jscript_Projection_ReferenceOrArrayGetValue", Jscript_Projection_ReferenceOrArrayGetValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[48] = new ProjectionTypeNameTraceData(null, 49, 21, "Jscript_Projection_PropertyValueVarFromGRCN", Jscript_Projection_PropertyValueVarFromGRCNTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[49] = new ProjectionTypeNameTraceData(null, 50, 21, "Jscript_Projection_PropertyValueVarFromGRCN", Jscript_Projection_PropertyValueVarFromGRCNTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[50] = new ProjectionTypeNameTraceData(null, 51, 22, "Jscript_Projection_VarFromGRCN", Jscript_Projection_VarFromGRCNTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[51] = new ProjectionTypeNameTraceData(null, 52, 22, "Jscript_Projection_VarFromGRCN", Jscript_Projection_VarFromGRCNTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[52] = new ProjectionTypeNameTraceData(null, 53, 23, "Jscript_Projection_WriteIReference", Jscript_Projection_WriteIReferenceTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[53] = new ProjectionTypeNameTraceData(null, 54, 23, "Jscript_Projection_WriteIReference", Jscript_Projection_WriteIReferenceTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[54] = new ProjectionIsBoxedInterfaceTraceData(null, 55, 24, "Jscript_Projection_WriteInspectable", Jscript_Projection_WriteInspectableTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[55] = new ProjectionIsBoxedInterfaceTraceData(null, 56, 24, "Jscript_Projection_WriteInspectable", Jscript_Projection_WriteInspectableTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[56] = new ProjectionTypeNameTraceData(null, 57, 25, "Jscript_Projection_GetNonArrayTypeAsPropertyValue", Jscript_Projection_GetNonArrayTypeAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[57] = new ProjectionTypeNameTraceData(null, 58, 25, "Jscript_Projection_GetNonArrayTypeAsPropertyValue", Jscript_Projection_GetNonArrayTypeAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[58] = new ProjectionTypeNameTraceData(null, 59, 26, "Jscript_Projection_GetNonArrayBasicTypeAsPropertyValue", Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[59] = new ProjectionTypeNameTraceData(null, 60, 26, "Jscript_Projection_GetNonArrayBasicTypeAsPropertyValue", Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[60] = new ProjectionTypeNameTraceData(null, 61, 27, "Jscript_Projection_GetTypedArrayAsPropertyValue", Jscript_Projection_GetTypedArrayAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[61] = new ProjectionTypeNameTraceData(null, 62, 27, "Jscript_Projection_GetTypedArrayAsPropertyValue", Jscript_Projection_GetTypedArrayAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[62] = new ProjectionTypeNameTraceData(null, 63, 28, "Jscript_Projection_GetBasicTypedArrayAsPropertyValue", Jscript_Projection_GetBasicTypedArrayAsPropertyValueTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[63] = new ProjectionTypeNameTraceData(null, 64, 28, "Jscript_Projection_GetBasicTypedArrayAsPropertyValue", Jscript_Projection_GetBasicTypedArrayAsPropertyValueTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[64] = new ParseStartStopTraceData(null, 65, 30, "ParseMethod", new Guid(), 1, "Start", ProviderGuid, ProviderName);
                templates[65] = new ParseStartStopTraceData(null, 66, 30, "ParseMethod", new Guid(), 2, "Stop", ProviderGuid, ProviderName);
                templates[66] = new BytecodeGenInfoTraceData(null, 67, 29, "GenerateBytecodeMethod", new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[67] = new GCPhaseTraceData(null, 68, 31, "Jscript_GC_ResetMarks", Jscript_GC_ResetMarksTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[68] = new GCPhaseTraceData(null, 69, 31, "Jscript_GC_ResetMarks", Jscript_GC_ResetMarksTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[69] = new GCPhaseTraceData(null, 70, 32, "Jscript_GC_ScanRoots", Jscript_GC_ScanRootsTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[70] = new GCPhaseTraceData(null, 71, 32, "Jscript_GC_ScanRoots", Jscript_GC_ScanRootsTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[71] = new GCPhaseTraceData(null, 72, 33, "Jscript_GC_ScanStack", Jscript_GC_ScanStackTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[72] = new GCPhaseTraceData(null, 73, 33, "Jscript_GC_ScanStack", Jscript_GC_ScanStackTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[73] = new GCPhaseTraceData(null, 74, 34, "Jscript_GC_Mark", Jscript_GC_MarkTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[74] = new GCPhaseTraceData(null, 75, 34, "Jscript_GC_Mark", Jscript_GC_MarkTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[75] = new GCPhaseTraceData(null, 76, 35, "Jscript_GC_Rescan", Jscript_GC_RescanTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[76] = new GCPhaseTraceData(null, 77, 35, "Jscript_GC_Rescan", Jscript_GC_RescanTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[77] = new GCPhaseTraceData(null, 78, 36, "Jscript_GC_Sweep", Jscript_GC_SweepTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[78] = new GCPhaseCollectTraceData(null, 79, 36, "Jscript_GC_Sweep", Jscript_GC_SweepTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[79] = new GCPhaseTraceData(null, 80, 37, "Jscript_GC_SetupBackgroundSweep", Jscript_GC_SetupBackgroundSweepTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[80] = new GCPhaseTraceData(null, 82, 38, "Jscript_GC_BackgroundSweep", Jscript_GC_BackgroundSweepTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[81] = new GCPhaseCollectTraceData(null, 83, 38, "Jscript_GC_BackgroundSweep", Jscript_GC_BackgroundSweepTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[82] = new GCPhaseTraceData(null, 84, 39, "Jscript_GC_TransferSweptObjects", Jscript_GC_TransferSweptObjectsTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[83] = new GCPhaseTraceData(null, 85, 39, "Jscript_GC_TransferSweptObjects", Jscript_GC_TransferSweptObjectsTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[84] = new GCPhaseTraceData(null, 86, 40, "Jscript_GC_Dispose", Jscript_GC_DisposeTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[85] = new GCPhaseCollectTraceData(null, 87, 40, "Jscript_GC_Dispose", Jscript_GC_DisposeTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[86] = new GCPhaseTraceData(null, 88, 41, "Jscript_GC_BackgroundMark", Jscript_GC_BackgroundMarkTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[87] = new GCPhaseTraceData(null, 89, 41, "Jscript_GC_BackgroundMark", Jscript_GC_BackgroundMarkTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[88] = new GCPhaseTraceData(null, 90, 42, "Jscript_GC_ResetWriteWatch", Jscript_GC_ResetWriteWatchTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[89] = new GCPhaseTraceData(null, 91, 42, "Jscript_GC_ResetWriteWatch", Jscript_GC_ResetWriteWatchTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[90] = new ProfileSaveTraceData(null, 92, 43, "Jscript_Profile_Persistence", new Guid(), 16, "Save", ProviderGuid, ProviderName);
                templates[91] = new StartupCompleteTraceData(null, 93, 2, "ScriptContextRuntime", new Guid(), 14, "ScriptContextOnStartupComplete", ProviderGuid, ProviderName);
                templates[92] = new ProfileLoadTraceData(null, 94, 43, "Jscript_Profile_Persistence", new Guid(), 15, "Load", ProviderGuid, ProviderName);
                templates[93] = new InlineInfoTraceData(null, 95, 44, "Jscript_Backend_Inline", new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[94] = new JitMethodStartTraceData(null, 96, 45, "Jscript_Method_Jit", new Guid(), 17, "Start", ProviderGuid, ProviderName);
                templates[95] = new JitMethodStopTraceData(null, 97, 45, "Jscript_Method_Jit", new Guid(), 18, "Stop", ProviderGuid, ProviderName);
                templates[96] = new JitMethodQueueDequeueTraceData(null, 98, 45, "Jscript_Method_Jit", new Guid(), 19, "Queue", ProviderGuid, ProviderName);
                templates[97] = new JitMethodQueueDequeueTraceData(null, 99, 45, "Jscript_Method_Jit", new Guid(), 20, "Dequeue", ProviderGuid, ProviderName);
                templates[98] = new GCPhaseTraceData(null, 100, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[99] = new GCPhaseTraceData(null, 101, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 0, "CallbackFinish", ProviderGuid, ProviderName);
                templates[100] = new GCPhaseTraceData(null, 102, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 0, "Scheduled", ProviderGuid, ProviderName);
                templates[101] = new GCPhaseTraceData(null, 103, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 0, "Finished", ProviderGuid, ProviderName);
                templates[102] = new GCPhaseTraceData(null, 104, 46, "Jscript_GC_IdleCollect", Jscript_GC_IdleCollectTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[103] = new JscriptSizeInBytesTraceData(null, 105, 47, "Jscript_Page_Allocator_Size", Jscript_Page_Allocator_SizeTaskGuid, 10, "UsedPageSize", ProviderGuid, ProviderName);
                templates[104] = new JscriptRecyclerFreeTraceData(null, 106, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 10, "Free_Memory", ProviderGuid, ProviderName);
                templates[105] = new JscriptRecyclerFreeBlockTraceData(null, 107, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 11, "Free_Memory_Block", ProviderGuid, ProviderName);
                templates[106] = new JscriptAllocationTraceData(null, 108, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 12, "Allocate_Object", ProviderGuid, ProviderName);
                templates[107] = new JscriptAllocationTraceData(null, 109, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 13, "Allocate_Array", ProviderGuid, ProviderName);
                templates[108] = new JscriptAllocateFunctionTraceData(null, 110, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 14, "Allocate_Function", ProviderGuid, ProviderName);
                templates[109] = new JscriptDOMAllocationTraceData(null, 111, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 15, "Allocate_DOM_Object", ProviderGuid, ProviderName);
                templates[110] = new JScriptWinRTObjectAllocationTraceData(null, 112, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 16, "Allocate_WinRT_JSProxy_Object", ProviderGuid, ProviderName);
                templates[111] = new JscriptAllocationTraceData(null, 113, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 17, "Allocate_PixelArray", ProviderGuid, ProviderName);
                templates[112] = new JscriptAllocationTraceData(null, 114, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 18, "External_AddRef", ProviderGuid, ProviderName);
                templates[113] = new JscriptAllocationTraceData(null, 115, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 19, "External_Release", ProviderGuid, ProviderName);
                templates[114] = new JScriptWinRTObjectAllocationTraceData(null, 116, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 20, "Allocate_WinRT_RuntimeClass_Object", ProviderGuid, ProviderName);
                templates[115] = new JScriptWinRTObjectAllocationTraceData(null, 117, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 21, "Allocate_WinRT_Namespace_Object", ProviderGuid, ProviderName);
                templates[116] = new JScriptWinRTObjectAllocationTraceData(null, 118, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 22, "Allocate_WinRT_Struct_Object", ProviderGuid, ProviderName);
                templates[117] = new JScriptWinRTObjectAllocationTraceData(null, 119, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 23, "Allocate_WinRT_Enum_Object", ProviderGuid, ProviderName);
                templates[118] = new JScriptWinRTObjectAllocationTraceData(null, 120, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 24, "Allocate_WinRT_TypedArray_Object", ProviderGuid, ProviderName);
                templates[119] = new JscriptWinRTWrapperAllocationTraceData(null, 121, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 25, "Allocate_WinRT_Delegate_Object", ProviderGuid, ProviderName);
                templates[120] = new JscriptWinRTEventHandlerAllocationTraceData(null, 122, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 26, "Allocate_WinRT_EventHandler_Object", ProviderGuid, ProviderName);
                templates[121] = new JscriptWinRTWrapperAllocationTraceData(null, 123, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 27, "Allocate_WinRT_Collections_Object", ProviderGuid, ProviderName);
                templates[122] = new JscriptWinRTPropertyValueAllocationTraceData(null, 124, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 28, "Allocate_WinRT_PropertyValue_Object", ProviderGuid, ProviderName);
                templates[123] = new JscriptWinRTWrapperFreeTraceData(null, 125, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 29, "Free_WinRT_Delegate_Object", ProviderGuid, ProviderName);
                templates[124] = new JscriptWinRTWrapperFreeTraceData(null, 126, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 30, "Free_WinRT_EventHandler_Object", ProviderGuid, ProviderName);
                templates[125] = new JscriptWinRTWrapperFreeTraceData(null, 127, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 31, "Free_WinRT_Collections_Object", ProviderGuid, ProviderName);
                templates[126] = new JscriptWinRTWrapperFreeTraceData(null, 128, 48, "Jscript_Recycler_Allocation", Jscript_Recycler_AllocationTaskGuid, 32, "Free_WinRT_PropertyValue_Object", ProviderGuid, ProviderName);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
#endif
        }

        private static readonly Guid Jscript_Projection_ResolveTypeTaskGuid = new Guid(unchecked((int)0x65e6ec90), unchecked((short)0x7758), unchecked((short)0x4fa8), 0xb8, 0x8a, 0x26, 0x11, 0x97, 0x15, 0x1e, 0x49);
        private static readonly Guid Jscript_Projection_ConstructRuntimeClassTaskGuid = new Guid(unchecked((int)0xfa44b46d), unchecked((short)0x38df), unchecked((short)0x4cc2), 0x0a, 0x76, 0x16, 0x7d, 0xe9, 0x8f, 0xa6, 0x21);
        private static readonly Guid Jscript_Projection_MethodCallTaskGuid = new Guid(unchecked((int)0xe044b46d), unchecked((short)0x38df), unchecked((short)0x4cc2), 0x0a, 0x76, 0x16, 0x7d, 0xe9, 0x8f, 0xb6, 0x61);
        private static readonly Guid Jscript_Projection_RawMethodCallTaskGuid = new Guid(unchecked((int)0xc944b46d), unchecked((short)0x38df), unchecked((short)0x4cc2), 0x0a, 0x86, 0x16, 0x7d, 0xe9, 0x8f, 0xa6, 0x21);
        private static readonly Guid Jscript_Projection_InvokesJsDelegateTaskGuid = new Guid(unchecked((int)0x9a94b47d), unchecked((short)0x8adf), unchecked((short)0x5dc2), 0x0a, 0x86, 0x16, 0x7d, 0xe9, 0x8f, 0xa6, 0x23);
        private static readonly Guid Jscript_Projection_InvokeNativeDelegateTaskGuid = new Guid(unchecked((int)0x9a94b47d), unchecked((short)0xfda8), unchecked((short)0x5dc2), 0x0a, 0x86, 0x16, 0x7d, 0xe9, 0x8f, 0xa6, 0x24);
        private static readonly Guid Jscript_Projection_AddEventListenerTaskGuid = new Guid(unchecked((int)0x9a9c947d), unchecked((short)0x8adf), unchecked((short)0x5dc2), 0x0a, 0x86, 0x16, 0x7d, 0xe9, 0x8f, 0xad, 0x23);
        private static readonly Guid Jscript_Projection_RemoveEventListenerTaskGuid = new Guid(unchecked((int)0xab9c947d), unchecked((short)0x8aef), unchecked((short)0x5dc2), 0x0a, 0x86, 0x16, 0x7d, 0xe9, 0x8f, 0xad, 0x02);
        private static readonly Guid Jscript_Projection_GetTypeMetaDataInformationTaskGuid = new Guid(unchecked((int)0x6d44b4fa), unchecked((short)0x38df), unchecked((short)0x4cc2), 0x0a, 0x76, 0x16, 0x7d, 0xe9, 0x8f, 0xa6, 0x31);
        private static readonly Guid Jscript_Projection_SetEventHandlerTaskGuid = new Guid(unchecked((int)0x4c42d2ac), unchecked((short)0x7b3e), unchecked((short)0x48ab), 0x91, 0xce, 0xc7, 0xe3, 0xff, 0xac, 0xf8, 0xbf);
        private static readonly Guid Jscript_Projection_RemoveAllEventsAndEventHandlersTaskGuid = new Guid(unchecked((int)0xb4fb623e), unchecked((short)0xa94c), unchecked((short)0x4226), 0xb0, 0xe4, 0xfc, 0x82, 0x53, 0xf2, 0x9d, 0xe5);
        private static readonly Guid Jscript_Projection_InvokeEventTaskGuid = new Guid(unchecked((int)0xf0c3c89f), unchecked((short)0xc1d3), unchecked((short)0x46e6), 0x85, 0x23, 0x2d, 0x4b, 0x71, 0xe2, 0x91, 0x94);
        private static readonly Guid Jscript_Projection_InvokeEventEvParamPrepTaskGuid = new Guid(unchecked((int)0x670b4b95), unchecked((short)0xbaf8), unchecked((short)0x42e1), 0xa1, 0xfd, 0xbf, 0xd4, 0x78, 0xcb, 0xf7, 0x20);
        private static readonly Guid Jscript_Projection_GetExprFromConcreteTypeNameTaskGuid = new Guid(unchecked((int)0x90df5cdf), unchecked((short)0x6eed), unchecked((short)0x47a4), 0xb6, 0x98, 0x54, 0x8c, 0x7a, 0xbf, 0x4f, 0xe9);
        private static readonly Guid Jscript_Projection_GetTypeFromTypeNamePartsTaskGuid = new Guid(unchecked((int)0x17395d83), unchecked((short)0x1e5c), unchecked((short)0x43ad), 0xa5, 0xd4, 0x41, 0x63, 0x1d, 0x33, 0x4f, 0x3c);
        private static readonly Guid Jscript_Projection_ReferenceOrArrayGetValueTaskGuid = new Guid(unchecked((int)0x97b5c7a6), unchecked((short)0x8cc5), unchecked((short)0x4e4d), 0xbb, 0x85, 0x38, 0x87, 0xed, 0x68, 0x73, 0x04);
        private static readonly Guid Jscript_Projection_PropertyValueVarFromGRCNTaskGuid = new Guid(unchecked((int)0x8a960840), unchecked((short)0x27ea), unchecked((short)0x487f), 0xb7, 0xc0, 0x7a, 0x6e, 0x87, 0x64, 0x56, 0x3e);
        private static readonly Guid Jscript_Projection_VarFromGRCNTaskGuid = new Guid(unchecked((int)0x9fcf06d2), unchecked((short)0x7907), unchecked((short)0x46b4), 0xa2, 0xe4, 0x4b, 0x56, 0x32, 0x94, 0x59, 0x65);
        private static readonly Guid Jscript_Projection_WriteIReferenceTaskGuid = new Guid(unchecked((int)0x1ebc5e72), unchecked((short)0x4c4a), unchecked((short)0x455e), 0xa9, 0xaa, 0x53, 0xc1, 0x1b, 0x32, 0xe3, 0xe1);
        private static readonly Guid Jscript_Projection_WriteInspectableTaskGuid = new Guid(unchecked((int)0x48b75069), unchecked((short)0xb48d), unchecked((short)0x404b), 0x95, 0x45, 0x92, 0x40, 0xb6, 0x9c, 0xb7, 0xf3);
        private static readonly Guid Jscript_Projection_GetNonArrayTypeAsPropertyValueTaskGuid = new Guid(unchecked((int)0x60990a40), unchecked((short)0x3dc5), unchecked((short)0x418e), 0x8c, 0x2e, 0x08, 0xe5, 0xfa, 0xde, 0x7f, 0x8d);
        private static readonly Guid Jscript_Projection_GetNonArrayBasicTypeAsPropertyValueTaskGuid = new Guid(unchecked((int)0x3d8fedce), unchecked((short)0xcf8e), unchecked((short)0x4d65), 0x8e, 0xb9, 0xbd, 0x1c, 0xbb, 0xc8, 0x90, 0xd5);
        private static readonly Guid Jscript_Projection_GetTypedArrayAsPropertyValueTaskGuid = new Guid(unchecked((int)0x1dc3ab0f), unchecked((short)0x3c64), unchecked((short)0x405a), 0x98, 0x52, 0x58, 0x95, 0xc1, 0x33, 0xf9, 0xa8);
        private static readonly Guid Jscript_Projection_GetBasicTypedArrayAsPropertyValueTaskGuid = new Guid(unchecked((int)0x4110d5bd), unchecked((short)0x5ff8), unchecked((short)0x4ff2), 0xa3, 0x3d, 0xd1, 0xb9, 0x2b, 0x12, 0x76, 0x06);
        private static readonly Guid Jscript_GC_ResetMarksTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xd4);
        private static readonly Guid Jscript_GC_ScanRootsTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xd5);
        private static readonly Guid Jscript_GC_ScanStackTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xd6);
        private static readonly Guid Jscript_GC_MarkTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xd7);
        private static readonly Guid Jscript_GC_RescanTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xd8);
        private static readonly Guid Jscript_GC_SweepTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xd9);
        private static readonly Guid Jscript_GC_SetupBackgroundSweepTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xda);
        private static readonly Guid Jscript_GC_BackgroundSweepTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xdb);
        private static readonly Guid Jscript_GC_TransferSweptObjectsTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xdc);
        private static readonly Guid Jscript_GC_DisposeTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xdd);
        private static readonly Guid Jscript_GC_BackgroundMarkTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xde);
        private static readonly Guid Jscript_GC_ResetWriteWatchTaskGuid = new Guid(unchecked((int)0x56aa7888), unchecked((short)0xcd74), unchecked((short)0x471f), 0xb4, 0x80, 0x25, 0xd2, 0x57, 0xce, 0xdc, 0xdf);
        private static readonly Guid Jscript_GC_IdleCollectTaskGuid = new Guid(unchecked((int)0x196a6ce6), unchecked((short)0x8826), unchecked((short)0x4d5f), 0x9b, 0x33, 0x55, 0xba, 0x2d, 0x3a, 0xcc, 0xbe);
        private static readonly Guid Jscript_Page_Allocator_SizeTaskGuid = new Guid(unchecked((int)0x313cb172), unchecked((short)0x9dd2), unchecked((short)0x4f8c), 0xa4, 0x1f, 0xba, 0xf7, 0x42, 0x64, 0x74, 0x90);
        private static readonly Guid Jscript_Recycler_AllocationTaskGuid = new Guid(unchecked((int)0x2d68a40e), unchecked((short)0xb890), unchecked((short)0x4c6f), 0x8c, 0x2e, 0xb4, 0xc8, 0x56, 0xcc, 0x21, 0xcf);
        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.JScript
{
    public sealed class MethodLoadUnloadJSTraceData : TraceEvent
    {
        public Address ScriptContextID { get { return GetAddressAt(0); } }
        public Address MethodStartAddress { get { return GetAddressAt(HostOffset(4, 1)); } }
        public long MethodSize { get { return GetInt64At(HostOffset(8, 2)); } }
        public int MethodID { get { return GetInt32At(HostOffset(16, 2)); } }
        public int MethodFlags { get { return GetInt16At(HostOffset(20, 2)); } }
        public MethodAddressRange MethodAddressRangeID { get { return (MethodAddressRange)GetInt16At(HostOffset(22, 2)); } }
        public long SourceID { get { return GetInt64At(HostOffset(24, 2)); } }
        public int Line { get { return GetInt32At(HostOffset(32, 2)); } }
        public int Column { get { return GetInt32At(HostOffset(36, 2)); } }
        public string MethodName { get { return GetUnicodeStringAt(HostOffset(40, 2)); } }

        #region Private
        internal MethodLoadUnloadJSTraceData(Action<MethodLoadUnloadJSTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<MethodLoadUnloadJSTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(40, 2))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(40, 2))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            XmlAttribHex(sb, "MethodStartAddress", MethodStartAddress);
            XmlAttrib(sb, "MethodSize", MethodSize);
            XmlAttrib(sb, "MethodID", MethodID);
            XmlAttrib(sb, "MethodFlags", MethodFlags);
            XmlAttrib(sb, "MethodAddressRangeID", MethodAddressRangeID);
            XmlAttrib(sb, "SourceID", SourceID);
            XmlAttrib(sb, "Line", Line);
            XmlAttrib(sb, "Column", Column);
            XmlAttrib(sb, "MethodName", MethodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ScriptContextID", "MethodStartAddress", "MethodSize", "MethodID", "MethodFlags", "MethodAddressRangeID", "SourceID", "Line", "Column", "MethodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ScriptContextID;
                case 1:
                    return MethodStartAddress;
                case 2:
                    return MethodSize;
                case 3:
                    return MethodID;
                case 4:
                    return MethodFlags;
                case 5:
                    return MethodAddressRangeID;
                case 6:
                    return SourceID;
                case 7:
                    return Line;
                case 8:
                    return Column;
                case 9:
                    return MethodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MethodLoadUnloadJSTraceData> Action;
        #endregion
    }
    public sealed class ScriptContextLoadUnloadTraceData : TraceEvent
    {
        public Address ScriptContextID { get { return GetAddressAt(0); } }

        #region Private
        internal ScriptContextLoadUnloadTraceData(Action<ScriptContextLoadUnloadTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ScriptContextLoadUnloadTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ScriptContextID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ScriptContextID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ScriptContextLoadUnloadTraceData> Action;
        #endregion
    }
    public sealed class ProjectionTypeNameTraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal ProjectionTypeNameTraceData(Action<ProjectionTypeNameTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ProjectionTypeNameTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProjectionTypeNameTraceData> Action;
        #endregion
    }
    public sealed class ProjectionTypeNameAndMethodNameTraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string MethodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal ProjectionTypeNameAndMethodNameTraceData(Action<ProjectionTypeNameAndMethodNameTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ProjectionTypeNameAndMethodNameTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "MethodName", MethodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "MethodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return MethodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProjectionTypeNameAndMethodNameTraceData> Action;
        #endregion
    }
    public sealed class ProjectionTypeNameAndEventNameTraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public new string EventName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal ProjectionTypeNameAndEventNameTraceData(Action<ProjectionTypeNameAndEventNameTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ProjectionTypeNameAndEventNameTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "EventName", EventName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "EventName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return EventName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProjectionTypeNameAndEventNameTraceData> Action;
        #endregion
    }
    public sealed class SourceLoadUnloadTraceData : TraceEvent
    {
        public long SourceID { get { return GetInt64At(0); } }
        public Address ScriptContextID { get { return GetAddressAt(8); } }
        public int SourceFlags { get { return GetInt32At(HostOffset(12, 1)); } }
        public string Url { get { return GetUnicodeStringAt(HostOffset(16, 1)); } }

        #region Private
        internal SourceLoadUnloadTraceData(Action<SourceLoadUnloadTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<SourceLoadUnloadTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(16, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(16, 1))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SourceID", SourceID);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            XmlAttrib(sb, "SourceFlags", SourceFlags);
            XmlAttrib(sb, "Url", Url);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SourceID", "ScriptContextID", "SourceFlags", "Url" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SourceID;
                case 1:
                    return ScriptContextID;
                case 2:
                    return SourceFlags;
                case 3:
                    return Url;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SourceLoadUnloadTraceData> Action;
        #endregion
    }
    public sealed class ProjectionIsBoxedInterfaceTraceData : TraceEvent
    {
        public bool IsBoxed { get { return GetInt32At(0) != 0; } }

        #region Private
        internal ProjectionIsBoxedInterfaceTraceData(Action<ProjectionIsBoxedInterfaceTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ProjectionIsBoxedInterfaceTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4));
            Debug.Assert(!(Version > 0 && EventDataLength < 4));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IsBoxed", IsBoxed);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IsBoxed" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IsBoxed;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProjectionIsBoxedInterfaceTraceData> Action;
        #endregion
    }
    public sealed class ParseStartStopTraceData : TraceEvent
    {
        public long SourceID { get { return GetInt64At(0); } }
        public Address ScriptContextID { get { return GetAddressAt(8); } }
        public int MethodID { get { return GetInt32At(HostOffset(12, 1)); } }
        public int ASTSize { get { return GetInt32At(HostOffset(16, 1)); } }
        public bool IsDeferred { get { return GetInt32At(HostOffset(20, 1)) != 0; } }
        public string MethodName { get { return GetUnicodeStringAt(HostOffset(24, 1)); } }

        #region Private
        internal ParseStartStopTraceData(Action<ParseStartStopTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ParseStartStopTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(24, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(24, 1))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SourceID", SourceID);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            XmlAttrib(sb, "MethodID", MethodID);
            XmlAttrib(sb, "ASTSize", ASTSize);
            XmlAttrib(sb, "IsDeferred", IsDeferred);
            XmlAttrib(sb, "MethodName", MethodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SourceID", "ScriptContextID", "MethodID", "ASTSize", "IsDeferred", "MethodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SourceID;
                case 1:
                    return ScriptContextID;
                case 2:
                    return MethodID;
                case 3:
                    return ASTSize;
                case 4:
                    return IsDeferred;
                case 5:
                    return MethodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ParseStartStopTraceData> Action;
        #endregion
    }
    public sealed class BytecodeGenInfoTraceData : TraceEvent
    {
        public long SourceID { get { return GetInt64At(0); } }
        public Address ScriptContextID { get { return GetAddressAt(8); } }
        public int MethodID { get { return GetInt32At(HostOffset(12, 1)); } }
        public int BytecodeCount { get { return GetInt32At(HostOffset(16, 1)); } }
        public int BytecodeSize { get { return GetInt32At(HostOffset(20, 1)); } }
        public string MethodName { get { return GetUnicodeStringAt(HostOffset(24, 1)); } }

        #region Private
        internal BytecodeGenInfoTraceData(Action<BytecodeGenInfoTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BytecodeGenInfoTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(24, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(24, 1))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SourceID", SourceID);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            XmlAttrib(sb, "MethodID", MethodID);
            XmlAttrib(sb, "BytecodeCount", BytecodeCount);
            XmlAttrib(sb, "BytecodeSize", BytecodeSize);
            XmlAttrib(sb, "MethodName", MethodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SourceID", "ScriptContextID", "MethodID", "BytecodeCount", "BytecodeSize", "MethodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SourceID;
                case 1:
                    return ScriptContextID;
                case 2:
                    return MethodID;
                case 3:
                    return BytecodeCount;
                case 4:
                    return BytecodeSize;
                case 5:
                    return MethodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BytecodeGenInfoTraceData> Action;
        #endregion
    }
    public sealed class GCPhaseTraceData : TraceEvent
    {
        public Address RecyclerID { get { return GetAddressAt(0); } }

        #region Private
        internal GCPhaseTraceData(Action<GCPhaseTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<GCPhaseTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength < HostOffset(4, 1)));    // Changed by hand to < (we got 5 instead of 4).  
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "RecyclerID", RecyclerID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RecyclerID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RecyclerID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCPhaseTraceData> Action;
        #endregion
    }
    public sealed class GCPhaseCollectTraceData : TraceEvent
    {
        public Address RecyclerID { get { return GetAddressAt(0); } }
        public int SweptBytes { get { return GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal GCPhaseCollectTraceData(Action<GCPhaseCollectTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<GCPhaseCollectTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "RecyclerID", RecyclerID);
            XmlAttrib(sb, "SweptBytes", SweptBytes);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RecyclerID", "SweptBytes" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RecyclerID;
                case 1:
                    return SweptBytes;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCPhaseCollectTraceData> Action;
        #endregion
    }
    public sealed class ProfileSaveTraceData : TraceEvent
    {
        public long SourceID { get { return GetInt64At(0); } }
        public Address ScriptContextID { get { return GetAddressAt(8); } }
        public int Size { get { return GetInt32At(HostOffset(12, 1)); } }
        public bool IsSaveOnClose { get { return GetInt32At(HostOffset(16, 1)) != 0; } }

        #region Private
        internal ProfileSaveTraceData(Action<ProfileSaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ProfileSaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SourceID", SourceID);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            XmlAttrib(sb, "Size", Size);
            XmlAttrib(sb, "IsSaveOnClose", IsSaveOnClose);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SourceID", "ScriptContextID", "Size", "IsSaveOnClose" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SourceID;
                case 1:
                    return ScriptContextID;
                case 2:
                    return Size;
                case 3:
                    return IsSaveOnClose;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProfileSaveTraceData> Action;
        #endregion
    }
    public sealed class StartupCompleteTraceData : TraceEvent
    {
        public Address ScriptContextID { get { return GetAddressAt(0); } }

        #region Private
        internal StartupCompleteTraceData(Action<StartupCompleteTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<StartupCompleteTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ScriptContextID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ScriptContextID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<StartupCompleteTraceData> Action;
        #endregion
    }
    public sealed class ProfileLoadTraceData : TraceEvent
    {
        public long SourceID { get { return GetInt64At(0); } }
        public Address ScriptContextID { get { return GetAddressAt(8); } }

        #region Private
        internal ProfileLoadTraceData(Action<ProfileLoadTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ProfileLoadTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SourceID", SourceID);
            XmlAttribHex(sb, "ScriptContextID", ScriptContextID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SourceID", "ScriptContextID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SourceID;
                case 1:
                    return ScriptContextID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProfileLoadTraceData> Action;
        #endregion
    }
    public sealed class InlineInfoTraceData : TraceEvent
    {
        public int CallerMethodID { get { return GetInt32At(0); } }
        public int InlineeMethodID { get { return GetInt32At(4); } }
        public string Caller { get { return GetUnicodeStringAt(8); } }
        public string Inlinee { get { return GetUnicodeStringAt(SkipUnicodeString(8)); } }

        #region Private
        internal InlineInfoTraceData(Action<InlineInfoTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<InlineInfoTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(8))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(8))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "CallerMethodID", CallerMethodID);
            XmlAttrib(sb, "InlineeMethodID", InlineeMethodID);
            XmlAttrib(sb, "Caller", Caller);
            XmlAttrib(sb, "Inlinee", Inlinee);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "CallerMethodID", "InlineeMethodID", "Caller", "Inlinee" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return CallerMethodID;
                case 1:
                    return InlineeMethodID;
                case 2:
                    return Caller;
                case 3:
                    return Inlinee;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<InlineInfoTraceData> Action;
        #endregion
    }
    public sealed class JitMethodStartTraceData : TraceEvent
    {
        public int MethodID { get { return GetInt32At(0); } }
        public string MethodName { get { return GetUnicodeStringAt(4); } }
        public Address ScriptContext { get { return GetAddressAt(SkipUnicodeString(4)); } }
        public int InterpretedCount { get { return GetInt32At(HostOffset(SkipUnicodeString(4) + 4, 1)); } }
        public int SourceCodeSize { get { return GetInt32At(HostOffset(SkipUnicodeString(4) + 8, 1)); } }
        public int ByteCodeSize { get { return GetInt32At(HostOffset(SkipUnicodeString(4) + 12, 1)); } }
        public int ByteCodeInLoopSize { get { return GetInt32At(HostOffset(SkipUnicodeString(4) + 16, 1)); } }

        #region Private
        internal JitMethodStartTraceData(Action<JitMethodStartTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JitMethodStartTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(SkipUnicodeString(4) + 20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(SkipUnicodeString(4) + 20, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "MethodID", MethodID);
            XmlAttrib(sb, "MethodName", MethodName);
            XmlAttribHex(sb, "ScriptContext", ScriptContext);
            XmlAttrib(sb, "InterpretedCount", InterpretedCount);
            XmlAttrib(sb, "SourceCodeSize", SourceCodeSize);
            XmlAttrib(sb, "ByteCodeSize", ByteCodeSize);
            XmlAttrib(sb, "ByteCodeInLoopSize", ByteCodeInLoopSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MethodID", "MethodName", "ScriptContext", "InterpretedCount", "SourceCodeSize", "ByteCodeSize", "ByteCodeInLoopSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MethodID;
                case 1:
                    return MethodName;
                case 2:
                    return ScriptContext;
                case 3:
                    return InterpretedCount;
                case 4:
                    return SourceCodeSize;
                case 5:
                    return ByteCodeSize;
                case 6:
                    return ByteCodeInLoopSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JitMethodStartTraceData> Action;
        #endregion
    }
    public sealed class JitMethodStopTraceData : TraceEvent
    {
        public int MethodID { get { return GetInt32At(0); } }
        public string MethodName { get { return GetUnicodeStringAt(4); } }
        public Address ScriptContext { get { return GetAddressAt(SkipUnicodeString(4)); } }
        public int InterpretedCount { get { return GetInt32At(HostOffset(SkipUnicodeString(4) + 4, 1)); } }
        public Address MethodStartAddress { get { return GetAddressAt(HostOffset(SkipUnicodeString(4) + 8, 1)); } }
        public long MethodSize { get { return GetInt64At(HostOffset(SkipUnicodeString(4) + 12, 2)); } }

        #region Private
        internal JitMethodStopTraceData(Action<JitMethodStopTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JitMethodStopTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(SkipUnicodeString(4) + 20, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(SkipUnicodeString(4) + 20, 2)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "MethodID", MethodID);
            XmlAttrib(sb, "MethodName", MethodName);
            XmlAttribHex(sb, "ScriptContext", ScriptContext);
            XmlAttrib(sb, "InterpretedCount", InterpretedCount);
            XmlAttribHex(sb, "MethodStartAddress", MethodStartAddress);
            XmlAttrib(sb, "MethodSize", MethodSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MethodID", "MethodName", "ScriptContext", "InterpretedCount", "MethodStartAddress", "MethodSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MethodID;
                case 1:
                    return MethodName;
                case 2:
                    return ScriptContext;
                case 3:
                    return InterpretedCount;
                case 4:
                    return MethodStartAddress;
                case 5:
                    return MethodSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JitMethodStopTraceData> Action;
        #endregion
    }
    public sealed class JitMethodQueueDequeueTraceData : TraceEvent
    {
        public int MethodID { get { return GetInt32At(0); } }
        public string MethodName { get { return GetUnicodeStringAt(4); } }
        public Address ScriptContext { get { return GetAddressAt(SkipUnicodeString(4)); } }
        public int InterpretedCount { get { return GetInt32At(HostOffset(SkipUnicodeString(4) + 4, 1)); } }

        #region Private
        internal JitMethodQueueDequeueTraceData(Action<JitMethodQueueDequeueTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JitMethodQueueDequeueTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(SkipUnicodeString(4) + 8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(SkipUnicodeString(4) + 8, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "MethodID", MethodID);
            XmlAttrib(sb, "MethodName", MethodName);
            XmlAttribHex(sb, "ScriptContext", ScriptContext);
            XmlAttrib(sb, "InterpretedCount", InterpretedCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MethodID", "MethodName", "ScriptContext", "InterpretedCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MethodID;
                case 1:
                    return MethodName;
                case 2:
                    return ScriptContext;
                case 3:
                    return InterpretedCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JitMethodQueueDequeueTraceData> Action;
        #endregion
    }
    public sealed class JscriptSizeInBytesTraceData : TraceEvent
    {
        public long SizeInBytes { get { return GetInt64At(0); } }

        #region Private
        internal JscriptSizeInBytesTraceData(Action<JscriptSizeInBytesTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptSizeInBytesTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SizeInBytes", SizeInBytes);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SizeInBytes" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SizeInBytes;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptSizeInBytesTraceData> Action;
        #endregion
    }
    public sealed class JscriptRecyclerFreeTraceData : TraceEvent
    {
        public int Count { get { return GetInt32At(0); } }
        public Address MemoryAddress { get { return GetAddressAt(4); } }
        public int Size { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal JscriptRecyclerFreeTraceData(Action<JscriptRecyclerFreeTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptRecyclerFreeTraceData>)value; }
        }
        protected internal override void Validate()
        {
            // Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1))); TODO FIX NOW disabled why wrong?
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Count", Count);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "Size", Size);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Count", "MemoryAddress", "Size" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Count;
                case 1:
                    return MemoryAddress;
                case 2:
                    return Size;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptRecyclerFreeTraceData> Action;
        #endregion
    }
    public sealed class JscriptRecyclerFreeBlockTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }
        public int BlockSize { get { return GetInt32At(HostOffset(4, 1)); } }
        public int ObjectSize { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal JscriptRecyclerFreeBlockTraceData(Action<JscriptRecyclerFreeBlockTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptRecyclerFreeBlockTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "BlockSize", BlockSize);
            XmlAttrib(sb, "ObjectSize", ObjectSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress", "BlockSize", "ObjectSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                case 1:
                    return BlockSize;
                case 2:
                    return ObjectSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptRecyclerFreeBlockTraceData> Action;
        #endregion
    }
    public sealed class JscriptAllocationTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }

        #region Private
        internal JscriptAllocationTraceData(Action<JscriptAllocationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptAllocationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptAllocationTraceData> Action;
        #endregion
    }
    public sealed class JscriptAllocateFunctionTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }
        public int MethodID { get { return GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal JscriptAllocateFunctionTraceData(Action<JscriptAllocateFunctionTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptAllocateFunctionTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "MethodID", MethodID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress", "MethodID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                case 1:
                    return MethodID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptAllocateFunctionTraceData> Action;
        #endregion
    }
    public sealed class JscriptDOMAllocationTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }
        public int TypeId { get { return GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal JscriptDOMAllocationTraceData(Action<JscriptDOMAllocationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptDOMAllocationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "TypeId", TypeId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress", "TypeId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                case 1:
                    return TypeId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptDOMAllocationTraceData> Action;
        #endregion
    }
    public sealed class JScriptWinRTObjectAllocationTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }
        public string TypeName { get { return GetUnicodeStringAt(HostOffset(4, 1)); } }

        #region Private
        internal JScriptWinRTObjectAllocationTraceData(Action<JScriptWinRTObjectAllocationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JScriptWinRTObjectAllocationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(4, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(4, 1))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "TypeName", TypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress", "TypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                case 1:
                    return TypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JScriptWinRTObjectAllocationTraceData> Action;
        #endregion
    }
    public sealed class JscriptWinRTWrapperAllocationTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }
        public string TypeName { get { return GetUnicodeStringAt(HostOffset(4, 1)); } }
        public Address jsVar { get { return GetAddressAt(SkipUnicodeString(HostOffset(4, 1))); } }

        #region Private
        internal JscriptWinRTWrapperAllocationTraceData(Action<JscriptWinRTWrapperAllocationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptWinRTWrapperAllocationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(SkipUnicodeString(HostOffset(4, 1)) + 4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(SkipUnicodeString(HostOffset(4, 1)) + 4, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttribHex(sb, "jsVar", jsVar);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress", "TypeName", "jsVar" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                case 1:
                    return TypeName;
                case 2:
                    return jsVar;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptWinRTWrapperAllocationTraceData> Action;
        #endregion
    }
    public sealed class JscriptWinRTEventHandlerAllocationTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }
        public string TypeName { get { return GetUnicodeStringAt(HostOffset(4, 1)); } }
        public Address callback { get { return GetAddressAt(SkipUnicodeString(HostOffset(4, 1))); } }
        public new string EventName { get { return GetUnicodeStringAt(HostOffset(SkipUnicodeString(HostOffset(4, 1)) + 4, 1)); } }

        #region Private
        internal JscriptWinRTEventHandlerAllocationTraceData(Action<JscriptWinRTEventHandlerAllocationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptWinRTEventHandlerAllocationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(SkipUnicodeString(HostOffset(4, 1)) + 4, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(SkipUnicodeString(HostOffset(4, 1)) + 4, 1))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttribHex(sb, "callback", callback);
            XmlAttrib(sb, "EventName", EventName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress", "TypeName", "callback", "EventName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                case 1:
                    return TypeName;
                case 2:
                    return callback;
                case 3:
                    return EventName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptWinRTEventHandlerAllocationTraceData> Action;
        #endregion
    }
    public sealed class JscriptWinRTPropertyValueAllocationTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }
        public string TypeName { get { return GetUnicodeStringAt(HostOffset(4, 1)); } }
        public bool IsArray { get { return GetInt32At(SkipUnicodeString(HostOffset(4, 1))) != 0; } }

        #region Private
        internal JscriptWinRTPropertyValueAllocationTraceData(Action<JscriptWinRTPropertyValueAllocationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptWinRTPropertyValueAllocationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(4, 1)) + 4));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(4, 1)) + 4));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "IsArray", IsArray);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress", "TypeName", "IsArray" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                case 1:
                    return TypeName;
                case 2:
                    return IsArray;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptWinRTPropertyValueAllocationTraceData> Action;
        #endregion
    }
    public sealed class JscriptWinRTWrapperFreeTraceData : TraceEvent
    {
        public Address MemoryAddress { get { return GetAddressAt(0); } }

        #region Private
        internal JscriptWinRTWrapperFreeTraceData(Action<JscriptWinRTWrapperFreeTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<JscriptWinRTWrapperFreeTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MemoryAddress" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MemoryAddress;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<JscriptWinRTWrapperFreeTraceData> Action;
        #endregion
    }
    public enum MethodAddressRange
    {
        Interpreted = 0x1,
        JIT = 0x2,
        JITLoopBody = 0x3,
    }

}
