using Microsoft.Diagnostics.Tracing.Parsers.JSDumpHeap;
using System;
using System.Diagnostics;
using System.Text;
using Address = System.UInt64;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{

    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "1.0")]
    public sealed class JSDumpHeapTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "Microsoft-IE-JSDumpHeap";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0x7f8e35ca), unchecked((short)0x68e8), unchecked((short)0x41b9), 0x86, 0xfe, 0xd6, 0xad, 0xc5, 0xb3, 0x27, 0xe7);
        public enum Keywords : long
        {
            jsdumpheap = 0x00000020,
            jsdumpheapEnvelopeOnly = 0x80000000,
        };

        public JSDumpHeapTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<SettingsTraceData> JSDumpHeapEnvelopeStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SettingsTraceData(value, 1, 321, "JSDumpHeapEnvelope", JSDumpHeapEnvelopeTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, JSDumpHeapEnvelopeTaskGuid);
            }
        }
        public event Action<SummaryTraceData> JSDumpHeapEnvelopeStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SummaryTraceData(value, 2, 321, "JSDumpHeapEnvelope", JSDumpHeapEnvelopeTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, JSDumpHeapEnvelopeTaskGuid);
            }
        }
        public event Action<BulkNodeTraceData> JSDumpHeapBulkNode
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new BulkNodeTraceData(value, 3, 323, "JSDumpHeapBulkNode", JSDumpHeapBulkNodeTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, JSDumpHeapBulkNodeTaskGuid);
            }
        }
        public event Action<BulkAttributeTraceData> JSDumpHeapBulkAttribute
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new BulkAttributeTraceData(value, 4, 324, "JSDumpHeapBulkAttribute", JSDumpHeapBulkAttributeTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, JSDumpHeapBulkAttributeTaskGuid);
            }
        }
        public event Action<BulkEdgeTraceData> JSDumpHeapBulkEdge
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new BulkEdgeTraceData(value, 5, 325, "JSDumpHeapBulkEdge", JSDumpHeapBulkEdgeTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, JSDumpHeapBulkEdgeTaskGuid);
            }
        }
        public event Action<StringTableTraceData> JSDumpHeapStringTable
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new StringTableTraceData(value, 6, 326, "JSDumpHeapStringTable", JSDumpHeapStringTableTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 6, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, JSDumpHeapStringTableTaskGuid);
            }
        }
        public event Action<DoubleTableTraceData> JSDumpHeapDoubleTable
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new DoubleTableTraceData(value, 7, 327, "JSDumpHeapDoubleTable", JSDumpHeapDoubleTableTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 7, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, JSDumpHeapDoubleTableTaskGuid);
            }
        }

        #region Event ID Definitions
        private const TraceEventID JSDumpHeapEnvelopeStartEventID = (TraceEventID)1;
        private const TraceEventID JSDumpHeapEnvelopeStopEventID = (TraceEventID)2;
        private const TraceEventID JSDumpHeapBulkNodeEventID = (TraceEventID)3;
        private const TraceEventID JSDumpHeapBulkAttributeEventID = (TraceEventID)4;
        private const TraceEventID JSDumpHeapBulkEdgeEventID = (TraceEventID)5;
        private const TraceEventID JSDumpHeapStringTableEventID = (TraceEventID)6;
        private const TraceEventID JSDumpHeapDoubleTableEventID = (TraceEventID)7;
        #endregion

        #region private
        protected override string GetProviderName() { return ProviderName; }
        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[7];
                templates[0] = new SettingsTraceData(null, 1, 321, "JSDumpHeapEnvelope", JSDumpHeapEnvelopeTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[1] = new SummaryTraceData(null, 2, 321, "JSDumpHeapEnvelope", JSDumpHeapEnvelopeTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[2] = new BulkNodeTraceData(null, 3, 323, "JSDumpHeapBulkNode", JSDumpHeapBulkNodeTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[3] = new BulkAttributeTraceData(null, 4, 324, "JSDumpHeapBulkAttribute", JSDumpHeapBulkAttributeTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[4] = new BulkEdgeTraceData(null, 5, 325, "JSDumpHeapBulkEdge", JSDumpHeapBulkEdgeTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[5] = new StringTableTraceData(null, 6, 326, "JSDumpHeapStringTable", JSDumpHeapStringTableTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[6] = new DoubleTableTraceData(null, 7, 327, "JSDumpHeapDoubleTable", JSDumpHeapDoubleTableTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        private static readonly Guid JSDumpHeapEnvelopeTaskGuid = new Guid(unchecked((int)0xfff80bb3), unchecked((short)0x0541), unchecked((short)0x4423), 0xb2, 0x6b, 0x8c, 0x4a, 0x5a, 0xf9, 0x06, 0xff);
        private static readonly Guid JSDumpHeapBulkNodeTaskGuid = new Guid(unchecked((int)0x89b4a9e6), unchecked((short)0x156f), unchecked((short)0x4ff2), 0x8c, 0x93, 0xcd, 0x86, 0xb1, 0xbc, 0xe9, 0xa4);
        private static readonly Guid JSDumpHeapBulkAttributeTaskGuid = new Guid(unchecked((int)0xb171ef0b), unchecked((short)0xd1fb), unchecked((short)0x4901), 0x98, 0x47, 0xe1, 0x3d, 0x58, 0x3b, 0xfa, 0x86);
        private static readonly Guid JSDumpHeapBulkEdgeTaskGuid = new Guid(unchecked((int)0xec5809c8), unchecked((short)0xef06), unchecked((short)0x456c), 0xbe, 0x69, 0xe8, 0xdc, 0xdf, 0x75, 0x54, 0xba);
        private static readonly Guid JSDumpHeapStringTableTaskGuid = new Guid(unchecked((int)0x8a019204), unchecked((short)0x6cc0), unchecked((short)0x41f3), 0x8f, 0xae, 0xe1, 0x90, 0xdd, 0xfd, 0x05, 0xa7);
        private static readonly Guid JSDumpHeapDoubleTableTaskGuid = new Guid(unchecked((int)0xeaa70a14), unchecked((short)0xd1c3), unchecked((short)0x4939), 0x8c, 0xa7, 0x39, 0x3c, 0x2f, 0x75, 0xfa, 0x58);
        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.JSDumpHeap
{
    public sealed class SettingsTraceData : TraceEvent
    {
        public new int Version { get { return GetInt32At(0); } }
        public int MaxStringLength { get { return GetInt32At(4); } }
        public bool IsTypeNamePrivate { get { return GetInt32At(8) != 0; } }
        public bool IsEdgeStringValuePrivate { get { return GetInt32At(12) != 0; } }
        public bool IsEdgeNumberValuePrivate { get { return GetInt32At(16) != 0; } }
        public bool IsAttributeStringValuePrivate { get { return GetInt32At(20) != 0; } }
        public bool IsAttributeNumberValuePrivate { get { return GetInt32At(24) != 0; } }

        #region Private
        internal SettingsTraceData(Action<SettingsTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<SettingsTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 28));
            Debug.Assert(!(Version > 0 && EventDataLength < 28));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Version", Version);
            XmlAttrib(sb, "MaxStringLength", MaxStringLength);
            XmlAttrib(sb, "IsTypeNamePrivate", IsTypeNamePrivate);
            XmlAttrib(sb, "IsEdgeStringValuePrivate", IsEdgeStringValuePrivate);
            XmlAttrib(sb, "IsEdgeNumberValuePrivate", IsEdgeNumberValuePrivate);
            XmlAttrib(sb, "IsAttributeStringValuePrivate", IsAttributeStringValuePrivate);
            XmlAttrib(sb, "IsAttributeNumberValuePrivate", IsAttributeNumberValuePrivate);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Version", "MaxStringLength", "IsTypeNamePrivate", "IsEdgeStringValuePrivate", "IsEdgeNumberValuePrivate", "IsAttributeStringValuePrivate", "IsAttributeNumberValuePrivate" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Version;
                case 1:
                    return MaxStringLength;
                case 2:
                    return IsTypeNamePrivate;
                case 3:
                    return IsEdgeStringValuePrivate;
                case 4:
                    return IsEdgeNumberValuePrivate;
                case 5:
                    return IsAttributeStringValuePrivate;
                case 6:
                    return IsAttributeNumberValuePrivate;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SettingsTraceData> Action;
        #endregion
    }
    public sealed class SummaryTraceData : TraceEvent
    {
        public int HrResult { get { return GetInt32At(0); } }
        public int NodeCount { get { return GetInt32At(4); } }
        public int EdgeCount { get { return GetInt32At(8); } }
        public int AttributeCount { get { return GetInt32At(12); } }
        public int NumberCount { get { return GetInt32At(16); } }
        public int StringCount { get { return GetInt32At(20); } }

        #region Private
        internal SummaryTraceData(Action<SummaryTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<SummaryTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "HrResult", HrResult);
            XmlAttrib(sb, "NodeCount", NodeCount);
            XmlAttrib(sb, "EdgeCount", EdgeCount);
            XmlAttrib(sb, "AttributeCount", AttributeCount);
            XmlAttrib(sb, "NumberCount", NumberCount);
            XmlAttrib(sb, "StringCount", StringCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HrResult", "NodeCount", "EdgeCount", "AttributeCount", "NumberCount", "StringCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HrResult;
                case 1:
                    return NodeCount;
                case 2:
                    return EdgeCount;
                case 3:
                    return AttributeCount;
                case 4:
                    return NumberCount;
                case 5:
                    return StringCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SummaryTraceData> Action;
        #endregion
    }

    public sealed class BulkNodeTraceData : TraceEvent
    {
        public int Index { get { return GetInt32At(0); } }
        public int Count { get { return GetInt32At(4); } }

        /// <summary>
        /// Returns the edge at the given zero-based index (index less than Count).   The returned BulkNodeValues 
        /// points the the data in BulkNodeTraceData so it cannot live beyond that lifetime.  
        /// </summary>
        public BulkNodeValues Values(int index) { return new BulkNodeValues(this, 8 + index * HostOffset(26, 2)); }

        #region Private
        internal BulkNodeTraceData(Action<BulkNodeTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BulkNodeTraceData>)value; }
        }
        protected internal override unsafe void Validate()
        {
            Debug.Assert(!(EventDataLength < 8));
            Debug.Assert(!(EventDataLength != 8 + Count * HostOffset(26, 2)));
            Debug.Assert(Count == 0 || Values(Count - 1).EdgeCount < 10000);        // Gets the BulkNodeValues asserts kicked in
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Index", Index);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Index", "Count" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Index;
                case 1:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BulkNodeTraceData> Action;
        #endregion
    }

    /// <summary>
    /// This structure just POINTS at the data in the BulkNodeTraceData.  It can only be used as long as
    /// the BulkNodeTraceData is alive which (unless you cloned it) is only for the lifetime of the callback.  
    /// </summary>
    public unsafe struct BulkNodeValues
    {
        public Address Id { get { return m_data.GetAddressAt(m_baseOffset); } }
        public int Size { get { return m_data.GetInt32At(m_data.HostOffset(m_baseOffset + 4, 1)); } }
        public Address Address { get { return m_data.GetAddressAt(m_data.HostOffset(m_baseOffset + 8, 1)); } }
        public int TypeNameId { get { return m_data.GetInt32At(m_data.HostOffset(m_baseOffset + 12, 2)); } }
        public ObjectFlags Flags { get { return (ObjectFlags)m_data.GetInt32At(m_data.HostOffset(m_baseOffset + 16, 2)); } }
        public int AttributeCount { get { return (ushort)m_data.GetInt16At(m_data.HostOffset(m_baseOffset + 20, 2)); } }
        public int EdgeCount { get { return m_data.GetInt32At(m_data.HostOffset(m_baseOffset + 22, 2)); } }

        #region private
        internal BulkNodeValues(TraceEvent data, int baseOffset)
        {
            m_data = data; m_baseOffset = baseOffset;
            Debug.Assert((Id & 0xFF00000000000003L) == 0);
            Debug.Assert(EdgeCount < 10000);
            Debug.Assert(AttributeCount < 10000);
            Debug.Assert(Size < 10000000);
        }

        private TraceEvent m_data;
        private int m_baseOffset;
        #endregion
    }

    // TODO change casing?  This is the PROFILER_HEAP_OBJECT_FLAGS enum 
    [Flags]
    public enum ObjectFlags : uint
    {
        NEW_OBJECT = 0x1,
        IS_ROOT = 0x2,
        SITE_CLOSED = 0x4,
        EXTERNAL = 0x8,
        EXTERNAL_UNKNOWN = 0x10,
        EXTERNAL_DISPATCH = 0x20,
        SIZE_APPROXIMATE = 0x40,
        SIZE_UNAVAILABLE = 0x80,
        NEW_STATE_UNAVAILABLE = 0x100,
        WINRT_INSTANCE = 0x200,
        WINRT_RUNTIMECLASS = 0x400,
        WINRT_DELEGATE = 0x800,
        WINRT_NAMESPACE = 0x1000,
        WINRT = (WINRT_INSTANCE | WINRT_RUNTIMECLASS | WINRT_DELEGATE | WINRT_NAMESPACE)
    };

    public sealed class BulkAttributeTraceData : TraceEvent
    {
        public int Index { get { return GetInt32At(0); } }
        public int Count { get { return GetInt32At(4); } }

        /// <summary>
        /// Returns the edge at the given zero-based index (index less than Count).   The returned BulkAttributeValues 
        /// points the the data in BulkAttributeTraceData so it cannot live beyond that lifetime.  
        /// </summary>
        public BulkAttributeValues Values(int index) { return new BulkAttributeValues(this, 8 + index * HostOffset(6, 1)); }

        #region Private
        internal BulkAttributeTraceData(Action<BulkAttributeTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BulkAttributeTraceData>)value; }
        }
        protected internal override unsafe void Validate()
        {
            Debug.Assert(!(EventDataLength < 8));
            Debug.Assert(!(EventDataLength != 8 + Count * HostOffset(6, 1)));
            Debug.Assert(Count == 0 || Values(Count - 1).Type <= AttributeType.Max);
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Index", Index);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Index", "Count" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Index;
                case 1:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BulkAttributeTraceData> Action;
        #endregion
    }

    /// <summary>
    /// This structure just POINTS at the data in the BulkAttributeTraceData.  It can only be used as long as
    /// the BulkAttributeTraceData is alive which (unless you cloned it) is only for the lifetime of the callback.  
    /// </summary>
    public unsafe struct BulkAttributeValues
    {
        public AttributeType Type { get { return (AttributeType)m_data.GetInt16At(m_baseOffset); } }
        public Address Value { get { return m_data.GetAddressAt(m_baseOffset + 2); } }

        #region private
        internal BulkAttributeValues(TraceEvent data, int baseOffset)
        {
            m_data = data; m_baseOffset = baseOffset;
            Debug.Assert(0 <= Type && Type <= AttributeType.Max);
        }

        private TraceEvent m_data;
        private int m_baseOffset;
        #endregion
    }

    public enum AttributeType : ushort
    {
        DOMTagName,                 // Does not seem to be used yet
        DOMId,                      // Does not seem to be used yet
        DOMClass,                   // Does not seem to be used yet
        DOMSrc,                     // Does not seem to be used yet
        ElementAttributesSize,      // Value is a number
        Scope,                      // Value is a number
        Prototype,                  // Value is a number
        FunctionName,               // Value is a string ID
        TextChildrenSize,           // Value is a number
        Max
    };

    public sealed class BulkEdgeTraceData : TraceEvent
    {
        public int Index { get { return GetInt32At(0); } }
        public int Count { get { return GetInt32At(4); } }

        /// <summary>
        /// Returns the edge at the given zero-based index (index less than Count).   The returned BulkEdgeValues 
        /// points the the data in BulkEdgeTraceData so it cannot live beyond that lifetime.  
        /// </summary>
        public BulkEdgeValues Values(int index) { return new BulkEdgeValues(this, 8 + index * HostOffset(10, 1)); }

        #region Private
        internal BulkEdgeTraceData(Action<BulkEdgeTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override unsafe void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BulkEdgeTraceData>)value; }
        }
        protected internal override unsafe void Validate()
        {
            Debug.Assert(!(EventDataLength < 8));
            Debug.Assert(EventDataLength == 8 + Count * HostOffset(10, 1));
            Debug.Assert(Count == 0 || Values(Count - 1).RelationshipType < EdgeRelationshipType.Max);  // This get the other Asserts kicked in too. 
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Index", Index);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Index", "Count" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Index;
                case 1:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BulkEdgeTraceData> Action;
        #endregion
    }

    /// <summary>
    /// This structure just POINTS at the data in the BulkNodeTraceData.  It can only be used as long as
    /// the BulkNodeTraceData is alive which (unless you cloned it) is only for the lifetime of the callback.  
    /// </summary>
    public unsafe struct BulkEdgeValues
    {
        public EdgeRelationshipType RelationshipType { get { return (EdgeRelationshipType)m_data.GetByteAt(m_baseOffset); } }
        public EdgeTargetType TargetType { get { return (EdgeTargetType)m_data.GetByteAt(m_baseOffset + 1); } }
        public int NameId { get { return m_data.GetInt32At(m_baseOffset + 2); } }
        public Address Value { get { return m_data.GetAddressAt(m_baseOffset + 6); } }

        #region private
        internal BulkEdgeValues(TraceEvent data, int baseOffset)
        {
            m_data = data; m_baseOffset = baseOffset;
            Debug.Assert(RelationshipType <= EdgeRelationshipType.Max);
            Debug.Assert(0 <= TargetType && TargetType <= EdgeTargetType.Max);
        }

        private TraceEvent m_data;
        private int m_baseOffset;
        #endregion
    }

    public enum EdgeRelationshipType : byte
    {
        Prototype,
        Scope,
        InternalProperty,
        NamedProperty,
        IndexedProperty,    // The object is an array, The Name ID is the index into that array.   (Not the index in the string table)
        Event,
        RelationShip,       // Some other relationship (typically a DOM tag or class) The NameId tells you the relationship. 
        Max
    }

    public enum EdgeTargetType : byte
    {
        Number,         // Value is index into double table
        String,         // Value is ???
        BSTR,           // Value is index into string table
        Object,         // Value is Node Address
        External,       // Value is Node Address
        Max
    }

    public sealed class StringTableTraceData : TraceEvent
    {
        public int Index { get { return GetInt32At(0); } }
        public int Count { get { return GetInt32At(4); } }
        public string Strings(int index)
        {
            Debug.Assert(0 <= index && index < Count);
            // Perf Remember the last place we were and look from there if possible.  
            // This handles the common case 
            int idx = m_lastStrIdx;
            int offset = m_lastStrOffset;
            if (index < idx)
            {
                idx = 0;
                offset = 8;
            }
            while (idx < index)
            {
                idx++;
                offset = SkipUnicodeString(offset);
            }

            var ret = GetUnicodeStringAt(offset);
            // Point at the next offset.  
            m_lastStrIdx = index + 1;
            m_lastStrOffset = offset + 2 * (ret.Length + 1);
            return ret;
        }

        #region Private
        internal StringTableTraceData(Action<StringTableTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
            m_lastStrOffset = 8;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<StringTableTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(EventDataLength < 8));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Index", Index);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Index", "Count" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Index;
                case 1:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<StringTableTraceData> Action;

        // For efficient string lookup
        private int m_lastStrIdx;
        private int m_lastStrOffset;
        #endregion
    }
    public sealed unsafe class DoubleTableTraceData : TraceEvent
    {
        public int Index { get { return GetInt32At(0); } }
        public int Count { get { return GetInt32At(4); } }
        public double Doubles(int index)
        {
            Debug.Assert(0 <= index && index < Count);
            double* basePtr = (double*)(((byte*)DataStart) + 8);
            return basePtr[index];
        }

        #region Private
        internal DoubleTableTraceData(Action<DoubleTableTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<DoubleTableTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(EventDataLength < 8));
            Debug.Assert(!(EventDataLength != 8 + Count * 8));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Index", Index);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Index", "Count" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Index;
                case 1:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<DoubleTableTraceData> Action;
        #endregion
    }

}
