﻿using System;
using System.Diagnostics;
using System.Text;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    using Microsoft.Diagnostics.Tracing.Parsers.IIS_Trace;

    public enum RequestNotification
    {
        AcquireRequestState = 32,
        AuthenticateRequest = 2,
        AuthorizeRequest = 4,
        BeginRequest = 1,
        EndRequest = 2048,
        ExecuteRequestHandler = 128,
        LogRequest = 1024,
        MapRequestHandler = 16,
        PreExecuteRequestHandler = 64,
        ReleaseRequestState = 256,
        ResolveRequestCache = 8,
        SendResponse = 536870912,
        UpdateRequestCache = 512
    }

    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
    public sealed class IisTraceEventParser : TraceEventParser
    {
        public static string ProviderName = "IIS_Trace";
        public static Guid ProviderGuid = new Guid(unchecked((int)0x3a2a4e84), unchecked((short)0x4c21), unchecked((short)0x4981), 0xae, 0x10, 0x3f, 0xda, 0x0d, 0x9b, 0x0f, 0x83);
        public static Guid IISGeneralGuid = Guid.Parse("{d42cf7ef-de92-473e-8b6c-621ea663113a}");
        public static Guid IISAuthenticationGuid = Guid.Parse("{c33bbe8f-985b-4080-81e6-005f1a06b9e2}");
        public static Guid IISSecurityGuid = Guid.Parse("{29347ffb-ba48-41e6-bffd-469c5e543ca5}");
        public static Guid IISFilterGuid = Guid.Parse("{00237f0d-73eb-4bcf-a232-126693595847}");
        public static Guid IISStaticFileGuid = Guid.Parse("{79b02104-0db9-4cda-a552-058d97c2ecfd}");
        public static Guid IISISAPIGuid = Guid.Parse("{2e94e6c7-eda0-4b73-9010-2529edce1c27}");
        public static Guid IISCGIGuid = Guid.Parse("{e2e55403-0d2e-4609-a470-be0da04013c0}");
        public static Guid IISFastCGIGuid = Guid.Parse("{e3642acc-3627-42b0-8372-867baa033b07}");
        public static Guid IISWebSocketGuid = Guid.Parse("{2ce74327-08be-425c-bfc5-1534fe7fefa6}");
        public static Guid IISCompressionGuid = Guid.Parse("{e60cee96-4472-448d-a13c-2170b18220ec}");
        public static Guid IISCacheGuid = Guid.Parse("{ac1d69f1-bf33-4ca0-9313-bca13873e1dc}");
        public static Guid IISRequestNotificationGuid = Guid.Parse("{002e91e3-e7ae-44ab-8e07-99230ffa6ade}");
        public static Guid IISModuleGuid = Guid.Parse("{d79a948e-95f1-417b-a731-b7a79dec7ae5}");
        public enum Keywords : long
        {
            IISGeneral = 0x0000000000000000,        // IIS general events
            UseUrlFilter = 0x0000000000000001,      // Allow tracing only selected requests
            IISAuthentication = 0x0000000000000002, // IIS authentication events
            IISSecurity = 0x0000000000000004,       // IIS security events
            IISFilter = 0x0000000000000008,         // IIS filter events
            IISStaticFile = 0x0000000000000010,     // IIS static file events
            IISCGI = 0x0000000000000020,            // IIS CGI events
            IISCompression = 0x0000000000000040,    // IIS compression events
            IISCache = 0x0000000000000080,          // IIS cache events
            IISRequestNotification = 0x0000000000000100, // IIS request notifications events
            IISModule = 0x0000000000000200,         // IIS module events
            IISFastCGI = 0x0000000000001000,        // IIS FastCGI events
            IISISAPI = 0x0000000000002000,          // IIS ISAPI events
            IISWebSocket = 0x0000000000004000,      // IIS WebSocket events
        };

        public IisTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<W3AuthAnonPasswdChangeNeeded> IISAuthenticationAuthAnonPasswdChangeNeeded
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthAnonPasswdChangeNeededTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10051, ProviderGuid);
            }
        }
        public event Action<W3AuthBadBasicHeader> IISAuthenticationAuthBadBasicHeader
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthBadBasicHeaderTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10042, ProviderGuid);
            }
        }
        public event Action<W3AuthBasicLogonFailed> IISAuthenticationAuthBasicLogonFailed
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthBasicLogonFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10043, ProviderGuid);
            }
        }
        public event Action<W3AuthEnd> IISAuthenticationAuthEnd
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10053, ProviderGuid);
            }
        }
        public event Action<W3AuthIISDigestLogonFailed> IISAuthenticationAuthIisdigestLogonFailed
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthIisdigestLogonFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10045, ProviderGuid);
            }
        }
        public event Action<W3AuthInvalidAnonAccount> IISAuthenticationAuthInvalidAnonAccount
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthInvalidAnonAccountTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10039, ProviderGuid);
            }
        }
        public event Action<W3AuthKerberosFailed> IISAuthenticationAuthKerberosFailed
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthKerberosFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10050, ProviderGuid);
            }
        }
        public event Action<W3AuthNTLMNullSession> IISAuthenticationAuthNtlmNullSession
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthNtlmNullSessionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10048, ProviderGuid);
            }
        }
        public event Action<W3AuthPassportLogonFailed> IISAuthenticationAuthPassportLogonFailed
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthPassportLogonFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10046, ProviderGuid);
            }
        }
        public event Action<W3AuthPasswdChangeDisabled> IISAuthenticationAuthPasswdChangeDisabled
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthPasswdChangeDisabledTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10041, ProviderGuid);
            }
        }
        public event Action<W3AuthPasswdChangeNeeded> IISAuthenticationAuthPasswdChangeNeeded
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthPasswdChangeNeededTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10040, ProviderGuid);
            }
        }
        public event Action<W3AuthRequestAuthType> IISAuthenticationAuthRequestAuthType
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthRequestAuthTypeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10052, ProviderGuid);
            }
        }
        public event Action<W3AuthSSPIContinueNeeded> IISAuthenticationAuthSspiContinueNeeded
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthSspiContinueNeededTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10049, ProviderGuid);
            }
        }
        public event Action<W3AuthSSPILogonFailed> IISAuthenticationAuthSspiLogonFailed
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthSspiLogonFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10047, ProviderGuid);
            }
        }
        public event Action<W3AuthStart> IISAuthenticationAuthStart
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10036, ProviderGuid);
            }
        }
        public event Action<W3AuthSucceeded> IISAuthenticationAuthSucceeded
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthSucceededTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10037, ProviderGuid);
            }
        }
        public event Action<W3AuthTypeNotSupported> IISAuthenticationAuthTypeNotSupported
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthTypeNotSupportedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10038, ProviderGuid);
            }
        }
        public event Action<W3AuthWDigestLogonFailed> IISAuthenticationAuthWdigestLogonFailed
        {
            add
            {
                source.RegisterEventTemplate(IISAuthenticationAuthWdigestLogonFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10044, ProviderGuid);
            }
        }
        public event Action<W3CacheFileCacheAccessEnd> IISCacheFileCacheAccessEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCacheFileCacheAccessEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10148, ProviderGuid);
            }
        }
        public event Action<W3CacheFileCacheAccessStart> IISCacheFileCacheAccessStart
        {
            add
            {
                source.RegisterEventTemplate(IISCacheFileCacheAccessStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10147, ProviderGuid);
            }
        }
        public event Action<W3CacheHttpsysCacheable> IISCacheHttpsysCacheable
        {
            add
            {
                source.RegisterEventTemplate(IISCacheHttpsysCacheableTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10151, ProviderGuid);
            }
        }
        public event Action<W3OutputCacheDisabled> IISCacheOutputCacheDisabled
        {
            add
            {
                source.RegisterEventTemplate(IISCacheOutputCacheDisabledTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10156, ProviderGuid);
            }
        }
        public event Action<W3OutputCacheLookupEnd> IISCacheOutputCacheLookupEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCacheOutputCacheLookupEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10153, ProviderGuid);
            }
        }
        public event Action<W3OutputCacheLookupStart> IISCacheOutputCacheLookupStart
        {
            add
            {
                source.RegisterEventTemplate(IISCacheOutputCacheLookupStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10152, ProviderGuid);
            }
        }
        public event Action<W3OutputCacheUpdateEnd> IISCacheOutputCacheUpdateEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCacheOutputCacheUpdateEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10155, ProviderGuid);
            }
        }
        public event Action<W3OutputCacheUpdateStart> IISCacheOutputCacheUpdateStart
        {
            add
            {
                source.RegisterEventTemplate(IISCacheOutputCacheUpdateStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10154, ProviderGuid);
            }
        }
        public event Action<W3CacheURLCacheAccessEnd> IISCacheUrlCacheAccessEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCacheUrlCacheAccessEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10150, ProviderGuid);
            }
        }
        public event Action<W3CacheURLCacheAccessStart> IISCacheUrlCacheAccessStart
        {
            add
            {
                source.RegisterEventTemplate(IISCacheUrlCacheAccessStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10149, ProviderGuid);
            }
        }
        public event Action<W3CGIEnd> IISCGICgiEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCGICgiEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10091, ProviderGuid);
            }
        }
        public event Action<W3CGIHeadersReceived> IISCGICgiHeadersReceived
        {
            add
            {
                source.RegisterEventTemplate(IISCGICgiHeadersReceivedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10096, ProviderGuid);
            }
        }
        public event Action<W3CGILaunch> IISCGICgiLaunch
        {
            add
            {
                source.RegisterEventTemplate(IISCGICgiLaunchTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10092, ProviderGuid);
            }
        }
        public event Action<W3CGIPrematureTermination> IISCGICgiPrematureTermination
        {
            add
            {
                source.RegisterEventTemplate(IISCGICgiPrematureTerminationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10094, ProviderGuid);
            }
        }
        public event Action<W3CGIRequestEntitySent> IISCGICgiRequestEntitySent
        {
            add
            {
                source.RegisterEventTemplate(IISCGICgiRequestEntitySentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10095, ProviderGuid);
            }
        }
        public event Action<W3CGIStart> IISCGICgiStart
        {
            add
            {
                source.RegisterEventTemplate(IISCGICgiStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10090, ProviderGuid);
            }
        }
        public event Action<W3CGITimeout> IISCGICgiTimeout
        {
            add
            {
                source.RegisterEventTemplate(IISCGICgiTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10093, ProviderGuid);
            }
        }
        public event Action<W3DynamicCompressionDo> IISCompressionDynamicCompressionDo
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionDynamicCompressionDoTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10144, ProviderGuid);
            }
        }
        public event Action<W3DynamicCompressionEnd> IISCompressionDynamicCompressionEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionDynamicCompressionEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10145, ProviderGuid);
            }
        }
        public event Action<W3DynamicCompressionNotSuccess> IISCompressionDynamicCompressionNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionDynamicCompressionNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10143, ProviderGuid);
            }
        }
        public event Action<W3DynamicCompressionStart> IISCompressionDynamicCompressionStart
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionDynamicCompressionStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10141, ProviderGuid);
            }
        }
        public event Action<W3DynamicCompressionSuccess> IISCompressionDynamicCompressionSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionDynamicCompressionSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10142, ProviderGuid);
            }
        }
        public event Action<W3StaticCompressionCreateEnd> IISCompressionStaticCompressionCreateEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionStaticCompressionCreateEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10140, ProviderGuid);
            }
        }
        public event Action<W3StaticCompressionCreateStart> IISCompressionStaticCompressionCreateStart
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionStaticCompressionCreateStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10139, ProviderGuid);
            }
        }
        public event Action<W3StaticCompressionEnd> IISCompressionStaticCompressionEnd
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionStaticCompressionEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10146, ProviderGuid);
            }
        }
        public event Action<W3StaticCompressionNotSuccess> IISCompressionStaticCompressionNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionStaticCompressionNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10138, ProviderGuid);
            }
        }
        public event Action<W3StaticCompressionStart> IISCompressionStaticCompressionStart
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionStaticCompressionStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10136, ProviderGuid);
            }
        }
        public event Action<W3StaticCompressionSuccess> IISCompressionStaticCompressionSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISCompressionStaticCompressionSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10137, ProviderGuid);
            }
        }
        public event Action<W3CGIFActivityTimeout> IISFastCGIFastcgiActivityTimeout
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiActivityTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10097, ProviderGuid);
            }
        }
        public event Action<W3CGIFAddJobObjectFail> IISFastCGIFastcgiAddJobobjectFail
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiAddJobobjectFailTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10103, ProviderGuid);
            }
        }
        public event Action<W3CGIFAppMgrShutdown> IISFastCGIFastcgiApplicationManagerShutdown
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiApplicationManagerShutdownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10104, ProviderGuid);
            }
        }
        public event Action<W3CGIFAssignProcess> IISFastCGIFastcgiAssignProcess
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiAssignProcessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10113, ProviderGuid);
            }
        }
        public event Action<W3CGIFEnd> IISFastCGIFastcgiEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10115, ProviderGuid);
            }
        }
        public event Action<W3CGIFPathNotFound> IISFastCGIFastcgiPathNotFound
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiPathNotFoundTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10101, ProviderGuid);
            }
        }
        public event Action<W3CGIFQueueFull> IISFastCGIFastcgiQueueFull
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiQueueFullTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10105, ProviderGuid);
            }
        }
        public event Action<W3CGIFQueueRequest> IISFastCGIFastcgiQueueRequest
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiQueueRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10112, ProviderGuid);
            }
        }
        public event Action<W3CGIFRapidFailureProtection> IISFastCGIFastcgiRapidFailureProtection
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiRapidFailureProtectionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10100, ProviderGuid);
            }
        }
        public event Action<W3CGIFRequestTimeout> IISFastCGIFastcgiRequestTimeout
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiRequestTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10098, ProviderGuid);
            }
        }
        public event Action<W3CGIFResponseWritten> IISFastCGIFastcgiResponseWritten
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiResponseWrittenTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10107, ProviderGuid);
            }
        }
        public event Action<W3CGIFScriptProcessorMissing> IISFastCGIFastcgiScriptProcessorMissing
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiScriptProcessorMissingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10102, ProviderGuid);
            }
        }
        public event Action<W3CGIFStart> IISFastCGIFastcgiStart
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10114, ProviderGuid);
            }
        }
        public event Action<W3CGIFTraceError> IISFastCGIFastcgiStderrTraceError
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiStderrTraceErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10109, ProviderGuid);
            }
        }
        public event Action<W3CGIFTraceInfo> IISFastCGIFastcgiStderrTraceInfo
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiStderrTraceInfoTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10111, ProviderGuid);
            }
        }
        public event Action<W3CGIFTraceWarning> IISFastCGIFastcgiStderrTraceWarning
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiStderrTraceWarningTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10110, ProviderGuid);
            }
        }
        public event Action<W3CGIFUnexpectedExit> IISFastCGIFastcgiUnexpectedExit
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiUnexpectedExitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10099, ProviderGuid);
            }
        }
        public event Action<W3CGIFUnknownError> IISFastCGIFastcgiUnknownError
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiUnknownErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10106, ProviderGuid);
            }
        }
        public event Action<W3CGIFWaitingForResponse> IISFastCGIFastcgiWaitingForResponse
        {
            add
            {
                source.RegisterEventTemplate(IISFastCGIFastcgiWaitingForResponseTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10108, ProviderGuid);
            }
        }
        public event Action<W3FilterAccessDeniedEnd> IISFilterFilterAccessDeniedEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAccessDeniedEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10083, ProviderGuid);
            }
        }
        public event Action<W3FilterAccessDeniedStart> IISFilterFilterAccessDeniedStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAccessDeniedStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10082, ProviderGuid);
            }
        }
        public event Action<W3FilterAddReqHeader> IISFilterFilterAddReqHeader
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAddReqHeaderTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10085, ProviderGuid);
            }
        }
        public event Action<W3FilterAddRespHeader> IISFilterFilterAddRespHeader
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAddRespHeaderTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10087, ProviderGuid);
            }
        }
        public event Action<W3FilterAuthCompleteEnd> IISFilterFilterAuthCompleteEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAuthCompleteEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10073, ProviderGuid);
            }
        }
        public event Action<W3FilterAuthCompleteStart> IISFilterFilterAuthCompleteStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAuthCompleteStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10072, ProviderGuid);
            }
        }
        public event Action<W3FilterAuthenticationEnd> IISFilterFilterAuthenticationEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAuthenticationEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10071, ProviderGuid);
            }
        }
        public event Action<W3FilterAuthenticationStart> IISFilterFilterAuthenticationStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterAuthenticationStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10070, ProviderGuid);
            }
        }
        public event Action<W3FilterEnd> IISFilterFilterEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10064, ProviderGuid);
            }
        }
        public event Action<W3FilterEndOfRequestEnd> IISFilterFilterEndOfRequestEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterEndOfRequestEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10077, ProviderGuid);
            }
        }
        public event Action<W3FilterEndOfRequestStart> IISFilterFilterEndOfRequestStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterEndOfRequestStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10076, ProviderGuid);
            }
        }
        public event Action<W3FilterError> IISFilterFilterError
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10065, ProviderGuid);
            }
        }
        public event Action<W3FilterLogEnd> IISFilterFilterLogEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterLogEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10079, ProviderGuid);
            }
        }
        public event Action<W3FilterLogStart> IISFilterFilterLogStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterLogStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10078, ProviderGuid);
            }
        }
        public event Action<W3FilterPreprocEnd> IISFilterFilterPreprocHeadersEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterPreprocHeadersEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10067, ProviderGuid);
            }
        }
        public event Action<W3FilterPreprocStart> IISFilterFilterPreprocHeadersStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterPreprocHeadersStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10066, ProviderGuid);
            }
        }
        public event Action<W3FilterSendRawDataEnd> IISFilterFilterSendRawDataEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterSendRawDataEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10081, ProviderGuid);
            }
        }
        public event Action<W3FilterSendRawDataStart> IISFilterFilterSendRawDataStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterSendRawDataStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10080, ProviderGuid);
            }
        }
        public event Action<W3FilterSendResponseEnd> IISFilterFilterSendResponseEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterSendResponseEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10075, ProviderGuid);
            }
        }
        public event Action<W3FilterSendResponseStart> IISFilterFilterSendResponseStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterSendResponseStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10074, ProviderGuid);
            }
        }
        public event Action<W3FilterSetReqHeader> IISFilterFilterSetReqHeader
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterSetReqHeaderTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10084, ProviderGuid);
            }
        }
        public event Action<W3FilterSetRespHeader> IISFilterFilterSetRespHeader
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterSetRespHeaderTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10086, ProviderGuid);
            }
        }
        public event Action<W3FilterStart> IISFilterFilterStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10063, ProviderGuid);
            }
        }
        public event Action<W3FilterURLMapEnd> IISFilterFilterUrlMapEnd
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterUrlMapEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10069, ProviderGuid);
            }
        }
        public event Action<W3FilterURLMapStart> IISFilterFilterUrlMapStart
        {
            add
            {
                source.RegisterEventTemplate(IISFilterFilterUrlMapStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10068, ProviderGuid);
            }
        }
        public event Action<IISGeneralConfigChangeNotification> IISGeneralConfigChangeNotification
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralConfigChangeNotificationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10020, ProviderGuid);
            }
        }
        public event Action<IISGeneralFileChangeNotification> IISGeneralFileChangeNotification
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralFileChangeNotificationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10019, ProviderGuid);
            }
        }
        public event Action<W3GeneralCGIHandler> IISGeneralGeneralCgiHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralCgiHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10003, ProviderGuid);
            }
        }
        public event Action<W3GeneralChildRequestEnd> IISGeneralGeneralChildRequestEnd
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralChildRequestEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10012, ProviderGuid);
            }
        }
        public event Action<W3GeneralChildRequestStart> IISGeneralGeneralChildRequestStart
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralChildRequestStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10011, ProviderGuid);
            }
        }
        public event Action<W3GeneralDavHandler> IISGeneralGeneralDavHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralDavHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10007, ProviderGuid);
            }
        }
        public event Action<W3GeneralEndpointInformation> IISGeneralGeneralEndpointInformation
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralEndpointInformationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10035, ProviderGuid);
            }
        }
        public event Action<W3GeneralFlushResponseEnd> IISGeneralGeneralFlushResponseEnd
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralFlushResponseEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10016, ProviderGuid);
            }
        }
        public event Action<W3GeneralFlushResponseStart> IISGeneralGeneralFlushResponseStart
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralFlushResponseStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10015, ProviderGuid);
            }
        }
        public event Action<W3GeneralGetURLMetadata> IISGeneralGeneralGetUrlMetadata
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralGetUrlMetadataTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10010, ProviderGuid);
            }
        }
        public event Action<W3GeneralISAPIHandler> IISGeneralGeneralIsapiHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralIsapiHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10004, ProviderGuid);
            }
        }
        public event Action<W3GeneralMapHandler> IISGeneralGeneralMapHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralMapHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10014, ProviderGuid);
            }
        }
        public event Action<W3GeneralModuleFactoryFailed> IISGeneralGeneralModuleFactoryFailed
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralModuleFactoryFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10034, ProviderGuid);
            }
        }
        public event Action<W3GeneralNotSendCustomError> IISGeneralGeneralNotSendCustomError
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralNotSendCustomErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10032, ProviderGuid);
            }
        }
        public event Action<W3GeneralOopISAPIHandler> IISGeneralGeneralOopIsapiHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralOopIsapiHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10005, ProviderGuid);
            }
        }
        public event Action<W3GeneralOptionsHandler> IISGeneralGeneralOptionsHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralOptionsHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10008, ProviderGuid);
            }
        }
        public event Action<W3GeneralReadEntityEnd> IISGeneralGeneralReadEntityEnd
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralReadEntityEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10018, ProviderGuid);
            }
        }
        public event Action<W3GeneralReadEntityStart> IISGeneralGeneralReadEntityStart
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralReadEntityStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10017, ProviderGuid);
            }
        }
        public event Action<W3GeneralRedirectionHandler> IISGeneralGeneralRedirectionHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralRedirectionHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10006, ProviderGuid);
            }
        }
        public event Action<W3GeneralEndNewRequest> IISGeneralGeneralRequestEnd
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralRequestEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10001, ProviderGuid);
            }
        }
        public event Action<W3GeneralRequestEntity> IISGeneralGeneralRequestEntity
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralRequestEntityTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10031, ProviderGuid);
            }
        }
        public event Action<W3GeneralRequestHeaders> IISGeneralGeneralRequestHeaders
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralRequestHeadersTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10030, ProviderGuid);
            }
        }
        public event Action<W3GeneralStartNewRequest> IISGeneralGeneralRequestStart
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralRequestStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10000, ProviderGuid);
            }
        }
        public event Action<W3GeneralResponseEntityBuffer> IISGeneralGeneralResponseEntityBuffer
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralResponseEntityBufferTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10029, ProviderGuid);
            }
        }
        public event Action<W3GeneralResponseEntityFile> IISGeneralGeneralResponseEntityFile
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralResponseEntityFileTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10028, ProviderGuid);
            }
        }
        public event Action<W3GeneralResponseHeaders> IISGeneralGeneralResponseHeaders
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralResponseHeadersTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10027, ProviderGuid);
            }
        }
        public event Action<W3GeneralSendCustomError> IISGeneralGeneralSendCustomError
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralSendCustomErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10013, ProviderGuid);
            }
        }
        public event Action<W3GeneralSetRequestHeader> IISGeneralGeneralSetRequestHeader
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralSetRequestHeaderTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10033, ProviderGuid);
            }
        }
        public event Action<W3GeneralStaticFileHandler> IISGeneralGeneralStaticFileHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralStaticFileHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10002, ProviderGuid);
            }
        }
        public event Action<W3GeneralTraceHandler> IISGeneralGeneralTraceHandler
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralGeneralTraceHandlerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10009, ProviderGuid);
            }
        }
        public event Action<IISGeneralHandlerChanged> IISGeneralHandlerChanged
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralHandlerChangedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10023, ProviderGuid);
            }
        }
        public event Action<IISGeneralHandlerPreconditionNotMatch> IISGeneralHandlerPreconditionNotMatch
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralHandlerPreconditionNotMatchTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10026, ProviderGuid);
            }
        }
        public event Action<IISGeneralModulePreconditionNotMatch> IISGeneralModulePreconditionNotMatch
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralModulePreconditionNotMatchTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10025, ProviderGuid);
            }
        }
        public event Action<IISGeneralUrlChanged> IISGeneralUrlChanged
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralUrlChangedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10022, ProviderGuid);
            }
        }
        public event Action<IISGeneralUserSet> IISGeneralUserSet
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralUserSetTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10024, ProviderGuid);
            }
        }
        public event Action<IISGeneralVirtualModuleUnresolved> IISGeneralVirtualModuleUnresolved
        {
            add
            {
                source.RegisterEventTemplate(IISGeneralVirtualModuleUnresolvedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10021, ProviderGuid);
            }
        }
        public event Action<W3ISAPIEnd> IISISAPIIsapiEnd
        {
            add
            {
                source.RegisterEventTemplate(IISISAPIIsapiEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10089, ProviderGuid);
            }
        }
        public event Action<W3ISAPIStart> IISISAPIIsapiStart
        {
            add
            {
                source.RegisterEventTemplate(IISISAPIIsapiStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10088, ProviderGuid);
            }
        }
        public event Action<IISModuleEventsModuleCriticalError> IISModuleModuleCriticalError
        {
            add
            {
                source.RegisterEventTemplate(IISModuleModuleCriticalErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10168, ProviderGuid);
            }
        }
        public event Action<IISModuleEventsModuleEnd> IISModuleModuleEnd
        {
            add
            {
                source.RegisterEventTemplate(IISModuleModuleEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10167, ProviderGuid);
            }
        }
        public event Action<IISModuleEventsModuleError> IISModuleModuleError
        {
            add
            {
                source.RegisterEventTemplate(IISModuleModuleErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10169, ProviderGuid);
            }
        }
        public event Action<IISModuleEventsModuleInformation> IISModuleModuleInformation
        {
            add
            {
                source.RegisterEventTemplate(IISModuleModuleInformationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10171, ProviderGuid);
            }
        }
        public event Action<IISModuleEventsModuleStart> IISModuleModuleStart
        {
            add
            {
                source.RegisterEventTemplate(IISModuleModuleStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10166, ProviderGuid);
            }
        }
        public event Action<IISModuleEventsModuleVerbose> IISModuleModuleVerbose
        {
            add
            {
                source.RegisterEventTemplate(IISModuleModuleVerboseTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10172, ProviderGuid);
            }
        }
        public event Action<IISModuleEventsModuleWarning> IISModuleModuleWarning
        {
            add
            {
                source.RegisterEventTemplate(IISModuleModuleWarningTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10170, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationEventsResponseErrorStatus> IISRequestNotificationModuleSetResponseErrorStatus
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationModuleSetResponseErrorStatusTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10163, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationEventsResponseSuccessStatus> IISRequestNotificationModuleSetResponseSuccessStatus
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationModuleSetResponseSuccessStatusTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10164, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationEventsCompletion> IISRequestNotificationNotifyModuleCompletion
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationNotifyModuleCompletionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10159, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationEventsEnd> IISRequestNotificationNotifyModuleEnd
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationNotifyModuleEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10158, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationEventsStart> IISRequestNotificationNotifyModuleStart
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationNotifyModuleStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10157, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationPreBeginEnd> IISRequestNotificationPreBeginRequestEnd
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationPreBeginRequestEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10161, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationPreBeginStart> IISRequestNotificationPreBeginRequestStart
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationPreBeginRequestStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10160, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationEventsError> IISRequestNotificationRequestProcessingError
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationRequestProcessingErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10162, ProviderGuid);
            }
        }
        public event Action<IISRequestNotificationEventsResponseErrorDescription> IISRequestNotificationSetResponseErrorDescription
        {
            add
            {
                source.RegisterEventTemplate(IISRequestNotificationSetResponseErrorDescriptionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10165, ProviderGuid);
            }
        }
        public event Action<W3SecDeniedByAccessFlags> IISSecuritySecurityDeniedByAccessFlags
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityDeniedByAccessFlagsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10062, ProviderGuid);
            }
        }
        public event Action<W3SecDeniedByCGIRestriction> IISSecuritySecurityDeniedByCgiRestriction
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityDeniedByCgiRestrictionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10061, ProviderGuid);
            }
        }
        public event Action<W3SecDeniedByISAPIRestriction> IISSecuritySecurityDeniedByIsapiRestriction
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityDeniedByIsapiRestrictionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10060, ProviderGuid);
            }
        }
        public event Action<W3SecDeniedByMimemap> IISSecuritySecurityDeniedByMimemap
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityDeniedByMimemapTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10059, ProviderGuid);
            }
        }
        public event Action<W3SecFileAccessDenied> IISSecuritySecurityFileAccessDenied
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityFileAccessDeniedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10058, ProviderGuid);
            }
        }
        public event Action<W3SecIllegalShortFilename> IISSecuritySecurityIllegalShortFilename
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityIllegalShortFilenameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10054, ProviderGuid);
            }
        }
        public event Action<W3SecRejectedHostname> IISSecuritySecurityRejectedHostname
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityRejectedHostnameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10056, ProviderGuid);
            }
        }
        public event Action<W3SecRejectedIP> IISSecuritySecurityRejectedIp
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityRejectedIpTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10055, ProviderGuid);
            }
        }
        public event Action<W3SecRequireSSL128> IISSecuritySecurityRejectedRequireSsl128
        {
            add
            {
                source.RegisterEventTemplate(IISSecuritySecurityRejectedRequireSsl128Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10057, ProviderGuid);
            }
        }
        public event Action<W3WebSocketApplicationCloseConnection> IISWebSocketWebsocketApplicationCloseConnection
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketApplicationCloseConnectionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10128, ProviderGuid);
            }
        }
        public event Action<W3WebSocketEndFailure> IISWebSocketWebsocketHandshakeNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketHandshakeNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10119, ProviderGuid);
            }
        }
        public event Action<W3WebSocketStart> IISWebSocketWebsocketHandshakeStart
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketHandshakeStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10117, ProviderGuid);
            }
        }
        public event Action<W3WebSocketEndSuccess> IISWebSocketWebsocketHandshakeSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketHandshakeSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10118, ProviderGuid);
            }
        }
        public event Action<W3WebSocketInitializeNotSuccess> IISWebSocketWebsocketInitializeFailed
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketInitializeFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10116, ProviderGuid);
            }
        }
        public event Action<W3WebSocketModuleCloseConnection> IISWebSocketWebsocketModuleCloseConnection
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketModuleCloseConnectionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10129, ProviderGuid);
            }
        }
        public event Action<W3WebSocketReadFragmentEndFailure> IISWebSocketWebsocketReadFragmentEndNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketReadFragmentEndNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10123, ProviderGuid);
            }
        }
        public event Action<W3WebSocketReadFragmentEndPending> IISWebSocketWebsocketReadFragmentEndPending
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketReadFragmentEndPendingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10121, ProviderGuid);
            }
        }
        public event Action<W3WebSocketReadFragmentEndSuccess> IISWebSocketWebsocketReadFragmentEndSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketReadFragmentEndSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10122, ProviderGuid);
            }
        }
        public event Action<W3WebSocketReadFragmentStart> IISWebSocketWebsocketReadFragmentStart
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketReadFragmentStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10120, ProviderGuid);
            }
        }
        public event Action<W3WebSocketReadIoFailed> IISWebSocketWebsocketReadIoNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketReadIoNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10130, ProviderGuid);
            }
        }
        public event Action<W3WebSocketCloseReceived> IISWebSocketWebsocketReceivedClose
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketReceivedCloseTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10132, ProviderGuid);
            }
        }
        public event Action<W3WebSocketCloseSendFailure> IISWebSocketWebsocketSendCloseEndNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketSendCloseEndNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10135, ProviderGuid);
            }
        }
        public event Action<W3WebSocketCloseSendSuccess> IISWebSocketWebsocketSendCloseEndSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketSendCloseEndSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10134, ProviderGuid);
            }
        }
        public event Action<W3WebSocketCloseSendStart> IISWebSocketWebsocketSendCloseStart
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketSendCloseStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10133, ProviderGuid);
            }
        }
        public event Action<W3WebSocketWriteFragmentEndFailure> IISWebSocketWebsocketWriteFragmentEndNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketWriteFragmentEndNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10127, ProviderGuid);
            }
        }
        public event Action<W3WebSocketWriteFragmentEndPending> IISWebSocketWebsocketWriteFragmentEndPending
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketWriteFragmentEndPendingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10125, ProviderGuid);
            }
        }
        public event Action<W3WebSocketWriteFragmentEndSuccess> IISWebSocketWebsocketWriteFragmentEndSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketWriteFragmentEndSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10126, ProviderGuid);
            }
        }
        public event Action<W3WebSocketWriteFragmentStart> IISWebSocketWebsocketWriteFragmentStart
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketWriteFragmentStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10124, ProviderGuid);
            }
        }
        public event Action<W3WebSocketWriteIoFailed> IISWebSocketWebsocketWriteIoNotSuccess
        {
            add
            {
                source.RegisterEventTemplate(IISWebSocketWebsocketWriteIoNotSuccessTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10131, ProviderGuid);
            }
        }

        #region private
        protected override string GetProviderName() { return ProviderName; }

        static private W3AuthAnonPasswdChangeNeeded IISAuthenticationAuthAnonPasswdChangeNeededTemplate(Action<W3AuthAnonPasswdChangeNeeded> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthAnonPasswdChangeNeeded(action, 10051, 1, "IISAuthentication", IISAuthenticationGuid, 24, "AUTH_ANON_PASSWD_CHANGE_NEEDED", ProviderGuid, ProviderName);
        }
        static private W3AuthBadBasicHeader IISAuthenticationAuthBadBasicHeaderTemplate(Action<W3AuthBadBasicHeader> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthBadBasicHeader(action, 10042, 1, "IISAuthentication", IISAuthenticationGuid, 16, "AUTH_BAD_BASIC_HEADER", ProviderGuid, ProviderName);
        }
        static private W3AuthBasicLogonFailed IISAuthenticationAuthBasicLogonFailedTemplate(Action<W3AuthBasicLogonFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthBasicLogonFailed(action, 10043, 1, "IISAuthentication", IISAuthenticationGuid, 17, "AUTH_BASIC_LOGON_FAILED", ProviderGuid, ProviderName);
        }
        static private W3AuthEnd IISAuthenticationAuthEndTemplate(Action<W3AuthEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthEnd(action, 10053, 1, "IISAuthentication", IISAuthenticationGuid, 28, "AUTH_END", ProviderGuid, ProviderName);
        }
        static private W3AuthIISDigestLogonFailed IISAuthenticationAuthIisdigestLogonFailedTemplate(Action<W3AuthIISDigestLogonFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthIISDigestLogonFailed(action, 10045, 1, "IISAuthentication", IISAuthenticationGuid, 19, "AUTH_IISDIGEST_LOGON_FAILED", ProviderGuid, ProviderName);
        }
        static private W3AuthInvalidAnonAccount IISAuthenticationAuthInvalidAnonAccountTemplate(Action<W3AuthInvalidAnonAccount> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthInvalidAnonAccount(action, 10039, 1, "IISAuthentication", IISAuthenticationGuid, 13, "AUTH_INVALID_ANON_ACCOUNT", ProviderGuid, ProviderName);
        }
        static private W3AuthKerberosFailed IISAuthenticationAuthKerberosFailedTemplate(Action<W3AuthKerberosFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthKerberosFailed(action, 10050, 1, "IISAuthentication", IISAuthenticationGuid, 55, "AUTH_KERBEROS_FAILED", ProviderGuid, ProviderName);
        }
        static private W3AuthNTLMNullSession IISAuthenticationAuthNtlmNullSessionTemplate(Action<W3AuthNTLMNullSession> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthNTLMNullSession(action, 10048, 1, "IISAuthentication", IISAuthenticationGuid, 22, "AUTH_NTLM_NULL_SESSION", ProviderGuid, ProviderName);
        }
        static private W3AuthPassportLogonFailed IISAuthenticationAuthPassportLogonFailedTemplate(Action<W3AuthPassportLogonFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthPassportLogonFailed(action, 10046, 1, "IISAuthentication", IISAuthenticationGuid, 20, "AUTH_PASSPORT_LOGON_FAILED", ProviderGuid, ProviderName);
        }
        static private W3AuthPasswdChangeDisabled IISAuthenticationAuthPasswdChangeDisabledTemplate(Action<W3AuthPasswdChangeDisabled> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthPasswdChangeDisabled(action, 10041, 1, "IISAuthentication", IISAuthenticationGuid, 15, "AUTH_PASSWD_CHANGE_DISABLED", ProviderGuid, ProviderName);
        }
        static private W3AuthPasswdChangeNeeded IISAuthenticationAuthPasswdChangeNeededTemplate(Action<W3AuthPasswdChangeNeeded> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthPasswdChangeNeeded(action, 10040, 1, "IISAuthentication", IISAuthenticationGuid, 14, "AUTH_PASSWD_CHANGE_NEEDED", ProviderGuid, ProviderName);
        }
        static private W3AuthRequestAuthType IISAuthenticationAuthRequestAuthTypeTemplate(Action<W3AuthRequestAuthType> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthRequestAuthType(action, 10052, 1, "IISAuthentication", IISAuthenticationGuid, 27, "AUTH_REQUEST_AUTH_TYPE", ProviderGuid, ProviderName);
        }
        static private W3AuthSSPIContinueNeeded IISAuthenticationAuthSspiContinueNeededTemplate(Action<W3AuthSSPIContinueNeeded> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthSSPIContinueNeeded(action, 10049, 1, "IISAuthentication", IISAuthenticationGuid, 23, "AUTH_SSPI_CONTINUE_NEEDED", ProviderGuid, ProviderName);
        }
        static private W3AuthSSPILogonFailed IISAuthenticationAuthSspiLogonFailedTemplate(Action<W3AuthSSPILogonFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthSSPILogonFailed(action, 10047, 1, "IISAuthentication", IISAuthenticationGuid, 21, "AUTH_SSPI_LOGON_FAILED", ProviderGuid, ProviderName);
        }
        static private W3AuthStart IISAuthenticationAuthStartTemplate(Action<W3AuthStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthStart(action, 10036, 1, "IISAuthentication", IISAuthenticationGuid, 10, "AUTH_START", ProviderGuid, ProviderName);
        }
        static private W3AuthSucceeded IISAuthenticationAuthSucceededTemplate(Action<W3AuthSucceeded> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthSucceeded(action, 10037, 1, "IISAuthentication", IISAuthenticationGuid, 11, "AUTH_SUCCEEDED", ProviderGuid, ProviderName);
        }
        static private W3AuthTypeNotSupported IISAuthenticationAuthTypeNotSupportedTemplate(Action<W3AuthTypeNotSupported> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthTypeNotSupported(action, 10038, 1, "IISAuthentication", IISAuthenticationGuid, 12, "AUTH_TYPE_NOT_SUPPORTED", ProviderGuid, ProviderName);
        }
        static private W3AuthWDigestLogonFailed IISAuthenticationAuthWdigestLogonFailedTemplate(Action<W3AuthWDigestLogonFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3AuthWDigestLogonFailed(action, 10044, 1, "IISAuthentication", IISAuthenticationGuid, 18, "AUTH_WDIGEST_LOGON_FAILED", ProviderGuid, ProviderName);
        }
        static private W3CacheFileCacheAccessEnd IISCacheFileCacheAccessEndTemplate(Action<W3CacheFileCacheAccessEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CacheFileCacheAccessEnd(action, 10148, 10, "IISCache", IISCacheGuid, 11, "FILE_CACHE_ACCESS_END", ProviderGuid, ProviderName);
        }
        static private W3CacheFileCacheAccessStart IISCacheFileCacheAccessStartTemplate(Action<W3CacheFileCacheAccessStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CacheFileCacheAccessStart(action, 10147, 10, "IISCache", IISCacheGuid, 10, "FILE_CACHE_ACCESS_START", ProviderGuid, ProviderName);
        }
        static private W3CacheHttpsysCacheable IISCacheHttpsysCacheableTemplate(Action<W3CacheHttpsysCacheable> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CacheHttpsysCacheable(action, 10151, 10, "IISCache", IISCacheGuid, 14, "HTTPSYS_CACHEABLE", ProviderGuid, ProviderName);
        }
        static private W3OutputCacheDisabled IISCacheOutputCacheDisabledTemplate(Action<W3OutputCacheDisabled> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3OutputCacheDisabled(action, 10156, 10, "IISCache", IISCacheGuid, 19, "OUTPUT_CACHE_DISABLED", ProviderGuid, ProviderName);
        }
        static private W3OutputCacheLookupEnd IISCacheOutputCacheLookupEndTemplate(Action<W3OutputCacheLookupEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3OutputCacheLookupEnd(action, 10153, 10, "IISCache", IISCacheGuid, 16, "OUTPUT_CACHE_LOOKUP_END", ProviderGuid, ProviderName);
        }
        static private W3OutputCacheLookupStart IISCacheOutputCacheLookupStartTemplate(Action<W3OutputCacheLookupStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3OutputCacheLookupStart(action, 10152, 10, "IISCache", IISCacheGuid, 15, "OUTPUT_CACHE_LOOKUP_START", ProviderGuid, ProviderName);
        }
        static private W3OutputCacheUpdateEnd IISCacheOutputCacheUpdateEndTemplate(Action<W3OutputCacheUpdateEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3OutputCacheUpdateEnd(action, 10155, 10, "IISCache", IISCacheGuid, 18, "OUTPUT_CACHE_UPDATE_END", ProviderGuid, ProviderName);
        }
        static private W3OutputCacheUpdateStart IISCacheOutputCacheUpdateStartTemplate(Action<W3OutputCacheUpdateStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3OutputCacheUpdateStart(action, 10154, 10, "IISCache", IISCacheGuid, 17, "OUTPUT_CACHE_UPDATE_START", ProviderGuid, ProviderName);
        }
        static private W3CacheURLCacheAccessEnd IISCacheUrlCacheAccessEndTemplate(Action<W3CacheURLCacheAccessEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CacheURLCacheAccessEnd(action, 10150, 10, "IISCache", IISCacheGuid, 13, "URL_CACHE_ACCESS_END", ProviderGuid, ProviderName);
        }
        static private W3CacheURLCacheAccessStart IISCacheUrlCacheAccessStartTemplate(Action<W3CacheURLCacheAccessStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CacheURLCacheAccessStart(action, 10149, 10, "IISCache", IISCacheGuid, 12, "URL_CACHE_ACCESS_START", ProviderGuid, ProviderName);
        }
        static private W3CGIEnd IISCGICgiEndTemplate(Action<W3CGIEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIEnd(action, 10091, 6, "IISCGI", IISCGIGuid, 2, "CGI_END", ProviderGuid, ProviderName);
        }
        static private W3CGIHeadersReceived IISCGICgiHeadersReceivedTemplate(Action<W3CGIHeadersReceived> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIHeadersReceived(action, 10096, 6, "IISCGI", IISCGIGuid, 7, "CGI_HEADERS_RECEIVED", ProviderGuid, ProviderName);
        }
        static private W3CGILaunch IISCGICgiLaunchTemplate(Action<W3CGILaunch> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGILaunch(action, 10092, 6, "IISCGI", IISCGIGuid, 3, "CGI_LAUNCH", ProviderGuid, ProviderName);
        }
        static private W3CGIPrematureTermination IISCGICgiPrematureTerminationTemplate(Action<W3CGIPrematureTermination> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIPrematureTermination(action, 10094, 6, "IISCGI", IISCGIGuid, 5, "CGI_PREMATURE_TERMINATION", ProviderGuid, ProviderName);
        }
        static private W3CGIRequestEntitySent IISCGICgiRequestEntitySentTemplate(Action<W3CGIRequestEntitySent> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIRequestEntitySent(action, 10095, 6, "IISCGI", IISCGIGuid, 6, "CGI_REQUEST_ENTITY_SENT", ProviderGuid, ProviderName);
        }
        static private W3CGIStart IISCGICgiStartTemplate(Action<W3CGIStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIStart(action, 10090, 6, "IISCGI", IISCGIGuid, 1, "CGI_START", ProviderGuid, ProviderName);
        }
        static private W3CGITimeout IISCGICgiTimeoutTemplate(Action<W3CGITimeout> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGITimeout(action, 10093, 6, "IISCGI", IISCGIGuid, 4, "CGI_TIMEOUT", ProviderGuid, ProviderName);
        }
        static private W3DynamicCompressionDo IISCompressionDynamicCompressionDoTemplate(Action<W3DynamicCompressionDo> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3DynamicCompressionDo(action, 10144, 9, "IISCompression", IISCompressionGuid, 9, "DYNAMIC_COMPRESSION_DO", ProviderGuid, ProviderName);
        }
        static private W3DynamicCompressionEnd IISCompressionDynamicCompressionEndTemplate(Action<W3DynamicCompressionEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3DynamicCompressionEnd(action, 10145, 9, "IISCompression", IISCompressionGuid, 10, "DYNAMIC_COMPRESSION_END", ProviderGuid, ProviderName);
        }
        static private W3DynamicCompressionNotSuccess IISCompressionDynamicCompressionNotSuccessTemplate(Action<W3DynamicCompressionNotSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3DynamicCompressionNotSuccess(action, 10143, 9, "IISCompression", IISCompressionGuid, 8, "DYNAMIC_COMPRESSION_NOT_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3DynamicCompressionStart IISCompressionDynamicCompressionStartTemplate(Action<W3DynamicCompressionStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3DynamicCompressionStart(action, 10141, 9, "IISCompression", IISCompressionGuid, 6, "DYNAMIC_COMPRESSION_START", ProviderGuid, ProviderName);
        }
        static private W3DynamicCompressionSuccess IISCompressionDynamicCompressionSuccessTemplate(Action<W3DynamicCompressionSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3DynamicCompressionSuccess(action, 10142, 9, "IISCompression", IISCompressionGuid, 7, "DYNAMIC_COMPRESSION_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3StaticCompressionCreateEnd IISCompressionStaticCompressionCreateEndTemplate(Action<W3StaticCompressionCreateEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3StaticCompressionCreateEnd(action, 10140, 9, "IISCompression", IISCompressionGuid, 5, "STATIC_COMPRESSION_CREATE_END", ProviderGuid, ProviderName);
        }
        static private W3StaticCompressionCreateStart IISCompressionStaticCompressionCreateStartTemplate(Action<W3StaticCompressionCreateStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3StaticCompressionCreateStart(action, 10139, 9, "IISCompression", IISCompressionGuid, 4, "STATIC_COMPRESSION_CREATE_START", ProviderGuid, ProviderName);
        }
        static private W3StaticCompressionEnd IISCompressionStaticCompressionEndTemplate(Action<W3StaticCompressionEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3StaticCompressionEnd(action, 10146, 9, "IISCompression", IISCompressionGuid, 11, "STATIC_COMPRESSION_END", ProviderGuid, ProviderName);
        }
        static private W3StaticCompressionNotSuccess IISCompressionStaticCompressionNotSuccessTemplate(Action<W3StaticCompressionNotSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3StaticCompressionNotSuccess(action, 10138, 9, "IISCompression", IISCompressionGuid, 3, "STATIC_COMPRESSION_NOT_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3StaticCompressionStart IISCompressionStaticCompressionStartTemplate(Action<W3StaticCompressionStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3StaticCompressionStart(action, 10136, 9, "IISCompression", IISCompressionGuid, 1, "STATIC_COMPRESSION_START", ProviderGuid, ProviderName);
        }
        static private W3StaticCompressionSuccess IISCompressionStaticCompressionSuccessTemplate(Action<W3StaticCompressionSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3StaticCompressionSuccess(action, 10137, 9, "IISCompression", IISCompressionGuid, 2, "STATIC_COMPRESSION_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3CGIFActivityTimeout IISFastCGIFastcgiActivityTimeoutTemplate(Action<W3CGIFActivityTimeout> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFActivityTimeout(action, 10097, 7, "IISFastCGI", IISFastCGIGuid, 1, "FASTCGI_ACTIVITY_TIMEOUT", ProviderGuid, ProviderName);
        }
        static private W3CGIFAddJobObjectFail IISFastCGIFastcgiAddJobobjectFailTemplate(Action<W3CGIFAddJobObjectFail> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFAddJobObjectFail(action, 10103, 7, "IISFastCGI", IISFastCGIGuid, 7, "FASTCGI_ADD_JOBOBJECT_FAIL", ProviderGuid, ProviderName);
        }
        static private W3CGIFAppMgrShutdown IISFastCGIFastcgiApplicationManagerShutdownTemplate(Action<W3CGIFAppMgrShutdown> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFAppMgrShutdown(action, 10104, 7, "IISFastCGI", IISFastCGIGuid, 8, "FASTCGI_APPLICATION_MANAGER_SHUTDOWN", ProviderGuid, ProviderName);
        }
        static private W3CGIFAssignProcess IISFastCGIFastcgiAssignProcessTemplate(Action<W3CGIFAssignProcess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFAssignProcess(action, 10113, 7, "IISFastCGI", IISFastCGIGuid, 17, "FASTCGI_ASSIGN_PROCESS", ProviderGuid, ProviderName);
        }
        static private W3CGIFEnd IISFastCGIFastcgiEndTemplate(Action<W3CGIFEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFEnd(action, 10115, 7, "IISFastCGI", IISFastCGIGuid, 19, "FASTCGI_END", ProviderGuid, ProviderName);
        }
        static private W3CGIFPathNotFound IISFastCGIFastcgiPathNotFoundTemplate(Action<W3CGIFPathNotFound> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFPathNotFound(action, 10101, 7, "IISFastCGI", IISFastCGIGuid, 5, "FASTCGI_PATH_NOT_FOUND", ProviderGuid, ProviderName);
        }
        static private W3CGIFQueueFull IISFastCGIFastcgiQueueFullTemplate(Action<W3CGIFQueueFull> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFQueueFull(action, 10105, 7, "IISFastCGI", IISFastCGIGuid, 9, "FASTCGI_QUEUE_FULL", ProviderGuid, ProviderName);
        }
        static private W3CGIFQueueRequest IISFastCGIFastcgiQueueRequestTemplate(Action<W3CGIFQueueRequest> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFQueueRequest(action, 10112, 7, "IISFastCGI", IISFastCGIGuid, 16, "FASTCGI_QUEUE_REQUEST", ProviderGuid, ProviderName);
        }
        static private W3CGIFRapidFailureProtection IISFastCGIFastcgiRapidFailureProtectionTemplate(Action<W3CGIFRapidFailureProtection> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFRapidFailureProtection(action, 10100, 7, "IISFastCGI", IISFastCGIGuid, 4, "FASTCGI_RAPID_FAILURE_PROTECTION", ProviderGuid, ProviderName);
        }
        static private W3CGIFRequestTimeout IISFastCGIFastcgiRequestTimeoutTemplate(Action<W3CGIFRequestTimeout> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFRequestTimeout(action, 10098, 7, "IISFastCGI", IISFastCGIGuid, 2, "FASTCGI_REQUEST_TIMEOUT", ProviderGuid, ProviderName);
        }
        static private W3CGIFResponseWritten IISFastCGIFastcgiResponseWrittenTemplate(Action<W3CGIFResponseWritten> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFResponseWritten(action, 10107, 7, "IISFastCGI", IISFastCGIGuid, 11, "FASTCGI_RESPONSE_WRITTEN", ProviderGuid, ProviderName);
        }
        static private W3CGIFScriptProcessorMissing IISFastCGIFastcgiScriptProcessorMissingTemplate(Action<W3CGIFScriptProcessorMissing> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFScriptProcessorMissing(action, 10102, 7, "IISFastCGI", IISFastCGIGuid, 6, "FASTCGI_SCRIPT_PROCESSOR_MISSING", ProviderGuid, ProviderName);
        }
        static private W3CGIFStart IISFastCGIFastcgiStartTemplate(Action<W3CGIFStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFStart(action, 10114, 7, "IISFastCGI", IISFastCGIGuid, 18, "FASTCGI_START", ProviderGuid, ProviderName);
        }
        static private W3CGIFTraceError IISFastCGIFastcgiStderrTraceErrorTemplate(Action<W3CGIFTraceError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFTraceError(action, 10109, 7, "IISFastCGI", IISFastCGIGuid, 13, "FASTCGI_STDERR_TRACE_ERROR", ProviderGuid, ProviderName);
        }
        static private W3CGIFTraceInfo IISFastCGIFastcgiStderrTraceInfoTemplate(Action<W3CGIFTraceInfo> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFTraceInfo(action, 10111, 7, "IISFastCGI", IISFastCGIGuid, 15, "FASTCGI_STDERR_TRACE_INFO", ProviderGuid, ProviderName);
        }
        static private W3CGIFTraceWarning IISFastCGIFastcgiStderrTraceWarningTemplate(Action<W3CGIFTraceWarning> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFTraceWarning(action, 10110, 7, "IISFastCGI", IISFastCGIGuid, 14, "FASTCGI_STDERR_TRACE_WARNING", ProviderGuid, ProviderName);
        }
        static private W3CGIFUnexpectedExit IISFastCGIFastcgiUnexpectedExitTemplate(Action<W3CGIFUnexpectedExit> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFUnexpectedExit(action, 10099, 7, "IISFastCGI", IISFastCGIGuid, 3, "FASTCGI_UNEXPECTED_EXIT", ProviderGuid, ProviderName);
        }
        static private W3CGIFUnknownError IISFastCGIFastcgiUnknownErrorTemplate(Action<W3CGIFUnknownError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFUnknownError(action, 10106, 7, "IISFastCGI", IISFastCGIGuid, 10, "FASTCGI_UNKNOWN_ERROR", ProviderGuid, ProviderName);
        }
        static private W3CGIFWaitingForResponse IISFastCGIFastcgiWaitingForResponseTemplate(Action<W3CGIFWaitingForResponse> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3CGIFWaitingForResponse(action, 10108, 7, "IISFastCGI", IISFastCGIGuid, 12, "FASTCGI_WAITING_FOR_RESPONSE", ProviderGuid, ProviderName);
        }
        static private W3FilterAccessDeniedEnd IISFilterFilterAccessDeniedEndTemplate(Action<W3FilterAccessDeniedEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAccessDeniedEnd(action, 10083, 3, "IISFilter", IISFilterGuid, 30, "FILTER_ACCESS_DENIED_END", ProviderGuid, ProviderName);
        }
        static private W3FilterAccessDeniedStart IISFilterFilterAccessDeniedStartTemplate(Action<W3FilterAccessDeniedStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAccessDeniedStart(action, 10082, 3, "IISFilter", IISFilterGuid, 29, "FILTER_ACCESS_DENIED_START", ProviderGuid, ProviderName);
        }
        static private W3FilterAddReqHeader IISFilterFilterAddReqHeaderTemplate(Action<W3FilterAddReqHeader> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAddReqHeader(action, 10085, 3, "IISFilter", IISFilterGuid, 32, "FILTER_ADD_REQ_HEADER", ProviderGuid, ProviderName);
        }
        static private W3FilterAddRespHeader IISFilterFilterAddRespHeaderTemplate(Action<W3FilterAddRespHeader> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAddRespHeader(action, 10087, 3, "IISFilter", IISFilterGuid, 34, "FILTER_ADD_RESP_HEADER", ProviderGuid, ProviderName);
        }
        static private W3FilterAuthCompleteEnd IISFilterFilterAuthCompleteEndTemplate(Action<W3FilterAuthCompleteEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAuthCompleteEnd(action, 10073, 3, "IISFilter", IISFilterGuid, 20, "FILTER_AUTH_COMPLETE_END", ProviderGuid, ProviderName);
        }
        static private W3FilterAuthCompleteStart IISFilterFilterAuthCompleteStartTemplate(Action<W3FilterAuthCompleteStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAuthCompleteStart(action, 10072, 3, "IISFilter", IISFilterGuid, 19, "FILTER_AUTH_COMPLETE_START", ProviderGuid, ProviderName);
        }
        static private W3FilterAuthenticationEnd IISFilterFilterAuthenticationEndTemplate(Action<W3FilterAuthenticationEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAuthenticationEnd(action, 10071, 3, "IISFilter", IISFilterGuid, 18, "FILTER_AUTHENTICATION_END", ProviderGuid, ProviderName);
        }
        static private W3FilterAuthenticationStart IISFilterFilterAuthenticationStartTemplate(Action<W3FilterAuthenticationStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterAuthenticationStart(action, 10070, 3, "IISFilter", IISFilterGuid, 17, "FILTER_AUTHENTICATION_START", ProviderGuid, ProviderName);
        }
        static private W3FilterEnd IISFilterFilterEndTemplate(Action<W3FilterEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterEnd(action, 10064, 3, "IISFilter", IISFilterGuid, 2, "FILTER_END", ProviderGuid, ProviderName);
        }
        static private W3FilterEndOfRequestEnd IISFilterFilterEndOfRequestEndTemplate(Action<W3FilterEndOfRequestEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterEndOfRequestEnd(action, 10077, 3, "IISFilter", IISFilterGuid, 24, "FILTER_END_OF_REQUEST_END", ProviderGuid, ProviderName);
        }
        static private W3FilterEndOfRequestStart IISFilterFilterEndOfRequestStartTemplate(Action<W3FilterEndOfRequestStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterEndOfRequestStart(action, 10076, 3, "IISFilter", IISFilterGuid, 23, "FILTER_END_OF_REQUEST_START", ProviderGuid, ProviderName);
        }
        static private W3FilterError IISFilterFilterErrorTemplate(Action<W3FilterError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterError(action, 10065, 3, "IISFilter", IISFilterGuid, 12, "FILTER_ERROR", ProviderGuid, ProviderName);
        }
        static private W3FilterLogEnd IISFilterFilterLogEndTemplate(Action<W3FilterLogEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterLogEnd(action, 10079, 3, "IISFilter", IISFilterGuid, 26, "FILTER_LOG_END", ProviderGuid, ProviderName);
        }
        static private W3FilterLogStart IISFilterFilterLogStartTemplate(Action<W3FilterLogStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterLogStart(action, 10078, 3, "IISFilter", IISFilterGuid, 25, "FILTER_LOG_START", ProviderGuid, ProviderName);
        }
        static private W3FilterPreprocEnd IISFilterFilterPreprocHeadersEndTemplate(Action<W3FilterPreprocEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterPreprocEnd(action, 10067, 3, "IISFilter", IISFilterGuid, 14, "FILTER_PREPROC_HEADERS_END", ProviderGuid, ProviderName);
        }
        static private W3FilterPreprocStart IISFilterFilterPreprocHeadersStartTemplate(Action<W3FilterPreprocStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterPreprocStart(action, 10066, 3, "IISFilter", IISFilterGuid, 13, "FILTER_PREPROC_HEADERS_START", ProviderGuid, ProviderName);
        }
        static private W3FilterSendRawDataEnd IISFilterFilterSendRawDataEndTemplate(Action<W3FilterSendRawDataEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterSendRawDataEnd(action, 10081, 3, "IISFilter", IISFilterGuid, 28, "FILTER_SEND_RAW_DATA_END", ProviderGuid, ProviderName);
        }
        static private W3FilterSendRawDataStart IISFilterFilterSendRawDataStartTemplate(Action<W3FilterSendRawDataStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterSendRawDataStart(action, 10080, 3, "IISFilter", IISFilterGuid, 27, "FILTER_SEND_RAW_DATA_START", ProviderGuid, ProviderName);
        }
        static private W3FilterSendResponseEnd IISFilterFilterSendResponseEndTemplate(Action<W3FilterSendResponseEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterSendResponseEnd(action, 10075, 3, "IISFilter", IISFilterGuid, 22, "FILTER_SEND_RESPONSE_END", ProviderGuid, ProviderName);
        }
        static private W3FilterSendResponseStart IISFilterFilterSendResponseStartTemplate(Action<W3FilterSendResponseStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterSendResponseStart(action, 10074, 3, "IISFilter", IISFilterGuid, 21, "FILTER_SEND_RESPONSE_START", ProviderGuid, ProviderName);
        }
        static private W3FilterSetReqHeader IISFilterFilterSetReqHeaderTemplate(Action<W3FilterSetReqHeader> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterSetReqHeader(action, 10084, 3, "IISFilter", IISFilterGuid, 31, "FILTER_SET_REQ_HEADER", ProviderGuid, ProviderName);
        }
        static private W3FilterSetRespHeader IISFilterFilterSetRespHeaderTemplate(Action<W3FilterSetRespHeader> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterSetRespHeader(action, 10086, 3, "IISFilter", IISFilterGuid, 33, "FILTER_SET_RESP_HEADER", ProviderGuid, ProviderName);
        }
        static private W3FilterStart IISFilterFilterStartTemplate(Action<W3FilterStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterStart(action, 10063, 3, "IISFilter", IISFilterGuid, 1, "FILTER_START", ProviderGuid, ProviderName);
        }
        static private W3FilterURLMapEnd IISFilterFilterUrlMapEndTemplate(Action<W3FilterURLMapEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterURLMapEnd(action, 10069, 3, "IISFilter", IISFilterGuid, 16, "FILTER_URL_MAP_END", ProviderGuid, ProviderName);
        }
        static private W3FilterURLMapStart IISFilterFilterUrlMapStartTemplate(Action<W3FilterURLMapStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3FilterURLMapStart(action, 10068, 3, "IISFilter", IISFilterGuid, 15, "FILTER_URL_MAP_START", ProviderGuid, ProviderName);
        }
        static private IISGeneralConfigChangeNotification IISGeneralConfigChangeNotificationTemplate(Action<IISGeneralConfigChangeNotification> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralConfigChangeNotification(action, 10020, 0, "IISGeneral", IISGeneralGuid, 40, "CONFIG_CHANGE_NOTIFICATION", ProviderGuid, ProviderName);
        }
        static private IISGeneralFileChangeNotification IISGeneralFileChangeNotificationTemplate(Action<IISGeneralFileChangeNotification> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralFileChangeNotification(action, 10019, 0, "IISGeneral", IISGeneralGuid, 39, "FILE_CHANGE_NOTIFICATION", ProviderGuid, ProviderName);
        }
        static private W3GeneralCGIHandler IISGeneralGeneralCgiHandlerTemplate(Action<W3GeneralCGIHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralCGIHandler(action, 10003, 0, "IISGeneral", IISGeneralGuid, 11, "GENERAL_CGI_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralChildRequestEnd IISGeneralGeneralChildRequestEndTemplate(Action<W3GeneralChildRequestEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralChildRequestEnd(action, 10012, 0, "IISGeneral", IISGeneralGuid, 32, "GENERAL_CHILD_REQUEST_END", ProviderGuid, ProviderName);
        }
        static private W3GeneralChildRequestStart IISGeneralGeneralChildRequestStartTemplate(Action<W3GeneralChildRequestStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralChildRequestStart(action, 10011, 0, "IISGeneral", IISGeneralGuid, 31, "GENERAL_CHILD_REQUEST_START", ProviderGuid, ProviderName);
        }
        static private W3GeneralDavHandler IISGeneralGeneralDavHandlerTemplate(Action<W3GeneralDavHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralDavHandler(action, 10007, 0, "IISGeneral", IISGeneralGuid, 15, "GENERAL_DAV_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralEndpointInformation IISGeneralGeneralEndpointInformationTemplate(Action<W3GeneralEndpointInformation> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralEndpointInformation(action, 10035, 0, "IISGeneral", IISGeneralGuid, 55, "GENERAL_ENDPOINT_INFORMATION", ProviderGuid, ProviderName);
        }
        static private W3GeneralFlushResponseEnd IISGeneralGeneralFlushResponseEndTemplate(Action<W3GeneralFlushResponseEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralFlushResponseEnd(action, 10016, 0, "IISGeneral", IISGeneralGuid, 36, "GENERAL_FLUSH_RESPONSE_END", ProviderGuid, ProviderName);
        }
        static private W3GeneralFlushResponseStart IISGeneralGeneralFlushResponseStartTemplate(Action<W3GeneralFlushResponseStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralFlushResponseStart(action, 10015, 0, "IISGeneral", IISGeneralGuid, 35, "GENERAL_FLUSH_RESPONSE_START", ProviderGuid, ProviderName);
        }
        static private W3GeneralGetURLMetadata IISGeneralGeneralGetUrlMetadataTemplate(Action<W3GeneralGetURLMetadata> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralGetURLMetadata(action, 10010, 0, "IISGeneral", IISGeneralGuid, 30, "GENERAL_GET_URL_METADATA", ProviderGuid, ProviderName);
        }
        static private W3GeneralISAPIHandler IISGeneralGeneralIsapiHandlerTemplate(Action<W3GeneralISAPIHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralISAPIHandler(action, 10004, 0, "IISGeneral", IISGeneralGuid, 12, "GENERAL_ISAPI_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralMapHandler IISGeneralGeneralMapHandlerTemplate(Action<W3GeneralMapHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralMapHandler(action, 10014, 0, "IISGeneral", IISGeneralGuid, 34, "GENERAL_MAP_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralModuleFactoryFailed IISGeneralGeneralModuleFactoryFailedTemplate(Action<W3GeneralModuleFactoryFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralModuleFactoryFailed(action, 10034, 0, "IISGeneral", IISGeneralGuid, 54, "GENERAL_MODULE_FACTORY_FAILED", ProviderGuid, ProviderName);
        }
        static private W3GeneralNotSendCustomError IISGeneralGeneralNotSendCustomErrorTemplate(Action<W3GeneralNotSendCustomError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralNotSendCustomError(action, 10032, 0, "IISGeneral", IISGeneralGuid, 52, "GENERAL_NOT_SEND_CUSTOM_ERROR", ProviderGuid, ProviderName);
        }
        static private W3GeneralOopISAPIHandler IISGeneralGeneralOopIsapiHandlerTemplate(Action<W3GeneralOopISAPIHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralOopISAPIHandler(action, 10005, 0, "IISGeneral", IISGeneralGuid, 13, "GENERAL_OOP_ISAPI_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralOptionsHandler IISGeneralGeneralOptionsHandlerTemplate(Action<W3GeneralOptionsHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralOptionsHandler(action, 10008, 0, "IISGeneral", IISGeneralGuid, 16, "GENERAL_OPTIONS_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralReadEntityEnd IISGeneralGeneralReadEntityEndTemplate(Action<W3GeneralReadEntityEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralReadEntityEnd(action, 10018, 0, "IISGeneral", IISGeneralGuid, 38, "GENERAL_READ_ENTITY_END", ProviderGuid, ProviderName);
        }
        static private W3GeneralReadEntityStart IISGeneralGeneralReadEntityStartTemplate(Action<W3GeneralReadEntityStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralReadEntityStart(action, 10017, 0, "IISGeneral", IISGeneralGuid, 37, "GENERAL_READ_ENTITY_START", ProviderGuid, ProviderName);
        }
        static private W3GeneralRedirectionHandler IISGeneralGeneralRedirectionHandlerTemplate(Action<W3GeneralRedirectionHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralRedirectionHandler(action, 10006, 0, "IISGeneral", IISGeneralGuid, 14, "GENERAL_REDIRECTION_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralEndNewRequest IISGeneralGeneralRequestEndTemplate(Action<W3GeneralEndNewRequest> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralEndNewRequest(action, 10001, 0, "IISGeneral", IISGeneralGuid, 2, "GENERAL_REQUEST_END", ProviderGuid, ProviderName);
        }
        static private W3GeneralRequestEntity IISGeneralGeneralRequestEntityTemplate(Action<W3GeneralRequestEntity> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralRequestEntity(action, 10031, 0, "IISGeneral", IISGeneralGuid, 51, "GENERAL_REQUEST_ENTITY", ProviderGuid, ProviderName);
        }
        static private W3GeneralRequestHeaders IISGeneralGeneralRequestHeadersTemplate(Action<W3GeneralRequestHeaders> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralRequestHeaders(action, 10030, 0, "IISGeneral", IISGeneralGuid, 50, "GENERAL_REQUEST_HEADERS", ProviderGuid, ProviderName);
        }
        static private W3GeneralStartNewRequest IISGeneralGeneralRequestStartTemplate(Action<W3GeneralStartNewRequest> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralStartNewRequest(action, 10000, 0, "IISGeneral", IISGeneralGuid, 1, "GENERAL_REQUEST_START", ProviderGuid, ProviderName);
        }
        static private W3GeneralResponseEntityBuffer IISGeneralGeneralResponseEntityBufferTemplate(Action<W3GeneralResponseEntityBuffer> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralResponseEntityBuffer(action, 10029, 0, "IISGeneral", IISGeneralGuid, 49, "GENERAL_RESPONSE_ENTITY_BUFFER", ProviderGuid, ProviderName);
        }
        static private W3GeneralResponseEntityFile IISGeneralGeneralResponseEntityFileTemplate(Action<W3GeneralResponseEntityFile> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralResponseEntityFile(action, 10028, 0, "IISGeneral", IISGeneralGuid, 48, "GENERAL_RESPONSE_ENTITY_FILE", ProviderGuid, ProviderName);
        }
        static private W3GeneralResponseHeaders IISGeneralGeneralResponseHeadersTemplate(Action<W3GeneralResponseHeaders> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralResponseHeaders(action, 10027, 0, "IISGeneral", IISGeneralGuid, 47, "GENERAL_RESPONSE_HEADERS", ProviderGuid, ProviderName);
        }
        static private W3GeneralSendCustomError IISGeneralGeneralSendCustomErrorTemplate(Action<W3GeneralSendCustomError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralSendCustomError(action, 10013, 0, "IISGeneral", IISGeneralGuid, 33, "GENERAL_SEND_CUSTOM_ERROR", ProviderGuid, ProviderName);
        }
        static private W3GeneralSetRequestHeader IISGeneralGeneralSetRequestHeaderTemplate(Action<W3GeneralSetRequestHeader> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralSetRequestHeader(action, 10033, 0, "IISGeneral", IISGeneralGuid, 53, "GENERAL_SET_REQUEST_HEADER", ProviderGuid, ProviderName);
        }
        static private W3GeneralStaticFileHandler IISGeneralGeneralStaticFileHandlerTemplate(Action<W3GeneralStaticFileHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralStaticFileHandler(action, 10002, 0, "IISGeneral", IISGeneralGuid, 10, "GENERAL_STATIC_FILE_HANDLER", ProviderGuid, ProviderName);
        }
        static private W3GeneralTraceHandler IISGeneralGeneralTraceHandlerTemplate(Action<W3GeneralTraceHandler> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3GeneralTraceHandler(action, 10009, 0, "IISGeneral", IISGeneralGuid, 17, "GENERAL_TRACE_HANDLER", ProviderGuid, ProviderName);
        }
        static private IISGeneralHandlerChanged IISGeneralHandlerChangedTemplate(Action<IISGeneralHandlerChanged> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralHandlerChanged(action, 10023, 0, "IISGeneral", IISGeneralGuid, 43, "HANDLER_CHANGED", ProviderGuid, ProviderName);
        }
        static private IISGeneralHandlerPreconditionNotMatch IISGeneralHandlerPreconditionNotMatchTemplate(Action<IISGeneralHandlerPreconditionNotMatch> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralHandlerPreconditionNotMatch(action, 10026, 0, "IISGeneral", IISGeneralGuid, 46, "HANDLER_PRECONDITION_NOT_MATCH", ProviderGuid, ProviderName);
        }
        static private IISGeneralModulePreconditionNotMatch IISGeneralModulePreconditionNotMatchTemplate(Action<IISGeneralModulePreconditionNotMatch> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralModulePreconditionNotMatch(action, 10025, 0, "IISGeneral", IISGeneralGuid, 45, "MODULE_PRECONDITION_NOT_MATCH", ProviderGuid, ProviderName);
        }
        static private IISGeneralUrlChanged IISGeneralUrlChangedTemplate(Action<IISGeneralUrlChanged> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralUrlChanged(action, 10022, 0, "IISGeneral", IISGeneralGuid, 42, "URL_CHANGED", ProviderGuid, ProviderName);
        }
        static private IISGeneralUserSet IISGeneralUserSetTemplate(Action<IISGeneralUserSet> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralUserSet(action, 10024, 0, "IISGeneral", IISGeneralGuid, 44, "USER_SET", ProviderGuid, ProviderName);
        }
        static private IISGeneralVirtualModuleUnresolved IISGeneralVirtualModuleUnresolvedTemplate(Action<IISGeneralVirtualModuleUnresolved> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISGeneralVirtualModuleUnresolved(action, 10021, 0, "IISGeneral", IISGeneralGuid, 41, "VIRTUAL_MODULE_UNRESOLVED", ProviderGuid, ProviderName);
        }
        static private W3ISAPIEnd IISISAPIIsapiEndTemplate(Action<W3ISAPIEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3ISAPIEnd(action, 10089, 5, "IISISAPI", IISISAPIGuid, 2, "ISAPI_END", ProviderGuid, ProviderName);
        }
        static private W3ISAPIStart IISISAPIIsapiStartTemplate(Action<W3ISAPIStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3ISAPIStart(action, 10088, 5, "IISISAPI", IISISAPIGuid, 1, "ISAPI_START", ProviderGuid, ProviderName);
        }
        static private IISModuleEventsModuleCriticalError IISModuleModuleCriticalErrorTemplate(Action<IISModuleEventsModuleCriticalError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISModuleEventsModuleCriticalError(action, 10168, 12, "IISModule", IISModuleGuid, 3, "MODULE_CRITICAL_ERROR", ProviderGuid, ProviderName);
        }
        static private IISModuleEventsModuleEnd IISModuleModuleEndTemplate(Action<IISModuleEventsModuleEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISModuleEventsModuleEnd(action, 10167, 12, "IISModule", IISModuleGuid, 2, "MODULE_END", ProviderGuid, ProviderName);
        }
        static private IISModuleEventsModuleError IISModuleModuleErrorTemplate(Action<IISModuleEventsModuleError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISModuleEventsModuleError(action, 10169, 12, "IISModule", IISModuleGuid, 4, "MODULE_ERROR", ProviderGuid, ProviderName);
        }
        static private IISModuleEventsModuleInformation IISModuleModuleInformationTemplate(Action<IISModuleEventsModuleInformation> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISModuleEventsModuleInformation(action, 10171, 12, "IISModule", IISModuleGuid, 6, "MODULE_INFORMATION", ProviderGuid, ProviderName);
        }
        static private IISModuleEventsModuleStart IISModuleModuleStartTemplate(Action<IISModuleEventsModuleStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISModuleEventsModuleStart(action, 10166, 12, "IISModule", IISModuleGuid, 1, "MODULE_START", ProviderGuid, ProviderName);
        }
        static private IISModuleEventsModuleVerbose IISModuleModuleVerboseTemplate(Action<IISModuleEventsModuleVerbose> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISModuleEventsModuleVerbose(action, 10172, 12, "IISModule", IISModuleGuid, 7, "MODULE_VERBOSE", ProviderGuid, ProviderName);
        }
        static private IISModuleEventsModuleWarning IISModuleModuleWarningTemplate(Action<IISModuleEventsModuleWarning> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISModuleEventsModuleWarning(action, 10170, 12, "IISModule", IISModuleGuid, 5, "MODULE_WARNING", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationEventsResponseErrorStatus IISRequestNotificationModuleSetResponseErrorStatusTemplate(Action<IISRequestNotificationEventsResponseErrorStatus> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationEventsResponseErrorStatus(action, 10163, 11, "IISRequestNotification", IISRequestNotificationGuid, 16, "MODULE_SET_RESPONSE_ERROR_STATUS", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationEventsResponseSuccessStatus IISRequestNotificationModuleSetResponseSuccessStatusTemplate(Action<IISRequestNotificationEventsResponseSuccessStatus> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationEventsResponseSuccessStatus(action, 10164, 11, "IISRequestNotification", IISRequestNotificationGuid, 17, "MODULE_SET_RESPONSE_SUCCESS_STATUS", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationEventsCompletion IISRequestNotificationNotifyModuleCompletionTemplate(Action<IISRequestNotificationEventsCompletion> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationEventsCompletion(action, 10159, 11, "IISRequestNotification", IISRequestNotificationGuid, 3, "NOTIFY_MODULE_COMPLETION", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationEventsEnd IISRequestNotificationNotifyModuleEndTemplate(Action<IISRequestNotificationEventsEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationEventsEnd(action, 10158, 11, "IISRequestNotification", IISRequestNotificationGuid, 2, "NOTIFY_MODULE_END", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationEventsStart IISRequestNotificationNotifyModuleStartTemplate(Action<IISRequestNotificationEventsStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationEventsStart(action, 10157, 11, "IISRequestNotification", IISRequestNotificationGuid, 1, "NOTIFY_MODULE_START", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationPreBeginEnd IISRequestNotificationPreBeginRequestEndTemplate(Action<IISRequestNotificationPreBeginEnd> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationPreBeginEnd(action, 10161, 11, "IISRequestNotification", IISRequestNotificationGuid, 5, "PRE_BEGIN_REQUEST_END", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationPreBeginStart IISRequestNotificationPreBeginRequestStartTemplate(Action<IISRequestNotificationPreBeginStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationPreBeginStart(action, 10160, 11, "IISRequestNotification", IISRequestNotificationGuid, 4, "PRE_BEGIN_REQUEST_START", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationEventsError IISRequestNotificationRequestProcessingErrorTemplate(Action<IISRequestNotificationEventsError> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationEventsError(action, 10162, 11, "IISRequestNotification", IISRequestNotificationGuid, 15, "REQUEST_PROCESSING_ERROR", ProviderGuid, ProviderName);
        }
        static private IISRequestNotificationEventsResponseErrorDescription IISRequestNotificationSetResponseErrorDescriptionTemplate(Action<IISRequestNotificationEventsResponseErrorDescription> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IISRequestNotificationEventsResponseErrorDescription(action, 10165, 11, "IISRequestNotification", IISRequestNotificationGuid, 18, "SET_RESPONSE_ERROR_DESCRIPTION", ProviderGuid, ProviderName);
        }
        static private W3SecDeniedByAccessFlags IISSecuritySecurityDeniedByAccessFlagsTemplate(Action<W3SecDeniedByAccessFlags> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecDeniedByAccessFlags(action, 10062, 2, "IISSecurity", IISSecurityGuid, 18, "SECURITY_DENIED_BY_ACCESS_FLAGS", ProviderGuid, ProviderName);
        }
        static private W3SecDeniedByCGIRestriction IISSecuritySecurityDeniedByCgiRestrictionTemplate(Action<W3SecDeniedByCGIRestriction> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecDeniedByCGIRestriction(action, 10061, 2, "IISSecurity", IISSecurityGuid, 17, "SECURITY_DENIED_BY_CGI_RESTRICTION", ProviderGuid, ProviderName);
        }
        static private W3SecDeniedByISAPIRestriction IISSecuritySecurityDeniedByIsapiRestrictionTemplate(Action<W3SecDeniedByISAPIRestriction> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecDeniedByISAPIRestriction(action, 10060, 2, "IISSecurity", IISSecurityGuid, 16, "SECURITY_DENIED_BY_ISAPI_RESTRICTION", ProviderGuid, ProviderName);
        }
        static private W3SecDeniedByMimemap IISSecuritySecurityDeniedByMimemapTemplate(Action<W3SecDeniedByMimemap> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecDeniedByMimemap(action, 10059, 2, "IISSecurity", IISSecurityGuid, 15, "SECURITY_DENIED_BY_MIMEMAP", ProviderGuid, ProviderName);
        }
        static private W3SecFileAccessDenied IISSecuritySecurityFileAccessDeniedTemplate(Action<W3SecFileAccessDenied> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecFileAccessDenied(action, 10058, 2, "IISSecurity", IISSecurityGuid, 14, "SECURITY_FILE_ACCESS_DENIED", ProviderGuid, ProviderName);
        }
        static private W3SecIllegalShortFilename IISSecuritySecurityIllegalShortFilenameTemplate(Action<W3SecIllegalShortFilename> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecIllegalShortFilename(action, 10054, 2, "IISSecurity", IISSecurityGuid, 10, "SECURITY_ILLEGAL_SHORT_FILENAME", ProviderGuid, ProviderName);
        }
        static private W3SecRejectedHostname IISSecuritySecurityRejectedHostnameTemplate(Action<W3SecRejectedHostname> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecRejectedHostname(action, 10056, 2, "IISSecurity", IISSecurityGuid, 12, "SECURITY_REJECTED_HOSTNAME", ProviderGuid, ProviderName);
        }
        static private W3SecRejectedIP IISSecuritySecurityRejectedIpTemplate(Action<W3SecRejectedIP> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecRejectedIP(action, 10055, 2, "IISSecurity", IISSecurityGuid, 11, "SECURITY_REJECTED_IP", ProviderGuid, ProviderName);
        }
        static private W3SecRequireSSL128 IISSecuritySecurityRejectedRequireSsl128Template(Action<W3SecRequireSSL128> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3SecRequireSSL128(action, 10057, 2, "IISSecurity", IISSecurityGuid, 13, "SECURITY_REJECTED_REQUIRE_SSL_128", ProviderGuid, ProviderName);
        }
        static private W3WebSocketApplicationCloseConnection IISWebSocketWebsocketApplicationCloseConnectionTemplate(Action<W3WebSocketApplicationCloseConnection> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketApplicationCloseConnection(action, 10128, 8, "IISWebSocket", IISWebSocketGuid, 13, "WEBSOCKET_APPLICATION_CLOSE_CONNECTION", ProviderGuid, ProviderName);
        }
        static private W3WebSocketEndFailure IISWebSocketWebsocketHandshakeNotSuccessTemplate(Action<W3WebSocketEndFailure> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketEndFailure(action, 10119, 8, "IISWebSocket", IISWebSocketGuid, 4, "WEBSOCKET_HANDSHAKE_NOT_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketStart IISWebSocketWebsocketHandshakeStartTemplate(Action<W3WebSocketStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketStart(action, 10117, 8, "IISWebSocket", IISWebSocketGuid, 2, "WEBSOCKET_HANDSHAKE_START", ProviderGuid, ProviderName);
        }
        static private W3WebSocketEndSuccess IISWebSocketWebsocketHandshakeSuccessTemplate(Action<W3WebSocketEndSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketEndSuccess(action, 10118, 8, "IISWebSocket", IISWebSocketGuid, 3, "WEBSOCKET_HANDSHAKE_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketInitializeNotSuccess IISWebSocketWebsocketInitializeFailedTemplate(Action<W3WebSocketInitializeNotSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketInitializeNotSuccess(action, 10116, 8, "IISWebSocket", IISWebSocketGuid, 1, "WEBSOCKET_INITIALIZE_FAILED", ProviderGuid, ProviderName);
        }
        static private W3WebSocketModuleCloseConnection IISWebSocketWebsocketModuleCloseConnectionTemplate(Action<W3WebSocketModuleCloseConnection> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketModuleCloseConnection(action, 10129, 8, "IISWebSocket", IISWebSocketGuid, 14, "WEBSOCKET_MODULE_CLOSE_CONNECTION", ProviderGuid, ProviderName);
        }
        static private W3WebSocketReadFragmentEndFailure IISWebSocketWebsocketReadFragmentEndNotSuccessTemplate(Action<W3WebSocketReadFragmentEndFailure> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketReadFragmentEndFailure(action, 10123, 8, "IISWebSocket", IISWebSocketGuid, 8, "WEBSOCKET_READ_FRAGMENT_END_NOT_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketReadFragmentEndPending IISWebSocketWebsocketReadFragmentEndPendingTemplate(Action<W3WebSocketReadFragmentEndPending> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketReadFragmentEndPending(action, 10121, 8, "IISWebSocket", IISWebSocketGuid, 6, "WEBSOCKET_READ_FRAGMENT_END_PENDING", ProviderGuid, ProviderName);
        }
        static private W3WebSocketReadFragmentEndSuccess IISWebSocketWebsocketReadFragmentEndSuccessTemplate(Action<W3WebSocketReadFragmentEndSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketReadFragmentEndSuccess(action, 10122, 8, "IISWebSocket", IISWebSocketGuid, 7, "WEBSOCKET_READ_FRAGMENT_END_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketReadFragmentStart IISWebSocketWebsocketReadFragmentStartTemplate(Action<W3WebSocketReadFragmentStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketReadFragmentStart(action, 10120, 8, "IISWebSocket", IISWebSocketGuid, 5, "WEBSOCKET_READ_FRAGMENT_START", ProviderGuid, ProviderName);
        }
        static private W3WebSocketReadIoFailed IISWebSocketWebsocketReadIoNotSuccessTemplate(Action<W3WebSocketReadIoFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketReadIoFailed(action, 10130, 8, "IISWebSocket", IISWebSocketGuid, 15, "WEBSOCKET_READ_IO_NOT_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketCloseReceived IISWebSocketWebsocketReceivedCloseTemplate(Action<W3WebSocketCloseReceived> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketCloseReceived(action, 10132, 8, "IISWebSocket", IISWebSocketGuid, 17, "WEBSOCKET_RECEIVED_CLOSE", ProviderGuid, ProviderName);
        }
        static private W3WebSocketCloseSendFailure IISWebSocketWebsocketSendCloseEndNotSuccessTemplate(Action<W3WebSocketCloseSendFailure> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketCloseSendFailure(action, 10135, 8, "IISWebSocket", IISWebSocketGuid, 20, "WEBSOCKET_SEND_CLOSE_END_NOT_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketCloseSendSuccess IISWebSocketWebsocketSendCloseEndSuccessTemplate(Action<W3WebSocketCloseSendSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketCloseSendSuccess(action, 10134, 8, "IISWebSocket", IISWebSocketGuid, 19, "WEBSOCKET_SEND_CLOSE_END_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketCloseSendStart IISWebSocketWebsocketSendCloseStartTemplate(Action<W3WebSocketCloseSendStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketCloseSendStart(action, 10133, 8, "IISWebSocket", IISWebSocketGuid, 18, "WEBSOCKET_SEND_CLOSE_START", ProviderGuid, ProviderName);
        }
        static private W3WebSocketWriteFragmentEndFailure IISWebSocketWebsocketWriteFragmentEndNotSuccessTemplate(Action<W3WebSocketWriteFragmentEndFailure> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketWriteFragmentEndFailure(action, 10127, 8, "IISWebSocket", IISWebSocketGuid, 12, "WEBSOCKET_WRITE_FRAGMENT_END_NOT_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketWriteFragmentEndPending IISWebSocketWebsocketWriteFragmentEndPendingTemplate(Action<W3WebSocketWriteFragmentEndPending> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketWriteFragmentEndPending(action, 10125, 8, "IISWebSocket", IISWebSocketGuid, 10, "WEBSOCKET_WRITE_FRAGMENT_END_PENDING", ProviderGuid, ProviderName);
        }
        static private W3WebSocketWriteFragmentEndSuccess IISWebSocketWebsocketWriteFragmentEndSuccessTemplate(Action<W3WebSocketWriteFragmentEndSuccess> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketWriteFragmentEndSuccess(action, 10126, 8, "IISWebSocket", IISWebSocketGuid, 11, "WEBSOCKET_WRITE_FRAGMENT_END_SUCCESS", ProviderGuid, ProviderName);
        }
        static private W3WebSocketWriteFragmentStart IISWebSocketWebsocketWriteFragmentStartTemplate(Action<W3WebSocketWriteFragmentStart> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketWriteFragmentStart(action, 10124, 8, "IISWebSocket", IISWebSocketGuid, 9, "WEBSOCKET_WRITE_FRAGMENT_START", ProviderGuid, ProviderName);
        }
        static private W3WebSocketWriteIoFailed IISWebSocketWebsocketWriteIoNotSuccessTemplate(Action<W3WebSocketWriteIoFailed> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new W3WebSocketWriteIoFailed(action, 10131, 8, "IISWebSocket", IISWebSocketGuid, 16, "WEBSOCKET_WRITE_IO_NOT_SUCCESS", ProviderGuid, ProviderName);
        }

        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[173];
                templates[0] = IISGeneralGeneralRequestStartTemplate(null);
                templates[1] = IISGeneralGeneralRequestEndTemplate(null);
                templates[2] = IISGeneralGeneralStaticFileHandlerTemplate(null);
                templates[3] = IISGeneralGeneralCgiHandlerTemplate(null);
                templates[4] = IISGeneralGeneralIsapiHandlerTemplate(null);
                templates[5] = IISGeneralGeneralOopIsapiHandlerTemplate(null);
                templates[6] = IISGeneralGeneralRedirectionHandlerTemplate(null);
                templates[7] = IISGeneralGeneralDavHandlerTemplate(null);
                templates[8] = IISGeneralGeneralOptionsHandlerTemplate(null);
                templates[9] = IISGeneralGeneralTraceHandlerTemplate(null);
                templates[10] = IISGeneralGeneralGetUrlMetadataTemplate(null);
                templates[11] = IISGeneralGeneralChildRequestStartTemplate(null);
                templates[12] = IISGeneralGeneralChildRequestEndTemplate(null);
                templates[13] = IISGeneralGeneralSendCustomErrorTemplate(null);
                templates[14] = IISGeneralGeneralMapHandlerTemplate(null);
                templates[15] = IISGeneralGeneralFlushResponseStartTemplate(null);
                templates[16] = IISGeneralGeneralFlushResponseEndTemplate(null);
                templates[17] = IISGeneralGeneralReadEntityStartTemplate(null);
                templates[18] = IISGeneralGeneralReadEntityEndTemplate(null);
                templates[19] = IISGeneralFileChangeNotificationTemplate(null);
                templates[20] = IISGeneralConfigChangeNotificationTemplate(null);
                templates[21] = IISGeneralVirtualModuleUnresolvedTemplate(null);
                templates[22] = IISGeneralUrlChangedTemplate(null);
                templates[23] = IISGeneralHandlerChangedTemplate(null);
                templates[24] = IISGeneralUserSetTemplate(null);
                templates[25] = IISGeneralModulePreconditionNotMatchTemplate(null);
                templates[26] = IISGeneralHandlerPreconditionNotMatchTemplate(null);
                templates[27] = IISGeneralGeneralResponseHeadersTemplate(null);
                templates[28] = IISGeneralGeneralResponseEntityFileTemplate(null);
                templates[29] = IISGeneralGeneralResponseEntityBufferTemplate(null);
                templates[30] = IISGeneralGeneralRequestHeadersTemplate(null);
                templates[31] = IISGeneralGeneralRequestEntityTemplate(null);
                templates[32] = IISGeneralGeneralNotSendCustomErrorTemplate(null);
                templates[33] = IISGeneralGeneralSetRequestHeaderTemplate(null);
                templates[34] = IISGeneralGeneralModuleFactoryFailedTemplate(null);
                templates[35] = IISGeneralGeneralEndpointInformationTemplate(null);
                templates[36] = IISAuthenticationAuthStartTemplate(null);
                templates[37] = IISAuthenticationAuthSucceededTemplate(null);
                templates[38] = IISAuthenticationAuthTypeNotSupportedTemplate(null);
                templates[39] = IISAuthenticationAuthInvalidAnonAccountTemplate(null);
                templates[40] = IISAuthenticationAuthPasswdChangeNeededTemplate(null);
                templates[41] = IISAuthenticationAuthPasswdChangeDisabledTemplate(null);
                templates[42] = IISAuthenticationAuthBadBasicHeaderTemplate(null);
                templates[43] = IISAuthenticationAuthBasicLogonFailedTemplate(null);
                templates[44] = IISAuthenticationAuthWdigestLogonFailedTemplate(null);
                templates[45] = IISAuthenticationAuthIisdigestLogonFailedTemplate(null);
                templates[46] = IISAuthenticationAuthPassportLogonFailedTemplate(null);
                templates[47] = IISAuthenticationAuthSspiLogonFailedTemplate(null);
                templates[48] = IISAuthenticationAuthNtlmNullSessionTemplate(null);
                templates[49] = IISAuthenticationAuthSspiContinueNeededTemplate(null);
                templates[50] = IISAuthenticationAuthKerberosFailedTemplate(null);
                templates[51] = IISAuthenticationAuthAnonPasswdChangeNeededTemplate(null);
                templates[52] = IISAuthenticationAuthRequestAuthTypeTemplate(null);
                templates[53] = IISAuthenticationAuthEndTemplate(null);
                templates[54] = IISSecuritySecurityIllegalShortFilenameTemplate(null);
                templates[55] = IISSecuritySecurityRejectedIpTemplate(null);
                templates[56] = IISSecuritySecurityRejectedHostnameTemplate(null);
                templates[57] = IISSecuritySecurityRejectedRequireSsl128Template(null);
                templates[58] = IISSecuritySecurityFileAccessDeniedTemplate(null);
                templates[59] = IISSecuritySecurityDeniedByMimemapTemplate(null);
                templates[60] = IISSecuritySecurityDeniedByIsapiRestrictionTemplate(null);
                templates[61] = IISSecuritySecurityDeniedByCgiRestrictionTemplate(null);
                templates[62] = IISSecuritySecurityDeniedByAccessFlagsTemplate(null);
                templates[63] = IISFilterFilterStartTemplate(null);
                templates[64] = IISFilterFilterEndTemplate(null);
                templates[65] = IISFilterFilterErrorTemplate(null);
                templates[66] = IISFilterFilterPreprocHeadersStartTemplate(null);
                templates[67] = IISFilterFilterPreprocHeadersEndTemplate(null);
                templates[68] = IISFilterFilterUrlMapStartTemplate(null);
                templates[69] = IISFilterFilterUrlMapEndTemplate(null);
                templates[70] = IISFilterFilterAuthenticationStartTemplate(null);
                templates[71] = IISFilterFilterAuthenticationEndTemplate(null);
                templates[72] = IISFilterFilterAuthCompleteStartTemplate(null);
                templates[73] = IISFilterFilterAuthCompleteEndTemplate(null);
                templates[74] = IISFilterFilterSendResponseStartTemplate(null);
                templates[75] = IISFilterFilterSendResponseEndTemplate(null);
                templates[76] = IISFilterFilterEndOfRequestStartTemplate(null);
                templates[77] = IISFilterFilterEndOfRequestEndTemplate(null);
                templates[78] = IISFilterFilterLogStartTemplate(null);
                templates[79] = IISFilterFilterLogEndTemplate(null);
                templates[80] = IISFilterFilterSendRawDataStartTemplate(null);
                templates[81] = IISFilterFilterSendRawDataEndTemplate(null);
                templates[82] = IISFilterFilterAccessDeniedStartTemplate(null);
                templates[83] = IISFilterFilterAccessDeniedEndTemplate(null);
                templates[84] = IISFilterFilterSetReqHeaderTemplate(null);
                templates[85] = IISFilterFilterAddReqHeaderTemplate(null);
                templates[86] = IISFilterFilterSetRespHeaderTemplate(null);
                templates[87] = IISFilterFilterAddRespHeaderTemplate(null);
                templates[88] = IISISAPIIsapiStartTemplate(null);
                templates[89] = IISISAPIIsapiEndTemplate(null);
                templates[90] = IISCGICgiStartTemplate(null);
                templates[91] = IISCGICgiEndTemplate(null);
                templates[92] = IISCGICgiLaunchTemplate(null);
                templates[93] = IISCGICgiTimeoutTemplate(null);
                templates[94] = IISCGICgiPrematureTerminationTemplate(null);
                templates[95] = IISCGICgiRequestEntitySentTemplate(null);
                templates[96] = IISCGICgiHeadersReceivedTemplate(null);
                templates[97] = IISFastCGIFastcgiActivityTimeoutTemplate(null);
                templates[98] = IISFastCGIFastcgiRequestTimeoutTemplate(null);
                templates[99] = IISFastCGIFastcgiUnexpectedExitTemplate(null);
                templates[100] = IISFastCGIFastcgiRapidFailureProtectionTemplate(null);
                templates[101] = IISFastCGIFastcgiPathNotFoundTemplate(null);
                templates[102] = IISFastCGIFastcgiScriptProcessorMissingTemplate(null);
                templates[103] = IISFastCGIFastcgiAddJobobjectFailTemplate(null);
                templates[104] = IISFastCGIFastcgiApplicationManagerShutdownTemplate(null);
                templates[105] = IISFastCGIFastcgiQueueFullTemplate(null);
                templates[106] = IISFastCGIFastcgiUnknownErrorTemplate(null);
                templates[107] = IISFastCGIFastcgiResponseWrittenTemplate(null);
                templates[108] = IISFastCGIFastcgiWaitingForResponseTemplate(null);
                templates[109] = IISFastCGIFastcgiStderrTraceErrorTemplate(null);
                templates[110] = IISFastCGIFastcgiStderrTraceWarningTemplate(null);
                templates[111] = IISFastCGIFastcgiStderrTraceInfoTemplate(null);
                templates[112] = IISFastCGIFastcgiQueueRequestTemplate(null);
                templates[113] = IISFastCGIFastcgiAssignProcessTemplate(null);
                templates[114] = IISFastCGIFastcgiStartTemplate(null);
                templates[115] = IISFastCGIFastcgiEndTemplate(null);
                templates[116] = IISWebSocketWebsocketInitializeFailedTemplate(null);
                templates[117] = IISWebSocketWebsocketHandshakeStartTemplate(null);
                templates[118] = IISWebSocketWebsocketHandshakeSuccessTemplate(null);
                templates[119] = IISWebSocketWebsocketHandshakeNotSuccessTemplate(null);
                templates[120] = IISWebSocketWebsocketReadFragmentStartTemplate(null);
                templates[121] = IISWebSocketWebsocketReadFragmentEndPendingTemplate(null);
                templates[122] = IISWebSocketWebsocketReadFragmentEndSuccessTemplate(null);
                templates[123] = IISWebSocketWebsocketReadFragmentEndNotSuccessTemplate(null);
                templates[124] = IISWebSocketWebsocketWriteFragmentStartTemplate(null);
                templates[125] = IISWebSocketWebsocketWriteFragmentEndPendingTemplate(null);
                templates[126] = IISWebSocketWebsocketWriteFragmentEndSuccessTemplate(null);
                templates[127] = IISWebSocketWebsocketWriteFragmentEndNotSuccessTemplate(null);
                templates[128] = IISWebSocketWebsocketApplicationCloseConnectionTemplate(null);
                templates[129] = IISWebSocketWebsocketModuleCloseConnectionTemplate(null);
                templates[130] = IISWebSocketWebsocketReadIoNotSuccessTemplate(null);
                templates[131] = IISWebSocketWebsocketWriteIoNotSuccessTemplate(null);
                templates[132] = IISWebSocketWebsocketReceivedCloseTemplate(null);
                templates[133] = IISWebSocketWebsocketSendCloseStartTemplate(null);
                templates[134] = IISWebSocketWebsocketSendCloseEndSuccessTemplate(null);
                templates[135] = IISWebSocketWebsocketSendCloseEndNotSuccessTemplate(null);
                templates[136] = IISCompressionStaticCompressionStartTemplate(null);
                templates[137] = IISCompressionStaticCompressionSuccessTemplate(null);
                templates[138] = IISCompressionStaticCompressionNotSuccessTemplate(null);
                templates[139] = IISCompressionStaticCompressionCreateStartTemplate(null);
                templates[140] = IISCompressionStaticCompressionCreateEndTemplate(null);
                templates[141] = IISCompressionDynamicCompressionStartTemplate(null);
                templates[142] = IISCompressionDynamicCompressionSuccessTemplate(null);
                templates[143] = IISCompressionDynamicCompressionNotSuccessTemplate(null);
                templates[144] = IISCompressionDynamicCompressionDoTemplate(null);
                templates[145] = IISCompressionDynamicCompressionEndTemplate(null);
                templates[146] = IISCompressionStaticCompressionEndTemplate(null);
                templates[147] = IISCacheFileCacheAccessStartTemplate(null);
                templates[148] = IISCacheFileCacheAccessEndTemplate(null);
                templates[149] = IISCacheUrlCacheAccessStartTemplate(null);
                templates[150] = IISCacheUrlCacheAccessEndTemplate(null);
                templates[151] = IISCacheHttpsysCacheableTemplate(null);
                templates[152] = IISCacheOutputCacheLookupStartTemplate(null);
                templates[153] = IISCacheOutputCacheLookupEndTemplate(null);
                templates[154] = IISCacheOutputCacheUpdateStartTemplate(null);
                templates[155] = IISCacheOutputCacheUpdateEndTemplate(null);
                templates[156] = IISCacheOutputCacheDisabledTemplate(null);
                templates[157] = IISRequestNotificationNotifyModuleStartTemplate(null);
                templates[158] = IISRequestNotificationNotifyModuleEndTemplate(null);
                templates[159] = IISRequestNotificationNotifyModuleCompletionTemplate(null);
                templates[160] = IISRequestNotificationPreBeginRequestStartTemplate(null);
                templates[161] = IISRequestNotificationPreBeginRequestEndTemplate(null);
                templates[162] = IISRequestNotificationRequestProcessingErrorTemplate(null);
                templates[163] = IISRequestNotificationModuleSetResponseErrorStatusTemplate(null);
                templates[164] = IISRequestNotificationModuleSetResponseSuccessStatusTemplate(null);
                templates[165] = IISRequestNotificationSetResponseErrorDescriptionTemplate(null);
                templates[166] = IISModuleModuleStartTemplate(null);
                templates[167] = IISModuleModuleEndTemplate(null);
                templates[168] = IISModuleModuleCriticalErrorTemplate(null);
                templates[169] = IISModuleModuleErrorTemplate(null);
                templates[170] = IISModuleModuleWarningTemplate(null);
                templates[171] = IISModuleModuleInformationTemplate(null);
                templates[172] = IISModuleModuleVerboseTemplate(null);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.IIS_Trace
{
    public sealed class W3AuthAnonPasswdChangeNeeded : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3AuthAnonPasswdChangeNeeded(Action<W3AuthAnonPasswdChangeNeeded> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthAnonPasswdChangeNeeded>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthAnonPasswdChangeNeeded> m_target;
        #endregion
    }
    public sealed class W3AuthBadBasicHeader : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3AuthBadBasicHeader(Action<W3AuthBadBasicHeader> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthBadBasicHeader>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthBadBasicHeader> m_target;
        #endregion
    }
    public sealed class W3AuthBasicLogonFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthBasicLogonFailed(Action<W3AuthBasicLogonFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthBasicLogonFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthBasicLogonFailed> m_target;
        #endregion
    }
    public sealed class W3AuthEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3AuthEnd(Action<W3AuthEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthEnd> m_target;
        #endregion
    }
    public sealed class W3AuthIISDigestLogonFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthIISDigestLogonFailed(Action<W3AuthIISDigestLogonFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthIISDigestLogonFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthIISDigestLogonFailed> m_target;
        #endregion
    }
    public sealed class W3AuthInvalidAnonAccount : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthInvalidAnonAccount(Action<W3AuthInvalidAnonAccount> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthInvalidAnonAccount>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthInvalidAnonAccount> m_target;
        #endregion
    }
    public sealed class W3AuthKerberosFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public bool KMUsed { get { return GetInt32At(16) != 0; } }
        public string APUserName { get { return GetUnicodeStringAt(20); } }
        public string SPNName { get { return GetUnicodeStringAt(SkipUnicodeString(20)); } }
        public bool ADConfigIsOK { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(20))) != 0; } }
        public string KerberosInfo { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(20)) + 4); } }

        #region Private
        internal W3AuthKerberosFailed(Action<W3AuthKerberosFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(20)) + 4)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(20)) + 4)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthKerberosFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "KMUsed", KMUsed);
            XmlAttrib(sb, "APUserName", APUserName);
            XmlAttrib(sb, "SPNName", SPNName);
            XmlAttrib(sb, "ADConfigIsOK", ADConfigIsOK);
            XmlAttrib(sb, "KerberosInfo", KerberosInfo);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "KMUsed", "APUserName", "SPNName", "ADConfigIsOK", "KerberosInfo" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return KMUsed;
                case 2:
                    return APUserName;
                case 3:
                    return SPNName;
                case 4:
                    return ADConfigIsOK;
                case 5:
                    return KerberosInfo;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthKerberosFailed> m_target;
        #endregion
    }
    public sealed class W3AuthNTLMNullSession : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3AuthNTLMNullSession(Action<W3AuthNTLMNullSession> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthNTLMNullSession>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthNTLMNullSession> m_target;
        #endregion
    }
    public sealed class W3AuthPassportLogonFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthPassportLogonFailed(Action<W3AuthPassportLogonFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthPassportLogonFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthPassportLogonFailed> m_target;
        #endregion
    }
    public sealed class W3AuthPasswdChangeDisabled : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3AuthPasswdChangeDisabled(Action<W3AuthPasswdChangeDisabled> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthPasswdChangeDisabled>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthPasswdChangeDisabled> m_target;
        #endregion
    }
    public sealed class W3AuthPasswdChangeNeeded : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3AuthPasswdChangeNeeded(Action<W3AuthPasswdChangeNeeded> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthPasswdChangeNeeded>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthPasswdChangeNeeded> m_target;
        #endregion
    }
    public sealed class W3AuthRequestAuthType : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int RequestAuthType { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthRequestAuthType(Action<W3AuthRequestAuthType> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthRequestAuthType>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "RequestAuthType", RequestAuthType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "RequestAuthType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return RequestAuthType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthRequestAuthType> m_target;
        #endregion
    }
    public sealed class W3AuthSSPIContinueNeeded : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string PackageName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3AuthSSPIContinueNeeded(Action<W3AuthSSPIContinueNeeded> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthSSPIContinueNeeded>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "PackageName", PackageName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "PackageName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return PackageName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthSSPIContinueNeeded> m_target;
        #endregion
    }
    public sealed class W3AuthSSPILogonFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthSSPILogonFailed(Action<W3AuthSSPILogonFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthSSPILogonFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthSSPILogonFailed> m_target;
        #endregion
    }
    public sealed class W3AuthStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int AuthTypeSupported { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthStart(Action<W3AuthStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "AuthTypeSupported", AuthTypeSupported);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "AuthTypeSupported" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return AuthTypeSupported;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthStart> m_target;
        #endregion
    }
    public sealed class W3AuthSucceeded : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int AuthType { get { return GetInt32At(16); } }
        public bool NTLMUsed { get { return GetInt32At(20) != 0; } }
        public string RemoteUserName { get { return GetUnicodeStringAt(24); } }
        public string AuthUserName { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public int TokenImpersonationLevel { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(24))); } }

        #region Private
        internal W3AuthSucceeded(Action<W3AuthSucceeded> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(24)) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(24)) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthSucceeded>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "AuthType", AuthType);
            XmlAttrib(sb, "NTLMUsed", NTLMUsed);
            XmlAttrib(sb, "RemoteUserName", RemoteUserName);
            XmlAttrib(sb, "AuthUserName", AuthUserName);
            XmlAttrib(sb, "TokenImpersonationLevel", TokenImpersonationLevel);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "AuthType", "NTLMUsed", "RemoteUserName", "AuthUserName", "TokenImpersonationLevel" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return AuthType;
                case 2:
                    return NTLMUsed;
                case 3:
                    return RemoteUserName;
                case 4:
                    return AuthUserName;
                case 5:
                    return TokenImpersonationLevel;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthSucceeded> m_target;
        #endregion
    }
    public sealed class W3AuthTypeNotSupported : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3AuthTypeNotSupported(Action<W3AuthTypeNotSupported> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthTypeNotSupported>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthTypeNotSupported> m_target;
        #endregion
    }
    public sealed class W3AuthWDigestLogonFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3AuthWDigestLogonFailed(Action<W3AuthWDigestLogonFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3AuthWDigestLogonFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3AuthWDigestLogonFailed> m_target;
        #endregion
    }
    public sealed class W3CacheFileCacheAccessEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public bool Successful { get { return GetInt32At(16) != 0; } }
        public bool FileFromCache { get { return GetInt32At(20) != 0; } }
        public bool FileAddedToCache { get { return GetInt32At(24) != 0; } }
        public bool FileDirmoned { get { return GetInt32At(28) != 0; } }
        public bool LastModCheckErrorIgnored { get { return GetInt32At(32) != 0; } }
        public int ErrorCode { get { return GetInt32At(36); } }
        public string LastModifiedTime { get { return GetUTF8StringAt(40); } }

        #region Private
        internal W3CacheFileCacheAccessEnd(Action<W3CacheFileCacheAccessEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(40)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(40)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CacheFileCacheAccessEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Successful", Successful);
            XmlAttrib(sb, "FileFromCache", FileFromCache);
            XmlAttrib(sb, "FileAddedToCache", FileAddedToCache);
            XmlAttrib(sb, "FileDirmoned", FileDirmoned);
            XmlAttrib(sb, "LastModCheckErrorIgnored", LastModCheckErrorIgnored);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            XmlAttrib(sb, "LastModifiedTime", LastModifiedTime);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Successful", "FileFromCache", "FileAddedToCache", "FileDirmoned", "LastModCheckErrorIgnored", "ErrorCode", "LastModifiedTime" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Successful;
                case 2:
                    return FileFromCache;
                case 3:
                    return FileAddedToCache;
                case 4:
                    return FileDirmoned;
                case 5:
                    return LastModCheckErrorIgnored;
                case 6:
                    return ErrorCode;
                case 7:
                    return LastModifiedTime;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CacheFileCacheAccessEnd> m_target;
        #endregion
    }
    public sealed class W3CacheFileCacheAccessStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FileName { get { return GetUnicodeStringAt(16); } }
        public string UserName { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string DomainName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }

        #region Private
        internal W3CacheFileCacheAccessStart(Action<W3CacheFileCacheAccessStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CacheFileCacheAccessStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FileName", FileName);
            XmlAttrib(sb, "UserName", UserName);
            XmlAttrib(sb, "DomainName", DomainName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FileName", "UserName", "DomainName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FileName;
                case 2:
                    return UserName;
                case 3:
                    return DomainName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CacheFileCacheAccessStart> m_target;
        #endregion
    }
    public sealed class W3CacheHttpsysCacheable : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public bool HttpsysCacheable { get { return GetInt32At(16) != 0; } }
        public int Reason { get { return GetInt32At(20); } }
        public int CachePolicy { get { return GetInt32At(24); } }
        public int TimeToLive { get { return GetInt32At(28); } }

        #region Private
        internal W3CacheHttpsysCacheable(Action<W3CacheHttpsysCacheable> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 32));
            Debug.Assert(!(Version > 1 && EventDataLength < 32));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CacheHttpsysCacheable>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HttpsysCacheable", HttpsysCacheable);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "CachePolicy", CachePolicy);
            XmlAttrib(sb, "TimeToLive", TimeToLive);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HttpsysCacheable", "Reason", "CachePolicy", "TimeToLive" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HttpsysCacheable;
                case 2:
                    return Reason;
                case 3:
                    return CachePolicy;
                case 4:
                    return TimeToLive;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CacheHttpsysCacheable> m_target;
        #endregion
    }
    public sealed class W3OutputCacheDisabled : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3OutputCacheDisabled(Action<W3OutputCacheDisabled> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3OutputCacheDisabled>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3OutputCacheDisabled> m_target;
        #endregion
    }
    public sealed class W3OutputCacheLookupEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Result { get { return GetInt32At(16); } }

        #region Private
        internal W3OutputCacheLookupEnd(Action<W3OutputCacheLookupEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3OutputCacheLookupEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Result", Result);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Result" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Result;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3OutputCacheLookupEnd> m_target;
        #endregion
    }
    public sealed class W3OutputCacheLookupStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3OutputCacheLookupStart(Action<W3OutputCacheLookupStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3OutputCacheLookupStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3OutputCacheLookupStart> m_target;
        #endregion
    }
    public sealed class W3OutputCacheUpdateEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Result { get { return GetInt32At(16); } }

        #region Private
        internal W3OutputCacheUpdateEnd(Action<W3OutputCacheUpdateEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3OutputCacheUpdateEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Result", Result);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Result" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Result;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3OutputCacheUpdateEnd> m_target;
        #endregion
    }
    public sealed class W3OutputCacheUpdateStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int CachePolicy { get { return GetInt32At(16); } }
        public int TimeToLive { get { return GetInt32At(20); } }

        #region Private
        internal W3OutputCacheUpdateStart(Action<W3OutputCacheUpdateStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 24));
            Debug.Assert(!(Version > 1 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3OutputCacheUpdateStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "CachePolicy", CachePolicy);
            XmlAttrib(sb, "TimeToLive", TimeToLive);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "CachePolicy", "TimeToLive" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return CachePolicy;
                case 2:
                    return TimeToLive;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3OutputCacheUpdateStart> m_target;
        #endregion
    }
    public sealed class W3CacheURLCacheAccessEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string PhysicalPath { get { return GetUnicodeStringAt(16); } }
        public bool URLInfoFromCache { get { return GetInt32At(SkipUnicodeString(16)) != 0; } }
        public bool URLInfoAddedToCache { get { return GetInt32At(SkipUnicodeString(16) + 4) != 0; } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(16) + 8); } }

        #region Private
        internal W3CacheURLCacheAccessEnd(Action<W3CacheURLCacheAccessEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 12));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CacheURLCacheAccessEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "PhysicalPath", PhysicalPath);
            XmlAttrib(sb, "URLInfoFromCache", URLInfoFromCache);
            XmlAttrib(sb, "URLInfoAddedToCache", URLInfoAddedToCache);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "PhysicalPath", "URLInfoFromCache", "URLInfoAddedToCache", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return PhysicalPath;
                case 2:
                    return URLInfoFromCache;
                case 3:
                    return URLInfoAddedToCache;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CacheURLCacheAccessEnd> m_target;
        #endregion
    }
    public sealed class W3CacheURLCacheAccessStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string RequestURL { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3CacheURLCacheAccessStart(Action<W3CacheURLCacheAccessStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CacheURLCacheAccessStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "RequestURL", RequestURL);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "RequestURL" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return RequestURL;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CacheURLCacheAccessStart> m_target;
        #endregion
    }
    public sealed class W3CGIEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIEnd(Action<W3CGIEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIEnd> m_target;
        #endregion
    }
    public sealed class W3CGIHeadersReceived : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIHeadersReceived(Action<W3CGIHeadersReceived> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIHeadersReceived>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIHeadersReceived> m_target;
        #endregion
    }
    public sealed class W3CGILaunch : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string CommandLine { get { return GetUnicodeStringAt(16); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(16)); } }
        public int ProcessId { get { return GetInt32At(SkipUnicodeString(16) + 4); } }

        #region Private
        internal W3CGILaunch(Action<W3CGILaunch> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 8));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGILaunch>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "CommandLine", CommandLine);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            XmlAttrib(sb, "ProcessId", ProcessId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "CommandLine", "ErrorCode", "ProcessId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return CommandLine;
                case 2:
                    return ErrorCode;
                case 3:
                    return ProcessId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGILaunch> m_target;
        #endregion
    }
    public sealed class W3CGIPrematureTermination : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Headers { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3CGIPrematureTermination(Action<W3CGIPrematureTermination> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIPrematureTermination>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Headers", Headers);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Headers" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Headers;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIPrematureTermination> m_target;
        #endregion
    }
    public sealed class W3CGIRequestEntitySent : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIRequestEntitySent(Action<W3CGIRequestEntitySent> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIRequestEntitySent>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIRequestEntitySent> m_target;
        #endregion
    }
    public sealed class W3CGIStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIStart(Action<W3CGIStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIStart> m_target;
        #endregion
    }
    public sealed class W3CGITimeout : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Headers { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3CGITimeout(Action<W3CGITimeout> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGITimeout>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Headers", Headers);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Headers" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Headers;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGITimeout> m_target;
        #endregion
    }
    public sealed class W3DynamicCompressionDo : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int OriginalSize { get { return GetInt32At(16); } }
        public int CompressedSize { get { return GetInt32At(20); } }

        #region Private
        internal W3DynamicCompressionDo(Action<W3DynamicCompressionDo> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 24));
            Debug.Assert(!(Version > 1 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3DynamicCompressionDo>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "OriginalSize", OriginalSize);
            XmlAttrib(sb, "CompressedSize", CompressedSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "OriginalSize", "CompressedSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return OriginalSize;
                case 2:
                    return CompressedSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3DynamicCompressionDo> m_target;
        #endregion
    }
    public sealed class W3DynamicCompressionEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3DynamicCompressionEnd(Action<W3DynamicCompressionEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3DynamicCompressionEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3DynamicCompressionEnd> m_target;
        #endregion
    }
    public sealed class W3DynamicCompressionNotSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Reason { get { return GetInt32At(16); } }

        #region Private
        internal W3DynamicCompressionNotSuccess(Action<W3DynamicCompressionNotSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3DynamicCompressionNotSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Reason", Reason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Reason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Reason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3DynamicCompressionNotSuccess> m_target;
        #endregion
    }
    public sealed class W3DynamicCompressionStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3DynamicCompressionStart(Action<W3DynamicCompressionStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3DynamicCompressionStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3DynamicCompressionStart> m_target;
        #endregion
    }
    public sealed class W3DynamicCompressionSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3DynamicCompressionSuccess(Action<W3DynamicCompressionSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3DynamicCompressionSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3DynamicCompressionSuccess> m_target;
        #endregion
    }
    public sealed class W3StaticCompressionCreateEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }
        public string OriginalFileName { get { return GetUnicodeStringAt(20); } }
        public int OriginalFileSize { get { return GetInt32At(SkipUnicodeString(20)); } }
        public string CompressedFileName { get { return GetUnicodeStringAt(SkipUnicodeString(20) + 4); } }
        public int CompressedFileSize { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(20) + 4)); } }

        #region Private
        internal W3StaticCompressionCreateEnd(Action<W3StaticCompressionCreateEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(20) + 4) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(20) + 4) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3StaticCompressionCreateEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            XmlAttrib(sb, "OriginalFileName", OriginalFileName);
            XmlAttrib(sb, "OriginalFileSize", OriginalFileSize);
            XmlAttrib(sb, "CompressedFileName", CompressedFileName);
            XmlAttrib(sb, "CompressedFileSize", CompressedFileSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode", "OriginalFileName", "OriginalFileSize", "CompressedFileName", "CompressedFileSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                case 2:
                    return OriginalFileName;
                case 3:
                    return OriginalFileSize;
                case 4:
                    return CompressedFileName;
                case 5:
                    return CompressedFileSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3StaticCompressionCreateEnd> m_target;
        #endregion
    }
    public sealed class W3StaticCompressionCreateStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string OriginalFileName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3StaticCompressionCreateStart(Action<W3StaticCompressionCreateStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3StaticCompressionCreateStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "OriginalFileName", OriginalFileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "OriginalFileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return OriginalFileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3StaticCompressionCreateStart> m_target;
        #endregion
    }
    public sealed class W3StaticCompressionEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3StaticCompressionEnd(Action<W3StaticCompressionEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3StaticCompressionEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3StaticCompressionEnd> m_target;
        #endregion
    }
    public sealed class W3StaticCompressionNotSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Reason { get { return GetInt32At(16); } }

        #region Private
        internal W3StaticCompressionNotSuccess(Action<W3StaticCompressionNotSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3StaticCompressionNotSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Reason", Reason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Reason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Reason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3StaticCompressionNotSuccess> m_target;
        #endregion
    }
    public sealed class W3StaticCompressionStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3StaticCompressionStart(Action<W3StaticCompressionStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3StaticCompressionStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3StaticCompressionStart> m_target;
        #endregion
    }
    public sealed class W3StaticCompressionSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3StaticCompressionSuccess(Action<W3StaticCompressionSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3StaticCompressionSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3StaticCompressionSuccess> m_target;
        #endregion
    }
    public sealed class W3CGIFActivityTimeout : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFActivityTimeout(Action<W3CGIFActivityTimeout> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFActivityTimeout>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFActivityTimeout> m_target;
        #endregion
    }
    public sealed class W3CGIFAddJobObjectFail : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFAddJobObjectFail(Action<W3CGIFAddJobObjectFail> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFAddJobObjectFail>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFAddJobObjectFail> m_target;
        #endregion
    }
    public sealed class W3CGIFAppMgrShutdown : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFAppMgrShutdown(Action<W3CGIFAppMgrShutdown> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFAppMgrShutdown>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFAppMgrShutdown> m_target;
        #endregion
    }
    public sealed class W3CGIFAssignProcess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string CommandLine { get { return GetUnicodeStringAt(16); } }
        public bool IsNewProcess { get { return GetInt32At(SkipUnicodeString(16)) != 0; } }
        public int ProcessId { get { return GetInt32At(SkipUnicodeString(16) + 4); } }
        public int RequestNumber { get { return GetInt32At(SkipUnicodeString(16) + 8); } }

        #region Private
        internal W3CGIFAssignProcess(Action<W3CGIFAssignProcess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 12));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFAssignProcess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "CommandLine", CommandLine);
            XmlAttrib(sb, "IsNewProcess", IsNewProcess);
            XmlAttrib(sb, "ProcessId", ProcessId);
            XmlAttrib(sb, "RequestNumber", RequestNumber);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "CommandLine", "IsNewProcess", "ProcessId", "RequestNumber" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return CommandLine;
                case 2:
                    return IsNewProcess;
                case 3:
                    return ProcessId;
                case 4:
                    return RequestNumber;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFAssignProcess> m_target;
        #endregion
    }
    public sealed class W3CGIFEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFEnd(Action<W3CGIFEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFEnd> m_target;
        #endregion
    }
    public sealed class W3CGIFPathNotFound : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFPathNotFound(Action<W3CGIFPathNotFound> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFPathNotFound>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFPathNotFound> m_target;
        #endregion
    }
    public sealed class W3CGIFQueueFull : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFQueueFull(Action<W3CGIFQueueFull> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFQueueFull>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFQueueFull> m_target;
        #endregion
    }
    public sealed class W3CGIFQueueRequest : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int PositionInQueue { get { return GetInt32At(16); } }
        public int MaxInstances { get { return GetInt32At(20); } }

        #region Private
        internal W3CGIFQueueRequest(Action<W3CGIFQueueRequest> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 24));
            Debug.Assert(!(Version > 1 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFQueueRequest>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "PositionInQueue", PositionInQueue);
            XmlAttrib(sb, "MaxInstances", MaxInstances);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "PositionInQueue", "MaxInstances" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return PositionInQueue;
                case 2:
                    return MaxInstances;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFQueueRequest> m_target;
        #endregion
    }
    public sealed class W3CGIFRapidFailureProtection : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFRapidFailureProtection(Action<W3CGIFRapidFailureProtection> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFRapidFailureProtection>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFRapidFailureProtection> m_target;
        #endregion
    }
    public sealed class W3CGIFRequestTimeout : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFRequestTimeout(Action<W3CGIFRequestTimeout> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFRequestTimeout>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFRequestTimeout> m_target;
        #endregion
    }
    public sealed class W3CGIFResponseWritten : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFResponseWritten(Action<W3CGIFResponseWritten> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFResponseWritten>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFResponseWritten> m_target;
        #endregion
    }
    public sealed class W3CGIFScriptProcessorMissing : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFScriptProcessorMissing(Action<W3CGIFScriptProcessorMissing> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFScriptProcessorMissing>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFScriptProcessorMissing> m_target;
        #endregion
    }
    public sealed class W3CGIFStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFStart(Action<W3CGIFStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFStart> m_target;
        #endregion
    }
    public sealed class W3CGIFTraceError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Message { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3CGIFTraceError(Action<W3CGIFTraceError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFTraceError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Message", Message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFTraceError> m_target;
        #endregion
    }
    public sealed class W3CGIFTraceInfo : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Message { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3CGIFTraceInfo(Action<W3CGIFTraceInfo> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFTraceInfo>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Message", Message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFTraceInfo> m_target;
        #endregion
    }
    public sealed class W3CGIFTraceWarning : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Message { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3CGIFTraceWarning(Action<W3CGIFTraceWarning> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFTraceWarning>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Message", Message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFTraceWarning> m_target;
        #endregion
    }
    public sealed class W3CGIFUnexpectedExit : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFUnexpectedExit(Action<W3CGIFUnexpectedExit> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFUnexpectedExit>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFUnexpectedExit> m_target;
        #endregion
    }
    public sealed class W3CGIFUnknownError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3CGIFUnknownError(Action<W3CGIFUnknownError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFUnknownError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFUnknownError> m_target;
        #endregion
    }
    public sealed class W3CGIFWaitingForResponse : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3CGIFWaitingForResponse(Action<W3CGIFWaitingForResponse> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3CGIFWaitingForResponse>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3CGIFWaitingForResponse> m_target;
        #endregion
    }
    public sealed class W3FilterAccessDeniedEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterAccessDeniedEnd(Action<W3FilterAccessDeniedEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAccessDeniedEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAccessDeniedEnd> m_target;
        #endregion
    }
    public sealed class W3FilterAccessDeniedStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string RequestedURL { get { return GetUTF8StringAt(16); } }
        public string PhysicalPath { get { return GetUTF8StringAt(SkipUTF8String(16)); } }
        public int DenialReason { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16))); } }

        #region Private
        internal W3FilterAccessDeniedStart(Action<W3FilterAccessDeniedStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(16)) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(16)) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAccessDeniedStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "RequestedURL", RequestedURL);
            XmlAttrib(sb, "PhysicalPath", PhysicalPath);
            XmlAttrib(sb, "DenialReason", DenialReason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "RequestedURL", "PhysicalPath", "DenialReason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return RequestedURL;
                case 2:
                    return PhysicalPath;
                case 3:
                    return DenialReason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAccessDeniedStart> m_target;
        #endregion
    }
    public sealed class W3FilterAddReqHeader : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string HeaderName { get { return GetUTF8StringAt(16); } }
        public string HeaderValue { get { return GetUTF8StringAt(SkipUTF8String(16)); } }

        #region Private
        internal W3FilterAddReqHeader(Action<W3FilterAddReqHeader> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAddReqHeader>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HeaderName", HeaderName);
            XmlAttrib(sb, "HeaderValue", HeaderValue);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HeaderName", "HeaderValue" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HeaderName;
                case 2:
                    return HeaderValue;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAddReqHeader> m_target;
        #endregion
    }
    public sealed class W3FilterAddRespHeader : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string HeaderName { get { return GetUTF8StringAt(16); } }
        public string HeaderValue { get { return GetUTF8StringAt(SkipUTF8String(16)); } }

        #region Private
        internal W3FilterAddRespHeader(Action<W3FilterAddRespHeader> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAddRespHeader>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HeaderName", HeaderName);
            XmlAttrib(sb, "HeaderValue", HeaderValue);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HeaderName", "HeaderValue" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HeaderName;
                case 2:
                    return HeaderValue;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAddRespHeader> m_target;
        #endregion
    }
    public sealed class W3FilterAuthCompleteEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterAuthCompleteEnd(Action<W3FilterAuthCompleteEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAuthCompleteEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAuthCompleteEnd> m_target;
        #endregion
    }
    public sealed class W3FilterAuthCompleteStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterAuthCompleteStart(Action<W3FilterAuthCompleteStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAuthCompleteStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAuthCompleteStart> m_target;
        #endregion
    }
    public sealed class W3FilterAuthenticationEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FinalUserName { get { return GetUTF8StringAt(16); } }
        public bool PasswordChanged { get { return GetInt32At(SkipUTF8String(16)) != 0; } }

        #region Private
        internal W3FilterAuthenticationEnd(Action<W3FilterAuthenticationEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAuthenticationEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FinalUserName", FinalUserName);
            XmlAttrib(sb, "PasswordChanged", PasswordChanged);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FinalUserName", "PasswordChanged" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FinalUserName;
                case 2:
                    return PasswordChanged;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAuthenticationEnd> m_target;
        #endregion
    }
    public sealed class W3FilterAuthenticationStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string OrigUserName { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3FilterAuthenticationStart(Action<W3FilterAuthenticationStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterAuthenticationStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "OrigUserName", OrigUserName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "OrigUserName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return OrigUserName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterAuthenticationStart> m_target;
        #endregion
    }
    public sealed class W3FilterEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int NotificationStatus { get { return GetInt32At(16); } }

        #region Private
        internal W3FilterEnd(Action<W3FilterEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "NotificationStatus", NotificationStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "NotificationStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return NotificationStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterEnd> m_target;
        #endregion
    }
    public sealed class W3FilterEndOfRequestEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterEndOfRequestEnd(Action<W3FilterEndOfRequestEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterEndOfRequestEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterEndOfRequestEnd> m_target;
        #endregion
    }
    public sealed class W3FilterEndOfRequestStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterEndOfRequestStart(Action<W3FilterEndOfRequestStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterEndOfRequestStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterEndOfRequestStart> m_target;
        #endregion
    }
    public sealed class W3FilterError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3FilterError(Action<W3FilterError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterError> m_target;
        #endregion
    }
    public sealed class W3FilterLogEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FinalClientHostName { get { return GetUTF8StringAt(16); } }
        public string FinalClientUserName { get { return GetUTF8StringAt(SkipUTF8String(16)); } }
        public string FinalServerName { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(16))); } }
        public string FinalOperation { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))); } }
        public string FinalTarget { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16))))); } }
        public string FinalParameters { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))); } }
        public int FinalHttpStatus { get { return GetInt32At(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16))))))); } }
        public int FinalWin32Status { get { return GetInt32At(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))) + 4); } }

        #region Private
        internal W3FilterLogEnd(Action<W3FilterLogEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))) + 8));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterLogEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FinalClientHostName", FinalClientHostName);
            XmlAttrib(sb, "FinalClientUserName", FinalClientUserName);
            XmlAttrib(sb, "FinalServerName", FinalServerName);
            XmlAttrib(sb, "FinalOperation", FinalOperation);
            XmlAttrib(sb, "FinalTarget", FinalTarget);
            XmlAttrib(sb, "FinalParameters", FinalParameters);
            XmlAttrib(sb, "FinalHttpStatus", FinalHttpStatus);
            XmlAttrib(sb, "FinalWin32Status", FinalWin32Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FinalClientHostName", "FinalClientUserName", "FinalServerName", "FinalOperation", "FinalTarget", "FinalParameters", "FinalHttpStatus", "FinalWin32Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FinalClientHostName;
                case 2:
                    return FinalClientUserName;
                case 3:
                    return FinalServerName;
                case 4:
                    return FinalOperation;
                case 5:
                    return FinalTarget;
                case 6:
                    return FinalParameters;
                case 7:
                    return FinalHttpStatus;
                case 8:
                    return FinalWin32Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterLogEnd> m_target;
        #endregion
    }
    public sealed class W3FilterLogStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string OrigClientHostName { get { return GetUTF8StringAt(16); } }
        public string OrigClientUserName { get { return GetUTF8StringAt(SkipUTF8String(16)); } }
        public string OrigServerName { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(16))); } }
        public string OrigOperation { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))); } }
        public string OrigTarget { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16))))); } }
        public string OrigParameters { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))); } }
        public int OrigHttpStatus { get { return GetInt32At(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16))))))); } }
        public int OrigWin32Status { get { return GetInt32At(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))) + 4); } }

        #region Private
        internal W3FilterLogStart(Action<W3FilterLogStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))) + 8));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))))) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterLogStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "OrigClientHostName", OrigClientHostName);
            XmlAttrib(sb, "OrigClientUserName", OrigClientUserName);
            XmlAttrib(sb, "OrigServerName", OrigServerName);
            XmlAttrib(sb, "OrigOperation", OrigOperation);
            XmlAttrib(sb, "OrigTarget", OrigTarget);
            XmlAttrib(sb, "OrigParameters", OrigParameters);
            XmlAttrib(sb, "OrigHttpStatus", OrigHttpStatus);
            XmlAttrib(sb, "OrigWin32Status", OrigWin32Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "OrigClientHostName", "OrigClientUserName", "OrigServerName", "OrigOperation", "OrigTarget", "OrigParameters", "OrigHttpStatus", "OrigWin32Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return OrigClientHostName;
                case 2:
                    return OrigClientUserName;
                case 3:
                    return OrigServerName;
                case 4:
                    return OrigOperation;
                case 5:
                    return OrigTarget;
                case 6:
                    return OrigParameters;
                case 7:
                    return OrigHttpStatus;
                case 8:
                    return OrigWin32Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterLogStart> m_target;
        #endregion
    }
    public sealed class W3FilterPreprocEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterPreprocEnd(Action<W3FilterPreprocEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterPreprocEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterPreprocEnd> m_target;
        #endregion
    }
    public sealed class W3FilterPreprocStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterPreprocStart(Action<W3FilterPreprocStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterPreprocStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterPreprocStart> m_target;
        #endregion
    }
    public sealed class W3FilterSendRawDataEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterSendRawDataEnd(Action<W3FilterSendRawDataEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterSendRawDataEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterSendRawDataEnd> m_target;
        #endregion
    }
    public sealed class W3FilterSendRawDataStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterSendRawDataStart(Action<W3FilterSendRawDataStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterSendRawDataStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterSendRawDataStart> m_target;
        #endregion
    }
    public sealed class W3FilterSendResponseEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3FilterSendResponseEnd(Action<W3FilterSendResponseEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterSendResponseEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterSendResponseEnd> m_target;
        #endregion
    }
    public sealed class W3FilterSendResponseStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int HttpStatus { get { return GetInt32At(16); } }

        #region Private
        internal W3FilterSendResponseStart(Action<W3FilterSendResponseStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterSendResponseStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HttpStatus", HttpStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HttpStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HttpStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterSendResponseStart> m_target;
        #endregion
    }
    public sealed class W3FilterSetReqHeader : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string HeaderName { get { return GetUTF8StringAt(16); } }
        public string HeaderValue { get { return GetUTF8StringAt(SkipUTF8String(16)); } }

        #region Private
        internal W3FilterSetReqHeader(Action<W3FilterSetReqHeader> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterSetReqHeader>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HeaderName", HeaderName);
            XmlAttrib(sb, "HeaderValue", HeaderValue);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HeaderName", "HeaderValue" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HeaderName;
                case 2:
                    return HeaderValue;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterSetReqHeader> m_target;
        #endregion
    }
    public sealed class W3FilterSetRespHeader : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string HeaderName { get { return GetUTF8StringAt(16); } }
        public string HeaderValue { get { return GetUTF8StringAt(SkipUTF8String(16)); } }

        #region Private
        internal W3FilterSetRespHeader(Action<W3FilterSetRespHeader> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterSetRespHeader>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HeaderName", HeaderName);
            XmlAttrib(sb, "HeaderValue", HeaderValue);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HeaderName", "HeaderValue" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HeaderName;
                case 2:
                    return HeaderValue;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterSetRespHeader> m_target;
        #endregion
    }
    public sealed class W3FilterStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FilterName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3FilterStart(Action<W3FilterStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FilterName", FilterName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FilterName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FilterName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterStart> m_target;
        #endregion
    }
    public sealed class W3FilterURLMapEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FinalURL { get { return GetUTF8StringAt(16); } }
        public string FinalPath { get { return GetUTF8StringAt(SkipUTF8String(16)); } }
        public int AccessPerms { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16))); } }
        public int MatchingPath { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16)) + 4); } }
        public int MatchingURL { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16)) + 8); } }
        public string ScriptMapEntry { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(16)) + 12); } }

        #region Private
        internal W3FilterURLMapEnd(Action<W3FilterURLMapEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(SkipUTF8String(16)) + 12)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(SkipUTF8String(16)) + 12)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterURLMapEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FinalURL", FinalURL);
            XmlAttrib(sb, "FinalPath", FinalPath);
            XmlAttrib(sb, "AccessPerms", AccessPerms);
            XmlAttrib(sb, "MatchingPath", MatchingPath);
            XmlAttrib(sb, "MatchingURL", MatchingURL);
            XmlAttrib(sb, "ScriptMapEntry", ScriptMapEntry);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FinalURL", "FinalPath", "AccessPerms", "MatchingPath", "MatchingURL", "ScriptMapEntry" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FinalURL;
                case 2:
                    return FinalPath;
                case 3:
                    return AccessPerms;
                case 4:
                    return MatchingPath;
                case 5:
                    return MatchingURL;
                case 6:
                    return ScriptMapEntry;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterURLMapEnd> m_target;
        #endregion
    }
    public sealed class W3FilterURLMapStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string OrigURL { get { return GetUTF8StringAt(16); } }
        public string OrigPath { get { return GetUTF8StringAt(SkipUTF8String(16)); } }
        public int AccessPerms { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16))); } }
        public int MatchingPath { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16)) + 4); } }
        public int MatchingURL { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16)) + 8); } }
        public string ScriptMapEntry { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(16)) + 12); } }

        #region Private
        internal W3FilterURLMapStart(Action<W3FilterURLMapStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(SkipUTF8String(16)) + 12)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(SkipUTF8String(16)) + 12)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3FilterURLMapStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "OrigURL", OrigURL);
            XmlAttrib(sb, "OrigPath", OrigPath);
            XmlAttrib(sb, "AccessPerms", AccessPerms);
            XmlAttrib(sb, "MatchingPath", MatchingPath);
            XmlAttrib(sb, "MatchingURL", MatchingURL);
            XmlAttrib(sb, "ScriptMapEntry", ScriptMapEntry);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "OrigURL", "OrigPath", "AccessPerms", "MatchingPath", "MatchingURL", "ScriptMapEntry" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return OrigURL;
                case 2:
                    return OrigPath;
                case 3:
                    return AccessPerms;
                case 4:
                    return MatchingPath;
                case 5:
                    return MatchingURL;
                case 6:
                    return ScriptMapEntry;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3FilterURLMapStart> m_target;
        #endregion
    }
    public sealed class IISGeneralConfigChangeNotification : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ConfigPath { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal IISGeneralConfigChangeNotification(Action<IISGeneralConfigChangeNotification> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralConfigChangeNotification>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ConfigPath", ConfigPath);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ConfigPath" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ConfigPath;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralConfigChangeNotification> m_target;
        #endregion
    }
    public sealed class IISGeneralFileChangeNotification : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FilePath { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal IISGeneralFileChangeNotification(Action<IISGeneralFileChangeNotification> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralFileChangeNotification>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FilePath", FilePath);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FilePath" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FilePath;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralFileChangeNotification> m_target;
        #endregion
    }
    public sealed class W3GeneralCGIHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3GeneralCGIHandler(Action<W3GeneralCGIHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralCGIHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralCGIHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralChildRequestEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int BytesSent { get { return GetInt32At(16); } }
        public int HttpStatus { get { return GetInt32At(20); } }
        public int HttpSubStatus { get { return GetInt16At(24); } }

        #region Private
        internal W3GeneralChildRequestEnd(Action<W3GeneralChildRequestEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 26));
            Debug.Assert(!(Version > 1 && EventDataLength < 26));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralChildRequestEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "BytesSent", BytesSent);
            XmlAttrib(sb, "HttpStatus", HttpStatus);
            XmlAttrib(sb, "HttpSubStatus", HttpSubStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "BytesSent", "HttpStatus", "HttpSubStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return BytesSent;
                case 2:
                    return HttpStatus;
                case 3:
                    return HttpSubStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralChildRequestEnd> m_target;
        #endregion
    }
    public sealed class W3GeneralChildRequestStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int SiteId { get { return GetInt32At(16); } }
        public string RequestURL { get { return GetUnicodeStringAt(20); } }
        public string RequestVerb { get { return GetUTF8StringAt(SkipUnicodeString(20)); } }
        public int RecursiveLevel { get { return GetInt32At(SkipUTF8String(SkipUnicodeString(20))); } }

        #region Private
        internal W3GeneralChildRequestStart(Action<W3GeneralChildRequestStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUnicodeString(20)) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUnicodeString(20)) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralChildRequestStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "SiteId", SiteId);
            XmlAttrib(sb, "RequestURL", RequestURL);
            XmlAttrib(sb, "RequestVerb", RequestVerb);
            XmlAttrib(sb, "RecursiveLevel", RecursiveLevel);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "SiteId", "RequestURL", "RequestVerb", "RecursiveLevel" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return SiteId;
                case 2:
                    return RequestURL;
                case 3:
                    return RequestVerb;
                case 4:
                    return RecursiveLevel;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralChildRequestStart> m_target;
        #endregion
    }
    public sealed class W3GeneralDavHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FileName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3GeneralDavHandler(Action<W3GeneralDavHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralDavHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FileName", FileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralDavHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralEndpointInformation : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string RemoteAddress { get { return GetUTF8StringAt(16); } }
        public string RemotePort { get { return GetUTF8StringAt(SkipUTF8String(16)); } }
        public string LocalAddress { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(16))); } }
        public string LocalPort { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(SkipUTF8String(16)))); } }

        #region Private
        internal W3GeneralEndpointInformation(Action<W3GeneralEndpointInformation> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16))))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(SkipUTF8String(SkipUTF8String(16))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralEndpointInformation>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "RemoteAddress", RemoteAddress);
            XmlAttrib(sb, "RemotePort", RemotePort);
            XmlAttrib(sb, "LocalAddress", LocalAddress);
            XmlAttrib(sb, "LocalPort", LocalPort);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "RemoteAddress", "RemotePort", "LocalAddress", "LocalPort" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return RemoteAddress;
                case 2:
                    return RemotePort;
                case 3:
                    return LocalAddress;
                case 4:
                    return LocalPort;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralEndpointInformation> m_target;
        #endregion
    }
    public sealed class W3GeneralFlushResponseEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int BytesSent { get { return GetInt32At(16); } }
        public int ErrorCode { get { return GetInt32At(20); } }

        #region Private
        internal W3GeneralFlushResponseEnd(Action<W3GeneralFlushResponseEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 24));
            Debug.Assert(!(Version > 1 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralFlushResponseEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "BytesSent", BytesSent);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "BytesSent", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return BytesSent;
                case 2:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralFlushResponseEnd> m_target;
        #endregion
    }
    public sealed class W3GeneralFlushResponseStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3GeneralFlushResponseStart(Action<W3GeneralFlushResponseStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralFlushResponseStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralFlushResponseStart> m_target;
        #endregion
    }
    public sealed class W3GeneralGetURLMetadata : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string PhysicalPath { get { return GetUnicodeStringAt(16); } }
        public int AccessPerms { get { return GetInt32At(SkipUnicodeString(16)); } }

        #region Private
        internal W3GeneralGetURLMetadata(Action<W3GeneralGetURLMetadata> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralGetURLMetadata>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "PhysicalPath", PhysicalPath);
            XmlAttrib(sb, "AccessPerms", AccessPerms);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "PhysicalPath", "AccessPerms" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return PhysicalPath;
                case 2:
                    return AccessPerms;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralGetURLMetadata> m_target;
        #endregion
    }
    public sealed class W3GeneralISAPIHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3GeneralISAPIHandler(Action<W3GeneralISAPIHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralISAPIHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralISAPIHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralMapHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3GeneralMapHandler(Action<W3GeneralMapHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralMapHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralMapHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralModuleFactoryFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(16)); } }

        #region Private
        internal W3GeneralModuleFactoryFailed(Action<W3GeneralModuleFactoryFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralModuleFactoryFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralModuleFactoryFailed> m_target;
        #endregion
    }
    public sealed class W3GeneralNotSendCustomError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Reason { get { return GetInt32At(16); } }

        #region Private
        internal W3GeneralNotSendCustomError(Action<W3GeneralNotSendCustomError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralNotSendCustomError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Reason", Reason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Reason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Reason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralNotSendCustomError> m_target;
        #endregion
    }
    public sealed class W3GeneralOopISAPIHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ProcessId { get { return GetInt32At(16); } }
        public int TotalReqs { get { return GetInt32At(20); } }
        public int CurrentReqs { get { return GetInt32At(24); } }

        #region Private
        internal W3GeneralOopISAPIHandler(Action<W3GeneralOopISAPIHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 28));
            Debug.Assert(!(Version > 1 && EventDataLength < 28));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralOopISAPIHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ProcessId", ProcessId);
            XmlAttrib(sb, "TotalReqs", TotalReqs);
            XmlAttrib(sb, "CurrentReqs", CurrentReqs);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ProcessId", "TotalReqs", "CurrentReqs" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ProcessId;
                case 2:
                    return TotalReqs;
                case 3:
                    return CurrentReqs;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralOopISAPIHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralOptionsHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3GeneralOptionsHandler(Action<W3GeneralOptionsHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralOptionsHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralOptionsHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralReadEntityEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int BytesReceived { get { return GetInt32At(16); } }
        public int ErrorCode { get { return GetInt32At(20); } }

        #region Private
        internal W3GeneralReadEntityEnd(Action<W3GeneralReadEntityEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 24));
            Debug.Assert(!(Version > 1 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralReadEntityEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "BytesReceived", BytesReceived);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "BytesReceived", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return BytesReceived;
                case 2:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralReadEntityEnd> m_target;
        #endregion
    }
    public sealed class W3GeneralReadEntityStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3GeneralReadEntityStart(Action<W3GeneralReadEntityStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralReadEntityStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralReadEntityStart> m_target;
        #endregion
    }
    public sealed class W3GeneralRedirectionHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string RedirectedURL { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3GeneralRedirectionHandler(Action<W3GeneralRedirectionHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralRedirectionHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "RedirectedURL", RedirectedURL);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "RedirectedURL" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return RedirectedURL;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralRedirectionHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralEndNewRequest : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int BytesSent { get { return GetInt32At(16); } }
        public int BytesReceived { get { return GetInt32At(20); } }
        public int HttpStatus { get { return GetInt32At(24); } }
        public int HttpSubStatus { get { return GetInt16At(28); } }

        #region Private
        internal W3GeneralEndNewRequest(Action<W3GeneralEndNewRequest> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 30));
            Debug.Assert(!(Version > 1 && EventDataLength < 30));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralEndNewRequest>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "BytesSent", BytesSent);
            XmlAttrib(sb, "BytesReceived", BytesReceived);
            XmlAttrib(sb, "HttpStatus", HttpStatus);
            XmlAttrib(sb, "HttpSubStatus", HttpSubStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "BytesSent", "BytesReceived", "HttpStatus", "HttpSubStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return BytesSent;
                case 2:
                    return BytesReceived;
                case 3:
                    return HttpStatus;
                case 4:
                    return HttpSubStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralEndNewRequest> m_target;
        #endregion
    }
    public sealed class W3GeneralRequestEntity : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Buffer { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3GeneralRequestEntity(Action<W3GeneralRequestEntity> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralRequestEntity>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Buffer", Buffer);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Buffer" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Buffer;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralRequestEntity> m_target;
        #endregion
    }
    public sealed class W3GeneralRequestHeaders : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Headers { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3GeneralRequestHeaders(Action<W3GeneralRequestHeaders> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralRequestHeaders>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Headers", Headers);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Headers" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Headers;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralRequestHeaders> m_target;
        #endregion
    }
    public sealed class W3GeneralStartNewRequest : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int SiteId { get { return GetInt32At(16); } }
        public string AppPoolId { get { return GetUnicodeStringAt(20); } }
        public long ConnId { get { return GetInt64At(SkipUnicodeString(20)); } }
        public long RawConnId { get { return GetInt64At(SkipUnicodeString(20) + 8); } }
        public string RequestURL { get { return GetUnicodeStringAt(SkipUnicodeString(20) + 16); } }
        public string RequestVerb { get { return GetUTF8StringAt(SkipUnicodeString(SkipUnicodeString(20) + 16)); } }

        #region Private
        internal W3GeneralStartNewRequest(Action<W3GeneralStartNewRequest> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUnicodeString(SkipUnicodeString(20) + 16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUnicodeString(SkipUnicodeString(20) + 16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralStartNewRequest>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "SiteId", SiteId);
            XmlAttrib(sb, "AppPoolId", AppPoolId);
            XmlAttrib(sb, "ConnId", ConnId);
            XmlAttrib(sb, "RawConnId", RawConnId);
            XmlAttrib(sb, "RequestURL", RequestURL);
            XmlAttrib(sb, "RequestVerb", RequestVerb);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "SiteId", "AppPoolId", "ConnId", "RawConnId", "RequestURL", "RequestVerb" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return SiteId;
                case 2:
                    return AppPoolId;
                case 3:
                    return ConnId;
                case 4:
                    return RawConnId;
                case 5:
                    return RequestURL;
                case 6:
                    return RequestVerb;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralStartNewRequest> m_target;
        #endregion
    }
    public sealed class W3GeneralResponseEntityBuffer : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Buffer { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3GeneralResponseEntityBuffer(Action<W3GeneralResponseEntityBuffer> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralResponseEntityBuffer>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Buffer", Buffer);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Buffer" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Buffer;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralResponseEntityBuffer> m_target;
        #endregion
    }
    public sealed class W3GeneralResponseEntityFile : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FileName { get { return GetUnicodeStringAt(16); } }
        public long Offset { get { return GetInt64At(SkipUnicodeString(16)); } }
        public long Size { get { return GetInt64At(SkipUnicodeString(16) + 8); } }

        #region Private
        internal W3GeneralResponseEntityFile(Action<W3GeneralResponseEntityFile> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 16));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralResponseEntityFile>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FileName", FileName);
            XmlAttrib(sb, "Offset", Offset);
            XmlAttrib(sb, "Size", Size);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FileName", "Offset", "Size" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FileName;
                case 2:
                    return Offset;
                case 3:
                    return Size;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralResponseEntityFile> m_target;
        #endregion
    }
    public sealed class W3GeneralResponseHeaders : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Headers { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3GeneralResponseHeaders(Action<W3GeneralResponseHeaders> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralResponseHeaders>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Headers", Headers);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Headers" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Headers;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralResponseHeaders> m_target;
        #endregion
    }
    public sealed class W3GeneralSendCustomError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int HttpStatus { get { return GetInt32At(16); } }
        public int HttpSubStatus { get { return GetInt16At(20); } }
        public string FileNameOrURL { get { return GetUnicodeStringAt(22); } }

        #region Private
        internal W3GeneralSendCustomError(Action<W3GeneralSendCustomError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(22)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(22)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralSendCustomError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HttpStatus", HttpStatus);
            XmlAttrib(sb, "HttpSubStatus", HttpSubStatus);
            XmlAttrib(sb, "FileNameOrURL", FileNameOrURL);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HttpStatus", "HttpSubStatus", "FileNameOrURL" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HttpStatus;
                case 2:
                    return HttpSubStatus;
                case 3:
                    return FileNameOrURL;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralSendCustomError> m_target;
        #endregion
    }
    public sealed class W3GeneralSetRequestHeader : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string HeaderName { get { return GetUTF8StringAt(16); } }
        public string HeaderValue { get { return GetUTF8StringAt(SkipUTF8String(16)); } }
        public bool Replace { get { return GetInt32At(SkipUTF8String(SkipUTF8String(16))) != 0; } }

        #region Private
        internal W3GeneralSetRequestHeader(Action<W3GeneralSetRequestHeader> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUTF8String(16)) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUTF8String(16)) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralSetRequestHeader>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HeaderName", HeaderName);
            XmlAttrib(sb, "HeaderValue", HeaderValue);
            XmlAttrib(sb, "Replace", Replace);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HeaderName", "HeaderValue", "Replace" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HeaderName;
                case 2:
                    return HeaderValue;
                case 3:
                    return Replace;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralSetRequestHeader> m_target;
        #endregion
    }
    public sealed class W3GeneralStaticFileHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FileName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3GeneralStaticFileHandler(Action<W3GeneralStaticFileHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralStaticFileHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FileName", FileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralStaticFileHandler> m_target;
        #endregion
    }
    public sealed class W3GeneralTraceHandler : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3GeneralTraceHandler(Action<W3GeneralTraceHandler> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3GeneralTraceHandler>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3GeneralTraceHandler> m_target;
        #endregion
    }
    public sealed class IISGeneralHandlerChanged : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string OldHandlerName { get { return GetUnicodeStringAt(16); } }
        public string NewHandlerName { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string NewHandlerModules { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public string NewHandlerScriptProcessor { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }
        public string NewHandlerType { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))))); } }

        #region Private
        internal IISGeneralHandlerChanged(Action<IISGeneralHandlerChanged> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralHandlerChanged>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "OldHandlerName", OldHandlerName);
            XmlAttrib(sb, "NewHandlerName", NewHandlerName);
            XmlAttrib(sb, "NewHandlerModules", NewHandlerModules);
            XmlAttrib(sb, "NewHandlerScriptProcessor", NewHandlerScriptProcessor);
            XmlAttrib(sb, "NewHandlerType", NewHandlerType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "OldHandlerName", "NewHandlerName", "NewHandlerModules", "NewHandlerScriptProcessor", "NewHandlerType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return OldHandlerName;
                case 2:
                    return NewHandlerName;
                case 3:
                    return NewHandlerModules;
                case 4:
                    return NewHandlerScriptProcessor;
                case 5:
                    return NewHandlerType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralHandlerChanged> m_target;
        #endregion
    }
    public sealed class IISGeneralHandlerPreconditionNotMatch : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Name { get { return GetUnicodeStringAt(16); } }
        public string Precondition { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal IISGeneralHandlerPreconditionNotMatch(Action<IISGeneralHandlerPreconditionNotMatch> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralHandlerPreconditionNotMatch>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "Precondition", Precondition);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Name", "Precondition" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Name;
                case 2:
                    return Precondition;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralHandlerPreconditionNotMatch> m_target;
        #endregion
    }
    public sealed class IISGeneralModulePreconditionNotMatch : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Name { get { return GetUnicodeStringAt(16); } }
        public string Precondition { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal IISGeneralModulePreconditionNotMatch(Action<IISGeneralModulePreconditionNotMatch> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralModulePreconditionNotMatch>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "Precondition", Precondition);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Name", "Precondition" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Name;
                case 2:
                    return Precondition;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralModulePreconditionNotMatch> m_target;
        #endregion
    }
    public sealed class IISGeneralUrlChanged : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string OldUrl { get { return GetUnicodeStringAt(16); } }
        public string NewUrl { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal IISGeneralUrlChanged(Action<IISGeneralUrlChanged> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralUrlChanged>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "OldUrl", OldUrl);
            XmlAttrib(sb, "NewUrl", NewUrl);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "OldUrl", "NewUrl" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return OldUrl;
                case 2:
                    return NewUrl;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralUrlChanged> m_target;
        #endregion
    }
    public sealed class IISGeneralUserSet : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string AuthType { get { return GetUnicodeStringAt(16); } }
        public string UserName { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public bool SupportsIsInRole { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(16))) != 0; } }

        #region Private
        internal IISGeneralUserSet(Action<IISGeneralUserSet> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16)) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16)) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralUserSet>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "AuthType", AuthType);
            XmlAttrib(sb, "UserName", UserName);
            XmlAttrib(sb, "SupportsIsInRole", SupportsIsInRole);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "AuthType", "UserName", "SupportsIsInRole" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return AuthType;
                case 2:
                    return UserName;
                case 3:
                    return SupportsIsInRole;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralUserSet> m_target;
        #endregion
    }
    public sealed class IISGeneralVirtualModuleUnresolved : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Name { get { return GetUnicodeStringAt(16); } }
        public string Type { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal IISGeneralVirtualModuleUnresolved(Action<IISGeneralVirtualModuleUnresolved> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISGeneralVirtualModuleUnresolved>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "Type", Type);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Name", "Type" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Name;
                case 2:
                    return Type;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISGeneralVirtualModuleUnresolved> m_target;
        #endregion
    }
    public sealed class W3ISAPIEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3ISAPIEnd(Action<W3ISAPIEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3ISAPIEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3ISAPIEnd> m_target;
        #endregion
    }
    public sealed class W3ISAPIStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3ISAPIStart(Action<W3ISAPIStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3ISAPIStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3ISAPIStart> m_target;
        #endregion
    }
    public sealed class IISModuleEventsModuleCriticalError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public string Data1 { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string Data2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal IISModuleEventsModuleCriticalError(Action<IISModuleEventsModuleCriticalError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISModuleEventsModuleCriticalError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Data1", Data1);
            XmlAttrib(sb, "Data2", Data2);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Data1", "Data2", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Data1;
                case 3:
                    return Data2;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISModuleEventsModuleCriticalError> m_target;
        #endregion
    }
    public sealed class IISModuleEventsModuleEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public string Data1 { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string Data2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal IISModuleEventsModuleEnd(Action<IISModuleEventsModuleEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISModuleEventsModuleEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Data1", Data1);
            XmlAttrib(sb, "Data2", Data2);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Data1", "Data2", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Data1;
                case 3:
                    return Data2;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISModuleEventsModuleEnd> m_target;
        #endregion
    }
    public sealed class IISModuleEventsModuleError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public string Data1 { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string Data2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal IISModuleEventsModuleError(Action<IISModuleEventsModuleError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISModuleEventsModuleError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Data1", Data1);
            XmlAttrib(sb, "Data2", Data2);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Data1", "Data2", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Data1;
                case 3:
                    return Data2;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISModuleEventsModuleError> m_target;
        #endregion
    }
    public sealed class IISModuleEventsModuleInformation : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public string Data1 { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string Data2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal IISModuleEventsModuleInformation(Action<IISModuleEventsModuleInformation> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISModuleEventsModuleInformation>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Data1", Data1);
            XmlAttrib(sb, "Data2", Data2);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Data1", "Data2", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Data1;
                case 3:
                    return Data2;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISModuleEventsModuleInformation> m_target;
        #endregion
    }
    public sealed class IISModuleEventsModuleStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public string Data1 { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string Data2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal IISModuleEventsModuleStart(Action<IISModuleEventsModuleStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISModuleEventsModuleStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Data1", Data1);
            XmlAttrib(sb, "Data2", Data2);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Data1", "Data2", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Data1;
                case 3:
                    return Data2;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISModuleEventsModuleStart> m_target;
        #endregion
    }
    public sealed class IISModuleEventsModuleVerbose : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public string Data1 { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string Data2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal IISModuleEventsModuleVerbose(Action<IISModuleEventsModuleVerbose> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISModuleEventsModuleVerbose>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Data1", Data1);
            XmlAttrib(sb, "Data2", Data2);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Data1", "Data2", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Data1;
                case 3:
                    return Data2;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISModuleEventsModuleVerbose> m_target;
        #endregion
    }
    public sealed class IISModuleEventsModuleWarning : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public string Data1 { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string Data2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal IISModuleEventsModuleWarning(Action<IISModuleEventsModuleWarning> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISModuleEventsModuleWarning>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Data1", Data1);
            XmlAttrib(sb, "Data2", Data2);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Data1", "Data2", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Data1;
                case 3:
                    return Data2;
                case 4:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISModuleEventsModuleWarning> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationEventsResponseErrorStatus : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int Notification { get { return GetInt32At(SkipUnicodeString(16)); } }
        public int HttpStatus { get { return GetInt32At(SkipUnicodeString(16) + 4); } }
        public string HttpReason { get { return GetUTF8StringAt(SkipUnicodeString(16) + 8); } }
        public int HttpSubStatus { get { return GetInt16At(SkipUTF8String(SkipUnicodeString(16) + 8)); } }
        public int ErrorCode { get { return GetInt32At(SkipUTF8String(SkipUnicodeString(16) + 8) + 2); } }
        public string ConfigExceptionInfo { get { return GetUnicodeStringAt(SkipUTF8String(SkipUnicodeString(16) + 8) + 6); } }

        #region Private
        internal IISRequestNotificationEventsResponseErrorStatus(Action<IISRequestNotificationEventsResponseErrorStatus> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUTF8String(SkipUnicodeString(16) + 8) + 6)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUTF8String(SkipUnicodeString(16) + 8) + 6)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationEventsResponseErrorStatus>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Notification", Notification);
            XmlAttrib(sb, "HttpStatus", HttpStatus);
            XmlAttrib(sb, "HttpReason", HttpReason);
            XmlAttrib(sb, "HttpSubStatus", HttpSubStatus);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            XmlAttrib(sb, "ConfigExceptionInfo", ConfigExceptionInfo);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Notification", "HttpStatus", "HttpReason", "HttpSubStatus", "ErrorCode", "ConfigExceptionInfo" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Notification;
                case 3:
                    return HttpStatus;
                case 4:
                    return HttpReason;
                case 5:
                    return HttpSubStatus;
                case 6:
                    return ErrorCode;
                case 7:
                    return ConfigExceptionInfo;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationEventsResponseErrorStatus> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationEventsResponseSuccessStatus : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int Notification { get { return GetInt32At(SkipUnicodeString(16)); } }
        public int HttpStatus { get { return GetInt32At(SkipUnicodeString(16) + 4); } }
        public string HttpReason { get { return GetUTF8StringAt(SkipUnicodeString(16) + 8); } }

        #region Private
        internal IISRequestNotificationEventsResponseSuccessStatus(Action<IISRequestNotificationEventsResponseSuccessStatus> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(SkipUnicodeString(16) + 8)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(SkipUnicodeString(16) + 8)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationEventsResponseSuccessStatus>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Notification", Notification);
            XmlAttrib(sb, "HttpStatus", HttpStatus);
            XmlAttrib(sb, "HttpReason", HttpReason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Notification", "HttpStatus", "HttpReason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Notification;
                case 3:
                    return HttpStatus;
                case 4:
                    return HttpReason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationEventsResponseSuccessStatus> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationEventsCompletion : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int Notification { get { return GetInt32At(SkipUnicodeString(16)); } }
        public bool fIsPostNotificationEvent { get { return GetInt32At(SkipUnicodeString(16) + 4) != 0; } }
        public int CompletionBytes { get { return GetInt32At(SkipUnicodeString(16) + 8); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(16) + 12); } }

        #region Private
        internal IISRequestNotificationEventsCompletion(Action<IISRequestNotificationEventsCompletion> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 16));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationEventsCompletion>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Notification", Notification);
            XmlAttrib(sb, "fIsPostNotificationEvent", fIsPostNotificationEvent);
            XmlAttrib(sb, "CompletionBytes", CompletionBytes);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Notification", "fIsPostNotificationEvent", "CompletionBytes", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Notification;
                case 3:
                    return fIsPostNotificationEvent;
                case 4:
                    return CompletionBytes;
                case 5:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationEventsCompletion> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationEventsEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int Notification { get { return GetInt32At(SkipUnicodeString(16)); } }
        public bool fIsPostNotificationEvent { get { return GetInt32At(SkipUnicodeString(16) + 4) != 0; } }
        public int NotificationStatus { get { return GetInt32At(SkipUnicodeString(16) + 8); } }

        #region Private
        internal IISRequestNotificationEventsEnd(Action<IISRequestNotificationEventsEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 12));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationEventsEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Notification", Notification);
            XmlAttrib(sb, "fIsPostNotificationEvent", fIsPostNotificationEvent);
            XmlAttrib(sb, "NotificationStatus", NotificationStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Notification", "fIsPostNotificationEvent", "NotificationStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Notification;
                case 3:
                    return fIsPostNotificationEvent;
                case 4:
                    return NotificationStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationEventsEnd> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationEventsStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int Notification { get { return GetInt32At(SkipUnicodeString(16)); } }
        public bool fIsPostNotification { get { return GetInt32At(SkipUnicodeString(16) + 4) != 0; } }

        #region Private
        internal IISRequestNotificationEventsStart(Action<IISRequestNotificationEventsStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 8));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationEventsStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Notification", Notification);
            XmlAttrib(sb, "fIsPostNotification", fIsPostNotification);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Notification", "fIsPostNotification" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Notification;
                case 3:
                    return fIsPostNotification;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationEventsStart> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationPreBeginEnd : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int NotificationStatus { get { return GetInt32At(SkipUnicodeString(16)); } }

        #region Private
        internal IISRequestNotificationPreBeginEnd(Action<IISRequestNotificationPreBeginEnd> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 4));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationPreBeginEnd>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "NotificationStatus", NotificationStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "NotificationStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return NotificationStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationPreBeginEnd> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationPreBeginStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal IISRequestNotificationPreBeginStart(Action<IISRequestNotificationPreBeginStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationPreBeginStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationPreBeginStart> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationEventsError : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ModuleName { get { return GetUnicodeStringAt(16); } }
        public int Notification { get { return GetInt32At(SkipUnicodeString(16)); } }
        public int ErrorCode { get { return GetInt32At(SkipUnicodeString(16) + 4); } }

        #region Private
        internal IISRequestNotificationEventsError(Action<IISRequestNotificationEventsError> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16) + 8));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationEventsError>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            XmlAttrib(sb, "Notification", Notification);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ModuleName", "Notification", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ModuleName;
                case 2:
                    return Notification;
                case 3:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationEventsError> m_target;
        #endregion
    }
    public sealed class IISRequestNotificationEventsResponseErrorDescription : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ErrorDescription { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal IISRequestNotificationEventsResponseErrorDescription(Action<IISRequestNotificationEventsResponseErrorDescription> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IISRequestNotificationEventsResponseErrorDescription>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorDescription", ErrorDescription);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorDescription" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorDescription;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IISRequestNotificationEventsResponseErrorDescription> m_target;
        #endregion
    }
    public sealed class W3SecDeniedByAccessFlags : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int CurrentFlags { get { return GetInt32At(16); } }
        public int NeededFlags { get { return GetInt32At(20); } }

        #region Private
        internal W3SecDeniedByAccessFlags(Action<W3SecDeniedByAccessFlags> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 24));
            Debug.Assert(!(Version > 1 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecDeniedByAccessFlags>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "CurrentFlags", CurrentFlags);
            XmlAttrib(sb, "NeededFlags", NeededFlags);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "CurrentFlags", "NeededFlags" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return CurrentFlags;
                case 2:
                    return NeededFlags;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecDeniedByAccessFlags> m_target;
        #endregion
    }
    public sealed class W3SecDeniedByCGIRestriction : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ImageName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3SecDeniedByCGIRestriction(Action<W3SecDeniedByCGIRestriction> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecDeniedByCGIRestriction>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ImageName", ImageName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ImageName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ImageName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecDeniedByCGIRestriction> m_target;
        #endregion
    }
    public sealed class W3SecDeniedByISAPIRestriction : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string ImageName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3SecDeniedByISAPIRestriction(Action<W3SecDeniedByISAPIRestriction> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecDeniedByISAPIRestriction>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ImageName", ImageName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ImageName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ImageName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecDeniedByISAPIRestriction> m_target;
        #endregion
    }
    public sealed class W3SecDeniedByMimemap : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FileName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3SecDeniedByMimemap(Action<W3SecDeniedByMimemap> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecDeniedByMimemap>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FileName", FileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecDeniedByMimemap> m_target;
        #endregion
    }
    public sealed class W3SecFileAccessDenied : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FileName { get { return GetUnicodeStringAt(16); } }
        public string AccountName { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string DomainName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }

        #region Private
        internal W3SecFileAccessDenied(Action<W3SecFileAccessDenied> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecFileAccessDenied>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FileName", FileName);
            XmlAttrib(sb, "AccountName", AccountName);
            XmlAttrib(sb, "DomainName", DomainName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FileName", "AccountName", "DomainName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FileName;
                case 2:
                    return AccountName;
                case 3:
                    return DomainName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecFileAccessDenied> m_target;
        #endregion
    }
    public sealed class W3SecIllegalShortFilename : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string FileName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3SecIllegalShortFilename(Action<W3SecIllegalShortFilename> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecIllegalShortFilename>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "FileName", FileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "FileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return FileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecIllegalShortFilename> m_target;
        #endregion
    }
    public sealed class W3SecRejectedHostname : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string HostName { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal W3SecRejectedHostname(Action<W3SecRejectedHostname> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecRejectedHostname>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HostName", HostName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "HostName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return HostName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecRejectedHostname> m_target;
        #endregion
    }
    public sealed class W3SecRejectedIP : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string IPAddress { get { return GetUTF8StringAt(16); } }

        #region Private
        internal W3SecRejectedIP(Action<W3SecRejectedIP> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUTF8String(16)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUTF8String(16)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecRejectedIP>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "IPAddress", IPAddress);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "IPAddress" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return IPAddress;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecRejectedIP> m_target;
        #endregion
    }
    public sealed class W3SecRequireSSL128 : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3SecRequireSSL128(Action<W3SecRequireSSL128> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3SecRequireSSL128>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3SecRequireSSL128> m_target;
        #endregion
    }
    public sealed class W3WebSocketApplicationCloseConnection : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3WebSocketApplicationCloseConnection(Action<W3WebSocketApplicationCloseConnection> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketApplicationCloseConnection>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketApplicationCloseConnection> m_target;
        #endregion
    }
    public sealed class W3WebSocketEndFailure : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketEndFailure(Action<W3WebSocketEndFailure> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketEndFailure>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketEndFailure> m_target;
        #endregion
    }
    public sealed class W3WebSocketStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3WebSocketStart(Action<W3WebSocketStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketStart> m_target;
        #endregion
    }
    public sealed class W3WebSocketEndSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3WebSocketEndSuccess(Action<W3WebSocketEndSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketEndSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketEndSuccess> m_target;
        #endregion
    }
    public sealed class W3WebSocketInitializeNotSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketInitializeNotSuccess(Action<W3WebSocketInitializeNotSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketInitializeNotSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketInitializeNotSuccess> m_target;
        #endregion
    }
    public sealed class W3WebSocketModuleCloseConnection : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Reason { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketModuleCloseConnection(Action<W3WebSocketModuleCloseConnection> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketModuleCloseConnection>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Reason", Reason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Reason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Reason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketModuleCloseConnection> m_target;
        #endregion
    }
    public sealed class W3WebSocketReadFragmentEndFailure : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketReadFragmentEndFailure(Action<W3WebSocketReadFragmentEndFailure> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketReadFragmentEndFailure>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketReadFragmentEndFailure> m_target;
        #endregion
    }
    public sealed class W3WebSocketReadFragmentEndPending : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3WebSocketReadFragmentEndPending(Action<W3WebSocketReadFragmentEndPending> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketReadFragmentEndPending>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketReadFragmentEndPending> m_target;
        #endregion
    }
    public sealed class W3WebSocketReadFragmentEndSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int BytesReceived { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketReadFragmentEndSuccess(Action<W3WebSocketReadFragmentEndSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketReadFragmentEndSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "BytesReceived", BytesReceived);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "BytesReceived" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return BytesReceived;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketReadFragmentEndSuccess> m_target;
        #endregion
    }
    public sealed class W3WebSocketReadFragmentStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int BufferSize { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketReadFragmentStart(Action<W3WebSocketReadFragmentStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketReadFragmentStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "BufferSize", BufferSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "BufferSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return BufferSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketReadFragmentStart> m_target;
        #endregion
    }
    public sealed class W3WebSocketReadIoFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketReadIoFailed(Action<W3WebSocketReadIoFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketReadIoFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketReadIoFailed> m_target;
        #endregion
    }
    public sealed class W3WebSocketCloseReceived : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Status { get { return GetInt32At(16); } }
        public string Reason { get { return GetUnicodeStringAt(20); } }

        #region Private
        internal W3WebSocketCloseReceived(Action<W3WebSocketCloseReceived> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(20)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(20)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketCloseReceived>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "Reason", Reason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Status", "Reason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Status;
                case 2:
                    return Reason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketCloseReceived> m_target;
        #endregion
    }
    public sealed class W3WebSocketCloseSendFailure : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketCloseSendFailure(Action<W3WebSocketCloseSendFailure> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketCloseSendFailure>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketCloseSendFailure> m_target;
        #endregion
    }
    public sealed class W3WebSocketCloseSendSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3WebSocketCloseSendSuccess(Action<W3WebSocketCloseSendSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketCloseSendSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketCloseSendSuccess> m_target;
        #endregion
    }
    public sealed class W3WebSocketCloseSendStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int Status { get { return GetInt32At(16); } }
        public string Reason { get { return GetUnicodeStringAt(20); } }

        #region Private
        internal W3WebSocketCloseSendStart(Action<W3WebSocketCloseSendStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(20)));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(20)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketCloseSendStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "Reason", Reason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Status", "Reason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Status;
                case 2:
                    return Reason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketCloseSendStart> m_target;
        #endregion
    }
    public sealed class W3WebSocketWriteFragmentEndFailure : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketWriteFragmentEndFailure(Action<W3WebSocketWriteFragmentEndFailure> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketWriteFragmentEndFailure>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketWriteFragmentEndFailure> m_target;
        #endregion
    }
    public sealed class W3WebSocketWriteFragmentEndPending : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }

        #region Private
        internal W3WebSocketWriteFragmentEndPending(Action<W3WebSocketWriteFragmentEndPending> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketWriteFragmentEndPending>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketWriteFragmentEndPending> m_target;
        #endregion
    }
    public sealed class W3WebSocketWriteFragmentEndSuccess : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int BytesSent { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketWriteFragmentEndSuccess(Action<W3WebSocketWriteFragmentEndSuccess> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketWriteFragmentEndSuccess>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "BytesSent", BytesSent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "BytesSent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return BytesSent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketWriteFragmentEndSuccess> m_target;
        #endregion
    }
    public sealed class W3WebSocketWriteFragmentStart : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int DataType { get { return GetInt32At(16); } }
        public int DataSize { get { return GetInt32At(20); } }

        #region Private
        internal W3WebSocketWriteFragmentStart(Action<W3WebSocketWriteFragmentStart> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 24));
            Debug.Assert(!(Version > 1 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketWriteFragmentStart>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "DataType", DataType);
            XmlAttrib(sb, "DataSize", DataSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "DataType", "DataSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return DataType;
                case 2:
                    return DataSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketWriteFragmentStart> m_target;
        #endregion
    }
    public sealed class W3WebSocketWriteIoFailed : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public int ErrorCode { get { return GetInt32At(16); } }

        #region Private
        internal W3WebSocketWriteIoFailed(Action<W3WebSocketWriteIoFailed> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 20));
            Debug.Assert(!(Version > 1 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<W3WebSocketWriteIoFailed>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "ErrorCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return ErrorCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<W3WebSocketWriteIoFailed> m_target;
        #endregion
    }
}
