using System;
using System.Diagnostics;
using System.Text;
using Address = System.UInt64;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    using Microsoft.Diagnostics.Tracing.Parsers.FrameworkEventSource;

    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
    public sealed class FrameworkEventSourceTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "FrameworkEventSource";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0x8e9f5090), unchecked((short)0x2d75), unchecked((short)0x4d03), 0x8a, 0x81, 0xe5, 0xaf, 0xbf, 0x85, 0xda, 0xf1);
        public enum Keywords : long
        {
            Loader = 0x1,
            ThreadPool = 0x2,
            NetClient = 0x4,
            DynamicTypeUsage = 0x8,
            ThreadTransfer = 0x10,
        };

        public FrameworkEventSourceTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<ActivatorCreateInstanceArgs> ActivatorCreateInstance
        {
            add
            {
                source.RegisterEventTemplate(ActivatorCreateInstanceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 32, ProviderGuid);
            }
        }
        public event Action<ActivatorCreateInstanceTArgs> ActivatorCreateInstanceT
        {
            add
            {
                source.RegisterEventTemplate(ActivatorCreateInstanceTTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 33, ProviderGuid);
            }
        }
        public event Action<ArrayCreateInstanceArgs> ArrayCreateInstance
        {
            add
            {
                source.RegisterEventTemplate(ArrayCreateInstanceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 34, ProviderGuid);
            }
        }
        public event Action<AssemblyGetTypeArgs> AssemblyGetType
        {
            add
            {
                source.RegisterEventTemplate(AssemblyGetTypeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 36, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> BeginCreateIReference
        {
            add
            {
                source.RegisterEventTemplate(BeginCreateIReferenceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 82, ProviderGuid);
            }
        }
        public event Action<BeginCustomPropertyImplGetValueArgs> BeginCustomPropertyImplGetValue
        {
            add
            {
                source.RegisterEventTemplate(BeginCustomPropertyImplGetValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 119, ProviderGuid);
            }
        }
        public event Action<BeginCustomPropertyImplGetValueIndexValueArgs> BeginCustomPropertyImplGetValueIndexValue
        {
            add
            {
                source.RegisterEventTemplate(BeginCustomPropertyImplGetValueIndexValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 121, ProviderGuid);
            }
        }
        public event Action<BeginCustomPropertyImplSetValueArgs> BeginCustomPropertyImplSetValue
        {
            add
            {
                source.RegisterEventTemplate(BeginCustomPropertyImplSetValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 123, ProviderGuid);
            }
        }
        public event Action<BeginCustomPropertyImplSetValueIndexValueArgs> BeginCustomPropertyImplSetValueIndexValue
        {
            add
            {
                source.RegisterEventTemplate(BeginCustomPropertyImplSetValueIndexValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 125, ProviderGuid);
            }
        }
        public event Action<BeginEnumFormatArgs> BeginEnumFormat
        {
            add
            {
                source.RegisterEventTemplate(BeginEnumFormatTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 47, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> BeginGetFieldFromHandle
        {
            add
            {
                source.RegisterEventTemplate(BeginGetFieldFromHandleTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 39, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> BeginGetMethodFromHandle
        {
            add
            {
                source.RegisterEventTemplate(BeginGetMethodFromHandleTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 37, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeConstructorsArgs> BeginGetRuntimeConstructors
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeConstructorsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 128, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeEventArgs> BeginGetRuntimeEvent
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeEventTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 68, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeEventsArgs> BeginGetRuntimeEvents
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeEventsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 60, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeFieldArgs> BeginGetRuntimeField
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeFieldTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 72, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeFieldsArgs> BeginGetRuntimeFields
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeFieldsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 64, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeMembersArgs> BeginGetRuntimeMembers
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeMembersTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 130, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeMethodArgs> BeginGetRuntimeMethod
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeMethodTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 70, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimeMethodsArgs> BeginGetRuntimeMethods
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimeMethodsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 62, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimePropertiesArgs> BeginGetRuntimeProperties
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimePropertiesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 58, ProviderGuid);
            }
        }
        public event Action<BeginGetRuntimePropertyArgs> BeginGetRuntimeProperty
        {
            add
            {
                source.RegisterEventTemplate(BeginGetRuntimePropertyTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 66, ProviderGuid);
            }
        }
        public event Action<BeginICustomPropertyProviderCreateIndexedPropertyArgs> BeginICustomPropertyProviderCreateIndexedProperty
        {
            add
            {
                source.RegisterEventTemplate(BeginICustomPropertyProviderCreateIndexedPropertyTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 117, ProviderGuid);
            }
        }
        public event Action<BeginICustomPropertyProviderCreatePropertyArgs> BeginICustomPropertyProviderCreateProperty
        {
            add
            {
                source.RegisterEventTemplate(BeginICustomPropertyProviderCreatePropertyTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 115, ProviderGuid);
            }
        }
        public event Action<BeginMarshalOffsetOfArgs> BeginMarshalOffsetOf
        {
            add
            {
                source.RegisterEventTemplate(BeginMarshalOffsetOfTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 107, ProviderGuid);
            }
        }
        public event Action<BeginMarshalPtrToStructureArgs> BeginMarshalPtrToStructure
        {
            add
            {
                source.RegisterEventTemplate(BeginMarshalPtrToStructureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 109, ProviderGuid);
            }
        }
        public event Action<BeginMethodInfoCreateDelegateArgs> BeginMethodInfoCreateDelegate
        {
            add
            {
                source.RegisterEventTemplate(BeginMethodInfoCreateDelegateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 80, ProviderGuid);
            }
        }
        public event Action<BeginTypeAssemblyQualifiedNameArgs> BeginTypeAssemblyQualifiedName
        {
            add
            {
                source.RegisterEventTemplate(BeginTypeAssemblyQualifiedNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 51, ProviderGuid);
            }
        }
        public event Action<ConstructorInfoInvokeArgs> ConstructorInfoInvoke
        {
            add
            {
                source.RegisterEventTemplate(ConstructorInfoInvokeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 84, ProviderGuid);
            }
        }
        public event Action<EndCreateIReferenceArgs> EndCreateIReference
        {
            add
            {
                source.RegisterEventTemplate(EndCreateIReferenceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 83, ProviderGuid);
            }
        }
        public event Action<EndCustomPropertyImplGetValueArgs> EndCustomPropertyImplGetValue
        {
            add
            {
                source.RegisterEventTemplate(EndCustomPropertyImplGetValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 120, ProviderGuid);
            }
        }
        public event Action<EndCustomPropertyImplGetValueIndexValueArgs> EndCustomPropertyImplGetValueIndexValue
        {
            add
            {
                source.RegisterEventTemplate(EndCustomPropertyImplGetValueIndexValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 122, ProviderGuid);
            }
        }
        public event Action<EndCustomPropertyImplSetValueArgs> EndCustomPropertyImplSetValue
        {
            add
            {
                source.RegisterEventTemplate(EndCustomPropertyImplSetValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 124, ProviderGuid);
            }
        }
        public event Action<EndCustomPropertyImplSetValueIndexValueArgs> EndCustomPropertyImplSetValueIndexValue
        {
            add
            {
                source.RegisterEventTemplate(EndCustomPropertyImplSetValueIndexValueTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 126, ProviderGuid);
            }
        }
        public event Action<EndEnumFormatArgs> EndEnumFormat
        {
            add
            {
                source.RegisterEventTemplate(EndEnumFormatTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 48, ProviderGuid);
            }
        }
        public event Action<EndGetFieldFromHandleArgs> EndGetFieldFromHandle
        {
            add
            {
                source.RegisterEventTemplate(EndGetFieldFromHandleTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 40, ProviderGuid);
            }
        }
        public event Action<EndGetMethodFromHandleArgs> EndGetMethodFromHandle
        {
            add
            {
                source.RegisterEventTemplate(EndGetMethodFromHandleTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 38, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeConstructorsArgs> EndGetRuntimeConstructors
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeConstructorsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 129, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeEventArgs> EndGetRuntimeEvent
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeEventTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 69, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeEventsArgs> EndGetRuntimeEvents
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeEventsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 61, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeFieldArgs> EndGetRuntimeField
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeFieldTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 73, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeFieldsArgs> EndGetRuntimeFields
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeFieldsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 65, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeMembersArgs> EndGetRuntimeMembers
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeMembersTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 131, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeMethodArgs> EndGetRuntimeMethod
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeMethodTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 71, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimeMethodsArgs> EndGetRuntimeMethods
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimeMethodsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 63, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimePropertiesArgs> EndGetRuntimeProperties
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimePropertiesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 59, ProviderGuid);
            }
        }
        public event Action<EndGetRuntimePropertyArgs> EndGetRuntimeProperty
        {
            add
            {
                source.RegisterEventTemplate(EndGetRuntimePropertyTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 67, ProviderGuid);
            }
        }
        public event Action<EndICustomPropertyProviderCreateIndexedPropertyArgs> EndICustomPropertyProviderCreateIndexedProperty
        {
            add
            {
                source.RegisterEventTemplate(EndICustomPropertyProviderCreateIndexedPropertyTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 118, ProviderGuid);
            }
        }
        public event Action<EndICustomPropertyProviderCreatePropertyArgs> EndICustomPropertyProviderCreateProperty
        {
            add
            {
                source.RegisterEventTemplate(EndICustomPropertyProviderCreatePropertyTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 116, ProviderGuid);
            }
        }
        public event Action<EndMarshalOffsetOfArgs> EndMarshalOffsetOf
        {
            add
            {
                source.RegisterEventTemplate(EndMarshalOffsetOfTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 108, ProviderGuid);
            }
        }
        public event Action<EndMarshalPtrToStructureArgs> EndMarshalPtrToStructure
        {
            add
            {
                source.RegisterEventTemplate(EndMarshalPtrToStructureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 110, ProviderGuid);
            }
        }
        public event Action<EndMethodInfoCreateDelegateArgs> EndMethodInfoCreateDelegate
        {
            add
            {
                source.RegisterEventTemplate(EndMethodInfoCreateDelegateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 81, ProviderGuid);
            }
        }
        public event Action<EndTypeAssemblyQualifiedNameArgs> EndTypeAssemblyQualifiedName
        {
            add
            {
                source.RegisterEventTemplate(EndTypeAssemblyQualifiedNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 52, ProviderGuid);
            }
        }
        public event Action<EnumGetNameArgs> EnumGetName
        {
            add
            {
                source.RegisterEventTemplate(EnumGetNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 44, ProviderGuid);
            }
        }
        public event Action<EnumGetNamesArgs> EnumGetNames
        {
            add
            {
                source.RegisterEventTemplate(EnumGetNamesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 45, ProviderGuid);
            }
        }
        public event Action<EnumGetUnderlyingTypeArgs> EnumGetUnderlyingType
        {
            add
            {
                source.RegisterEventTemplate(EnumGetUnderlyingTypeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 42, ProviderGuid);
            }
        }
        public event Action<EnumGetValuesArgs> EnumGetValues
        {
            add
            {
                source.RegisterEventTemplate(EnumGetValuesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 43, ProviderGuid);
            }
        }
        public event Action<EnumIsDefinedArgs> EnumIsDefined
        {
            add
            {
                source.RegisterEventTemplate(EnumIsDefinedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 46, ProviderGuid);
            }
        }
        public event Action<EnumToObjectArgs> EnumToObject
        {
            add
            {
                source.RegisterEventTemplate(EnumToObjectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 49, ProviderGuid);
            }
        }
        public event Action<EnumTryParseEnumArgs> EnumTryParseEnum
        {
            add
            {
                source.RegisterEventTemplate(EnumTryParseEnumTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 41, ProviderGuid);
            }
        }
        public event Action<EventNameArgs> EventName
        {
            add
            {
                source.RegisterEventTemplate(EventNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 132, ProviderGuid);
            }
        }
        public event Action<FieldNameArgs> FieldName
        {
            add
            {
                source.RegisterEventTemplate(FieldNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 55, ProviderGuid);
            }
        }
        public event Action<BeginGetRequestStreamArgs> GetRequestStreamStart
        {
            add
            {
                source.RegisterEventTemplate(GetRequestStreamStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 142, ProviderGuid);
            }
        }
        public event Action<EndGetRequestStreamArgs> GetRequestStreamStop
        {
            add
            {
                source.RegisterEventTemplate(GetRequestStreamStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 143, ProviderGuid);
            }
        }
        public event Action<BeginGetResponseArgs> GetResponseStart
        {
            add
            {
                source.RegisterEventTemplate(GetResponseStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 140, ProviderGuid);
            }
        }
        public event Action<EndGetResponseArgs> GetResponseStop
        {
            add
            {
                source.RegisterEventTemplate(GetResponseStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 141, ProviderGuid);
            }
        }
        public event Action<IntrospectionExtensionsGetTypeInfoArgs> IntrospectionExtensionsGetTypeInfo
        {
            add
            {
                source.RegisterEventTemplate(IntrospectionExtensionsGetTypeInfoTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 57, ProviderGuid);
            }
        }
        public event Action<ManagedActivationFactoryConstructorArgs> ManagedActivationFactoryConstructor
        {
            add
            {
                source.RegisterEventTemplate(ManagedActivationFactoryConstructorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 87, ProviderGuid);
            }
        }
        public event Action<MarshalAsAnyConvertToManagedArgs> MarshalAsAnyConvertToManaged
        {
            add
            {
                source.RegisterEventTemplate(MarshalAsAnyConvertToManagedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 86, ProviderGuid);
            }
        }
        public event Action<MarshalAsAnyConvertToNativeArgs> MarshalAsAnyConvertToNative
        {
            add
            {
                source.RegisterEventTemplate(MarshalAsAnyConvertToNativeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 85, ProviderGuid);
            }
        }
        public event Action<MarshalCreateAggregatedObjectArgs> MarshalCreateAggregatedObject
        {
            add
            {
                source.RegisterEventTemplate(MarshalCreateAggregatedObjectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 89, ProviderGuid);
            }
        }
        public event Action<MarshalCreateWrapperOfTypeArgs> MarshalCreateWrapperOfType
        {
            add
            {
                source.RegisterEventTemplate(MarshalCreateWrapperOfTypeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 90, ProviderGuid);
            }
        }
        public event Action<MarshalDestroyStructureArgs> MarshalDestroyStructure
        {
            add
            {
                source.RegisterEventTemplate(MarshalDestroyStructureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 91, ProviderGuid);
            }
        }
        public event Action<MarshalGetComInterfaceForObjectArgs> MarshalGetComInterfaceForObject
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetComInterfaceForObjectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 92, ProviderGuid);
            }
        }
        public event Action<MarshalGetDelegateForFunctionPointerArgs> MarshalGetDelegateForFunctionPointer
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetDelegateForFunctionPointerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 93, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MarshalGetExceptionCode
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetExceptionCodeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 94, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MarshalGetExceptionForHR
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetExceptionForHRTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 95, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MarshalGetExceptionForHR2
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetExceptionForHR2Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 96, ProviderGuid);
            }
        }
        public event Action<MarshalGetFunctionPointerForDelegateArgs> MarshalGetFunctionPointerForDelegate
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetFunctionPointerForDelegateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 97, ProviderGuid);
            }
        }
        public event Action<MarshalGetIUnknownForObjectArgs> MarshalGetIUnknownForObject
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetIUnknownForObjectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 98, ProviderGuid);
            }
        }
        public event Action<MarshalGetNativeVariantForObjectArgs> MarshalGetNativeVariantForObject
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetNativeVariantForObjectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 99, ProviderGuid);
            }
        }
        public event Action<MarshalGetObjectForIUnknownArgs> MarshalGetObjectForIUnknown
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetObjectForIUnknownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 100, ProviderGuid);
            }
        }
        public event Action<MarshalGetObjectForNativeVariantArgs> MarshalGetObjectForNativeVariant
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetObjectForNativeVariantTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 101, ProviderGuid);
            }
        }
        public event Action<MarshalGetObjectsForNativeVariantsArgs> MarshalGetObjectsForNativeVariants
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetObjectsForNativeVariantsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 102, ProviderGuid);
            }
        }
        public event Action<MarshalGetStartComSlotArgs> MarshalGetStartComSlot
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetStartComSlotTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 103, ProviderGuid);
            }
        }
        public event Action<MarshalGetTypeFromCLSIDArgs> MarshalGetTypeFromCLSID
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetTypeFromCLSIDTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 104, ProviderGuid);
            }
        }
        public event Action<MarshalGetTypeInfoNameArgs> MarshalGetTypeInfoName
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetTypeInfoNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 105, ProviderGuid);
            }
        }
        public event Action<MarshalGetUniqueObjectForIUnknownArgs> MarshalGetUniqueObjectForIUnknown
        {
            add
            {
                source.RegisterEventTemplate(MarshalGetUniqueObjectForIUnknownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 106, ProviderGuid);
            }
        }
        public event Action<MarshalSizeOfArgs> MarshalSizeOf
        {
            add
            {
                source.RegisterEventTemplate(MarshalSizeOfTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 111, ProviderGuid);
            }
        }
        public event Action<MarshalStructureToPtrArgs> MarshalStructureToPtr
        {
            add
            {
                source.RegisterEventTemplate(MarshalStructureToPtrTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 112, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MarshalThrowExceptionForHR
        {
            add
            {
                source.RegisterEventTemplate(MarshalThrowExceptionForHRTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 113, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> MarshalThrowExceptionForHR2
        {
            add
            {
                source.RegisterEventTemplate(MarshalThrowExceptionForHR2Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 127, ProviderGuid);
            }
        }
        public event Action<MarshalUnsafeAddrOfPinnedArrayElementArgs> MarshalUnsafeAddrOfPinnedArrayElement
        {
            add
            {
                source.RegisterEventTemplate(MarshalUnsafeAddrOfPinnedArrayElementTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 114, ProviderGuid);
            }
        }
        public event Action<MethodInfoInvokeArgs> MethodInfoInvoke
        {
            add
            {
                source.RegisterEventTemplate(MethodInfoInvokeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 79, ProviderGuid);
            }
        }
        public event Action<MethodNameArgs> MethodName
        {
            add
            {
                source.RegisterEventTemplate(MethodNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 54, ProviderGuid);
            }
        }
        public event Action<QueryAttributeIsDefinedArgs> QueryAttributeIsDefined
        {
            add
            {
                source.RegisterEventTemplate(QueryAttributeIsDefinedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 133, ProviderGuid);
            }
        }
        public event Action<ResourceManagerAddingCultureFromConfigFileArgs> ResourceManagerAddingCultureFromConfigFile
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerAddingCultureFromConfigFileTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 20, ProviderGuid);
            }
        }
        public event Action<ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs> ResourceManagerCaseInsensitiveResourceStreamLookupFailed
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerCaseInsensitiveResourceStreamLookupFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, ProviderGuid);
            }
        }
        public event Action<ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs> ResourceManagerCaseInsensitiveResourceStreamLookupSucceeded
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerCaseInsensitiveResourceStreamLookupSucceededTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 9, ProviderGuid);
            }
        }
        public event Action<ResourceManagerCreatingResourceSetArgs> ResourceManagerCreatingResourceSet
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerCreatingResourceSetTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 14, ProviderGuid);
            }
        }
        public event Action<ResourceManagerCultureFoundInConfigFileArgs> ResourceManagerCultureFoundInConfigFile
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerCultureFoundInConfigFileTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 22, ProviderGuid);
            }
        }
        public event Action<ResourceManagerCultureNotFoundInConfigFileArgs> ResourceManagerCultureNotFoundInConfigFile
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerCultureNotFoundInConfigFileTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 21, ProviderGuid);
            }
        }
        public event Action<ResourceManagerFoundResourceSetInCacheArgs> ResourceManagerFoundResourceSetInCache
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerFoundResourceSetInCacheTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3, ProviderGuid);
            }
        }
        public event Action<ResourceManagerFoundResourceSetInCacheUnexpectedArgs> ResourceManagerFoundResourceSetInCacheUnexpected
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerFoundResourceSetInCacheUnexpectedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4, ProviderGuid);
            }
        }
        public event Action<ResourceManagerGetSatelliteAssemblyFailedArgs> ResourceManagerGetSatelliteAssemblyFailed
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerGetSatelliteAssemblyFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 8, ProviderGuid);
            }
        }
        public event Action<ResourceManagerGetSatelliteAssemblySucceededArgs> ResourceManagerGetSatelliteAssemblySucceeded
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerGetSatelliteAssemblySucceededTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 7, ProviderGuid);
            }
        }
        public event Action<ResourceManagerLookingForResourceSetArgs> ResourceManagerLookingForResourceSet
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerLookingForResourceSetTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, ProviderGuid);
            }
        }
        public event Action<ResourceManagerLookupFailedArgs> ResourceManagerLookupFailed
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerLookupFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 16, ProviderGuid);
            }
        }
        public event Action<ResourceManagerLookupStartedArgs> ResourceManagerLookupStarted
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerLookupStartedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, ProviderGuid);
            }
        }
        public event Action<ResourceManagerManifestResourceAccessDeniedArgs> ResourceManagerManifestResourceAccessDenied
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerManifestResourceAccessDeniedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, ProviderGuid);
            }
        }
        public event Action<ResourceManagerNeutralResourceAttributeMissingArgs> ResourceManagerNeutralResourceAttributeMissing
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerNeutralResourceAttributeMissingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, ProviderGuid);
            }
        }
        public event Action<ResourceManagerNeutralResourcesFoundArgs> ResourceManagerNeutralResourcesFound
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerNeutralResourcesFoundTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 19, ProviderGuid);
            }
        }
        public event Action<ResourceManagerNeutralResourcesNotFoundArgs> ResourceManagerNeutralResourcesNotFound
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerNeutralResourcesNotFoundTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 18, ProviderGuid);
            }
        }
        public event Action<ResourceManagerNeutralResourcesSufficientArgs> ResourceManagerNeutralResourcesSufficient
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerNeutralResourcesSufficientTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
            }
        }
        public event Action<ResourceManagerNotCreatingResourceSetArgs> ResourceManagerNotCreatingResourceSet
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerNotCreatingResourceSetTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 15, ProviderGuid);
            }
        }
        public event Action<ResourceManagerReleasingResourcesArgs> ResourceManagerReleasingResources
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerReleasingResourcesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 17, ProviderGuid);
            }
        }
        public event Action<ResourceManagerStreamFoundArgs> ResourceManagerStreamFound
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerStreamFoundTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5, ProviderGuid);
            }
        }
        public event Action<ResourceManagerStreamNotFoundArgs> ResourceManagerStreamNotFound
        {
            add
            {
                source.RegisterEventTemplate(ResourceManagerStreamNotFoundTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 6, ProviderGuid);
            }
        }
        public event Action<ThreadPoolDequeueWorkArgs> ThreadPoolDequeueWork
        {
            add
            {
                source.RegisterEventTemplate(ThreadPoolDequeueWorkTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 31, ProviderGuid);
            }
        }
        public event Action<ThreadPoolEnqueueWorkArgs> ThreadPoolEnqueueWork
        {
            add
            {
                source.RegisterEventTemplate(ThreadPoolEnqueueWorkTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 30, ProviderGuid);
            }
        }
        public event Action<ThreadTransferReceiveArgs> ThreadTransferReceive
        {
            add
            {
                source.RegisterEventTemplate(ThreadTransferReceiveTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 151, ProviderGuid);
            }
        }
        public event Action<ThreadTransferReceiveHandledArgs> ThreadTransferReceiveHandled
        {
            add
            {
                source.RegisterEventTemplate(ThreadTransferReceiveHandledTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 152, ProviderGuid);
            }
        }
        public event Action<ThreadTransferSendArgs> ThreadTransferSend
        {
            add
            {
                source.RegisterEventTemplate(ThreadTransferSendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 150, ProviderGuid);
            }
        }
        public event Action<TypeFullNameArgs> TypeFullName
        {
            add
            {
                source.RegisterEventTemplate(TypeFullNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 50, ProviderGuid);
            }
        }
        public event Action<TypeGetTypeArgs> TypeGetType
        {
            add
            {
                source.RegisterEventTemplate(TypeGetTypeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 35, ProviderGuid);
            }
        }
        public event Action<TypeNameArgs> TypeName
        {
            add
            {
                source.RegisterEventTemplate(TypeNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 56, ProviderGuid);
            }
        }
        public event Action<TypeNamespaceArgs> TypeNamespace
        {
            add
            {
                source.RegisterEventTemplate(TypeNamespaceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 53, ProviderGuid);
            }
        }
        public event Action<WindowsRuntimeMarshalGetActivationFactoryArgs> WindowsRuntimeMarshalGetActivationFactory
        {
            add
            {
                source.RegisterEventTemplate(WindowsRuntimeMarshalGetActivationFactoryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 88, ProviderGuid);
            }
        }

        #region private
        protected override string GetProviderName() { return ProviderName; }

        static private ActivatorCreateInstanceArgs ActivatorCreateInstanceTemplate(Action<ActivatorCreateInstanceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ActivatorCreateInstanceArgs(action, 32, 65502, "ActivatorCreateInstance", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ActivatorCreateInstanceTArgs ActivatorCreateInstanceTTemplate(Action<ActivatorCreateInstanceTArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ActivatorCreateInstanceTArgs(action, 33, 65501, "ActivatorCreateInstanceT", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ArrayCreateInstanceArgs ArrayCreateInstanceTemplate(Action<ArrayCreateInstanceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ArrayCreateInstanceArgs(action, 34, 65500, "ArrayCreateInstance", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private AssemblyGetTypeArgs AssemblyGetTypeTemplate(Action<AssemblyGetTypeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new AssemblyGetTypeArgs(action, 36, 65498, "AssemblyGetType", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData BeginCreateIReferenceTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 82, 65452, "BeginCreateIReference", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginCustomPropertyImplGetValueArgs BeginCustomPropertyImplGetValueTemplate(Action<BeginCustomPropertyImplGetValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginCustomPropertyImplGetValueArgs(action, 119, 65415, "BeginCustomPropertyImplGetValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginCustomPropertyImplGetValueIndexValueArgs BeginCustomPropertyImplGetValueIndexValueTemplate(Action<BeginCustomPropertyImplGetValueIndexValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginCustomPropertyImplGetValueIndexValueArgs(action, 121, 65413, "BeginCustomPropertyImplGetValueIndexValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginCustomPropertyImplSetValueArgs BeginCustomPropertyImplSetValueTemplate(Action<BeginCustomPropertyImplSetValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginCustomPropertyImplSetValueArgs(action, 123, 65411, "BeginCustomPropertyImplSetValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginCustomPropertyImplSetValueIndexValueArgs BeginCustomPropertyImplSetValueIndexValueTemplate(Action<BeginCustomPropertyImplSetValueIndexValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginCustomPropertyImplSetValueIndexValueArgs(action, 125, 65409, "BeginCustomPropertyImplSetValueIndexValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginEnumFormatArgs BeginEnumFormatTemplate(Action<BeginEnumFormatArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginEnumFormatArgs(action, 47, 65487, "BeginEnumFormat", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData BeginGetFieldFromHandleTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 39, 65495, "BeginGetFieldFromHandle", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData BeginGetMethodFromHandleTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 37, 65497, "BeginGetMethodFromHandle", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeConstructorsArgs BeginGetRuntimeConstructorsTemplate(Action<BeginGetRuntimeConstructorsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeConstructorsArgs(action, 128, 65406, "BeginGetRuntimeConstructors", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeEventArgs BeginGetRuntimeEventTemplate(Action<BeginGetRuntimeEventArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeEventArgs(action, 68, 65466, "BeginGetRuntimeEvent", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeEventsArgs BeginGetRuntimeEventsTemplate(Action<BeginGetRuntimeEventsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeEventsArgs(action, 60, 65474, "BeginGetRuntimeEvents", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeFieldArgs BeginGetRuntimeFieldTemplate(Action<BeginGetRuntimeFieldArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeFieldArgs(action, 72, 65462, "BeginGetRuntimeField", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeFieldsArgs BeginGetRuntimeFieldsTemplate(Action<BeginGetRuntimeFieldsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeFieldsArgs(action, 64, 65470, "BeginGetRuntimeFields", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeMembersArgs BeginGetRuntimeMembersTemplate(Action<BeginGetRuntimeMembersArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeMembersArgs(action, 130, 65404, "BeginGetRuntimeMembers", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeMethodArgs BeginGetRuntimeMethodTemplate(Action<BeginGetRuntimeMethodArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeMethodArgs(action, 70, 65464, "BeginGetRuntimeMethod", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimeMethodsArgs BeginGetRuntimeMethodsTemplate(Action<BeginGetRuntimeMethodsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimeMethodsArgs(action, 62, 65472, "BeginGetRuntimeMethods", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimePropertiesArgs BeginGetRuntimePropertiesTemplate(Action<BeginGetRuntimePropertiesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimePropertiesArgs(action, 58, 65476, "BeginGetRuntimeProperties", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRuntimePropertyArgs BeginGetRuntimePropertyTemplate(Action<BeginGetRuntimePropertyArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRuntimePropertyArgs(action, 66, 65468, "BeginGetRuntimeProperty", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginICustomPropertyProviderCreateIndexedPropertyArgs BeginICustomPropertyProviderCreateIndexedPropertyTemplate(Action<BeginICustomPropertyProviderCreateIndexedPropertyArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginICustomPropertyProviderCreateIndexedPropertyArgs(action, 117, 65417, "BeginICustomPropertyProviderCreateIndexedProperty", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginICustomPropertyProviderCreatePropertyArgs BeginICustomPropertyProviderCreatePropertyTemplate(Action<BeginICustomPropertyProviderCreatePropertyArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginICustomPropertyProviderCreatePropertyArgs(action, 115, 65419, "BeginICustomPropertyProviderCreateProperty", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginMarshalOffsetOfArgs BeginMarshalOffsetOfTemplate(Action<BeginMarshalOffsetOfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginMarshalOffsetOfArgs(action, 107, 65427, "BeginMarshalOffsetOf", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginMarshalPtrToStructureArgs BeginMarshalPtrToStructureTemplate(Action<BeginMarshalPtrToStructureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginMarshalPtrToStructureArgs(action, 109, 65425, "BeginMarshalPtrToStructure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginMethodInfoCreateDelegateArgs BeginMethodInfoCreateDelegateTemplate(Action<BeginMethodInfoCreateDelegateArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginMethodInfoCreateDelegateArgs(action, 80, 65454, "BeginMethodInfoCreateDelegate", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginTypeAssemblyQualifiedNameArgs BeginTypeAssemblyQualifiedNameTemplate(Action<BeginTypeAssemblyQualifiedNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginTypeAssemblyQualifiedNameArgs(action, 51, 65483, "BeginTypeAssemblyQualifiedName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ConstructorInfoInvokeArgs ConstructorInfoInvokeTemplate(Action<ConstructorInfoInvokeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ConstructorInfoInvokeArgs(action, 84, 65450, "ConstructorInfoInvoke", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndCreateIReferenceArgs EndCreateIReferenceTemplate(Action<EndCreateIReferenceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndCreateIReferenceArgs(action, 83, 65451, "EndCreateIReference", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndCustomPropertyImplGetValueArgs EndCustomPropertyImplGetValueTemplate(Action<EndCustomPropertyImplGetValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndCustomPropertyImplGetValueArgs(action, 120, 65414, "EndCustomPropertyImplGetValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndCustomPropertyImplGetValueIndexValueArgs EndCustomPropertyImplGetValueIndexValueTemplate(Action<EndCustomPropertyImplGetValueIndexValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndCustomPropertyImplGetValueIndexValueArgs(action, 122, 65412, "EndCustomPropertyImplGetValueIndexValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndCustomPropertyImplSetValueArgs EndCustomPropertyImplSetValueTemplate(Action<EndCustomPropertyImplSetValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndCustomPropertyImplSetValueArgs(action, 124, 65410, "EndCustomPropertyImplSetValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndCustomPropertyImplSetValueIndexValueArgs EndCustomPropertyImplSetValueIndexValueTemplate(Action<EndCustomPropertyImplSetValueIndexValueArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndCustomPropertyImplSetValueIndexValueArgs(action, 126, 65408, "EndCustomPropertyImplSetValueIndexValue", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndEnumFormatArgs EndEnumFormatTemplate(Action<EndEnumFormatArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndEnumFormatArgs(action, 48, 65486, "EndEnumFormat", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetFieldFromHandleArgs EndGetFieldFromHandleTemplate(Action<EndGetFieldFromHandleArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetFieldFromHandleArgs(action, 40, 65494, "EndGetFieldFromHandle", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetMethodFromHandleArgs EndGetMethodFromHandleTemplate(Action<EndGetMethodFromHandleArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetMethodFromHandleArgs(action, 38, 65496, "EndGetMethodFromHandle", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeConstructorsArgs EndGetRuntimeConstructorsTemplate(Action<EndGetRuntimeConstructorsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeConstructorsArgs(action, 129, 65405, "EndGetRuntimeConstructors", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeEventArgs EndGetRuntimeEventTemplate(Action<EndGetRuntimeEventArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeEventArgs(action, 69, 65465, "EndGetRuntimeEvent", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeEventsArgs EndGetRuntimeEventsTemplate(Action<EndGetRuntimeEventsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeEventsArgs(action, 61, 65473, "EndGetRuntimeEvents", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeFieldArgs EndGetRuntimeFieldTemplate(Action<EndGetRuntimeFieldArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeFieldArgs(action, 73, 65461, "EndGetRuntimeField", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeFieldsArgs EndGetRuntimeFieldsTemplate(Action<EndGetRuntimeFieldsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeFieldsArgs(action, 65, 65469, "EndGetRuntimeFields", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeMembersArgs EndGetRuntimeMembersTemplate(Action<EndGetRuntimeMembersArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeMembersArgs(action, 131, 65403, "EndGetRuntimeMembers", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeMethodArgs EndGetRuntimeMethodTemplate(Action<EndGetRuntimeMethodArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeMethodArgs(action, 71, 65463, "EndGetRuntimeMethod", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimeMethodsArgs EndGetRuntimeMethodsTemplate(Action<EndGetRuntimeMethodsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimeMethodsArgs(action, 63, 65471, "EndGetRuntimeMethods", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimePropertiesArgs EndGetRuntimePropertiesTemplate(Action<EndGetRuntimePropertiesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimePropertiesArgs(action, 59, 65475, "EndGetRuntimeProperties", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndGetRuntimePropertyArgs EndGetRuntimePropertyTemplate(Action<EndGetRuntimePropertyArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRuntimePropertyArgs(action, 67, 65467, "EndGetRuntimeProperty", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndICustomPropertyProviderCreateIndexedPropertyArgs EndICustomPropertyProviderCreateIndexedPropertyTemplate(Action<EndICustomPropertyProviderCreateIndexedPropertyArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndICustomPropertyProviderCreateIndexedPropertyArgs(action, 118, 65416, "EndICustomPropertyProviderCreateIndexedProperty", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndICustomPropertyProviderCreatePropertyArgs EndICustomPropertyProviderCreatePropertyTemplate(Action<EndICustomPropertyProviderCreatePropertyArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndICustomPropertyProviderCreatePropertyArgs(action, 116, 65418, "EndICustomPropertyProviderCreateProperty", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndMarshalOffsetOfArgs EndMarshalOffsetOfTemplate(Action<EndMarshalOffsetOfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndMarshalOffsetOfArgs(action, 108, 65426, "EndMarshalOffsetOf", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndMarshalPtrToStructureArgs EndMarshalPtrToStructureTemplate(Action<EndMarshalPtrToStructureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndMarshalPtrToStructureArgs(action, 110, 65424, "EndMarshalPtrToStructure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndMethodInfoCreateDelegateArgs EndMethodInfoCreateDelegateTemplate(Action<EndMethodInfoCreateDelegateArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndMethodInfoCreateDelegateArgs(action, 81, 65453, "EndMethodInfoCreateDelegate", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EndTypeAssemblyQualifiedNameArgs EndTypeAssemblyQualifiedNameTemplate(Action<EndTypeAssemblyQualifiedNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndTypeAssemblyQualifiedNameArgs(action, 52, 65482, "EndTypeAssemblyQualifiedName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EnumGetNameArgs EnumGetNameTemplate(Action<EnumGetNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EnumGetNameArgs(action, 44, 65490, "EnumGetName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EnumGetNamesArgs EnumGetNamesTemplate(Action<EnumGetNamesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EnumGetNamesArgs(action, 45, 65489, "EnumGetNames", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EnumGetUnderlyingTypeArgs EnumGetUnderlyingTypeTemplate(Action<EnumGetUnderlyingTypeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EnumGetUnderlyingTypeArgs(action, 42, 65492, "EnumGetUnderlyingType", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EnumGetValuesArgs EnumGetValuesTemplate(Action<EnumGetValuesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EnumGetValuesArgs(action, 43, 65491, "EnumGetValues", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EnumIsDefinedArgs EnumIsDefinedTemplate(Action<EnumIsDefinedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EnumIsDefinedArgs(action, 46, 65488, "EnumIsDefined", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EnumToObjectArgs EnumToObjectTemplate(Action<EnumToObjectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EnumToObjectArgs(action, 49, 65485, "EnumToObject", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EnumTryParseEnumArgs EnumTryParseEnumTemplate(Action<EnumTryParseEnumArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EnumTryParseEnumArgs(action, 41, 65493, "EnumTryParseEnum", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EventNameArgs EventNameTemplate(Action<EventNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EventNameArgs(action, 132, 65402, "EventName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private FieldNameArgs FieldNameTemplate(Action<FieldNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new FieldNameArgs(action, 55, 65479, "FieldName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private BeginGetRequestStreamArgs GetRequestStreamStartTemplate(Action<BeginGetRequestStreamArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetRequestStreamArgs(action, 142, 2, "GetRequestStream", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private EndGetRequestStreamArgs GetRequestStreamStopTemplate(Action<EndGetRequestStreamArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetRequestStreamArgs(action, 143, 2, "GetRequestStream", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private BeginGetResponseArgs GetResponseStartTemplate(Action<BeginGetResponseArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new BeginGetResponseArgs(action, 140, 1, "GetResponse", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private EndGetResponseArgs GetResponseStopTemplate(Action<EndGetResponseArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EndGetResponseArgs(action, 141, 1, "GetResponse", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private IntrospectionExtensionsGetTypeInfoArgs IntrospectionExtensionsGetTypeInfoTemplate(Action<IntrospectionExtensionsGetTypeInfoArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IntrospectionExtensionsGetTypeInfoArgs(action, 57, 65477, "IntrospectionExtensionsGetTypeInfo", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ManagedActivationFactoryConstructorArgs ManagedActivationFactoryConstructorTemplate(Action<ManagedActivationFactoryConstructorArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ManagedActivationFactoryConstructorArgs(action, 87, 65447, "ManagedActivationFactoryConstructor", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalAsAnyConvertToManagedArgs MarshalAsAnyConvertToManagedTemplate(Action<MarshalAsAnyConvertToManagedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalAsAnyConvertToManagedArgs(action, 86, 65448, "MarshalAsAnyConvertToManaged", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalAsAnyConvertToNativeArgs MarshalAsAnyConvertToNativeTemplate(Action<MarshalAsAnyConvertToNativeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalAsAnyConvertToNativeArgs(action, 85, 65449, "MarshalAsAnyConvertToNative", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalCreateAggregatedObjectArgs MarshalCreateAggregatedObjectTemplate(Action<MarshalCreateAggregatedObjectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalCreateAggregatedObjectArgs(action, 89, 65445, "MarshalCreateAggregatedObject", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalCreateWrapperOfTypeArgs MarshalCreateWrapperOfTypeTemplate(Action<MarshalCreateWrapperOfTypeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalCreateWrapperOfTypeArgs(action, 90, 65444, "MarshalCreateWrapperOfType", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalDestroyStructureArgs MarshalDestroyStructureTemplate(Action<MarshalDestroyStructureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalDestroyStructureArgs(action, 91, 65443, "MarshalDestroyStructure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetComInterfaceForObjectArgs MarshalGetComInterfaceForObjectTemplate(Action<MarshalGetComInterfaceForObjectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetComInterfaceForObjectArgs(action, 92, 65442, "MarshalGetComInterfaceForObject", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetDelegateForFunctionPointerArgs MarshalGetDelegateForFunctionPointerTemplate(Action<MarshalGetDelegateForFunctionPointerArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetDelegateForFunctionPointerArgs(action, 93, 65441, "MarshalGetDelegateForFunctionPointer", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData MarshalGetExceptionCodeTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 94, 65440, "MarshalGetExceptionCode", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData MarshalGetExceptionForHRTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 95, 65439, "MarshalGetExceptionForHR", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData MarshalGetExceptionForHR2Template(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 96, 65438, "MarshalGetExceptionForHR2", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetFunctionPointerForDelegateArgs MarshalGetFunctionPointerForDelegateTemplate(Action<MarshalGetFunctionPointerForDelegateArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetFunctionPointerForDelegateArgs(action, 97, 65437, "MarshalGetFunctionPointerForDelegate", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetIUnknownForObjectArgs MarshalGetIUnknownForObjectTemplate(Action<MarshalGetIUnknownForObjectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetIUnknownForObjectArgs(action, 98, 65436, "MarshalGetIUnknownForObject", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetNativeVariantForObjectArgs MarshalGetNativeVariantForObjectTemplate(Action<MarshalGetNativeVariantForObjectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetNativeVariantForObjectArgs(action, 99, 65435, "MarshalGetNativeVariantForObject", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetObjectForIUnknownArgs MarshalGetObjectForIUnknownTemplate(Action<MarshalGetObjectForIUnknownArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetObjectForIUnknownArgs(action, 100, 65434, "MarshalGetObjectForIUnknown", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetObjectForNativeVariantArgs MarshalGetObjectForNativeVariantTemplate(Action<MarshalGetObjectForNativeVariantArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetObjectForNativeVariantArgs(action, 101, 65433, "MarshalGetObjectForNativeVariant", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetObjectsForNativeVariantsArgs MarshalGetObjectsForNativeVariantsTemplate(Action<MarshalGetObjectsForNativeVariantsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetObjectsForNativeVariantsArgs(action, 102, 65432, "MarshalGetObjectsForNativeVariants", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetStartComSlotArgs MarshalGetStartComSlotTemplate(Action<MarshalGetStartComSlotArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetStartComSlotArgs(action, 103, 65431, "MarshalGetStartComSlot", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetTypeFromCLSIDArgs MarshalGetTypeFromCLSIDTemplate(Action<MarshalGetTypeFromCLSIDArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetTypeFromCLSIDArgs(action, 104, 65430, "MarshalGetTypeFromCLSID", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetTypeInfoNameArgs MarshalGetTypeInfoNameTemplate(Action<MarshalGetTypeInfoNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetTypeInfoNameArgs(action, 105, 65429, "MarshalGetTypeInfoName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalGetUniqueObjectForIUnknownArgs MarshalGetUniqueObjectForIUnknownTemplate(Action<MarshalGetUniqueObjectForIUnknownArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalGetUniqueObjectForIUnknownArgs(action, 106, 65428, "MarshalGetUniqueObjectForIUnknown", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalSizeOfArgs MarshalSizeOfTemplate(Action<MarshalSizeOfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalSizeOfArgs(action, 111, 65423, "MarshalSizeOf", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalStructureToPtrArgs MarshalStructureToPtrTemplate(Action<MarshalStructureToPtrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalStructureToPtrArgs(action, 112, 65422, "MarshalStructureToPtr", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData MarshalThrowExceptionForHRTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 113, 65421, "MarshalThrowExceptionForHR", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData MarshalThrowExceptionForHR2Template(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 127, 65407, "MarshalThrowExceptionForHR2", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MarshalUnsafeAddrOfPinnedArrayElementArgs MarshalUnsafeAddrOfPinnedArrayElementTemplate(Action<MarshalUnsafeAddrOfPinnedArrayElementArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MarshalUnsafeAddrOfPinnedArrayElementArgs(action, 114, 65420, "MarshalUnsafeAddrOfPinnedArrayElement", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MethodInfoInvokeArgs MethodInfoInvokeTemplate(Action<MethodInfoInvokeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MethodInfoInvokeArgs(action, 79, 65455, "MethodInfoInvoke", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private MethodNameArgs MethodNameTemplate(Action<MethodNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new MethodNameArgs(action, 54, 65480, "MethodName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private QueryAttributeIsDefinedArgs QueryAttributeIsDefinedTemplate(Action<QueryAttributeIsDefinedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new QueryAttributeIsDefinedArgs(action, 133, 65401, "QueryAttributeIsDefined", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerAddingCultureFromConfigFileArgs ResourceManagerAddingCultureFromConfigFileTemplate(Action<ResourceManagerAddingCultureFromConfigFileArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerAddingCultureFromConfigFileArgs(action, 20, 65514, "ResourceManagerAddingCultureFromConfigFile", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs ResourceManagerCaseInsensitiveResourceStreamLookupFailedTemplate(Action<ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs(action, 10, 65524, "ResourceManagerCaseInsensitiveResourceStreamLookupFailed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs ResourceManagerCaseInsensitiveResourceStreamLookupSucceededTemplate(Action<ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs(action, 9, 65525, "ResourceManagerCaseInsensitiveResourceStreamLookupSucceeded", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerCreatingResourceSetArgs ResourceManagerCreatingResourceSetTemplate(Action<ResourceManagerCreatingResourceSetArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerCreatingResourceSetArgs(action, 14, 65520, "ResourceManagerCreatingResourceSet", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerCultureFoundInConfigFileArgs ResourceManagerCultureFoundInConfigFileTemplate(Action<ResourceManagerCultureFoundInConfigFileArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerCultureFoundInConfigFileArgs(action, 22, 65512, "ResourceManagerCultureFoundInConfigFile", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerCultureNotFoundInConfigFileArgs ResourceManagerCultureNotFoundInConfigFileTemplate(Action<ResourceManagerCultureNotFoundInConfigFileArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerCultureNotFoundInConfigFileArgs(action, 21, 65513, "ResourceManagerCultureNotFoundInConfigFile", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerFoundResourceSetInCacheArgs ResourceManagerFoundResourceSetInCacheTemplate(Action<ResourceManagerFoundResourceSetInCacheArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerFoundResourceSetInCacheArgs(action, 3, 65531, "ResourceManagerFoundResourceSetInCache", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerFoundResourceSetInCacheUnexpectedArgs ResourceManagerFoundResourceSetInCacheUnexpectedTemplate(Action<ResourceManagerFoundResourceSetInCacheUnexpectedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerFoundResourceSetInCacheUnexpectedArgs(action, 4, 65530, "ResourceManagerFoundResourceSetInCacheUnexpected", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerGetSatelliteAssemblyFailedArgs ResourceManagerGetSatelliteAssemblyFailedTemplate(Action<ResourceManagerGetSatelliteAssemblyFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerGetSatelliteAssemblyFailedArgs(action, 8, 65526, "ResourceManagerGetSatelliteAssemblyFailed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerGetSatelliteAssemblySucceededArgs ResourceManagerGetSatelliteAssemblySucceededTemplate(Action<ResourceManagerGetSatelliteAssemblySucceededArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerGetSatelliteAssemblySucceededArgs(action, 7, 65527, "ResourceManagerGetSatelliteAssemblySucceeded", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerLookingForResourceSetArgs ResourceManagerLookingForResourceSetTemplate(Action<ResourceManagerLookingForResourceSetArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerLookingForResourceSetArgs(action, 2, 65532, "ResourceManagerLookingForResourceSet", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerLookupFailedArgs ResourceManagerLookupFailedTemplate(Action<ResourceManagerLookupFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerLookupFailedArgs(action, 16, 65518, "ResourceManagerLookupFailed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerLookupStartedArgs ResourceManagerLookupStartedTemplate(Action<ResourceManagerLookupStartedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerLookupStartedArgs(action, 1, 65533, "ResourceManagerLookupStarted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerManifestResourceAccessDeniedArgs ResourceManagerManifestResourceAccessDeniedTemplate(Action<ResourceManagerManifestResourceAccessDeniedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerManifestResourceAccessDeniedArgs(action, 11, 65523, "ResourceManagerManifestResourceAccessDenied", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerNeutralResourceAttributeMissingArgs ResourceManagerNeutralResourceAttributeMissingTemplate(Action<ResourceManagerNeutralResourceAttributeMissingArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerNeutralResourceAttributeMissingArgs(action, 13, 65521, "ResourceManagerNeutralResourceAttributeMissing", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerNeutralResourcesFoundArgs ResourceManagerNeutralResourcesFoundTemplate(Action<ResourceManagerNeutralResourcesFoundArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerNeutralResourcesFoundArgs(action, 19, 65515, "ResourceManagerNeutralResourcesFound", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerNeutralResourcesNotFoundArgs ResourceManagerNeutralResourcesNotFoundTemplate(Action<ResourceManagerNeutralResourcesNotFoundArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerNeutralResourcesNotFoundArgs(action, 18, 65516, "ResourceManagerNeutralResourcesNotFound", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerNeutralResourcesSufficientArgs ResourceManagerNeutralResourcesSufficientTemplate(Action<ResourceManagerNeutralResourcesSufficientArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerNeutralResourcesSufficientArgs(action, 12, 65522, "ResourceManagerNeutralResourcesSufficient", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerNotCreatingResourceSetArgs ResourceManagerNotCreatingResourceSetTemplate(Action<ResourceManagerNotCreatingResourceSetArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerNotCreatingResourceSetArgs(action, 15, 65519, "ResourceManagerNotCreatingResourceSet", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerReleasingResourcesArgs ResourceManagerReleasingResourcesTemplate(Action<ResourceManagerReleasingResourcesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerReleasingResourcesArgs(action, 17, 65517, "ResourceManagerReleasingResources", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerStreamFoundArgs ResourceManagerStreamFoundTemplate(Action<ResourceManagerStreamFoundArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerStreamFoundArgs(action, 5, 65529, "ResourceManagerStreamFound", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ResourceManagerStreamNotFoundArgs ResourceManagerStreamNotFoundTemplate(Action<ResourceManagerStreamNotFoundArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ResourceManagerStreamNotFoundArgs(action, 6, 65528, "ResourceManagerStreamNotFound", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ThreadPoolDequeueWorkArgs ThreadPoolDequeueWorkTemplate(Action<ThreadPoolDequeueWorkArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ThreadPoolDequeueWorkArgs(action, 31, 65503, "ThreadPoolDequeueWork", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ThreadPoolEnqueueWorkArgs ThreadPoolEnqueueWorkTemplate(Action<ThreadPoolEnqueueWorkArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ThreadPoolEnqueueWorkArgs(action, 30, 65504, "ThreadPoolEnqueueWork", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ThreadTransferReceiveArgs ThreadTransferReceiveTemplate(Action<ThreadTransferReceiveArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ThreadTransferReceiveArgs(action, 151, 3, "ThreadTransfer", Guid.Empty, 240, "Receive", ProviderGuid, ProviderName);
        }
        static private ThreadTransferReceiveHandledArgs ThreadTransferReceiveHandledTemplate(Action<ThreadTransferReceiveHandledArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ThreadTransferReceiveHandledArgs(action, 152, 3, "ThreadTransfer", Guid.Empty, 11, "ReceiveHandled", ProviderGuid, ProviderName);
        }
        static private ThreadTransferSendArgs ThreadTransferSendTemplate(Action<ThreadTransferSendArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ThreadTransferSendArgs(action, 150, 3, "ThreadTransfer", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
        }
        static private TypeFullNameArgs TypeFullNameTemplate(Action<TypeFullNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TypeFullNameArgs(action, 50, 65484, "TypeFullName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TypeGetTypeArgs TypeGetTypeTemplate(Action<TypeGetTypeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TypeGetTypeArgs(action, 35, 65499, "TypeGetType", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TypeNameArgs TypeNameTemplate(Action<TypeNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TypeNameArgs(action, 56, 65478, "TypeName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TypeNamespaceArgs TypeNamespaceTemplate(Action<TypeNamespaceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TypeNamespaceArgs(action, 53, 65481, "TypeNamespace", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private WindowsRuntimeMarshalGetActivationFactoryArgs WindowsRuntimeMarshalGetActivationFactoryTemplate(Action<WindowsRuntimeMarshalGetActivationFactoryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new WindowsRuntimeMarshalGetActivationFactoryArgs(action, 88, 65446, "WindowsRuntimeMarshalGetActivationFactory", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }

        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[128];
                templates[0] = MarshalThrowExceptionForHRTemplate(null);
                templates[1] = MarshalUnsafeAddrOfPinnedArrayElementTemplate(null);
                templates[2] = BeginICustomPropertyProviderCreatePropertyTemplate(null);
                templates[3] = EndICustomPropertyProviderCreatePropertyTemplate(null);
                templates[4] = BeginICustomPropertyProviderCreateIndexedPropertyTemplate(null);
                templates[5] = EndICustomPropertyProviderCreateIndexedPropertyTemplate(null);
                templates[6] = BeginCustomPropertyImplGetValueTemplate(null);
                templates[7] = EndCustomPropertyImplGetValueTemplate(null);
                templates[8] = BeginCustomPropertyImplGetValueIndexValueTemplate(null);
                templates[9] = EndCustomPropertyImplGetValueIndexValueTemplate(null);
                templates[10] = BeginCustomPropertyImplSetValueTemplate(null);
                templates[11] = EndCustomPropertyImplSetValueTemplate(null);
                templates[12] = BeginCustomPropertyImplSetValueIndexValueTemplate(null);
                templates[13] = EndCustomPropertyImplSetValueIndexValueTemplate(null);
                templates[14] = MarshalThrowExceptionForHR2Template(null);
                templates[15] = BeginGetRuntimeConstructorsTemplate(null);
                templates[16] = EndGetRuntimeConstructorsTemplate(null);
                templates[17] = BeginGetRuntimeMembersTemplate(null);
                templates[18] = EndGetRuntimeMembersTemplate(null);
                templates[19] = EventNameTemplate(null);
                templates[20] = QueryAttributeIsDefinedTemplate(null);
                templates[21] = GetResponseStartTemplate(null);
                templates[22] = GetResponseStopTemplate(null);
                templates[23] = GetRequestStreamStartTemplate(null);
                templates[24] = GetRequestStreamStopTemplate(null);
                templates[25] = ThreadTransferSendTemplate(null);
                templates[26] = ThreadTransferReceiveTemplate(null);
                templates[27] = ThreadTransferReceiveHandledTemplate(null);
                templates[28] = ResourceManagerLookupStartedTemplate(null);
                templates[29] = ResourceManagerLookingForResourceSetTemplate(null);
                templates[30] = ResourceManagerFoundResourceSetInCacheTemplate(null);
                templates[31] = ResourceManagerFoundResourceSetInCacheUnexpectedTemplate(null);
                templates[32] = ResourceManagerStreamFoundTemplate(null);
                templates[33] = ResourceManagerStreamNotFoundTemplate(null);
                templates[34] = ResourceManagerGetSatelliteAssemblySucceededTemplate(null);
                templates[35] = ResourceManagerGetSatelliteAssemblyFailedTemplate(null);
                templates[36] = ResourceManagerCaseInsensitiveResourceStreamLookupSucceededTemplate(null);
                templates[37] = ResourceManagerCaseInsensitiveResourceStreamLookupFailedTemplate(null);
                templates[38] = ResourceManagerManifestResourceAccessDeniedTemplate(null);
                templates[39] = ResourceManagerNeutralResourcesSufficientTemplate(null);
                templates[40] = ResourceManagerNeutralResourceAttributeMissingTemplate(null);
                templates[41] = ResourceManagerCreatingResourceSetTemplate(null);
                templates[42] = ResourceManagerNotCreatingResourceSetTemplate(null);
                templates[43] = ResourceManagerLookupFailedTemplate(null);
                templates[44] = ResourceManagerReleasingResourcesTemplate(null);
                templates[45] = ResourceManagerNeutralResourcesNotFoundTemplate(null);
                templates[46] = ResourceManagerNeutralResourcesFoundTemplate(null);
                templates[47] = ResourceManagerAddingCultureFromConfigFileTemplate(null);
                templates[48] = ResourceManagerCultureNotFoundInConfigFileTemplate(null);
                templates[49] = ResourceManagerCultureFoundInConfigFileTemplate(null);
                templates[50] = ThreadPoolEnqueueWorkTemplate(null);
                templates[51] = ThreadPoolDequeueWorkTemplate(null);
                templates[52] = ActivatorCreateInstanceTemplate(null);
                templates[53] = ActivatorCreateInstanceTTemplate(null);
                templates[54] = ArrayCreateInstanceTemplate(null);
                templates[55] = TypeGetTypeTemplate(null);
                templates[56] = AssemblyGetTypeTemplate(null);
                templates[57] = BeginGetMethodFromHandleTemplate(null);
                templates[58] = EndGetMethodFromHandleTemplate(null);
                templates[59] = BeginGetFieldFromHandleTemplate(null);
                templates[60] = EndGetFieldFromHandleTemplate(null);
                templates[61] = EnumTryParseEnumTemplate(null);
                templates[62] = EnumGetUnderlyingTypeTemplate(null);
                templates[63] = EnumGetValuesTemplate(null);
                templates[64] = EnumGetNameTemplate(null);
                templates[65] = EnumGetNamesTemplate(null);
                templates[66] = EnumIsDefinedTemplate(null);
                templates[67] = BeginEnumFormatTemplate(null);
                templates[68] = EndEnumFormatTemplate(null);
                templates[69] = EnumToObjectTemplate(null);
                templates[70] = TypeFullNameTemplate(null);
                templates[71] = BeginTypeAssemblyQualifiedNameTemplate(null);
                templates[72] = EndTypeAssemblyQualifiedNameTemplate(null);
                templates[73] = TypeNamespaceTemplate(null);
                templates[74] = MethodNameTemplate(null);
                templates[75] = FieldNameTemplate(null);
                templates[76] = TypeNameTemplate(null);
                templates[77] = IntrospectionExtensionsGetTypeInfoTemplate(null);
                templates[78] = BeginGetRuntimePropertiesTemplate(null);
                templates[79] = EndGetRuntimePropertiesTemplate(null);
                templates[80] = BeginGetRuntimeEventsTemplate(null);
                templates[81] = EndGetRuntimeEventsTemplate(null);
                templates[82] = BeginGetRuntimeMethodsTemplate(null);
                templates[83] = EndGetRuntimeMethodsTemplate(null);
                templates[84] = BeginGetRuntimeFieldsTemplate(null);
                templates[85] = EndGetRuntimeFieldsTemplate(null);
                templates[86] = BeginGetRuntimePropertyTemplate(null);
                templates[87] = EndGetRuntimePropertyTemplate(null);
                templates[88] = BeginGetRuntimeEventTemplate(null);
                templates[89] = EndGetRuntimeEventTemplate(null);
                templates[90] = BeginGetRuntimeMethodTemplate(null);
                templates[91] = EndGetRuntimeMethodTemplate(null);
                templates[92] = BeginGetRuntimeFieldTemplate(null);
                templates[93] = EndGetRuntimeFieldTemplate(null);
                templates[94] = MethodInfoInvokeTemplate(null);
                templates[95] = BeginMethodInfoCreateDelegateTemplate(null);
                templates[96] = EndMethodInfoCreateDelegateTemplate(null);
                templates[97] = BeginCreateIReferenceTemplate(null);
                templates[98] = EndCreateIReferenceTemplate(null);
                templates[99] = ConstructorInfoInvokeTemplate(null);
                templates[100] = MarshalAsAnyConvertToNativeTemplate(null);
                templates[101] = MarshalAsAnyConvertToManagedTemplate(null);
                templates[102] = ManagedActivationFactoryConstructorTemplate(null);
                templates[103] = WindowsRuntimeMarshalGetActivationFactoryTemplate(null);
                templates[104] = MarshalCreateAggregatedObjectTemplate(null);
                templates[105] = MarshalCreateWrapperOfTypeTemplate(null);
                templates[106] = MarshalDestroyStructureTemplate(null);
                templates[107] = MarshalGetComInterfaceForObjectTemplate(null);
                templates[108] = MarshalGetDelegateForFunctionPointerTemplate(null);
                templates[109] = MarshalGetExceptionCodeTemplate(null);
                templates[110] = MarshalGetExceptionForHRTemplate(null);
                templates[111] = MarshalGetExceptionForHR2Template(null);
                templates[112] = MarshalGetFunctionPointerForDelegateTemplate(null);
                templates[113] = MarshalGetIUnknownForObjectTemplate(null);
                templates[114] = MarshalGetNativeVariantForObjectTemplate(null);
                templates[115] = MarshalGetObjectForIUnknownTemplate(null);
                templates[116] = MarshalGetObjectForNativeVariantTemplate(null);
                templates[117] = MarshalGetObjectsForNativeVariantsTemplate(null);
                templates[118] = MarshalGetStartComSlotTemplate(null);
                templates[119] = MarshalGetTypeFromCLSIDTemplate(null);
                templates[120] = MarshalGetTypeInfoNameTemplate(null);
                templates[121] = MarshalGetUniqueObjectForIUnknownTemplate(null);
                templates[122] = BeginMarshalOffsetOfTemplate(null);
                templates[123] = EndMarshalOffsetOfTemplate(null);
                templates[124] = BeginMarshalPtrToStructureTemplate(null);
                templates[125] = EndMarshalPtrToStructureTemplate(null);
                templates[126] = MarshalSizeOfTemplate(null);
                templates[127] = MarshalStructureToPtrTemplate(null);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.FrameworkEventSource
{
    public sealed class ActivatorCreateInstanceArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal ActivatorCreateInstanceArgs(Action<ActivatorCreateInstanceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ActivatorCreateInstanceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ActivatorCreateInstanceArgs> m_target;
        #endregion
    }
    public sealed class ActivatorCreateInstanceTArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal ActivatorCreateInstanceTArgs(Action<ActivatorCreateInstanceTArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ActivatorCreateInstanceTArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ActivatorCreateInstanceTArgs> m_target;
        #endregion
    }
    public sealed class ArrayCreateInstanceArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal ArrayCreateInstanceArgs(Action<ArrayCreateInstanceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ArrayCreateInstanceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ArrayCreateInstanceArgs> m_target;
        #endregion
    }
    public sealed class AssemblyGetTypeArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal AssemblyGetTypeArgs(Action<AssemblyGetTypeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<AssemblyGetTypeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AssemblyGetTypeArgs> m_target;
        #endregion
    }
    public sealed class BeginCustomPropertyImplGetValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginCustomPropertyImplGetValueArgs(Action<BeginCustomPropertyImplGetValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginCustomPropertyImplGetValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyTypeName", propertyTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginCustomPropertyImplGetValueArgs> m_target;
        #endregion
    }
    public sealed class BeginCustomPropertyImplGetValueIndexValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginCustomPropertyImplGetValueIndexValueArgs(Action<BeginCustomPropertyImplGetValueIndexValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginCustomPropertyImplGetValueIndexValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyTypeName", propertyTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginCustomPropertyImplGetValueIndexValueArgs> m_target;
        #endregion
    }
    public sealed class BeginCustomPropertyImplSetValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string valueTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginCustomPropertyImplSetValueArgs(Action<BeginCustomPropertyImplSetValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginCustomPropertyImplSetValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "valueTypeName", valueTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "valueTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return valueTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginCustomPropertyImplSetValueArgs> m_target;
        #endregion
    }
    public sealed class BeginCustomPropertyImplSetValueIndexValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string indexValueTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal BeginCustomPropertyImplSetValueIndexValueArgs(Action<BeginCustomPropertyImplSetValueIndexValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginCustomPropertyImplSetValueIndexValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyTypeName", propertyTypeName);
            XmlAttrib(sb, "indexValueTypeName", indexValueTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyTypeName", "indexValueTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyTypeName;
                case 2:
                    return indexValueTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginCustomPropertyImplSetValueIndexValueArgs> m_target;
        #endregion
    }
    public sealed class BeginEnumFormatArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginEnumFormatArgs(Action<BeginEnumFormatArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginEnumFormatArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginEnumFormatArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeConstructorsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginGetRuntimeConstructorsArgs(Action<BeginGetRuntimeConstructorsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeConstructorsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeConstructorsArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeEventArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public new string eventName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginGetRuntimeEventArgs(Action<BeginGetRuntimeEventArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeEventArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "eventName", eventName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "eventName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return eventName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeEventArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeEventsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginGetRuntimeEventsArgs(Action<BeginGetRuntimeEventsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeEventsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeEventsArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeFieldArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string fieldName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginGetRuntimeFieldArgs(Action<BeginGetRuntimeFieldArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeFieldArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "fieldName", fieldName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "fieldName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return fieldName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeFieldArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeFieldsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginGetRuntimeFieldsArgs(Action<BeginGetRuntimeFieldsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeFieldsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeFieldsArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeMembersArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginGetRuntimeMembersArgs(Action<BeginGetRuntimeMembersArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeMembersArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeMembersArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeMethodArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginGetRuntimeMethodArgs(Action<BeginGetRuntimeMethodArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeMethodArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeMethodArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimeMethodsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginGetRuntimeMethodsArgs(Action<BeginGetRuntimeMethodsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimeMethodsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimeMethodsArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimePropertiesArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginGetRuntimePropertiesArgs(Action<BeginGetRuntimePropertiesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimePropertiesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimePropertiesArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRuntimePropertyArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginGetRuntimePropertyArgs(Action<BeginGetRuntimePropertyArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRuntimePropertyArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyName", propertyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRuntimePropertyArgs> m_target;
        #endregion
    }
    public sealed class BeginICustomPropertyProviderCreateIndexedPropertyArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string indexedParamTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal BeginICustomPropertyProviderCreateIndexedPropertyArgs(Action<BeginICustomPropertyProviderCreateIndexedPropertyArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginICustomPropertyProviderCreateIndexedPropertyArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyName", propertyName);
            XmlAttrib(sb, "indexedParamTypeName", indexedParamTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyName", "indexedParamTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyName;
                case 2:
                    return indexedParamTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginICustomPropertyProviderCreateIndexedPropertyArgs> m_target;
        #endregion
    }
    public sealed class BeginICustomPropertyProviderCreatePropertyArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginICustomPropertyProviderCreatePropertyArgs(Action<BeginICustomPropertyProviderCreatePropertyArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginICustomPropertyProviderCreatePropertyArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyName", propertyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginICustomPropertyProviderCreatePropertyArgs> m_target;
        #endregion
    }
    public sealed class BeginMarshalOffsetOfArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string fieldName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal BeginMarshalOffsetOfArgs(Action<BeginMarshalOffsetOfArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginMarshalOffsetOfArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "fieldName", fieldName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "fieldName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return fieldName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginMarshalOffsetOfArgs> m_target;
        #endregion
    }
    public sealed class BeginMarshalPtrToStructureArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginMarshalPtrToStructureArgs(Action<BeginMarshalPtrToStructureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginMarshalPtrToStructureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginMarshalPtrToStructureArgs> m_target;
        #endregion
    }
    public sealed class BeginMethodInfoCreateDelegateArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string delegateTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal BeginMethodInfoCreateDelegateArgs(Action<BeginMethodInfoCreateDelegateArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginMethodInfoCreateDelegateArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            XmlAttrib(sb, "delegateTypeName", delegateTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName", "delegateTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                case 2:
                    return delegateTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginMethodInfoCreateDelegateArgs> m_target;
        #endregion
    }
    public sealed class BeginTypeAssemblyQualifiedNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal BeginTypeAssemblyQualifiedNameArgs(Action<BeginTypeAssemblyQualifiedNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginTypeAssemblyQualifiedNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginTypeAssemblyQualifiedNameArgs> m_target;
        #endregion
    }
    public sealed class ConstructorInfoInvokeArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal ConstructorInfoInvokeArgs(Action<ConstructorInfoInvokeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ConstructorInfoInvokeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ConstructorInfoInvokeArgs> m_target;
        #endregion
    }
    public sealed class EndCreateIReferenceArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndCreateIReferenceArgs(Action<EndCreateIReferenceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndCreateIReferenceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndCreateIReferenceArgs> m_target;
        #endregion
    }
    public sealed class EndCustomPropertyImplGetValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndCustomPropertyImplGetValueArgs(Action<EndCustomPropertyImplGetValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndCustomPropertyImplGetValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyTypeName", propertyTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndCustomPropertyImplGetValueArgs> m_target;
        #endregion
    }
    public sealed class EndCustomPropertyImplGetValueIndexValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndCustomPropertyImplGetValueIndexValueArgs(Action<EndCustomPropertyImplGetValueIndexValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndCustomPropertyImplGetValueIndexValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyTypeName", propertyTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndCustomPropertyImplGetValueIndexValueArgs> m_target;
        #endregion
    }
    public sealed class EndCustomPropertyImplSetValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string valueTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndCustomPropertyImplSetValueArgs(Action<EndCustomPropertyImplSetValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndCustomPropertyImplSetValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "valueTypeName", valueTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "valueTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return valueTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndCustomPropertyImplSetValueArgs> m_target;
        #endregion
    }
    public sealed class EndCustomPropertyImplSetValueIndexValueArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string indexValueTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal EndCustomPropertyImplSetValueIndexValueArgs(Action<EndCustomPropertyImplSetValueIndexValueArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndCustomPropertyImplSetValueIndexValueArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyTypeName", propertyTypeName);
            XmlAttrib(sb, "indexValueTypeName", indexValueTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyTypeName", "indexValueTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyTypeName;
                case 2:
                    return indexValueTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndCustomPropertyImplSetValueIndexValueArgs> m_target;
        #endregion
    }
    public sealed class EndEnumFormatArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndEnumFormatArgs(Action<EndEnumFormatArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndEnumFormatArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndEnumFormatArgs> m_target;
        #endregion
    }
    public sealed class EndGetFieldFromHandleArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string field { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndGetFieldFromHandleArgs(Action<EndGetFieldFromHandleArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetFieldFromHandleArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "field", field);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "field" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return field;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetFieldFromHandleArgs> m_target;
        #endregion
    }
    public sealed class EndGetMethodFromHandleArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string method { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndGetMethodFromHandleArgs(Action<EndGetMethodFromHandleArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetMethodFromHandleArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "method", method);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "method" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return method;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetMethodFromHandleArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeConstructorsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndGetRuntimeConstructorsArgs(Action<EndGetRuntimeConstructorsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeConstructorsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeConstructorsArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeEventArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public new string eventName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndGetRuntimeEventArgs(Action<EndGetRuntimeEventArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeEventArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "eventName", eventName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "eventName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return eventName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeEventArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeEventsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndGetRuntimeEventsArgs(Action<EndGetRuntimeEventsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeEventsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeEventsArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeFieldArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string fieldName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndGetRuntimeFieldArgs(Action<EndGetRuntimeFieldArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeFieldArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "fieldName", fieldName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "fieldName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return fieldName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeFieldArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeFieldsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndGetRuntimeFieldsArgs(Action<EndGetRuntimeFieldsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeFieldsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeFieldsArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeMembersArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndGetRuntimeMembersArgs(Action<EndGetRuntimeMembersArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeMembersArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeMembersArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeMethodArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndGetRuntimeMethodArgs(Action<EndGetRuntimeMethodArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeMethodArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeMethodArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimeMethodsArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndGetRuntimeMethodsArgs(Action<EndGetRuntimeMethodsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimeMethodsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimeMethodsArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimePropertiesArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndGetRuntimePropertiesArgs(Action<EndGetRuntimePropertiesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimePropertiesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimePropertiesArgs> m_target;
        #endregion
    }
    public sealed class EndGetRuntimePropertyArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndGetRuntimePropertyArgs(Action<EndGetRuntimePropertyArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRuntimePropertyArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyName", propertyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRuntimePropertyArgs> m_target;
        #endregion
    }
    public sealed class EndICustomPropertyProviderCreateIndexedPropertyArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string indexedParamTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal EndICustomPropertyProviderCreateIndexedPropertyArgs(Action<EndICustomPropertyProviderCreateIndexedPropertyArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndICustomPropertyProviderCreateIndexedPropertyArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyName", propertyName);
            XmlAttrib(sb, "indexedParamTypeName", indexedParamTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyName", "indexedParamTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyName;
                case 2:
                    return indexedParamTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndICustomPropertyProviderCreateIndexedPropertyArgs> m_target;
        #endregion
    }
    public sealed class EndICustomPropertyProviderCreatePropertyArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string propertyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndICustomPropertyProviderCreatePropertyArgs(Action<EndICustomPropertyProviderCreatePropertyArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndICustomPropertyProviderCreatePropertyArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "propertyName", propertyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "propertyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return propertyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndICustomPropertyProviderCreatePropertyArgs> m_target;
        #endregion
    }
    public sealed class EndMarshalOffsetOfArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string fieldName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EndMarshalOffsetOfArgs(Action<EndMarshalOffsetOfArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndMarshalOffsetOfArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "fieldName", fieldName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "fieldName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return fieldName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndMarshalOffsetOfArgs> m_target;
        #endregion
    }
    public sealed class EndMarshalPtrToStructureArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndMarshalPtrToStructureArgs(Action<EndMarshalPtrToStructureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndMarshalPtrToStructureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndMarshalPtrToStructureArgs> m_target;
        #endregion
    }
    public sealed class EndMethodInfoCreateDelegateArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string delegateTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal EndMethodInfoCreateDelegateArgs(Action<EndMethodInfoCreateDelegateArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndMethodInfoCreateDelegateArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            XmlAttrib(sb, "delegateTypeName", delegateTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName", "delegateTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                case 2:
                    return delegateTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndMethodInfoCreateDelegateArgs> m_target;
        #endregion
    }
    public sealed class EndTypeAssemblyQualifiedNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EndTypeAssemblyQualifiedNameArgs(Action<EndTypeAssemblyQualifiedNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndTypeAssemblyQualifiedNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndTypeAssemblyQualifiedNameArgs> m_target;
        #endregion
    }
    public sealed class EnumGetNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EnumGetNameArgs(Action<EnumGetNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EnumGetNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EnumGetNameArgs> m_target;
        #endregion
    }
    public sealed class EnumGetNamesArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EnumGetNamesArgs(Action<EnumGetNamesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EnumGetNamesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EnumGetNamesArgs> m_target;
        #endregion
    }
    public sealed class EnumGetUnderlyingTypeArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EnumGetUnderlyingTypeArgs(Action<EnumGetUnderlyingTypeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EnumGetUnderlyingTypeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EnumGetUnderlyingTypeArgs> m_target;
        #endregion
    }
    public sealed class EnumGetValuesArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EnumGetValuesArgs(Action<EnumGetValuesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EnumGetValuesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EnumGetValuesArgs> m_target;
        #endregion
    }
    public sealed class EnumIsDefinedArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EnumIsDefinedArgs(Action<EnumIsDefinedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EnumIsDefinedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EnumIsDefinedArgs> m_target;
        #endregion
    }
    public sealed class EnumToObjectArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal EnumToObjectArgs(Action<EnumToObjectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EnumToObjectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EnumToObjectArgs> m_target;
        #endregion
    }
    public sealed class EnumTryParseEnumArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string value { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EnumTryParseEnumArgs(Action<EnumTryParseEnumArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EnumTryParseEnumArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "value", value);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "value" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return value;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EnumTryParseEnumArgs> m_target;
        #endregion
    }
    public sealed class EventNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public new string eventName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal EventNameArgs(Action<EventNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EventNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "eventName", eventName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "eventName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return eventName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EventNameArgs> m_target;
        #endregion
    }
    public sealed class FieldNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string fieldName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal FieldNameArgs(Action<FieldNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<FieldNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "fieldName", fieldName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "fieldName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return fieldName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FieldNameArgs> m_target;
        #endregion
    }
    public sealed class BeginGetRequestStreamArgs : TraceEvent
    {
        public long id { get { return GetInt64At(0); } }
        public string uri { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal BeginGetRequestStreamArgs(Action<BeginGetRequestStreamArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetRequestStreamArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            XmlAttrib(sb, "uri", uri);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id", "uri" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                case 1:
                    return uri;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetRequestStreamArgs> m_target;
        #endregion
    }
    public sealed class EndGetRequestStreamArgs : TraceEvent
    {
        public long id { get { return GetInt64At(0); } }

        #region Private
        internal EndGetRequestStreamArgs(Action<EndGetRequestStreamArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetRequestStreamArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetRequestStreamArgs> m_target;
        #endregion
    }
    public sealed class BeginGetResponseArgs : TraceEvent
    {
        public long id { get { return GetInt64At(0); } }
        public string uri { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal BeginGetResponseArgs(Action<BeginGetResponseArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<BeginGetResponseArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            XmlAttrib(sb, "uri", uri);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id", "uri" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                case 1:
                    return uri;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BeginGetResponseArgs> m_target;
        #endregion
    }
    public sealed class EndGetResponseArgs : TraceEvent
    {
        public long id { get { return GetInt64At(0); } }

        #region Private
        internal EndGetResponseArgs(Action<EndGetResponseArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<EndGetResponseArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EndGetResponseArgs> m_target;
        #endregion
    }
    public sealed class IntrospectionExtensionsGetTypeInfoArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal IntrospectionExtensionsGetTypeInfoArgs(Action<IntrospectionExtensionsGetTypeInfoArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IntrospectionExtensionsGetTypeInfoArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IntrospectionExtensionsGetTypeInfoArgs> m_target;
        #endregion
    }
    public sealed class ManagedActivationFactoryConstructorArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal ManagedActivationFactoryConstructorArgs(Action<ManagedActivationFactoryConstructorArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ManagedActivationFactoryConstructorArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ManagedActivationFactoryConstructorArgs> m_target;
        #endregion
    }
    public sealed class MarshalAsAnyConvertToManagedArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalAsAnyConvertToManagedArgs(Action<MarshalAsAnyConvertToManagedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalAsAnyConvertToManagedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalAsAnyConvertToManagedArgs> m_target;
        #endregion
    }
    public sealed class MarshalAsAnyConvertToNativeArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalAsAnyConvertToNativeArgs(Action<MarshalAsAnyConvertToNativeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalAsAnyConvertToNativeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalAsAnyConvertToNativeArgs> m_target;
        #endregion
    }
    public sealed class MarshalCreateAggregatedObjectArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalCreateAggregatedObjectArgs(Action<MarshalCreateAggregatedObjectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalCreateAggregatedObjectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalCreateAggregatedObjectArgs> m_target;
        #endregion
    }
    public sealed class MarshalCreateWrapperOfTypeArgs : TraceEvent
    {
        public string comObjectTypeName { get { return GetUnicodeStringAt(0); } }
        public string wrapperTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal MarshalCreateWrapperOfTypeArgs(Action<MarshalCreateWrapperOfTypeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalCreateWrapperOfTypeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "comObjectTypeName", comObjectTypeName);
            XmlAttrib(sb, "wrapperTypeName", wrapperTypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "comObjectTypeName", "wrapperTypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return comObjectTypeName;
                case 1:
                    return wrapperTypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalCreateWrapperOfTypeArgs> m_target;
        #endregion
    }
    public sealed class MarshalDestroyStructureArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalDestroyStructureArgs(Action<MarshalDestroyStructureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalDestroyStructureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalDestroyStructureArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetComInterfaceForObjectArgs : TraceEvent
    {
        public string objectTypeName { get { return GetUnicodeStringAt(0); } }
        public string typeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string implementsAndMode { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal MarshalGetComInterfaceForObjectArgs(Action<MarshalGetComInterfaceForObjectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetComInterfaceForObjectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectTypeName", objectTypeName);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "implementsAndMode", implementsAndMode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectTypeName", "typeName", "implementsAndMode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectTypeName;
                case 1:
                    return typeName;
                case 2:
                    return implementsAndMode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetComInterfaceForObjectArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetDelegateForFunctionPointerArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetDelegateForFunctionPointerArgs(Action<MarshalGetDelegateForFunctionPointerArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetDelegateForFunctionPointerArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetDelegateForFunctionPointerArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetFunctionPointerForDelegateArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal MarshalGetFunctionPointerForDelegateArgs(Action<MarshalGetFunctionPointerForDelegateArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetFunctionPointerForDelegateArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetFunctionPointerForDelegateArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetIUnknownForObjectArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetIUnknownForObjectArgs(Action<MarshalGetIUnknownForObjectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetIUnknownForObjectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetIUnknownForObjectArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetNativeVariantForObjectArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetNativeVariantForObjectArgs(Action<MarshalGetNativeVariantForObjectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetNativeVariantForObjectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetNativeVariantForObjectArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetObjectForIUnknownArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetObjectForIUnknownArgs(Action<MarshalGetObjectForIUnknownArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetObjectForIUnknownArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetObjectForIUnknownArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetObjectForNativeVariantArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetObjectForNativeVariantArgs(Action<MarshalGetObjectForNativeVariantArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetObjectForNativeVariantArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetObjectForNativeVariantArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetObjectsForNativeVariantsArgs : TraceEvent
    {
        public string typeNames { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetObjectsForNativeVariantsArgs(Action<MarshalGetObjectsForNativeVariantsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetObjectsForNativeVariantsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeNames", typeNames);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeNames" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeNames;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetObjectsForNativeVariantsArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetStartComSlotArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetStartComSlotArgs(Action<MarshalGetStartComSlotArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetStartComSlotArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetStartComSlotArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetTypeFromCLSIDArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string guid { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal MarshalGetTypeFromCLSIDArgs(Action<MarshalGetTypeFromCLSIDArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetTypeFromCLSIDArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "guid", guid);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "guid" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return guid;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetTypeFromCLSIDArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetTypeInfoNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetTypeInfoNameArgs(Action<MarshalGetTypeInfoNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetTypeInfoNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetTypeInfoNameArgs> m_target;
        #endregion
    }
    public sealed class MarshalGetUniqueObjectForIUnknownArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalGetUniqueObjectForIUnknownArgs(Action<MarshalGetUniqueObjectForIUnknownArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalGetUniqueObjectForIUnknownArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalGetUniqueObjectForIUnknownArgs> m_target;
        #endregion
    }
    public sealed class MarshalSizeOfArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalSizeOfArgs(Action<MarshalSizeOfArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalSizeOfArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalSizeOfArgs> m_target;
        #endregion
    }
    public sealed class MarshalStructureToPtrArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string deleteOld { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal MarshalStructureToPtrArgs(Action<MarshalStructureToPtrArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalStructureToPtrArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "deleteOld", deleteOld);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "deleteOld" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return deleteOld;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalStructureToPtrArgs> m_target;
        #endregion
    }
    public sealed class MarshalUnsafeAddrOfPinnedArrayElementArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarshalUnsafeAddrOfPinnedArrayElementArgs(Action<MarshalUnsafeAddrOfPinnedArrayElementArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MarshalUnsafeAddrOfPinnedArrayElementArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarshalUnsafeAddrOfPinnedArrayElementArgs> m_target;
        #endregion
    }
    public sealed class MethodInfoInvokeArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal MethodInfoInvokeArgs(Action<MethodInfoInvokeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MethodInfoInvokeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MethodInfoInvokeArgs> m_target;
        #endregion
    }
    public sealed class MethodNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }
        public string methodName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal MethodNameArgs(Action<MethodNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<MethodNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            XmlAttrib(sb, "methodName", methodName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName", "methodName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                case 1:
                    return methodName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MethodNameArgs> m_target;
        #endregion
    }
    public sealed class QueryAttributeIsDefinedArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal QueryAttributeIsDefinedArgs(Action<QueryAttributeIsDefinedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<QueryAttributeIsDefinedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<QueryAttributeIsDefinedArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerAddingCultureFromConfigFileArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerAddingCultureFromConfigFileArgs(Action<ResourceManagerAddingCultureFromConfigFileArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerAddingCultureFromConfigFileArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerAddingCultureFromConfigFileArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string assemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string resourceFileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs(Action<ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "assemblyName", assemblyName);
            XmlAttrib(sb, "resourceFileName", resourceFileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "assemblyName", "resourceFileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return assemblyName;
                case 3:
                    return resourceFileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerCaseInsensitiveResourceStreamLookupFailedArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string assemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string resourceFileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs(Action<ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "assemblyName", assemblyName);
            XmlAttrib(sb, "resourceFileName", resourceFileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "assemblyName", "resourceFileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return assemblyName;
                case 3:
                    return resourceFileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerCaseInsensitiveResourceStreamLookupSucceededArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerCreatingResourceSetArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string fileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal ResourceManagerCreatingResourceSetArgs(Action<ResourceManagerCreatingResourceSetArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerCreatingResourceSetArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            XmlAttrib(sb, "fileName", fileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName", "fileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                case 3:
                    return fileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerCreatingResourceSetArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerCultureFoundInConfigFileArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerCultureFoundInConfigFileArgs(Action<ResourceManagerCultureFoundInConfigFileArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerCultureFoundInConfigFileArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerCultureFoundInConfigFileArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerCultureNotFoundInConfigFileArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerCultureNotFoundInConfigFileArgs(Action<ResourceManagerCultureNotFoundInConfigFileArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerCultureNotFoundInConfigFileArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerCultureNotFoundInConfigFileArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerFoundResourceSetInCacheArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerFoundResourceSetInCacheArgs(Action<ResourceManagerFoundResourceSetInCacheArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerFoundResourceSetInCacheArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerFoundResourceSetInCacheArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerFoundResourceSetInCacheUnexpectedArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerFoundResourceSetInCacheUnexpectedArgs(Action<ResourceManagerFoundResourceSetInCacheUnexpectedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerFoundResourceSetInCacheUnexpectedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerFoundResourceSetInCacheUnexpectedArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerGetSatelliteAssemblyFailedArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string assemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal ResourceManagerGetSatelliteAssemblyFailedArgs(Action<ResourceManagerGetSatelliteAssemblyFailedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerGetSatelliteAssemblyFailedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            XmlAttrib(sb, "assemblyName", assemblyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName", "assemblyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                case 3:
                    return assemblyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerGetSatelliteAssemblyFailedArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerGetSatelliteAssemblySucceededArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string assemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal ResourceManagerGetSatelliteAssemblySucceededArgs(Action<ResourceManagerGetSatelliteAssemblySucceededArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerGetSatelliteAssemblySucceededArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            XmlAttrib(sb, "assemblyName", assemblyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName", "assemblyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                case 3:
                    return assemblyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerGetSatelliteAssemblySucceededArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerLookingForResourceSetArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerLookingForResourceSetArgs(Action<ResourceManagerLookingForResourceSetArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerLookingForResourceSetArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerLookingForResourceSetArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerLookupFailedArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerLookupFailedArgs(Action<ResourceManagerLookupFailedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerLookupFailedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerLookupFailedArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerLookupStartedArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerLookupStartedArgs(Action<ResourceManagerLookupStartedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerLookupStartedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerLookupStartedArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerManifestResourceAccessDeniedArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string assemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string canonicalName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal ResourceManagerManifestResourceAccessDeniedArgs(Action<ResourceManagerManifestResourceAccessDeniedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerManifestResourceAccessDeniedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "assemblyName", assemblyName);
            XmlAttrib(sb, "canonicalName", canonicalName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "assemblyName", "canonicalName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return assemblyName;
                case 3:
                    return canonicalName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerManifestResourceAccessDeniedArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerNeutralResourceAttributeMissingArgs : TraceEvent
    {
        public string mainAssemblyName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal ResourceManagerNeutralResourceAttributeMissingArgs(Action<ResourceManagerNeutralResourceAttributeMissingArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerNeutralResourceAttributeMissingArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "mainAssemblyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return mainAssemblyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerNeutralResourceAttributeMissingArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerNeutralResourcesFoundArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string resName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerNeutralResourcesFoundArgs(Action<ResourceManagerNeutralResourcesFoundArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerNeutralResourcesFoundArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "resName", resName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "resName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return resName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerNeutralResourcesFoundArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerNeutralResourcesNotFoundArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string resName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerNeutralResourcesNotFoundArgs(Action<ResourceManagerNeutralResourcesNotFoundArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerNeutralResourcesNotFoundArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "resName", resName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "resName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return resName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerNeutralResourcesNotFoundArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerNeutralResourcesSufficientArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerNeutralResourcesSufficientArgs(Action<ResourceManagerNeutralResourcesSufficientArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerNeutralResourcesSufficientArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerNeutralResourcesSufficientArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerNotCreatingResourceSetArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ResourceManagerNotCreatingResourceSetArgs(Action<ResourceManagerNotCreatingResourceSetArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerNotCreatingResourceSetArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerNotCreatingResourceSetArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerReleasingResourcesArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal ResourceManagerReleasingResourcesArgs(Action<ResourceManagerReleasingResourcesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerReleasingResourcesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerReleasingResourcesArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerStreamFoundArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string loadedAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string resourceFileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }

        #region Private
        internal ResourceManagerStreamFoundArgs(Action<ResourceManagerStreamFoundArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerStreamFoundArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            XmlAttrib(sb, "loadedAssemblyName", loadedAssemblyName);
            XmlAttrib(sb, "resourceFileName", resourceFileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName", "loadedAssemblyName", "resourceFileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                case 3:
                    return loadedAssemblyName;
                case 4:
                    return resourceFileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerStreamFoundArgs> m_target;
        #endregion
    }
    public sealed class ResourceManagerStreamNotFoundArgs : TraceEvent
    {
        public string baseName { get { return GetUnicodeStringAt(0); } }
        public string mainAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string cultureName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string loadedAssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string resourceFileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }

        #region Private
        internal ResourceManagerStreamNotFoundArgs(Action<ResourceManagerStreamNotFoundArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ResourceManagerStreamNotFoundArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "baseName", baseName);
            XmlAttrib(sb, "mainAssemblyName", mainAssemblyName);
            XmlAttrib(sb, "cultureName", cultureName);
            XmlAttrib(sb, "loadedAssemblyName", loadedAssemblyName);
            XmlAttrib(sb, "resourceFileName", resourceFileName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "baseName", "mainAssemblyName", "cultureName", "loadedAssemblyName", "resourceFileName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return baseName;
                case 1:
                    return mainAssemblyName;
                case 2:
                    return cultureName;
                case 3:
                    return loadedAssemblyName;
                case 4:
                    return resourceFileName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ResourceManagerStreamNotFoundArgs> m_target;
        #endregion
    }
    public sealed class ThreadPoolDequeueWorkArgs : TraceEvent
    {
        public Address WorkID { get { return (Address)GetInt64At(0); } }

        #region Private
        internal ThreadPoolDequeueWorkArgs(Action<ThreadPoolDequeueWorkArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ThreadPoolDequeueWorkArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "WorkID", WorkID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "WorkID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return WorkID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ThreadPoolDequeueWorkArgs> m_target;
        #endregion
    }
    public sealed class ThreadPoolEnqueueWorkArgs : TraceEvent
    {
        public Address WorkID { get { return (Address)GetInt64At(0); } }

        #region Private
        internal ThreadPoolEnqueueWorkArgs(Action<ThreadPoolEnqueueWorkArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ThreadPoolEnqueueWorkArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "WorkID", WorkID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "WorkID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return WorkID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ThreadPoolEnqueueWorkArgs> m_target;
        #endregion
    }

    public enum ThreadTransferKind
    {
        Unknown = 0,
        ManagedTimers = 1,
        ManagedAsync = 2,   // FileStream, PipeStream. ...
        WinRT = 3,          // Dispatch operations 
    }

    public sealed class ThreadTransferReceiveArgs : TraceEvent
    {
        public Address id { get { return (Address)GetInt64At(0); } }
        public ThreadTransferKind kind { get { return (ThreadTransferKind)GetInt32At(8); } }
        public string info { get { return GetUnicodeStringAt(12); } }

        #region Private
        internal ThreadTransferReceiveArgs(Action<ThreadTransferReceiveArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(12)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(12)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ThreadTransferReceiveArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            XmlAttrib(sb, "kind", kind);
            XmlAttrib(sb, "info", info);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id", "kind", "info" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                case 1:
                    return kind;
                case 2:
                    return info;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ThreadTransferReceiveArgs> m_target;
        #endregion
    }
    public sealed class ThreadTransferReceiveHandledArgs : TraceEvent
    {
        public Address id { get { return (Address)GetInt64At(0); } }
        public ThreadTransferKind kind { get { return (ThreadTransferKind)GetInt32At(8); } }
        public string info { get { return GetUnicodeStringAt(12); } }

        #region Private
        internal ThreadTransferReceiveHandledArgs(Action<ThreadTransferReceiveHandledArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(12)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(12)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ThreadTransferReceiveHandledArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            XmlAttrib(sb, "kind", kind);
            XmlAttrib(sb, "info", info);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id", "kind", "info" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                case 1:
                    return kind;
                case 2:
                    return info;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ThreadTransferReceiveHandledArgs> m_target;
        #endregion
    }
    public sealed class ThreadTransferSendArgs : TraceEvent
    {
        public Address id { get { return (Address)GetInt64At(0); } }
        public ThreadTransferKind kind { get { return (ThreadTransferKind)GetInt32At(8); } }
        public string info { get { return GetUnicodeStringAt(12); } }
        public bool multiDequeues { get { return GetInt32At(SkipUnicodeString(12)) != 0; } }

        #region Private
        internal ThreadTransferSendArgs(Action<ThreadTransferSendArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(12) + 4));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(12) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ThreadTransferSendArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            XmlAttrib(sb, "kind", kind);
            XmlAttrib(sb, "info", info);
            XmlAttrib(sb, "multiDequeues", multiDequeues);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id", "kind", "info", "multiDequeues" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                case 1:
                    return kind;
                case 2:
                    return info;
                case 3:
                    return multiDequeues;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ThreadTransferSendArgs> m_target;
        #endregion
    }
    public sealed class TypeFullNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal TypeFullNameArgs(Action<TypeFullNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TypeFullNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TypeFullNameArgs> m_target;
        #endregion
    }
    public sealed class TypeGetTypeArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal TypeGetTypeArgs(Action<TypeGetTypeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TypeGetTypeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TypeGetTypeArgs> m_target;
        #endregion
    }
    public sealed class TypeNameArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal TypeNameArgs(Action<TypeNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TypeNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TypeNameArgs> m_target;
        #endregion
    }
    public sealed class TypeNamespaceArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal TypeNamespaceArgs(Action<TypeNamespaceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TypeNamespaceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TypeNamespaceArgs> m_target;
        #endregion
    }
    public sealed class WindowsRuntimeMarshalGetActivationFactoryArgs : TraceEvent
    {
        public string typeName { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal WindowsRuntimeMarshalGetActivationFactoryArgs(Action<WindowsRuntimeMarshalGetActivationFactoryArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<WindowsRuntimeMarshalGetActivationFactoryArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "typeName", typeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "typeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return typeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<WindowsRuntimeMarshalGetActivationFactoryArgs> m_target;
        #endregion
    }
}
