using Microsoft.Diagnostics.Tracing.Parsers.ClrPrivate;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using Address = System.UInt64;
using ClrStackWalkTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.ClrStackWalkTraceData;
using DestroyGCHandleTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.DestroyGCHandleTraceData;
// TODO FIX NOW harmonize these two and then refer to one from the other.  
using FinalizeObjectTraceData = Microsoft.Diagnostics.Tracing.Parsers.ClrPrivate.FinalizeObjectTraceData;
using GCGlobalHeapHistoryTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.GCGlobalHeapHistoryTraceData;
using GCJoinTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.GCJoinTraceData;
// be explicit about the specific types we need from the public provider
using GCMarkTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.GCMarkTraceData;
using GCNoUserDataTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.GCNoUserDataTraceData;
using GCPerHeapHistoryTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.GCPerHeapHistoryTraceData;
using PinObjectAtGCTimeTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.PinObjectAtGCTimeTraceData;
using PinPlugAtGCTimeTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.PinPlugAtGCTimeTraceData;
using SetGCHandleTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.SetGCHandleTraceData;
using ThreadPoolIOWorkTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.ThreadPoolIOWorkTraceData;
using ThreadPoolWorkingThreadCountTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.ThreadPoolWorkingThreadCountTraceData;
// the next threadpool related types are needed for backwards compat only, as we moved some events from the 
// private provider to the public provider
using ThreadPoolWorkTraceData = Microsoft.Diagnostics.Tracing.Parsers.Clr.ThreadPoolWorkTraceData;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "1.0")]
    public sealed class ClrPrivateTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "Microsoft-Windows-DotNETRuntimePrivate";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0x763fd754), unchecked((short)0x7086), unchecked((short)0x4dfe), 0x95, 0xeb, 0xc0, 0x1a, 0x46, 0xfa, 0xf4, 0xca);

        // TODO FIX NOW:  Project N and the Desktop should not have two GUIDs  
        public static readonly Guid NativeProviderGuid = new Guid(0x1095638c, 0x8748, 0x4c7a, 0xb3, 0x9e, 0xba, 0xea, 0x27, 0xb9, 0xc5, 0x89);

        public enum Keywords : long
        {
            None = 0x0,
            GC = 0x00000001,
            Binding = 0x00000002,
            NGenForceRestore = 0x00000004,
            Fusion = 0x00000008,
            LoaderHeap = 0x00000010,
            Security = 0x00000400,
            Threading = 0x10000,
            MulticoreJit = 0x20000,
            Stack = 0x40000000,
            Startup = 0x80000000,
            PerfTrack = 0x20000000,
        };

        public ClrPrivateTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<GCDecisionTraceData> GCDecision
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCDecisionTraceData(value, 1, 1, "GC", GCTaskGuid, 132, "Decision", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, ProviderGuid);
                source.UnregisterEventTemplate(value, 132, GCTaskGuid);
            }
        }
        public event Action<GCSettingsTraceData> GCSettings
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCSettingsTraceData(value, 2, 1, "GC", GCTaskGuid, 14, "Settings", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, ProviderGuid);
                source.UnregisterEventTemplate(value, 14, GCTaskGuid);
            }
        }
        public event Action<GCOptimizedTraceData> GCOptimized
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCOptimizedTraceData(value, 3, 1, "GC", GCTaskGuid, 16, "Optimized", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3, ProviderGuid);
                source.UnregisterEventTemplate(value, 16, GCTaskGuid);
            }
        }
        public event Action<GCPerHeapHistoryTraceData> GCPerHeapHistory
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCPerHeapHistoryTraceData(value, 4, 1, "GC", GCTaskGuid, 17, "PerHeapHistory", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4, ProviderGuid);
                source.UnregisterEventTemplate(value, 17, GCTaskGuid);
            }
        }
        public event Action<GCGlobalHeapHistoryTraceData> GCGlobalHeapHistory
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCGlobalHeapHistoryTraceData(value, 5, 1, "GC", GCTaskGuid, 18, "GlobalHeapHistory", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5, ProviderGuid);
                source.UnregisterEventTemplate(value, 18, GCTaskGuid);
            }
        }
        public event Action<GCJoinTraceData> GCJoin
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCJoinTraceData(value, 6, 1, "GC", GCTaskGuid, 20, "Join", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 6, ProviderGuid);
                source.UnregisterEventTemplate(value, 20, GCTaskGuid);
            }
        }
        public event Action<GCMarkTraceData> GCMarkStackRoots
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCMarkTraceData(value, 7, 1, "GC", GCTaskGuid, 21, "MarkStackRoots", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 7, ProviderGuid);
                source.UnregisterEventTemplate(value, 21, GCTaskGuid);
            }
        }
        public event Action<GCMarkTraceData> GCMarkFinalizeQueueRoots
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCMarkTraceData(value, 8, 1, "GC", GCTaskGuid, 22, "MarkFinalizeQueueRoots", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 8, ProviderGuid);
                source.UnregisterEventTemplate(value, 22, GCTaskGuid);
            }
        }
        public event Action<GCMarkTraceData> GCMarkHandles
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCMarkTraceData(value, 9, 1, "GC", GCTaskGuid, 23, "MarkHandles", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 9, ProviderGuid);
                source.UnregisterEventTemplate(value, 23, GCTaskGuid);
            }
        }
        public event Action<GCMarkTraceData> GCMarkCards
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCMarkTraceData(value, 10, 1, "GC", GCTaskGuid, 24, "MarkCards", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, ProviderGuid);
                source.UnregisterEventTemplate(value, 24, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGCStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 11, 1, "GC", GCTaskGuid, 25, "BGCStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, ProviderGuid);
                source.UnregisterEventTemplate(value, 25, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGC1stNonCondStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 12, 1, "GC", GCTaskGuid, 26, "BGC1stNonCondStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
                source.UnregisterEventTemplate(value, 26, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGC1stConStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 13, 1, "GC", GCTaskGuid, 27, "BGC1stConStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, ProviderGuid);
                source.UnregisterEventTemplate(value, 27, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGC2ndNonConStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 14, 1, "GC", GCTaskGuid, 28, "BGC2ndNonConStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 14, ProviderGuid);
                source.UnregisterEventTemplate(value, 28, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGC2ndNonConStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 15, 1, "GC", GCTaskGuid, 29, "BGC2ndNonConStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 15, ProviderGuid);
                source.UnregisterEventTemplate(value, 29, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGC2ndConStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 16, 1, "GC", GCTaskGuid, 30, "BGC2ndConStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 16, ProviderGuid);
                source.UnregisterEventTemplate(value, 30, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGC2ndConStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 17, 1, "GC", GCTaskGuid, 31, "BGC2ndConStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 17, ProviderGuid);
                source.UnregisterEventTemplate(value, 31, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGCPlanStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 18, 1, "GC", GCTaskGuid, 32, "BGCPlanStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 18, ProviderGuid);
                source.UnregisterEventTemplate(value, 32, GCTaskGuid);
            }
        }
        public event Action<GCNoUserDataTraceData> GCBGCSweepStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCNoUserDataTraceData(value, 19, 1, "GC", GCTaskGuid, 33, "BGCSweepStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 19, ProviderGuid);
                source.UnregisterEventTemplate(value, 33, GCTaskGuid);
            }
        }
        public event Action<BGCDrainMarkTraceData> GCBGCDrainMark
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BGCDrainMarkTraceData(value, 20, 1, "GC", GCTaskGuid, 34, "BGCDrainMark", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 20, ProviderGuid);
                source.UnregisterEventTemplate(value, 34, GCTaskGuid);
            }
        }
        public event Action<BGCRevisitTraceData> GCBGCRevisit
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BGCRevisitTraceData(value, 21, 1, "GC", GCTaskGuid, 35, "BGCRevisit", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 21, ProviderGuid);
                source.UnregisterEventTemplate(value, 35, GCTaskGuid);
            }
        }
        public event Action<BGCOverflowTraceData> GCBGCOverflow
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BGCOverflowTraceData(value, 22, 1, "GC", GCTaskGuid, 36, "BGCOverflow", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 22, ProviderGuid);
                source.UnregisterEventTemplate(value, 36, GCTaskGuid);
            }
        }
        public event Action<BGCAllocWaitTraceData> GCBGCAllocWaitStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BGCAllocWaitTraceData(value, 23, 1, "GC", GCTaskGuid, 37, "BGCAllocWaitStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 23, ProviderGuid);
                source.UnregisterEventTemplate(value, 37, GCTaskGuid);
            }
        }
        public event Action<BGCAllocWaitTraceData> GCBGCAllocWaitStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BGCAllocWaitTraceData(value, 24, 1, "GC", GCTaskGuid, 38, "BGCAllocWaitStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 24, ProviderGuid);
                source.UnregisterEventTemplate(value, 38, GCTaskGuid);
            }
        }
        public event Action<GCFullNotifyTraceData> GCFullNotify
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new GCFullNotifyTraceData(value, 25, 1, "GC", GCTaskGuid, 19, "FullNotify", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 25, ProviderGuid);
                source.UnregisterEventTemplate(value, 19, GCTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupEEStartupStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 80, 9, "Startup", StartupTaskGuid, 128, "EEStartupStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 80, ProviderGuid);
                source.UnregisterEventTemplate(value, 128, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupEEStartupStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 81, 9, "Startup", StartupTaskGuid, 129, "EEStartupStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 81, ProviderGuid);
                source.UnregisterEventTemplate(value, 129, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupEEConfigSetupStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 82, 9, "Startup", StartupTaskGuid, 130, "EEConfigSetupStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 82, ProviderGuid);
                source.UnregisterEventTemplate(value, 130, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupEEConfigSetupStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 83, 9, "Startup", StartupTaskGuid, 131, "EEConfigSetupStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 83, ProviderGuid);
                source.UnregisterEventTemplate(value, 131, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupLoadSystemBasesStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 84, 9, "Startup", StartupTaskGuid, 132, "LoadSystemBasesStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 84, ProviderGuid);
                source.UnregisterEventTemplate(value, 132, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupLoadSystemBasesStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 85, 9, "Startup", StartupTaskGuid, 133, "LoadSystemBasesStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 85, ProviderGuid);
                source.UnregisterEventTemplate(value, 133, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupExecExeStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 86, 9, "Startup", StartupTaskGuid, 134, "ExecExeStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 86, ProviderGuid);
                source.UnregisterEventTemplate(value, 134, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupExecExeStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 87, 9, "Startup", StartupTaskGuid, 135, "ExecExeStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 87, ProviderGuid);
                source.UnregisterEventTemplate(value, 135, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupMainStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 88, 9, "Startup", StartupTaskGuid, 136, "MainStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 88, ProviderGuid);
                source.UnregisterEventTemplate(value, 136, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupMainStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 89, 9, "Startup", StartupTaskGuid, 137, "MainStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 89, ProviderGuid);
                source.UnregisterEventTemplate(value, 137, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupApplyPolicyStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 90, 9, "Startup", StartupTaskGuid, 10, "ApplyPolicyStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 90, ProviderGuid);
                source.UnregisterEventTemplate(value, 10, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupApplyPolicyStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 91, 9, "Startup", StartupTaskGuid, 11, "ApplyPolicyStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 91, ProviderGuid);
                source.UnregisterEventTemplate(value, 11, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupLdLibShFolderStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 92, 9, "Startup", StartupTaskGuid, 12, "LdLibShFolderStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 92, ProviderGuid);
                source.UnregisterEventTemplate(value, 12, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupLdLibShFolderStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 93, 9, "Startup", StartupTaskGuid, 13, "LdLibShFolderStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 93, ProviderGuid);
                source.UnregisterEventTemplate(value, 13, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupPrestubWorkerStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 94, 9, "Startup", StartupTaskGuid, 14, "PrestubWorkerStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 94, ProviderGuid);
                source.UnregisterEventTemplate(value, 14, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupPrestubWorkerStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 95, 9, "Startup", StartupTaskGuid, 15, "PrestubWorkerStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 95, ProviderGuid);
                source.UnregisterEventTemplate(value, 15, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupGetInstallationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 96, 9, "Startup", StartupTaskGuid, 16, "GetInstallationStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 96, ProviderGuid);
                source.UnregisterEventTemplate(value, 16, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupGetInstallationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 97, 9, "Startup", StartupTaskGuid, 17, "GetInstallationStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 97, ProviderGuid);
                source.UnregisterEventTemplate(value, 17, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupOpenHModuleStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 98, 9, "Startup", StartupTaskGuid, 18, "OpenHModuleStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 98, ProviderGuid);
                source.UnregisterEventTemplate(value, 18, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupOpenHModuleStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 99, 9, "Startup", StartupTaskGuid, 19, "OpenHModuleStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 99, ProviderGuid);
                source.UnregisterEventTemplate(value, 19, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupExplicitBindStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 100, 9, "Startup", StartupTaskGuid, 20, "ExplicitBindStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 100, ProviderGuid);
                source.UnregisterEventTemplate(value, 20, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupExplicitBindStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 101, 9, "Startup", StartupTaskGuid, 21, "ExplicitBindStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 101, ProviderGuid);
                source.UnregisterEventTemplate(value, 21, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupParseXmlStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 102, 9, "Startup", StartupTaskGuid, 22, "ParseXmlStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 102, ProviderGuid);
                source.UnregisterEventTemplate(value, 22, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupParseXmlStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 103, 9, "Startup", StartupTaskGuid, 23, "ParseXmlStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 103, ProviderGuid);
                source.UnregisterEventTemplate(value, 23, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupInitDefaultDomainStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 104, 9, "Startup", StartupTaskGuid, 24, "InitDefaultDomainStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 104, ProviderGuid);
                source.UnregisterEventTemplate(value, 24, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupInitDefaultDomainStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 105, 9, "Startup", StartupTaskGuid, 25, "InitDefaultDomainStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 105, ProviderGuid);
                source.UnregisterEventTemplate(value, 25, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupInitSecurityStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 106, 9, "Startup", StartupTaskGuid, 26, "InitSecurityStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 106, ProviderGuid);
                source.UnregisterEventTemplate(value, 26, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupInitSecurityStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 107, 9, "Startup", StartupTaskGuid, 27, "InitSecurityStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 107, ProviderGuid);
                source.UnregisterEventTemplate(value, 27, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupAllowBindingRedirsStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 108, 9, "Startup", StartupTaskGuid, 28, "AllowBindingRedirsStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 108, ProviderGuid);
                source.UnregisterEventTemplate(value, 28, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupAllowBindingRedirsStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 109, 9, "Startup", StartupTaskGuid, 29, "AllowBindingRedirsStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 109, ProviderGuid);
                source.UnregisterEventTemplate(value, 29, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupEEConfigSyncStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 110, 9, "Startup", StartupTaskGuid, 30, "EEConfigSyncStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 110, ProviderGuid);
                source.UnregisterEventTemplate(value, 30, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupEEConfigSyncStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 111, 9, "Startup", StartupTaskGuid, 31, "EEConfigSyncStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 111, ProviderGuid);
                source.UnregisterEventTemplate(value, 31, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupBindingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 112, 9, "Startup", StartupTaskGuid, 32, "BindingStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 112, ProviderGuid);
                source.UnregisterEventTemplate(value, 32, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupBindingStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 113, 9, "Startup", StartupTaskGuid, 33, "BindingStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 113, ProviderGuid);
                source.UnregisterEventTemplate(value, 33, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupLoaderCatchCallStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 114, 9, "Startup", StartupTaskGuid, 34, "LoaderCatchCallStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 114, ProviderGuid);
                source.UnregisterEventTemplate(value, 34, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupLoaderCatchCallStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 115, 9, "Startup", StartupTaskGuid, 35, "LoaderCatchCallStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 115, ProviderGuid);
                source.UnregisterEventTemplate(value, 35, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupFusionInitStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 116, 9, "Startup", StartupTaskGuid, 36, "FusionInitStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 116, ProviderGuid);
                source.UnregisterEventTemplate(value, 36, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupFusionInitStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 117, 9, "Startup", StartupTaskGuid, 37, "FusionInitStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 117, ProviderGuid);
                source.UnregisterEventTemplate(value, 37, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupFusionAppCtxStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 118, 9, "Startup", StartupTaskGuid, 38, "FusionAppCtxStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 118, ProviderGuid);
                source.UnregisterEventTemplate(value, 38, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupFusionAppCtxStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 119, 9, "Startup", StartupTaskGuid, 39, "FusionAppCtxStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 119, ProviderGuid);
                source.UnregisterEventTemplate(value, 39, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupFusion2EEStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 120, 9, "Startup", StartupTaskGuid, 40, "Fusion2EEStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 120, ProviderGuid);
                source.UnregisterEventTemplate(value, 40, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupFusion2EEStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 121, 9, "Startup", StartupTaskGuid, 41, "Fusion2EEStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 121, ProviderGuid);
                source.UnregisterEventTemplate(value, 41, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupSecurityCatchCallStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 122, 9, "Startup", StartupTaskGuid, 42, "SecurityCatchCallStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 122, ProviderGuid);
                source.UnregisterEventTemplate(value, 42, StartupTaskGuid);
            }
        }
        public event Action<StartupTraceData> StartupSecurityCatchCallStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new StartupTraceData(value, 123, 9, "Startup", StartupTaskGuid, 43, "SecurityCatchCallStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 123, ProviderGuid);
                source.UnregisterEventTemplate(value, 43, StartupTaskGuid);
            }
        }
        public event Action<ClrStackWalkTraceData> ClrStackWalk
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ClrStackWalkTraceData(value, 151, 11, "ClrStack", ClrStackTaskGuid, 82, "Walk", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 151, ProviderGuid);
                source.UnregisterEventTemplate(value, 82, ClrStackTaskGuid);
            }
        }
        public event Action<ModuleRangePrivateTraceData> ClrPerfTrackModuleRangeLoad
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ModuleRangePrivateTraceData(value, 158, 20, "ClrPerfTrack", ClrPerfTrackTaskGuid, 10, "ModuleRangeLoad", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 158, ProviderGuid);
                source.UnregisterEventTemplate(value, 10, ClrPerfTrackTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingPolicyPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 159, 10, "Binding", BindingTaskGuid, 51, "PolicyPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 159, ProviderGuid);
                source.UnregisterEventTemplate(value, 51, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingPolicyPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 160, 10, "Binding", BindingTaskGuid, 52, "PolicyPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 160, ProviderGuid);
                source.UnregisterEventTemplate(value, 52, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingNgenPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 161, 10, "Binding", BindingTaskGuid, 53, "NgenPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 161, ProviderGuid);
                source.UnregisterEventTemplate(value, 53, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingNgenPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 162, 10, "Binding", BindingTaskGuid, 54, "NgenPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 162, ProviderGuid);
                source.UnregisterEventTemplate(value, 54, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoopupAndProbingPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 163, 10, "Binding", BindingTaskGuid, 55, "LoopupAndProbingPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 163, ProviderGuid);
                source.UnregisterEventTemplate(value, 55, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLookupAndProbingPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 164, 10, "Binding", BindingTaskGuid, 56, "LookupAndProbingPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 164, ProviderGuid);
                source.UnregisterEventTemplate(value, 56, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 165, 10, "Binding", BindingTaskGuid, 57, "LoaderPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 165, ProviderGuid);
                source.UnregisterEventTemplate(value, 57, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 166, 10, "Binding", BindingTaskGuid, 58, "LoaderPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 166, ProviderGuid);
                source.UnregisterEventTemplate(value, 58, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 167, 10, "Binding", BindingTaskGuid, 59, "PhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 167, ProviderGuid);
                source.UnregisterEventTemplate(value, 59, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 168, 10, "Binding", BindingTaskGuid, 60, "PhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 168, ProviderGuid);
                source.UnregisterEventTemplate(value, 60, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingDownloadPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 169, 10, "Binding", BindingTaskGuid, 61, "DownloadPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 169, ProviderGuid);
                source.UnregisterEventTemplate(value, 61, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingDownloadPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 170, 10, "Binding", BindingTaskGuid, 62, "DownloadPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 170, ProviderGuid);
                source.UnregisterEventTemplate(value, 62, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderAssemblyInitPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 171, 10, "Binding", BindingTaskGuid, 63, "LoaderAssemblyInitPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 171, ProviderGuid);
                source.UnregisterEventTemplate(value, 63, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderAssemblyInitPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 172, 10, "Binding", BindingTaskGuid, 64, "LoaderAssemblyInitPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 172, ProviderGuid);
                source.UnregisterEventTemplate(value, 64, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderMappingPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 173, 10, "Binding", BindingTaskGuid, 65, "LoaderMappingPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 173, ProviderGuid);
                source.UnregisterEventTemplate(value, 65, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderMappingPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 174, 10, "Binding", BindingTaskGuid, 66, "LoaderMappingPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 174, ProviderGuid);
                source.UnregisterEventTemplate(value, 66, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderDeliverEventPhaseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 175, 10, "Binding", BindingTaskGuid, 67, "LoaderDeliverEventPhaseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 175, ProviderGuid);
                source.UnregisterEventTemplate(value, 67, BindingTaskGuid);
            }
        }
        public event Action<BindingTraceData> BindingLoaderDeliverEventsPhaseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new BindingTraceData(value, 176, 10, "Binding", BindingTaskGuid, 68, "LoaderDeliverEventsPhaseStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 176, ProviderGuid);
                source.UnregisterEventTemplate(value, 68, BindingTaskGuid);
            }
        }
        public event Action<EvidenceGeneratedTraceData> EvidenceGenerationEvidenceGenerated
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new EvidenceGeneratedTraceData(value, 177, 12, "EvidenceGeneration", EvidenceGenerationTaskGuid, 10, "EvidenceGenerated", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 177, ProviderGuid);
                source.UnregisterEventTemplate(value, 10, EvidenceGenerationTaskGuid);
            }
        }
        public event Action<ModuleTransparencyCalculationTraceData> TransparencyModuleTransparencyComputationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ModuleTransparencyCalculationTraceData(value, 178, 14, "Transparency", TransparencyTaskGuid, 83, "ModuleTransparencyComputationStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 178, ProviderGuid);
                source.UnregisterEventTemplate(value, 83, TransparencyTaskGuid);
            }
        }
        public event Action<ModuleTransparencyCalculationResultTraceData> TransparencyModuleTransparencyComputationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ModuleTransparencyCalculationResultTraceData(value, 179, 14, "Transparency", TransparencyTaskGuid, 84, "ModuleTransparencyComputationStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 179, ProviderGuid);
                source.UnregisterEventTemplate(value, 84, TransparencyTaskGuid);
            }
        }
        public event Action<TypeTransparencyCalculationTraceData> TransparencyTypeTransparencyComputationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new TypeTransparencyCalculationTraceData(value, 180, 14, "Transparency", TransparencyTaskGuid, 85, "TypeTransparencyComputationStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 180, ProviderGuid);
                source.UnregisterEventTemplate(value, 85, TransparencyTaskGuid);
            }
        }
        public event Action<TypeTransparencyCalculationResultTraceData> TransparencyTypeTransparencyComputationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new TypeTransparencyCalculationResultTraceData(value, 181, 14, "Transparency", TransparencyTaskGuid, 86, "TypeTransparencyComputationStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 181, ProviderGuid);
                source.UnregisterEventTemplate(value, 86, TransparencyTaskGuid);
            }
        }
        public event Action<MethodTransparencyCalculationTraceData> TransparencyMethodTransparencyComputationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new MethodTransparencyCalculationTraceData(value, 182, 14, "Transparency", TransparencyTaskGuid, 87, "MethodTransparencyComputationStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 182, ProviderGuid);
                source.UnregisterEventTemplate(value, 87, TransparencyTaskGuid);
            }
        }
        public event Action<MethodTransparencyCalculationResultTraceData> TransparencyMethodTransparencyComputationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new MethodTransparencyCalculationResultTraceData(value, 183, 14, "Transparency", TransparencyTaskGuid, 88, "MethodTransparencyComputationStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 183, ProviderGuid);
                source.UnregisterEventTemplate(value, 88, TransparencyTaskGuid);
            }
        }
        public event Action<FieldTransparencyCalculationTraceData> TransparencyFieldTransparencyComputationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new FieldTransparencyCalculationTraceData(value, 184, 14, "Transparency", TransparencyTaskGuid, 89, "FieldTransparencyComputationStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 184, ProviderGuid);
                source.UnregisterEventTemplate(value, 89, TransparencyTaskGuid);
            }
        }
        public event Action<FieldTransparencyCalculationResultTraceData> TransparencyFieldTransparencyComputationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new FieldTransparencyCalculationResultTraceData(value, 185, 14, "Transparency", TransparencyTaskGuid, 90, "FieldTransparencyComputationStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 185, ProviderGuid);
                source.UnregisterEventTemplate(value, 90, TransparencyTaskGuid);
            }
        }
        public event Action<TokenTransparencyCalculationTraceData> TransparencyTokenTransparencyComputationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new TokenTransparencyCalculationTraceData(value, 186, 14, "Transparency", TransparencyTaskGuid, 91, "TokenTransparencyComputationStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 186, ProviderGuid);
                source.UnregisterEventTemplate(value, 91, TransparencyTaskGuid);
            }
        }
        public event Action<TokenTransparencyCalculationResultTraceData> TransparencyTokenTransparencyComputationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new TokenTransparencyCalculationResultTraceData(value, 187, 14, "Transparency", TransparencyTaskGuid, 92, "TokenTransparencyComputationStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 187, ProviderGuid);
                source.UnregisterEventTemplate(value, 92, TransparencyTaskGuid);
            }
        }
        public event Action<NgenBindEventTraceData> NgenBinderNgenBind
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new NgenBindEventTraceData(value, 188, 13, "NgenBinder", NgenBinderTaskGuid, 69, "NgenBind", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 188, ProviderGuid);
                source.UnregisterEventTemplate(value, 69, NgenBinderTaskGuid);
            }
        }
        public event Action<FailFastTraceData> FailFast
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new FailFastTraceData(value, 191, 2, "FailFast", FailFastTaskGuid, 52, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 191, ProviderGuid);
                source.UnregisterEventTemplate(value, 52, FailFastTaskGuid);
            }
        }
        public event Action<FinalizeObjectTraceData> GCFinalizeObject
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new FinalizeObjectTraceData(value, 192, 1, "GC", GCTaskGuid, 39, "FinalizeObject", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 192, ProviderGuid);
                source.UnregisterEventTemplate(value, 39, GCTaskGuid);
            }
        }
        public event Action<CCWRefCountChangeAnsiTraceData> GCCCWRefCountChangeAnsi
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new CCWRefCountChangeAnsiTraceData(value, 193, 1, "GC", GCTaskGuid, 40, "CCWRefCountChangeAnsi", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 193, ProviderGuid);
                source.UnregisterEventTemplate(value, 40, GCTaskGuid);
            }
        }
        public event Action<CCWRefCountChangeTraceData> GCCCWRefCountChange
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new CCWRefCountChangeTraceData(value, 200, 1, "GC", GCTaskGuid, 40, "CCWRefCountChange", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 200, ProviderGuid);
            }
        }
        public event Action<SetGCHandleTraceData> GCSetGCHandle
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new SetGCHandleTraceData(value, 194, 1, "GC", GCTaskGuid, 42, "SetGCHandle", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 194, ProviderGuid);
                source.UnregisterEventTemplate(value, 42, GCTaskGuid);
            }
        }
        public event Action<DestroyGCHandleTraceData> GCDestroyGCHandle
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DestroyGCHandleTraceData(value, 195, 1, "GC", GCTaskGuid, 43, "DestroyGCHandle", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 195, ProviderGuid);
                source.UnregisterEventTemplate(value, 43, GCTaskGuid);
            }
        }
        public event Action<FusionMessageTraceData> BindingFusionMessage
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new FusionMessageTraceData(value, 196, 10, "Binding", BindingTaskGuid, 70, "FusionMessage", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 196, ProviderGuid);
                source.UnregisterEventTemplate(value, 70, BindingTaskGuid);
            }
        }

        // TODO FIX NOW, remove after private builds are gone.  
        public event Action<PinObjectAtGCTimeTraceData> GCPinObjectAtGCTime
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new PinObjectAtGCTimeTraceData(value, 198, 1, "GC", GCTaskGuid, 44, "PinObjectAtGCTime", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 198, ProviderGuid);
                source.UnregisterEventTemplate(value, 44, GCTaskGuid);
            }
        }
        public event Action<PinPlugAtGCTimeTraceData> GCPinPlugAtGCTime
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new PinPlugAtGCTimeTraceData(value, 199, 1, "GC", GCTaskGuid, 45, "PinPlugAtGCTime", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 199, ProviderGuid);
                source.UnregisterEventTemplate(value, 45, GCTaskGuid);
            }
        }
        public event Action<MulticoreJitPrivateTraceData> ClrMulticoreJitCommon
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new MulticoreJitPrivateTraceData(value, 201, 17, "ClrMulticoreJit", ClrMulticoreJitTaskGuid, 10, "Common", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 201, ProviderGuid);
                source.UnregisterEventTemplate(value, 10, ClrMulticoreJitTaskGuid);
            }
        }
        public event Action<MulticoreJitMethodCodeReturnedPrivateTraceData> ClrMulticoreJitMethodCodeReturned
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new MulticoreJitMethodCodeReturnedPrivateTraceData(value, 202, 17, "ClrMulticoreJit", ClrMulticoreJitTaskGuid, 11, "MethodCodeReturned", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 202, ProviderGuid);
                source.UnregisterEventTemplate(value, 11, ClrMulticoreJitTaskGuid);
            }
        }
        public event Action<ThreadPoolWorkingThreadCountTraceData> ThreadPoolWorkingThreadCountStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ThreadPoolWorkingThreadCountTraceData(value, 300, 15, "ThreadPoolWorkingThreadCount", ThreadPoolWorkingThreadCountTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 300, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ThreadPoolWorkingThreadCountTaskGuid);
            }
        }
        public event Action<ThreadPoolWorkTraceData> ThreadPoolEnqueue
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ThreadPoolWorkTraceData(value, 301, 21, "ThreadPool", ThreadPoolTaskGuid, 11, "Enqueue", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 301, ProviderGuid);
                source.UnregisterEventTemplate(value, 11, ThreadPoolTaskGuid);
            }
        }
        public event Action<ThreadPoolWorkTraceData> ThreadPoolDequeue
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ThreadPoolWorkTraceData(value, 302, 21, "ThreadPool", ThreadPoolTaskGuid, 12, "Dequeue", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 302, ProviderGuid);
                source.UnregisterEventTemplate(value, 12, ThreadPoolTaskGuid);
            }
        }
        public event Action<ThreadPoolIOWorkTraceData> ThreadPoolIOEnqueue
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ThreadPoolIOWorkTraceData(value, 303, 21, "ThreadPool", ThreadPoolTaskGuid, 13, "IOEnqueue", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 303, ProviderGuid);
                source.UnregisterEventTemplate(value, 13, ThreadPoolTaskGuid);
            }
        }
        public event Action<ThreadPoolIOWorkTraceData> ThreadPoolIODequeue
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ThreadPoolIOWorkTraceData(value, 304, 21, "ThreadPool", ThreadPoolTaskGuid, 14, "IODequeue", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 304, ProviderGuid);
                source.UnregisterEventTemplate(value, 14, ThreadPoolTaskGuid);
            }
        }
        public event Action<ThreadPoolIOWorkTraceData> ThreadPoolIOPack
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new ThreadPoolIOWorkTraceData(value, 305, 21, "ThreadPool", ThreadPoolTaskGuid, 15, "IOPack", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 305, ProviderGuid);
                source.UnregisterEventTemplate(value, 15, ThreadPoolTaskGuid);
            }
        }
        public event Action<LoaderHeapAllocRequestTraceData> LoaderHeapAllocRequest
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new LoaderHeapAllocRequestTraceData(value, 310, 16, "LoaderHeap", LoaderHeapTaskGuid, 97, "AllocRequest", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 310, ProviderGuid);
                source.UnregisterEventTemplate(value, 97, LoaderHeapTaskGuid);
            }
        }
        public event Action<DynamicTypeUsePrivateTraceData> ClrDynamicTypeUsageIInspectableRuntimeClassName
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUsePrivateTraceData(value, 400, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 11, "IInspectableRuntimeClassName", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 400, ProviderGuid);
                source.UnregisterEventTemplate(value, 11, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseTwoParametersPrivateTraceData> ClrDynamicTypeUsageWinRTUnbox
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseTwoParametersPrivateTraceData(value, 401, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 12, "WinRTUnbox", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 401, ProviderGuid);
                source.UnregisterEventTemplate(value, 12, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUsePrivateTraceData> ClrDynamicTypeUsageCreateRCW
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUsePrivateTraceData(value, 402, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 13, "CreateRCW", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 402, ProviderGuid);
                source.UnregisterEventTemplate(value, 13, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUsePrivateVarianceTraceData> ClrDynamicTypeUsageRCWVariance
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUsePrivateVarianceTraceData(value, 403, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 14, "RCWVariance", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 403, ProviderGuid);
                source.UnregisterEventTemplate(value, 14, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseTwoParametersPrivateTraceData> ClrDynamicTypeUsageRCWIEnumerableCasting
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseTwoParametersPrivateTraceData(value, 404, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 15, "RCWIEnumerableCasting", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 404, ProviderGuid);
                source.UnregisterEventTemplate(value, 15, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUsePrivateTraceData> ClrDynamicTypeUsageCreateCCW
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUsePrivateTraceData(value, 405, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 16, "CreateCCW", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 405, ProviderGuid);
                source.UnregisterEventTemplate(value, 16, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUsePrivateVarianceTraceData> ClrDynamicTypeUsageCCWVariance
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUsePrivateVarianceTraceData(value, 406, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 17, "CCWVariance", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 406, ProviderGuid);
                source.UnregisterEventTemplate(value, 17, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseStringAndIntPrivateTraceData> ClrDynamicTypeUsageObjectVariantMarshallingToNative
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseStringAndIntPrivateTraceData(value, 407, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 18, "ObjectVariantMarshallingToNative", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 407, ProviderGuid);
                source.UnregisterEventTemplate(value, 18, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseTwoParametersPrivateTraceData> ClrDynamicTypeUsageGetTypeFromGUID
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseTwoParametersPrivateTraceData(value, 408, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 19, "GetTypeFromGUID", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 408, ProviderGuid);
                source.UnregisterEventTemplate(value, 19, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseTwoParametersPrivateTraceData> ClrDynamicTypeUsageGetTypeFromProgID
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseTwoParametersPrivateTraceData(value, 409, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 20, "GetTypeFromProgID", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 409, ProviderGuid);
                source.UnregisterEventTemplate(value, 20, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseTwoParametersPrivateTraceData> ClrDynamicTypeUsageConvertToCallbackEtw
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseTwoParametersPrivateTraceData(value, 410, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 21, "ConvertToCallbackEtw", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 410, ProviderGuid);
                source.UnregisterEventTemplate(value, 21, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseNoParametersPrivateTraceData> ClrDynamicTypeUsageBeginCreateManagedReference
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseNoParametersPrivateTraceData(value, 411, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 22, "BeginCreateManagedReference", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 411, ProviderGuid);
                source.UnregisterEventTemplate(value, 22, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseNoParametersPrivateTraceData> ClrDynamicTypeUsageEndCreateManagedReference
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseNoParametersPrivateTraceData(value, 412, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 23, "EndCreateManagedReference", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 412, ProviderGuid);
                source.UnregisterEventTemplate(value, 23, ClrDynamicTypeUsageTaskGuid);
            }
        }
        public event Action<DynamicTypeUseStringAndIntPrivateTraceData> ClrDynamicTypeUsageObjectVariantMarshallingToManaged
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                RegisterTemplate(new DynamicTypeUseStringAndIntPrivateTraceData(value, 413, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 24, "ObjectVariantMarshallingToManaged", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 413, ProviderGuid);
                source.UnregisterEventTemplate(value, 24, ClrDynamicTypeUsageTaskGuid);
            }
        }

        #region Event ID Definitions
        private const TraceEventID GCDecisionEventID = (TraceEventID)1;
        private const TraceEventID GCSettingsEventID = (TraceEventID)2;
        private const TraceEventID GCOptimizedEventID = (TraceEventID)3;
        private const TraceEventID GCPerHeapHistoryEventID = (TraceEventID)4;
        private const TraceEventID GCGlobalHeapHistoryEventID = (TraceEventID)5;
        private const TraceEventID GCJoinEventID = (TraceEventID)6;
        private const TraceEventID GCMarkStackRootsEventID = (TraceEventID)7;
        private const TraceEventID GCMarkFinalizeQueueRootsEventID = (TraceEventID)8;
        private const TraceEventID GCMarkHandlesEventID = (TraceEventID)9;
        private const TraceEventID GCMarkCardsEventID = (TraceEventID)10;
        private const TraceEventID GCBGCStartEventID = (TraceEventID)11;
        private const TraceEventID GCBGC1stNonCondStopEventID = (TraceEventID)12;
        private const TraceEventID GCBGC1stConStopEventID = (TraceEventID)13;
        private const TraceEventID GCBGC2ndNonConStartEventID = (TraceEventID)14;
        private const TraceEventID GCBGC2ndNonConStopEventID = (TraceEventID)15;
        private const TraceEventID GCBGC2ndConStartEventID = (TraceEventID)16;
        private const TraceEventID GCBGC2ndConStopEventID = (TraceEventID)17;
        private const TraceEventID GCBGCPlanStopEventID = (TraceEventID)18;
        private const TraceEventID GCBGCSweepStopEventID = (TraceEventID)19;
        private const TraceEventID GCBGCDrainMarkEventID = (TraceEventID)20;
        private const TraceEventID GCBGCRevisitEventID = (TraceEventID)21;
        private const TraceEventID GCBGCOverflowEventID = (TraceEventID)22;
        private const TraceEventID GCBGCAllocWaitStartEventID = (TraceEventID)23;
        private const TraceEventID GCBGCAllocWaitStopEventID = (TraceEventID)24;
        private const TraceEventID GCFullNotifyEventID = (TraceEventID)25;
        private const TraceEventID StartupEEStartupStartEventID = (TraceEventID)80;
        private const TraceEventID StartupEEStartupStopEventID = (TraceEventID)81;
        private const TraceEventID StartupEEConfigSetupStartEventID = (TraceEventID)82;
        private const TraceEventID StartupEEConfigSetupStopEventID = (TraceEventID)83;
        private const TraceEventID StartupLoadSystemBasesStartEventID = (TraceEventID)84;
        private const TraceEventID StartupLoadSystemBasesStopEventID = (TraceEventID)85;
        private const TraceEventID StartupExecExeStartEventID = (TraceEventID)86;
        private const TraceEventID StartupExecExeStopEventID = (TraceEventID)87;
        private const TraceEventID StartupMainStartEventID = (TraceEventID)88;
        private const TraceEventID StartupMainStopEventID = (TraceEventID)89;
        private const TraceEventID StartupApplyPolicyStartEventID = (TraceEventID)90;
        private const TraceEventID StartupApplyPolicyStopEventID = (TraceEventID)91;
        private const TraceEventID StartupLdLibShFolderStartEventID = (TraceEventID)92;
        private const TraceEventID StartupLdLibShFolderStopEventID = (TraceEventID)93;
        private const TraceEventID StartupPrestubWorkerStartEventID = (TraceEventID)94;
        private const TraceEventID StartupPrestubWorkerStopEventID = (TraceEventID)95;
        private const TraceEventID StartupGetInstallationStartEventID = (TraceEventID)96;
        private const TraceEventID StartupGetInstallationStopEventID = (TraceEventID)97;
        private const TraceEventID StartupOpenHModuleStartEventID = (TraceEventID)98;
        private const TraceEventID StartupOpenHModuleStopEventID = (TraceEventID)99;
        private const TraceEventID StartupExplicitBindStartEventID = (TraceEventID)100;
        private const TraceEventID StartupExplicitBindStopEventID = (TraceEventID)101;
        private const TraceEventID StartupParseXmlStartEventID = (TraceEventID)102;
        private const TraceEventID StartupParseXmlStopEventID = (TraceEventID)103;
        private const TraceEventID StartupInitDefaultDomainStartEventID = (TraceEventID)104;
        private const TraceEventID StartupInitDefaultDomainStopEventID = (TraceEventID)105;
        private const TraceEventID StartupInitSecurityStartEventID = (TraceEventID)106;
        private const TraceEventID StartupInitSecurityStopEventID = (TraceEventID)107;
        private const TraceEventID StartupAllowBindingRedirsStartEventID = (TraceEventID)108;
        private const TraceEventID StartupAllowBindingRedirsStopEventID = (TraceEventID)109;
        private const TraceEventID StartupEEConfigSyncStartEventID = (TraceEventID)110;
        private const TraceEventID StartupEEConfigSyncStopEventID = (TraceEventID)111;
        private const TraceEventID StartupBindingStartEventID = (TraceEventID)112;
        private const TraceEventID StartupBindingStopEventID = (TraceEventID)113;
        private const TraceEventID StartupLoaderCatchCallStartEventID = (TraceEventID)114;
        private const TraceEventID StartupLoaderCatchCallStopEventID = (TraceEventID)115;
        private const TraceEventID StartupFusionInitStartEventID = (TraceEventID)116;
        private const TraceEventID StartupFusionInitStopEventID = (TraceEventID)117;
        private const TraceEventID StartupFusionAppCtxStartEventID = (TraceEventID)118;
        private const TraceEventID StartupFusionAppCtxStopEventID = (TraceEventID)119;
        private const TraceEventID StartupFusion2EEStartEventID = (TraceEventID)120;
        private const TraceEventID StartupFusion2EEStopEventID = (TraceEventID)121;
        private const TraceEventID StartupSecurityCatchCallStartEventID = (TraceEventID)122;
        private const TraceEventID StartupSecurityCatchCallStopEventID = (TraceEventID)123;
        private const TraceEventID ClrStackWalkEventID = (TraceEventID)151;
        private const TraceEventID ClrPerfTrackModuleRangeLoadEventID = (TraceEventID)158;
        private const TraceEventID BindingPolicyPhaseStartEventID = (TraceEventID)159;
        private const TraceEventID BindingPolicyPhaseStopEventID = (TraceEventID)160;
        private const TraceEventID BindingNgenPhaseStartEventID = (TraceEventID)161;
        private const TraceEventID BindingNgenPhaseStopEventID = (TraceEventID)162;
        private const TraceEventID BindingLoopupAndProbingPhaseStartEventID = (TraceEventID)163;
        private const TraceEventID BindingLookupAndProbingPhaseStopEventID = (TraceEventID)164;
        private const TraceEventID BindingLoaderPhaseStartEventID = (TraceEventID)165;
        private const TraceEventID BindingLoaderPhaseStopEventID = (TraceEventID)166;
        private const TraceEventID BindingPhaseStartEventID = (TraceEventID)167;
        private const TraceEventID BindingPhaseStopEventID = (TraceEventID)168;
        private const TraceEventID BindingDownloadPhaseStartEventID = (TraceEventID)169;
        private const TraceEventID BindingDownloadPhaseStopEventID = (TraceEventID)170;
        private const TraceEventID BindingLoaderAssemblyInitPhaseStartEventID = (TraceEventID)171;
        private const TraceEventID BindingLoaderAssemblyInitPhaseStopEventID = (TraceEventID)172;
        private const TraceEventID BindingLoaderMappingPhaseStartEventID = (TraceEventID)173;
        private const TraceEventID BindingLoaderMappingPhaseStopEventID = (TraceEventID)174;
        private const TraceEventID BindingLoaderDeliverEventPhaseStartEventID = (TraceEventID)175;
        private const TraceEventID BindingLoaderDeliverEventsPhaseStopEventID = (TraceEventID)176;
        private const TraceEventID EvidenceGenerationEvidenceGeneratedEventID = (TraceEventID)177;
        private const TraceEventID TransparencyModuleTransparencyComputationStartEventID = (TraceEventID)178;
        private const TraceEventID TransparencyModuleTransparencyComputationStopEventID = (TraceEventID)179;
        private const TraceEventID TransparencyTypeTransparencyComputationStartEventID = (TraceEventID)180;
        private const TraceEventID TransparencyTypeTransparencyComputationStopEventID = (TraceEventID)181;
        private const TraceEventID TransparencyMethodTransparencyComputationStartEventID = (TraceEventID)182;
        private const TraceEventID TransparencyMethodTransparencyComputationStopEventID = (TraceEventID)183;
        private const TraceEventID TransparencyFieldTransparencyComputationStartEventID = (TraceEventID)184;
        private const TraceEventID TransparencyFieldTransparencyComputationStopEventID = (TraceEventID)185;
        private const TraceEventID TransparencyTokenTransparencyComputationStartEventID = (TraceEventID)186;
        private const TraceEventID TransparencyTokenTransparencyComputationStopEventID = (TraceEventID)187;
        private const TraceEventID NgenBinderNgenBindEventID = (TraceEventID)188;
        private const TraceEventID FailFastFailFastEventID = (TraceEventID)191;
        private const TraceEventID GCPinGCObjectEventID = (TraceEventID)198;
        private const TraceEventID GCPinGCPlugEventID = (TraceEventID)199;
        private const TraceEventID ClrMulticoreJitCommonEventID = (TraceEventID)201;
        private const TraceEventID MulticoreJitMethodCodeReturnedEventID = (TraceEventID)202;
        private const TraceEventID ThreadPoolWorkingThreadCountStartEventID = (TraceEventID)300;
        private const TraceEventID LoaderHeapLoaderHeapAllocRequestEventID = (TraceEventID)310;
        #endregion

        #region private
        protected override string GetProviderName() { return ProviderName; }
        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[133];
                templates[0] = new GCDecisionTraceData(null, 1, 1, "GC", GCTaskGuid, 132, "Decision", ProviderGuid, ProviderName);
                templates[1] = new GCSettingsTraceData(null, 2, 1, "GC", GCTaskGuid, 14, "Settings", ProviderGuid, ProviderName);
                templates[2] = new GCOptimizedTraceData(null, 3, 1, "GC", GCTaskGuid, 16, "Optimized", ProviderGuid, ProviderName);
                templates[3] = new GCPerHeapHistoryTraceData(null, 4, 1, "GC", GCTaskGuid, 17, "PerHeapHistory", ProviderGuid, ProviderName);
                templates[4] = new GCGlobalHeapHistoryTraceData(null, 5, 1, "GC", GCTaskGuid, 18, "GlobalHeapHistory", ProviderGuid, ProviderName);
                templates[5] = new GCJoinTraceData(null, 6, 1, "GC", GCTaskGuid, 20, "Join", ProviderGuid, ProviderName);
                templates[6] = new GCMarkTraceData(null, 7, 1, "GC", GCTaskGuid, 21, "MarkStackRoots", ProviderGuid, ProviderName);
                templates[7] = new GCMarkTraceData(null, 8, 1, "GC", GCTaskGuid, 22, "MarkFinalizeQueueRoots", ProviderGuid, ProviderName);
                templates[8] = new GCMarkTraceData(null, 9, 1, "GC", GCTaskGuid, 23, "MarkHandles", ProviderGuid, ProviderName);
                templates[9] = new GCMarkTraceData(null, 10, 1, "GC", GCTaskGuid, 24, "MarkCards", ProviderGuid, ProviderName);
                templates[10] = new GCNoUserDataTraceData(null, 11, 1, "GC", GCTaskGuid, 25, "BGCStart", ProviderGuid, ProviderName);
                templates[11] = new GCNoUserDataTraceData(null, 12, 1, "GC", GCTaskGuid, 26, "BGC1stNonCondStop", ProviderGuid, ProviderName);
                templates[12] = new GCNoUserDataTraceData(null, 13, 1, "GC", GCTaskGuid, 27, "BGC1stConStop", ProviderGuid, ProviderName);
                templates[13] = new GCNoUserDataTraceData(null, 14, 1, "GC", GCTaskGuid, 28, "BGC2ndNonConStart", ProviderGuid, ProviderName);
                templates[14] = new GCNoUserDataTraceData(null, 15, 1, "GC", GCTaskGuid, 29, "BGC2ndNonConStop", ProviderGuid, ProviderName);
                templates[15] = new GCNoUserDataTraceData(null, 16, 1, "GC", GCTaskGuid, 30, "BGC2ndConStart", ProviderGuid, ProviderName);
                templates[16] = new GCNoUserDataTraceData(null, 17, 1, "GC", GCTaskGuid, 31, "BGC2ndConStop", ProviderGuid, ProviderName);
                templates[17] = new GCNoUserDataTraceData(null, 18, 1, "GC", GCTaskGuid, 32, "BGCPlanStop", ProviderGuid, ProviderName);
                templates[18] = new GCNoUserDataTraceData(null, 19, 1, "GC", GCTaskGuid, 33, "BGCSweepStop", ProviderGuid, ProviderName);
                templates[19] = new BGCDrainMarkTraceData(null, 20, 1, "GC", GCTaskGuid, 34, "BGCDrainMark", ProviderGuid, ProviderName);
                templates[20] = new BGCRevisitTraceData(null, 21, 1, "GC", GCTaskGuid, 35, "BGCRevisit", ProviderGuid, ProviderName);
                templates[21] = new BGCOverflowTraceData(null, 22, 1, "GC", GCTaskGuid, 36, "BGCOverflow", ProviderGuid, ProviderName);
                templates[22] = new BGCAllocWaitTraceData(null, 23, 1, "GC", GCTaskGuid, 37, "BGCAllocWaitStart", ProviderGuid, ProviderName);
                templates[23] = new BGCAllocWaitTraceData(null, 24, 1, "GC", GCTaskGuid, 38, "BGCAllocWaitStop", ProviderGuid, ProviderName);
                templates[24] = new GCFullNotifyTraceData(null, 25, 1, "GC", GCTaskGuid, 19, "FullNotify", ProviderGuid, ProviderName);
                templates[25] = new StartupTraceData(null, 80, 9, "Startup", StartupTaskGuid, 128, "EEStartupStart", ProviderGuid, ProviderName);
                templates[26] = new StartupTraceData(null, 81, 9, "Startup", StartupTaskGuid, 129, "EEStartupStop", ProviderGuid, ProviderName);
                templates[27] = new StartupTraceData(null, 82, 9, "Startup", StartupTaskGuid, 130, "EEConfigSetupStart", ProviderGuid, ProviderName);
                templates[28] = new StartupTraceData(null, 83, 9, "Startup", StartupTaskGuid, 131, "EEConfigSetupStop", ProviderGuid, ProviderName);
                templates[29] = new StartupTraceData(null, 84, 9, "Startup", StartupTaskGuid, 132, "LoadSystemBasesStart", ProviderGuid, ProviderName);
                templates[30] = new StartupTraceData(null, 85, 9, "Startup", StartupTaskGuid, 133, "LoadSystemBasesStop", ProviderGuid, ProviderName);
                templates[31] = new StartupTraceData(null, 86, 9, "Startup", StartupTaskGuid, 134, "ExecExeStart", ProviderGuid, ProviderName);
                templates[32] = new StartupTraceData(null, 87, 9, "Startup", StartupTaskGuid, 135, "ExecExeStop", ProviderGuid, ProviderName);
                templates[33] = new StartupTraceData(null, 88, 9, "Startup", StartupTaskGuid, 136, "MainStart", ProviderGuid, ProviderName);
                templates[34] = new StartupTraceData(null, 89, 9, "Startup", StartupTaskGuid, 137, "MainStop", ProviderGuid, ProviderName);
                templates[35] = new StartupTraceData(null, 90, 9, "Startup", StartupTaskGuid, 10, "ApplyPolicyStart", ProviderGuid, ProviderName);
                templates[36] = new StartupTraceData(null, 91, 9, "Startup", StartupTaskGuid, 11, "ApplyPolicyStop", ProviderGuid, ProviderName);
                templates[37] = new StartupTraceData(null, 92, 9, "Startup", StartupTaskGuid, 12, "LdLibShFolderStart", ProviderGuid, ProviderName);
                templates[38] = new StartupTraceData(null, 93, 9, "Startup", StartupTaskGuid, 13, "LdLibShFolderStop", ProviderGuid, ProviderName);
                templates[39] = new StartupTraceData(null, 94, 9, "Startup", StartupTaskGuid, 14, "PrestubWorkerStart", ProviderGuid, ProviderName);
                templates[40] = new StartupTraceData(null, 95, 9, "Startup", StartupTaskGuid, 15, "PrestubWorkerStop", ProviderGuid, ProviderName);
                templates[41] = new StartupTraceData(null, 96, 9, "Startup", StartupTaskGuid, 16, "GetInstallationStart", ProviderGuid, ProviderName);
                templates[42] = new StartupTraceData(null, 97, 9, "Startup", StartupTaskGuid, 17, "GetInstallationStop", ProviderGuid, ProviderName);
                templates[43] = new StartupTraceData(null, 98, 9, "Startup", StartupTaskGuid, 18, "OpenHModuleStart", ProviderGuid, ProviderName);
                templates[44] = new StartupTraceData(null, 99, 9, "Startup", StartupTaskGuid, 19, "OpenHModuleStop", ProviderGuid, ProviderName);
                templates[45] = new StartupTraceData(null, 100, 9, "Startup", StartupTaskGuid, 20, "ExplicitBindStart", ProviderGuid, ProviderName);
                templates[46] = new StartupTraceData(null, 101, 9, "Startup", StartupTaskGuid, 21, "ExplicitBindStop", ProviderGuid, ProviderName);
                templates[47] = new StartupTraceData(null, 102, 9, "Startup", StartupTaskGuid, 22, "ParseXmlStart", ProviderGuid, ProviderName);
                templates[48] = new StartupTraceData(null, 103, 9, "Startup", StartupTaskGuid, 23, "ParseXmlStop", ProviderGuid, ProviderName);
                templates[49] = new StartupTraceData(null, 104, 9, "Startup", StartupTaskGuid, 24, "InitDefaultDomainStart", ProviderGuid, ProviderName);
                templates[50] = new StartupTraceData(null, 105, 9, "Startup", StartupTaskGuid, 25, "InitDefaultDomainStop", ProviderGuid, ProviderName);
                templates[51] = new StartupTraceData(null, 106, 9, "Startup", StartupTaskGuid, 26, "InitSecurityStart", ProviderGuid, ProviderName);
                templates[52] = new StartupTraceData(null, 107, 9, "Startup", StartupTaskGuid, 27, "InitSecurityStop", ProviderGuid, ProviderName);
                templates[53] = new StartupTraceData(null, 108, 9, "Startup", StartupTaskGuid, 28, "AllowBindingRedirsStart", ProviderGuid, ProviderName);
                templates[54] = new StartupTraceData(null, 109, 9, "Startup", StartupTaskGuid, 29, "AllowBindingRedirsStop", ProviderGuid, ProviderName);
                templates[55] = new StartupTraceData(null, 110, 9, "Startup", StartupTaskGuid, 30, "EEConfigSyncStart", ProviderGuid, ProviderName);
                templates[56] = new StartupTraceData(null, 111, 9, "Startup", StartupTaskGuid, 31, "EEConfigSyncStop", ProviderGuid, ProviderName);
                templates[57] = new StartupTraceData(null, 112, 9, "Startup", StartupTaskGuid, 32, "BindingStart", ProviderGuid, ProviderName);
                templates[58] = new StartupTraceData(null, 113, 9, "Startup", StartupTaskGuid, 33, "BindingStop", ProviderGuid, ProviderName);
                templates[59] = new StartupTraceData(null, 114, 9, "Startup", StartupTaskGuid, 34, "LoaderCatchCallStart", ProviderGuid, ProviderName);
                templates[60] = new StartupTraceData(null, 115, 9, "Startup", StartupTaskGuid, 35, "LoaderCatchCallStop", ProviderGuid, ProviderName);
                templates[61] = new StartupTraceData(null, 116, 9, "Startup", StartupTaskGuid, 36, "FusionInitStart", ProviderGuid, ProviderName);
                templates[62] = new StartupTraceData(null, 117, 9, "Startup", StartupTaskGuid, 37, "FusionInitStop", ProviderGuid, ProviderName);
                templates[63] = new StartupTraceData(null, 118, 9, "Startup", StartupTaskGuid, 38, "FusionAppCtxStart", ProviderGuid, ProviderName);
                templates[64] = new StartupTraceData(null, 119, 9, "Startup", StartupTaskGuid, 39, "FusionAppCtxStop", ProviderGuid, ProviderName);
                templates[65] = new StartupTraceData(null, 120, 9, "Startup", StartupTaskGuid, 40, "Fusion2EEStart", ProviderGuid, ProviderName);
                templates[66] = new StartupTraceData(null, 121, 9, "Startup", StartupTaskGuid, 41, "Fusion2EEStop", ProviderGuid, ProviderName);
                templates[67] = new StartupTraceData(null, 122, 9, "Startup", StartupTaskGuid, 42, "SecurityCatchCallStart", ProviderGuid, ProviderName);
                templates[68] = new StartupTraceData(null, 123, 9, "Startup", StartupTaskGuid, 43, "SecurityCatchCallStop", ProviderGuid, ProviderName);
                templates[69] = new ClrStackWalkTraceData(null, 151, 11, "ClrStack", ClrStackTaskGuid, 82, "Walk", ProviderGuid, ProviderName);
                templates[70] = new ModuleRangePrivateTraceData(null, 158, 20, "ClrPerfTrack", ClrPerfTrackTaskGuid, 10, "ModuleRangeLoad", ProviderGuid, ProviderName);
                templates[71] = new BindingTraceData(null, 159, 10, "Binding", BindingTaskGuid, 51, "PolicyPhaseStart", ProviderGuid, ProviderName);
                templates[72] = new BindingTraceData(null, 160, 10, "Binding", BindingTaskGuid, 52, "PolicyPhaseStop", ProviderGuid, ProviderName);
                templates[73] = new BindingTraceData(null, 161, 10, "Binding", BindingTaskGuid, 53, "NgenPhaseStart", ProviderGuid, ProviderName);
                templates[74] = new BindingTraceData(null, 162, 10, "Binding", BindingTaskGuid, 54, "NgenPhaseStop", ProviderGuid, ProviderName);
                templates[75] = new BindingTraceData(null, 163, 10, "Binding", BindingTaskGuid, 55, "LoopupAndProbingPhaseStart", ProviderGuid, ProviderName);
                templates[76] = new BindingTraceData(null, 164, 10, "Binding", BindingTaskGuid, 56, "LookupAndProbingPhaseStop", ProviderGuid, ProviderName);
                templates[77] = new BindingTraceData(null, 165, 10, "Binding", BindingTaskGuid, 57, "LoaderPhaseStart", ProviderGuid, ProviderName);
                templates[78] = new BindingTraceData(null, 166, 10, "Binding", BindingTaskGuid, 58, "LoaderPhaseStop", ProviderGuid, ProviderName);
                templates[79] = new BindingTraceData(null, 167, 10, "Binding", BindingTaskGuid, 59, "PhaseStart", ProviderGuid, ProviderName);
                templates[80] = new BindingTraceData(null, 168, 10, "Binding", BindingTaskGuid, 60, "PhaseStop", ProviderGuid, ProviderName);
                templates[81] = new BindingTraceData(null, 169, 10, "Binding", BindingTaskGuid, 61, "DownloadPhaseStart", ProviderGuid, ProviderName);
                templates[82] = new BindingTraceData(null, 170, 10, "Binding", BindingTaskGuid, 62, "DownloadPhaseStop", ProviderGuid, ProviderName);
                templates[83] = new BindingTraceData(null, 171, 10, "Binding", BindingTaskGuid, 63, "LoaderAssemblyInitPhaseStart", ProviderGuid, ProviderName);
                templates[84] = new BindingTraceData(null, 172, 10, "Binding", BindingTaskGuid, 64, "LoaderAssemblyInitPhaseStop", ProviderGuid, ProviderName);
                templates[85] = new BindingTraceData(null, 173, 10, "Binding", BindingTaskGuid, 65, "LoaderMappingPhaseStart", ProviderGuid, ProviderName);
                templates[86] = new BindingTraceData(null, 174, 10, "Binding", BindingTaskGuid, 66, "LoaderMappingPhaseStop", ProviderGuid, ProviderName);
                templates[87] = new BindingTraceData(null, 175, 10, "Binding", BindingTaskGuid, 67, "LoaderDeliverEventPhaseStart", ProviderGuid, ProviderName);
                templates[88] = new BindingTraceData(null, 176, 10, "Binding", BindingTaskGuid, 68, "LoaderDeliverEventsPhaseStop", ProviderGuid, ProviderName);
                templates[89] = new EvidenceGeneratedTraceData(null, 177, 12, "EvidenceGeneration", EvidenceGenerationTaskGuid, 10, "EvidenceGenerated", ProviderGuid, ProviderName);
                templates[90] = new ModuleTransparencyCalculationTraceData(null, 178, 14, "Transparency", TransparencyTaskGuid, 83, "ModuleTransparencyComputationStart", ProviderGuid, ProviderName);
                templates[91] = new ModuleTransparencyCalculationResultTraceData(null, 179, 14, "Transparency", TransparencyTaskGuid, 84, "ModuleTransparencyComputationStop", ProviderGuid, ProviderName);
                templates[92] = new TypeTransparencyCalculationTraceData(null, 180, 14, "Transparency", TransparencyTaskGuid, 85, "TypeTransparencyComputationStart", ProviderGuid, ProviderName);
                templates[93] = new TypeTransparencyCalculationResultTraceData(null, 181, 14, "Transparency", TransparencyTaskGuid, 86, "TypeTransparencyComputationStop", ProviderGuid, ProviderName);
                templates[94] = new MethodTransparencyCalculationTraceData(null, 182, 14, "Transparency", TransparencyTaskGuid, 87, "MethodTransparencyComputationStart", ProviderGuid, ProviderName);
                templates[95] = new MethodTransparencyCalculationResultTraceData(null, 183, 14, "Transparency", TransparencyTaskGuid, 88, "MethodTransparencyComputationStop", ProviderGuid, ProviderName);
                templates[96] = new FieldTransparencyCalculationTraceData(null, 184, 14, "Transparency", TransparencyTaskGuid, 89, "FieldTransparencyComputationStart", ProviderGuid, ProviderName);
                templates[97] = new FieldTransparencyCalculationResultTraceData(null, 185, 14, "Transparency", TransparencyTaskGuid, 90, "FieldTransparencyComputationStop", ProviderGuid, ProviderName);
                templates[98] = new TokenTransparencyCalculationTraceData(null, 186, 14, "Transparency", TransparencyTaskGuid, 91, "TokenTransparencyComputationStart", ProviderGuid, ProviderName);
                templates[99] = new TokenTransparencyCalculationResultTraceData(null, 187, 14, "Transparency", TransparencyTaskGuid, 92, "TokenTransparencyComputationStop", ProviderGuid, ProviderName);
                templates[100] = new NgenBindEventTraceData(null, 188, 13, "NgenBinder", NgenBinderTaskGuid, 69, "NgenBind", ProviderGuid, ProviderName);
                templates[101] = new FailFastTraceData(null, 191, 2, "FailFast", FailFastTaskGuid, 52, "", ProviderGuid, ProviderName);
                templates[102] = new FinalizeObjectTraceData(null, 192, 1, "GC", GCTaskGuid, 39, "FinalizeObject", ProviderGuid, ProviderName);
                templates[103] = new CCWRefCountChangeAnsiTraceData(null, 193, 1, "GC", GCTaskGuid, 40, "CCWRefCountChangeAnsi", ProviderGuid, ProviderName);
                templates[104] = new SetGCHandleTraceData(null, 194, 1, "GC", GCTaskGuid, 42, "SetGCHandle", ProviderGuid, ProviderName);
                templates[105] = new DestroyGCHandleTraceData(null, 195, 1, "GC", GCTaskGuid, 43, "DestroyGCHandle", ProviderGuid, ProviderName);
                templates[106] = new FusionMessageTraceData(null, 196, 10, "Binding", BindingTaskGuid, 70, "FusionMessage", ProviderGuid, ProviderName);
                templates[107] = new PinObjectAtGCTimeTraceData(null, 198, 1, "GC", GCTaskGuid, 44, "PinObjectAtGCTime", ProviderGuid, ProviderName);
                templates[108] = new PinPlugAtGCTimeTraceData(null, 199, 1, "GC", GCTaskGuid, 45, "PinPlugAtGCTime", ProviderGuid, ProviderName);
                templates[109] = new MulticoreJitPrivateTraceData(null, 201, 17, "ClrMulticoreJit", ClrMulticoreJitTaskGuid, 10, "Common", ProviderGuid, ProviderName);
                templates[110] = new MulticoreJitMethodCodeReturnedPrivateTraceData(null, 202, 17, "ClrMulticoreJit", ClrMulticoreJitTaskGuid, 11, "MethodCodeReturned", ProviderGuid, ProviderName);
                templates[111] = new ThreadPoolWorkingThreadCountTraceData(null, 300, 15, "ThreadPoolWorkingThreadCount", ThreadPoolWorkingThreadCountTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[112] = new ThreadPoolWorkTraceData(null, 301, 21, "ThreadPool", ThreadPoolTaskGuid, 11, "Enqueue", ProviderGuid, ProviderName);
                templates[113] = new ThreadPoolWorkTraceData(null, 302, 21, "ThreadPool", ThreadPoolTaskGuid, 12, "Dequeue", ProviderGuid, ProviderName);
                templates[114] = new ThreadPoolIOWorkTraceData(null, 303, 21, "ThreadPool", ThreadPoolTaskGuid, 13, "IOEnqueue", ProviderGuid, ProviderName);
                templates[115] = new ThreadPoolIOWorkTraceData(null, 304, 21, "ThreadPool", ThreadPoolTaskGuid, 14, "IODequeue", ProviderGuid, ProviderName);
                templates[116] = new ThreadPoolIOWorkTraceData(null, 305, 21, "ThreadPool", ThreadPoolTaskGuid, 15, "IOPack", ProviderGuid, ProviderName);
                templates[117] = new LoaderHeapAllocRequestTraceData(null, 310, 16, "LoaderHeap", LoaderHeapTaskGuid, 97, "AllocRequest", ProviderGuid, ProviderName);
                templates[118] = new DynamicTypeUsePrivateTraceData(null, 400, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 11, "IInspectableRuntimeClassName", ProviderGuid, ProviderName);
                templates[119] = new DynamicTypeUseTwoParametersPrivateTraceData(null, 401, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 12, "WinRTUnbox", ProviderGuid, ProviderName);
                templates[120] = new DynamicTypeUsePrivateTraceData(null, 402, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 13, "CreateRCW", ProviderGuid, ProviderName);
                templates[121] = new DynamicTypeUsePrivateVarianceTraceData(null, 403, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 14, "RCWVariance", ProviderGuid, ProviderName);
                templates[122] = new DynamicTypeUseTwoParametersPrivateTraceData(null, 404, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 15, "RCWIEnumerableCasting", ProviderGuid, ProviderName);
                templates[123] = new DynamicTypeUsePrivateTraceData(null, 405, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 16, "CreateCCW", ProviderGuid, ProviderName);
                templates[124] = new DynamicTypeUsePrivateVarianceTraceData(null, 406, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 17, "CCWVariance", ProviderGuid, ProviderName);
                templates[125] = new DynamicTypeUseStringAndIntPrivateTraceData(null, 407, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 18, "ObjectVariantMarshallingToNative", ProviderGuid, ProviderName);
                templates[126] = new DynamicTypeUseTwoParametersPrivateTraceData(null, 408, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 19, "GetTypeFromGUID", ProviderGuid, ProviderName);
                templates[127] = new DynamicTypeUseTwoParametersPrivateTraceData(null, 409, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 20, "GetTypeFromProgID", ProviderGuid, ProviderName);
                templates[128] = new DynamicTypeUseTwoParametersPrivateTraceData(null, 410, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 21, "ConvertToCallbackEtw", ProviderGuid, ProviderName);
                templates[129] = new DynamicTypeUseNoParametersPrivateTraceData(null, 411, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 22, "BeginCreateManagedReference", ProviderGuid, ProviderName);
                templates[130] = new DynamicTypeUseNoParametersPrivateTraceData(null, 412, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 23, "EndCreateManagedReference", ProviderGuid, ProviderName);
                templates[131] = new DynamicTypeUseStringAndIntPrivateTraceData(null, 413, 22, "ClrDynamicTypeUsage", ClrDynamicTypeUsageTaskGuid, 24, "ObjectVariantMarshallingToManaged", ProviderGuid, ProviderName);
                templates[132] = new CCWRefCountChangeTraceData(null, 200, 1, "GC", GCTaskGuid, 40, "CCWRefCountChange", ProviderGuid, ProviderName);

                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        private static readonly Guid GCTaskGuid = new Guid(unchecked((int)0x2f1b6bf6), unchecked((short)0x18ff), unchecked((short)0x4645), 0x95, 0x01, 0x15, 0xdf, 0x6c, 0x64, 0xc2, 0xcf);
        private static readonly Guid FailFastTaskGuid = new Guid(unchecked((int)0xee9ede12), unchecked((short)0xc5f5), unchecked((short)0x4995), 0x81, 0xa2, 0xdc, 0xfb, 0x5f, 0x6b, 0x80, 0xc8);
        private static readonly Guid StartupTaskGuid = new Guid(unchecked((int)0x02d08a4f), unchecked((short)0xfd01), unchecked((short)0x4538), 0x98, 0x9b, 0x03, 0xe4, 0x37, 0xb9, 0x50, 0xf4);
        private static readonly Guid BindingTaskGuid = new Guid(unchecked((int)0xe90e32ba), unchecked((short)0xe396), unchecked((short)0x4e6a), 0xa7, 0x90, 0x0a, 0x08, 0xc6, 0xc9, 0x25, 0xdc);
        private static readonly Guid ClrStackTaskGuid = new Guid(unchecked((int)0xd3363dc0), unchecked((short)0x243a), unchecked((short)0x4620), 0xa4, 0xd0, 0x8a, 0x07, 0xd7, 0x72, 0xf5, 0x33);
        private static readonly Guid EvidenceGenerationTaskGuid = new Guid(unchecked((int)0x24333617), unchecked((short)0x5ae4), unchecked((short)0x4f9e), 0xa5, 0xc5, 0x5e, 0xde, 0x1b, 0xc5, 0x92, 0x07);
        private static readonly Guid NgenBinderTaskGuid = new Guid(unchecked((int)0x861f5339), unchecked((short)0x19d6), unchecked((short)0x4873), 0xb3, 0x50, 0x7b, 0x03, 0x22, 0x8b, 0xda, 0x7c);
        private static readonly Guid TransparencyTaskGuid = new Guid(unchecked((int)0xe2444377), unchecked((short)0xddf9), unchecked((short)0x4589), 0xa8, 0x85, 0x08, 0xd6, 0x09, 0x25, 0x21, 0xdf);
        private static readonly Guid ThreadPoolWorkingThreadCountTaskGuid = new Guid(unchecked((int)0x1b032b96), unchecked((short)0x767c), unchecked((short)0x42e4), 0x84, 0x81, 0xcb, 0x52, 0x8a, 0x66, 0xd7, 0xbd);
        private static readonly Guid LoaderHeapTaskGuid = new Guid(unchecked((int)0x87f1e966), unchecked((short)0xd604), unchecked((short)0x41ba), 0xb1, 0xab, 0x18, 0x38, 0x49, 0xdf, 0xf2, 0x9d);
        private static readonly Guid ClrMulticoreJitTaskGuid = new Guid(unchecked((int)0xb85ad9e5), unchecked((short)0x658b), unchecked((short)0x4215), 0x8d, 0xdb, 0x83, 0x40, 0x40, 0xf4, 0xbc, 0x10);
        private static readonly Guid ClrPerfTrackTaskGuid = new Guid(unchecked((int)0xeac685f6), unchecked((short)0x2104), unchecked((short)0x4dec), 0x88, 0xfd, 0x91, 0xe4, 0x25, 0x42, 0x21, 0xec);
        private static readonly Guid ThreadPoolTaskGuid = new Guid(unchecked((int)0xead685f6), unchecked((short)0x2104), unchecked((short)0x4dec), 0x88, 0xfd, 0x91, 0xe4, 0x25, 0x42, 0x21, 0xe9);
        private static readonly Guid ClrDynamicTypeUsageTaskGuid = new Guid(unchecked((int)0x4f67e18d), unchecked((short)0xeedd), unchecked((short)0x4056), 0xb8, 0xce, 0xdd, 0x82, 0x2f, 0xe5, 0x45, 0x53);

        protected internal override IEnumerable<CtfEventMapping> EnumerateCtfEventMappings()
        {
            yield return new CtfEventMapping("DotNETRuntimePrivate:ApplyPolicyStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 10, 90, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ApplyPolicyStart_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 10, 90, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ModuleRangeLoadPrivate", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 10, 158, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EvidenceGenerated", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 10, 177, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:MulticoreJit", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 10, 201, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ApplyPolicyEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 11, 91, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ApplyPolicyEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 11, 91, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:MulticoreJitMethodCodeReturned", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 11, 202, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:IInspectableRuntimeClassName", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 11, 400, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdLibShFolder", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 12, 92, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdLibShFolder_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 12, 92, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:WinRTUnbox", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 12, 401, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdLibShFolderEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 13, 93, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdLibShFolderEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 13, 93, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:CreateRCW", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 13, 402, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCSettings", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 14, 2, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCSettings_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 14, 2, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrestubWorker", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 14, 94, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrestubWorker_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 14, 94, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:RCWVariance", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 14, 403, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrestubWorkerEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 15, 95, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrestubWorkerEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 15, 95, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:RCWIEnumerableCasting", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 15, 404, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCOptimized", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 16, 3, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCOptimized_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 16, 3, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GetInstallationStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 16, 96, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GetInstallationStart_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 16, 96, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:CreateCCW", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 16, 405, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCPerHeapHistory", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 17, 4, 2);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCPerHeapHistory_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 17, 4, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GetInstallationEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 17, 97, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GetInstallationEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 17, 97, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:CCWVariance", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 17, 406, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCGlobalHeapHistory", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 18, 5, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCGlobalHeapHistory_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 18, 5, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:OpenHModule", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 18, 98, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:OpenHModule_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 18, 98, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ObjectVariantMarshallingToNative", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 18, 407, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCFullNotify", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 19, 25, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCFullNotify_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 19, 25, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:OpenHModuleEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 19, 99, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:OpenHModuleEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 19, 99, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GetTypeFromGUID", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 19, 408, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCJoin", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 20, 6, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCJoin_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 20, 6, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExplicitBindStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 20, 100, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExplicitBindStart_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 20, 100, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GetTypeFromProgID", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 20, 409, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkStackRoots", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 21, 7, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkStackRoots_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 21, 7, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExplicitBindEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 21, 101, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExplicitBindEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 21, 101, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ConvertToCallbackEtw", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 21, 410, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkFinalizeQueueRoots", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 22, 8, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkFinalizeQueueRoots_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 22, 8, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ParseXml", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 22, 102, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ParseXml_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 22, 102, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BeginCreateManagedReference", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 22, 411, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkHandles", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 23, 9, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkHandles_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 23, 9, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ParseXmlEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 23, 103, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ParseXmlEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 23, 103, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EndCreateManagedReference", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 23, 412, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkCards", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 24, 10, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvGCMarkCards_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 24, 10, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitDefaultDomain", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 24, 104, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitDefaultDomain_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 24, 104, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ObjectVariantMarshallingToManaged", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 24, 413, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCBegin", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 25, 11, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitDefaultDomainEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 25, 105, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitDefaultDomainEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 25, 105, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGC1stNonConEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 26, 12, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitSecurity", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 26, 106, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitSecurity_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 26, 106, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGC1stConEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 27, 13, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitSecurityEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 27, 107, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:InitSecurityEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 27, 107, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGC2ndNonConBegin", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 28, 14, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:AllowBindingRedirs", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 28, 108, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:AllowBindingRedirs_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 28, 108, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGC2ndNonConEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 29, 15, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:AllowBindingRedirsEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 29, 109, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:AllowBindingRedirsEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 29, 109, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGC2ndConBegin", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 30, 16, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSync", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 30, 110, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSync_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 30, 110, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGC2ndConEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 31, 17, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSyncEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 31, 111, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSyncEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 31, 111, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCPlanEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 32, 18, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionBinding", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 32, 112, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionBinding_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 32, 112, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCSweepEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 33, 19, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionBindingEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 33, 113, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionBindingEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 33, 113, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCDrainMark", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 34, 20, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderCatchCall", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 34, 114, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderCatchCall_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 34, 114, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCRevisit", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 35, 21, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderCatchCallEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 35, 115, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderCatchCallEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 35, 115, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCOverflow", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 36, 22, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionInit", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 36, 116, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionInit_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 36, 116, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCAllocWaitBegin", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 37, 23, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionInitEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 37, 117, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionInitEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 37, 117, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BGCAllocWaitEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 38, 24, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionAppCtx", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 38, 118, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionAppCtx_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 38, 118, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionAppCtxEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 39, 119, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionAppCtxEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 39, 119, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvFinalizeObject", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 39, 192, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:Fusion2EE", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 40, 120, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:Fusion2EE_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 40, 120, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:CCWRefCountChange", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 40, 193, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:Fusion2EEEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 41, 121, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:Fusion2EEEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 41, 121, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:SecurityCatchCall", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 42, 122, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:SecurityCatchCall_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 42, 122, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvSetGCHandle", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 42, 194, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:SecurityCatchCallEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 43, 123, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:SecurityCatchCallEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 43, 123, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PrvDestroyGCHandle", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 43, 195, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:PinPlugAtGCTime", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 44, 199, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingPolicyPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 51, 159, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingPolicyPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 52, 160, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FailFast", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 52, 191, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingNgenPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 53, 161, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingNgenPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 54, 162, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingLookupAndProbingPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 55, 163, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingLookupAndProbingPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 56, 164, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 57, 165, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 58, 166, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 59, 167, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 60, 168, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingDownloadPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 61, 169, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:BindingDownloadPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 62, 170, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderAssemblyInitPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 63, 171, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderAssemblyInitPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 64, 172, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderMappingPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 65, 173, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderMappingPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 66, 174, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderDeliverEventsPhaseStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 67, 175, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LoaderDeliverEventsPhaseEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 68, 176, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:NgenBindEvent", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 69, 188, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionMessageEvent", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 70, 196, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FusionErrorCodeEvent", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 71, 197, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:CLRStackWalkPrivate", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 82, 151, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ModuleTransparencyComputationStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 83, 178, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ModuleTransparencyComputationEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 84, 179, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:TypeTransparencyComputationStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 85, 180, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:TypeTransparencyComputationEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 86, 181, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:MethodTransparencyComputationStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 87, 182, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:MethodTransparencyComputationEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 88, 183, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FieldTransparencyComputationStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 89, 184, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:FieldTransparencyComputationEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 90, 185, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:TokenTransparencyComputationStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 91, 186, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:TokenTransparencyComputationEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 92, 187, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:AllocRequest", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 97, 310, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEStartupStart", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 128, 80, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEStartupStart_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 128, 80, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEStartupEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 129, 81, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEStartupEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 129, 81, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSetup", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 130, 82, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSetup_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 130, 82, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSetupEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 131, 83, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:EEConfigSetupEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 131, 83, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCDecision", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 132, 1, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:GCDecision_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 132, 1, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdSysBases", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 132, 84, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdSysBases_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 132, 84, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdSysBasesEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 133, 85, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:LdSysBasesEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 133, 85, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExecExe", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 134, 86, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExecExe_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 134, 86, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExecExeEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 135, 87, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:ExecExeEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 135, 87, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:Main", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 136, 88, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:Main_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 136, 88, 1);
            yield return new CtfEventMapping("DotNETRuntimePrivate:MainEnd", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 137, 89, 0);
            yield return new CtfEventMapping("DotNETRuntimePrivate:MainEnd_V1", Parsers.ClrPrivateTraceEventParser.ProviderGuid, 137, 89, 1);
        }

        // TODO remove if project N's Guids are harmonized with the desktop 
        private void RegisterTemplate(TraceEvent template)
        {
            Debug.Assert(template.ProviderGuid == ClrPrivateTraceEventParser.ProviderGuid);        // It is the desktop GUID 
            var projectNTemplate = template.Clone();
            projectNTemplate.providerGuid = ClrPrivateTraceEventParser.NativeProviderGuid;

            source.RegisterEventTemplate(template);
            source.RegisterEventTemplate(projectNTemplate);

            // TODO FIX NOW also have to unregister the project N templates.  
        }
        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.ClrPrivate
{
    public sealed class GCDecisionTraceData : TraceEvent
    {
        public bool DoCompact { get { return GetInt32At(0) != 0; } }
        public int ClrInstanceID { get { if (Version >= 1) { return GetInt16At(4); } return 0; } }

        #region Private
        internal GCDecisionTraceData(Action<GCDecisionTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<GCDecisionTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4));
            Debug.Assert(!(Version == 1 && EventDataLength != 6));
            Debug.Assert(!(Version > 1 && EventDataLength < 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "DoCompact", DoCompact);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "DoCompact", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return DoCompact;
                case 1:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCDecisionTraceData> Action;
        #endregion
    }
    public sealed class GCSettingsTraceData : TraceEvent
    {
        public long SegmentSize { get { return GetInt64At(0); } }
        public long LargeObjectSegmentSize { get { return GetInt64At(8); } }
        public bool ServerGC { get { return GetInt32At(16) != 0; } }
        public int ClrInstanceID { get { if (Version >= 1) { return GetInt16At(20); } return 0; } }

        #region Private
        internal GCSettingsTraceData(Action<GCSettingsTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<GCSettingsTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 20));
            Debug.Assert(!(Version == 1 && EventDataLength != 22));
            Debug.Assert(!(Version > 1 && EventDataLength < 22));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SegmentSize", SegmentSize);
            XmlAttrib(sb, "LargeObjectSegmentSize", LargeObjectSegmentSize);
            XmlAttrib(sb, "ServerGC", ServerGC);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SegmentSize", "LargeObjectSegmentSize", "ServerGC", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SegmentSize;
                case 1:
                    return LargeObjectSegmentSize;
                case 2:
                    return ServerGC;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCSettingsTraceData> Action;
        #endregion
    }
    public sealed class GCOptimizedTraceData : TraceEvent
    {
        public long DesiredAllocation { get { return GetInt64At(0); } }
        public long NewAllocation { get { return GetInt64At(8); } }
        public int GenerationNumber { get { return GetInt32At(16); } }
        public int ClrInstanceID { get { if (Version >= 1) { return GetInt16At(20); } return 0; } }

        #region Private
        internal GCOptimizedTraceData(Action<GCOptimizedTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<GCOptimizedTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 20));
            Debug.Assert(!(Version == 1 && EventDataLength != 22));
            Debug.Assert(!(Version > 1 && EventDataLength < 22));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "DesiredAllocation", DesiredAllocation);
            XmlAttribHex(sb, "NewAllocation", NewAllocation);
            XmlAttrib(sb, "GenerationNumber", GenerationNumber);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "DesiredAllocation", "NewAllocation", "GenerationNumber", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return DesiredAllocation;
                case 1:
                    return NewAllocation;
                case 2:
                    return GenerationNumber;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCOptimizedTraceData> Action;
        #endregion
    }

    public sealed class BGCDrainMarkTraceData : TraceEvent
    {
        public long Objects { get { return GetInt64At(0); } }
        public int ClrInstanceID { get { return GetInt16At(8); } }

        #region Private
        internal BGCDrainMarkTraceData(Action<BGCDrainMarkTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BGCDrainMarkTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 10));
            Debug.Assert(!(Version > 0 && EventDataLength < 10));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Objects", Objects);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Objects", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Objects;
                case 1:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BGCDrainMarkTraceData> Action;
        #endregion
    }
    public sealed class BGCRevisitTraceData : TraceEvent
    {
        public long Pages { get { return GetInt64At(0); } }
        public long Objects { get { return GetInt64At(8); } }
        public int IsLarge { get { return GetInt32At(16); } }
        public int ClrInstanceID { get { return GetInt16At(20); } }

        #region Private
        internal BGCRevisitTraceData(Action<BGCRevisitTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BGCRevisitTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 22));
            Debug.Assert(!(Version > 0 && EventDataLength < 22));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Pages", Pages);
            XmlAttrib(sb, "Objects", Objects);
            XmlAttrib(sb, "IsLarge", IsLarge);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Pages", "Objects", "IsLarge", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Pages;
                case 1:
                    return Objects;
                case 2:
                    return IsLarge;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BGCRevisitTraceData> Action;
        #endregion
    }
    public sealed class BGCOverflowTraceData : TraceEvent
    {
        public long Min { get { return GetInt64At(0); } }
        public long Max { get { return GetInt64At(8); } }
        public long Objects { get { return GetInt64At(16); } }
        public int IsLarge { get { return GetInt32At(24); } }
        public int ClrInstanceID { get { return GetInt16At(28); } }

        #region Private
        internal BGCOverflowTraceData(Action<BGCOverflowTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BGCOverflowTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 30));
            Debug.Assert(!(Version > 0 && EventDataLength < 30));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Min", Min);
            XmlAttrib(sb, "Max", Max);
            XmlAttrib(sb, "Objects", Objects);
            XmlAttrib(sb, "IsLarge", IsLarge);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Min", "Max", "Objects", "IsLarge", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Min;
                case 1:
                    return Max;
                case 2:
                    return Objects;
                case 3:
                    return IsLarge;
                case 4:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BGCOverflowTraceData> Action;
        #endregion
    }
    public sealed class BGCAllocWaitTraceData : TraceEvent
    {
        public int Reason { get { return GetInt32At(0); } }
        public int ClrInstanceID { get { return GetInt16At(4); } }

        #region Private
        internal BGCAllocWaitTraceData(Action<BGCAllocWaitTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BGCAllocWaitTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 6));
            Debug.Assert(!(Version > 0 && EventDataLength < 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Reason", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Reason;
                case 1:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BGCAllocWaitTraceData> Action;
        #endregion
    }
    public sealed class GCFullNotifyTraceData : TraceEvent
    {
        public int GenNumber { get { return GetInt32At(0); } }
        public int IsAlloc { get { return GetInt32At(4); } }
        public int ClrInstanceID { get { if (Version >= 1) { return GetInt16At(8); } return 0; } }

        #region Private
        internal GCFullNotifyTraceData(Action<GCFullNotifyTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<GCFullNotifyTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version == 1 && EventDataLength != 10));
            Debug.Assert(!(Version > 1 && EventDataLength < 10));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "GenNumber", GenNumber);
            XmlAttrib(sb, "IsAlloc", IsAlloc);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "GenNumber", "IsAlloc", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return GenNumber;
                case 1:
                    return IsAlloc;
                case 2:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCFullNotifyTraceData> Action;
        #endregion
    }
    public sealed class StartupTraceData : TraceEvent
    {
        public int ClrInstanceID { get { if (Version >= 1) { return GetInt16At(0); } return 0; } }

        #region Private
        internal StartupTraceData(Action<StartupTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<StartupTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 2));
            Debug.Assert(!(Version > 1 && EventDataLength < 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<StartupTraceData> Action;
        #endregion
    }
    public sealed class ModuleRangePrivateTraceData : TraceEvent
    {
        public int ClrInstanceID { get { return GetInt16At(0); } }
        public long ModuleID { get { return GetInt64At(2); } }
        public int RangeBegin { get { return GetInt32At(10); } }
        public int RangeSize { get { return GetInt32At(14); } }
        public ModuleRangeType RangeType { get { return (ModuleRangeType)GetByteAt(18); } }
        public ModuleRangeIBCType IBCType { get { return (ModuleRangeIBCType)GetByteAt(19); } }
        public ModuleRangeSectionType SectionType { get { return (ModuleRangeSectionType)GetInt16At(20); } }

        #region Private
        internal ModuleRangePrivateTraceData(Action<ModuleRangePrivateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ModuleRangePrivateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            // TODO FIX NOW gives 19 on win8 Debug.Assert(!(Version == 0 && EventDataLength != 22));
            Debug.Assert(!(Version > 0 && EventDataLength < 22));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            XmlAttribHex(sb, "ModuleID", ModuleID);
            XmlAttribHex(sb, "RangeBegin", RangeBegin);
            XmlAttribHex(sb, "RangeSize", RangeSize);
            XmlAttrib(sb, "RangeType", RangeType);
            XmlAttrib(sb, "IBCType", IBCType);
            XmlAttrib(sb, "SectionType", SectionType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClrInstanceID", "ModuleID", "RangeBegin", "RangeSize", "RangeType", "IBCType", "SectionType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClrInstanceID;
                case 1:
                    return ModuleID;
                case 2:
                    return RangeBegin;
                case 3:
                    return RangeSize;
                case 4:
                    return RangeType;
                case 5:
                    return IBCType;
                case 6:
                    return SectionType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ModuleRangePrivateTraceData> Action;
        #endregion
    }
    public sealed class BindingTraceData : TraceEvent
    {
        public int AppDomainID { get { return GetInt32At(0); } }
        public int LoadContextID { get { return GetInt32At(4); } }
        public int FromLoaderCache { get { return GetInt32At(8); } }
        public int DynamicLoad { get { return GetInt32At(12); } }
        public string AssemblyCodebase { get { return GetUnicodeStringAt(16); } }
        public string AssemblyName { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(16))); } }

        #region Private
        internal BindingTraceData(Action<BindingTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<BindingTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16)) + 2));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16)) + 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "LoadContextID", LoadContextID);
            XmlAttrib(sb, "FromLoaderCache", FromLoaderCache);
            XmlAttrib(sb, "DynamicLoad", DynamicLoad);
            XmlAttrib(sb, "AssemblyCodebase", AssemblyCodebase);
            XmlAttrib(sb, "AssemblyName", AssemblyName);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AppDomainID", "LoadContextID", "FromLoaderCache", "DynamicLoad", "AssemblyCodebase", "AssemblyName", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AppDomainID;
                case 1:
                    return LoadContextID;
                case 2:
                    return FromLoaderCache;
                case 3:
                    return DynamicLoad;
                case 4:
                    return AssemblyCodebase;
                case 5:
                    return AssemblyName;
                case 6:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<BindingTraceData> Action;
        #endregion
    }
    public sealed class EvidenceGeneratedTraceData : TraceEvent
    {
        public int Type { get { return GetInt32At(0); } }
        public int AppDomain { get { return GetInt32At(4); } }
        public string ILImage { get { return GetUnicodeStringAt(8); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(8)); } }

        #region Private
        internal EvidenceGeneratedTraceData(Action<EvidenceGeneratedTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<EvidenceGeneratedTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8) + 2));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8) + 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Type", Type);
            XmlAttrib(sb, "AppDomain", AppDomain);
            XmlAttrib(sb, "ILImage", ILImage);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Type", "AppDomain", "ILImage", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Type;
                case 1:
                    return AppDomain;
                case 2:
                    return ILImage;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EvidenceGeneratedTraceData> Action;
        #endregion
    }
    public sealed class ModuleTransparencyCalculationTraceData : TraceEvent
    {
        public string Module { get { return GetUnicodeStringAt(0); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(0)); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(0) + 4); } }

        #region Private
        internal ModuleTransparencyCalculationTraceData(Action<ModuleTransparencyCalculationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ModuleTransparencyCalculationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 6));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Module", "AppDomainID", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Module;
                case 1:
                    return AppDomainID;
                case 2:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ModuleTransparencyCalculationTraceData> Action;
        #endregion
    }
    public sealed class ModuleTransparencyCalculationResultTraceData : TraceEvent
    {
        public string Module { get { return GetUnicodeStringAt(0); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(0)); } }
        public bool IsAllCritical { get { return GetInt32At(SkipUnicodeString(0) + 4) != 0; } }
        public bool IsAllTransparent { get { return GetInt32At(SkipUnicodeString(0) + 8) != 0; } }
        public bool IsTreatAsSafe { get { return GetInt32At(SkipUnicodeString(0) + 12) != 0; } }
        public bool IsOpportunisticallyCritical { get { return GetInt32At(SkipUnicodeString(0) + 16) != 0; } }
        public int SecurityRuleSet { get { return GetInt32At(SkipUnicodeString(0) + 20); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(0) + 24); } }

        #region Private
        internal ModuleTransparencyCalculationResultTraceData(Action<ModuleTransparencyCalculationResultTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ModuleTransparencyCalculationResultTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 26));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 26));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "IsAllCritical", IsAllCritical);
            XmlAttrib(sb, "IsAllTransparent", IsAllTransparent);
            XmlAttrib(sb, "IsTreatAsSafe", IsTreatAsSafe);
            XmlAttrib(sb, "IsOpportunisticallyCritical", IsOpportunisticallyCritical);
            XmlAttrib(sb, "SecurityRuleSet", SecurityRuleSet);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Module", "AppDomainID", "IsAllCritical", "IsAllTransparent", "IsTreatAsSafe", "IsOpportunisticallyCritical", "SecurityRuleSet", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Module;
                case 1:
                    return AppDomainID;
                case 2:
                    return IsAllCritical;
                case 3:
                    return IsAllTransparent;
                case 4:
                    return IsTreatAsSafe;
                case 5:
                    return IsOpportunisticallyCritical;
                case 6:
                    return SecurityRuleSet;
                case 7:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ModuleTransparencyCalculationResultTraceData> Action;
        #endregion
    }
    public sealed class TypeTransparencyCalculationTraceData : TraceEvent
    {
        public string Type { get { return GetUnicodeStringAt(0); } }
        public string Module { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0))); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(0)) + 4); } }

        #region Private
        internal TypeTransparencyCalculationTraceData(Action<TypeTransparencyCalculationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TypeTransparencyCalculationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 6));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Type", Type);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Type", "Module", "AppDomainID", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Type;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TypeTransparencyCalculationTraceData> Action;
        #endregion
    }
    public sealed class TypeTransparencyCalculationResultTraceData : TraceEvent
    {
        public string Type { get { return GetUnicodeStringAt(0); } }
        public string Module { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0))); } }
        public bool IsAllCritical { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 4) != 0; } }
        public bool IsAllTransparent { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 8) != 0; } }
        public bool IsCritical { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 12) != 0; } }
        public bool IsTreatAsSafe { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 16) != 0; } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(0)) + 20); } }

        #region Private
        internal TypeTransparencyCalculationResultTraceData(Action<TypeTransparencyCalculationResultTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TypeTransparencyCalculationResultTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 22));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 22));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Type", Type);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "IsAllCritical", IsAllCritical);
            XmlAttrib(sb, "IsAllTransparent", IsAllTransparent);
            XmlAttrib(sb, "IsCritical", IsCritical);
            XmlAttrib(sb, "IsTreatAsSafe", IsTreatAsSafe);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Type", "Module", "AppDomainID", "IsAllCritical", "IsAllTransparent", "IsCritical", "IsTreatAsSafe", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Type;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return IsAllCritical;
                case 4:
                    return IsAllTransparent;
                case 5:
                    return IsCritical;
                case 6:
                    return IsTreatAsSafe;
                case 7:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TypeTransparencyCalculationResultTraceData> Action;
        #endregion
    }
    public sealed class MethodTransparencyCalculationTraceData : TraceEvent
    {
        public string Method { get { return GetUnicodeStringAt(0); } }
        public string Module { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0))); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(0)) + 4); } }

        #region Private
        internal MethodTransparencyCalculationTraceData(Action<MethodTransparencyCalculationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<MethodTransparencyCalculationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 6));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Method", Method);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Method", "Module", "AppDomainID", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Method;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MethodTransparencyCalculationTraceData> Action;
        #endregion
    }
    public sealed class MethodTransparencyCalculationResultTraceData : TraceEvent
    {
        public string Method { get { return GetUnicodeStringAt(0); } }
        public string Module { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0))); } }
        public bool IsCritical { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 4) != 0; } }
        public bool IsTreatAsSafe { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 8) != 0; } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(0)) + 12); } }

        #region Private
        internal MethodTransparencyCalculationResultTraceData(Action<MethodTransparencyCalculationResultTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<MethodTransparencyCalculationResultTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 14));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 14));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Method", Method);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "IsCritical", IsCritical);
            XmlAttrib(sb, "IsTreatAsSafe", IsTreatAsSafe);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Method", "Module", "AppDomainID", "IsCritical", "IsTreatAsSafe", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Method;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return IsCritical;
                case 4:
                    return IsTreatAsSafe;
                case 5:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MethodTransparencyCalculationResultTraceData> Action;
        #endregion
    }
    public sealed class FieldTransparencyCalculationTraceData : TraceEvent
    {
        public string Field { get { return GetUnicodeStringAt(0); } }
        public string Module { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0))); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(0)) + 4); } }

        #region Private
        internal FieldTransparencyCalculationTraceData(Action<FieldTransparencyCalculationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FieldTransparencyCalculationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 6));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Field", Field);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Field", "Module", "AppDomainID", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Field;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FieldTransparencyCalculationTraceData> Action;
        #endregion
    }
    public sealed class FieldTransparencyCalculationResultTraceData : TraceEvent
    {
        public string Field { get { return GetUnicodeStringAt(0); } }
        public string Module { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0))); } }
        public bool IsCritical { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 4) != 0; } }
        public bool IsTreatAsSafe { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 8) != 0; } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(0)) + 12); } }

        #region Private
        internal FieldTransparencyCalculationResultTraceData(Action<FieldTransparencyCalculationResultTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FieldTransparencyCalculationResultTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 14));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 14));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Field", Field);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "IsCritical", IsCritical);
            XmlAttrib(sb, "IsTreatAsSafe", IsTreatAsSafe);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Field", "Module", "AppDomainID", "IsCritical", "IsTreatAsSafe", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Field;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return IsCritical;
                case 4:
                    return IsTreatAsSafe;
                case 5:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FieldTransparencyCalculationResultTraceData> Action;
        #endregion
    }
    public sealed class TokenTransparencyCalculationTraceData : TraceEvent
    {
        public int Token { get { return GetInt32At(0); } }
        public string Module { get { return GetUnicodeStringAt(4); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(4)); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(4) + 4); } }

        #region Private
        internal TokenTransparencyCalculationTraceData(Action<TokenTransparencyCalculationTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TokenTransparencyCalculationTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4) + 6));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4) + 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Token", Token);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Token", "Module", "AppDomainID", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Token;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TokenTransparencyCalculationTraceData> Action;
        #endregion
    }
    public sealed class TokenTransparencyCalculationResultTraceData : TraceEvent
    {
        public int Token { get { return GetInt32At(0); } }
        public string Module { get { return GetUnicodeStringAt(4); } }
        public int AppDomainID { get { return GetInt32At(SkipUnicodeString(4)); } }
        public bool IsCritical { get { return GetInt32At(SkipUnicodeString(4) + 4) != 0; } }
        public bool IsTreatAsSafe { get { return GetInt32At(SkipUnicodeString(4) + 8) != 0; } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(4) + 12); } }

        #region Private
        internal TokenTransparencyCalculationResultTraceData(Action<TokenTransparencyCalculationResultTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TokenTransparencyCalculationResultTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4) + 14));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4) + 14));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Token", Token);
            XmlAttrib(sb, "Module", Module);
            XmlAttrib(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "IsCritical", IsCritical);
            XmlAttrib(sb, "IsTreatAsSafe", IsTreatAsSafe);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Token", "Module", "AppDomainID", "IsCritical", "IsTreatAsSafe", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Token;
                case 1:
                    return Module;
                case 2:
                    return AppDomainID;
                case 3:
                    return IsCritical;
                case 4:
                    return IsTreatAsSafe;
                case 5:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TokenTransparencyCalculationResultTraceData> Action;
        #endregion
    }

    public enum NGenBind
    {
        // Many of these are not used.  
        START_BIND = 0,
        NO_INDEX = 1,
        SYSTEM_ASSEMBLY_NOT_AVAILABLE = 2,
        NO_NATIVE_IMAGE = 3,
        REJECT_CONFIG_MASK = 4,
        FAIL = 5,
        INDEX_CORRUPTION = 6,
        REJECT_TIMESTAMP = 7,
        REJECT_NATIVEIMAGE_NOT_FOUND = 8,
        REJECT_IL_SIG = 9,
        REJECT_LOADER_EVAL_FAIL = 10,
        MISSING_FOUND = 11,
        REJECT_HOSTASM = 12,
        REJECT_IL_NOT_FOUND = 13,
        REJECT_APPBASE_NOT_FILE = 14,
        BIND_DEPEND_REJECT_REF_DEF_MISMATCH = 15,
        BIND_DEPEND_REJECT_NGEN_SIG = 16,
        APPLY_EXTERNAL_RELOCS_FAILED = 17,
        SYSTEM_ASSEMBLY_NATIVEIMAGE_NOT_AVAILABLE = 18,
        ASSEMBLY_HAS_DIFFERENT_GRANT = 19,
        ASSEMBLY_NOT_DOMAIN_NEUTRAL = 20,
        NATIVEIMAGE_VERSION_MISMATCH = 21,
        LOADFROM_NOT_ALLOWED = 22,
        DEPENDENCY_HAS_DIFFERENT_IDENTITY = 23
    };

    public sealed class NgenBindEventTraceData : TraceEvent
    {
        public int ClrInstanceID { get { return GetInt16At(0); } }
        public long BindingID { get { return GetInt64At(2); } }
        public NGenBind ReasonCode { get { return (NGenBind)GetInt32At(10); } }
        public string AssemblyName { get { return GetUnicodeStringAt(14); } }

        #region Private
        internal NgenBindEventTraceData(Action<NgenBindEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<NgenBindEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(14)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(14)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            XmlAttrib(sb, "BindingID", BindingID);
            XmlAttrib(sb, "ReasonCode", ReasonCode);
            XmlAttrib(sb, "AssemblyName", AssemblyName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClrInstanceID", "BindingID", "ReasonCode", "AssemblyName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClrInstanceID;
                case 1:
                    return BindingID;
                case 2:
                    return ReasonCode;
                case 3:
                    return AssemblyName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<NgenBindEventTraceData> Action;
        #endregion
    }
    public sealed class FailFastTraceData : TraceEvent
    {
        public string FailFastUserMessage { get { return GetUnicodeStringAt(0); } }
        public Address FailedEIP { get { return GetAddressAt(SkipUnicodeString(0)); } }
        public int OSExitCode { get { return GetInt32At(HostOffset(SkipUnicodeString(0) + 4, 1)); } }
        public int ClrExitCode { get { return GetInt32At(HostOffset(SkipUnicodeString(0) + 8, 1)); } }
        public int ClrInstanceID { get { return GetInt16At(HostOffset(SkipUnicodeString(0) + 12, 1)); } }

        #region Private
        internal FailFastTraceData(Action<FailFastTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FailFastTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(SkipUnicodeString(0) + 14, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(SkipUnicodeString(0) + 14, 1)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "FailFastUserMessage", FailFastUserMessage);
            XmlAttribHex(sb, "FailedEIP", FailedEIP);
            XmlAttrib(sb, "OSExitCode", OSExitCode);
            XmlAttrib(sb, "ClrExitCode", ClrExitCode);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "FailFastUserMessage", "FailedEIP", "OSExitCode", "ClrExitCode", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return FailFastUserMessage;
                case 1:
                    return FailedEIP;
                case 2:
                    return OSExitCode;
                case 3:
                    return ClrExitCode;
                case 4:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FailFastTraceData> Action;
        #endregion
    }

    public sealed class FinalizeObjectTraceData : TraceEvent
    {
        public Address TypeID { get { return GetAddressAt(0); } }
        public Address ObjectID { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int ClrInstanceID { get { return GetInt16At(HostOffset(8, 2)); } }
        public string TypeName { get { return GetUnicodeStringAt(HostOffset(10, 2)); } }

        #region Private
        internal FinalizeObjectTraceData(Action<FinalizeObjectTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FinalizeObjectTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(10, 2))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(10, 2))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "TypeID", TypeID);
            XmlAttribHex(sb, "ObjectID", ObjectID);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            XmlAttrib(sb, "TypeName", TypeName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeID", "ObjectID", "ClrInstanceID", "TypeName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeID;
                case 1:
                    return ObjectID;
                case 2:
                    return ClrInstanceID;
                case 3:
                    return TypeName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FinalizeObjectTraceData> Action;
        #endregion
    }
    public sealed class CCWRefCountChangeAnsiTraceData : TraceEvent
    {
        public Address HandleID { get { return GetAddressAt(0); } }
        public Address ObjectID { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address COMInterfacePointer { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int NewRefCount { get { return GetInt32At(HostOffset(12, 3)); } }
        public long AppDomainID { get { return GetInt64At(HostOffset(16, 3)); } }
        public string ClassName { get { return GetUTF8StringAt(HostOffset(24, 3)); } }
        public string NameSpace { get { return GetUTF8StringAt(SkipUTF8String(HostOffset(24, 3))); } }
        public string Operation { get { return GetUnicodeStringAt(SkipUTF8String(SkipUTF8String(HostOffset(24, 3)))); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUTF8String(SkipUTF8String(HostOffset(24, 3))))); } }

        #region Private
        internal CCWRefCountChangeAnsiTraceData(Action<CCWRefCountChangeAnsiTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<CCWRefCountChangeAnsiTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUTF8String(SkipUTF8String(HostOffset(24, 3)))) + 2));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUTF8String(SkipUTF8String(HostOffset(24, 3)))) + 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "HandleID", HandleID);
            XmlAttribHex(sb, "ObjectID", ObjectID);
            XmlAttribHex(sb, "COMInterfacePointer", COMInterfacePointer);
            XmlAttrib(sb, "NewRefCount", NewRefCount);
            XmlAttribHex(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "ClassName", ClassName);
            XmlAttrib(sb, "NameSpace", NameSpace);
            XmlAttrib(sb, "Operation", Operation);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HandleID", "ObjectID", "COMInterfacePointer", "NewRefCount", "AppDomainID", "ClassName", "NameSpace", "Operation", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HandleID;
                case 1:
                    return ObjectID;
                case 2:
                    return COMInterfacePointer;
                case 3:
                    return NewRefCount;
                case 4:
                    return AppDomainID;
                case 5:
                    return ClassName;
                case 6:
                    return NameSpace;
                case 7:
                    return Operation;
                case 8:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<CCWRefCountChangeAnsiTraceData> Action;
        #endregion
    }
    public sealed class CCWRefCountChangeTraceData : TraceEvent
    {
        public Address HandleID { get { return GetAddressAt(0); } }
        public Address ObjectID { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address COMInterfacePointer { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int NewRefCount { get { return GetInt32At(HostOffset(12, 3)); } }
        public long AppDomainID { get { return GetInt64At(HostOffset(16, 3)); } }
        public string ClassName { get { return GetUnicodeStringAt(HostOffset(24, 3)); } }
        public string NameSpace { get { return GetUnicodeStringAt(SkipUnicodeString(HostOffset(24, 3))); } }
        public string Operation { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(HostOffset(24, 3)))); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(HostOffset(24, 3))))); } }

        #region Private
        internal CCWRefCountChangeTraceData(Action<CCWRefCountChangeTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<CCWRefCountChangeTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(HostOffset(24, 3)))) + 2));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(HostOffset(24, 3)))) + 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "HandleID", HandleID);
            XmlAttribHex(sb, "ObjectID", ObjectID);
            XmlAttribHex(sb, "COMInterfacePointer", COMInterfacePointer);
            XmlAttrib(sb, "NewRefCount", NewRefCount);
            XmlAttribHex(sb, "AppDomainID", AppDomainID);
            XmlAttrib(sb, "ClassName", ClassName);
            XmlAttrib(sb, "NameSpace", NameSpace);
            XmlAttrib(sb, "Operation", Operation);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HandleID", "ObjectID", "COMInterfacePointer", "NewRefCount", "AppDomainID", "ClassName", "NameSpace", "Operation", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HandleID;
                case 1:
                    return ObjectID;
                case 2:
                    return COMInterfacePointer;
                case 3:
                    return NewRefCount;
                case 4:
                    return AppDomainID;
                case 5:
                    return ClassName;
                case 6:
                    return NameSpace;
                case 7:
                    return Operation;
                case 8:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<CCWRefCountChangeTraceData> Action;
        #endregion
    }

    public sealed class FusionMessageTraceData : TraceEvent
    {
        public int ClrInstanceID { get { return GetInt16At(0); } }
        public bool Prepend { get { return GetInt32At(2) != 0; } }
        public string Message { get { return GetUnicodeStringAt(6); } }

        #region Private
        internal FusionMessageTraceData(Action<FusionMessageTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FusionMessageTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(6)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(6)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            XmlAttrib(sb, "Prepend", Prepend);
            XmlAttrib(sb, "Message", Message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClrInstanceID", "Prepend", "Message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClrInstanceID;
                case 1:
                    return Prepend;
                case 2:
                    return Message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FusionMessageTraceData> Action;
        #endregion
    }

    public sealed class MulticoreJitPrivateTraceData : TraceEvent
    {
        public int ClrInstanceID { get { return GetInt16At(0); } }
        public string String1 { get { return GetUnicodeStringAt(2); } }
        public string String2 { get { return GetUnicodeStringAt(SkipUnicodeString(2)); } }
        public int Int1 { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(2))); } }
        public int Int2 { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(2)) + 4); } }
        public int Int3 { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(2)) + 8); } }

        #region Private
        internal MulticoreJitPrivateTraceData(Action<MulticoreJitPrivateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<MulticoreJitPrivateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(2)) + 12));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(2)) + 12));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            XmlAttrib(sb, "String1", String1);
            XmlAttrib(sb, "String2", String2);
            XmlAttrib(sb, "Int1", Int1);
            XmlAttrib(sb, "Int2", Int2);
            XmlAttrib(sb, "Int3", Int3);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClrInstanceID", "String1", "String2", "Int1", "Int2", "Int3" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClrInstanceID;
                case 1:
                    return String1;
                case 2:
                    return String2;
                case 3:
                    return Int1;
                case 4:
                    return Int2;
                case 5:
                    return Int3;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MulticoreJitPrivateTraceData> Action;
        #endregion
    }
    public sealed class MulticoreJitMethodCodeReturnedPrivateTraceData : TraceEvent
    {
        public int ClrInstanceID { get { return GetInt16At(0); } }
        public long ModuleID { get { return GetInt64At(2); } }
        public long MethodID { get { return GetInt64At(10); } }

        #region Private
        internal MulticoreJitMethodCodeReturnedPrivateTraceData(Action<MulticoreJitMethodCodeReturnedPrivateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<MulticoreJitMethodCodeReturnedPrivateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 18));
            Debug.Assert(!(Version > 0 && EventDataLength < 18));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            XmlAttrib(sb, "ModuleID", ModuleID);
            XmlAttrib(sb, "MethodID", MethodID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClrInstanceID", "ModuleID", "MethodID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClrInstanceID;
                case 1:
                    return ModuleID;
                case 2:
                    return MethodID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MulticoreJitMethodCodeReturnedPrivateTraceData> Action;
        #endregion
    }
    public sealed class LoaderHeapAllocRequestTraceData : TraceEvent
    {
        public Address LoaderHeapPtr { get { return GetAddressAt(0); } }
        public Address MemoryAddress { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int RequestSize { get { return GetInt32At(HostOffset(8, 2)); } }
        // Unused 4 byte quantity
        // Unused 8 byte quantity
        public int ClrInstanceID { get { return GetInt16At(HostOffset(24, 2)); } }

        #region Private
        internal LoaderHeapAllocRequestTraceData(Action<LoaderHeapAllocRequestTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<LoaderHeapAllocRequestTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(26, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(26, 2)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "LoaderHeapPtr", LoaderHeapPtr);
            XmlAttribHex(sb, "MemoryAddress", MemoryAddress);
            XmlAttrib(sb, "RequestSize", RequestSize);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LoaderHeapPtr", "MemoryAddress", "RequestSize", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LoaderHeapPtr;
                case 1:
                    return MemoryAddress;
                case 2:
                    return RequestSize;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<LoaderHeapAllocRequestTraceData> Action;
        #endregion
    }
    public sealed class DynamicTypeUsePrivateTraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(0)); } }

        #region Private
        internal DynamicTypeUsePrivateTraceData(Action<DynamicTypeUsePrivateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<DynamicTypeUsePrivateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 2));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<DynamicTypeUsePrivateTraceData> Action;
        #endregion
    }
    public sealed class DynamicTypeUseTwoParametersPrivateTraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string SecondTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal DynamicTypeUseTwoParametersPrivateTraceData(Action<DynamicTypeUseTwoParametersPrivateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<DynamicTypeUseTwoParametersPrivateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 2));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "SecondTypeName", SecondTypeName);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "SecondTypeName", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return SecondTypeName;
                case 2:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<DynamicTypeUseTwoParametersPrivateTraceData> Action;
        #endregion
    }
    public sealed class DynamicTypeUsePrivateVarianceTraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string InterfaceTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string VariantInterfaceTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal DynamicTypeUsePrivateVarianceTraceData(Action<DynamicTypeUsePrivateVarianceTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<DynamicTypeUsePrivateVarianceTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))) + 2));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))) + 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "InterfaceTypeName", InterfaceTypeName);
            XmlAttrib(sb, "VariantInterfaceTypeName", VariantInterfaceTypeName);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "InterfaceTypeName", "VariantInterfaceTypeName", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return InterfaceTypeName;
                case 2:
                    return VariantInterfaceTypeName;
                case 3:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<DynamicTypeUsePrivateVarianceTraceData> Action;
        #endregion
    }
    public sealed class DynamicTypeUseStringAndIntPrivateTraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public int Int1 { get { return GetInt32At(SkipUnicodeString(0)); } }
        public int ClrInstanceID { get { return GetInt16At(SkipUnicodeString(0) + 4); } }

        #region Private
        internal DynamicTypeUseStringAndIntPrivateTraceData(Action<DynamicTypeUseStringAndIntPrivateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<DynamicTypeUseStringAndIntPrivateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 6));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 6));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "Int1", Int1);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "Int1", "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return Int1;
                case 2:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<DynamicTypeUseStringAndIntPrivateTraceData> Action;
        #endregion
    }
    public sealed class DynamicTypeUseNoParametersPrivateTraceData : TraceEvent
    {
        public int ClrInstanceID { get { return GetInt16At(0); } }

        #region Private
        internal DynamicTypeUseNoParametersPrivateTraceData(Action<DynamicTypeUseNoParametersPrivateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<DynamicTypeUseNoParametersPrivateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 2));
            Debug.Assert(!(Version > 0 && EventDataLength < 2));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClrInstanceID", ClrInstanceID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClrInstanceID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClrInstanceID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<DynamicTypeUseNoParametersPrivateTraceData> Action;
        #endregion
    }
    [Flags]
    public enum ModuleRangeIBCType
    {
        None = 0,
        IBCUnprofiledSection = 0x1,
        IBCProfiledSection = 0x2,
    }
    [Flags]
    public enum ModuleRangeType
    {
        None = 0,
        HotRange = 0x1,
        WarmRange = 0x2,
        ColdRange = 0x4,
        HotColdSortedRange = 0x8,
    }
    // There are other reasons but these are the only reasons we care about 
    // for diagnostics purpose for now.
    public enum BGCAllocWaitReason
    {
        GetLOHSeg = 9,
        AllocDuringSweep = 10,
        AllocDuringBGC = 11,
    }
    public enum BGCPhase
    {
        BGC1stNonConcurrent = 0,
        BGC1stConcurrent = 1,
        BGC2ndNonConcurrent = 2,
        BGC2ndConcurrent = 3,
    }
    public enum ModuleRangeSectionType
    {
        ModuleSection = 0x1,
        EETableSection = 0x2,
        WriteDataSection = 0x3,
        WriteableDataSection = 0x4,
        DataSection = 0x5,
        RVAStaticsSection = 0x6,
        EEDataSection = 0x7,
        DelayLoadInfoTableEagerSection = 0x8,
        DelayLoadInfoTableSection = 0x9,
        EEReadonlyData = 0xA,
        ReadonlyData = 0xB,
        ClassSection = 0xC,
        CrossDomainInfoSection = 0xD,
        MethodDescSection = 0xE,
        MethodDescWriteableSection = 0xF,
        ExceptionSection = 0x10,
        InstrumentSection = 0x11,
        VirtualImportThunkSection = 0x12,
        ExternalMethodThunkSection = 0x13,
        HelperTableSection = 0x14,
        MethodPrecodeWriteableSection = 0x15,
        MethodPrecodeWriteSection = 0x16,
        MethodPrecodeSection = 0x17,
        Win32ResourcesSection = 0x18,
        HeaderSection = 0x19,
        MetadataSection = 0x1A,
        DelayLoadInfoSection = 0x1B,
        ImportTableSection = 0x1C,
        CodeSection = 0x1D,
        CodeHeaderSection = 0x1E,
        CodeManagerSection = 0x1F,
        UnwindDataSection = 0x20,
        RuntimeFunctionSection = 0x21,
        StubsSection = 0x22,
        StubDispatchDataSection = 0x23,
        ExternalMethodDataSection = 0x24,
        DelayLoadInfoDelayListSection = 0x25,
        ReadonlySharedSection = 0x26,
        ReadonlySection = 0x27,
        ILSection = 0x28,
        GCInfoSection = 0x29,
        ILMetadataSection = 0x2A,
        ResourcesSection = 0x2B,
        CompressedMapsSection = 0x2C,
        DebugSection = 0x2D,
        BaseRelocsSection = 0x2E,
    }
}
