using Microsoft.Diagnostics.Tracing.Parsers.ApplicationServer;
using System;
using System.Diagnostics;
using System.Text;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "1.0")]
    public sealed class ApplicationServerTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "Microsoft-Windows-Application Server-Applications";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0xc651f5f6), unchecked((short)0x1c0d), unchecked((short)0x492e), 0x8a, 0xe1, 0xb4, 0xef, 0xd7, 0xc9, 0xd5, 0x03);
        public enum Keywords : long
        {
            ServiceHost = 0x1,
            Serialization = 0x2,
            ServiceModel = 0x4,
            Transaction = 0x8,
            Security = 0x10,
            WCFMessageLogging = 0x20,
            WFTracking = 0x40,
            WebHost = 0x80,
            HTTPTransport = 0x100,
            TCPTransport = 0x200,
            TransportGeneral = 0x400,
            ActivationServices = 0x800,
            Channel = 0x1000,
            WebHTTP = 0x2000,
            Discovery = 0x4000,
            RoutingServices = 0x8000,
            Infrastructure = 0x10000,
            EndtoEndMonitoring = 0x20000,
            HealthMonitoring = 0x40000,
            Troubleshooting = 0x80000,
            UserEvents = 0x100000,
            Threading = 0x200000,
            Quota = 0x400000,
            WorkflowRuntime = 0x1000000,
            WorkflowActivities = 0x2000000,
            WorkflowServiceHost = 0x4000000,
            WorkflowInstanceStore = 0x8000000,
        };

        public ApplicationServerTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<Multidata9TemplateHATraceData> WorkflowInstanceRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata9TemplateHATraceData(value, 100, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 100, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata10TemplateHATraceData> WorkflowInstanceUnhandledExceptionRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata10TemplateHATraceData(value, 101, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 150, "UnhandledExceptionRecord", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 101, ProviderGuid);
                source.UnregisterEventTemplate(value, 150, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata8TemplateHATraceData> WorkflowInstanceAbortedRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata8TemplateHATraceData(value, 102, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 144, "AbortedRecord", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 102, ProviderGuid);
                source.UnregisterEventTemplate(value, 144, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata4TemplateHATraceData> ActivityStateRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata4TemplateHATraceData(value, 103, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 103, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WorkflowTrackingTaskGuid);
            }
        }
        public event Action<Multidata3TemplateHATraceData> ActivityScheduledRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata3TemplateHATraceData(value, 104, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 104, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WorkflowTrackingTaskGuid);
            }
        }
        public event Action<Multidata6TemplateHATraceData> FaultPropagationRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata6TemplateHATraceData(value, 105, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 105, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WorkflowTrackingTaskGuid);
            }
        }
        public event Action<Multidata3TemplateHATraceData> CancelRequestedRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata3TemplateHATraceData(value, 106, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 106, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WorkflowTrackingTaskGuid);
            }
        }
        public event Action<Multidata5TemplateHATraceData> BookmarkResumptionRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata5TemplateHATraceData(value, 107, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 107, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WorkflowTrackingTaskGuid);
            }
        }
        public event Action<Multidata7TemplateHATraceData> CustomTrackingRecordInfo
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata7TemplateHATraceData(value, 108, 2527, "CustomTrackingRecord", CustomTrackingRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 108, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CustomTrackingRecordTaskGuid);
            }
        }
        public event Action<Multidata7TemplateHATraceData> CustomTrackingRecordWarning
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata7TemplateHATraceData(value, 110, 2527, "CustomTrackingRecord", CustomTrackingRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 110, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CustomTrackingRecordTaskGuid);
            }
        }
        public event Action<Multidata7TemplateHATraceData> CustomTrackingRecordError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata7TemplateHATraceData(value, 111, 2527, "CustomTrackingRecord", CustomTrackingRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 111, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CustomTrackingRecordTaskGuid);
            }
        }
        public event Action<Multidata8TemplateHATraceData> WorkflowInstanceSuspendedRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata8TemplateHATraceData(value, 112, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 146, "SuspendedRecord", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 112, ProviderGuid);
                source.UnregisterEventTemplate(value, 146, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata8TemplateHATraceData> WorkflowInstanceTerminatedRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata8TemplateHATraceData(value, 113, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 148, "TerminatedRecord", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 113, ProviderGuid);
                source.UnregisterEventTemplate(value, 148, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata11TemplateHATraceData> WorkflowInstanceRecordWithId
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata11TemplateHATraceData(value, 114, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 114, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata12TemplateHATraceData> WorkflowInstanceAbortedRecordWithId
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata12TemplateHATraceData(value, 115, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 145, "AbortedWithId", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 115, ProviderGuid);
                source.UnregisterEventTemplate(value, 145, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata12TemplateHATraceData> WorkflowInstanceSuspendedRecordWithId
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata12TemplateHATraceData(value, 116, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 147, "SuspendedWithId", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 116, ProviderGuid);
                source.UnregisterEventTemplate(value, 147, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata12TemplateHATraceData> WorkflowInstanceTerminatedRecordWithId
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata12TemplateHATraceData(value, 117, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 149, "TerminatedWithId", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 117, ProviderGuid);
                source.UnregisterEventTemplate(value, 149, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata13TemplateHATraceData> WorkflowInstanceUnhandledExceptionRecordWithId
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata13TemplateHATraceData(value, 118, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 151, "UnhandledExceptionWithId", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 118, ProviderGuid);
                source.UnregisterEventTemplate(value, 151, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata14TemplateHATraceData> WorkflowInstanceUpdatedRecord
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata14TemplateHATraceData(value, 119, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 152, "UpdatedRecord", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 119, ProviderGuid);
                source.UnregisterEventTemplate(value, 152, WorkflowInstanceRecordTaskGuid);
            }
        }
        public event Action<Multidata1TemplateATraceData> BufferPoolAllocation
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata1TemplateATraceData(value, 131, 2509, "BufferPooling", BufferPoolingTaskGuid, 12, "Allocate", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 131, ProviderGuid);
                source.UnregisterEventTemplate(value, 12, BufferPoolingTaskGuid);
            }
        }
        public event Action<Multidata2TemplateATraceData> BufferPoolChangeQuota
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata2TemplateATraceData(value, 132, 2509, "BufferPooling", BufferPoolingTaskGuid, 13, "Tune", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 132, ProviderGuid);
                source.UnregisterEventTemplate(value, 13, BufferPoolingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ActionItemScheduled
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 133, 2593, "ThreadScheduling", ThreadSchedulingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 133, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ThreadSchedulingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ActionItemCallbackInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 134, 2593, "ThreadScheduling", ThreadSchedulingTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 134, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ThreadSchedulingTaskGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> ClientMessageInspectorAfterReceiveInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 201, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 16, "ClientMessageInspectorAfterReceiveInvoked", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 201, ProviderGuid);
                source.UnregisterEventTemplate(value, 16, ClientRuntimeTaskGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> ClientMessageInspectorBeforeSendInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 202, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 17, "ClientMessageInspectorBeforeSendInvoked", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 202, ProviderGuid);
                source.UnregisterEventTemplate(value, 17, ClientRuntimeTaskGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> ClientParameterInspectorAfterCallInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 203, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 19, "ClientParameterInspectorStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 203, ProviderGuid);
                source.UnregisterEventTemplate(value, 19, ClientRuntimeTaskGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> ClientParameterInspectorBeforeCallInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 204, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 18, "ClientParameterInspectorStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 204, ProviderGuid);
                source.UnregisterEventTemplate(value, 18, ClientRuntimeTaskGuid);
            }
        }
        public event Action<Multidata24TemplateHATraceData> OperationInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata24TemplateHATraceData(value, 205, 2533, "DispatchMessage", DispatchMessageTaskGuid, 53, "OperationInvokerStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 205, ProviderGuid);
                source.UnregisterEventTemplate(value, 53, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata25TemplateHATraceData> ErrorHandlerInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata25TemplateHATraceData(value, 206, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 206, ProviderGuid);
            }
        }
        public event Action<Multidata26TemplateHATraceData> FaultProviderInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata26TemplateHATraceData(value, 207, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 207, ProviderGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> MessageInspectorAfterReceiveInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 208, 2533, "DispatchMessage", DispatchMessageTaskGuid, 51, "DispathMessageInspectorAfterReceiveInvoked", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 208, ProviderGuid);
                source.UnregisterEventTemplate(value, 51, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> MessageInspectorBeforeSendInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 209, 2533, "DispatchMessage", DispatchMessageTaskGuid, 52, "DispathMessageInspectorBeforeSendInvoked", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 209, ProviderGuid);
                source.UnregisterEventTemplate(value, 52, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata27TemplateHATraceData> MessageThrottleExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata27TemplateHATraceData(value, 210, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 210, ProviderGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> ParameterInspectorAfterCallInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 211, 2533, "DispatchMessage", DispatchMessageTaskGuid, 56, "ParameterInspectorStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 211, ProviderGuid);
                source.UnregisterEventTemplate(value, 56, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata23TemplateHATraceData> ParameterInspectorBeforeCallInvoked
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata23TemplateHATraceData(value, 212, 2533, "DispatchMessage", DispatchMessageTaskGuid, 55, "ParameterInspectorStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 212, ProviderGuid);
                source.UnregisterEventTemplate(value, 55, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata72TemplateHATraceData> ServiceHostStarted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata72TemplateHATraceData(value, 213, 2578, "ServiceHostActivation", ServiceHostActivationTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 213, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceHostActivationTaskGuid);
            }
        }
        public event Action<Multidata28TemplateHATraceData> OperationCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata28TemplateHATraceData(value, 214, 2533, "DispatchMessage", DispatchMessageTaskGuid, 54, "OperationInvokerStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 214, ProviderGuid);
                source.UnregisterEventTemplate(value, 54, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata29TemplateHATraceData> MessageReceivedByTransport
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata29TemplateHATraceData(value, 215, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 215, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportReceiveTaskGuid);
            }
        }
        public event Action<Multidata30TemplateHATraceData> MessageSentByTransport
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata30TemplateHATraceData(value, 216, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 216, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportSendTaskGuid);
            }
        }
        public event Action<Multidata22TemplateHATraceData> ClientOperationPrepared
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata22TemplateHATraceData(value, 217, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 20, "OperationPrepared", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 217, ProviderGuid);
                source.UnregisterEventTemplate(value, 20, ClientRuntimeTaskGuid);
            }
        }
        public event Action<Multidata22TemplateHATraceData> ServiceChannelCallStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata22TemplateHATraceData(value, 218, 2576, "ServiceChannelCall", ServiceChannelCallTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 218, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceChannelCallTaskGuid);
            }
        }
        public event Action<Multidata31TemplateHATraceData> ServiceException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata31TemplateHATraceData(value, 219, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 219, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata32TemplateHATraceData> MessageSentToTransport
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata32TemplateHATraceData(value, 220, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 220, ProviderGuid);
            }
        }
        public event Action<Multidata32TemplateHATraceData> MessageReceivedFromTransport
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata32TemplateHATraceData(value, 221, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 221, ProviderGuid);
            }
        }
        public event Action<Multidata28TemplateHATraceData> OperationFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata28TemplateHATraceData(value, 222, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 222, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata28TemplateHATraceData> OperationFaulted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata28TemplateHATraceData(value, 223, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 223, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata27TemplateHATraceData> MessageThrottleAtSeventyPercent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata27TemplateHATraceData(value, 224, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 224, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata86TemplateHATraceData> TraceCorrelationKeys
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata86TemplateHATraceData(value, 225, 2523, "Correlation", CorrelationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 225, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CorrelationTaskGuid);
            }
        }
        public event Action<Multidata73TemplateATraceData> IdleServicesClosed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata73TemplateATraceData(value, 226, 2585, "ServiceShutdown", ServiceShutdownTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 226, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ServiceShutdownTaskGuid);
            }
        }
        public event Action<UserEventsTemplateTraceData> UserDefinedErrorOccurred
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new UserEventsTemplateTraceData(value, 301, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 301, ProviderGuid);
            }
        }
        public event Action<UserEventsTemplateTraceData> UserDefinedWarningOccurred
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new UserEventsTemplateTraceData(value, 302, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 302, ProviderGuid);
            }
        }
        public event Action<UserEventsTemplateTraceData> UserDefinedInformationEventOccured
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new UserEventsTemplateTraceData(value, 303, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 303, ProviderGuid);
            }
        }
        public event Action<TwoStringsTemplateTATraceData> StopSignpostEvent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateTATraceData(value, 401, 2588, "Signpost", SignpostTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 401, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, SignpostTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateTATraceData> StartSignpostEvent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateTATraceData(value, 402, 2588, "Signpost", SignpostTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 402, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SignpostTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateTATraceData> SuspendSignpostEvent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateTATraceData(value, 403, 2588, "Signpost", SignpostTaskGuid, 8, "Suspend", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 403, ProviderGuid);
                source.UnregisterEventTemplate(value, 8, SignpostTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateTATraceData> ResumeSignpostEvent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateTATraceData(value, 404, 2588, "Signpost", SignpostTaskGuid, 7, "Resume", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 404, ProviderGuid);
                source.UnregisterEventTemplate(value, 7, SignpostTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateTATraceData> StartSignpostEvent1
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateTATraceData(value, 440, 2588, "Signpost", SignpostTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 440, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SignpostTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateTATraceData> StopSignpostEvent1
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateTATraceData(value, 441, 2588, "Signpost", SignpostTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 441, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, SignpostTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MessageLogInfo
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 451, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 451, ProviderGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MessageLogWarning
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 452, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 452, ProviderGuid);
            }
        }
        public event Action<TransferEmittedTemplateTraceData> TransferEmitted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TransferEmittedTemplateTraceData(value, 499, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 499, ProviderGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> CompilationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 501, 2579, "ServiceHostCompilation", ServiceHostCompilationTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 501, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceHostCompilationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> CompilationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 502, 2579, "ServiceHostCompilation", ServiceHostCompilationTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 502, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceHostCompilationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceHostFactoryCreationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 503, 2581, "ServiceHostFactoryCreation", ServiceHostFactoryCreationTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 503, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceHostFactoryCreationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceHostFactoryCreationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 504, 2581, "ServiceHostFactoryCreation", ServiceHostFactoryCreationTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 504, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceHostFactoryCreationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> CreateServiceHostStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 505, 2580, "ServiceHostCreate", ServiceHostCreateTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 505, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceHostCreateTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> CreateServiceHostStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 506, 2580, "ServiceHostCreate", ServiceHostCreateTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 506, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceHostCreateTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HostedTransportConfigurationManagerConfigInitStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 507, 2546, "HostedTransportConfigurationManagerConfigInit", HostedTransportConfigurationManagerConfigInitTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 507, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, HostedTransportConfigurationManagerConfigInitTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HostedTransportConfigurationManagerConfigInitStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 508, 2546, "HostedTransportConfigurationManagerConfigInit", HostedTransportConfigurationManagerConfigInitTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 508, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, HostedTransportConfigurationManagerConfigInitTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceHostOpenStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 509, 2583, "ServiceHostOpen", ServiceHostOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 509, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceHostOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceHostOpenStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 510, 2583, "ServiceHostOpen", ServiceHostOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 510, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceHostOpenTaskGuid);
            }
        }
        public event Action<Multidata69TemplateATraceData> WebHostRequestStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata69TemplateATraceData(value, 513, 2604, "WebHostRequest", WebHostRequestTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 513, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, WebHostRequestTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WebHostRequestStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 514, 2604, "WebHostRequest", WebHostRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 514, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, WebHostRequestTaskGuid);
            }
        }
        public event Action<Multidata74TemplateATraceData> CBAEntryRead
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata74TemplateATraceData(value, 601, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 601, ProviderGuid);
            }
        }
        public event Action<Multidata70TemplateATraceData> CBAMatchFound
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata70TemplateATraceData(value, 602, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 602, ProviderGuid);
            }
        }
        public event Action<Multidata70TemplateATraceData> AspNetRoutingService
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata70TemplateATraceData(value, 603, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 603, ProviderGuid);
            }
        }
        public event Action<Multidata71TemplateATraceData> AspNetRoute
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata71TemplateATraceData(value, 604, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 604, ProviderGuid);
            }
        }
        public event Action<Multidata75TemplateATraceData> IncrementBusyCount
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata75TemplateATraceData(value, 605, 2604, "WebHostRequest", WebHostRequestTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 605, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WebHostRequestTaskGuid);
            }
        }
        public event Action<Multidata75TemplateATraceData> DecrementBusyCount
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata75TemplateATraceData(value, 606, 2604, "WebHostRequest", WebHostRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 606, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, WebHostRequestTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceChannelOpenStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 701, 2577, "ServiceChannelOpen", ServiceChannelOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 701, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceChannelOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceChannelOpenStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 702, 2577, "ServiceChannelOpen", ServiceChannelOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 702, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceChannelOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceChannelCallStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 703, 2576, "ServiceChannelCall", ServiceChannelCallTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 703, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceChannelCallTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceChannelBeginCallStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 704, 2576, "ServiceChannelCall", ServiceChannelCallTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 704, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceChannelCallTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpSendMessageStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 706, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 706, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpSendStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 707, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 707, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportSendTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpMessageReceiveStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 708, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 708, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportReceiveTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> DispatchMessageStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 709, 2533, "DispatchMessage", DispatchMessageTaskGuid, 49, "DispatchStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 709, ProviderGuid);
                source.UnregisterEventTemplate(value, 49, DispatchMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpContextBeforeProcessAuthentication
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 710, 2599, "TransportReceive", TransportReceiveTaskGuid, 128, "BeforeAuthentication", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 710, ProviderGuid);
                source.UnregisterEventTemplate(value, 128, TransportReceiveTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchMessageBeforeAuthorization
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 711, 2533, "DispatchMessage", DispatchMessageTaskGuid, 48, "BeforeAuthorization", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 711, ProviderGuid);
                source.UnregisterEventTemplate(value, 48, DispatchMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchMessageStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 712, 2533, "DispatchMessage", DispatchMessageTaskGuid, 50, "DispatchStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 712, ProviderGuid);
                source.UnregisterEventTemplate(value, 50, DispatchMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientChannelOpenStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 715, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 14, "ClientChannelOpenStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 715, ProviderGuid);
                source.UnregisterEventTemplate(value, 14, ClientRuntimeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientChannelOpenStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 716, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 15, "ClientChannelOpenStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 716, ProviderGuid);
                source.UnregisterEventTemplate(value, 15, ClientRuntimeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpSendStreamedMessageStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 717, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 717, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> WorkflowApplicationCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1001, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 134, "Completed", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1001, ProviderGuid);
                source.UnregisterEventTemplate(value, 134, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> WorkflowApplicationTerminated
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 1002, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 140, "Terminated", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1002, ProviderGuid);
                source.UnregisterEventTemplate(value, 140, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> WorkflowInstanceCanceled
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1003, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 137, "InstanceCanceled", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1003, ProviderGuid);
                source.UnregisterEventTemplate(value, 137, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> WorkflowInstanceAborted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 1004, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 136, "InstanceAborted", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1004, ProviderGuid);
                source.UnregisterEventTemplate(value, 136, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> WorkflowApplicationIdled
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1005, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 135, "Idled", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1005, ProviderGuid);
                source.UnregisterEventTemplate(value, 135, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<SixStringsTemplateEATraceData> WorkflowApplicationUnhandledException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SixStringsTemplateEATraceData(value, 1006, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 141, "UnhandledException", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1006, ProviderGuid);
                source.UnregisterEventTemplate(value, 141, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> WorkflowApplicationPersisted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1007, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 139, "Persisted", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1007, ProviderGuid);
                source.UnregisterEventTemplate(value, 139, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> WorkflowApplicationUnloaded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1008, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 142, "Unloaded", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1008, ProviderGuid);
                source.UnregisterEventTemplate(value, 142, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<SevenStringsTemplateATraceData> ActivityScheduled
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SevenStringsTemplateATraceData(value, 1009, 2569, "ScheduleActivity", ScheduleActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1009, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ScheduleActivityTaskGuid);
            }
        }
        public event Action<FiveStringsTemplateATraceData> ActivityCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FiveStringsTemplateATraceData(value, 1010, 2517, "CompleteActivity", CompleteActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1010, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CompleteActivityTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> ScheduleExecuteActivityWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1011, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 110, "ScheduleExecuteActivity", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1011, ProviderGuid);
                source.UnregisterEventTemplate(value, 110, ScheduleWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> StartExecuteActivityWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1012, 2590, "StartWorkItem", StartWorkItemTaskGuid, 120, "StartExecuteActivity", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1012, ProviderGuid);
                source.UnregisterEventTemplate(value, 120, StartWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> CompleteExecuteActivityWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1013, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 24, "CompleteExecuteActivity", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1013, ProviderGuid);
                source.UnregisterEventTemplate(value, 24, CompleteWorkItemTaskGuid);
            }
        }
        public event Action<SevenStringsTemplateATraceData> ScheduleCompletionWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SevenStringsTemplateATraceData(value, 1014, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 109, "ScheduleCompletion", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1014, ProviderGuid);
                source.UnregisterEventTemplate(value, 109, ScheduleWorkItemTaskGuid);
            }
        }
        public event Action<SevenStringsTemplateATraceData> StartCompletionWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SevenStringsTemplateATraceData(value, 1015, 2590, "StartWorkItem", StartWorkItemTaskGuid, 119, "StartCompletion", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1015, ProviderGuid);
                source.UnregisterEventTemplate(value, 119, StartWorkItemTaskGuid);
            }
        }
        public event Action<SevenStringsTemplateATraceData> CompleteCompletionWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SevenStringsTemplateATraceData(value, 1016, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 23, "CompleteCompletion", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1016, ProviderGuid);
                source.UnregisterEventTemplate(value, 23, CompleteWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> ScheduleCancelActivityWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1017, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 108, "ScheduleCancelActivity", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1017, ProviderGuid);
                source.UnregisterEventTemplate(value, 108, ScheduleWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> StartCancelActivityWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1018, 2590, "StartWorkItem", StartWorkItemTaskGuid, 118, "StartCancelActivity", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1018, ProviderGuid);
                source.UnregisterEventTemplate(value, 118, StartWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> CompleteCancelActivityWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1019, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 22, "CompleteCancelActivity", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1019, ProviderGuid);
                source.UnregisterEventTemplate(value, 22, CompleteWorkItemTaskGuid);
            }
        }
        public event Action<SixStringsTemplateATraceData> CreateBookmark
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SixStringsTemplateATraceData(value, 1020, 2524, "CreateBookmark", CreateBookmarkTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1020, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CreateBookmarkTaskGuid);
            }
        }
        public event Action<SixStringsTemplateATraceData> ScheduleBookmarkWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SixStringsTemplateATraceData(value, 1021, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 107, "ScheduleBookmark", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1021, ProviderGuid);
                source.UnregisterEventTemplate(value, 107, ScheduleWorkItemTaskGuid);
            }
        }
        public event Action<SixStringsTemplateATraceData> StartBookmarkWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SixStringsTemplateATraceData(value, 1022, 2590, "StartWorkItem", StartWorkItemTaskGuid, 117, "StartBookmark", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1022, ProviderGuid);
                source.UnregisterEventTemplate(value, 117, StartWorkItemTaskGuid);
            }
        }
        public event Action<SixStringsTemplateATraceData> CompleteBookmarkWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SixStringsTemplateATraceData(value, 1023, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 21, "CompleteBookmark", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1023, ProviderGuid);
                source.UnregisterEventTemplate(value, 21, CompleteWorkItemTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> CreateBookmarkScope
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1024, 2524, "CreateBookmark", CreateBookmarkTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1024, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CreateBookmarkTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> BookmarkScopeInitialized
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 1025, 2549, "InitializeBookmarkScope", InitializeBookmarkScopeTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1025, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, InitializeBookmarkScopeTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> ScheduleTransactionContextWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1026, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 113, "ScheduleTransactionContext", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1026, ProviderGuid);
                source.UnregisterEventTemplate(value, 113, ScheduleWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> StartTransactionContextWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1027, 2590, "StartWorkItem", StartWorkItemTaskGuid, 123, "StartTransactionContext", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1027, ProviderGuid);
                source.UnregisterEventTemplate(value, 123, StartWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> CompleteTransactionContextWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1028, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 27, "CompleteTransactionContext", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1028, ProviderGuid);
                source.UnregisterEventTemplate(value, 27, CompleteWorkItemTaskGuid);
            }
        }
        public event Action<EightStringsTemplateEATraceData> ScheduleFaultWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EightStringsTemplateEATraceData(value, 1029, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 111, "ScheduleFault", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1029, ProviderGuid);
                source.UnregisterEventTemplate(value, 111, ScheduleWorkItemTaskGuid);
            }
        }
        public event Action<EightStringsTemplateEATraceData> StartFaultWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EightStringsTemplateEATraceData(value, 1030, 2590, "StartWorkItem", StartWorkItemTaskGuid, 121, "StartFault", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1030, ProviderGuid);
                source.UnregisterEventTemplate(value, 121, StartWorkItemTaskGuid);
            }
        }
        public event Action<EightStringsTemplateEATraceData> CompleteFaultWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EightStringsTemplateEATraceData(value, 1031, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 25, "CompleteFault", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1031, ProviderGuid);
                source.UnregisterEventTemplate(value, 25, CompleteWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> ScheduleRuntimeWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1032, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 112, "ScheduleRuntime", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1032, ProviderGuid);
                source.UnregisterEventTemplate(value, 112, ScheduleWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> StartRuntimeWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1033, 2590, "StartWorkItem", StartWorkItemTaskGuid, 122, "StartRuntime", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1033, ProviderGuid);
                source.UnregisterEventTemplate(value, 122, StartWorkItemTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> CompleteRuntimeWorkItem
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1034, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 26, "CompleteRuntime", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1034, ProviderGuid);
                source.UnregisterEventTemplate(value, 26, CompleteWorkItemTaskGuid);
            }
        }
        public event Action<SevenStringsTemplateATraceData> RuntimeTransactionSet
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SevenStringsTemplateATraceData(value, 1035, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 106, "Set", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1035, ProviderGuid);
                source.UnregisterEventTemplate(value, 106, RuntimeTransactionTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> RuntimeTransactionCompletionRequested
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1036, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 105, "CompletionRequested", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1036, ProviderGuid);
                source.UnregisterEventTemplate(value, 105, RuntimeTransactionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RuntimeTransactionComplete
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1037, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 104, "Complete", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1037, ProviderGuid);
                source.UnregisterEventTemplate(value, 104, RuntimeTransactionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> EnterNoPersistBlock
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 1038, 2559, "NoPersistBlock", NoPersistBlockTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1038, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, NoPersistBlockTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ExitNoPersistBlock
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 1039, 2559, "NoPersistBlock", NoPersistBlockTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1039, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, NoPersistBlockTaskGuid);
            }
        }
        public event Action<SixStringsTemplateATraceData> InArgumentBound
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SixStringsTemplateATraceData(value, 1040, 2535, "ExecuteActivity", ExecuteActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1040, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ExecuteActivityTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> WorkflowApplicationPersistableIdle
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 1041, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 138, "PersistableIdle", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1041, ProviderGuid);
                source.UnregisterEventTemplate(value, 138, WFApplicationStateChangeTaskGuid);
            }
        }
        public event Action<Multidata17TemplateATraceData> WorkflowActivityStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata17TemplateATraceData(value, 1101, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1101, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, WorkflowActivityTaskGuid);
            }
        }
        public event Action<Multidata17TemplateATraceData> WorkflowActivityStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata17TemplateATraceData(value, 1102, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1102, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, WorkflowActivityTaskGuid);
            }
        }
        public event Action<Multidata17TemplateATraceData> WorkflowActivitySuspend
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata17TemplateATraceData(value, 1103, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 8, "Suspend", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1103, ProviderGuid);
                source.UnregisterEventTemplate(value, 8, WorkflowActivityTaskGuid);
            }
        }
        public event Action<Multidata17TemplateATraceData> WorkflowActivityResume
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata17TemplateATraceData(value, 1104, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 7, "Resume", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1104, ProviderGuid);
                source.UnregisterEventTemplate(value, 7, WorkflowActivityTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> InvokeMethodIsStatic
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1124, 2551, "InvokeMethod", InvokeMethodTaskGuid, 73, "IsStatic", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1124, ProviderGuid);
                source.UnregisterEventTemplate(value, 73, InvokeMethodTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> InvokeMethodIsNotStatic
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1125, 2551, "InvokeMethod", InvokeMethodTaskGuid, 72, "IsNotStatic", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1125, ProviderGuid);
                source.UnregisterEventTemplate(value, 72, InvokeMethodTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> InvokedMethodThrewException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 1126, 2551, "InvokeMethod", InvokeMethodTaskGuid, 74, "ThrewException", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1126, ProviderGuid);
                source.UnregisterEventTemplate(value, 74, InvokeMethodTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> InvokeMethodUseAsyncPattern
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 1131, 2551, "InvokeMethod", InvokeMethodTaskGuid, 75, "UseAsyncPattern", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1131, ProviderGuid);
                source.UnregisterEventTemplate(value, 75, InvokeMethodTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> InvokeMethodDoesNotUseAsyncPattern
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1132, 2551, "InvokeMethod", InvokeMethodTaskGuid, 71, "DoesNotUseAsyncPattern", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1132, ProviderGuid);
                source.UnregisterEventTemplate(value, 71, InvokeMethodTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> FlowchartStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1140, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 11, "Begin", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1140, ProviderGuid);
                source.UnregisterEventTemplate(value, 11, ExecuteFlowchartTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> FlowchartEmpty
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1141, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 60, "Empty", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1141, ProviderGuid);
                source.UnregisterEventTemplate(value, 60, ExecuteFlowchartTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> FlowchartNextNull
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1143, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 61, "NextNull", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1143, ProviderGuid);
                source.UnregisterEventTemplate(value, 61, ExecuteFlowchartTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> FlowchartSwitchCase
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 1146, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 62, "SwitchCase", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1146, ProviderGuid);
                source.UnregisterEventTemplate(value, 62, ExecuteFlowchartTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> FlowchartSwitchDefault
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1147, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 64, "SwitchDefault", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1147, ProviderGuid);
                source.UnregisterEventTemplate(value, 64, ExecuteFlowchartTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> FlowchartSwitchCaseNotFound
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1148, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 63, "SwitchCaseNotFound", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1148, ProviderGuid);
                source.UnregisterEventTemplate(value, 63, ExecuteFlowchartTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> CompensationState
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 1150, 2516, "CompensationState", CompensationStateTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1150, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, CompensationStateTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> SwitchCaseNotFound
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1223, 2535, "ExecuteActivity", ExecuteActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1223, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ExecuteActivityTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> ChannelInitializationTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1400, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1400, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> CloseTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1401, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1401, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<Multidata56TemplateATraceData> IdleTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata56TemplateATraceData(value, 1402, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1402, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<Multidata56TemplateATraceData> LeaseTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata56TemplateATraceData(value, 1403, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1403, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> OpenTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1405, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1405, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> ReceiveTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1406, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1406, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> SendTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1407, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1407, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> InactivityTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1409, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1409, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MaxReceivedMessageSizeExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1416, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1416, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MaxSentMessageSizeExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1417, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1417, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MaxOutboundConnectionsPerEndpointExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1418, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1418, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MaxPendingConnectionsExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1419, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1419, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> ReaderQuotaExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1420, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1420, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata57TemplateATraceData> NegotiateTokenAuthenticatorStateCacheExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata57TemplateATraceData(value, 1422, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1422, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> NegotiateTokenAuthenticatorStateCacheRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1423, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1423, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> SecuritySessionRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1424, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1424, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> PendingConnectionsRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1430, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1430, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> ConcurrentCallsRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1431, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1431, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> ConcurrentSessionsRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1432, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1432, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> OutboundConnectionsPerEndpointRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1433, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1433, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> PendingMessagesPerChannelRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1436, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1436, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata58TemplateATraceData> ConcurrentInstancesRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata58TemplateATraceData(value, 1438, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1438, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> PendingAcceptsAtZero
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 1439, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1439, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MaxSessionSizeReached
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1441, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1441, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> ReceiveRetryCountReached
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1442, 2558, "MsmqQuotas", MsmqQuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1442, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, MsmqQuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MaxRetryCyclesExceededMsmq
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1443, 2558, "MsmqQuotas", MsmqQuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1443, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, MsmqQuotasTaskGuid);
            }
        }
        public event Action<Multidata59TemplateATraceData> ReadPoolMiss
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata59TemplateATraceData(value, 1445, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1445, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata59TemplateATraceData> WritePoolMiss
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata59TemplateATraceData(value, 1446, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1446, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WfMessageReceived
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 1449, 2606, "WFMessage", WFMessageTaskGuid, 240, "Receive", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1449, ProviderGuid);
                source.UnregisterEventTemplate(value, 240, WFMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WfMessageSent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 1450, 2606, "WFMessage", WFMessageTaskGuid, 9, "Send", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1450, ProviderGuid);
                source.UnregisterEventTemplate(value, 9, WFMessageTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> MaxRetryCyclesExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 1451, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1451, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ExecuteWorkItemStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 2021, 2537, "ExecuteWorkItem", ExecuteWorkItemTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2021, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ExecuteWorkItemTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ExecuteWorkItemStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 2022, 2537, "ExecuteWorkItem", ExecuteWorkItemTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2022, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ExecuteWorkItemTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SendMessageChannelCacheMiss
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 2023, 2554, "MessageChannelCache", MessageChannelCacheTaskGuid, 76, "Missed", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2023, ProviderGuid);
                source.UnregisterEventTemplate(value, 76, MessageChannelCacheTaskGuid);
            }
        }
        public event Action<Multidata19TemplateATraceData> InternalCacheMetadataStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata19TemplateATraceData(value, 2024, 2550, "InternalCacheMetadata", InternalCacheMetadataTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2024, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, InternalCacheMetadataTaskGuid);
            }
        }
        public event Action<Multidata19TemplateATraceData> InternalCacheMetadataStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata19TemplateATraceData(value, 2025, 2550, "InternalCacheMetadata", InternalCacheMetadataTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2025, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, InternalCacheMetadataTaskGuid);
            }
        }
        public event Action<Multidata20TemplateATraceData> CompileVbExpressionStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata20TemplateATraceData(value, 2026, 2602, "VBExpressionCompile", VBExpressionCompileTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2026, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, VBExpressionCompileTaskGuid);
            }
        }
        public event Action<Multidata21TemplateATraceData> CacheRootMetadataStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata21TemplateATraceData(value, 2027, 2510, "CacheRootMetadata", CacheRootMetadataTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2027, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, CacheRootMetadataTaskGuid);
            }
        }
        public event Action<Multidata21TemplateATraceData> CacheRootMetadataStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata21TemplateATraceData(value, 2028, 2510, "CacheRootMetadata", CacheRootMetadataTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2028, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, CacheRootMetadataTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> CompileVbExpressionStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 2029, 2602, "VBExpressionCompile", VBExpressionCompileTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2029, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, VBExpressionCompileTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> TryCatchExceptionFromTry
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 2576, 2601, "TryCatchException", TryCatchExceptionTaskGuid, 131, "FromTry", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2576, ProviderGuid);
                source.UnregisterEventTemplate(value, 131, TryCatchExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> TryCatchExceptionDuringCancelation
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 2577, 2601, "TryCatchException", TryCatchExceptionTaskGuid, 129, "DuringCancelation", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2577, ProviderGuid);
                source.UnregisterEventTemplate(value, 129, TryCatchExceptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> TryCatchExceptionFromCatchOrFinally
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 2578, 2601, "TryCatchException", TryCatchExceptionTaskGuid, 130, "FromCatchOrFinally", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2578, ProviderGuid);
                source.UnregisterEventTemplate(value, 130, TryCatchExceptionTaskGuid);
            }
        }
        public event Action<Multidata33TemplateATraceData> ReceiveContextCompleteFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata33TemplateATraceData(value, 3300, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3300, ProviderGuid);
            }
        }
        public event Action<Multidata33TemplateATraceData> ReceiveContextAbandonFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata33TemplateATraceData(value, 3301, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3301, ProviderGuid);
            }
        }
        public event Action<TwoStringsTemplateSATraceData> ReceiveContextFaulted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateSATraceData(value, 3302, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3302, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata34TemplateATraceData> ReceiveContextAbandonWithException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata34TemplateATraceData(value, 3303, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3303, ProviderGuid);
            }
        }
        public event Action<Multidata35TemplateSATraceData> ClientBaseCachedChannelFactoryCount
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata35TemplateSATraceData(value, 3305, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3305, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ChannelFactoryCachingTaskGuid);
            }
        }
        public event Action<Multidata36TemplateSATraceData> ClientBaseChannelFactoryAgedOutofCache
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata36TemplateSATraceData(value, 3306, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3306, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ChannelFactoryCachingTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateSATraceData> ClientBaseChannelFactoryCacheHit
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateSATraceData(value, 3307, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3307, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ChannelFactoryCachingTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateSATraceData> ClientBaseUsingLocalChannelFactory
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateSATraceData(value, 3308, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3308, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ChannelFactoryCachingTaskGuid);
            }
        }
        public event Action<Multidata37TemplateSATraceData> QueryCompositionExecuted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata37TemplateSATraceData(value, 3309, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3309, ProviderGuid);
            }
        }
        public event Action<Multidata38TemplateHATraceData> DispatchFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata38TemplateHATraceData(value, 3310, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3310, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata38TemplateHATraceData> DispatchSuccessful
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata38TemplateHATraceData(value, 3311, 2533, "DispatchMessage", DispatchMessageTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3311, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, DispatchMessageTaskGuid);
            }
        }
        public event Action<Multidata39TemplateSATraceData> MessageReadByEncoder
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata39TemplateSATraceData(value, 3312, 2555, "MessageDecoding", MessageDecodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3312, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, MessageDecodingTaskGuid);
            }
        }
        public event Action<Multidata39TemplateSATraceData> MessageWrittenByEncoder
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata39TemplateSATraceData(value, 3313, 2556, "MessageEncoding", MessageEncodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3313, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, MessageEncodingTaskGuid);
            }
        }
        public event Action<Multidata40TemplateATraceData> SessionIdleTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata40TemplateATraceData(value, 3314, 2595, "Timeout", TimeoutTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3314, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TimeoutTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SocketAcceptEnqueued
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3319, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3319, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ConnectionAcceptTaskGuid);
            }
        }
        public event Action<Multidata41TemplateATraceData> SocketAccepted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata41TemplateATraceData(value, 3320, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3320, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ConnectionAcceptTaskGuid);
            }
        }
        public event Action<Multidata42TemplateATraceData> ConnectionPoolMiss
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata42TemplateATraceData(value, 3321, 2522, "ConnectionPooling", ConnectionPoolingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3321, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectionPoolingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchFormatterDeserializeRequestStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3322, 2540, "FormatterDeserializeRequest", FormatterDeserializeRequestTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3322, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, FormatterDeserializeRequestTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchFormatterDeserializeRequestStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3323, 2540, "FormatterDeserializeRequest", FormatterDeserializeRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3323, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, FormatterDeserializeRequestTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchFormatterSerializeReplyStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3324, 2541, "FormatterSerializeReply", FormatterSerializeReplyTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3324, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, FormatterSerializeReplyTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchFormatterSerializeReplyStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3325, 2541, "FormatterSerializeReply", FormatterSerializeReplyTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3325, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, FormatterSerializeReplyTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientFormatterSerializeRequestStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3326, 2542, "FormatterSerializeRequest", FormatterSerializeRequestTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3326, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, FormatterSerializeRequestTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientFormatterSerializeRequestStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3327, 2542, "FormatterSerializeRequest", FormatterSerializeRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3327, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, FormatterSerializeRequestTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientFormatterDeserializeReplyStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3328, 2539, "FormatterDeserializeReply", FormatterDeserializeReplyTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3328, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, FormatterDeserializeReplyTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientFormatterDeserializeReplyStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3329, 2539, "FormatterDeserializeReply", FormatterDeserializeReplyTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3329, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, FormatterDeserializeReplyTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityNegotiationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3330, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3330, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SecurityNegotiationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityNegotiationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3331, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3331, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, SecurityNegotiationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityTokenProviderOpened
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3332, 2571, "SecureMessage", SecureMessageTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3332, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SecureMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> OutgoingMessageSecured
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3333, 2571, "SecureMessage", SecureMessageTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3333, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, SecureMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> IncomingMessageVerified
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3334, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3334, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityVerificationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> GetServiceInstanceStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3335, 2584, "ServiceInstance", ServiceInstanceTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3335, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceInstanceTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> GetServiceInstanceStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3336, 2584, "ServiceInstance", ServiceInstanceTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3336, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceInstanceTaskGuid);
            }
        }
        public event Action<Multidata43TemplateATraceData> ChannelReceiveStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata43TemplateATraceData(value, 3337, 2513, "ChannelReceive", ChannelReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3337, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ChannelReceiveTaskGuid);
            }
        }
        public event Action<Multidata43TemplateATraceData> ChannelReceiveStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata43TemplateATraceData(value, 3338, 2513, "ChannelReceive", ChannelReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3338, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ChannelReceiveTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateSATraceData> ChannelFactoryCreated
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateSATraceData(value, 3339, 2512, "ChannelFactoryCreate", ChannelFactoryCreateTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3339, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ChannelFactoryCreateTaskGuid);
            }
        }
        public event Action<Multidata44TemplateATraceData> PipeConnectionAcceptStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata44TemplateATraceData(value, 3340, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3340, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ConnectionAcceptTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> PipeConnectionAcceptStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3341, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3341, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ConnectionAcceptTaskGuid);
            }
        }
        public event Action<Multidata45TemplateATraceData> EstablishConnectionStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata45TemplateATraceData(value, 3342, 2519, "Connect", ConnectTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3342, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ConnectTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> EstablishConnectionStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3343, 2519, "Connect", ConnectTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3343, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ConnectTaskGuid);
            }
        }
        public event Action<Multidata46TemplateATraceData> SessionPreambleUnderstood
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata46TemplateATraceData(value, 3345, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3345, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata47TemplateATraceData> ConnectionReaderSendFault
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata47TemplateATraceData(value, 3346, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3346, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SocketAcceptClosed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3347, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3347, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ConnectionAcceptTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateSATraceData> ServiceHostFaulted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateSATraceData(value, 3348, 2582, "ServiceHostFault", ServiceHostFaultTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3348, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ServiceHostFaultTaskGuid);
            }
        }
        public event Action<Multidata48TemplateATraceData> ListenerOpenStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata48TemplateATraceData(value, 3349, 2552, "ListenerOpen", ListenerOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3349, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ListenerOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ListenerOpenStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3350, 2552, "ListenerOpen", ListenerOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3350, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ListenerOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServerMaxPooledConnectionsQuotaReached
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3351, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3351, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<Multidata49TemplateATraceData> TcpConnectionTimedOut
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata49TemplateATraceData(value, 3352, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3352, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata49TemplateATraceData> TcpConnectionResetError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata49TemplateATraceData(value, 3353, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3353, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceSecurityNegotiationCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3354, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3354, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityNegotiationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityNegotiationProcessingFailure
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3355, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3355, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityNegotiationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityIdentityVerificationSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3356, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3356, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityVerificationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityIdentityVerificationFailure
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3357, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3357, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityVerificationTaskGuid);
            }
        }
        public event Action<Multidata48TemplateATraceData> PortSharingDuplicatedSocket
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata48TemplateATraceData(value, 3358, 2501, "ActivationDuplicateSocket", ActivationDuplicateSocketTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3358, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ActivationDuplicateSocketTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityImpersonationSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3359, 2572, "SecurityImpersonation", SecurityImpersonationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3359, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityImpersonationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SecurityImpersonationFailure
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3360, 2572, "SecurityImpersonation", SecurityImpersonationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3360, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityImpersonationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpChannelRequestAborted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3361, 2599, "TransportReceive", TransportReceiveTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3361, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TransportReceiveTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpChannelResponseAborted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3362, 2600, "TransportSend", TransportSendTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3362, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TransportSendTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpAuthFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3363, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3363, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SecurityVerificationTaskGuid);
            }
        }
        public event Action<Multidata48TemplateATraceData> SharedListenerProxyRegisterStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata48TemplateATraceData(value, 3364, 2502, "ActivationListenerOpen", ActivationListenerOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3364, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ActivationListenerOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SharedListenerProxyRegisterStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3365, 2502, "ActivationListenerOpen", ActivationListenerOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3365, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ActivationListenerOpenTaskGuid);
            }
        }
        public event Action<Multidata50TemplateATraceData> SharedListenerProxyRegisterFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata50TemplateATraceData(value, 3366, 2502, "ActivationListenerOpen", ActivationListenerOpenTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3366, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ActivationListenerOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ConnectionPoolPreambleFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3367, 2586, "SessionStart", SessionStartTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3367, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SessionStartTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SslOnInitiateUpgrade
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3368, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 115, "Initiate", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3368, ProviderGuid);
                source.UnregisterEventTemplate(value, 115, SessionUpgradeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SslOnAcceptUpgrade
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3369, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 114, "Accept", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3369, ProviderGuid);
                source.UnregisterEventTemplate(value, 114, SessionUpgradeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> BinaryMessageEncodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3370, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3370, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageEncodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MtomMessageEncodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3371, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3371, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageEncodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> TextMessageEncodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3372, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3372, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageEncodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> BinaryMessageDecodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3373, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3373, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageDecodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MtomMessageDecodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3374, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3374, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageDecodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> TextMessageDecodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3375, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3375, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageDecodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpResponseReceiveStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3376, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3376, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportReceiveTaskGuid);
            }
        }
        public event Action<Multidata51TemplateATraceData> SocketReadStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata51TemplateATraceData(value, 3377, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3377, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportReceiveTaskGuid);
            }
        }
        public event Action<Multidata51TemplateATraceData> SocketAsyncReadStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata51TemplateATraceData(value, 3378, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3378, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportReceiveTaskGuid);
            }
        }
        public event Action<Multidata51TemplateATraceData> SocketWriteStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata51TemplateATraceData(value, 3379, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3379, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<Multidata51TemplateATraceData> SocketAsyncWriteStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata51TemplateATraceData(value, 3380, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3380, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<Multidata52TemplateATraceData> SequenceAcknowledgementSent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata52TemplateATraceData(value, 3381, 2561, "ReliableSession", ReliableSessionTaskGuid, 79, "SequenceAck", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3381, ProviderGuid);
                source.UnregisterEventTemplate(value, 79, ReliableSessionTaskGuid);
            }
        }
        public event Action<Multidata52TemplateATraceData> ClientReliableSessionReconnect
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata52TemplateATraceData(value, 3382, 2561, "ReliableSession", ReliableSessionTaskGuid, 78, "Reconnect", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3382, ProviderGuid);
                source.UnregisterEventTemplate(value, 78, ReliableSessionTaskGuid);
            }
        }
        public event Action<Multidata52TemplateATraceData> ReliableSessionChannelFaulted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata52TemplateATraceData(value, 3383, 2561, "ReliableSession", ReliableSessionTaskGuid, 77, "Faulted", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3383, ProviderGuid);
                source.UnregisterEventTemplate(value, 77, ReliableSessionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WindowsStreamSecurityOnInitiateUpgrade
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3384, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 115, "Initiate", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3384, ProviderGuid);
                source.UnregisterEventTemplate(value, 115, SessionUpgradeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WindowsStreamSecurityOnAcceptUpgrade
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3385, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 114, "Accept", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3385, ProviderGuid);
                source.UnregisterEventTemplate(value, 114, SessionUpgradeTaskGuid);
            }
        }
        public event Action<Multidata53TemplateATraceData> SocketConnectionAbort
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata53TemplateATraceData(value, 3386, 2520, "ConnectionAbort", ConnectionAbortTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3386, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectionAbortTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpGetContextStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3388, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3388, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportReceiveTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientSendPreambleStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3389, 2515, "ClientSendPreamble", ClientSendPreambleTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3389, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ClientSendPreambleTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ClientSendPreambleStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3390, 2515, "ClientSendPreamble", ClientSendPreambleTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3390, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ClientSendPreambleTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpMessageReceiveFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3391, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3391, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportReceiveTaskGuid);
            }
        }
        public event Action<Multidata54TemplateATraceData> TransactionScopeCreate
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata54TemplateATraceData(value, 3392, 2533, "DispatchMessage", DispatchMessageTaskGuid, 57, "TransactionScopeCreate", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3392, ProviderGuid);
                source.UnregisterEventTemplate(value, 57, DispatchMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> StreamedMessageReadByEncoder
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3393, 2555, "MessageDecoding", MessageDecodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3393, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, MessageDecodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> StreamedMessageWrittenByEncoder
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3394, 2556, "MessageEncoding", MessageEncodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3394, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, MessageEncodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MessageWrittenAsynchronouslyByEncoder
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3395, 2556, "MessageEncoding", MessageEncodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3395, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, MessageEncodingTaskGuid);
            }
        }
        public event Action<Multidata55TemplateATraceData> BufferedAsyncWriteStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata55TemplateATraceData(value, 3396, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3396, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> BufferedAsyncWriteStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3397, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3397, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportSendTaskGuid);
            }
        }
        public event Action<Multidata60TemplateATraceData> PipeSharedMemoryCreated
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata60TemplateATraceData(value, 3398, 2552, "ListenerOpen", ListenerOpenTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3398, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ListenerOpenTaskGuid);
            }
        }
        public event Action<Multidata61TemplateATraceData> NamedPipeCreated
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata61TemplateATraceData(value, 3399, 2552, "ListenerOpen", ListenerOpenTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3399, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ListenerOpenTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SignatureVerificationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3401, 2611, "SignatureVerification", SignatureVerificationTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3401, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SignatureVerificationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SignatureVerificationSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3402, 2611, "SignatureVerification", SignatureVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3402, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SignatureVerificationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WrappedKeyDecryptionStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3403, 2614, "WrappedKeyDecryption", WrappedKeyDecryptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3403, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WrappedKeyDecryptionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WrappedKeyDecryptionSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3404, 2614, "WrappedKeyDecryption", WrappedKeyDecryptionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3404, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WrappedKeyDecryptionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> EncryptedDataProcessingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3405, 2615, "EncryptedDataProcessing", EncryptedDataProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3405, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, EncryptedDataProcessingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> EncryptedDataProcessingSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3406, 2615, "EncryptedDataProcessing", EncryptedDataProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3406, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, EncryptedDataProcessingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineProcessInboundRequestStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3407, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3407, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportReceiveTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineBeginProcessInboundRequestStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3408, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3408, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportReceiveTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineProcessInboundRequestStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3409, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3409, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportReceiveTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineFaulted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3410, 2599, "TransportReceive", TransportReceiveTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3410, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TransportReceiveTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineTimeoutException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3411, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3411, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineProcessResponseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3412, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3412, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineBeginProcessResponseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3413, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3413, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> HttpPipelineProcessResponseStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3414, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3414, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportSendTaskGuid);
            }
        }
        public event Action<Multidata62TemplateATraceData> WebSocketConnectionRequestSendStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata62TemplateATraceData(value, 3415, 2519, "Connect", ConnectTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3415, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ConnectTaskGuid);
            }
        }
        public event Action<Multidata63TemplateATraceData> WebSocketConnectionRequestSendStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata63TemplateATraceData(value, 3416, 2519, "Connect", ConnectTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3416, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ConnectTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WebSocketConnectionAcceptStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3417, 2519, "Connect", ConnectTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3417, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ConnectTaskGuid);
            }
        }
        public event Action<Multidata63TemplateATraceData> WebSocketConnectionAccepted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata63TemplateATraceData(value, 3418, 2519, "Connect", ConnectTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3418, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ConnectTaskGuid);
            }
        }
        public event Action<Multidata64TemplateATraceData> WebSocketConnectionDeclined
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata64TemplateATraceData(value, 3419, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3419, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata64TemplateATraceData> WebSocketConnectionFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata64TemplateATraceData(value, 3420, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3420, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata63TemplateATraceData> WebSocketConnectionAborted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata63TemplateATraceData(value, 3421, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3421, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata65TemplateATraceData> WebSocketAsyncWriteStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata65TemplateATraceData(value, 3422, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3422, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportSendTaskGuid);
            }
        }
        public event Action<Multidata63TemplateATraceData> WebSocketAsyncWriteStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata63TemplateATraceData(value, 3423, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3423, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportSendTaskGuid);
            }
        }
        public event Action<Multidata63TemplateATraceData> WebSocketAsyncReadStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata63TemplateATraceData(value, 3424, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3424, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, TransportReceiveTaskGuid);
            }
        }
        public event Action<Multidata65TemplateATraceData> WebSocketAsyncReadStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata65TemplateATraceData(value, 3425, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3425, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, TransportReceiveTaskGuid);
            }
        }
        public event Action<Multidata66TemplateATraceData> WebSocketCloseSent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata66TemplateATraceData(value, 3426, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3426, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata66TemplateATraceData> WebSocketCloseOutputSent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata66TemplateATraceData(value, 3427, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3427, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata63TemplateATraceData> WebSocketConnectionClosed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata63TemplateATraceData(value, 3428, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3428, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata67TemplateATraceData> WebSocketCloseStatusReceived
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata67TemplateATraceData(value, 3429, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3429, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata68TemplateATraceData> WebSocketUseVersionFromClientWebSocketFactory
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata68TemplateATraceData(value, 3430, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3430, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<Multidata68TemplateATraceData> WebSocketCreateClientWebSocketWithFactory
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata68TemplateATraceData(value, 3431, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3431, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ConnectTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> InferredContractDescription
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 3501, 2548, "InferDescription", InferDescriptionTaskGuid, 69, "Contract", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3501, ProviderGuid);
                source.UnregisterEventTemplate(value, 69, InferDescriptionTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> InferredOperationDescription
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 3502, 2548, "InferDescription", InferDescriptionTaskGuid, 70, "Operation", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3502, ProviderGuid);
                source.UnregisterEventTemplate(value, 70, InferDescriptionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> DuplicateCorrelationQuery
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3503, 2523, "Correlation", CorrelationTaskGuid, 28, "DuplicateQuery", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3503, ProviderGuid);
                source.UnregisterEventTemplate(value, 28, CorrelationTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> ServiceEndpointAdded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 3507, 2507, "AddServiceEndpoint", AddServiceEndpointTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3507, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, AddServiceEndpointTaskGuid);
            }
        }
        public event Action<Multidata85TemplateATraceData> TrackingProfileNotFound
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata85TemplateATraceData(value, 3508, 2597, "TrackingProfile", TrackingProfileTaskGuid, 124, "NotFound", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3508, ProviderGuid);
                source.UnregisterEventTemplate(value, 124, TrackingProfileTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> BufferOutOfOrderMessageNoInstance
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3550, 2508, "BufferOutOfOrder", BufferOutOfOrderTaskGuid, 11, "NoInstance", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3550, ProviderGuid);
                source.UnregisterEventTemplate(value, 11, BufferOutOfOrderTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> BufferOutOfOrderMessageNoBookmark
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 3551, 2508, "BufferOutOfOrder", BufferOutOfOrderTaskGuid, 10, "NoBookmark", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3551, ProviderGuid);
                source.UnregisterEventTemplate(value, 10, BufferOutOfOrderTaskGuid);
            }
        }
        public event Action<Multidata84TemplateATraceData> MaxPendingMessagesPerChannelExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata84TemplateATraceData(value, 3552, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3552, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> XamlServicesLoadStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3553, 2610, "XamlServicesLoad", XamlServicesLoadTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3553, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, XamlServicesLoadTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> XamlServicesLoadStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3554, 2610, "XamlServicesLoad", XamlServicesLoadTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3554, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, XamlServicesLoadTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> CreateWorkflowServiceHostStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3555, 2526, "CreateWorkflowServiceHost", CreateWorkflowServiceHostTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3555, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, CreateWorkflowServiceHostTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> CreateWorkflowServiceHostStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3556, 2526, "CreateWorkflowServiceHost", CreateWorkflowServiceHostTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3556, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, CreateWorkflowServiceHostTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> TransactedReceiveScopeEndCommitFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 3557, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3557, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, RuntimeTransactionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceActivationStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3558, 2575, "ServiceActivation", ServiceActivationTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3558, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ServiceActivationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ServiceActivationStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3559, 2575, "ServiceActivation", ServiceActivationTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3559, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ServiceActivationTaskGuid);
            }
        }
        public event Action<Multidata76TemplateATraceData> ServiceActivationAvailableMemory
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata76TemplateATraceData(value, 3560, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3560, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> ServiceActivationException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 3561, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3561, ProviderGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceClosingClient
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3800, 2563, "RoutingServiceClient", RoutingServiceClientTaskGuid, 87, "Closing", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3800, ProviderGuid);
                source.UnregisterEventTemplate(value, 87, RoutingServiceClientTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceChannelFaulted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3801, 2563, "RoutingServiceClient", RoutingServiceClientTaskGuid, 86, "ChannelFaulted", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3801, ProviderGuid);
                source.UnregisterEventTemplate(value, 86, RoutingServiceClientTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateEATraceData> RoutingServiceCompletingOneWay
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateEATraceData(value, 3802, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 89, "CompletingOneWay", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3802, ProviderGuid);
                source.UnregisterEventTemplate(value, 89, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> RoutingServiceProcessingFailure
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 3803, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 92, "ProcessingFailure", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3803, ProviderGuid);
                source.UnregisterEventTemplate(value, 92, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceCreatingClientForEndpoint
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3804, 2563, "RoutingServiceClient", RoutingServiceClientTaskGuid, 88, "CreatingForEndpoint", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3804, ProviderGuid);
                source.UnregisterEventTemplate(value, 88, RoutingServiceClientTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> RoutingServiceDisplayConfig
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 3805, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3805, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> RoutingServiceCompletingTwoWay
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3807, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 90, "CompletingTwoWay", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3807, ProviderGuid);
                source.UnregisterEventTemplate(value, 90, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> RoutingServiceMessageRoutedToEndpoints
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 3809, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 94, "RoutedToEndpoints", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3809, ProviderGuid);
                source.UnregisterEventTemplate(value, 94, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> RoutingServiceConfigurationApplied
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3810, 2562, "RoutingService", RoutingServiceTaskGuid, 82, "ConfigurationApplied", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3810, ProviderGuid);
                source.UnregisterEventTemplate(value, 82, RoutingServiceTaskGuid);
            }
        }
        public event Action<FiveStringsTemplateATraceData> RoutingServiceProcessingMessage
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FiveStringsTemplateATraceData(value, 3815, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 93, "ProcessingMessage", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3815, ProviderGuid);
                source.UnregisterEventTemplate(value, 93, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> RoutingServiceTransmittingMessage
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 3816, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 98, "TransmittingMessage", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3816, ProviderGuid);
                source.UnregisterEventTemplate(value, 98, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceCommittingTransaction
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3817, 2567, "RoutingServiceTransaction", RoutingServiceTransactionTaskGuid, 101, "CommittingTransaction", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3817, ProviderGuid);
                source.UnregisterEventTemplate(value, 101, RoutingServiceTransactionTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> RoutingServiceDuplexCallbackException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 3818, 2562, "RoutingService", RoutingServiceTaskGuid, 83, "DuplexCallbackException", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3818, ProviderGuid);
                source.UnregisterEventTemplate(value, 83, RoutingServiceTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> RoutingServiceMovedToBackup
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 3819, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 91, "MovedToBackup", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3819, ProviderGuid);
                source.UnregisterEventTemplate(value, 91, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceCreatingTransaction
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3820, 2567, "RoutingServiceTransaction", RoutingServiceTransactionTaskGuid, 102, "Creating", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3820, ProviderGuid);
                source.UnregisterEventTemplate(value, 102, RoutingServiceTransactionTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> RoutingServiceCloseFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 3821, 2562, "RoutingService", RoutingServiceTaskGuid, 81, "CloseFailed", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3821, ProviderGuid);
                source.UnregisterEventTemplate(value, 81, RoutingServiceTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceSendingResponse
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3822, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 96, "SendingResponse", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3822, ProviderGuid);
                source.UnregisterEventTemplate(value, 96, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceSendingFaultResponse
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3823, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 95, "SendingFaultResponse", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3823, ProviderGuid);
                source.UnregisterEventTemplate(value, 95, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceCompletingReceiveContext
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3824, 2566, "RoutingServiceReceiveContext", RoutingServiceReceiveContextTaskGuid, 100, "Completing", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3824, ProviderGuid);
                source.UnregisterEventTemplate(value, 100, RoutingServiceReceiveContextTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceAbandoningReceiveContext
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3825, 2566, "RoutingServiceReceiveContext", RoutingServiceReceiveContextTaskGuid, 99, "Abandoning", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3825, ProviderGuid);
                source.UnregisterEventTemplate(value, 99, RoutingServiceReceiveContextTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceUsingExistingTransaction
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3826, 2567, "RoutingServiceTransaction", RoutingServiceTransactionTaskGuid, 103, "UsingExisting", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3826, ProviderGuid);
                source.UnregisterEventTemplate(value, 103, RoutingServiceTransactionTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> RoutingServiceTransmitFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 3827, 2562, "RoutingService", RoutingServiceTaskGuid, 85, "TransmitFailed", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3827, ProviderGuid);
                source.UnregisterEventTemplate(value, 85, RoutingServiceTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> RoutingServiceFilterTableMatchStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3828, 2564, "RoutingServiceFilterTableMatch", RoutingServiceFilterTableMatchTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3828, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, RoutingServiceFilterTableMatchTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> RoutingServiceFilterTableMatchStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 3829, 2564, "RoutingServiceFilterTableMatch", RoutingServiceFilterTableMatchTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3829, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, RoutingServiceFilterTableMatchTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RoutingServiceAbortingChannel
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 3830, 2562, "RoutingService", RoutingServiceTaskGuid, 80, "AbortingChannel", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3830, ProviderGuid);
                source.UnregisterEventTemplate(value, 80, RoutingServiceTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateEATraceData> RoutingServiceHandledException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateEATraceData(value, 3831, 2562, "RoutingService", RoutingServiceTaskGuid, 84, "HandledException", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3831, ProviderGuid);
                source.UnregisterEventTemplate(value, 84, RoutingServiceTaskGuid);
            }
        }
        public event Action<FourStringsTemplateATraceData> RoutingServiceTransmitSucceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 3832, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 97, "TransmitSucceeded", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3832, ProviderGuid);
                source.UnregisterEventTemplate(value, 97, RoutingServiceMessageTaskGuid);
            }
        }
        public event Action<Multidata77TemplateATraceData> TransportListenerSessionsReceived
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata77TemplateATraceData(value, 4001, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 240, "Receive", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4001, ProviderGuid);
                source.UnregisterEventTemplate(value, 240, ActivationDispatchSessionTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateEATraceData> FailFastException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateEATraceData(value, 4002, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4002, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WASActivationTaskGuid);
            }
        }
        public event Action<Multidata78TemplateATraceData> ServiceStartPipeError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata78TemplateATraceData(value, 4003, 2505, "ActivationServiceStart", ActivationServiceStartTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4003, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ActivationServiceStartTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchSessionStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4008, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4008, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ActivationDispatchSessionTaskGuid);
            }
        }
        public event Action<Multidata79TemplateATraceData> PendingSessionQueueFull
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata79TemplateATraceData(value, 4010, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4010, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ActivationDispatchSessionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MessageQueueRegisterStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4011, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4011, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageQueueRegisterTaskGuid);
            }
        }
        public event Action<Multidata81TemplateATraceData> MessageQueueRegisterAbort
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata81TemplateATraceData(value, 4012, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4012, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, MessageQueueRegisterTaskGuid);
            }
        }
        public event Action<Multidata48TemplateATraceData> MessageQueueUnregisterSucceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata48TemplateATraceData(value, 4013, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4013, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, MessageQueueRegisterTaskGuid);
            }
        }
        public event Action<Multidata80TemplateATraceData> MessageQueueRegisterFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata80TemplateATraceData(value, 4014, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4014, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, MessageQueueRegisterTaskGuid);
            }
        }
        public event Action<Multidata48TemplateATraceData> MessageQueueRegisterCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata48TemplateATraceData(value, 4015, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4015, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, MessageQueueRegisterTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MessageQueueDuplicatedSocketError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4016, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4016, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ActivationDispatchSessionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MessageQueueDuplicatedSocketComplete
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4019, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4019, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ActivationDispatchSessionTaskGuid);
            }
        }
        public event Action<Multidata48TemplateATraceData> TcpTransportListenerListeningStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata48TemplateATraceData(value, 4020, 2506, "ActivationTcpListenerListening", ActivationTcpListenerListeningTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4020, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ActivationTcpListenerListeningTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> TcpTransportListenerListeningStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4021, 2506, "ActivationTcpListenerListening", ActivationTcpListenerListeningTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4021, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ActivationTcpListenerListeningTaskGuid);
            }
        }
        public event Action<Multidata82TemplateATraceData> WebhostUnregisterProtocolFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata82TemplateATraceData(value, 4022, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4022, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WASActivationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WasCloseAllListenerChannelInstancesCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4023, 2603, "WASActivation", WASActivationTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4023, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, WASActivationTaskGuid);
            }
        }
        public event Action<Multidata82TemplateATraceData> WasCloseAllListenerChannelInstancesFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata82TemplateATraceData(value, 4024, 2603, "WASActivation", WASActivationTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4024, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, WASActivationTaskGuid);
            }
        }
        public event Action<Multidata82TemplateATraceData> OpenListenerChannelInstanceFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata82TemplateATraceData(value, 4025, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4025, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WASActivationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WasConnected
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4026, 2603, "WASActivation", WASActivationTaskGuid, 132, "Connected", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4026, ProviderGuid);
                source.UnregisterEventTemplate(value, 132, WASActivationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WasDisconnected
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4027, 2603, "WASActivation", WASActivationTaskGuid, 133, "Disconnect", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4027, ProviderGuid);
                source.UnregisterEventTemplate(value, 133, WASActivationTaskGuid);
            }
        }
        public event Action<Multidata48TemplateATraceData> PipeTransportListenerListeningStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata48TemplateATraceData(value, 4028, 2503, "ActivationPipeListenerListening", ActivationPipeListenerListeningTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4028, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ActivationPipeListenerListeningTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> PipeTransportListenerListeningStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4029, 2503, "ActivationPipeListenerListening", ActivationPipeListenerListeningTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4029, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ActivationPipeListenerListeningTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchSessionSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4030, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4030, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ActivationDispatchSessionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DispatchSessionFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4031, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4031, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, ActivationDispatchSessionTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> WasConnectionTimedout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4032, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4032, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, WASActivationTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> RoutingTableLookupStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4033, 2504, "ActivationRoutingTableLookup", ActivationRoutingTableLookupTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4033, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ActivationRoutingTableLookupTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> RoutingTableLookupStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4034, 2504, "ActivationRoutingTableLookup", ActivationRoutingTableLookupTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4034, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ActivationRoutingTableLookupTaskGuid);
            }
        }
        public event Action<Multidata83TemplateATraceData> PendingSessionQueueRatio
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata83TemplateATraceData(value, 4035, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4035, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, QuotasTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> EndSqlCommandExecute
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 4201, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4201, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> StartSqlCommandExecute
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 4202, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4202, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> RenewLockSystemError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4203, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4203, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, LockWorkflowInstanceTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateEATraceData> FoundProcessingError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateEATraceData(value, 4205, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4205, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> UnlockInstanceException
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 4206, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4206, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, LockWorkflowInstanceTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MaximumRetriesExceededForSqlCommand
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4207, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4207, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> RetryingSqlCommandDueToSqlError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 4208, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4208, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> TimeoutOpeningSqlConnection
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 4209, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4209, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> SqlExceptionCaught
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 4210, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4210, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> QueuingSqlRetry
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 4211, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4211, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, LockWorkflowInstanceTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateATraceData> LockRetryTimeout
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateATraceData(value, 4212, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4212, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SqlCommandExecuteTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateEATraceData> RunnableInstancesDetectionError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateEATraceData(value, 4213, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4213, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, LockWorkflowInstanceTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateEATraceData> InstanceLocksRecoveryError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateEATraceData(value, 4214, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4214, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, LockWorkflowInstanceTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> MessageLogEventSizeExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4600, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4600, ProviderGuid);
            }
        }
        public event Action<TwoStringsTemplateEATraceData> DiscoveryClientInClientChannelFailedToClose
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateEATraceData(value, 4801, 2529, "DiscoveryClient", DiscoveryClientTaskGuid, 30, "FailedToClose", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4801, ProviderGuid);
                source.UnregisterEventTemplate(value, 30, DiscoveryClientTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateEATraceData> DiscoveryClientProtocolExceptionSuppressed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateEATraceData(value, 4802, 2529, "DiscoveryClient", DiscoveryClientTaskGuid, 29, "ExceptionSuppressed", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4802, ProviderGuid);
                source.UnregisterEventTemplate(value, 29, DiscoveryClientTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DiscoveryClientReceivedMulticastSuppression
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4803, 2529, "DiscoveryClient", DiscoveryClientTaskGuid, 31, "ReceivedMulticastSuppression", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4803, ProviderGuid);
                source.UnregisterEventTemplate(value, 31, DiscoveryClientTaskGuid);
            }
        }
        public event Action<Multidata87TemplateATraceData> DiscoveryMessageReceivedAfterOperationCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata87TemplateATraceData(value, 4804, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 45, "ReceivedAfterOperationCompleted", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4804, ProviderGuid);
                source.UnregisterEventTemplate(value, 45, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata88TemplateATraceData> DiscoveryMessageWithInvalidContent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata88TemplateATraceData(value, 4805, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 37, "InvalidContent", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4805, ProviderGuid);
                source.UnregisterEventTemplate(value, 37, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata89TemplateATraceData> DiscoveryMessageWithInvalidRelatesToOrOperationCompleted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata89TemplateATraceData(value, 4806, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 38, "InvalidRelatesToOrOperationCompleted", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4806, ProviderGuid);
                source.UnregisterEventTemplate(value, 38, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata90TemplateATraceData> DiscoveryMessageWithInvalidReplyTo
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata90TemplateATraceData(value, 4807, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 39, "InvalidReplyTo", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4807, ProviderGuid);
                source.UnregisterEventTemplate(value, 39, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata91TemplateATraceData> DiscoveryMessageWithNoContent
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata91TemplateATraceData(value, 4808, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 40, "NoContent", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4808, ProviderGuid);
                source.UnregisterEventTemplate(value, 40, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata91TemplateATraceData> DiscoveryMessageWithNullMessageId
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata91TemplateATraceData(value, 4809, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 41, "NullMessageId", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4809, ProviderGuid);
                source.UnregisterEventTemplate(value, 41, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata92TemplateATraceData> DiscoveryMessageWithNullMessageSequence
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata92TemplateATraceData(value, 4810, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 42, "NullMessageSequence", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4810, ProviderGuid);
                source.UnregisterEventTemplate(value, 42, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata92TemplateATraceData> DiscoveryMessageWithNullRelatesTo
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata92TemplateATraceData(value, 4811, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 43, "NullRelatesTo", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4811, ProviderGuid);
                source.UnregisterEventTemplate(value, 43, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata90TemplateATraceData> DiscoveryMessageWithNullReplyTo
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata90TemplateATraceData(value, 4812, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 44, "NullReplyTo", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4812, ProviderGuid);
                source.UnregisterEventTemplate(value, 44, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata88TemplateATraceData> DuplicateDiscoveryMessage
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata88TemplateATraceData(value, 4813, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 36, "Duplicate", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4813, ProviderGuid);
                source.UnregisterEventTemplate(value, 36, DiscoveryMessageTaskGuid);
            }
        }
        public event Action<Multidata93TemplateATraceData> EndpointDiscoverabilityDisabled
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata93TemplateATraceData(value, 4814, 2534, "EndpointDiscoverability", EndpointDiscoverabilityTaskGuid, 58, "Disabled", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4814, ProviderGuid);
                source.UnregisterEventTemplate(value, 58, EndpointDiscoverabilityTaskGuid);
            }
        }
        public event Action<Multidata93TemplateATraceData> EndpointDiscoverabilityEnabled
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata93TemplateATraceData(value, 4815, 2534, "EndpointDiscoverability", EndpointDiscoverabilityTaskGuid, 59, "Enabled", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4815, ProviderGuid);
                source.UnregisterEventTemplate(value, 59, EndpointDiscoverabilityTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> FindInitiatedInDiscoveryClientChannel
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4816, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 33, "FindInitiated", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4816, ProviderGuid);
                source.UnregisterEventTemplate(value, 33, DiscoveryClientChannelTaskGuid);
            }
        }
        public event Action<Multidata94TemplateEATraceData> InnerChannelCreationFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata94TemplateEATraceData(value, 4817, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 32, "CreationFailed", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4817, ProviderGuid);
                source.UnregisterEventTemplate(value, 32, DiscoveryClientChannelTaskGuid);
            }
        }
        public event Action<Multidata94TemplateEATraceData> InnerChannelOpenFailed
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata94TemplateEATraceData(value, 4818, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 34, "OpenFailed", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4818, ProviderGuid);
                source.UnregisterEventTemplate(value, 34, DiscoveryClientChannelTaskGuid);
            }
        }
        public event Action<Multidata95TemplateATraceData> InnerChannelOpenSucceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata95TemplateATraceData(value, 4819, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 35, "OpenSucceeded", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4819, ProviderGuid);
                source.UnregisterEventTemplate(value, 35, DiscoveryClientChannelTaskGuid);
            }
        }
        public event Action<Multidata96TemplateATraceData> SynchronizationContextReset
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata96TemplateATraceData(value, 4820, 2532, "DiscoverySynchronizationContext", DiscoverySynchronizationContextTaskGuid, 46, "Reset", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4820, ProviderGuid);
                source.UnregisterEventTemplate(value, 46, DiscoverySynchronizationContextTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> SynchronizationContextSetToNull
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 4821, 2532, "DiscoverySynchronizationContext", DiscoverySynchronizationContextTaskGuid, 47, "SetToNull", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4821, ProviderGuid);
                source.UnregisterEventTemplate(value, 47, DiscoverySynchronizationContextTaskGuid);
            }
        }
        public event Action<Multidata97TemplateATraceData> DCSerializeWithSurrogateStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata97TemplateATraceData(value, 5001, 2592, "SurrogateSerialize", SurrogateSerializeTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5001, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SurrogateSerializeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DCSerializeWithSurrogateStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5002, 2592, "SurrogateSerialize", SurrogateSerializeTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5002, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, SurrogateSerializeTaskGuid);
            }
        }
        public event Action<Multidata97TemplateATraceData> DCDeserializeWithSurrogateStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata97TemplateATraceData(value, 5003, 2591, "SurrogateDeserialize", SurrogateDeserializeTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5003, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, SurrogateDeserializeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DCDeserializeWithSurrogateStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5004, 2591, "SurrogateDeserialize", SurrogateDeserializeTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5004, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, SurrogateDeserializeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ImportKnownTypesStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5005, 2547, "ImportKnownType", ImportKnownTypeTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5005, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, ImportKnownTypeTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> ImportKnownTypesStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5006, 2547, "ImportKnownType", ImportKnownTypeTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5006, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, ImportKnownTypeTaskGuid);
            }
        }
        public event Action<Multidata33TemplateATraceData> DCResolverResolve
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata33TemplateATraceData(value, 5007, 2528, "DataContractResolver", DataContractResolverTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5007, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, DataContractResolverTaskGuid);
            }
        }
        public event Action<Multidata98TemplateATraceData> DCGenWriterStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata98TemplateATraceData(value, 5008, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5008, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, GenerateSerializerTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DCGenWriterStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5009, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5009, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, GenerateSerializerTaskGuid);
            }
        }
        public event Action<Multidata98TemplateATraceData> DCGenReaderStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata98TemplateATraceData(value, 5010, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5010, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, GenerateDeserializerTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DCGenReaderStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5011, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5011, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, GenerateDeserializerTaskGuid);
            }
        }
        public event Action<Multidata98TemplateATraceData> DCJsonGenReaderStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata98TemplateATraceData(value, 5012, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5012, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, GenerateDeserializerTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DCJsonGenReaderStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5013, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5013, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, GenerateDeserializerTaskGuid);
            }
        }
        public event Action<Multidata98TemplateATraceData> DCJsonGenWriterStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata98TemplateATraceData(value, 5014, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5014, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, GenerateSerializerTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> DCJsonGenWriterStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5015, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5015, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, GenerateSerializerTaskGuid);
            }
        }
        public event Action<Multidata99TemplateATraceData> GenXmlSerializableStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata99TemplateATraceData(value, 5016, 2545, "GenerateXmlSerializable", GenerateXmlSerializableTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5016, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, GenerateXmlSerializableTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> GenXmlSerializableStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5017, 2545, "GenerateXmlSerializable", GenerateXmlSerializableTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5017, ProviderGuid);
                source.UnregisterEventTemplate(value, 2, GenerateXmlSerializableTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> JsonMessageDecodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5203, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5203, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageDecodingTaskGuid);
            }
        }
        public event Action<OneStringsTemplateATraceData> JsonMessageEncodingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new OneStringsTemplateATraceData(value, 5204, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5204, ProviderGuid);
                source.UnregisterEventTemplate(value, 1, MessageEncodingTaskGuid);
            }
        }
        public event Action<Multidata103TemplateHATraceData> TokenValidationStarted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata103TemplateHATraceData(value, 5402, 2612, "TokenValidation", TokenValidationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5402, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TokenValidationTaskGuid);
            }
        }
        public event Action<Multidata103TemplateHATraceData> TokenValidationSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata103TemplateHATraceData(value, 5403, 2612, "TokenValidation", TokenValidationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5403, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TokenValidationTaskGuid);
            }
        }
        public event Action<Multidata102TemplateHATraceData> TokenValidationFailure
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata102TemplateHATraceData(value, 5404, 2612, "TokenValidation", TokenValidationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5404, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, TokenValidationTaskGuid);
            }
        }
        public event Action<Multidata101TemplateHATraceData> GetIssuerNameSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata101TemplateHATraceData(value, 5405, 2613, "GetIssuerName", GetIssuerNameTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5405, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, GetIssuerNameTaskGuid);
            }
        }
        public event Action<Multidata100TemplateHATraceData> GetIssuerNameFailure
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata100TemplateHATraceData(value, 5406, 2613, "GetIssuerName", GetIssuerNameTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5406, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, GetIssuerNameTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> FederationMessageProcessingStarted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5600, 2616, "FederationMessageProcessing", FederationMessageProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5600, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, FederationMessageProcessingTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> FederationMessageProcessingSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5601, 2616, "FederationMessageProcessing", FederationMessageProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5601, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, FederationMessageProcessingTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> FederationMessageCreationStarted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5602, 2617, "FederationMessageCreation", FederationMessageCreationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5602, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, FederationMessageCreationTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> FederationMessageCreationSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5603, 2617, "FederationMessageCreation", FederationMessageCreationTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5603, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, FederationMessageCreationTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> SessionCookieReadingStarted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5604, 2618, "SessionCookieReading", SessionCookieReadingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5604, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SessionCookieReadingTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> SessionCookieReadingSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5605, 2618, "SessionCookieReading", SessionCookieReadingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5605, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, SessionCookieReadingTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> PrincipalSettingFromSessionTokenStarted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5606, 2619, "PrincipalSetting", PrincipalSettingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5606, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, PrincipalSettingTaskGuid);
            }
        }
        public event Action<TwoStringsTemplateVATraceData> PrincipalSettingFromSessionTokenSuccess
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TwoStringsTemplateVATraceData(value, 5607, 2619, "PrincipalSetting", PrincipalSettingTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5607, ProviderGuid);
                source.UnregisterEventTemplate(value, 0, PrincipalSettingTaskGuid);
            }
        }
        public event Action<Multidata15TemplateATraceData> TrackingRecordDropped
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata15TemplateATraceData(value, 0xFFFF, 2598, "TrackingRecord", TrackingRecordTaskGuid, 125, "Dropped", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 125, TrackingRecordTaskGuid);
            }
        }
        public event Action<ThreeStringsTemplateATraceData> TrackingRecordRaised
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ThreeStringsTemplateATraceData(value, 0xFFFF, 2598, "TrackingRecord", TrackingRecordTaskGuid, 126, "Raised", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 126, TrackingRecordTaskGuid);
            }
        }
        public event Action<Multidata15TemplateATraceData> TrackingRecordTruncated
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata15TemplateATraceData(value, 0xFFFF, 2598, "TrackingRecord", TrackingRecordTaskGuid, 127, "Truncated", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 127, TrackingRecordTaskGuid);
            }
        }
        public event Action<Multidata16TemplateATraceData> TrackingDataExtracted
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata16TemplateATraceData(value, 0xFFFF, 2597, "TrackingProfile", TrackingProfileTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 0, TrackingProfileTaskGuid);
            }
        }
        public event Action<Multidata18TemplateATraceData> TrackingValueNotSerializable
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata18TemplateATraceData(value, 0xFFFF, 2597, "TrackingProfile", TrackingProfileTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 0, TrackingProfileTaskGuid);
            }
        }


        public event Action<Multidata84TemplateATraceData> MaxInstancesExceeded
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new Multidata84TemplateATraceData(value, 0xFFFF, 2594, "Throttles", ThrottlesTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 0, ThrottlesTaskGuid);
            }
        }

        public event Action<FourStringsTemplateATraceData> HttpHandlerPickedForUrl
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new FourStringsTemplateATraceData(value, 0xFFFF, 2526, "CreateWorkflowServiceHost", CreateWorkflowServiceHostTaskGuid, 0, "Info", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 0, CreateWorkflowServiceHostTaskGuid);
            }
        }

        #region Event ID Definitions
        private const TraceEventID WorkflowInstanceRecordEventID = (TraceEventID)100;
        private const TraceEventID WorkflowInstanceUnhandledExceptionRecordEventID = (TraceEventID)101;
        private const TraceEventID WorkflowInstanceAbortedRecordEventID = (TraceEventID)102;
        private const TraceEventID ActivityStateRecordEventID = (TraceEventID)103;
        private const TraceEventID ActivityScheduledRecordEventID = (TraceEventID)104;
        private const TraceEventID FaultPropagationRecordEventID = (TraceEventID)105;
        private const TraceEventID CancelRequestedRecordEventID = (TraceEventID)106;
        private const TraceEventID BookmarkResumptionRecordEventID = (TraceEventID)107;
        private const TraceEventID CustomTrackingRecordInfoEventID = (TraceEventID)108;
        private const TraceEventID CustomTrackingRecordWarningEventID = (TraceEventID)110;
        private const TraceEventID CustomTrackingRecordErrorEventID = (TraceEventID)111;
        private const TraceEventID WorkflowInstanceSuspendedRecordEventID = (TraceEventID)112;
        private const TraceEventID WorkflowInstanceTerminatedRecordEventID = (TraceEventID)113;
        private const TraceEventID WorkflowInstanceRecordWithIdEventID = (TraceEventID)114;
        private const TraceEventID WorkflowInstanceAbortedRecordWithIdEventID = (TraceEventID)115;
        private const TraceEventID WorkflowInstanceSuspendedRecordWithIdEventID = (TraceEventID)116;
        private const TraceEventID WorkflowInstanceTerminatedRecordWithIdEventID = (TraceEventID)117;
        private const TraceEventID WorkflowInstanceUnhandledExceptionRecordWithIdEventID = (TraceEventID)118;
        private const TraceEventID WorkflowInstanceUpdatedRecordEventID = (TraceEventID)119;
        private const TraceEventID BufferPoolAllocationEventID = (TraceEventID)131;
        private const TraceEventID BufferPoolChangeQuotaEventID = (TraceEventID)132;
        private const TraceEventID ActionItemScheduledEventID = (TraceEventID)133;
        private const TraceEventID ActionItemCallbackInvokedEventID = (TraceEventID)134;
        private const TraceEventID ClientMessageInspectorAfterReceiveInvokedEventID = (TraceEventID)201;
        private const TraceEventID ClientMessageInspectorBeforeSendInvokedEventID = (TraceEventID)202;
        private const TraceEventID ClientParameterInspectorAfterCallInvokedEventID = (TraceEventID)203;
        private const TraceEventID ClientParameterInspectorBeforeCallInvokedEventID = (TraceEventID)204;
        private const TraceEventID OperationInvokedEventID = (TraceEventID)205;
        private const TraceEventID ErrorHandlerInvokedEventID = (TraceEventID)206;
        private const TraceEventID FaultProviderInvokedEventID = (TraceEventID)207;
        private const TraceEventID MessageInspectorAfterReceiveInvokedEventID = (TraceEventID)208;
        private const TraceEventID MessageInspectorBeforeSendInvokedEventID = (TraceEventID)209;
        private const TraceEventID MessageThrottleExceededEventID = (TraceEventID)210;
        private const TraceEventID ParameterInspectorAfterCallInvokedEventID = (TraceEventID)211;
        private const TraceEventID ParameterInspectorBeforeCallInvokedEventID = (TraceEventID)212;
        private const TraceEventID ServiceHostStartedEventID = (TraceEventID)213;
        private const TraceEventID OperationCompletedEventID = (TraceEventID)214;
        private const TraceEventID MessageReceivedByTransportEventID = (TraceEventID)215;
        private const TraceEventID MessageSentByTransportEventID = (TraceEventID)216;
        private const TraceEventID ClientOperationPreparedEventID = (TraceEventID)217;
        private const TraceEventID ServiceChannelCallStopEventID = (TraceEventID)218;
        private const TraceEventID ServiceExceptionEventID = (TraceEventID)219;
        private const TraceEventID MessageSentToTransportEventID = (TraceEventID)220;
        private const TraceEventID MessageReceivedFromTransportEventID = (TraceEventID)221;
        private const TraceEventID OperationFailedEventID = (TraceEventID)222;
        private const TraceEventID OperationFaultedEventID = (TraceEventID)223;
        private const TraceEventID MessageThrottleAtSeventyPercentEventID = (TraceEventID)224;
        private const TraceEventID TraceCorrelationKeysEventID = (TraceEventID)225;
        private const TraceEventID IdleServicesClosedEventID = (TraceEventID)226;
        private const TraceEventID UserDefinedErrorOccurredEventID = (TraceEventID)301;
        private const TraceEventID UserDefinedWarningOccurredEventID = (TraceEventID)302;
        private const TraceEventID UserDefinedInformationEventOccuredEventID = (TraceEventID)303;
        private const TraceEventID StopSignpostEventEventID = (TraceEventID)401;
        private const TraceEventID StartSignpostEventEventID = (TraceEventID)402;
        private const TraceEventID SuspendSignpostEventEventID = (TraceEventID)403;
        private const TraceEventID ResumeSignpostEventEventID = (TraceEventID)404;
        private const TraceEventID StartSignpostEvent1EventID = (TraceEventID)440;
        private const TraceEventID StopSignpostEvent1EventID = (TraceEventID)441;
        private const TraceEventID MessageLogInfoEventID = (TraceEventID)451;
        private const TraceEventID MessageLogWarningEventID = (TraceEventID)452;
        private const TraceEventID TransferEmittedEventID = (TraceEventID)499;
        private const TraceEventID CompilationStartEventID = (TraceEventID)501;
        private const TraceEventID CompilationStopEventID = (TraceEventID)502;
        private const TraceEventID ServiceHostFactoryCreationStartEventID = (TraceEventID)503;
        private const TraceEventID ServiceHostFactoryCreationStopEventID = (TraceEventID)504;
        private const TraceEventID CreateServiceHostStartEventID = (TraceEventID)505;
        private const TraceEventID CreateServiceHostStopEventID = (TraceEventID)506;
        private const TraceEventID HostedTransportConfigurationManagerConfigInitStartEventID = (TraceEventID)507;
        private const TraceEventID HostedTransportConfigurationManagerConfigInitStopEventID = (TraceEventID)508;
        private const TraceEventID ServiceHostOpenStartEventID = (TraceEventID)509;
        private const TraceEventID ServiceHostOpenStopEventID = (TraceEventID)510;
        private const TraceEventID WebHostRequestStartEventID = (TraceEventID)513;
        private const TraceEventID WebHostRequestStopEventID = (TraceEventID)514;
        private const TraceEventID CBAEntryReadEventID = (TraceEventID)601;
        private const TraceEventID CBAMatchFoundEventID = (TraceEventID)602;
        private const TraceEventID AspNetRoutingServiceEventID = (TraceEventID)603;
        private const TraceEventID AspNetRouteEventID = (TraceEventID)604;
        private const TraceEventID IncrementBusyCountEventID = (TraceEventID)605;
        private const TraceEventID DecrementBusyCountEventID = (TraceEventID)606;
        private const TraceEventID ServiceChannelOpenStartEventID = (TraceEventID)701;
        private const TraceEventID ServiceChannelOpenStopEventID = (TraceEventID)702;
        private const TraceEventID ServiceChannelCallStartEventID = (TraceEventID)703;
        private const TraceEventID ServiceChannelBeginCallStartEventID = (TraceEventID)704;
        private const TraceEventID HttpSendMessageStartEventID = (TraceEventID)706;
        private const TraceEventID HttpSendStopEventID = (TraceEventID)707;
        private const TraceEventID HttpMessageReceiveStartEventID = (TraceEventID)708;
        private const TraceEventID DispatchMessageStartEventID = (TraceEventID)709;
        private const TraceEventID HttpContextBeforeProcessAuthenticationEventID = (TraceEventID)710;
        private const TraceEventID DispatchMessageBeforeAuthorizationEventID = (TraceEventID)711;
        private const TraceEventID DispatchMessageStopEventID = (TraceEventID)712;
        private const TraceEventID ClientChannelOpenStartEventID = (TraceEventID)715;
        private const TraceEventID ClientChannelOpenStopEventID = (TraceEventID)716;
        private const TraceEventID HttpSendStreamedMessageStartEventID = (TraceEventID)717;
        private const TraceEventID WorkflowApplicationCompletedEventID = (TraceEventID)1001;
        private const TraceEventID WorkflowApplicationTerminatedEventID = (TraceEventID)1002;
        private const TraceEventID WorkflowInstanceCanceledEventID = (TraceEventID)1003;
        private const TraceEventID WorkflowInstanceAbortedEventID = (TraceEventID)1004;
        private const TraceEventID WorkflowApplicationIdledEventID = (TraceEventID)1005;
        private const TraceEventID WorkflowApplicationUnhandledExceptionEventID = (TraceEventID)1006;
        private const TraceEventID WorkflowApplicationPersistedEventID = (TraceEventID)1007;
        private const TraceEventID WorkflowApplicationUnloadedEventID = (TraceEventID)1008;
        private const TraceEventID ActivityScheduledEventID = (TraceEventID)1009;
        private const TraceEventID ActivityCompletedEventID = (TraceEventID)1010;
        private const TraceEventID ScheduleExecuteActivityWorkItemEventID = (TraceEventID)1011;
        private const TraceEventID StartExecuteActivityWorkItemEventID = (TraceEventID)1012;
        private const TraceEventID CompleteExecuteActivityWorkItemEventID = (TraceEventID)1013;
        private const TraceEventID ScheduleCompletionWorkItemEventID = (TraceEventID)1014;
        private const TraceEventID StartCompletionWorkItemEventID = (TraceEventID)1015;
        private const TraceEventID CompleteCompletionWorkItemEventID = (TraceEventID)1016;
        private const TraceEventID ScheduleCancelActivityWorkItemEventID = (TraceEventID)1017;
        private const TraceEventID StartCancelActivityWorkItemEventID = (TraceEventID)1018;
        private const TraceEventID CompleteCancelActivityWorkItemEventID = (TraceEventID)1019;
        private const TraceEventID CreateBookmarkEventID = (TraceEventID)1020;
        private const TraceEventID ScheduleBookmarkWorkItemEventID = (TraceEventID)1021;
        private const TraceEventID StartBookmarkWorkItemEventID = (TraceEventID)1022;
        private const TraceEventID CompleteBookmarkWorkItemEventID = (TraceEventID)1023;
        private const TraceEventID CreateBookmarkScopeEventID = (TraceEventID)1024;
        private const TraceEventID BookmarkScopeInitializedEventID = (TraceEventID)1025;
        private const TraceEventID ScheduleTransactionContextWorkItemEventID = (TraceEventID)1026;
        private const TraceEventID StartTransactionContextWorkItemEventID = (TraceEventID)1027;
        private const TraceEventID CompleteTransactionContextWorkItemEventID = (TraceEventID)1028;
        private const TraceEventID ScheduleFaultWorkItemEventID = (TraceEventID)1029;
        private const TraceEventID StartFaultWorkItemEventID = (TraceEventID)1030;
        private const TraceEventID CompleteFaultWorkItemEventID = (TraceEventID)1031;
        private const TraceEventID ScheduleRuntimeWorkItemEventID = (TraceEventID)1032;
        private const TraceEventID StartRuntimeWorkItemEventID = (TraceEventID)1033;
        private const TraceEventID CompleteRuntimeWorkItemEventID = (TraceEventID)1034;
        private const TraceEventID RuntimeTransactionSetEventID = (TraceEventID)1035;
        private const TraceEventID RuntimeTransactionCompletionRequestedEventID = (TraceEventID)1036;
        private const TraceEventID RuntimeTransactionCompleteEventID = (TraceEventID)1037;
        private const TraceEventID EnterNoPersistBlockEventID = (TraceEventID)1038;
        private const TraceEventID ExitNoPersistBlockEventID = (TraceEventID)1039;
        private const TraceEventID InArgumentBoundEventID = (TraceEventID)1040;
        private const TraceEventID WorkflowApplicationPersistableIdleEventID = (TraceEventID)1041;
        private const TraceEventID WorkflowActivityStartEventID = (TraceEventID)1101;
        private const TraceEventID WorkflowActivityStopEventID = (TraceEventID)1102;
        private const TraceEventID WorkflowActivitySuspendEventID = (TraceEventID)1103;
        private const TraceEventID WorkflowActivityResumeEventID = (TraceEventID)1104;
        private const TraceEventID InvokeMethodIsStaticEventID = (TraceEventID)1124;
        private const TraceEventID InvokeMethodIsNotStaticEventID = (TraceEventID)1125;
        private const TraceEventID InvokedMethodThrewExceptionEventID = (TraceEventID)1126;
        private const TraceEventID InvokeMethodUseAsyncPatternEventID = (TraceEventID)1131;
        private const TraceEventID InvokeMethodDoesNotUseAsyncPatternEventID = (TraceEventID)1132;
        private const TraceEventID FlowchartStartEventID = (TraceEventID)1140;
        private const TraceEventID FlowchartEmptyEventID = (TraceEventID)1141;
        private const TraceEventID FlowchartNextNullEventID = (TraceEventID)1143;
        private const TraceEventID FlowchartSwitchCaseEventID = (TraceEventID)1146;
        private const TraceEventID FlowchartSwitchDefaultEventID = (TraceEventID)1147;
        private const TraceEventID FlowchartSwitchCaseNotFoundEventID = (TraceEventID)1148;
        private const TraceEventID CompensationStateEventID = (TraceEventID)1150;
        private const TraceEventID SwitchCaseNotFoundEventID = (TraceEventID)1223;
        private const TraceEventID ChannelInitializationTimeoutEventID = (TraceEventID)1400;
        private const TraceEventID CloseTimeoutEventID = (TraceEventID)1401;
        private const TraceEventID IdleTimeoutEventID = (TraceEventID)1402;
        private const TraceEventID LeaseTimeoutEventID = (TraceEventID)1403;
        private const TraceEventID OpenTimeoutEventID = (TraceEventID)1405;
        private const TraceEventID ReceiveTimeoutEventID = (TraceEventID)1406;
        private const TraceEventID SendTimeoutEventID = (TraceEventID)1407;
        private const TraceEventID InactivityTimeoutEventID = (TraceEventID)1409;
        private const TraceEventID MaxReceivedMessageSizeExceededEventID = (TraceEventID)1416;
        private const TraceEventID MaxSentMessageSizeExceededEventID = (TraceEventID)1417;
        private const TraceEventID MaxOutboundConnectionsPerEndpointExceededEventID = (TraceEventID)1418;
        private const TraceEventID MaxPendingConnectionsExceededEventID = (TraceEventID)1419;
        private const TraceEventID ReaderQuotaExceededEventID = (TraceEventID)1420;
        private const TraceEventID NegotiateTokenAuthenticatorStateCacheExceededEventID = (TraceEventID)1422;
        private const TraceEventID NegotiateTokenAuthenticatorStateCacheRatioEventID = (TraceEventID)1423;
        private const TraceEventID SecuritySessionRatioEventID = (TraceEventID)1424;
        private const TraceEventID PendingConnectionsRatioEventID = (TraceEventID)1430;
        private const TraceEventID ConcurrentCallsRatioEventID = (TraceEventID)1431;
        private const TraceEventID ConcurrentSessionsRatioEventID = (TraceEventID)1432;
        private const TraceEventID OutboundConnectionsPerEndpointRatioEventID = (TraceEventID)1433;
        private const TraceEventID PendingMessagesPerChannelRatioEventID = (TraceEventID)1436;
        private const TraceEventID ConcurrentInstancesRatioEventID = (TraceEventID)1438;
        private const TraceEventID PendingAcceptsAtZeroEventID = (TraceEventID)1439;
        private const TraceEventID MaxSessionSizeReachedEventID = (TraceEventID)1441;
        private const TraceEventID ReceiveRetryCountReachedEventID = (TraceEventID)1442;
        private const TraceEventID MaxRetryCyclesExceededMsmqEventID = (TraceEventID)1443;
        private const TraceEventID ReadPoolMissEventID = (TraceEventID)1445;
        private const TraceEventID WritePoolMissEventID = (TraceEventID)1446;
        private const TraceEventID WfMessageReceivedEventID = (TraceEventID)1449;
        private const TraceEventID WfMessageSentEventID = (TraceEventID)1450;
        private const TraceEventID MaxRetryCyclesExceededEventID = (TraceEventID)1451;
        private const TraceEventID ExecuteWorkItemStartEventID = (TraceEventID)2021;
        private const TraceEventID ExecuteWorkItemStopEventID = (TraceEventID)2022;
        private const TraceEventID SendMessageChannelCacheMissEventID = (TraceEventID)2023;
        private const TraceEventID InternalCacheMetadataStartEventID = (TraceEventID)2024;
        private const TraceEventID InternalCacheMetadataStopEventID = (TraceEventID)2025;
        private const TraceEventID CompileVbExpressionStartEventID = (TraceEventID)2026;
        private const TraceEventID CacheRootMetadataStartEventID = (TraceEventID)2027;
        private const TraceEventID CacheRootMetadataStopEventID = (TraceEventID)2028;
        private const TraceEventID CompileVbExpressionStopEventID = (TraceEventID)2029;
        private const TraceEventID TryCatchExceptionFromTryEventID = (TraceEventID)2576;
        private const TraceEventID TryCatchExceptionDuringCancelationEventID = (TraceEventID)2577;
        private const TraceEventID TryCatchExceptionFromCatchOrFinallyEventID = (TraceEventID)2578;
        private const TraceEventID ReceiveContextCompleteFailedEventID = (TraceEventID)3300;
        private const TraceEventID ReceiveContextAbandonFailedEventID = (TraceEventID)3301;
        private const TraceEventID ReceiveContextFaultedEventID = (TraceEventID)3302;
        private const TraceEventID ReceiveContextAbandonWithExceptionEventID = (TraceEventID)3303;
        private const TraceEventID ClientBaseCachedChannelFactoryCountEventID = (TraceEventID)3305;
        private const TraceEventID ClientBaseChannelFactoryAgedOutofCacheEventID = (TraceEventID)3306;
        private const TraceEventID ClientBaseChannelFactoryCacheHitEventID = (TraceEventID)3307;
        private const TraceEventID ClientBaseUsingLocalChannelFactoryEventID = (TraceEventID)3308;
        private const TraceEventID QueryCompositionExecutedEventID = (TraceEventID)3309;
        private const TraceEventID DispatchFailedEventID = (TraceEventID)3310;
        private const TraceEventID DispatchSuccessfulEventID = (TraceEventID)3311;
        private const TraceEventID MessageReadByEncoderEventID = (TraceEventID)3312;
        private const TraceEventID MessageWrittenByEncoderEventID = (TraceEventID)3313;
        private const TraceEventID SessionIdleTimeoutEventID = (TraceEventID)3314;
        private const TraceEventID SocketAcceptEnqueuedEventID = (TraceEventID)3319;
        private const TraceEventID SocketAcceptedEventID = (TraceEventID)3320;
        private const TraceEventID ConnectionPoolMissEventID = (TraceEventID)3321;
        private const TraceEventID DispatchFormatterDeserializeRequestStartEventID = (TraceEventID)3322;
        private const TraceEventID DispatchFormatterDeserializeRequestStopEventID = (TraceEventID)3323;
        private const TraceEventID DispatchFormatterSerializeReplyStartEventID = (TraceEventID)3324;
        private const TraceEventID DispatchFormatterSerializeReplyStopEventID = (TraceEventID)3325;
        private const TraceEventID ClientFormatterSerializeRequestStartEventID = (TraceEventID)3326;
        private const TraceEventID ClientFormatterSerializeRequestStopEventID = (TraceEventID)3327;
        private const TraceEventID ClientFormatterDeserializeReplyStartEventID = (TraceEventID)3328;
        private const TraceEventID ClientFormatterDeserializeReplyStopEventID = (TraceEventID)3329;
        private const TraceEventID SecurityNegotiationStartEventID = (TraceEventID)3330;
        private const TraceEventID SecurityNegotiationStopEventID = (TraceEventID)3331;
        private const TraceEventID SecurityTokenProviderOpenedEventID = (TraceEventID)3332;
        private const TraceEventID OutgoingMessageSecuredEventID = (TraceEventID)3333;
        private const TraceEventID IncomingMessageVerifiedEventID = (TraceEventID)3334;
        private const TraceEventID GetServiceInstanceStartEventID = (TraceEventID)3335;
        private const TraceEventID GetServiceInstanceStopEventID = (TraceEventID)3336;
        private const TraceEventID ChannelReceiveStartEventID = (TraceEventID)3337;
        private const TraceEventID ChannelReceiveStopEventID = (TraceEventID)3338;
        private const TraceEventID ChannelFactoryCreatedEventID = (TraceEventID)3339;
        private const TraceEventID PipeConnectionAcceptStartEventID = (TraceEventID)3340;
        private const TraceEventID PipeConnectionAcceptStopEventID = (TraceEventID)3341;
        private const TraceEventID EstablishConnectionStartEventID = (TraceEventID)3342;
        private const TraceEventID EstablishConnectionStopEventID = (TraceEventID)3343;
        private const TraceEventID SessionPreambleUnderstoodEventID = (TraceEventID)3345;
        private const TraceEventID ConnectionReaderSendFaultEventID = (TraceEventID)3346;
        private const TraceEventID SocketAcceptClosedEventID = (TraceEventID)3347;
        private const TraceEventID ServiceHostFaultedEventID = (TraceEventID)3348;
        private const TraceEventID ListenerOpenStartEventID = (TraceEventID)3349;
        private const TraceEventID ListenerOpenStopEventID = (TraceEventID)3350;
        private const TraceEventID ServerMaxPooledConnectionsQuotaReachedEventID = (TraceEventID)3351;
        private const TraceEventID TcpConnectionTimedOutEventID = (TraceEventID)3352;
        private const TraceEventID TcpConnectionResetErrorEventID = (TraceEventID)3353;
        private const TraceEventID ServiceSecurityNegotiationCompletedEventID = (TraceEventID)3354;
        private const TraceEventID SecurityNegotiationProcessingFailureEventID = (TraceEventID)3355;
        private const TraceEventID SecurityIdentityVerificationSuccessEventID = (TraceEventID)3356;
        private const TraceEventID SecurityIdentityVerificationFailureEventID = (TraceEventID)3357;
        private const TraceEventID PortSharingDuplicatedSocketEventID = (TraceEventID)3358;
        private const TraceEventID SecurityImpersonationSuccessEventID = (TraceEventID)3359;
        private const TraceEventID SecurityImpersonationFailureEventID = (TraceEventID)3360;
        private const TraceEventID HttpChannelRequestAbortedEventID = (TraceEventID)3361;
        private const TraceEventID HttpChannelResponseAbortedEventID = (TraceEventID)3362;
        private const TraceEventID HttpAuthFailedEventID = (TraceEventID)3363;
        private const TraceEventID SharedListenerProxyRegisterStartEventID = (TraceEventID)3364;
        private const TraceEventID SharedListenerProxyRegisterStopEventID = (TraceEventID)3365;
        private const TraceEventID SharedListenerProxyRegisterFailedEventID = (TraceEventID)3366;
        private const TraceEventID ConnectionPoolPreambleFailedEventID = (TraceEventID)3367;
        private const TraceEventID SslOnInitiateUpgradeEventID = (TraceEventID)3368;
        private const TraceEventID SslOnAcceptUpgradeEventID = (TraceEventID)3369;
        private const TraceEventID BinaryMessageEncodingStartEventID = (TraceEventID)3370;
        private const TraceEventID MtomMessageEncodingStartEventID = (TraceEventID)3371;
        private const TraceEventID TextMessageEncodingStartEventID = (TraceEventID)3372;
        private const TraceEventID BinaryMessageDecodingStartEventID = (TraceEventID)3373;
        private const TraceEventID MtomMessageDecodingStartEventID = (TraceEventID)3374;
        private const TraceEventID TextMessageDecodingStartEventID = (TraceEventID)3375;
        private const TraceEventID HttpResponseReceiveStartEventID = (TraceEventID)3376;
        private const TraceEventID SocketReadStopEventID = (TraceEventID)3377;
        private const TraceEventID SocketAsyncReadStopEventID = (TraceEventID)3378;
        private const TraceEventID SocketWriteStartEventID = (TraceEventID)3379;
        private const TraceEventID SocketAsyncWriteStartEventID = (TraceEventID)3380;
        private const TraceEventID SequenceAcknowledgementSentEventID = (TraceEventID)3381;
        private const TraceEventID ClientReliableSessionReconnectEventID = (TraceEventID)3382;
        private const TraceEventID ReliableSessionChannelFaultedEventID = (TraceEventID)3383;
        private const TraceEventID WindowsStreamSecurityOnInitiateUpgradeEventID = (TraceEventID)3384;
        private const TraceEventID WindowsStreamSecurityOnAcceptUpgradeEventID = (TraceEventID)3385;
        private const TraceEventID SocketConnectionAbortEventID = (TraceEventID)3386;
        private const TraceEventID HttpGetContextStartEventID = (TraceEventID)3388;
        private const TraceEventID ClientSendPreambleStartEventID = (TraceEventID)3389;
        private const TraceEventID ClientSendPreambleStopEventID = (TraceEventID)3390;
        private const TraceEventID HttpMessageReceiveFailedEventID = (TraceEventID)3391;
        private const TraceEventID TransactionScopeCreateEventID = (TraceEventID)3392;
        private const TraceEventID StreamedMessageReadByEncoderEventID = (TraceEventID)3393;
        private const TraceEventID StreamedMessageWrittenByEncoderEventID = (TraceEventID)3394;
        private const TraceEventID MessageWrittenAsynchronouslyByEncoderEventID = (TraceEventID)3395;
        private const TraceEventID BufferedAsyncWriteStartEventID = (TraceEventID)3396;
        private const TraceEventID BufferedAsyncWriteStopEventID = (TraceEventID)3397;
        private const TraceEventID PipeSharedMemoryCreatedEventID = (TraceEventID)3398;
        private const TraceEventID NamedPipeCreatedEventID = (TraceEventID)3399;
        private const TraceEventID SignatureVerificationStartEventID = (TraceEventID)3401;
        private const TraceEventID SignatureVerificationSuccessEventID = (TraceEventID)3402;
        private const TraceEventID WrappedKeyDecryptionStartEventID = (TraceEventID)3403;
        private const TraceEventID WrappedKeyDecryptionSuccessEventID = (TraceEventID)3404;
        private const TraceEventID EncryptedDataProcessingStartEventID = (TraceEventID)3405;
        private const TraceEventID EncryptedDataProcessingSuccessEventID = (TraceEventID)3406;
        private const TraceEventID HttpPipelineProcessInboundRequestStartEventID = (TraceEventID)3407;
        private const TraceEventID HttpPipelineBeginProcessInboundRequestStartEventID = (TraceEventID)3408;
        private const TraceEventID HttpPipelineProcessInboundRequestStopEventID = (TraceEventID)3409;
        private const TraceEventID HttpPipelineFaultedEventID = (TraceEventID)3410;
        private const TraceEventID HttpPipelineTimeoutExceptionEventID = (TraceEventID)3411;
        private const TraceEventID HttpPipelineProcessResponseStartEventID = (TraceEventID)3412;
        private const TraceEventID HttpPipelineBeginProcessResponseStartEventID = (TraceEventID)3413;
        private const TraceEventID HttpPipelineProcessResponseStopEventID = (TraceEventID)3414;
        private const TraceEventID WebSocketConnectionRequestSendStartEventID = (TraceEventID)3415;
        private const TraceEventID WebSocketConnectionRequestSendStopEventID = (TraceEventID)3416;
        private const TraceEventID WebSocketConnectionAcceptStartEventID = (TraceEventID)3417;
        private const TraceEventID WebSocketConnectionAcceptedEventID = (TraceEventID)3418;
        private const TraceEventID WebSocketConnectionDeclinedEventID = (TraceEventID)3419;
        private const TraceEventID WebSocketConnectionFailedEventID = (TraceEventID)3420;
        private const TraceEventID WebSocketConnectionAbortedEventID = (TraceEventID)3421;
        private const TraceEventID WebSocketAsyncWriteStartEventID = (TraceEventID)3422;
        private const TraceEventID WebSocketAsyncWriteStopEventID = (TraceEventID)3423;
        private const TraceEventID WebSocketAsyncReadStartEventID = (TraceEventID)3424;
        private const TraceEventID WebSocketAsyncReadStopEventID = (TraceEventID)3425;
        private const TraceEventID WebSocketCloseSentEventID = (TraceEventID)3426;
        private const TraceEventID WebSocketCloseOutputSentEventID = (TraceEventID)3427;
        private const TraceEventID WebSocketConnectionClosedEventID = (TraceEventID)3428;
        private const TraceEventID WebSocketCloseStatusReceivedEventID = (TraceEventID)3429;
        private const TraceEventID WebSocketUseVersionFromClientWebSocketFactoryEventID = (TraceEventID)3430;
        private const TraceEventID WebSocketCreateClientWebSocketWithFactoryEventID = (TraceEventID)3431;
        private const TraceEventID InferredContractDescriptionEventID = (TraceEventID)3501;
        private const TraceEventID InferredOperationDescriptionEventID = (TraceEventID)3502;
        private const TraceEventID DuplicateCorrelationQueryEventID = (TraceEventID)3503;
        private const TraceEventID ServiceEndpointAddedEventID = (TraceEventID)3507;
        private const TraceEventID TrackingProfileNotFoundEventID = (TraceEventID)3508;
        private const TraceEventID BufferOutOfOrderMessageNoInstanceEventID = (TraceEventID)3550;
        private const TraceEventID BufferOutOfOrderMessageNoBookmarkEventID = (TraceEventID)3551;
        private const TraceEventID MaxPendingMessagesPerChannelExceededEventID = (TraceEventID)3552;
        private const TraceEventID XamlServicesLoadStartEventID = (TraceEventID)3553;
        private const TraceEventID XamlServicesLoadStopEventID = (TraceEventID)3554;
        private const TraceEventID CreateWorkflowServiceHostStartEventID = (TraceEventID)3555;
        private const TraceEventID CreateWorkflowServiceHostStopEventID = (TraceEventID)3556;
        private const TraceEventID TransactedReceiveScopeEndCommitFailedEventID = (TraceEventID)3557;
        private const TraceEventID ServiceActivationStartEventID = (TraceEventID)3558;
        private const TraceEventID ServiceActivationStopEventID = (TraceEventID)3559;
        private const TraceEventID ServiceActivationAvailableMemoryEventID = (TraceEventID)3560;
        private const TraceEventID ServiceActivationExceptionEventID = (TraceEventID)3561;
        private const TraceEventID RoutingServiceClosingClientEventID = (TraceEventID)3800;
        private const TraceEventID RoutingServiceChannelFaultedEventID = (TraceEventID)3801;
        private const TraceEventID RoutingServiceCompletingOneWayEventID = (TraceEventID)3802;
        private const TraceEventID RoutingServiceProcessingFailureEventID = (TraceEventID)3803;
        private const TraceEventID RoutingServiceCreatingClientForEndpointEventID = (TraceEventID)3804;
        private const TraceEventID RoutingServiceDisplayConfigEventID = (TraceEventID)3805;
        private const TraceEventID RoutingServiceCompletingTwoWayEventID = (TraceEventID)3807;
        private const TraceEventID RoutingServiceMessageRoutedToEndpointsEventID = (TraceEventID)3809;
        private const TraceEventID RoutingServiceConfigurationAppliedEventID = (TraceEventID)3810;
        private const TraceEventID RoutingServiceProcessingMessageEventID = (TraceEventID)3815;
        private const TraceEventID RoutingServiceTransmittingMessageEventID = (TraceEventID)3816;
        private const TraceEventID RoutingServiceCommittingTransactionEventID = (TraceEventID)3817;
        private const TraceEventID RoutingServiceDuplexCallbackExceptionEventID = (TraceEventID)3818;
        private const TraceEventID RoutingServiceMovedToBackupEventID = (TraceEventID)3819;
        private const TraceEventID RoutingServiceCreatingTransactionEventID = (TraceEventID)3820;
        private const TraceEventID RoutingServiceCloseFailedEventID = (TraceEventID)3821;
        private const TraceEventID RoutingServiceSendingResponseEventID = (TraceEventID)3822;
        private const TraceEventID RoutingServiceSendingFaultResponseEventID = (TraceEventID)3823;
        private const TraceEventID RoutingServiceCompletingReceiveContextEventID = (TraceEventID)3824;
        private const TraceEventID RoutingServiceAbandoningReceiveContextEventID = (TraceEventID)3825;
        private const TraceEventID RoutingServiceUsingExistingTransactionEventID = (TraceEventID)3826;
        private const TraceEventID RoutingServiceTransmitFailedEventID = (TraceEventID)3827;
        private const TraceEventID RoutingServiceFilterTableMatchStartEventID = (TraceEventID)3828;
        private const TraceEventID RoutingServiceFilterTableMatchStopEventID = (TraceEventID)3829;
        private const TraceEventID RoutingServiceAbortingChannelEventID = (TraceEventID)3830;
        private const TraceEventID RoutingServiceHandledExceptionEventID = (TraceEventID)3831;
        private const TraceEventID RoutingServiceTransmitSucceededEventID = (TraceEventID)3832;
        private const TraceEventID TransportListenerSessionsReceivedEventID = (TraceEventID)4001;
        private const TraceEventID FailFastExceptionEventID = (TraceEventID)4002;
        private const TraceEventID ServiceStartPipeErrorEventID = (TraceEventID)4003;
        private const TraceEventID DispatchSessionStartEventID = (TraceEventID)4008;
        private const TraceEventID PendingSessionQueueFullEventID = (TraceEventID)4010;
        private const TraceEventID MessageQueueRegisterStartEventID = (TraceEventID)4011;
        private const TraceEventID MessageQueueRegisterAbortEventID = (TraceEventID)4012;
        private const TraceEventID MessageQueueUnregisterSucceededEventID = (TraceEventID)4013;
        private const TraceEventID MessageQueueRegisterFailedEventID = (TraceEventID)4014;
        private const TraceEventID MessageQueueRegisterCompletedEventID = (TraceEventID)4015;
        private const TraceEventID MessageQueueDuplicatedSocketErrorEventID = (TraceEventID)4016;
        private const TraceEventID MessageQueueDuplicatedSocketCompleteEventID = (TraceEventID)4019;
        private const TraceEventID TcpTransportListenerListeningStartEventID = (TraceEventID)4020;
        private const TraceEventID TcpTransportListenerListeningStopEventID = (TraceEventID)4021;
        private const TraceEventID WebhostUnregisterProtocolFailedEventID = (TraceEventID)4022;
        private const TraceEventID WasCloseAllListenerChannelInstancesCompletedEventID = (TraceEventID)4023;
        private const TraceEventID WasCloseAllListenerChannelInstancesFailedEventID = (TraceEventID)4024;
        private const TraceEventID OpenListenerChannelInstanceFailedEventID = (TraceEventID)4025;
        private const TraceEventID WasConnectedEventID = (TraceEventID)4026;
        private const TraceEventID WasDisconnectedEventID = (TraceEventID)4027;
        private const TraceEventID PipeTransportListenerListeningStartEventID = (TraceEventID)4028;
        private const TraceEventID PipeTransportListenerListeningStopEventID = (TraceEventID)4029;
        private const TraceEventID DispatchSessionSuccessEventID = (TraceEventID)4030;
        private const TraceEventID DispatchSessionFailedEventID = (TraceEventID)4031;
        private const TraceEventID WasConnectionTimedoutEventID = (TraceEventID)4032;
        private const TraceEventID RoutingTableLookupStartEventID = (TraceEventID)4033;
        private const TraceEventID RoutingTableLookupStopEventID = (TraceEventID)4034;
        private const TraceEventID PendingSessionQueueRatioEventID = (TraceEventID)4035;
        private const TraceEventID EndSqlCommandExecuteEventID = (TraceEventID)4201;
        private const TraceEventID StartSqlCommandExecuteEventID = (TraceEventID)4202;
        private const TraceEventID RenewLockSystemErrorEventID = (TraceEventID)4203;
        private const TraceEventID FoundProcessingErrorEventID = (TraceEventID)4205;
        private const TraceEventID UnlockInstanceExceptionEventID = (TraceEventID)4206;
        private const TraceEventID MaximumRetriesExceededForSqlCommandEventID = (TraceEventID)4207;
        private const TraceEventID RetryingSqlCommandDueToSqlErrorEventID = (TraceEventID)4208;
        private const TraceEventID TimeoutOpeningSqlConnectionEventID = (TraceEventID)4209;
        private const TraceEventID SqlExceptionCaughtEventID = (TraceEventID)4210;
        private const TraceEventID QueuingSqlRetryEventID = (TraceEventID)4211;
        private const TraceEventID LockRetryTimeoutEventID = (TraceEventID)4212;
        private const TraceEventID RunnableInstancesDetectionErrorEventID = (TraceEventID)4213;
        private const TraceEventID InstanceLocksRecoveryErrorEventID = (TraceEventID)4214;
        private const TraceEventID MessageLogEventSizeExceededEventID = (TraceEventID)4600;
        private const TraceEventID DiscoveryClientInClientChannelFailedToCloseEventID = (TraceEventID)4801;
        private const TraceEventID DiscoveryClientProtocolExceptionSuppressedEventID = (TraceEventID)4802;
        private const TraceEventID DiscoveryClientReceivedMulticastSuppressionEventID = (TraceEventID)4803;
        private const TraceEventID DiscoveryMessageReceivedAfterOperationCompletedEventID = (TraceEventID)4804;
        private const TraceEventID DiscoveryMessageWithInvalidContentEventID = (TraceEventID)4805;
        private const TraceEventID DiscoveryMessageWithInvalidRelatesToOrOperationCompletedEventID = (TraceEventID)4806;
        private const TraceEventID DiscoveryMessageWithInvalidReplyToEventID = (TraceEventID)4807;
        private const TraceEventID DiscoveryMessageWithNoContentEventID = (TraceEventID)4808;
        private const TraceEventID DiscoveryMessageWithNullMessageIdEventID = (TraceEventID)4809;
        private const TraceEventID DiscoveryMessageWithNullMessageSequenceEventID = (TraceEventID)4810;
        private const TraceEventID DiscoveryMessageWithNullRelatesToEventID = (TraceEventID)4811;
        private const TraceEventID DiscoveryMessageWithNullReplyToEventID = (TraceEventID)4812;
        private const TraceEventID DuplicateDiscoveryMessageEventID = (TraceEventID)4813;
        private const TraceEventID EndpointDiscoverabilityDisabledEventID = (TraceEventID)4814;
        private const TraceEventID EndpointDiscoverabilityEnabledEventID = (TraceEventID)4815;
        private const TraceEventID FindInitiatedInDiscoveryClientChannelEventID = (TraceEventID)4816;
        private const TraceEventID InnerChannelCreationFailedEventID = (TraceEventID)4817;
        private const TraceEventID InnerChannelOpenFailedEventID = (TraceEventID)4818;
        private const TraceEventID InnerChannelOpenSucceededEventID = (TraceEventID)4819;
        private const TraceEventID SynchronizationContextResetEventID = (TraceEventID)4820;
        private const TraceEventID SynchronizationContextSetToNullEventID = (TraceEventID)4821;
        private const TraceEventID DCSerializeWithSurrogateStartEventID = (TraceEventID)5001;
        private const TraceEventID DCSerializeWithSurrogateStopEventID = (TraceEventID)5002;
        private const TraceEventID DCDeserializeWithSurrogateStartEventID = (TraceEventID)5003;
        private const TraceEventID DCDeserializeWithSurrogateStopEventID = (TraceEventID)5004;
        private const TraceEventID ImportKnownTypesStartEventID = (TraceEventID)5005;
        private const TraceEventID ImportKnownTypesStopEventID = (TraceEventID)5006;
        private const TraceEventID DCResolverResolveEventID = (TraceEventID)5007;
        private const TraceEventID DCGenWriterStartEventID = (TraceEventID)5008;
        private const TraceEventID DCGenWriterStopEventID = (TraceEventID)5009;
        private const TraceEventID DCGenReaderStartEventID = (TraceEventID)5010;
        private const TraceEventID DCGenReaderStopEventID = (TraceEventID)5011;
        private const TraceEventID DCJsonGenReaderStartEventID = (TraceEventID)5012;
        private const TraceEventID DCJsonGenReaderStopEventID = (TraceEventID)5013;
        private const TraceEventID DCJsonGenWriterStartEventID = (TraceEventID)5014;
        private const TraceEventID DCJsonGenWriterStopEventID = (TraceEventID)5015;
        private const TraceEventID GenXmlSerializableStartEventID = (TraceEventID)5016;
        private const TraceEventID GenXmlSerializableStopEventID = (TraceEventID)5017;
        private const TraceEventID JsonMessageDecodingStartEventID = (TraceEventID)5203;
        private const TraceEventID JsonMessageEncodingStartEventID = (TraceEventID)5204;
        private const TraceEventID TokenValidationStartedEventID = (TraceEventID)5402;
        private const TraceEventID TokenValidationSuccessEventID = (TraceEventID)5403;
        private const TraceEventID TokenValidationFailureEventID = (TraceEventID)5404;
        private const TraceEventID GetIssuerNameSuccessEventID = (TraceEventID)5405;
        private const TraceEventID GetIssuerNameFailureEventID = (TraceEventID)5406;
        private const TraceEventID FederationMessageProcessingStartedEventID = (TraceEventID)5600;
        private const TraceEventID FederationMessageProcessingSuccessEventID = (TraceEventID)5601;
        private const TraceEventID FederationMessageCreationStartedEventID = (TraceEventID)5602;
        private const TraceEventID FederationMessageCreationSuccessEventID = (TraceEventID)5603;
        private const TraceEventID SessionCookieReadingStartedEventID = (TraceEventID)5604;
        private const TraceEventID SessionCookieReadingSuccessEventID = (TraceEventID)5605;
        private const TraceEventID PrincipalSettingFromSessionTokenStartedEventID = (TraceEventID)5606;
        private const TraceEventID PrincipalSettingFromSessionTokenSuccessEventID = (TraceEventID)5607;
        private const TraceEventID TrackingRecordDroppedEventID = (TraceEventID)39456;
        private const TraceEventID TrackingRecordRaisedEventID = (TraceEventID)39457;
        private const TraceEventID TrackingRecordTruncatedEventID = (TraceEventID)39458;
        private const TraceEventID TrackingDataExtractedEventID = (TraceEventID)39459;
        private const TraceEventID TrackingValueNotSerializableEventID = (TraceEventID)39460;
        private const TraceEventID AppDomainUnloadEventID = (TraceEventID)57393;
        private const TraceEventID HandledExceptionEventID = (TraceEventID)57394;
        private const TraceEventID ShipAssertExceptionMessageEventID = (TraceEventID)57395;
        private const TraceEventID ThrowingExceptionEventID = (TraceEventID)57396;
        private const TraceEventID UnhandledExceptionEventID = (TraceEventID)57397;
        private const TraceEventID MaxInstancesExceededEventID = (TraceEventID)57398;
        private const TraceEventID TraceCodeEventLogCriticalEventID = (TraceEventID)57399;
        private const TraceEventID TraceCodeEventLogErrorEventID = (TraceEventID)57400;
        private const TraceEventID TraceCodeEventLogInfoEventID = (TraceEventID)57401;
        private const TraceEventID TraceCodeEventLogVerboseEventID = (TraceEventID)57402;
        private const TraceEventID TraceCodeEventLogWarningEventID = (TraceEventID)57403;
        private const TraceEventID HandledExceptionWarningEventID = (TraceEventID)57404;
        private const TraceEventID HandledExceptionErrorEventID = (TraceEventID)57405;
        private const TraceEventID HandledExceptionVerboseEventID = (TraceEventID)57406;
        private const TraceEventID ThrowingExceptionVerboseEventID = (TraceEventID)57407;
        private const TraceEventID EtwUnhandledExceptionEventID = (TraceEventID)57408;
        private const TraceEventID ThrowingEtwExceptionVerboseEventID = (TraceEventID)57409;
        private const TraceEventID ThrowingEtwExceptionEventID = (TraceEventID)57410;
        private const TraceEventID HttpHandlerPickedForUrlEventID = (TraceEventID)62326;
        #endregion

        #region private
        protected override string GetProviderName() { return ProviderName; }
        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[464];
                templates[0] = new Multidata9TemplateHATraceData(null, 100, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[1] = new Multidata10TemplateHATraceData(null, 101, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 150, "UnhandledExceptionRecord", ProviderGuid, ProviderName);
                templates[2] = new Multidata8TemplateHATraceData(null, 102, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 144, "AbortedRecord", ProviderGuid, ProviderName);
                templates[3] = new Multidata4TemplateHATraceData(null, 103, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[4] = new Multidata3TemplateHATraceData(null, 104, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[5] = new Multidata6TemplateHATraceData(null, 105, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[6] = new Multidata3TemplateHATraceData(null, 106, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[7] = new Multidata5TemplateHATraceData(null, 107, 2609, "WorkflowTracking", WorkflowTrackingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[8] = new Multidata7TemplateHATraceData(null, 108, 2527, "CustomTrackingRecord", CustomTrackingRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[9] = new Multidata7TemplateHATraceData(null, 110, 2527, "CustomTrackingRecord", CustomTrackingRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[10] = new Multidata7TemplateHATraceData(null, 111, 2527, "CustomTrackingRecord", CustomTrackingRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[11] = new Multidata8TemplateHATraceData(null, 112, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 146, "SuspendedRecord", ProviderGuid, ProviderName);
                templates[12] = new Multidata8TemplateHATraceData(null, 113, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 148, "TerminatedRecord", ProviderGuid, ProviderName);
                templates[13] = new Multidata11TemplateHATraceData(null, 114, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[14] = new Multidata12TemplateHATraceData(null, 115, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 145, "AbortedWithId", ProviderGuid, ProviderName);
                templates[15] = new Multidata12TemplateHATraceData(null, 116, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 147, "SuspendedWithId", ProviderGuid, ProviderName);
                templates[16] = new Multidata12TemplateHATraceData(null, 117, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 149, "TerminatedWithId", ProviderGuid, ProviderName);
                templates[17] = new Multidata13TemplateHATraceData(null, 118, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 151, "UnhandledExceptionWithId", ProviderGuid, ProviderName);
                templates[18] = new Multidata14TemplateHATraceData(null, 119, 2608, "WorkflowInstanceRecord", WorkflowInstanceRecordTaskGuid, 152, "UpdatedRecord", ProviderGuid, ProviderName);
                templates[19] = new Multidata1TemplateATraceData(null, 131, 2509, "BufferPooling", BufferPoolingTaskGuid, 12, "Allocate", ProviderGuid, ProviderName);
                templates[20] = new Multidata2TemplateATraceData(null, 132, 2509, "BufferPooling", BufferPoolingTaskGuid, 13, "Tune", ProviderGuid, ProviderName);
                templates[21] = new OneStringsTemplateATraceData(null, 133, 2593, "ThreadScheduling", ThreadSchedulingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[22] = new OneStringsTemplateATraceData(null, 134, 2593, "ThreadScheduling", ThreadSchedulingTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[23] = new Multidata23TemplateHATraceData(null, 201, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 16, "ClientMessageInspectorAfterReceiveInvoked", ProviderGuid, ProviderName);
                templates[24] = new Multidata23TemplateHATraceData(null, 202, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 17, "ClientMessageInspectorBeforeSendInvoked", ProviderGuid, ProviderName);
                templates[25] = new Multidata23TemplateHATraceData(null, 203, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 19, "ClientParameterInspectorStop", ProviderGuid, ProviderName);
                templates[26] = new Multidata23TemplateHATraceData(null, 204, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 18, "ClientParameterInspectorStart", ProviderGuid, ProviderName);
                templates[27] = new Multidata24TemplateHATraceData(null, 205, 2533, "DispatchMessage", DispatchMessageTaskGuid, 53, "OperationInvokerStart", ProviderGuid, ProviderName);
                templates[28] = new Multidata25TemplateHATraceData(null, 206, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[29] = new Multidata26TemplateHATraceData(null, 207, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[30] = new Multidata23TemplateHATraceData(null, 208, 2533, "DispatchMessage", DispatchMessageTaskGuid, 51, "DispathMessageInspectorAfterReceiveInvoked", ProviderGuid, ProviderName);
                templates[31] = new Multidata23TemplateHATraceData(null, 209, 2533, "DispatchMessage", DispatchMessageTaskGuid, 52, "DispathMessageInspectorBeforeSendInvoked", ProviderGuid, ProviderName);
                templates[32] = new Multidata27TemplateHATraceData(null, 210, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[33] = new Multidata23TemplateHATraceData(null, 211, 2533, "DispatchMessage", DispatchMessageTaskGuid, 56, "ParameterInspectorStop", ProviderGuid, ProviderName);
                templates[34] = new Multidata23TemplateHATraceData(null, 212, 2533, "DispatchMessage", DispatchMessageTaskGuid, 55, "ParameterInspectorStart", ProviderGuid, ProviderName);
                templates[35] = new Multidata72TemplateHATraceData(null, 213, 2578, "ServiceHostActivation", ServiceHostActivationTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[36] = new Multidata28TemplateHATraceData(null, 214, 2533, "DispatchMessage", DispatchMessageTaskGuid, 54, "OperationInvokerStop", ProviderGuid, ProviderName);
                templates[37] = new Multidata29TemplateHATraceData(null, 215, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[38] = new Multidata30TemplateHATraceData(null, 216, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[39] = new Multidata22TemplateHATraceData(null, 217, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 20, "OperationPrepared", ProviderGuid, ProviderName);
                templates[40] = new Multidata22TemplateHATraceData(null, 218, 2576, "ServiceChannelCall", ServiceChannelCallTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[41] = new Multidata31TemplateHATraceData(null, 219, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[42] = new Multidata32TemplateHATraceData(null, 220, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[43] = new Multidata32TemplateHATraceData(null, 221, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[44] = new Multidata28TemplateHATraceData(null, 222, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[45] = new Multidata28TemplateHATraceData(null, 223, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[46] = new Multidata27TemplateHATraceData(null, 224, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[47] = new Multidata86TemplateHATraceData(null, 225, 2523, "Correlation", CorrelationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[48] = new Multidata73TemplateATraceData(null, 226, 2585, "ServiceShutdown", ServiceShutdownTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[49] = new UserEventsTemplateTraceData(null, 301, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[50] = new UserEventsTemplateTraceData(null, 302, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[51] = new UserEventsTemplateTraceData(null, 303, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[52] = new TwoStringsTemplateTATraceData(null, 401, 2588, "Signpost", SignpostTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[53] = new TwoStringsTemplateTATraceData(null, 402, 2588, "Signpost", SignpostTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[54] = new TwoStringsTemplateTATraceData(null, 403, 2588, "Signpost", SignpostTaskGuid, 8, "Suspend", ProviderGuid, ProviderName);
                templates[55] = new TwoStringsTemplateTATraceData(null, 404, 2588, "Signpost", SignpostTaskGuid, 7, "Resume", ProviderGuid, ProviderName);
                templates[56] = new TwoStringsTemplateTATraceData(null, 440, 2588, "Signpost", SignpostTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[57] = new TwoStringsTemplateTATraceData(null, 441, 2588, "Signpost", SignpostTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[58] = new TwoStringsTemplateATraceData(null, 451, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[59] = new TwoStringsTemplateATraceData(null, 452, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[60] = new TransferEmittedTemplateTraceData(null, 499, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[61] = new OneStringsTemplateATraceData(null, 501, 2579, "ServiceHostCompilation", ServiceHostCompilationTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[62] = new OneStringsTemplateATraceData(null, 502, 2579, "ServiceHostCompilation", ServiceHostCompilationTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[63] = new OneStringsTemplateATraceData(null, 503, 2581, "ServiceHostFactoryCreation", ServiceHostFactoryCreationTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[64] = new OneStringsTemplateATraceData(null, 504, 2581, "ServiceHostFactoryCreation", ServiceHostFactoryCreationTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[65] = new OneStringsTemplateATraceData(null, 505, 2580, "ServiceHostCreate", ServiceHostCreateTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[66] = new OneStringsTemplateATraceData(null, 506, 2580, "ServiceHostCreate", ServiceHostCreateTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[67] = new OneStringsTemplateATraceData(null, 507, 2546, "HostedTransportConfigurationManagerConfigInit", HostedTransportConfigurationManagerConfigInitTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[68] = new OneStringsTemplateATraceData(null, 508, 2546, "HostedTransportConfigurationManagerConfigInit", HostedTransportConfigurationManagerConfigInitTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[69] = new OneStringsTemplateATraceData(null, 509, 2583, "ServiceHostOpen", ServiceHostOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[70] = new OneStringsTemplateATraceData(null, 510, 2583, "ServiceHostOpen", ServiceHostOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[71] = new Multidata69TemplateATraceData(null, 513, 2604, "WebHostRequest", WebHostRequestTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[72] = new OneStringsTemplateATraceData(null, 514, 2604, "WebHostRequest", WebHostRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[73] = new Multidata74TemplateATraceData(null, 601, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[74] = new Multidata70TemplateATraceData(null, 602, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[75] = new Multidata70TemplateATraceData(null, 603, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[76] = new Multidata71TemplateATraceData(null, 604, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[77] = new Multidata75TemplateATraceData(null, 605, 2604, "WebHostRequest", WebHostRequestTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[78] = new Multidata75TemplateATraceData(null, 606, 2604, "WebHostRequest", WebHostRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[79] = new OneStringsTemplateATraceData(null, 701, 2577, "ServiceChannelOpen", ServiceChannelOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[80] = new OneStringsTemplateATraceData(null, 702, 2577, "ServiceChannelOpen", ServiceChannelOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[81] = new OneStringsTemplateATraceData(null, 703, 2576, "ServiceChannelCall", ServiceChannelCallTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[82] = new OneStringsTemplateATraceData(null, 704, 2576, "ServiceChannelCall", ServiceChannelCallTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[83] = new OneStringsTemplateATraceData(null, 706, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[84] = new OneStringsTemplateATraceData(null, 707, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[85] = new OneStringsTemplateATraceData(null, 708, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[86] = new TwoStringsTemplateVATraceData(null, 709, 2533, "DispatchMessage", DispatchMessageTaskGuid, 49, "DispatchStart", ProviderGuid, ProviderName);
                templates[87] = new OneStringsTemplateATraceData(null, 710, 2599, "TransportReceive", TransportReceiveTaskGuid, 128, "BeforeAuthentication", ProviderGuid, ProviderName);
                templates[88] = new OneStringsTemplateATraceData(null, 711, 2533, "DispatchMessage", DispatchMessageTaskGuid, 48, "BeforeAuthorization", ProviderGuid, ProviderName);
                templates[89] = new OneStringsTemplateATraceData(null, 712, 2533, "DispatchMessage", DispatchMessageTaskGuid, 50, "DispatchStop", ProviderGuid, ProviderName);
                templates[90] = new OneStringsTemplateATraceData(null, 715, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 14, "ClientChannelOpenStart", ProviderGuid, ProviderName);
                templates[91] = new OneStringsTemplateATraceData(null, 716, 2514, "ClientRuntime", ClientRuntimeTaskGuid, 15, "ClientChannelOpenStop", ProviderGuid, ProviderName);
                templates[92] = new OneStringsTemplateATraceData(null, 717, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[93] = new TwoStringsTemplateATraceData(null, 1001, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 134, "Completed", ProviderGuid, ProviderName);
                templates[94] = new ThreeStringsTemplateEATraceData(null, 1002, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 140, "Terminated", ProviderGuid, ProviderName);
                templates[95] = new TwoStringsTemplateATraceData(null, 1003, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 137, "InstanceCanceled", ProviderGuid, ProviderName);
                templates[96] = new ThreeStringsTemplateEATraceData(null, 1004, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 136, "InstanceAborted", ProviderGuid, ProviderName);
                templates[97] = new TwoStringsTemplateATraceData(null, 1005, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 135, "Idled", ProviderGuid, ProviderName);
                templates[98] = new SixStringsTemplateEATraceData(null, 1006, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 141, "UnhandledException", ProviderGuid, ProviderName);
                templates[99] = new TwoStringsTemplateATraceData(null, 1007, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 139, "Persisted", ProviderGuid, ProviderName);
                templates[100] = new TwoStringsTemplateATraceData(null, 1008, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 142, "Unloaded", ProviderGuid, ProviderName);
                templates[101] = new SevenStringsTemplateATraceData(null, 1009, 2569, "ScheduleActivity", ScheduleActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[102] = new FiveStringsTemplateATraceData(null, 1010, 2517, "CompleteActivity", CompleteActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[103] = new FourStringsTemplateATraceData(null, 1011, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 110, "ScheduleExecuteActivity", ProviderGuid, ProviderName);
                templates[104] = new FourStringsTemplateATraceData(null, 1012, 2590, "StartWorkItem", StartWorkItemTaskGuid, 120, "StartExecuteActivity", ProviderGuid, ProviderName);
                templates[105] = new FourStringsTemplateATraceData(null, 1013, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 24, "CompleteExecuteActivity", ProviderGuid, ProviderName);
                templates[106] = new SevenStringsTemplateATraceData(null, 1014, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 109, "ScheduleCompletion", ProviderGuid, ProviderName);
                templates[107] = new SevenStringsTemplateATraceData(null, 1015, 2590, "StartWorkItem", StartWorkItemTaskGuid, 119, "StartCompletion", ProviderGuid, ProviderName);
                templates[108] = new SevenStringsTemplateATraceData(null, 1016, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 23, "CompleteCompletion", ProviderGuid, ProviderName);
                templates[109] = new FourStringsTemplateATraceData(null, 1017, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 108, "ScheduleCancelActivity", ProviderGuid, ProviderName);
                templates[110] = new FourStringsTemplateATraceData(null, 1018, 2590, "StartWorkItem", StartWorkItemTaskGuid, 118, "StartCancelActivity", ProviderGuid, ProviderName);
                templates[111] = new FourStringsTemplateATraceData(null, 1019, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 22, "CompleteCancelActivity", ProviderGuid, ProviderName);
                templates[112] = new SixStringsTemplateATraceData(null, 1020, 2524, "CreateBookmark", CreateBookmarkTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[113] = new SixStringsTemplateATraceData(null, 1021, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 107, "ScheduleBookmark", ProviderGuid, ProviderName);
                templates[114] = new SixStringsTemplateATraceData(null, 1022, 2590, "StartWorkItem", StartWorkItemTaskGuid, 117, "StartBookmark", ProviderGuid, ProviderName);
                templates[115] = new SixStringsTemplateATraceData(null, 1023, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 21, "CompleteBookmark", ProviderGuid, ProviderName);
                templates[116] = new TwoStringsTemplateATraceData(null, 1024, 2524, "CreateBookmark", CreateBookmarkTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[117] = new ThreeStringsTemplateATraceData(null, 1025, 2549, "InitializeBookmarkScope", InitializeBookmarkScopeTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[118] = new FourStringsTemplateATraceData(null, 1026, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 113, "ScheduleTransactionContext", ProviderGuid, ProviderName);
                templates[119] = new FourStringsTemplateATraceData(null, 1027, 2590, "StartWorkItem", StartWorkItemTaskGuid, 123, "StartTransactionContext", ProviderGuid, ProviderName);
                templates[120] = new FourStringsTemplateATraceData(null, 1028, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 27, "CompleteTransactionContext", ProviderGuid, ProviderName);
                templates[121] = new EightStringsTemplateEATraceData(null, 1029, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 111, "ScheduleFault", ProviderGuid, ProviderName);
                templates[122] = new EightStringsTemplateEATraceData(null, 1030, 2590, "StartWorkItem", StartWorkItemTaskGuid, 121, "StartFault", ProviderGuid, ProviderName);
                templates[123] = new EightStringsTemplateEATraceData(null, 1031, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 25, "CompleteFault", ProviderGuid, ProviderName);
                templates[124] = new FourStringsTemplateATraceData(null, 1032, 2570, "ScheduleWorkItem", ScheduleWorkItemTaskGuid, 112, "ScheduleRuntime", ProviderGuid, ProviderName);
                templates[125] = new FourStringsTemplateATraceData(null, 1033, 2590, "StartWorkItem", StartWorkItemTaskGuid, 122, "StartRuntime", ProviderGuid, ProviderName);
                templates[126] = new FourStringsTemplateATraceData(null, 1034, 2518, "CompleteWorkItem", CompleteWorkItemTaskGuid, 26, "CompleteRuntime", ProviderGuid, ProviderName);
                templates[127] = new SevenStringsTemplateATraceData(null, 1035, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 106, "Set", ProviderGuid, ProviderName);
                templates[128] = new FourStringsTemplateATraceData(null, 1036, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 105, "CompletionRequested", ProviderGuid, ProviderName);
                templates[129] = new TwoStringsTemplateATraceData(null, 1037, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 104, "Complete", ProviderGuid, ProviderName);
                templates[130] = new OneStringsTemplateATraceData(null, 1038, 2559, "NoPersistBlock", NoPersistBlockTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[131] = new OneStringsTemplateATraceData(null, 1039, 2559, "NoPersistBlock", NoPersistBlockTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[132] = new SixStringsTemplateATraceData(null, 1040, 2535, "ExecuteActivity", ExecuteActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[133] = new ThreeStringsTemplateATraceData(null, 1041, 2605, "WFApplicationStateChange", WFApplicationStateChangeTaskGuid, 138, "PersistableIdle", ProviderGuid, ProviderName);
                templates[134] = new Multidata17TemplateATraceData(null, 1101, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[135] = new Multidata17TemplateATraceData(null, 1102, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[136] = new Multidata17TemplateATraceData(null, 1103, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 8, "Suspend", ProviderGuid, ProviderName);
                templates[137] = new Multidata17TemplateATraceData(null, 1104, 2607, "WorkflowActivity", WorkflowActivityTaskGuid, 7, "Resume", ProviderGuid, ProviderName);
                templates[138] = new TwoStringsTemplateATraceData(null, 1124, 2551, "InvokeMethod", InvokeMethodTaskGuid, 73, "IsStatic", ProviderGuid, ProviderName);
                templates[139] = new TwoStringsTemplateATraceData(null, 1125, 2551, "InvokeMethod", InvokeMethodTaskGuid, 72, "IsNotStatic", ProviderGuid, ProviderName);
                templates[140] = new ThreeStringsTemplateATraceData(null, 1126, 2551, "InvokeMethod", InvokeMethodTaskGuid, 74, "ThrewException", ProviderGuid, ProviderName);
                templates[141] = new FourStringsTemplateATraceData(null, 1131, 2551, "InvokeMethod", InvokeMethodTaskGuid, 75, "UseAsyncPattern", ProviderGuid, ProviderName);
                templates[142] = new TwoStringsTemplateATraceData(null, 1132, 2551, "InvokeMethod", InvokeMethodTaskGuid, 71, "DoesNotUseAsyncPattern", ProviderGuid, ProviderName);
                templates[143] = new TwoStringsTemplateATraceData(null, 1140, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 11, "Begin", ProviderGuid, ProviderName);
                templates[144] = new TwoStringsTemplateATraceData(null, 1141, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 60, "Empty", ProviderGuid, ProviderName);
                templates[145] = new TwoStringsTemplateATraceData(null, 1143, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 61, "NextNull", ProviderGuid, ProviderName);
                templates[146] = new ThreeStringsTemplateATraceData(null, 1146, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 62, "SwitchCase", ProviderGuid, ProviderName);
                templates[147] = new TwoStringsTemplateATraceData(null, 1147, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 64, "SwitchDefault", ProviderGuid, ProviderName);
                templates[148] = new TwoStringsTemplateATraceData(null, 1148, 2536, "ExecuteFlowchart", ExecuteFlowchartTaskGuid, 63, "SwitchCaseNotFound", ProviderGuid, ProviderName);
                templates[149] = new ThreeStringsTemplateATraceData(null, 1150, 2516, "CompensationState", CompensationStateTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[150] = new TwoStringsTemplateATraceData(null, 1223, 2535, "ExecuteActivity", ExecuteActivityTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[151] = new TwoStringsTemplateATraceData(null, 1400, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[152] = new TwoStringsTemplateATraceData(null, 1401, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[153] = new Multidata56TemplateATraceData(null, 1402, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[154] = new Multidata56TemplateATraceData(null, 1403, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[155] = new TwoStringsTemplateATraceData(null, 1405, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[156] = new TwoStringsTemplateATraceData(null, 1406, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[157] = new TwoStringsTemplateATraceData(null, 1407, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[158] = new TwoStringsTemplateATraceData(null, 1409, 2596, "TimeoutException", TimeoutExceptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[159] = new TwoStringsTemplateATraceData(null, 1416, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[160] = new TwoStringsTemplateATraceData(null, 1417, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[161] = new TwoStringsTemplateATraceData(null, 1418, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[162] = new TwoStringsTemplateATraceData(null, 1419, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[163] = new TwoStringsTemplateATraceData(null, 1420, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[164] = new Multidata57TemplateATraceData(null, 1422, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[165] = new Multidata58TemplateATraceData(null, 1423, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[166] = new Multidata58TemplateATraceData(null, 1424, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[167] = new Multidata58TemplateATraceData(null, 1430, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[168] = new Multidata58TemplateATraceData(null, 1431, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[169] = new Multidata58TemplateATraceData(null, 1432, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[170] = new Multidata58TemplateATraceData(null, 1433, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[171] = new Multidata58TemplateATraceData(null, 1436, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[172] = new Multidata58TemplateATraceData(null, 1438, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[173] = new OneStringsTemplateATraceData(null, 1439, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[174] = new TwoStringsTemplateATraceData(null, 1441, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[175] = new TwoStringsTemplateATraceData(null, 1442, 2558, "MsmqQuotas", MsmqQuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[176] = new TwoStringsTemplateATraceData(null, 1443, 2558, "MsmqQuotas", MsmqQuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[177] = new Multidata59TemplateATraceData(null, 1445, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[178] = new Multidata59TemplateATraceData(null, 1446, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[179] = new OneStringsTemplateATraceData(null, 1449, 2606, "WFMessage", WFMessageTaskGuid, 240, "Receive", ProviderGuid, ProviderName);
                templates[180] = new OneStringsTemplateATraceData(null, 1450, 2606, "WFMessage", WFMessageTaskGuid, 9, "Send", ProviderGuid, ProviderName);
                templates[181] = new TwoStringsTemplateATraceData(null, 1451, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[182] = new OneStringsTemplateATraceData(null, 2021, 2537, "ExecuteWorkItem", ExecuteWorkItemTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[183] = new OneStringsTemplateATraceData(null, 2022, 2537, "ExecuteWorkItem", ExecuteWorkItemTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[184] = new OneStringsTemplateATraceData(null, 2023, 2554, "MessageChannelCache", MessageChannelCacheTaskGuid, 76, "Missed", ProviderGuid, ProviderName);
                templates[185] = new Multidata19TemplateATraceData(null, 2024, 2550, "InternalCacheMetadata", InternalCacheMetadataTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[186] = new Multidata19TemplateATraceData(null, 2025, 2550, "InternalCacheMetadata", InternalCacheMetadataTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[187] = new Multidata20TemplateATraceData(null, 2026, 2602, "VBExpressionCompile", VBExpressionCompileTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[188] = new Multidata21TemplateATraceData(null, 2027, 2510, "CacheRootMetadata", CacheRootMetadataTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[189] = new Multidata21TemplateATraceData(null, 2028, 2510, "CacheRootMetadata", CacheRootMetadataTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[190] = new OneStringsTemplateATraceData(null, 2029, 2602, "VBExpressionCompile", VBExpressionCompileTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[191] = new ThreeStringsTemplateATraceData(null, 2576, 2601, "TryCatchException", TryCatchExceptionTaskGuid, 131, "FromTry", ProviderGuid, ProviderName);
                templates[192] = new TwoStringsTemplateATraceData(null, 2577, 2601, "TryCatchException", TryCatchExceptionTaskGuid, 129, "DuringCancelation", ProviderGuid, ProviderName);
                templates[193] = new TwoStringsTemplateATraceData(null, 2578, 2601, "TryCatchException", TryCatchExceptionTaskGuid, 130, "FromCatchOrFinally", ProviderGuid, ProviderName);
                templates[194] = new Multidata33TemplateATraceData(null, 3300, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[195] = new Multidata33TemplateATraceData(null, 3301, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[196] = new TwoStringsTemplateSATraceData(null, 3302, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[197] = new Multidata34TemplateATraceData(null, 3303, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[198] = new Multidata35TemplateSATraceData(null, 3305, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[199] = new Multidata36TemplateSATraceData(null, 3306, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[200] = new TwoStringsTemplateSATraceData(null, 3307, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[201] = new TwoStringsTemplateSATraceData(null, 3308, 2511, "ChannelFactoryCaching", ChannelFactoryCachingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[202] = new Multidata37TemplateSATraceData(null, 3309, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[203] = new Multidata38TemplateHATraceData(null, 3310, 2533, "DispatchMessage", DispatchMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[204] = new Multidata38TemplateHATraceData(null, 3311, 2533, "DispatchMessage", DispatchMessageTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[205] = new Multidata39TemplateSATraceData(null, 3312, 2555, "MessageDecoding", MessageDecodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[206] = new Multidata39TemplateSATraceData(null, 3313, 2556, "MessageEncoding", MessageEncodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[207] = new Multidata40TemplateATraceData(null, 3314, 2595, "Timeout", TimeoutTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[208] = new OneStringsTemplateATraceData(null, 3319, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[209] = new Multidata41TemplateATraceData(null, 3320, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[210] = new Multidata42TemplateATraceData(null, 3321, 2522, "ConnectionPooling", ConnectionPoolingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[211] = new OneStringsTemplateATraceData(null, 3322, 2540, "FormatterDeserializeRequest", FormatterDeserializeRequestTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[212] = new OneStringsTemplateATraceData(null, 3323, 2540, "FormatterDeserializeRequest", FormatterDeserializeRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[213] = new OneStringsTemplateATraceData(null, 3324, 2541, "FormatterSerializeReply", FormatterSerializeReplyTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[214] = new OneStringsTemplateATraceData(null, 3325, 2541, "FormatterSerializeReply", FormatterSerializeReplyTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[215] = new OneStringsTemplateATraceData(null, 3326, 2542, "FormatterSerializeRequest", FormatterSerializeRequestTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[216] = new OneStringsTemplateATraceData(null, 3327, 2542, "FormatterSerializeRequest", FormatterSerializeRequestTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[217] = new OneStringsTemplateATraceData(null, 3328, 2539, "FormatterDeserializeReply", FormatterDeserializeReplyTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[218] = new OneStringsTemplateATraceData(null, 3329, 2539, "FormatterDeserializeReply", FormatterDeserializeReplyTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[219] = new OneStringsTemplateATraceData(null, 3330, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[220] = new OneStringsTemplateATraceData(null, 3331, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[221] = new OneStringsTemplateATraceData(null, 3332, 2571, "SecureMessage", SecureMessageTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[222] = new OneStringsTemplateATraceData(null, 3333, 2571, "SecureMessage", SecureMessageTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[223] = new OneStringsTemplateATraceData(null, 3334, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[224] = new OneStringsTemplateATraceData(null, 3335, 2584, "ServiceInstance", ServiceInstanceTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[225] = new OneStringsTemplateATraceData(null, 3336, 2584, "ServiceInstance", ServiceInstanceTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[226] = new Multidata43TemplateATraceData(null, 3337, 2513, "ChannelReceive", ChannelReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[227] = new Multidata43TemplateATraceData(null, 3338, 2513, "ChannelReceive", ChannelReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[228] = new TwoStringsTemplateSATraceData(null, 3339, 2512, "ChannelFactoryCreate", ChannelFactoryCreateTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[229] = new Multidata44TemplateATraceData(null, 3340, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[230] = new OneStringsTemplateATraceData(null, 3341, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[231] = new Multidata45TemplateATraceData(null, 3342, 2519, "Connect", ConnectTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[232] = new OneStringsTemplateATraceData(null, 3343, 2519, "Connect", ConnectTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[233] = new Multidata46TemplateATraceData(null, 3345, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[234] = new Multidata47TemplateATraceData(null, 3346, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[235] = new OneStringsTemplateATraceData(null, 3347, 2521, "ConnectionAccept", ConnectionAcceptTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[236] = new TwoStringsTemplateSATraceData(null, 3348, 2582, "ServiceHostFault", ServiceHostFaultTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[237] = new Multidata48TemplateATraceData(null, 3349, 2552, "ListenerOpen", ListenerOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[238] = new OneStringsTemplateATraceData(null, 3350, 2552, "ListenerOpen", ListenerOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[239] = new OneStringsTemplateATraceData(null, 3351, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[240] = new Multidata49TemplateATraceData(null, 3352, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[241] = new Multidata49TemplateATraceData(null, 3353, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[242] = new OneStringsTemplateATraceData(null, 3354, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[243] = new OneStringsTemplateATraceData(null, 3355, 2573, "SecurityNegotiation", SecurityNegotiationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[244] = new OneStringsTemplateATraceData(null, 3356, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[245] = new OneStringsTemplateATraceData(null, 3357, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[246] = new Multidata48TemplateATraceData(null, 3358, 2501, "ActivationDuplicateSocket", ActivationDuplicateSocketTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[247] = new OneStringsTemplateATraceData(null, 3359, 2572, "SecurityImpersonation", SecurityImpersonationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[248] = new OneStringsTemplateATraceData(null, 3360, 2572, "SecurityImpersonation", SecurityImpersonationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[249] = new OneStringsTemplateATraceData(null, 3361, 2599, "TransportReceive", TransportReceiveTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[250] = new OneStringsTemplateATraceData(null, 3362, 2600, "TransportSend", TransportSendTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[251] = new OneStringsTemplateATraceData(null, 3363, 2574, "SecurityVerification", SecurityVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[252] = new Multidata48TemplateATraceData(null, 3364, 2502, "ActivationListenerOpen", ActivationListenerOpenTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[253] = new OneStringsTemplateATraceData(null, 3365, 2502, "ActivationListenerOpen", ActivationListenerOpenTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[254] = new Multidata50TemplateATraceData(null, 3366, 2502, "ActivationListenerOpen", ActivationListenerOpenTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[255] = new OneStringsTemplateATraceData(null, 3367, 2586, "SessionStart", SessionStartTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[256] = new OneStringsTemplateATraceData(null, 3368, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 115, "Initiate", ProviderGuid, ProviderName);
                templates[257] = new OneStringsTemplateATraceData(null, 3369, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 114, "Accept", ProviderGuid, ProviderName);
                templates[258] = new OneStringsTemplateATraceData(null, 3370, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[259] = new OneStringsTemplateATraceData(null, 3371, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[260] = new OneStringsTemplateATraceData(null, 3372, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[261] = new OneStringsTemplateATraceData(null, 3373, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[262] = new OneStringsTemplateATraceData(null, 3374, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[263] = new OneStringsTemplateATraceData(null, 3375, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[264] = new OneStringsTemplateATraceData(null, 3376, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[265] = new Multidata51TemplateATraceData(null, 3377, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[266] = new Multidata51TemplateATraceData(null, 3378, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[267] = new Multidata51TemplateATraceData(null, 3379, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[268] = new Multidata51TemplateATraceData(null, 3380, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[269] = new Multidata52TemplateATraceData(null, 3381, 2561, "ReliableSession", ReliableSessionTaskGuid, 79, "SequenceAck", ProviderGuid, ProviderName);
                templates[270] = new Multidata52TemplateATraceData(null, 3382, 2561, "ReliableSession", ReliableSessionTaskGuid, 78, "Reconnect", ProviderGuid, ProviderName);
                templates[271] = new Multidata52TemplateATraceData(null, 3383, 2561, "ReliableSession", ReliableSessionTaskGuid, 77, "Faulted", ProviderGuid, ProviderName);
                templates[272] = new OneStringsTemplateATraceData(null, 3384, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 115, "Initiate", ProviderGuid, ProviderName);
                templates[273] = new OneStringsTemplateATraceData(null, 3385, 2587, "SessionUpgrade", SessionUpgradeTaskGuid, 114, "Accept", ProviderGuid, ProviderName);
                templates[274] = new Multidata53TemplateATraceData(null, 3386, 2520, "ConnectionAbort", ConnectionAbortTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[275] = new OneStringsTemplateATraceData(null, 3388, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[276] = new OneStringsTemplateATraceData(null, 3389, 2515, "ClientSendPreamble", ClientSendPreambleTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[277] = new OneStringsTemplateATraceData(null, 3390, 2515, "ClientSendPreamble", ClientSendPreambleTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[278] = new OneStringsTemplateATraceData(null, 3391, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[279] = new Multidata54TemplateATraceData(null, 3392, 2533, "DispatchMessage", DispatchMessageTaskGuid, 57, "TransactionScopeCreate", ProviderGuid, ProviderName);
                templates[280] = new OneStringsTemplateATraceData(null, 3393, 2555, "MessageDecoding", MessageDecodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[281] = new OneStringsTemplateATraceData(null, 3394, 2556, "MessageEncoding", MessageEncodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[282] = new OneStringsTemplateATraceData(null, 3395, 2556, "MessageEncoding", MessageEncodingTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[283] = new Multidata55TemplateATraceData(null, 3396, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[284] = new OneStringsTemplateATraceData(null, 3397, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[285] = new Multidata60TemplateATraceData(null, 3398, 2552, "ListenerOpen", ListenerOpenTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[286] = new Multidata61TemplateATraceData(null, 3399, 2552, "ListenerOpen", ListenerOpenTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[287] = new OneStringsTemplateATraceData(null, 3401, 2611, "SignatureVerification", SignatureVerificationTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[288] = new OneStringsTemplateATraceData(null, 3402, 2611, "SignatureVerification", SignatureVerificationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[289] = new OneStringsTemplateATraceData(null, 3403, 2614, "WrappedKeyDecryption", WrappedKeyDecryptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[290] = new OneStringsTemplateATraceData(null, 3404, 2614, "WrappedKeyDecryption", WrappedKeyDecryptionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[291] = new OneStringsTemplateATraceData(null, 3405, 2615, "EncryptedDataProcessing", EncryptedDataProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[292] = new OneStringsTemplateATraceData(null, 3406, 2615, "EncryptedDataProcessing", EncryptedDataProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[293] = new OneStringsTemplateATraceData(null, 3407, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[294] = new OneStringsTemplateATraceData(null, 3408, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[295] = new OneStringsTemplateATraceData(null, 3409, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[296] = new OneStringsTemplateATraceData(null, 3410, 2599, "TransportReceive", TransportReceiveTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[297] = new OneStringsTemplateATraceData(null, 3411, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[298] = new OneStringsTemplateATraceData(null, 3412, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[299] = new OneStringsTemplateATraceData(null, 3413, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[300] = new OneStringsTemplateATraceData(null, 3414, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[301] = new Multidata62TemplateATraceData(null, 3415, 2519, "Connect", ConnectTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[302] = new Multidata63TemplateATraceData(null, 3416, 2519, "Connect", ConnectTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[303] = new OneStringsTemplateATraceData(null, 3417, 2519, "Connect", ConnectTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[304] = new Multidata63TemplateATraceData(null, 3418, 2519, "Connect", ConnectTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[305] = new Multidata64TemplateATraceData(null, 3419, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[306] = new Multidata64TemplateATraceData(null, 3420, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[307] = new Multidata63TemplateATraceData(null, 3421, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[308] = new Multidata65TemplateATraceData(null, 3422, 2600, "TransportSend", TransportSendTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[309] = new Multidata63TemplateATraceData(null, 3423, 2600, "TransportSend", TransportSendTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[310] = new Multidata63TemplateATraceData(null, 3424, 2599, "TransportReceive", TransportReceiveTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[311] = new Multidata65TemplateATraceData(null, 3425, 2599, "TransportReceive", TransportReceiveTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[312] = new Multidata66TemplateATraceData(null, 3426, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[313] = new Multidata66TemplateATraceData(null, 3427, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[314] = new Multidata63TemplateATraceData(null, 3428, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[315] = new Multidata67TemplateATraceData(null, 3429, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[316] = new Multidata68TemplateATraceData(null, 3430, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[317] = new Multidata68TemplateATraceData(null, 3431, 2519, "Connect", ConnectTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[318] = new ThreeStringsTemplateATraceData(null, 3501, 2548, "InferDescription", InferDescriptionTaskGuid, 69, "Contract", ProviderGuid, ProviderName);
                templates[319] = new FourStringsTemplateATraceData(null, 3502, 2548, "InferDescription", InferDescriptionTaskGuid, 70, "Operation", ProviderGuid, ProviderName);
                templates[320] = new TwoStringsTemplateATraceData(null, 3503, 2523, "Correlation", CorrelationTaskGuid, 28, "DuplicateQuery", ProviderGuid, ProviderName);
                templates[321] = new FourStringsTemplateATraceData(null, 3507, 2507, "AddServiceEndpoint", AddServiceEndpointTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[322] = new Multidata85TemplateATraceData(null, 3508, 2597, "TrackingProfile", TrackingProfileTaskGuid, 124, "NotFound", ProviderGuid, ProviderName);
                templates[323] = new TwoStringsTemplateATraceData(null, 3550, 2508, "BufferOutOfOrder", BufferOutOfOrderTaskGuid, 11, "NoInstance", ProviderGuid, ProviderName);
                templates[324] = new ThreeStringsTemplateATraceData(null, 3551, 2508, "BufferOutOfOrder", BufferOutOfOrderTaskGuid, 10, "NoBookmark", ProviderGuid, ProviderName);
                templates[325] = new Multidata84TemplateATraceData(null, 3552, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[326] = new OneStringsTemplateATraceData(null, 3553, 2610, "XamlServicesLoad", XamlServicesLoadTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[327] = new OneStringsTemplateATraceData(null, 3554, 2610, "XamlServicesLoad", XamlServicesLoadTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[328] = new OneStringsTemplateATraceData(null, 3555, 2526, "CreateWorkflowServiceHost", CreateWorkflowServiceHostTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[329] = new OneStringsTemplateATraceData(null, 3556, 2526, "CreateWorkflowServiceHost", CreateWorkflowServiceHostTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[330] = new ThreeStringsTemplateATraceData(null, 3557, 2568, "RuntimeTransaction", RuntimeTransactionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[331] = new OneStringsTemplateATraceData(null, 3558, 2575, "ServiceActivation", ServiceActivationTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[332] = new OneStringsTemplateATraceData(null, 3559, 2575, "ServiceActivation", ServiceActivationTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[333] = new Multidata76TemplateATraceData(null, 3560, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[334] = new ThreeStringsTemplateEATraceData(null, 3561, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[335] = new TwoStringsTemplateATraceData(null, 3800, 2563, "RoutingServiceClient", RoutingServiceClientTaskGuid, 87, "Closing", ProviderGuid, ProviderName);
                templates[336] = new TwoStringsTemplateATraceData(null, 3801, 2563, "RoutingServiceClient", RoutingServiceClientTaskGuid, 86, "ChannelFaulted", ProviderGuid, ProviderName);
                templates[337] = new TwoStringsTemplateEATraceData(null, 3802, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 89, "CompletingOneWay", ProviderGuid, ProviderName);
                templates[338] = new ThreeStringsTemplateEATraceData(null, 3803, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 92, "ProcessingFailure", ProviderGuid, ProviderName);
                templates[339] = new TwoStringsTemplateATraceData(null, 3804, 2563, "RoutingServiceClient", RoutingServiceClientTaskGuid, 88, "CreatingForEndpoint", ProviderGuid, ProviderName);
                templates[340] = new FourStringsTemplateATraceData(null, 3805, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[341] = new OneStringsTemplateATraceData(null, 3807, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 90, "CompletingTwoWay", ProviderGuid, ProviderName);
                templates[342] = new ThreeStringsTemplateATraceData(null, 3809, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 94, "RoutedToEndpoints", ProviderGuid, ProviderName);
                templates[343] = new OneStringsTemplateATraceData(null, 3810, 2562, "RoutingService", RoutingServiceTaskGuid, 82, "ConfigurationApplied", ProviderGuid, ProviderName);
                templates[344] = new FiveStringsTemplateATraceData(null, 3815, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 93, "ProcessingMessage", ProviderGuid, ProviderName);
                templates[345] = new FourStringsTemplateATraceData(null, 3816, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 98, "TransmittingMessage", ProviderGuid, ProviderName);
                templates[346] = new TwoStringsTemplateATraceData(null, 3817, 2567, "RoutingServiceTransaction", RoutingServiceTransactionTaskGuid, 101, "CommittingTransaction", ProviderGuid, ProviderName);
                templates[347] = new ThreeStringsTemplateEATraceData(null, 3818, 2562, "RoutingService", RoutingServiceTaskGuid, 83, "DuplexCallbackException", ProviderGuid, ProviderName);
                templates[348] = new FourStringsTemplateATraceData(null, 3819, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 91, "MovedToBackup", ProviderGuid, ProviderName);
                templates[349] = new TwoStringsTemplateATraceData(null, 3820, 2567, "RoutingServiceTransaction", RoutingServiceTransactionTaskGuid, 102, "Creating", ProviderGuid, ProviderName);
                templates[350] = new ThreeStringsTemplateEATraceData(null, 3821, 2562, "RoutingService", RoutingServiceTaskGuid, 81, "CloseFailed", ProviderGuid, ProviderName);
                templates[351] = new TwoStringsTemplateATraceData(null, 3822, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 96, "SendingResponse", ProviderGuid, ProviderName);
                templates[352] = new TwoStringsTemplateATraceData(null, 3823, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 95, "SendingFaultResponse", ProviderGuid, ProviderName);
                templates[353] = new TwoStringsTemplateATraceData(null, 3824, 2566, "RoutingServiceReceiveContext", RoutingServiceReceiveContextTaskGuid, 100, "Completing", ProviderGuid, ProviderName);
                templates[354] = new TwoStringsTemplateATraceData(null, 3825, 2566, "RoutingServiceReceiveContext", RoutingServiceReceiveContextTaskGuid, 99, "Abandoning", ProviderGuid, ProviderName);
                templates[355] = new TwoStringsTemplateATraceData(null, 3826, 2567, "RoutingServiceTransaction", RoutingServiceTransactionTaskGuid, 103, "UsingExisting", ProviderGuid, ProviderName);
                templates[356] = new ThreeStringsTemplateEATraceData(null, 3827, 2562, "RoutingService", RoutingServiceTaskGuid, 85, "TransmitFailed", ProviderGuid, ProviderName);
                templates[357] = new OneStringsTemplateATraceData(null, 3828, 2564, "RoutingServiceFilterTableMatch", RoutingServiceFilterTableMatchTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[358] = new OneStringsTemplateATraceData(null, 3829, 2564, "RoutingServiceFilterTableMatch", RoutingServiceFilterTableMatchTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[359] = new TwoStringsTemplateATraceData(null, 3830, 2562, "RoutingService", RoutingServiceTaskGuid, 80, "AbortingChannel", ProviderGuid, ProviderName);
                templates[360] = new TwoStringsTemplateEATraceData(null, 3831, 2562, "RoutingService", RoutingServiceTaskGuid, 84, "HandledException", ProviderGuid, ProviderName);
                templates[361] = new FourStringsTemplateATraceData(null, 3832, 2565, "RoutingServiceMessage", RoutingServiceMessageTaskGuid, 97, "TransmitSucceeded", ProviderGuid, ProviderName);
                templates[362] = new Multidata77TemplateATraceData(null, 4001, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 240, "Receive", ProviderGuid, ProviderName);
                templates[363] = new TwoStringsTemplateEATraceData(null, 4002, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[364] = new Multidata78TemplateATraceData(null, 4003, 2505, "ActivationServiceStart", ActivationServiceStartTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[365] = new OneStringsTemplateATraceData(null, 4008, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[366] = new Multidata79TemplateATraceData(null, 4010, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[367] = new OneStringsTemplateATraceData(null, 4011, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[368] = new Multidata81TemplateATraceData(null, 4012, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[369] = new Multidata48TemplateATraceData(null, 4013, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[370] = new Multidata80TemplateATraceData(null, 4014, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[371] = new Multidata48TemplateATraceData(null, 4015, 2557, "MessageQueueRegister", MessageQueueRegisterTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[372] = new OneStringsTemplateATraceData(null, 4016, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[373] = new OneStringsTemplateATraceData(null, 4019, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[374] = new Multidata48TemplateATraceData(null, 4020, 2506, "ActivationTcpListenerListening", ActivationTcpListenerListeningTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[375] = new OneStringsTemplateATraceData(null, 4021, 2506, "ActivationTcpListenerListening", ActivationTcpListenerListeningTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[376] = new Multidata82TemplateATraceData(null, 4022, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[377] = new OneStringsTemplateATraceData(null, 4023, 2603, "WASActivation", WASActivationTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[378] = new Multidata82TemplateATraceData(null, 4024, 2603, "WASActivation", WASActivationTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[379] = new Multidata82TemplateATraceData(null, 4025, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[380] = new OneStringsTemplateATraceData(null, 4026, 2603, "WASActivation", WASActivationTaskGuid, 132, "Connected", ProviderGuid, ProviderName);
                templates[381] = new OneStringsTemplateATraceData(null, 4027, 2603, "WASActivation", WASActivationTaskGuid, 133, "Disconnect", ProviderGuid, ProviderName);
                templates[382] = new Multidata48TemplateATraceData(null, 4028, 2503, "ActivationPipeListenerListening", ActivationPipeListenerListeningTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[383] = new OneStringsTemplateATraceData(null, 4029, 2503, "ActivationPipeListenerListening", ActivationPipeListenerListeningTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[384] = new OneStringsTemplateATraceData(null, 4030, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[385] = new OneStringsTemplateATraceData(null, 4031, 2500, "ActivationDispatchSession", ActivationDispatchSessionTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[386] = new OneStringsTemplateATraceData(null, 4032, 2603, "WASActivation", WASActivationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[387] = new OneStringsTemplateATraceData(null, 4033, 2504, "ActivationRoutingTableLookup", ActivationRoutingTableLookupTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[388] = new OneStringsTemplateATraceData(null, 4034, 2504, "ActivationRoutingTableLookup", ActivationRoutingTableLookupTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[389] = new Multidata83TemplateATraceData(null, 4035, 2560, "Quotas", QuotasTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[390] = new TwoStringsTemplateATraceData(null, 4201, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[391] = new TwoStringsTemplateATraceData(null, 4202, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[392] = new OneStringsTemplateATraceData(null, 4203, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[393] = new ThreeStringsTemplateEATraceData(null, 4205, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[394] = new TwoStringsTemplateATraceData(null, 4206, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[395] = new OneStringsTemplateATraceData(null, 4207, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[396] = new TwoStringsTemplateATraceData(null, 4208, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[397] = new TwoStringsTemplateATraceData(null, 4209, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[398] = new ThreeStringsTemplateATraceData(null, 4210, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[399] = new TwoStringsTemplateATraceData(null, 4211, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[400] = new TwoStringsTemplateATraceData(null, 4212, 2589, "SqlCommandExecute", SqlCommandExecuteTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[401] = new TwoStringsTemplateEATraceData(null, 4213, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[402] = new TwoStringsTemplateEATraceData(null, 4214, 2553, "LockWorkflowInstance", LockWorkflowInstanceTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[403] = new OneStringsTemplateATraceData(null, 4600, 0, null, new Guid(), 0, "Info", ProviderGuid, ProviderName);
                templates[404] = new TwoStringsTemplateEATraceData(null, 4801, 2529, "DiscoveryClient", DiscoveryClientTaskGuid, 30, "FailedToClose", ProviderGuid, ProviderName);
                templates[405] = new TwoStringsTemplateEATraceData(null, 4802, 2529, "DiscoveryClient", DiscoveryClientTaskGuid, 29, "ExceptionSuppressed", ProviderGuid, ProviderName);
                templates[406] = new OneStringsTemplateATraceData(null, 4803, 2529, "DiscoveryClient", DiscoveryClientTaskGuid, 31, "ReceivedMulticastSuppression", ProviderGuid, ProviderName);
                templates[407] = new Multidata87TemplateATraceData(null, 4804, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 45, "ReceivedAfterOperationCompleted", ProviderGuid, ProviderName);
                templates[408] = new Multidata88TemplateATraceData(null, 4805, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 37, "InvalidContent", ProviderGuid, ProviderName);
                templates[409] = new Multidata89TemplateATraceData(null, 4806, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 38, "InvalidRelatesToOrOperationCompleted", ProviderGuid, ProviderName);
                templates[410] = new Multidata90TemplateATraceData(null, 4807, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 39, "InvalidReplyTo", ProviderGuid, ProviderName);
                templates[411] = new Multidata91TemplateATraceData(null, 4808, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 40, "NoContent", ProviderGuid, ProviderName);
                templates[412] = new Multidata91TemplateATraceData(null, 4809, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 41, "NullMessageId", ProviderGuid, ProviderName);
                templates[413] = new Multidata92TemplateATraceData(null, 4810, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 42, "NullMessageSequence", ProviderGuid, ProviderName);
                templates[414] = new Multidata92TemplateATraceData(null, 4811, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 43, "NullRelatesTo", ProviderGuid, ProviderName);
                templates[415] = new Multidata90TemplateATraceData(null, 4812, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 44, "NullReplyTo", ProviderGuid, ProviderName);
                templates[416] = new Multidata88TemplateATraceData(null, 4813, 2531, "DiscoveryMessage", DiscoveryMessageTaskGuid, 36, "Duplicate", ProviderGuid, ProviderName);
                templates[417] = new Multidata93TemplateATraceData(null, 4814, 2534, "EndpointDiscoverability", EndpointDiscoverabilityTaskGuid, 58, "Disabled", ProviderGuid, ProviderName);
                templates[418] = new Multidata93TemplateATraceData(null, 4815, 2534, "EndpointDiscoverability", EndpointDiscoverabilityTaskGuid, 59, "Enabled", ProviderGuid, ProviderName);
                templates[419] = new OneStringsTemplateATraceData(null, 4816, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 33, "FindInitiated", ProviderGuid, ProviderName);
                templates[420] = new Multidata94TemplateEATraceData(null, 4817, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 32, "CreationFailed", ProviderGuid, ProviderName);
                templates[421] = new Multidata94TemplateEATraceData(null, 4818, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 34, "OpenFailed", ProviderGuid, ProviderName);
                templates[422] = new Multidata95TemplateATraceData(null, 4819, 2530, "DiscoveryClientChannel", DiscoveryClientChannelTaskGuid, 35, "OpenSucceeded", ProviderGuid, ProviderName);
                templates[423] = new Multidata96TemplateATraceData(null, 4820, 2532, "DiscoverySynchronizationContext", DiscoverySynchronizationContextTaskGuid, 46, "Reset", ProviderGuid, ProviderName);
                templates[424] = new OneStringsTemplateATraceData(null, 4821, 2532, "DiscoverySynchronizationContext", DiscoverySynchronizationContextTaskGuid, 47, "SetToNull", ProviderGuid, ProviderName);
                templates[425] = new Multidata97TemplateATraceData(null, 5001, 2592, "SurrogateSerialize", SurrogateSerializeTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[426] = new OneStringsTemplateATraceData(null, 5002, 2592, "SurrogateSerialize", SurrogateSerializeTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[427] = new Multidata97TemplateATraceData(null, 5003, 2591, "SurrogateDeserialize", SurrogateDeserializeTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[428] = new OneStringsTemplateATraceData(null, 5004, 2591, "SurrogateDeserialize", SurrogateDeserializeTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[429] = new OneStringsTemplateATraceData(null, 5005, 2547, "ImportKnownType", ImportKnownTypeTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[430] = new OneStringsTemplateATraceData(null, 5006, 2547, "ImportKnownType", ImportKnownTypeTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[431] = new Multidata33TemplateATraceData(null, 5007, 2528, "DataContractResolver", DataContractResolverTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[432] = new Multidata98TemplateATraceData(null, 5008, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[433] = new OneStringsTemplateATraceData(null, 5009, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[434] = new Multidata98TemplateATraceData(null, 5010, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[435] = new OneStringsTemplateATraceData(null, 5011, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[436] = new Multidata98TemplateATraceData(null, 5012, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[437] = new OneStringsTemplateATraceData(null, 5013, 2543, "GenerateDeserializer", GenerateDeserializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[438] = new Multidata98TemplateATraceData(null, 5014, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[439] = new OneStringsTemplateATraceData(null, 5015, 2544, "GenerateSerializer", GenerateSerializerTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[440] = new Multidata99TemplateATraceData(null, 5016, 2545, "GenerateXmlSerializable", GenerateXmlSerializableTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[441] = new OneStringsTemplateATraceData(null, 5017, 2545, "GenerateXmlSerializable", GenerateXmlSerializableTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[442] = new OneStringsTemplateATraceData(null, 5203, 2555, "MessageDecoding", MessageDecodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[443] = new OneStringsTemplateATraceData(null, 5204, 2556, "MessageEncoding", MessageEncodingTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[444] = new Multidata103TemplateHATraceData(null, 5402, 2612, "TokenValidation", TokenValidationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[445] = new Multidata103TemplateHATraceData(null, 5403, 2612, "TokenValidation", TokenValidationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[446] = new Multidata102TemplateHATraceData(null, 5404, 2612, "TokenValidation", TokenValidationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[447] = new Multidata101TemplateHATraceData(null, 5405, 2613, "GetIssuerName", GetIssuerNameTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[448] = new Multidata100TemplateHATraceData(null, 5406, 2613, "GetIssuerName", GetIssuerNameTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[449] = new TwoStringsTemplateVATraceData(null, 5600, 2616, "FederationMessageProcessing", FederationMessageProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[450] = new TwoStringsTemplateVATraceData(null, 5601, 2616, "FederationMessageProcessing", FederationMessageProcessingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[451] = new TwoStringsTemplateVATraceData(null, 5602, 2617, "FederationMessageCreation", FederationMessageCreationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[452] = new TwoStringsTemplateVATraceData(null, 5603, 2617, "FederationMessageCreation", FederationMessageCreationTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[453] = new TwoStringsTemplateVATraceData(null, 5604, 2618, "SessionCookieReading", SessionCookieReadingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[454] = new TwoStringsTemplateVATraceData(null, 5605, 2618, "SessionCookieReading", SessionCookieReadingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[455] = new TwoStringsTemplateVATraceData(null, 5606, 2619, "PrincipalSetting", PrincipalSettingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[456] = new TwoStringsTemplateVATraceData(null, 5607, 2619, "PrincipalSetting", PrincipalSettingTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[457] = new Multidata15TemplateATraceData(null, 0xFFFF, 2598, "TrackingRecord", TrackingRecordTaskGuid, 125, "Dropped", ProviderGuid, ProviderName);
                templates[458] = new ThreeStringsTemplateATraceData(null, 0xFFFF, 2598, "TrackingRecord", TrackingRecordTaskGuid, 126, "Raised", ProviderGuid, ProviderName);
                templates[459] = new Multidata15TemplateATraceData(null, 0xFFFF, 2598, "TrackingRecord", TrackingRecordTaskGuid, 127, "Truncated", ProviderGuid, ProviderName);
                templates[460] = new Multidata16TemplateATraceData(null, 0xFFFF, 2597, "TrackingProfile", TrackingProfileTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[461] = new Multidata18TemplateATraceData(null, 0xFFFF, 2597, "TrackingProfile", TrackingProfileTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[462] = new Multidata84TemplateATraceData(null, 0xFFFF, 2594, "Throttles", ThrottlesTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                templates[463] = new FourStringsTemplateATraceData(null, 0xFFFF, 2526, "CreateWorkflowServiceHost", CreateWorkflowServiceHostTaskGuid, 0, "Info", ProviderGuid, ProviderName);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        private static readonly Guid ActivationDispatchSessionTaskGuid = new Guid(unchecked((int)0xcc62b5a3), unchecked((short)0x2fe1), unchecked((short)0x4546), 0xae, 0x18, 0x2e, 0xa4, 0x2a, 0xaf, 0x49, 0x78);
        private static readonly Guid ActivationDuplicateSocketTaskGuid = new Guid(unchecked((int)0xa8cea9f0), unchecked((short)0x416c), unchecked((short)0x4631), 0xaf, 0xbb, 0xbd, 0xd7, 0x85, 0x95, 0x63, 0x24);
        private static readonly Guid ActivationListenerOpenTaskGuid = new Guid(unchecked((int)0x2f44781b), unchecked((short)0x94da), unchecked((short)0x4a82), 0x9b, 0xfd, 0x2d, 0x86, 0xc6, 0x7b, 0x6d, 0x59);
        private static readonly Guid ActivationPipeListenerListeningTaskGuid = new Guid(unchecked((int)0x290d600c), unchecked((short)0x9ac4), unchecked((short)0x4e3f), 0x80, 0x8f, 0x5a, 0xe8, 0xc0, 0x5b, 0xa9, 0x9b);
        private static readonly Guid ActivationRoutingTableLookupTaskGuid = new Guid(unchecked((int)0xa3fe4600), unchecked((short)0x2cbb), unchecked((short)0x4ac2), 0x8f, 0x97, 0x1f, 0x49, 0xf5, 0x55, 0xe4, 0x0d);
        private static readonly Guid ActivationServiceStartTaskGuid = new Guid(unchecked((int)0x258510de), unchecked((short)0xeff7), unchecked((short)0x440b), 0x87, 0xe0, 0xfe, 0xf9, 0xbf, 0x74, 0x02, 0x64);
        private static readonly Guid ActivationTcpListenerListeningTaskGuid = new Guid(unchecked((int)0x7050cd38), unchecked((short)0xffce), unchecked((short)0x4626), 0xa0, 0x4b, 0xe3, 0x38, 0xe1, 0xa5, 0xab, 0xbe);
        private static readonly Guid AddServiceEndpointTaskGuid = new Guid(unchecked((int)0xf102a07a), unchecked((short)0x2a6a), unchecked((short)0x4e97), 0x98, 0xcb, 0x3b, 0xb3, 0xa7, 0x16, 0x0d, 0xb6);
        private static readonly Guid BufferOutOfOrderTaskGuid = new Guid(unchecked((int)0xb47455d1), unchecked((short)0x7962), unchecked((short)0x45da), 0x98, 0x05, 0xdb, 0x7c, 0xc7, 0x93, 0x03, 0x83);
        private static readonly Guid BufferPoolingTaskGuid = new Guid(unchecked((int)0x6f83b987), unchecked((short)0x9660), unchecked((short)0x4211), 0xaf, 0x87, 0x22, 0x99, 0x40, 0x65, 0xd0, 0x3b);
        private static readonly Guid CacheRootMetadataTaskGuid = new Guid(unchecked((int)0xa2c991a1), unchecked((short)0xa330), unchecked((short)0x4f57), 0xac, 0x54, 0x41, 0xf0, 0x99, 0x7c, 0xe7, 0x2e);
        private static readonly Guid ChannelFactoryCachingTaskGuid = new Guid(unchecked((int)0x643d11c2), unchecked((short)0x6eee), unchecked((short)0x4388), 0x96, 0x5e, 0x8b, 0xea, 0xc2, 0xb6, 0xc7, 0x05);
        private static readonly Guid ChannelFactoryCreateTaskGuid = new Guid(unchecked((int)0x8b16dba4), unchecked((short)0x17cb), unchecked((short)0x451f), 0x9d, 0xce, 0x2b, 0x6a, 0x0a, 0x61, 0xd2, 0x30);
        private static readonly Guid ChannelReceiveTaskGuid = new Guid(unchecked((int)0xbdaeec18), unchecked((short)0x49e2), unchecked((short)0x46da), 0xbd, 0x4c, 0xb3, 0x2f, 0x3e, 0x95, 0x5c, 0xfb);
        private static readonly Guid ClientRuntimeTaskGuid = new Guid(unchecked((int)0x2a726cd5), unchecked((short)0x610e), unchecked((short)0x4a23), 0xb4, 0x11, 0x61, 0xf1, 0xd8, 0xab, 0x24, 0x4d);
        private static readonly Guid ClientSendPreambleTaskGuid = new Guid(unchecked((int)0x00830c8d), unchecked((short)0x78eb), unchecked((short)0x4ea3), 0xbc, 0xae, 0xcf, 0x5f, 0xe6, 0x0f, 0xfd, 0x71);
        private static readonly Guid CompensationStateTaskGuid = new Guid(unchecked((int)0x0da1bff2), unchecked((short)0x411e), unchecked((short)0x430f), 0x8a, 0x5d, 0xc9, 0x56, 0x54, 0x3c, 0x5c, 0x97);
        private static readonly Guid CompleteActivityTaskGuid = new Guid(unchecked((int)0xf2ff22dd), unchecked((short)0x397c), unchecked((short)0x467b), 0x98, 0x12, 0x0a, 0x79, 0xe8, 0xc5, 0xa1, 0x2b);
        private static readonly Guid CompleteWorkItemTaskGuid = new Guid(unchecked((int)0x63680005), unchecked((short)0xee91), unchecked((short)0x4154), 0xae, 0x7a, 0x24, 0x09, 0x42, 0x51, 0x0b, 0x98);
        private static readonly Guid ConnectTaskGuid = new Guid(unchecked((int)0x7386e51a), unchecked((short)0x8418), unchecked((short)0x4599), 0xb8, 0x2f, 0xd1, 0xd0, 0x89, 0x25, 0xc8, 0xd6);
        private static readonly Guid ConnectionAbortTaskGuid = new Guid(unchecked((int)0xd28a7513), unchecked((short)0x7db8), unchecked((short)0x4175), 0x9c, 0x38, 0x3a, 0xe9, 0x8e, 0x63, 0x3f, 0x75);
        private static readonly Guid ConnectionAcceptTaskGuid = new Guid(unchecked((int)0x8289b69b), unchecked((short)0x1b48), unchecked((short)0x4160), 0xae, 0x03, 0x50, 0xa6, 0xea, 0x89, 0x3e, 0x61);
        private static readonly Guid ConnectionPoolingTaskGuid = new Guid(unchecked((int)0xbc25d06d), unchecked((short)0xa60a), unchecked((short)0x4769), 0xa3, 0xf2, 0x38, 0x58, 0xb0, 0xe7, 0xc5, 0xdb);
        private static readonly Guid CorrelationTaskGuid = new Guid(unchecked((int)0xa945f7d1), unchecked((short)0x4dba), unchecked((short)0x4537), 0xb8, 0xde, 0xa2, 0xdb, 0x62, 0x1e, 0x2a, 0xde);
        private static readonly Guid CreateBookmarkTaskGuid = new Guid(unchecked((int)0xd156f187), unchecked((short)0xf5c0), unchecked((short)0x4213), 0xb8, 0x59, 0x87, 0xc7, 0x61, 0x61, 0x67, 0x02);
        private static readonly Guid CreateHttpMessageHandlerTaskGuid = new Guid(unchecked((int)0x4c4e08dd), unchecked((short)0x6602), unchecked((short)0x4cbe), 0xb3, 0x38, 0xd4, 0x2f, 0xd1, 0x9a, 0xc9, 0x0b);
        private static readonly Guid CreateWorkflowServiceHostTaskGuid = new Guid(unchecked((int)0xdc5e2af3), unchecked((short)0x2c21), unchecked((short)0x40d9), 0x82, 0x16, 0x68, 0x32, 0xb1, 0x1d, 0x57, 0x96);
        private static readonly Guid CustomTrackingRecordTaskGuid = new Guid(unchecked((int)0x01132c8e), unchecked((short)0xcb5f), unchecked((short)0x47c8), 0x98, 0xc3, 0x67, 0x47, 0x34, 0x40, 0xcd, 0xad);
        private static readonly Guid DataContractResolverTaskGuid = new Guid(unchecked((int)0x5809dff9), unchecked((short)0xc1eb), unchecked((short)0x469d), 0x9a, 0x88, 0xd1, 0xe7, 0x08, 0x22, 0x5c, 0x03);
        private static readonly Guid DiscoveryClientTaskGuid = new Guid(unchecked((int)0x3419e18e), unchecked((short)0xab9c), unchecked((short)0x495f), 0x88, 0x53, 0x4f, 0xd2, 0x53, 0xfe, 0xe7, 0x42);
        private static readonly Guid DiscoveryClientChannelTaskGuid = new Guid(unchecked((int)0x1733b7bf), unchecked((short)0xbeb5), unchecked((short)0x4f77), 0x9c, 0xa4, 0xfb, 0x4e, 0x47, 0xb8, 0xba, 0x92);
        private static readonly Guid DiscoveryMessageTaskGuid = new Guid(unchecked((int)0x6718f681), unchecked((short)0xceb8), unchecked((short)0x418b), 0xaa, 0x29, 0x2d, 0x4b, 0x17, 0x62, 0xfc, 0xdc);
        private static readonly Guid DiscoverySynchronizationContextTaskGuid = new Guid(unchecked((int)0x6dae34cb), unchecked((short)0xa41e), unchecked((short)0x4f83), 0x92, 0x15, 0x36, 0xa6, 0xd9, 0x9b, 0x92, 0x0f);
        private static readonly Guid DispatchMessageTaskGuid = new Guid(unchecked((int)0xcfa3eff0), unchecked((short)0xbf4d), unchecked((short)0x48ba), 0x94, 0x8e, 0x7d, 0x74, 0x7d, 0x4c, 0x3c, 0x29);
        private static readonly Guid EndpointDiscoverabilityTaskGuid = new Guid(unchecked((int)0x3a550486), unchecked((short)0x6e72), unchecked((short)0x409a), 0xaf, 0x80, 0x2b, 0xdd, 0x33, 0xd9, 0x5d, 0xe7);
        private static readonly Guid ExecuteActivityTaskGuid = new Guid(unchecked((int)0xe36d0c20), unchecked((short)0x32cb), unchecked((short)0x4568), 0x98, 0x97, 0x66, 0x3f, 0x38, 0x2a, 0x02, 0xe5);
        private static readonly Guid ExecuteFlowchartTaskGuid = new Guid(unchecked((int)0x4a46e34a), unchecked((short)0x6765), unchecked((short)0x4bdd), 0xb8, 0x1d, 0x7c, 0x77, 0x38, 0xad, 0x6c, 0x3f);
        private static readonly Guid ExecuteWorkItemTaskGuid = new Guid(unchecked((int)0x6d072edb), unchecked((short)0x429e), unchecked((short)0x4046), 0x93, 0x97, 0xaf, 0xf0, 0x05, 0x75, 0x2e, 0xb2);
        private static readonly Guid ExpressionResultTaskGuid = new Guid(unchecked((int)0x046c6554), unchecked((short)0x41aa), unchecked((short)0x4e98), 0xba, 0x6c, 0x2e, 0xd4, 0x57, 0xc4, 0x2e, 0xb9);
        private static readonly Guid FormatterDeserializeReplyTaskGuid = new Guid(unchecked((int)0x1383449f), unchecked((short)0x3231), unchecked((short)0x4a82), 0xb0, 0x8f, 0xa6, 0x7b, 0x5d, 0xf7, 0x1c, 0x6f);
        private static readonly Guid FormatterDeserializeRequestTaskGuid = new Guid(unchecked((int)0xa6034273), unchecked((short)0xe068), unchecked((short)0x4663), 0xa5, 0xbb, 0xa3, 0xbb, 0xc1, 0x3b, 0x19, 0x53);
        private static readonly Guid FormatterSerializeReplyTaskGuid = new Guid(unchecked((int)0xcbf0fa02), unchecked((short)0x6964), unchecked((short)0x4298), 0x9b, 0xf7, 0x2f, 0x03, 0x79, 0xf8, 0x36, 0x08);
        private static readonly Guid FormatterSerializeRequestTaskGuid = new Guid(unchecked((int)0x150fd34c), unchecked((short)0x30d9), unchecked((short)0x41c0), 0xbc, 0xd0, 0x86, 0x78, 0x4a, 0x36, 0xbe, 0x3b);
        private static readonly Guid GenerateDeserializerTaskGuid = new Guid(unchecked((int)0x0a195d68), unchecked((short)0xee49), unchecked((short)0x4a4b), 0xb3, 0x11, 0x36, 0x71, 0x7a, 0xd8, 0xe8, 0x42);
        private static readonly Guid GenerateSerializerTaskGuid = new Guid(unchecked((int)0x2eac2877), unchecked((short)0xe183), unchecked((short)0x4280), 0x84, 0x7e, 0xdb, 0xb4, 0x4b, 0xaf, 0x64, 0x29);
        private static readonly Guid GenerateXmlSerializableTaskGuid = new Guid(unchecked((int)0x2bd9d243), unchecked((short)0x9e23), unchecked((short)0x4a78), 0x9a, 0xda, 0x60, 0x0c, 0xc1, 0x28, 0xf7, 0xff);
        private static readonly Guid HostedTransportConfigurationManagerConfigInitTaskGuid = new Guid(unchecked((int)0x209e9d89), unchecked((short)0x3301), unchecked((short)0x4132), 0xb1, 0x2e, 0xcb, 0x03, 0xb4, 0xc9, 0x08, 0xd1);
        private static readonly Guid ImportKnownTypeTaskGuid = new Guid(unchecked((int)0x751739d0), unchecked((short)0x0aff), unchecked((short)0x4f56), 0xb8, 0x78, 0xc2, 0x70, 0xc5, 0x8a, 0x17, 0xa1);
        private static readonly Guid InferDescriptionTaskGuid = new Guid(unchecked((int)0x11efeeee), unchecked((short)0x6ca2), unchecked((short)0x484c), 0x9f, 0x52, 0x39, 0x96, 0xd4, 0x0e, 0x39, 0x73);
        private static readonly Guid InitializeBookmarkScopeTaskGuid = new Guid(unchecked((int)0x19b94d63), unchecked((short)0x4a80), unchecked((short)0x4eed), 0xaf, 0xc7, 0x48, 0x13, 0xf2, 0xc3, 0xd3, 0x17);
        private static readonly Guid InternalCacheMetadataTaskGuid = new Guid(unchecked((int)0xb7c65e88), unchecked((short)0x50b2), unchecked((short)0x49c8), 0x9c, 0x5f, 0x56, 0x79, 0xeb, 0x06, 0x63, 0x5a);
        private static readonly Guid InvokeMethodTaskGuid = new Guid(unchecked((int)0x281c1dc8), unchecked((short)0xac41), unchecked((short)0x4170), 0xa7, 0xef, 0x13, 0xd2, 0x16, 0xff, 0x58, 0x73);
        private static readonly Guid ListenerOpenTaskGuid = new Guid(unchecked((int)0xdb4cadc2), unchecked((short)0x970c), unchecked((short)0x46b3), 0x99, 0x95, 0x74, 0xf3, 0x99, 0xe5, 0x7d, 0x25);
        private static readonly Guid LockWorkflowInstanceTaskGuid = new Guid(unchecked((int)0xc9dec4a9), unchecked((short)0x2a27), unchecked((short)0x48ae), 0x9b, 0x76, 0x07, 0x3a, 0x60, 0xaa, 0x1b, 0xdf);
        private static readonly Guid MessageChannelCacheTaskGuid = new Guid(unchecked((int)0x09bf4c8a), unchecked((short)0x579b), unchecked((short)0x44ea), 0x8c, 0xd9, 0x24, 0x90, 0xac, 0x2e, 0x64, 0x0f);
        private static readonly Guid MessageDecodingTaskGuid = new Guid(unchecked((int)0x3c7bb03f), unchecked((short)0xcb27), unchecked((short)0x4ac7), 0x88, 0xb3, 0x74, 0x99, 0x6c, 0x38, 0xd0, 0x0f);
        private static readonly Guid MessageEncodingTaskGuid = new Guid(unchecked((int)0x7d9dc4bc), unchecked((short)0xcf40), unchecked((short)0x494d), 0x9e, 0x9d, 0xab, 0x00, 0xe9, 0xd9, 0x56, 0x28);
        private static readonly Guid MessageQueueRegisterTaskGuid = new Guid(unchecked((int)0x18c94a0d), unchecked((short)0xc90c), unchecked((short)0x4045), 0xad, 0x31, 0x07, 0xbb, 0x22, 0x2e, 0x6d, 0xbf);
        private static readonly Guid MsmqQuotasTaskGuid = new Guid(unchecked((int)0x01b57294), unchecked((short)0x49fc), unchecked((short)0x4a9d), 0xb4, 0x6d, 0x42, 0x58, 0x9e, 0x86, 0x32, 0x8d);
        private static readonly Guid NoPersistBlockTaskGuid = new Guid(unchecked((int)0x42a1f6b2), unchecked((short)0xf9c5), unchecked((short)0x4dc4), 0xa7, 0xda, 0x18, 0x92, 0xa8, 0x30, 0x46, 0xab);
        private static readonly Guid QuotasTaskGuid = new Guid(unchecked((int)0x3b3023ac), unchecked((short)0xe7bf), unchecked((short)0x4d11), 0x89, 0x6b, 0x78, 0x10, 0xba, 0x5b, 0x43, 0xf5);
        private static readonly Guid ReliableSessionTaskGuid = new Guid(unchecked((int)0xf105d9e4), unchecked((short)0x3bee), unchecked((short)0x44f3), 0x9e, 0x34, 0x17, 0x6c, 0x4c, 0x36, 0x96, 0x6b);
        private static readonly Guid RoutingServiceTaskGuid = new Guid(unchecked((int)0x29e2a04c), unchecked((short)0xaaed), unchecked((short)0x4439), 0xa3, 0x4d, 0x88, 0x40, 0x50, 0x31, 0x7c, 0x37);
        private static readonly Guid RoutingServiceClientTaskGuid = new Guid(unchecked((int)0x854a57e9), unchecked((short)0x7fc3), unchecked((short)0x49be), 0xbf, 0xb1, 0xa4, 0xdf, 0xe1, 0x31, 0x9d, 0x6e);
        private static readonly Guid RoutingServiceFilterTableMatchTaskGuid = new Guid(unchecked((int)0x8d9dab05), unchecked((short)0x283c), unchecked((short)0x4e06), 0x82, 0x0d, 0x1a, 0x86, 0x51, 0x2a, 0x6f, 0xae);
        private static readonly Guid RoutingServiceMessageTaskGuid = new Guid(unchecked((int)0x7604f4c2), unchecked((short)0xda79), unchecked((short)0x4b5c), 0x89, 0x27, 0x89, 0x00, 0x06, 0xa4, 0x3a, 0x3a);
        private static readonly Guid RoutingServiceReceiveContextTaskGuid = new Guid(unchecked((int)0xd051f201), unchecked((short)0xc391), unchecked((short)0x438c), 0xba, 0x86, 0xc4, 0xb3, 0x6a, 0xd4, 0x33, 0x54);
        private static readonly Guid RoutingServiceTransactionTaskGuid = new Guid(unchecked((int)0x39b697ed), unchecked((short)0x79b9), unchecked((short)0x4172), 0xa6, 0x2f, 0xc1, 0x9e, 0x1d, 0x80, 0x7e, 0x32);
        private static readonly Guid RuntimeTransactionTaskGuid = new Guid(unchecked((int)0xe71036aa), unchecked((short)0x4d1e), unchecked((short)0x4acb), 0x8f, 0x5b, 0xd1, 0xab, 0x14, 0x8d, 0xdc, 0x5e);
        private static readonly Guid ScheduleActivityTaskGuid = new Guid(unchecked((int)0x75bfa87e), unchecked((short)0xb64f), unchecked((short)0x4e34), 0xb6, 0xc9, 0xbf, 0x31, 0x5b, 0xab, 0x52, 0x68);
        private static readonly Guid ScheduleWorkItemTaskGuid = new Guid(unchecked((int)0xe55a99e9), unchecked((short)0xadf3), unchecked((short)0x4da2), 0xb8, 0x12, 0x37, 0x6c, 0x68, 0x2a, 0xd9, 0x91);
        private static readonly Guid SecureMessageTaskGuid = new Guid(unchecked((int)0x4a44e657), unchecked((short)0xbb88), unchecked((short)0x40e6), 0xb4, 0xb6, 0x7c, 0x4b, 0xad, 0xe8, 0x64, 0x5c);
        private static readonly Guid SecurityImpersonationTaskGuid = new Guid(unchecked((int)0x215c2b1c), unchecked((short)0xbcc4), unchecked((short)0x406b), 0x92, 0x8f, 0x53, 0xc5, 0xaf, 0x9a, 0xb8, 0xce);
        private static readonly Guid SecurityNegotiationTaskGuid = new Guid(unchecked((int)0x906923a1), unchecked((short)0x1501), unchecked((short)0x456b), 0xad, 0x24, 0xdc, 0x6e, 0x6e, 0x7a, 0x7e, 0x0e);
        private static readonly Guid SecurityVerificationTaskGuid = new Guid(unchecked((int)0xa18a4968), unchecked((short)0xa0fe), unchecked((short)0x4218), 0xa2, 0xc6, 0x41, 0xbc, 0x98, 0x04, 0xae, 0x40);
        private static readonly Guid ServiceActivationTaskGuid = new Guid(unchecked((int)0x495cdd67), unchecked((short)0x1051), unchecked((short)0x4a73), 0x86, 0x71, 0xf5, 0x5c, 0xd4, 0xf8, 0x26, 0x2a);
        private static readonly Guid ServiceChannelCallTaskGuid = new Guid(unchecked((int)0xe0bc1bbf), unchecked((short)0xdc44), unchecked((short)0x4bfe), 0x82, 0x48, 0xc1, 0x35, 0x47, 0x47, 0x1d, 0xe5);
        private static readonly Guid ServiceChannelOpenTaskGuid = new Guid(unchecked((int)0x3a4d4500), unchecked((short)0xa5ff), unchecked((short)0x48e8), 0x98, 0xf3, 0x03, 0x1e, 0x37, 0xc7, 0x5c, 0x46);
        private static readonly Guid ServiceHostActivationTaskGuid = new Guid(unchecked((int)0x889b37e9), unchecked((short)0x86e8), unchecked((short)0x4394), 0xb9, 0xcf, 0x51, 0xa9, 0xf8, 0x61, 0x51, 0xf3);
        private static readonly Guid ServiceHostCompilationTaskGuid = new Guid(unchecked((int)0xb89a8822), unchecked((short)0xf97f), unchecked((short)0x4dc6), 0xa8, 0x5f, 0x82, 0xa1, 0x85, 0x58, 0xe8, 0xfc);
        private static readonly Guid ServiceHostCreateTaskGuid = new Guid(unchecked((int)0x6b129f40), unchecked((short)0xfc49), unchecked((short)0x4032), 0x8e, 0xc4, 0x0b, 0x13, 0x96, 0xa4, 0x7d, 0x5d);
        private static readonly Guid ServiceHostFactoryCreationTaskGuid = new Guid(unchecked((int)0x9c411076), unchecked((short)0x9eb0), unchecked((short)0x4579), 0x87, 0x41, 0xf8, 0x03, 0x7e, 0x91, 0x40, 0xdc);
        private static readonly Guid ServiceHostFaultTaskGuid = new Guid(unchecked((int)0xa3276f7a), unchecked((short)0xbf2b), unchecked((short)0x4e74), 0xb4, 0xd5, 0x23, 0x29, 0xb0, 0xb1, 0x96, 0x20);
        private static readonly Guid ServiceHostOpenTaskGuid = new Guid(unchecked((int)0x0a0d5fc5), unchecked((short)0x939d), unchecked((short)0x4f85), 0x9c, 0x73, 0x6b, 0x10, 0xbe, 0x96, 0xfa, 0xea);
        private static readonly Guid ServiceInstanceTaskGuid = new Guid(unchecked((int)0xb0cd6c86), unchecked((short)0x90b8), unchecked((short)0x4382), 0xb8, 0xe0, 0x40, 0xf7, 0x7a, 0x70, 0x58, 0x4a);
        private static readonly Guid ServiceShutdownTaskGuid = new Guid(unchecked((int)0xaa2e18aa), unchecked((short)0x3618), unchecked((short)0x4be9), 0xb9, 0x38, 0x5a, 0x04, 0xff, 0xc0, 0xd2, 0x32);
        private static readonly Guid SessionStartTaskGuid = new Guid(unchecked((int)0x5fab4482), unchecked((short)0x260c), unchecked((short)0x4280), 0xa6, 0x70, 0x72, 0xcb, 0x40, 0xa6, 0xd3, 0x8c);
        private static readonly Guid SessionUpgradeTaskGuid = new Guid(unchecked((int)0x29f551a4), unchecked((short)0x5a53), unchecked((short)0x4ce2), 0xb7, 0x08, 0x38, 0x98, 0x3b, 0x5f, 0x68, 0xcc);
        private static readonly Guid SignpostTaskGuid = new Guid(unchecked((int)0x467f2eed), unchecked((short)0x797f), unchecked((short)0x4a5b), 0xaa, 0x77, 0xf6, 0x0e, 0x81, 0x74, 0xd2, 0x87);
        private static readonly Guid SqlCommandExecuteTaskGuid = new Guid(unchecked((int)0x837f6564), unchecked((short)0x75a0), unchecked((short)0x4ca1), 0x80, 0x87, 0x23, 0x06, 0x99, 0x35, 0xef, 0xa4);
        private static readonly Guid StartWorkItemTaskGuid = new Guid(unchecked((int)0x8931a237), unchecked((short)0xd6c2), unchecked((short)0x42c7), 0x94, 0x38, 0x83, 0xee, 0x5d, 0x3a, 0x24, 0xc1);
        private static readonly Guid SurrogateDeserializeTaskGuid = new Guid(unchecked((int)0xfd67d29d), unchecked((short)0x3b67), unchecked((short)0x4138), 0x85, 0x3f, 0x02, 0xfe, 0xbd, 0xb1, 0xbb, 0x3c);
        private static readonly Guid SurrogateSerializeTaskGuid = new Guid(unchecked((int)0x48379681), unchecked((short)0x20f4), unchecked((short)0x4ba2), 0x92, 0x59, 0xf7, 0x97, 0x94, 0x9b, 0x31, 0x72);
        private static readonly Guid ThreadSchedulingTaskGuid = new Guid(unchecked((int)0x8ab777e0), unchecked((short)0x9d97), unchecked((short)0x498f), 0xbe, 0xc6, 0xee, 0xd9, 0xf9, 0x73, 0x2e, 0x1a);
        private static readonly Guid ThrottlesTaskGuid = new Guid(unchecked((int)0xf71d9f5c), unchecked((short)0x8697), unchecked((short)0x457f), 0xac, 0xaa, 0x78, 0x48, 0xc7, 0xf7, 0x1c, 0x33);
        private static readonly Guid TimeoutTaskGuid = new Guid(unchecked((int)0xcbb66a44), unchecked((short)0x9a0d), unchecked((short)0x498c), 0xba, 0x30, 0xf5, 0x2f, 0x9b, 0x11, 0xd7, 0x34);
        private static readonly Guid TimeoutExceptionTaskGuid = new Guid(unchecked((int)0xa2b6a84c), unchecked((short)0x3e36), unchecked((short)0x4847), 0xb6, 0x3a, 0x04, 0x6b, 0xb4, 0xff, 0xb0, 0xfc);
        private static readonly Guid TrackingProfileTaskGuid = new Guid(unchecked((int)0xb8405407), unchecked((short)0xf1c7), unchecked((short)0x436b), 0x9c, 0xc7, 0xd1, 0x41, 0xca, 0xd8, 0xa9, 0xa1);
        private static readonly Guid TrackingRecordTaskGuid = new Guid(unchecked((int)0xb92f3124), unchecked((short)0x6b3b), unchecked((short)0x41ca), 0x89, 0x70, 0xa0, 0x19, 0x51, 0xfc, 0x87, 0x1a);
        private static readonly Guid TransportReceiveTaskGuid = new Guid(unchecked((int)0x32dc9a79), unchecked((short)0xb143), unchecked((short)0x42c0), 0x84, 0x7e, 0x1a, 0x0d, 0x81, 0x58, 0xfa, 0x82);
        private static readonly Guid TransportSendTaskGuid = new Guid(unchecked((int)0x21222074), unchecked((short)0xfec4), unchecked((short)0x4a37), 0xa5, 0x02, 0x7d, 0x3f, 0xa5, 0xdd, 0x7b, 0xbd);
        private static readonly Guid TryCatchExceptionTaskGuid = new Guid(unchecked((int)0xf1a89c01), unchecked((short)0x0cd8), unchecked((short)0x425e), 0x8b, 0xaa, 0x20, 0x20, 0x99, 0x8b, 0xa2, 0x02);
        private static readonly Guid VBExpressionCompileTaskGuid = new Guid(unchecked((int)0x56082d31), unchecked((short)0x0408), unchecked((short)0x471b), 0xbd, 0x3a, 0xb6, 0x06, 0x0d, 0x54, 0xaa, 0xf6);
        private static readonly Guid WASActivationTaskGuid = new Guid(unchecked((int)0x37cc9fa0), unchecked((short)0x54bc), unchecked((short)0x4e2a), 0xb9, 0xf7, 0x3e, 0x13, 0x81, 0xd0, 0x4f, 0x84);
        private static readonly Guid WebHostRequestTaskGuid = new Guid(unchecked((int)0x2b36e2cf), unchecked((short)0xca86), unchecked((short)0x455e), 0xa5, 0xd0, 0xc3, 0xdc, 0x17, 0x8b, 0x45, 0xa7);
        private static readonly Guid WFApplicationStateChangeTaskGuid = new Guid(unchecked((int)0xe2f60385), unchecked((short)0xfabc), unchecked((short)0x46ba), 0xb6, 0x0a, 0x16, 0x44, 0xa9, 0x6d, 0xda, 0x92);
        private static readonly Guid WFMessageTaskGuid = new Guid(unchecked((int)0xf048298b), unchecked((short)0xe812), unchecked((short)0x42b8), 0xa0, 0xfe, 0x39, 0x9a, 0x94, 0x17, 0xcc, 0x12);
        private static readonly Guid WorkflowActivityTaskGuid = new Guid(unchecked((int)0xd0c1971f), unchecked((short)0xe415), unchecked((short)0x4b16), 0x92, 0x7d, 0x4a, 0x07, 0x10, 0x21, 0x76, 0xff);
        private static readonly Guid WorkflowInstanceRecordTaskGuid = new Guid(unchecked((int)0xba2a6ac8), unchecked((short)0x4687), unchecked((short)0x470a), 0xbe, 0xb8, 0x0f, 0x73, 0xa0, 0x88, 0x0b, 0xff);
        private static readonly Guid WorkflowTrackingTaskGuid = new Guid(unchecked((int)0x4dc544cd), unchecked((short)0xa2dd), unchecked((short)0x47c1), 0x98, 0xf8, 0x2d, 0xbf, 0xd5, 0xb2, 0xdb, 0x84);
        private static readonly Guid XamlServicesLoadTaskGuid = new Guid(unchecked((int)0x757f24b4), unchecked((short)0x6432), unchecked((short)0x4ad2), 0xa7, 0x5c, 0x8a, 0xe2, 0xc3, 0x19, 0x98, 0xf1);
        private static readonly Guid SignatureVerificationTaskGuid = new Guid(unchecked((int)0x022b7eea), unchecked((short)0xcd11), unchecked((short)0x47d6), 0x80, 0xc1, 0xed, 0x30, 0xac, 0x7a, 0x8a, 0x1f);
        private static readonly Guid TokenValidationTaskGuid = new Guid(unchecked((int)0xf3a96f6f), unchecked((short)0x1af7), unchecked((short)0x4229), 0x96, 0x97, 0x68, 0x89, 0xfd, 0x45, 0x8a, 0x97);
        private static readonly Guid GetIssuerNameTaskGuid = new Guid(unchecked((int)0x042e133f), unchecked((short)0xf3bd), unchecked((short)0x4fba), 0xb8, 0xb7, 0x2a, 0x9f, 0x72, 0x71, 0x51, 0xdb);
        private static readonly Guid WrappedKeyDecryptionTaskGuid = new Guid(unchecked((int)0x59725508), unchecked((short)0xd5cc), unchecked((short)0x4c89), 0x8d, 0xa0, 0x9a, 0xd2, 0xb8, 0x85, 0x2b, 0xaa);
        private static readonly Guid EncryptedDataProcessingTaskGuid = new Guid(unchecked((int)0x81db23be), unchecked((short)0x6eda), unchecked((short)0x4c2b), 0xb1, 0x02, 0x6c, 0xd8, 0x81, 0x82, 0x35, 0x92);
        private static readonly Guid FederationMessageProcessingTaskGuid = new Guid(unchecked((int)0xe8353704), unchecked((short)0xaea1), unchecked((short)0x489f), 0xb8, 0x33, 0x10, 0xda, 0xb2, 0x91, 0x3f, 0x40);
        private static readonly Guid FederationMessageCreationTaskGuid = new Guid(unchecked((int)0xb50f0e7d), unchecked((short)0x8cd3), unchecked((short)0x446b), 0xa8, 0x06, 0xda, 0x9b, 0xda, 0x5f, 0xfb, 0xaf);
        private static readonly Guid SessionCookieReadingTaskGuid = new Guid(unchecked((int)0xbca1e46d), unchecked((short)0xd690), unchecked((short)0x4ca4), 0x93, 0x0a, 0x4c, 0x4c, 0x67, 0xcc, 0x79, 0x06);
        private static readonly Guid PrincipalSettingTaskGuid = new Guid(unchecked((int)0x70502091), unchecked((short)0x88e2), unchecked((short)0x47e9), 0x90, 0x66, 0xa7, 0x33, 0xcf, 0x8c, 0x4e, 0xcd);
        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.ApplicationServer
{
    public sealed class Multidata9TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(24); } }
        public string State { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }

        #region Private
        internal Multidata9TemplateHATraceData(Action<Multidata9TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata9TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "ActivityDefinitionId", "State", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return ActivityDefinitionId;
                case 3:
                    return State;
                case 4:
                    return Annotations;
                case 5:
                    return ProfileName;
                case 6:
                    return HostReference;
                case 7:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata9TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata10TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(24); } }
        public string SourceName { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string SourceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string SourceInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string SourceTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string Exception { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))); } }

        #region Private
        internal Multidata10TemplateHATraceData(Action<Multidata10TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata10TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "SourceName", SourceName);
            XmlAttrib(sb, "SourceId", SourceId);
            XmlAttrib(sb, "SourceInstanceId", SourceInstanceId);
            XmlAttrib(sb, "SourceTypeName", SourceTypeName);
            XmlAttrib(sb, "Exception", Exception);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "ActivityDefinitionId", "SourceName", "SourceId", "SourceInstanceId", "SourceTypeName", "Exception", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return ActivityDefinitionId;
                case 3:
                    return SourceName;
                case 4:
                    return SourceId;
                case 5:
                    return SourceInstanceId;
                case 6:
                    return SourceTypeName;
                case 7:
                    return Exception;
                case 8:
                    return Annotations;
                case 9:
                    return ProfileName;
                case 10:
                    return HostReference;
                case 11:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata10TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata8TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(24); } }
        public string Reason { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }

        #region Private
        internal Multidata8TemplateHATraceData(Action<Multidata8TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata8TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "ActivityDefinitionId", "Reason", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return ActivityDefinitionId;
                case 3:
                    return Reason;
                case 4:
                    return Annotations;
                case 5:
                    return ProfileName;
                case 6:
                    return HostReference;
                case 7:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata8TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata4TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string State { get { return GetUnicodeStringAt(24); } }
        public string Name { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string ActivityId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string ActivityInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string ActivityTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string Arguments { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string Variables { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))); } }

        #region Private
        internal Multidata4TemplateHATraceData(Action<Multidata4TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata4TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "ActivityId", ActivityId);
            XmlAttrib(sb, "ActivityInstanceId", ActivityInstanceId);
            XmlAttrib(sb, "ActivityTypeName", ActivityTypeName);
            XmlAttrib(sb, "Arguments", Arguments);
            XmlAttrib(sb, "Variables", Variables);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "State", "Name", "ActivityId", "ActivityInstanceId", "ActivityTypeName", "Arguments", "Variables", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return State;
                case 3:
                    return Name;
                case 4:
                    return ActivityId;
                case 5:
                    return ActivityInstanceId;
                case 6:
                    return ActivityTypeName;
                case 7:
                    return Arguments;
                case 8:
                    return Variables;
                case 9:
                    return Annotations;
                case 10:
                    return ProfileName;
                case 11:
                    return HostReference;
                case 12:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata4TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata3TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string Name { get { return GetUnicodeStringAt(24); } }
        public string ActivityId { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string ActivityInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string ActivityTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string ChildActivityName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string ChildActivityId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string ChildActivityInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }
        public string ChildActivityTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))))); } }

        #region Private
        internal Multidata3TemplateHATraceData(Action<Multidata3TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata3TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "ActivityId", ActivityId);
            XmlAttrib(sb, "ActivityInstanceId", ActivityInstanceId);
            XmlAttrib(sb, "ActivityTypeName", ActivityTypeName);
            XmlAttrib(sb, "ChildActivityName", ChildActivityName);
            XmlAttrib(sb, "ChildActivityId", ChildActivityId);
            XmlAttrib(sb, "ChildActivityInstanceId", ChildActivityInstanceId);
            XmlAttrib(sb, "ChildActivityTypeName", ChildActivityTypeName);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "Name", "ActivityId", "ActivityInstanceId", "ActivityTypeName", "ChildActivityName", "ChildActivityId", "ChildActivityInstanceId", "ChildActivityTypeName", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return Name;
                case 3:
                    return ActivityId;
                case 4:
                    return ActivityInstanceId;
                case 5:
                    return ActivityTypeName;
                case 6:
                    return ChildActivityName;
                case 7:
                    return ChildActivityId;
                case 8:
                    return ChildActivityInstanceId;
                case 9:
                    return ChildActivityTypeName;
                case 10:
                    return Annotations;
                case 11:
                    return ProfileName;
                case 12:
                    return HostReference;
                case 13:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata3TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata6TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string FaultSourceActivityName { get { return GetUnicodeStringAt(24); } }
        public string FaultSourceActivityId { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string FaultSourceActivityInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string FaultSourceActivityTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string FaultHandlerActivityName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string FaultHandlerActivityId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string FaultHandlerActivityInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }
        public string FaultHandlerActivityTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))); } }
        public string Fault { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))); } }
        public int IsFaultSource { get { return GetByteAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))) + 1); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))) + 1)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))) + 1))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))) + 1)))); } }

        #region Private
        internal Multidata6TemplateHATraceData(Action<Multidata6TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata6TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))) + 1))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))) + 1))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "FaultSourceActivityName", FaultSourceActivityName);
            XmlAttrib(sb, "FaultSourceActivityId", FaultSourceActivityId);
            XmlAttrib(sb, "FaultSourceActivityInstanceId", FaultSourceActivityInstanceId);
            XmlAttrib(sb, "FaultSourceActivityTypeName", FaultSourceActivityTypeName);
            XmlAttrib(sb, "FaultHandlerActivityName", FaultHandlerActivityName);
            XmlAttrib(sb, "FaultHandlerActivityId", FaultHandlerActivityId);
            XmlAttrib(sb, "FaultHandlerActivityInstanceId", FaultHandlerActivityInstanceId);
            XmlAttrib(sb, "FaultHandlerActivityTypeName", FaultHandlerActivityTypeName);
            XmlAttrib(sb, "Fault", Fault);
            XmlAttrib(sb, "IsFaultSource", IsFaultSource);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "FaultSourceActivityName", "FaultSourceActivityId", "FaultSourceActivityInstanceId", "FaultSourceActivityTypeName", "FaultHandlerActivityName", "FaultHandlerActivityId", "FaultHandlerActivityInstanceId", "FaultHandlerActivityTypeName", "Fault", "IsFaultSource", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return FaultSourceActivityName;
                case 3:
                    return FaultSourceActivityId;
                case 4:
                    return FaultSourceActivityInstanceId;
                case 5:
                    return FaultSourceActivityTypeName;
                case 6:
                    return FaultHandlerActivityName;
                case 7:
                    return FaultHandlerActivityId;
                case 8:
                    return FaultHandlerActivityInstanceId;
                case 9:
                    return FaultHandlerActivityTypeName;
                case 10:
                    return Fault;
                case 11:
                    return IsFaultSource;
                case 12:
                    return Annotations;
                case 13:
                    return ProfileName;
                case 14:
                    return HostReference;
                case 15:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata6TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata5TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string Name { get { return GetUnicodeStringAt(24); } }
        public Guid SubInstanceID { get { return GetGuidAt(SkipUnicodeString(24)); } }
        public string OwnerActivityName { get { return GetUnicodeStringAt(SkipUnicodeString(24) + 16); } }
        public string OwnerActivityId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24) + 16)); } }
        public string OwnerActivityInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16))); } }
        public string OwnerActivityTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16)))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16))))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16)))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16)))))))); } }

        #region Private
        internal Multidata5TemplateHATraceData(Action<Multidata5TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata5TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24) + 16))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "SubInstanceID", SubInstanceID);
            XmlAttrib(sb, "OwnerActivityName", OwnerActivityName);
            XmlAttrib(sb, "OwnerActivityId", OwnerActivityId);
            XmlAttrib(sb, "OwnerActivityInstanceId", OwnerActivityInstanceId);
            XmlAttrib(sb, "OwnerActivityTypeName", OwnerActivityTypeName);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "Name", "SubInstanceID", "OwnerActivityName", "OwnerActivityId", "OwnerActivityInstanceId", "OwnerActivityTypeName", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return Name;
                case 3:
                    return SubInstanceID;
                case 4:
                    return OwnerActivityName;
                case 5:
                    return OwnerActivityId;
                case 6:
                    return OwnerActivityInstanceId;
                case 7:
                    return OwnerActivityTypeName;
                case 8:
                    return Annotations;
                case 9:
                    return ProfileName;
                case 10:
                    return HostReference;
                case 11:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata5TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata7TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string Name { get { return GetUnicodeStringAt(24); } }
        public string ActivityName { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string ActivityId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string ActivityInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string ActivityTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string Data { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))); } }

        #region Private
        internal Multidata7TemplateHATraceData(Action<Multidata7TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata7TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "ActivityName", ActivityName);
            XmlAttrib(sb, "ActivityId", ActivityId);
            XmlAttrib(sb, "ActivityInstanceId", ActivityInstanceId);
            XmlAttrib(sb, "ActivityTypeName", ActivityTypeName);
            XmlAttrib(sb, "Data", Data);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "Name", "ActivityName", "ActivityId", "ActivityInstanceId", "ActivityTypeName", "Data", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return Name;
                case 3:
                    return ActivityName;
                case 4:
                    return ActivityId;
                case 5:
                    return ActivityInstanceId;
                case 6:
                    return ActivityTypeName;
                case 7:
                    return Data;
                case 8:
                    return Annotations;
                case 9:
                    return ProfileName;
                case 10:
                    return HostReference;
                case 11:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata7TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata11TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(24); } }
        public string State { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string WorkflowDefinitionIdentity { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }

        #region Private
        internal Multidata11TemplateHATraceData(Action<Multidata11TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata11TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "WorkflowDefinitionIdentity", WorkflowDefinitionIdentity);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "ActivityDefinitionId", "State", "Annotations", "ProfileName", "WorkflowDefinitionIdentity", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return ActivityDefinitionId;
                case 3:
                    return State;
                case 4:
                    return Annotations;
                case 5:
                    return ProfileName;
                case 6:
                    return WorkflowDefinitionIdentity;
                case 7:
                    return HostReference;
                case 8:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata11TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata12TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(24); } }
        public string Reason { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string WorkflowDefinitionIdentity { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }

        #region Private
        internal Multidata12TemplateHATraceData(Action<Multidata12TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata12TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "WorkflowDefinitionIdentity", WorkflowDefinitionIdentity);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "ActivityDefinitionId", "Reason", "Annotations", "ProfileName", "WorkflowDefinitionIdentity", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return ActivityDefinitionId;
                case 3:
                    return Reason;
                case 4:
                    return Annotations;
                case 5:
                    return ProfileName;
                case 6:
                    return WorkflowDefinitionIdentity;
                case 7:
                    return HostReference;
                case 8:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata12TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata13TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(24); } }
        public string SourceName { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string SourceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string SourceInstanceId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string SourceTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string Exception { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))); } }
        public string WorkflowDefinitionIdentity { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))))); } }

        #region Private
        internal Multidata13TemplateHATraceData(Action<Multidata13TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata13TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "SourceName", SourceName);
            XmlAttrib(sb, "SourceId", SourceId);
            XmlAttrib(sb, "SourceInstanceId", SourceInstanceId);
            XmlAttrib(sb, "SourceTypeName", SourceTypeName);
            XmlAttrib(sb, "Exception", Exception);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "WorkflowDefinitionIdentity", WorkflowDefinitionIdentity);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "ActivityDefinitionId", "SourceName", "SourceId", "SourceInstanceId", "SourceTypeName", "Exception", "Annotations", "ProfileName", "WorkflowDefinitionIdentity", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return ActivityDefinitionId;
                case 3:
                    return SourceName;
                case 4:
                    return SourceId;
                case 5:
                    return SourceInstanceId;
                case 6:
                    return SourceTypeName;
                case 7:
                    return Exception;
                case 8:
                    return Annotations;
                case 9:
                    return ProfileName;
                case 10:
                    return WorkflowDefinitionIdentity;
                case 11:
                    return HostReference;
                case 12:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata13TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata14TemplateHATraceData : TraceEvent
    {
        public Guid InstanceId { get { return GetGuidAt(0); } }
        public long RecordNumber { get { return GetInt64At(16); } }
        // Skipping EventTime
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(24); } }
        public string State { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string OriginalDefinitionIdentity { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string UpdatedDefinitionIdentity { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }
        public string Annotations { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))); } }
        public string ProfileName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))))))); } }

        #region Private
        internal Multidata14TemplateHATraceData(Action<Multidata14TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata14TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceId", InstanceId);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "OriginalDefinitionIdentity", OriginalDefinitionIdentity);
            XmlAttrib(sb, "UpdatedDefinitionIdentity", UpdatedDefinitionIdentity);
            XmlAttrib(sb, "Annotations", Annotations);
            XmlAttrib(sb, "ProfileName", ProfileName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceId", "RecordNumber", "ActivityDefinitionId", "State", "OriginalDefinitionIdentity", "UpdatedDefinitionIdentity", "Annotations", "ProfileName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceId;
                case 1:
                    return RecordNumber;
                case 2:
                    return ActivityDefinitionId;
                case 3:
                    return State;
                case 4:
                    return OriginalDefinitionIdentity;
                case 5:
                    return UpdatedDefinitionIdentity;
                case 6:
                    return Annotations;
                case 7:
                    return ProfileName;
                case 8:
                    return HostReference;
                case 9:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata14TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata1TemplateATraceData : TraceEvent
    {
        public int Size { get { return GetInt32At(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(4); } }

        #region Private
        internal Multidata1TemplateATraceData(Action<Multidata1TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata1TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Size", Size);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Size", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Size;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata1TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata2TemplateATraceData : TraceEvent
    {
        public int PoolSize { get { return GetInt32At(0); } }
        public int Delta { get { return GetInt32At(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal Multidata2TemplateATraceData(Action<Multidata2TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata2TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "PoolSize", PoolSize);
            XmlAttrib(sb, "Delta", Delta);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "PoolSize", "Delta", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return PoolSize;
                case 1:
                    return Delta;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata2TemplateATraceData> Action;
        #endregion
    }
    public sealed class OneStringsTemplateATraceData : TraceEvent
    {
        public string AppDomain { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal OneStringsTemplateATraceData(Action<OneStringsTemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<OneStringsTemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<OneStringsTemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata23TemplateHATraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata23TemplateHATraceData(Action<Multidata23TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata23TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return HostReference;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata23TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata24TemplateHATraceData : TraceEvent
    {
        public string MethodName { get { return GetUnicodeStringAt(0); } }
        public string CallerInfo { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata24TemplateHATraceData(Action<Multidata24TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata24TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "MethodName", MethodName);
            XmlAttrib(sb, "CallerInfo", CallerInfo);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MethodName", "CallerInfo", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MethodName;
                case 1:
                    return CallerInfo;
                case 2:
                    return HostReference;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata24TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata25TemplateHATraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public int Handled { get { return GetByteAt(SkipUnicodeString(0)); } }
        public string ExceptionTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0) + 1); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0) + 1)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0) + 1))); } }

        #region Private
        internal Multidata25TemplateHATraceData(Action<Multidata25TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata25TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0) + 1)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0) + 1)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "Handled", Handled);
            XmlAttrib(sb, "ExceptionTypeName", ExceptionTypeName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "Handled", "ExceptionTypeName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return Handled;
                case 2:
                    return ExceptionTypeName;
                case 3:
                    return HostReference;
                case 4:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata25TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata26TemplateHATraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string ExceptionTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata26TemplateHATraceData(Action<Multidata26TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata26TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "ExceptionTypeName", ExceptionTypeName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "ExceptionTypeName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return ExceptionTypeName;
                case 2:
                    return HostReference;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata26TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata27TemplateHATraceData : TraceEvent
    {
        public string ThrottleName { get { return GetUnicodeStringAt(0); } }
        public long Limit { get { return GetInt64At(SkipUnicodeString(0)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0) + 8); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0) + 8)); } }

        #region Private
        internal Multidata27TemplateHATraceData(Action<Multidata27TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata27TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0) + 8))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0) + 8))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ThrottleName", ThrottleName);
            XmlAttrib(sb, "Limit", Limit);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ThrottleName", "Limit", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ThrottleName;
                case 1:
                    return Limit;
                case 2:
                    return HostReference;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata27TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata72TemplateHATraceData : TraceEvent
    {
        public string ServiceTypeName { get { return GetUnicodeStringAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata72TemplateHATraceData(Action<Multidata72TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata72TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ServiceTypeName", ServiceTypeName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ServiceTypeName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ServiceTypeName;
                case 1:
                    return HostReference;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata72TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata28TemplateHATraceData : TraceEvent
    {
        public string MethodName { get { return GetUnicodeStringAt(0); } }
        public long Duration { get { return GetInt64At(SkipUnicodeString(0)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0) + 8); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0) + 8)); } }

        #region Private
        internal Multidata28TemplateHATraceData(Action<Multidata28TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata28TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0) + 8))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0) + 8))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "MethodName", MethodName);
            XmlAttrib(sb, "Duration", Duration);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "MethodName", "Duration", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return MethodName;
                case 1:
                    return Duration;
                case 2:
                    return HostReference;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata28TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata29TemplateHATraceData : TraceEvent
    {
        public string ListenAddress { get { return GetUnicodeStringAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata29TemplateHATraceData(Action<Multidata29TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata29TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ListenAddress", ListenAddress);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ListenAddress", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ListenAddress;
                case 1:
                    return HostReference;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata29TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata30TemplateHATraceData : TraceEvent
    {
        public string DestinationAddress { get { return GetUnicodeStringAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata30TemplateHATraceData(Action<Multidata30TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata30TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "DestinationAddress", DestinationAddress);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "DestinationAddress", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return DestinationAddress;
                case 1:
                    return HostReference;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata30TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata22TemplateHATraceData : TraceEvent
    {
        public string ServiceAction { get { return GetUnicodeStringAt(0); } }
        public string ContractName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string Destination { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }

        #region Private
        internal Multidata22TemplateHATraceData(Action<Multidata22TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata22TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Action", Action);
            XmlAttrib(sb, "ContractName", ContractName);
            XmlAttrib(sb, "Destination", Destination);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Action", "ContractName", "Destination", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Action;
                case 1:
                    return ContractName;
                case 2:
                    return Destination;
                case 3:
                    return HostReference;
                case 4:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata22TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata31TemplateHATraceData : TraceEvent
    {
        public string ExceptionToString { get { return GetUnicodeStringAt(0); } }
        public string ExceptionTypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata31TemplateHATraceData(Action<Multidata31TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata31TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ExceptionToString", ExceptionToString);
            XmlAttrib(sb, "ExceptionTypeName", ExceptionTypeName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ExceptionToString", "ExceptionTypeName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ExceptionToString;
                case 1:
                    return ExceptionTypeName;
                case 2:
                    return HostReference;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata31TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata32TemplateHATraceData : TraceEvent
    {
        public Guid CorrelationId { get { return GetGuidAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(16); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal Multidata32TemplateHATraceData(Action<Multidata32TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata32TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "CorrelationId", CorrelationId);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "CorrelationId", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return CorrelationId;
                case 1:
                    return HostReference;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata32TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata86TemplateHATraceData : TraceEvent
    {
        public Guid InstanceKey { get { return GetGuidAt(0); } }
        public string Values { get { return GetUnicodeStringAt(16); } }
        public string ParentScope { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(16))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16)))); } }

        #region Private
        internal Multidata86TemplateHATraceData(Action<Multidata86TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata86TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(16))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InstanceKey", InstanceKey);
            XmlAttrib(sb, "Values", Values);
            XmlAttrib(sb, "ParentScope", ParentScope);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InstanceKey", "Values", "ParentScope", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InstanceKey;
                case 1:
                    return Values;
                case 2:
                    return ParentScope;
                case 3:
                    return HostReference;
                case 4:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata86TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata73TemplateATraceData : TraceEvent
    {
        public int ClosedCount { get { return GetInt32At(0); } }
        public int TotalCount { get { return GetInt32At(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal Multidata73TemplateATraceData(Action<Multidata73TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata73TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClosedCount", ClosedCount);
            XmlAttrib(sb, "TotalCount", TotalCount);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClosedCount", "TotalCount", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClosedCount;
                case 1:
                    return TotalCount;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata73TemplateATraceData> Action;
        #endregion
    }
    public sealed class UserEventsTemplateTraceData : TraceEvent
    {
        public string Name { get { return GetUnicodeStringAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string Payload { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal UserEventsTemplateTraceData(Action<UserEventsTemplateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<UserEventsTemplateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Name", Name);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "Payload", Payload);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Name", "HostReference", "Payload" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Name;
                case 1:
                    return HostReference;
                case 2:
                    return Payload;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<UserEventsTemplateTraceData> Action;
        #endregion
    }
    public sealed class TwoStringsTemplateTATraceData : TraceEvent
    {
        public string ExtendedData { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal TwoStringsTemplateTATraceData(Action<TwoStringsTemplateTATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TwoStringsTemplateTATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ExtendedData", ExtendedData);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ExtendedData", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ExtendedData;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TwoStringsTemplateTATraceData> Action;
        #endregion
    }
    public sealed class TwoStringsTemplateATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal TwoStringsTemplateATraceData(Action<TwoStringsTemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TwoStringsTemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TwoStringsTemplateATraceData> Action;
        #endregion
    }
    public sealed class TransferEmittedTemplateTraceData : TraceEvent
    {
        public string HostReference { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal TransferEmittedTemplateTraceData(Action<TransferEmittedTemplateTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TransferEmittedTemplateTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HostReference;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TransferEmittedTemplateTraceData> Action;
        #endregion
    }
    public sealed class Multidata69TemplateATraceData : TraceEvent
    {
        public string AppDomainFriendlyName { get { return GetUnicodeStringAt(0); } }
        public string VirtualPath { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata69TemplateATraceData(Action<Multidata69TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata69TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AppDomainFriendlyName", AppDomainFriendlyName);
            XmlAttrib(sb, "VirtualPath", VirtualPath);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AppDomainFriendlyName", "VirtualPath", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AppDomainFriendlyName;
                case 1:
                    return VirtualPath;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata69TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata74TemplateATraceData : TraceEvent
    {
        public string RelativeAddress { get { return GetUnicodeStringAt(0); } }
        public string NormalizedAddress { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata74TemplateATraceData(Action<Multidata74TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata74TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "RelativeAddress", RelativeAddress);
            XmlAttrib(sb, "NormalizedAddress", NormalizedAddress);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RelativeAddress", "NormalizedAddress", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RelativeAddress;
                case 1:
                    return NormalizedAddress;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata74TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata70TemplateATraceData : TraceEvent
    {
        public string IncomingAddress { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata70TemplateATraceData(Action<Multidata70TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata70TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IncomingAddress", IncomingAddress);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IncomingAddress", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IncomingAddress;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata70TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata71TemplateATraceData : TraceEvent
    {
        public string AspNetRoutePrefix { get { return GetUnicodeStringAt(0); } }
        public string ServiceType { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string ServiceHostFactoryType { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata71TemplateATraceData(Action<Multidata71TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata71TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AspNetRoutePrefix", AspNetRoutePrefix);
            XmlAttrib(sb, "ServiceType", ServiceType);
            XmlAttrib(sb, "ServiceHostFactoryType", ServiceHostFactoryType);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AspNetRoutePrefix", "ServiceType", "ServiceHostFactoryType", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AspNetRoutePrefix;
                case 1:
                    return ServiceType;
                case 2:
                    return ServiceHostFactoryType;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata71TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata75TemplateATraceData : TraceEvent
    {
        public string Data { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata75TemplateATraceData(Action<Multidata75TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata75TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Data", Data);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Data", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Data;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata75TemplateATraceData> Action;
        #endregion
    }
    public sealed class TwoStringsTemplateVATraceData : TraceEvent
    {
        public string HostReference { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal TwoStringsTemplateVATraceData(Action<TwoStringsTemplateVATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TwoStringsTemplateVATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HostReference;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TwoStringsTemplateVATraceData> Action;
        #endregion
    }
    public sealed class ThreeStringsTemplateEATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string SerializedException { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ThreeStringsTemplateEATraceData(Action<ThreeStringsTemplateEATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ThreeStringsTemplateEATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "SerializedException", SerializedException);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "SerializedException", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return SerializedException;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ThreeStringsTemplateEATraceData> Action;
        #endregion
    }
    public sealed class SixStringsTemplateEATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string data3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string data4 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string SerializedException { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))); } }

        #region Private
        internal SixStringsTemplateEATraceData(Action<SixStringsTemplateEATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<SixStringsTemplateEATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "data3", data3);
            XmlAttrib(sb, "data4", data4);
            XmlAttrib(sb, "SerializedException", SerializedException);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "data3", "data4", "SerializedException", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return data3;
                case 3:
                    return data4;
                case 4:
                    return SerializedException;
                case 5:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SixStringsTemplateEATraceData> Action;
        #endregion
    }
    public sealed class SevenStringsTemplateATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string data3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string data4 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string data5 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }
        public string data6 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))); } }

        #region Private
        internal SevenStringsTemplateATraceData(Action<SevenStringsTemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<SevenStringsTemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "data3", data3);
            XmlAttrib(sb, "data4", data4);
            XmlAttrib(sb, "data5", data5);
            XmlAttrib(sb, "data6", data6);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "data3", "data4", "data5", "data6", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return data3;
                case 3:
                    return data4;
                case 4:
                    return data5;
                case 5:
                    return data6;
                case 6:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SevenStringsTemplateATraceData> Action;
        #endregion
    }
    public sealed class FiveStringsTemplateATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string data3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string data4 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }

        #region Private
        internal FiveStringsTemplateATraceData(Action<FiveStringsTemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FiveStringsTemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "data3", data3);
            XmlAttrib(sb, "data4", data4);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "data3", "data4", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return data3;
                case 3:
                    return data4;
                case 4:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FiveStringsTemplateATraceData> Action;
        #endregion
    }
    public sealed class FourStringsTemplateATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string data3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal FourStringsTemplateATraceData(Action<FourStringsTemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FourStringsTemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "data3", data3);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "data3", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return data3;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FourStringsTemplateATraceData> Action;
        #endregion
    }
    public sealed class SixStringsTemplateATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string data3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string data4 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string data5 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))); } }

        #region Private
        internal SixStringsTemplateATraceData(Action<SixStringsTemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<SixStringsTemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "data3", data3);
            XmlAttrib(sb, "data4", data4);
            XmlAttrib(sb, "data5", data5);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "data3", "data4", "data5", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return data3;
                case 3:
                    return data4;
                case 4:
                    return data5;
                case 5:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SixStringsTemplateATraceData> Action;
        #endregion
    }
    public sealed class ThreeStringsTemplateATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal ThreeStringsTemplateATraceData(Action<ThreeStringsTemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ThreeStringsTemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ThreeStringsTemplateATraceData> Action;
        #endregion
    }
    public sealed class EightStringsTemplateEATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string data3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string data4 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string data5 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }
        public string data6 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))); } }
        public string SerializedException { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))); } }

        #region Private
        internal EightStringsTemplateEATraceData(Action<EightStringsTemplateEATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<EightStringsTemplateEATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "data3", data3);
            XmlAttrib(sb, "data4", data4);
            XmlAttrib(sb, "data5", data5);
            XmlAttrib(sb, "data6", data6);
            XmlAttrib(sb, "SerializedException", SerializedException);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "data3", "data4", "data5", "data6", "SerializedException", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return data3;
                case 3:
                    return data4;
                case 4:
                    return data5;
                case 5:
                    return data6;
                case 6:
                    return SerializedException;
                case 7:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<EightStringsTemplateEATraceData> Action;
        #endregion
    }
    public sealed class Multidata17TemplateATraceData : TraceEvent
    {
        public Guid Id { get { return GetGuidAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal Multidata17TemplateATraceData(Action<Multidata17TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata17TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(16)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Id", Id);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Id", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Id;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata17TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata56TemplateATraceData : TraceEvent
    {
        public string msg { get { return GetUnicodeStringAt(0); } }
        public string key { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata56TemplateATraceData(Action<Multidata56TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata56TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "msg", msg);
            XmlAttrib(sb, "key", key);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "msg", "key", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return msg;
                case 1:
                    return key;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata56TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata57TemplateATraceData : TraceEvent
    {
        public string msg { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata57TemplateATraceData(Action<Multidata57TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata57TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "msg", msg);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "msg", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return msg;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata57TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata58TemplateATraceData : TraceEvent
    {
        public int cur { get { return GetInt32At(0); } }
        public int max { get { return GetInt32At(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal Multidata58TemplateATraceData(Action<Multidata58TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata58TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "cur", cur);
            XmlAttrib(sb, "max", max);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "cur", "max", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return cur;
                case 1:
                    return max;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata58TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata59TemplateATraceData : TraceEvent
    {
        public string itemTypeName { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata59TemplateATraceData(Action<Multidata59TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata59TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "itemTypeName", itemTypeName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "itemTypeName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return itemTypeName;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata59TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata19TemplateATraceData : TraceEvent
    {
        public string id { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata19TemplateATraceData(Action<Multidata19TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata19TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "id", id);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "id", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return id;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata19TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata20TemplateATraceData : TraceEvent
    {
        public string expr { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata20TemplateATraceData(Action<Multidata20TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata20TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "expr", expr);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "expr", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return expr;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata20TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata21TemplateATraceData : TraceEvent
    {
        public string activityName { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata21TemplateATraceData(Action<Multidata21TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata21TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "activityName", activityName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "activityName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return activityName;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata21TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata33TemplateATraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata33TemplateATraceData(Action<Multidata33TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata33TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata33TemplateATraceData> Action;
        #endregion
    }
    public sealed class TwoStringsTemplateSATraceData : TraceEvent
    {
        public string EventSource { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal TwoStringsTemplateSATraceData(Action<TwoStringsTemplateSATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TwoStringsTemplateSATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "EventSource", EventSource);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "EventSource", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return EventSource;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TwoStringsTemplateSATraceData> Action;
        #endregion
    }
    public sealed class Multidata34TemplateATraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string ExceptionToString { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata34TemplateATraceData(Action<Multidata34TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata34TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "ExceptionToString", ExceptionToString);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "ExceptionToString", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return ExceptionToString;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata34TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata35TemplateSATraceData : TraceEvent
    {
        public int Count { get { return GetInt32At(0); } }
        public int MaxNum { get { return GetInt32At(4); } }
        public string EventSource { get { return GetUnicodeStringAt(8); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(8)); } }

        #region Private
        internal Multidata35TemplateSATraceData(Action<Multidata35TemplateSATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata35TemplateSATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(8))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(8))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Count", Count);
            XmlAttrib(sb, "MaxNum", MaxNum);
            XmlAttrib(sb, "EventSource", EventSource);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Count", "MaxNum", "EventSource", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Count;
                case 1:
                    return MaxNum;
                case 2:
                    return EventSource;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata35TemplateSATraceData> Action;
        #endregion
    }
    public sealed class Multidata36TemplateSATraceData : TraceEvent
    {
        public int Count { get { return GetInt32At(0); } }
        public string EventSource { get { return GetUnicodeStringAt(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(4)); } }

        #region Private
        internal Multidata36TemplateSATraceData(Action<Multidata36TemplateSATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata36TemplateSATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(4))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(4))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Count", Count);
            XmlAttrib(sb, "EventSource", EventSource);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Count", "EventSource", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Count;
                case 1:
                    return EventSource;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata36TemplateSATraceData> Action;
        #endregion
    }
    public sealed class Multidata37TemplateSATraceData : TraceEvent
    {
        public string TypeName { get { return GetUnicodeStringAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string EventSource { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata37TemplateSATraceData(Action<Multidata37TemplateSATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata37TemplateSATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "EventSource", EventSource);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TypeName", "Uri", "EventSource", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TypeName;
                case 1:
                    return Uri;
                case 2:
                    return EventSource;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata37TemplateSATraceData> Action;
        #endregion
    }
    public sealed class Multidata38TemplateHATraceData : TraceEvent
    {
        public string OperationName { get { return GetUnicodeStringAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata38TemplateHATraceData(Action<Multidata38TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata38TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OperationName", OperationName);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OperationName", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OperationName;
                case 1:
                    return HostReference;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata38TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata39TemplateSATraceData : TraceEvent
    {
        public int Size { get { return GetInt32At(0); } }
        public string EventSource { get { return GetUnicodeStringAt(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(4)); } }

        #region Private
        internal Multidata39TemplateSATraceData(Action<Multidata39TemplateSATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata39TemplateSATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(4))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(4))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Size", Size);
            XmlAttrib(sb, "EventSource", EventSource);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Size", "EventSource", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Size;
                case 1:
                    return EventSource;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata39TemplateSATraceData> Action;
        #endregion
    }
    public sealed class Multidata40TemplateATraceData : TraceEvent
    {
        public string RemoteAddress { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata40TemplateATraceData(Action<Multidata40TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata40TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "RemoteAddress", RemoteAddress);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RemoteAddress", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RemoteAddress;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata40TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata41TemplateATraceData : TraceEvent
    {
        public int ListenerHashCode { get { return GetInt32At(0); } }
        public int SocketHashCode { get { return GetInt32At(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal Multidata41TemplateATraceData(Action<Multidata41TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata41TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ListenerHashCode", ListenerHashCode);
            XmlAttrib(sb, "SocketHashCode", SocketHashCode);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ListenerHashCode", "SocketHashCode", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ListenerHashCode;
                case 1:
                    return SocketHashCode;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata41TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata42TemplateATraceData : TraceEvent
    {
        public string PoolKey { get { return GetUnicodeStringAt(0); } }
        public int busy { get { return GetInt32At(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0) + 4); } }

        #region Private
        internal Multidata42TemplateATraceData(Action<Multidata42TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata42TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0) + 4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0) + 4)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "PoolKey", PoolKey);
            XmlAttrib(sb, "busy", busy);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "PoolKey", "busy", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return PoolKey;
                case 1:
                    return busy;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata42TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata43TemplateATraceData : TraceEvent
    {
        public int ChannelId { get { return GetInt32At(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(4); } }

        #region Private
        internal Multidata43TemplateATraceData(Action<Multidata43TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata43TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ChannelId", ChannelId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ChannelId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ChannelId;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata43TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata44TemplateATraceData : TraceEvent
    {
        public string uri { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata44TemplateATraceData(Action<Multidata44TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata44TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "uri", uri);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "uri", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return uri;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata44TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata45TemplateATraceData : TraceEvent
    {
        public string Key { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata45TemplateATraceData(Action<Multidata45TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata45TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Key", Key);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Key", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Key;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata45TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata46TemplateATraceData : TraceEvent
    {
        public string Via { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata46TemplateATraceData(Action<Multidata46TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata46TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Via", Via);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Via", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Via;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata46TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata47TemplateATraceData : TraceEvent
    {
        public string FaultString { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata47TemplateATraceData(Action<Multidata47TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata47TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "FaultString", FaultString);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "FaultString", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return FaultString;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata47TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata48TemplateATraceData : TraceEvent
    {
        public string Uri { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata48TemplateATraceData(Action<Multidata48TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata48TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Uri", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Uri;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata48TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata49TemplateATraceData : TraceEvent
    {
        public int SocketId { get { return GetInt32At(0); } }
        public string Uri { get { return GetUnicodeStringAt(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(4)); } }

        #region Private
        internal Multidata49TemplateATraceData(Action<Multidata49TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata49TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(4))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(4))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SocketId", SocketId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SocketId", "Uri", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SocketId;
                case 1:
                    return Uri;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata49TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata50TemplateATraceData : TraceEvent
    {
        public string Status { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata50TemplateATraceData(Action<Multidata50TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata50TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Status", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Status;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata50TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata51TemplateATraceData : TraceEvent
    {
        public int SocketId { get { return GetInt32At(0); } }
        public int Size { get { return GetInt32At(4); } }
        public string Endpoint { get { return GetUnicodeStringAt(8); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(8)); } }

        #region Private
        internal Multidata51TemplateATraceData(Action<Multidata51TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata51TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(8))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(8))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SocketId", SocketId);
            XmlAttrib(sb, "Size", Size);
            XmlAttrib(sb, "Endpoint", Endpoint);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SocketId", "Size", "Endpoint", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SocketId;
                case 1:
                    return Size;
                case 2:
                    return Endpoint;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata51TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata52TemplateATraceData : TraceEvent
    {
        public string SessionId { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata52TemplateATraceData(Action<Multidata52TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata52TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SessionId", SessionId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SessionId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SessionId;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata52TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata53TemplateATraceData : TraceEvent
    {
        public int SocketId { get { return GetInt32At(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(4); } }

        #region Private
        internal Multidata53TemplateATraceData(Action<Multidata53TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata53TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SocketId", SocketId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SocketId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SocketId;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata53TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata54TemplateATraceData : TraceEvent
    {
        public string LocalId { get { return GetUnicodeStringAt(0); } }
        public Guid Distributed { get { return GetGuidAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0) + 16); } }

        #region Private
        internal Multidata54TemplateATraceData(Action<Multidata54TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata54TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0) + 16)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0) + 16)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LocalId", LocalId);
            XmlAttrib(sb, "Distributed", Distributed);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LocalId", "Distributed", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LocalId;
                case 1:
                    return Distributed;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata54TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata55TemplateATraceData : TraceEvent
    {
        public int BufferId { get { return GetInt32At(0); } }
        public int Size { get { return GetInt32At(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal Multidata55TemplateATraceData(Action<Multidata55TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata55TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "BufferId", BufferId);
            XmlAttrib(sb, "Size", Size);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "BufferId", "Size", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return BufferId;
                case 1:
                    return Size;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata55TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata60TemplateATraceData : TraceEvent
    {
        public string sharedMemoryName { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata60TemplateATraceData(Action<Multidata60TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata60TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "sharedMemoryName", sharedMemoryName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "sharedMemoryName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return sharedMemoryName;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata60TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata61TemplateATraceData : TraceEvent
    {
        public string pipeName { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata61TemplateATraceData(Action<Multidata61TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata61TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "pipeName", pipeName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "pipeName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return pipeName;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata61TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata62TemplateATraceData : TraceEvent
    {
        public string remoteAddress { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata62TemplateATraceData(Action<Multidata62TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata62TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "remoteAddress", remoteAddress);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "remoteAddress", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return remoteAddress;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata62TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata63TemplateATraceData : TraceEvent
    {
        public int websocketId { get { return GetInt32At(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(4); } }

        #region Private
        internal Multidata63TemplateATraceData(Action<Multidata63TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata63TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "websocketId", websocketId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "websocketId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return websocketId;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata63TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata64TemplateATraceData : TraceEvent
    {
        public string errorMessage { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata64TemplateATraceData(Action<Multidata64TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata64TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "errorMessage", errorMessage);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "errorMessage", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return errorMessage;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata64TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata65TemplateATraceData : TraceEvent
    {
        public int websocketId { get { return GetInt32At(0); } }
        public int byteCount { get { return GetInt32At(4); } }
        public string remoteAddress { get { return GetUnicodeStringAt(8); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(8)); } }

        #region Private
        internal Multidata65TemplateATraceData(Action<Multidata65TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata65TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(8))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(8))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "websocketId", websocketId);
            XmlAttrib(sb, "byteCount", byteCount);
            XmlAttrib(sb, "remoteAddress", remoteAddress);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "websocketId", "byteCount", "remoteAddress", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return websocketId;
                case 1:
                    return byteCount;
                case 2:
                    return remoteAddress;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata65TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata66TemplateATraceData : TraceEvent
    {
        public int websocketId { get { return GetInt32At(0); } }
        public string remoteAddress { get { return GetUnicodeStringAt(4); } }
        public string closeStatus { get { return GetUnicodeStringAt(SkipUnicodeString(4)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(4))); } }

        #region Private
        internal Multidata66TemplateATraceData(Action<Multidata66TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata66TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(4)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(4)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "websocketId", websocketId);
            XmlAttrib(sb, "remoteAddress", remoteAddress);
            XmlAttrib(sb, "closeStatus", closeStatus);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "websocketId", "remoteAddress", "closeStatus", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return websocketId;
                case 1:
                    return remoteAddress;
                case 2:
                    return closeStatus;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata66TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata67TemplateATraceData : TraceEvent
    {
        public int websocketId { get { return GetInt32At(0); } }
        public string closeStatus { get { return GetUnicodeStringAt(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(4)); } }

        #region Private
        internal Multidata67TemplateATraceData(Action<Multidata67TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata67TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(4))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(4))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "websocketId", websocketId);
            XmlAttrib(sb, "closeStatus", closeStatus);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "websocketId", "closeStatus", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return websocketId;
                case 1:
                    return closeStatus;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata67TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata68TemplateATraceData : TraceEvent
    {
        public string clientWebSocketFactoryType { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata68TemplateATraceData(Action<Multidata68TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata68TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "clientWebSocketFactoryType", clientWebSocketFactoryType);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "clientWebSocketFactoryType", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return clientWebSocketFactoryType;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata68TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata85TemplateATraceData : TraceEvent
    {
        public string TrackingProfile { get { return GetUnicodeStringAt(0); } }
        public string ActivityDefinitionId { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata85TemplateATraceData(Action<Multidata85TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata85TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TrackingProfile", TrackingProfile);
            XmlAttrib(sb, "ActivityDefinitionId", ActivityDefinitionId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TrackingProfile", "ActivityDefinitionId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TrackingProfile;
                case 1:
                    return ActivityDefinitionId;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata85TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata84TemplateATraceData : TraceEvent
    {
        public int limit { get { return GetInt32At(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(4); } }

        #region Private
        internal Multidata84TemplateATraceData(Action<Multidata84TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata84TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "limit", limit);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "limit", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return limit;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata84TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata76TemplateATraceData : TraceEvent
    {
        public long availableMemoryBytes { get { return GetInt64At(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal Multidata76TemplateATraceData(Action<Multidata76TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata76TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "availableMemoryBytes", availableMemoryBytes);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "availableMemoryBytes", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return availableMemoryBytes;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata76TemplateATraceData> Action;
        #endregion
    }
    public sealed class TwoStringsTemplateEATraceData : TraceEvent
    {
        public string SerializedException { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal TwoStringsTemplateEATraceData(Action<TwoStringsTemplateEATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TwoStringsTemplateEATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SerializedException", SerializedException);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SerializedException", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SerializedException;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TwoStringsTemplateEATraceData> Action;
        #endregion
    }
    public sealed class Multidata77TemplateATraceData : TraceEvent
    {
        public string via { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata77TemplateATraceData(Action<Multidata77TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata77TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "via", via);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "via", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return via;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata77TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata78TemplateATraceData : TraceEvent
    {
        public string Endpoint { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata78TemplateATraceData(Action<Multidata78TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata78TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Endpoint", Endpoint);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Endpoint", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Endpoint;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata78TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata79TemplateATraceData : TraceEvent
    {
        public string Uri { get { return GetUnicodeStringAt(0); } }
        public int count { get { return GetInt32At(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0) + 4); } }

        #region Private
        internal Multidata79TemplateATraceData(Action<Multidata79TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata79TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0) + 4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0) + 4)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "count", count);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Uri", "count", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Uri;
                case 1:
                    return count;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata79TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata81TemplateATraceData : TraceEvent
    {
        public string Status { get { return GetUnicodeStringAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata81TemplateATraceData(Action<Multidata81TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata81TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Status", "Uri", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Status;
                case 1:
                    return Uri;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata81TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata80TemplateATraceData : TraceEvent
    {
        public string Uri { get { return GetUnicodeStringAt(0); } }
        public string Status { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata80TemplateATraceData(Action<Multidata80TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata80TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Uri", "Status", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Uri;
                case 1:
                    return Status;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata80TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata82TemplateATraceData : TraceEvent
    {
        public string hresult { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata82TemplateATraceData(Action<Multidata82TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata82TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "hresult", hresult);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "hresult", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return hresult;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata82TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata83TemplateATraceData : TraceEvent
    {
        public int curr { get { return GetInt32At(0); } }
        public int max { get { return GetInt32At(4); } }
        public string AppDomain { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal Multidata83TemplateATraceData(Action<Multidata83TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata83TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "curr", curr);
            XmlAttrib(sb, "max", max);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "curr", "max", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return curr;
                case 1:
                    return max;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata83TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata87TemplateATraceData : TraceEvent
    {
        public string discoveryMessageName { get { return GetUnicodeStringAt(0); } }
        public string messageId { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string discoveryOperationName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata87TemplateATraceData(Action<Multidata87TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata87TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "discoveryMessageName", discoveryMessageName);
            XmlAttrib(sb, "messageId", messageId);
            XmlAttrib(sb, "discoveryOperationName", discoveryOperationName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "discoveryMessageName", "messageId", "discoveryOperationName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return discoveryMessageName;
                case 1:
                    return messageId;
                case 2:
                    return discoveryOperationName;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata87TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata88TemplateATraceData : TraceEvent
    {
        public string messageType { get { return GetUnicodeStringAt(0); } }
        public string messageId { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata88TemplateATraceData(Action<Multidata88TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata88TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "messageType", messageType);
            XmlAttrib(sb, "messageId", messageId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "messageType", "messageId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return messageType;
                case 1:
                    return messageId;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata88TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata89TemplateATraceData : TraceEvent
    {
        public string discoveryMessageName { get { return GetUnicodeStringAt(0); } }
        public string messageId { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string relatesTo { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string discoveryOperationName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }

        #region Private
        internal Multidata89TemplateATraceData(Action<Multidata89TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata89TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "discoveryMessageName", discoveryMessageName);
            XmlAttrib(sb, "messageId", messageId);
            XmlAttrib(sb, "relatesTo", relatesTo);
            XmlAttrib(sb, "discoveryOperationName", discoveryOperationName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "discoveryMessageName", "messageId", "relatesTo", "discoveryOperationName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return discoveryMessageName;
                case 1:
                    return messageId;
                case 2:
                    return relatesTo;
                case 3:
                    return discoveryOperationName;
                case 4:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata89TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata90TemplateATraceData : TraceEvent
    {
        public string messageId { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata90TemplateATraceData(Action<Multidata90TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata90TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "messageId", messageId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "messageId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return messageId;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata90TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata91TemplateATraceData : TraceEvent
    {
        public string messageType { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata91TemplateATraceData(Action<Multidata91TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata91TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "messageType", messageType);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "messageType", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return messageType;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata91TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata92TemplateATraceData : TraceEvent
    {
        public string discoveryMessageName { get { return GetUnicodeStringAt(0); } }
        public string messageId { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata92TemplateATraceData(Action<Multidata92TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata92TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "discoveryMessageName", discoveryMessageName);
            XmlAttrib(sb, "messageId", messageId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "discoveryMessageName", "messageId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return discoveryMessageName;
                case 1:
                    return messageId;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata92TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata93TemplateATraceData : TraceEvent
    {
        public string endpointAddress { get { return GetUnicodeStringAt(0); } }
        public string listenUri { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata93TemplateATraceData(Action<Multidata93TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata93TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "endpointAddress", endpointAddress);
            XmlAttrib(sb, "listenUri", listenUri);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "endpointAddress", "listenUri", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return endpointAddress;
                case 1:
                    return listenUri;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata93TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata94TemplateEATraceData : TraceEvent
    {
        public string endpointAddress { get { return GetUnicodeStringAt(0); } }
        public string via { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string SerializedException { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata94TemplateEATraceData(Action<Multidata94TemplateEATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata94TemplateEATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "endpointAddress", endpointAddress);
            XmlAttrib(sb, "via", via);
            XmlAttrib(sb, "SerializedException", SerializedException);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "endpointAddress", "via", "SerializedException", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return endpointAddress;
                case 1:
                    return via;
                case 2:
                    return SerializedException;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata94TemplateEATraceData> Action;
        #endregion
    }
    public sealed class Multidata95TemplateATraceData : TraceEvent
    {
        public string endpointAddress { get { return GetUnicodeStringAt(0); } }
        public string via { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata95TemplateATraceData(Action<Multidata95TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata95TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "endpointAddress", endpointAddress);
            XmlAttrib(sb, "via", via);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "endpointAddress", "via", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return endpointAddress;
                case 1:
                    return via;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata95TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata96TemplateATraceData : TraceEvent
    {
        public string synchronizationContextType { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata96TemplateATraceData(Action<Multidata96TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata96TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "synchronizationContextType", synchronizationContextType);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "synchronizationContextType", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return synchronizationContextType;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata96TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata97TemplateATraceData : TraceEvent
    {
        public string SurrogateType { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata97TemplateATraceData(Action<Multidata97TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata97TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SurrogateType", SurrogateType);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SurrogateType", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SurrogateType;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata97TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata98TemplateATraceData : TraceEvent
    {
        public string Kind { get { return GetUnicodeStringAt(0); } }
        public string TypeName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata98TemplateATraceData(Action<Multidata98TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata98TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Kind", Kind);
            XmlAttrib(sb, "TypeName", TypeName);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Kind", "TypeName", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Kind;
                case 1:
                    return TypeName;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata98TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata99TemplateATraceData : TraceEvent
    {
        public string DCType { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata99TemplateATraceData(Action<Multidata99TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata99TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "DCType", DCType);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "DCType", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return DCType;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata99TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata103TemplateHATraceData : TraceEvent
    {
        public string tokenType { get { return GetUnicodeStringAt(0); } }
        public string tokenID { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata103TemplateHATraceData(Action<Multidata103TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata103TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "tokenType", tokenType);
            XmlAttrib(sb, "tokenID", tokenID);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "tokenType", "tokenID", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return tokenType;
                case 1:
                    return tokenID;
                case 2:
                    return HostReference;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata103TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata102TemplateHATraceData : TraceEvent
    {
        public string tokenType { get { return GetUnicodeStringAt(0); } }
        public string tokenID { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string errorMessage { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }

        #region Private
        internal Multidata102TemplateHATraceData(Action<Multidata102TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata102TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "tokenType", tokenType);
            XmlAttrib(sb, "tokenID", tokenID);
            XmlAttrib(sb, "errorMessage", errorMessage);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "tokenType", "tokenID", "errorMessage", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return tokenType;
                case 1:
                    return tokenID;
                case 2:
                    return errorMessage;
                case 3:
                    return HostReference;
                case 4:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata102TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata101TemplateHATraceData : TraceEvent
    {
        public string issuerName { get { return GetUnicodeStringAt(0); } }
        public string tokenID { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata101TemplateHATraceData(Action<Multidata101TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata101TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "issuerName", issuerName);
            XmlAttrib(sb, "tokenID", tokenID);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "issuerName", "tokenID", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return issuerName;
                case 1:
                    return tokenID;
                case 2:
                    return HostReference;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata101TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata100TemplateHATraceData : TraceEvent
    {
        public string tokenID { get { return GetUnicodeStringAt(0); } }
        public string HostReference { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata100TemplateHATraceData(Action<Multidata100TemplateHATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata100TemplateHATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "tokenID", tokenID);
            XmlAttrib(sb, "HostReference", HostReference);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "tokenID", "HostReference", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return tokenID;
                case 1:
                    return HostReference;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata100TemplateHATraceData> Action;
        #endregion
    }
    public sealed class Multidata15TemplateATraceData : TraceEvent
    {
        public long RecordNumber { get { return GetInt64At(0); } }
        public Guid ProviderId { get { return GetGuidAt(8); } }
        public string AppDomain { get { return GetUnicodeStringAt(24); } }

        #region Private
        internal Multidata15TemplateATraceData(Action<Multidata15TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata15TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(24)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(24)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "RecordNumber", RecordNumber);
            XmlAttrib(sb, "ProviderId", ProviderId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RecordNumber", "ProviderId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RecordNumber;
                case 1:
                    return ProviderId;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata15TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata16TemplateATraceData : TraceEvent
    {
        public string Data { get { return GetUnicodeStringAt(0); } }
        public string Activity { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal Multidata16TemplateATraceData(Action<Multidata16TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata16TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Data", Data);
            XmlAttrib(sb, "Activity", Activity);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Data", "Activity", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Data;
                case 1:
                    return Activity;
                case 2:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata16TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata18TemplateATraceData : TraceEvent
    {
        public string name { get { return GetUnicodeStringAt(0); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

        #region Private
        internal Multidata18TemplateATraceData(Action<Multidata18TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata18TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "name", name);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "name", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return name;
                case 1:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata18TemplateATraceData> Action;
        #endregion
    }
    public sealed class Multidata0TemplateATraceData : TraceEvent
    {
        public string appdomainName { get { return GetUnicodeStringAt(0); } }
        public string processName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string processId { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal Multidata0TemplateATraceData(Action<Multidata0TemplateATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<Multidata0TemplateATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "appdomainName", appdomainName);
            XmlAttrib(sb, "processName", processName);
            XmlAttrib(sb, "processId", processId);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "appdomainName", "processName", "processId", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return appdomainName;
                case 1:
                    return processName;
                case 2:
                    return processId;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Multidata0TemplateATraceData> Action;
        #endregion
    }
    public sealed class FourStringsTemplateEATraceData : TraceEvent
    {
        public string data1 { get { return GetUnicodeStringAt(0); } }
        public string data2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string SerializedException { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
        public string AppDomain { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }

        #region Private
        internal FourStringsTemplateEATraceData(Action<FourStringsTemplateEATraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<FourStringsTemplateEATraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "data1", data1);
            XmlAttrib(sb, "data2", data2);
            XmlAttrib(sb, "SerializedException", SerializedException);
            XmlAttrib(sb, "AppDomain", AppDomain);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "data1", "data2", "SerializedException", "AppDomain" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return data1;
                case 1:
                    return data2;
                case 2:
                    return SerializedException;
                case 3:
                    return AppDomain;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FourStringsTemplateEATraceData> Action;
        #endregion
    }

}
