using System;
using System.Diagnostics;
using System.Text;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers.AspNet
{
    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "1.0")]
    public sealed class AspNetTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "AspNetTrace";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0xaff081fe), unchecked((short)0x0247), unchecked((short)0x4275), 0x9c, 0x4e, 0x02, 0x1f, 0x3d, 0xc1, 0xda, 0x35);
        public AspNetTraceEventParser(TraceEventSource source) : base(source) { }

        public enum Keywords
        {
            None = 0,
            Infrastructure = 1,
            Module = 2,
            Page = 4,
            AppSvc = 8,
        };

        public event Action<AspNetStartTraceData> AspNetReqStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetStartTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetStopTraceData> AspNetReqStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetStopTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetRequestQueuedTraceData> AspNetReqRequestQueued
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetRequestQueuedTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 3, "RequestQueued", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetRequestDequeuedTraceData> AspNetReqRequestDequeued
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetRequestDequeuedTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 4, "RequestDequeued", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetGetAppDomainEnterTraceData> AspNetReqGetAppDomainEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetGetAppDomainEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 5, "GetAppDomainEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetGetAppDomainLeaveTraceData> AspNetReqGetAppDomainLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetGetAppDomainLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 6, "GetAppDomainLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 6, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetAppDomainEnterTraceData> AspNetReqAppDomainEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetAppDomainEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 7, "AppDomainEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 7, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetStartHandlerTraceData> AspNetReqStartHandler
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetStartHandlerTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 8, "StartHandler", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 8, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetEndHandlerTraceData> AspNetReqEndHandler
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetEndHandlerTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 9, "EndHandler", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 9, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPipelineModuleEnterTraceData> AspNetReqPipelineModuleEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPipelineModuleEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 10, "PipelineModuleEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPipelineModuleLeaveTraceData> AspNetReqPipelineModuleLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPipelineModuleLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 11, "PipelineModuleLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetMapHandlerEnterTraceData> AspNetReqMapHandlerEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetMapHandlerEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 12, "MapHandlerEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetMapHandlerLeaveTraceData> AspNetReqMapHandlerLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetMapHandlerLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 13, "MapHandlerLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetParseEnterTraceData> AspNetReqParseEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetParseEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 14, "ParseEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 14, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetParseLeaveTraceData> AspNetReqParseLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetParseLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 15, "ParseLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 15, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetCompileEnterTraceData> AspNetReqCompileEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetCompileEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 16, "CompileEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 16, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetCompileLeaveTraceData> AspNetReqCompileLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetCompileLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 17, "CompileLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 17, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetHttpHandlerEnterTraceData> AspNetReqHttpHandlerEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetHttpHandlerEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 18, "HttpHandlerEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 18, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetHttpHandlerLeaveTraceData> AspNetReqHttpHandlerLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetHttpHandlerLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 19, "HttpHandlerLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 19, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetSessionStatePartitionStartTraceData> AspNetReqSessionStatePartitionStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetSessionStatePartitionStartTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 20, "SessionStatePartitionStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 20, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetSessionStatePartitionEndTraceData> AspNetReqSessionStatePartitionEnd
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetSessionStatePartitionEndTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 21, "SessionStatePartitionEnd", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 21, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPagePreInitEnterTraceData> AspNetReqPagePreInitEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPagePreInitEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 22, "PagePreInitEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 22, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPagePreInitLeaveTraceData> AspNetReqPagePreInitLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPagePreInitLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 23, "PagePreInitLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 23, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageInitEnterTraceData> AspNetReqPageInitEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageInitEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 24, "PageInitEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 24, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageInitLeaveTraceData> AspNetReqPageInitLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageInitLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 25, "PageInitLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 25, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageLoadViewstateEnterTraceData> AspNetReqPageLoadViewstateEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageLoadViewstateEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 26, "PageLoadViewstateEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 26, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageLoadViewstateLeaveTraceData> AspNetReqPageLoadViewstateLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageLoadViewstateLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 27, "PageLoadViewstateLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 27, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageLoadPostDataEnterTraceData> AspNetReqPageLoadPostDataEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageLoadPostDataEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 28, "PageLoadPostDataEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 28, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageLoadPostDataLeaveTraceData> AspNetReqPageLoadPostDataLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageLoadPostDataLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 29, "PageLoadPostDataLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 29, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageLoadEnterTraceData> AspNetReqPageLoadEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageLoadEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 30, "PageLoadEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 30, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageLoadLeaveTraceData> AspNetReqPageLoadLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageLoadLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 31, "PageLoadLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 31, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPagePostDataChangedEnterTraceData> AspNetReqPagePostDataChangedEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPagePostDataChangedEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 32, "PagePostDataChangedEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 32, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPagePostDataChangedLeaveTraceData> AspNetReqPagePostDataChangedLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPagePostDataChangedLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 33, "PagePostDataChangedLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 33, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageRaisePostbackEnterTraceData> AspNetReqPageRaisePostbackEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageRaisePostbackEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 34, "PageRaisePostbackEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 34, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageRaisePostbackLeaveTraceData> AspNetReqPageRaisePostbackLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageRaisePostbackLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 35, "PageRaisePostbackLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 35, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPagePreRenderEnterTraceData> AspNetReqPagePreRenderEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPagePreRenderEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 36, "PagePreRenderEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 36, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPagePreRenderLeaveTraceData> AspNetReqPagePreRenderLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPagePreRenderLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 37, "PagePreRenderLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 37, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageSaveViewstateEnterTraceData> AspNetReqPageSaveViewstateEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageSaveViewstateEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 38, "PageSaveViewstateEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 38, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageSaveViewstateLeaveTraceData> AspNetReqPageSaveViewstateLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageSaveViewstateLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 39, "PageSaveViewstateLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 39, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageRenderEnterTraceData> AspNetReqPageRenderEnter
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageRenderEnterTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 40, "PageRenderEnter", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 40, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageRenderLeaveTraceData> AspNetReqPageRenderLeave
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageRenderLeaveTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 41, "PageRenderLeave", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 41, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetAcquireSessionBeginTraceData> AspNetReqSessionDataBegin
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetAcquireSessionBeginTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 42, "SessionDataBegin", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 42, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetAcquireSessionEndTraceData> AspNetReqSessionDataEnd
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetAcquireSessionEndTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 43, "SessionDataEnd", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 43, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetProfileBeginTraceData> AspNetReqProfileBegin
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetProfileBeginTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 44, "ProfileBegin", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 44, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetProfileEndTraceData> AspNetReqProfileEnd
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetProfileEndTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 45, "ProfileEnd", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 45, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetRoleManagerIsUserInRoleTraceData> AspNetReqRoleManagerIsUserInRole
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetRoleManagerIsUserInRoleTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 46, "RoleManagerIsUserInRole", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 46, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetRoleManagerGetUserRolesTraceData> AspNetReqRoleManagerGetUserRoles
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetRoleManagerGetUserRolesTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 47, "RoleManagerGetUserRoles", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 47, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetRoleManagerBeginTraceData> AspNetReqRoleManagerBegin
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetRoleManagerBeginTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 48, "RoleManagerBegin", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 48, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetRoleManagerEndTraceData> AspNetReqRoleManagerEnd
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetRoleManagerEndTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 49, "RoleManagerEnd", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 49, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetWebEventRaiseStartTraceData> AspNetReqWebEventRaiseStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetWebEventRaiseStartTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 50, "WebEventRaiseStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 50, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetWebEventRaiseEndTraceData> AspNetReqWebEventRaiseEnd
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetWebEventRaiseEndTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 51, "WebEventRaiseEnd", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 51, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetWebEventDeliverStartTraceData> AspNetReqWebEventDeliverStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetWebEventDeliverStartTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 52, "WebEventDeliverStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 52, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetWebEventDeliverEndTraceData> AspNetReqWebEventDeliverEnd
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetWebEventDeliverEndTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 53, "WebEventDeliverEnd", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 53, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageTraceWarnEventTraceData> AspNetReqTraceContextWarning
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageTraceWarnEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 59, "TraceContextWarning", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 59, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetPageTraceWriteEventTraceData> AspNetReqTraceContextWrite
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetPageTraceWriteEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 60, "TraceContextWrite", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 60, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagCriticalEventTraceData> AspNetReqDiagnosticTraceCritical
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagCriticalEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 61, "DiagnosticTraceCritical", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 61, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagErrorEventTraceData> AspNetReqDiagnosticTraceError
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagErrorEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 62, "DiagnosticTraceError", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 62, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagWarningEventTraceData> AspNetReqDiagnosticTraceWarning
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagWarningEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 63, "DiagnosticTraceWarning", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 63, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagInfoEventTraceData> AspNetReqDiagnosticTraceInfo
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagInfoEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 64, "DiagnosticTraceInfo", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 64, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagVerboseEventTraceData> AspNetReqDiagnosticTraceVerbose
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagVerboseEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 65, "DiagnosticTraceVerbose", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 65, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagStartEventTraceData> AspNetReqDiagnosticTraceStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagStartEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 66, "DiagnosticTraceStart", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 66, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagStopEventTraceData> AspNetReqDiagnosticTraceStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagStopEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 67, "DiagnosticTraceStop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 67, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagSuspendEventTraceData> AspNetReqDiagnosticTraceSuspend
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagSuspendEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 68, "DiagnosticTraceSuspend", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 68, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagResumeEventTraceData> AspNetReqDiagnosticTraceResume
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagResumeEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 69, "DiagnosticTraceResume", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 69, AspNetReqTaskGuid);
            }
        }
        public event Action<AspNetModuleDiagTransferEventTraceData> AspNetReqDiagnosticTraceTransfer
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new AspNetModuleDiagTransferEventTraceData(value, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 70, "DiagnosticTraceTransfer", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 70, AspNetReqTaskGuid);
            }
        }

        #region Event ID Definitions
        private const TraceEventID AspNetReqStartEventID = (TraceEventID)10000;
        private const TraceEventID AspNetReqEndEventID = (TraceEventID)10001;
        private const TraceEventID AspNetReqRequestQueuedEventID = (TraceEventID)10002;
        private const TraceEventID AspNetReqRequestDequeuedEventID = (TraceEventID)10003;
        private const TraceEventID AspNetReqGetAppDomainEnterEventID = (TraceEventID)10004;
        private const TraceEventID AspNetReqGetAppDomainLeaveEventID = (TraceEventID)10005;
        private const TraceEventID AspNetReqAppDomainEnterEventID = (TraceEventID)10006;
        private const TraceEventID AspNetReqStartHandlerEventID = (TraceEventID)10007;
        private const TraceEventID AspNetReqEndHandlerEventID = (TraceEventID)10008;
        private const TraceEventID AspNetReqPipelineModuleEnterEventID = (TraceEventID)10009;
        private const TraceEventID AspNetReqPipelineModuleLeaveEventID = (TraceEventID)10010;
        private const TraceEventID AspNetReqMapHandlerEnterEventID = (TraceEventID)10011;
        private const TraceEventID AspNetReqMapHandlerLeaveEventID = (TraceEventID)10012;
        private const TraceEventID AspNetReqParseEnterEventID = (TraceEventID)10013;
        private const TraceEventID AspNetReqParseLeaveEventID = (TraceEventID)10014;
        private const TraceEventID AspNetReqCompileEnterEventID = (TraceEventID)10015;
        private const TraceEventID AspNetReqCompileLeaveEventID = (TraceEventID)10016;
        private const TraceEventID AspNetReqHttpHandlerEnterEventID = (TraceEventID)10017;
        private const TraceEventID AspNetReqHttpHandlerLeaveEventID = (TraceEventID)10018;
        private const TraceEventID AspNetReqSessionStatePartitionStartEventID = (TraceEventID)10019;
        private const TraceEventID AspNetReqSessionStatePartitionEndEventID = (TraceEventID)10020;
        private const TraceEventID AspNetReqPagePreInitEnterEventID = (TraceEventID)10021;
        private const TraceEventID AspNetReqPagePreInitLeaveEventID = (TraceEventID)10022;
        private const TraceEventID AspNetReqPageInitEnterEventID = (TraceEventID)10023;
        private const TraceEventID AspNetReqPageInitLeaveEventID = (TraceEventID)10024;
        private const TraceEventID AspNetReqPageLoadViewstateEnterEventID = (TraceEventID)10025;
        private const TraceEventID AspNetReqPageLoadViewstateLeaveEventID = (TraceEventID)10026;
        private const TraceEventID AspNetReqPageLoadPostDataEnterEventID = (TraceEventID)10027;
        private const TraceEventID AspNetReqPageLoadPostDataLeaveEventID = (TraceEventID)10028;
        private const TraceEventID AspNetReqPageLoadEnterEventID = (TraceEventID)10029;
        private const TraceEventID AspNetReqPageLoadLeaveEventID = (TraceEventID)10030;
        private const TraceEventID AspNetReqPagePostDataChangedEnterEventID = (TraceEventID)10031;
        private const TraceEventID AspNetReqPagePostDataChangedLeaveEventID = (TraceEventID)10032;
        private const TraceEventID AspNetReqPageRaisePostbackEnterEventID = (TraceEventID)10033;
        private const TraceEventID AspNetReqPageRaisePostbackLeaveEventID = (TraceEventID)10034;
        private const TraceEventID AspNetReqPagePreRenderEnterEventID = (TraceEventID)10035;
        private const TraceEventID AspNetReqPagePreRenderLeaveEventID = (TraceEventID)10036;
        private const TraceEventID AspNetReqPageSaveViewstateEnterEventID = (TraceEventID)10037;
        private const TraceEventID AspNetReqPageSaveViewstateLeaveEventID = (TraceEventID)10038;
        private const TraceEventID AspNetReqPageRenderEnterEventID = (TraceEventID)10039;
        private const TraceEventID AspNetReqPageRenderLeaveEventID = (TraceEventID)10040;
        private const TraceEventID AspNetReqSessionDataBeginEventID = (TraceEventID)10041;
        private const TraceEventID AspNetReqSessionDataEndEventID = (TraceEventID)10042;
        private const TraceEventID AspNetReqProfileBeginEventID = (TraceEventID)10043;
        private const TraceEventID AspNetReqProfileEndEventID = (TraceEventID)10044;
        private const TraceEventID AspNetReqRoleManagerIsUserInRoleEventID = (TraceEventID)10045;
        private const TraceEventID AspNetReqRoleManagerGetUserRolesEventID = (TraceEventID)10046;
        private const TraceEventID AspNetReqRoleManagerBeginEventID = (TraceEventID)10047;
        private const TraceEventID AspNetReqRoleManagerEndEventID = (TraceEventID)10048;
        private const TraceEventID AspNetReqWebEventRaiseStartEventID = (TraceEventID)10049;
        private const TraceEventID AspNetReqWebEventRaiseEndEventID = (TraceEventID)10050;
        private const TraceEventID AspNetReqWebEventDeliverStartEventID = (TraceEventID)10051;
        private const TraceEventID AspNetReqWebEventDeliverEndEventID = (TraceEventID)10052;
        private const TraceEventID AspNetReqTraceContextWarningEventID = (TraceEventID)10053;
        private const TraceEventID AspNetReqTraceContextWriteEventID = (TraceEventID)10054;
        private const TraceEventID AspNetReqDiagnosticTraceCriticalEventID = (TraceEventID)10055;
        private const TraceEventID AspNetReqDiagnosticTraceErrorEventID = (TraceEventID)10056;
        private const TraceEventID AspNetReqDiagnosticTraceWarningEventID = (TraceEventID)10057;
        private const TraceEventID AspNetReqDiagnosticTraceInfoEventID = (TraceEventID)10058;
        private const TraceEventID AspNetReqDiagnosticTraceVerboseEventID = (TraceEventID)10059;
        private const TraceEventID AspNetReqDiagnosticTraceStartEventID = (TraceEventID)10060;
        private const TraceEventID AspNetReqDiagnosticTraceStopEventID = (TraceEventID)10061;
        private const TraceEventID AspNetReqDiagnosticTraceSuspendEventID = (TraceEventID)10062;
        private const TraceEventID AspNetReqDiagnosticTraceResumeEventID = (TraceEventID)10063;
        private const TraceEventID AspNetReqDiagnosticTraceTransferEventID = (TraceEventID)10064;
        #endregion

        #region private
        protected override string GetProviderName() { return ProviderName; }
        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[65];
                templates[0] = new AspNetStartTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 1, "Start", ProviderGuid, ProviderName);
                templates[1] = new AspNetStopTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 2, "Stop", ProviderGuid, ProviderName);
                templates[2] = new AspNetRequestQueuedTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 3, "RequestQueued", ProviderGuid, ProviderName);
                templates[3] = new AspNetRequestDequeuedTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 4, "RequestDequeued", ProviderGuid, ProviderName);
                templates[4] = new AspNetGetAppDomainEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 5, "GetAppDomainEnter", ProviderGuid, ProviderName);
                templates[5] = new AspNetGetAppDomainLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 6, "GetAppDomainLeave", ProviderGuid, ProviderName);
                templates[6] = new AspNetAppDomainEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 7, "AppDomainEnter", ProviderGuid, ProviderName);
                templates[7] = new AspNetStartHandlerTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 8, "StartHandler", ProviderGuid, ProviderName);
                templates[8] = new AspNetEndHandlerTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 9, "EndHandler", ProviderGuid, ProviderName);
                templates[9] = new AspNetPipelineModuleEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 10, "PipelineModuleEnter", ProviderGuid, ProviderName);
                templates[10] = new AspNetPipelineModuleLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 11, "PipelineModuleLeave", ProviderGuid, ProviderName);
                templates[11] = new AspNetMapHandlerEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 12, "MapHandlerEnter", ProviderGuid, ProviderName);
                templates[12] = new AspNetMapHandlerLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 13, "MapHandlerLeave", ProviderGuid, ProviderName);
                templates[13] = new AspNetParseEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 14, "ParseEnter", ProviderGuid, ProviderName);
                templates[14] = new AspNetParseLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 15, "ParseLeave", ProviderGuid, ProviderName);
                templates[15] = new AspNetCompileEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 16, "CompileEnter", ProviderGuid, ProviderName);
                templates[16] = new AspNetCompileLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 17, "CompileLeave", ProviderGuid, ProviderName);
                templates[17] = new AspNetHttpHandlerEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 18, "HttpHandlerEnter", ProviderGuid, ProviderName);
                templates[18] = new AspNetHttpHandlerLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 19, "HttpHandlerLeave", ProviderGuid, ProviderName);
                templates[19] = new AspNetSessionStatePartitionStartTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 20, "SessionStatePartitionStart", ProviderGuid, ProviderName);
                templates[20] = new AspNetSessionStatePartitionEndTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 21, "SessionStatePartitionEnd", ProviderGuid, ProviderName);
                templates[21] = new AspNetPagePreInitEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 22, "PagePreInitEnter", ProviderGuid, ProviderName);
                templates[22] = new AspNetPagePreInitLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 23, "PagePreInitLeave", ProviderGuid, ProviderName);
                templates[23] = new AspNetPageInitEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 24, "PageInitEnter", ProviderGuid, ProviderName);
                templates[24] = new AspNetPageInitLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 25, "PageInitLeave", ProviderGuid, ProviderName);
                templates[25] = new AspNetPageLoadViewstateEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 26, "PageLoadViewstateEnter", ProviderGuid, ProviderName);
                templates[26] = new AspNetPageLoadViewstateLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 27, "PageLoadViewstateLeave", ProviderGuid, ProviderName);
                templates[27] = new AspNetPageLoadPostDataEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 28, "PageLoadPostDataEnter", ProviderGuid, ProviderName);
                templates[28] = new AspNetPageLoadPostDataLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 29, "PageLoadPostDataLeave", ProviderGuid, ProviderName);
                templates[29] = new AspNetPageLoadEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 30, "PageLoadEnter", ProviderGuid, ProviderName);
                templates[30] = new AspNetPageLoadLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 31, "PageLoadLeave", ProviderGuid, ProviderName);
                templates[31] = new AspNetPagePostDataChangedEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 32, "PagePostDataChangedEnter", ProviderGuid, ProviderName);
                templates[32] = new AspNetPagePostDataChangedLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 33, "PagePostDataChangedLeave", ProviderGuid, ProviderName);
                templates[33] = new AspNetPageRaisePostbackEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 34, "PageRaisePostbackEnter", ProviderGuid, ProviderName);
                templates[34] = new AspNetPageRaisePostbackLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 35, "PageRaisePostbackLeave", ProviderGuid, ProviderName);
                templates[35] = new AspNetPagePreRenderEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 36, "PagePreRenderEnter", ProviderGuid, ProviderName);
                templates[36] = new AspNetPagePreRenderLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 37, "PagePreRenderLeave", ProviderGuid, ProviderName);
                templates[37] = new AspNetPageSaveViewstateEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 38, "PageSaveViewstateEnter", ProviderGuid, ProviderName);
                templates[38] = new AspNetPageSaveViewstateLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 39, "PageSaveViewstateLeave", ProviderGuid, ProviderName);
                templates[39] = new AspNetPageRenderEnterTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 40, "PageRenderEnter", ProviderGuid, ProviderName);
                templates[40] = new AspNetPageRenderLeaveTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 41, "PageRenderLeave", ProviderGuid, ProviderName);
                templates[41] = new AspNetAcquireSessionBeginTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 42, "SessionDataBegin", ProviderGuid, ProviderName);
                templates[42] = new AspNetAcquireSessionEndTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 43, "SessionDataEnd", ProviderGuid, ProviderName);
                templates[43] = new AspNetProfileBeginTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 44, "ProfileBegin", ProviderGuid, ProviderName);
                templates[44] = new AspNetProfileEndTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 45, "ProfileEnd", ProviderGuid, ProviderName);
                templates[45] = new AspNetRoleManagerIsUserInRoleTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 46, "RoleManagerIsUserInRole", ProviderGuid, ProviderName);
                templates[46] = new AspNetRoleManagerGetUserRolesTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 47, "RoleManagerGetUserRoles", ProviderGuid, ProviderName);
                templates[47] = new AspNetRoleManagerBeginTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 48, "RoleManagerBegin", ProviderGuid, ProviderName);
                templates[48] = new AspNetRoleManagerEndTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 49, "RoleManagerEnd", ProviderGuid, ProviderName);
                templates[49] = new AspNetWebEventRaiseStartTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 50, "WebEventRaiseStart", ProviderGuid, ProviderName);
                templates[50] = new AspNetWebEventRaiseEndTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 51, "WebEventRaiseEnd", ProviderGuid, ProviderName);
                templates[51] = new AspNetWebEventDeliverStartTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 52, "WebEventDeliverStart", ProviderGuid, ProviderName);
                templates[52] = new AspNetWebEventDeliverEndTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 53, "WebEventDeliverEnd", ProviderGuid, ProviderName);
                templates[53] = new AspNetPageTraceWarnEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 59, "TraceContextWarning", ProviderGuid, ProviderName);
                templates[54] = new AspNetPageTraceWriteEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 60, "TraceContextWrite", ProviderGuid, ProviderName);
                templates[55] = new AspNetModuleDiagCriticalEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 61, "DiagnosticTraceCritical", ProviderGuid, ProviderName);
                templates[56] = new AspNetModuleDiagErrorEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 62, "DiagnosticTraceError", ProviderGuid, ProviderName);
                templates[57] = new AspNetModuleDiagWarningEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 63, "DiagnosticTraceWarning", ProviderGuid, ProviderName);
                templates[58] = new AspNetModuleDiagInfoEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 64, "DiagnosticTraceInfo", ProviderGuid, ProviderName);
                templates[59] = new AspNetModuleDiagVerboseEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 65, "DiagnosticTraceVerbose", ProviderGuid, ProviderName);
                templates[60] = new AspNetModuleDiagStartEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 66, "DiagnosticTraceStart", ProviderGuid, ProviderName);
                templates[61] = new AspNetModuleDiagStopEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 67, "DiagnosticTraceStop", ProviderGuid, ProviderName);
                templates[62] = new AspNetModuleDiagSuspendEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 68, "DiagnosticTraceSuspend", ProviderGuid, ProviderName);
                templates[63] = new AspNetModuleDiagResumeEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 69, "DiagnosticTraceResume", ProviderGuid, ProviderName);
                templates[64] = new AspNetModuleDiagTransferEventTraceData(null, 0xFFFF, 0, "AspNetReq", AspNetReqTaskGuid, 70, "DiagnosticTraceTransfer", ProviderGuid, ProviderName);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        private static readonly Guid AspNetReqTaskGuid = new Guid(unchecked((int)0x06a01367), unchecked((short)0x79d3), unchecked((short)0x4594), 0x8e, 0xb3, 0xc7, 0x21, 0x60, 0x3c, 0x46, 0x79);
        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.AspNet
{
    public sealed class AspNetStartTraceData : TraceEvent
    {
        // Note that V1.1 CLR version (ancient) only have a payload length of 8, and will print junk.   
        // I don't even bother protecting myself from these right now.  
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string Method { get { return GetUTF8StringAt(24); } }
        public string Path { get { return GetUTF8StringAt(SkipUTF8String(24)); } }
        public string QueryString { get { return GetUTF8StringAt(SkipUTF8String(SkipUTF8String(24))); } }

        #region Private
        internal AspNetStartTraceData(Action<AspNetStartTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetStartTraceData>)value; }
        }
        protected internal override void Validate()
        {
            // V1.1 version of the runtime have an EventDataLength of 8
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(SkipUTF8String(SkipUTF8String(24))) && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(SkipUTF8String(SkipUTF8String(24)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Method", Method);
            XmlAttrib(sb, "Path", Path);
            XmlAttrib(sb, "QueryString", QueryString);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "Method", "Path", "QueryString" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return Method;
                case 3:
                    return Path;
                case 4:
                    return QueryString;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetStartTraceData> Action;
        #endregion
    }
    public sealed class AspNetStopTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetStopTraceData(Action<AspNetStopTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetStopTraceData>)value; }
        }
        protected internal override void Validate()
        {
            // != 8 added because V1.1 runtimes had an old event. 
            Debug.Assert(!(Version == 0 && EventDataLength != 24 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetStopTraceData> Action;
        #endregion
    }
    public sealed class AspNetRequestQueuedTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetRequestQueuedTraceData(Action<AspNetRequestQueuedTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetRequestQueuedTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetRequestQueuedTraceData> Action;
        #endregion
    }
    public sealed class AspNetRequestDequeuedTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetRequestDequeuedTraceData(Action<AspNetRequestDequeuedTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetRequestDequeuedTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetRequestDequeuedTraceData> Action;
        #endregion
    }
    public sealed class AspNetGetAppDomainEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetGetAppDomainEnterTraceData(Action<AspNetGetAppDomainEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetGetAppDomainEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetGetAppDomainEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetGetAppDomainLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetGetAppDomainLeaveTraceData(Action<AspNetGetAppDomainLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetGetAppDomainLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetGetAppDomainLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetAppDomainEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string DomainId { get { return GetUnicodeStringAt(24); } }

        #region Private
        internal AspNetAppDomainEnterTraceData(Action<AspNetAppDomainEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetAppDomainEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(24)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(24)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "DomainId", DomainId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "DomainId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return DomainId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetAppDomainEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetStartHandlerTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string HandlerName { get { return GetUnicodeStringAt(24); } }
        public new string EventName { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }

        #region Private
        internal AspNetStartHandlerTraceData(Action<AspNetStartHandlerTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetStartHandlerTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(24))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(24))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "HandlerName", HandlerName);
            XmlAttrib(sb, "EventName", EventName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "HandlerName", "EventName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return HandlerName;
                case 3:
                    return EventName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetStartHandlerTraceData> Action;
        #endregion
    }
    public sealed class AspNetEndHandlerTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetEndHandlerTraceData(Action<AspNetEndHandlerTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetEndHandlerTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetEndHandlerTraceData> Action;
        #endregion
    }
    public sealed class AspNetPipelineModuleEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string ModuleName { get { return GetUnicodeStringAt(24); } }

        #region Private
        internal AspNetPipelineModuleEnterTraceData(Action<AspNetPipelineModuleEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPipelineModuleEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(24)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(24)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "ModuleName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return ModuleName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPipelineModuleEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPipelineModuleLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string ModuleName { get { return GetUnicodeStringAt(24); } }

        #region Private
        internal AspNetPipelineModuleLeaveTraceData(Action<AspNetPipelineModuleLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPipelineModuleLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(24)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(24)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ModuleName", ModuleName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "ModuleName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return ModuleName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPipelineModuleLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetMapHandlerEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetMapHandlerEnterTraceData(Action<AspNetMapHandlerEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetMapHandlerEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetMapHandlerEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetMapHandlerLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetMapHandlerLeaveTraceData(Action<AspNetMapHandlerLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetMapHandlerLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetMapHandlerLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetParseEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetParseEnterTraceData(Action<AspNetParseEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetParseEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetParseEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetParseLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetParseLeaveTraceData(Action<AspNetParseLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetParseLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetParseLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetCompileEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetCompileEnterTraceData(Action<AspNetCompileEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetCompileEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetCompileEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetCompileLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string Files { get { return GetUnicodeStringAt(24); } }
        public string Status { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }

        #region Private
        internal AspNetCompileLeaveTraceData(Action<AspNetCompileLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetCompileLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(24))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(24))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Files", Files);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "Files", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return Files;
                case 3:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetCompileLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetHttpHandlerEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetHttpHandlerEnterTraceData(Action<AspNetHttpHandlerEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetHttpHandlerEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetHttpHandlerEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetHttpHandlerLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetHttpHandlerLeaveTraceData(Action<AspNetHttpHandlerLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetHttpHandlerLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetHttpHandlerLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetSessionStatePartitionStartTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string ResolverType { get { return GetUnicodeStringAt(24); } }
        public string SessionId { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }

        #region Private
        internal AspNetSessionStatePartitionStartTraceData(Action<AspNetSessionStatePartitionStartTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetSessionStatePartitionStartTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(24))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(24))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ResolverType", ResolverType);
            XmlAttrib(sb, "SessionId", SessionId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "ResolverType", "SessionId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return ResolverType;
                case 3:
                    return SessionId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetSessionStatePartitionStartTraceData> Action;
        #endregion
    }
    public sealed class AspNetSessionStatePartitionEndTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string ResolverResult { get { return GetUnicodeStringAt(24); } }

        #region Private
        internal AspNetSessionStatePartitionEndTraceData(Action<AspNetSessionStatePartitionEndTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetSessionStatePartitionEndTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(24)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(24)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ResolverResult", ResolverResult);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "ResolverResult" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return ResolverResult;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetSessionStatePartitionEndTraceData> Action;
        #endregion
    }
    public sealed class AspNetPagePreInitEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPagePreInitEnterTraceData(Action<AspNetPagePreInitEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPagePreInitEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPagePreInitEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPagePreInitLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPagePreInitLeaveTraceData(Action<AspNetPagePreInitLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPagePreInitLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPagePreInitLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageInitEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageInitEnterTraceData(Action<AspNetPageInitEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageInitEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageInitEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageInitLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageInitLeaveTraceData(Action<AspNetPageInitLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageInitLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageInitLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageLoadViewstateEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageLoadViewstateEnterTraceData(Action<AspNetPageLoadViewstateEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageLoadViewstateEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageLoadViewstateEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageLoadViewstateLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageLoadViewstateLeaveTraceData(Action<AspNetPageLoadViewstateLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageLoadViewstateLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageLoadViewstateLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageLoadPostDataEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageLoadPostDataEnterTraceData(Action<AspNetPageLoadPostDataEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageLoadPostDataEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageLoadPostDataEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageLoadPostDataLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageLoadPostDataLeaveTraceData(Action<AspNetPageLoadPostDataLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageLoadPostDataLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageLoadPostDataLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageLoadEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageLoadEnterTraceData(Action<AspNetPageLoadEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageLoadEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageLoadEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageLoadLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageLoadLeaveTraceData(Action<AspNetPageLoadLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageLoadLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageLoadLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPagePostDataChangedEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPagePostDataChangedEnterTraceData(Action<AspNetPagePostDataChangedEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPagePostDataChangedEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPagePostDataChangedEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPagePostDataChangedLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPagePostDataChangedLeaveTraceData(Action<AspNetPagePostDataChangedLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPagePostDataChangedLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPagePostDataChangedLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageRaisePostbackEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageRaisePostbackEnterTraceData(Action<AspNetPageRaisePostbackEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageRaisePostbackEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageRaisePostbackEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageRaisePostbackLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageRaisePostbackLeaveTraceData(Action<AspNetPageRaisePostbackLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageRaisePostbackLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageRaisePostbackLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPagePreRenderEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPagePreRenderEnterTraceData(Action<AspNetPagePreRenderEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPagePreRenderEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPagePreRenderEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPagePreRenderLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPagePreRenderLeaveTraceData(Action<AspNetPagePreRenderLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPagePreRenderLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPagePreRenderLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageSaveViewstateEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageSaveViewstateEnterTraceData(Action<AspNetPageSaveViewstateEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageSaveViewstateEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageSaveViewstateEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageSaveViewstateLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageSaveViewstateLeaveTraceData(Action<AspNetPageSaveViewstateLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageSaveViewstateLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageSaveViewstateLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageRenderEnterTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageRenderEnterTraceData(Action<AspNetPageRenderEnterTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageRenderEnterTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageRenderEnterTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageRenderLeaveTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetPageRenderLeaveTraceData(Action<AspNetPageRenderLeaveTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageRenderLeaveTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageRenderLeaveTraceData> Action;
        #endregion
    }
    public sealed class AspNetAcquireSessionBeginTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetAcquireSessionBeginTraceData(Action<AspNetAcquireSessionBeginTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetAcquireSessionBeginTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetAcquireSessionBeginTraceData> Action;
        #endregion
    }
    public sealed class AspNetAcquireSessionEndTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetAcquireSessionEndTraceData(Action<AspNetAcquireSessionEndTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetAcquireSessionEndTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetAcquireSessionEndTraceData> Action;
        #endregion
    }
    public sealed class AspNetProfileBeginTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetProfileBeginTraceData(Action<AspNetProfileBeginTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetProfileBeginTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetProfileBeginTraceData> Action;
        #endregion
    }
    public sealed class AspNetProfileEndTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string User { get { return GetUnicodeStringAt(24); } }

        #region Private
        internal AspNetProfileEndTraceData(Action<AspNetProfileEndTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetProfileEndTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(24)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(24)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "User", User);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "User" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return User;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetProfileEndTraceData> Action;
        #endregion
    }
    public sealed class AspNetRoleManagerIsUserInRoleTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string Provider { get { return GetUnicodeStringAt(24); } }
        public string User { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string Role { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }
        public string Status { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))); } }

        #region Private
        internal AspNetRoleManagerIsUserInRoleTraceData(Action<AspNetRoleManagerIsUserInRoleTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetRoleManagerIsUserInRoleTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24))))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Provider", Provider);
            XmlAttrib(sb, "User", User);
            XmlAttrib(sb, "Role", Role);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "Provider", "User", "Role", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return Provider;
                case 3:
                    return User;
                case 4:
                    return Role;
                case 5:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetRoleManagerIsUserInRoleTraceData> Action;
        #endregion
    }
    public sealed class AspNetRoleManagerGetUserRolesTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string Provider { get { return GetUnicodeStringAt(24); } }
        public string User { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string Roles { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }

        #region Private
        internal AspNetRoleManagerGetUserRolesTraceData(Action<AspNetRoleManagerGetUserRolesTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetRoleManagerGetUserRolesTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Provider", Provider);
            XmlAttrib(sb, "User", User);
            XmlAttrib(sb, "Roles", Roles);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "Provider", "User", "Roles" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return Provider;
                case 3:
                    return User;
                case 4:
                    return Roles;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetRoleManagerGetUserRolesTraceData> Action;
        #endregion
    }
    public sealed class AspNetRoleManagerBeginTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetRoleManagerBeginTraceData(Action<AspNetRoleManagerBeginTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetRoleManagerBeginTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetRoleManagerBeginTraceData> Action;
        #endregion
    }
    public sealed class AspNetRoleManagerEndTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string Provider { get { return GetUnicodeStringAt(24); } }
        public string User { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }

        #region Private
        internal AspNetRoleManagerEndTraceData(Action<AspNetRoleManagerEndTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetRoleManagerEndTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(24))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(24))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Provider", Provider);
            XmlAttrib(sb, "User", User);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "Provider", "User" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return Provider;
                case 3:
                    return User;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetRoleManagerEndTraceData> Action;
        #endregion
    }
    public sealed class AspNetWebEventRaiseStartTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public string EventClassName { get { return GetUnicodeStringAt(24); } }
        public string EventCode { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string EventDetailCode { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }

        #region Private
        internal AspNetWebEventRaiseStartTraceData(Action<AspNetWebEventRaiseStartTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetWebEventRaiseStartTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "EventClassName", EventClassName);
            XmlAttrib(sb, "EventCode", EventCode);
            XmlAttrib(sb, "EventDetailCode", EventDetailCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "EventClassName", "EventCode", "EventDetailCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return EventClassName;
                case 3:
                    return EventCode;
                case 4:
                    return EventDetailCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetWebEventRaiseStartTraceData> Action;
        #endregion
    }
    public sealed class AspNetWebEventRaiseEndTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetWebEventRaiseEndTraceData(Action<AspNetWebEventRaiseEndTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetWebEventRaiseEndTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetWebEventRaiseEndTraceData> Action;
        #endregion
    }
    public sealed class AspNetWebEventDeliverStartTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }
        public new string ProviderName { get { return GetUnicodeStringAt(24); } }
        public string RuleName { get { return GetUnicodeStringAt(SkipUnicodeString(24)); } }
        public string EventGroupName { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(24))); } }

        #region Private
        internal AspNetWebEventDeliverStartTraceData(Action<AspNetWebEventDeliverStartTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetWebEventDeliverStartTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(24)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "ProviderName", ProviderName);
            XmlAttrib(sb, "RuleName", RuleName);
            XmlAttrib(sb, "EventGroupName", EventGroupName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId", "ProviderName", "RuleName", "EventGroupName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                case 2:
                    return ProviderName;
                case 3:
                    return RuleName;
                case 4:
                    return EventGroupName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetWebEventDeliverStartTraceData> Action;
        #endregion
    }
    public sealed class AspNetWebEventDeliverEndTraceData : TraceEvent
    {
        public long ConnID { get { return GetInt64At(0); } }
        public Guid ContextId { get { return GetGuidAt(8); } }

        #region Private
        internal AspNetWebEventDeliverEndTraceData(Action<AspNetWebEventDeliverEndTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetWebEventDeliverEndTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ConnID", ConnID);
            XmlAttrib(sb, "ContextId", ContextId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnID", "ContextId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnID;
                case 1:
                    return ContextId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetWebEventDeliverEndTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageTraceWarnEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWarningMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetPageTraceWarnEventTraceData(Action<AspNetPageTraceWarnEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageTraceWarnEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWarningMsg", TraceWarningMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWarningMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWarningMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageTraceWarnEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetPageTraceWriteEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetPageTraceWriteEventTraceData(Action<AspNetPageTraceWriteEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetPageTraceWriteEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetPageTraceWriteEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagCriticalEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagCriticalEventTraceData(Action<AspNetModuleDiagCriticalEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagCriticalEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagCriticalEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagErrorEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagErrorEventTraceData(Action<AspNetModuleDiagErrorEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagErrorEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagErrorEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagWarningEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagWarningEventTraceData(Action<AspNetModuleDiagWarningEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagWarningEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagWarningEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagInfoEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagInfoEventTraceData(Action<AspNetModuleDiagInfoEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagInfoEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagInfoEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagVerboseEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagVerboseEventTraceData(Action<AspNetModuleDiagVerboseEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagVerboseEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagVerboseEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagStartEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagStartEventTraceData(Action<AspNetModuleDiagStartEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagStartEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagStartEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagStopEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagStopEventTraceData(Action<AspNetModuleDiagStopEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagStopEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagStopEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagSuspendEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagSuspendEventTraceData(Action<AspNetModuleDiagSuspendEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagSuspendEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagSuspendEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagResumeEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagResumeEventTraceData(Action<AspNetModuleDiagResumeEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagResumeEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagResumeEventTraceData> Action;
        #endregion
    }
    public sealed class AspNetModuleDiagTransferEventTraceData : TraceEvent
    {
        public Guid ContextId { get { return GetGuidAt(0); } }
        public string Uri { get { return GetUnicodeStringAt(16); } }
        public string TraceWriteMsg { get { return GetUnicodeStringAt(SkipUnicodeString(16)); } }

        #region Private
        internal AspNetModuleDiagTransferEventTraceData(Action<AspNetModuleDiagTransferEventTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected internal override void Dispatch()
        {
            Action(this);
        }
        protected internal override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<AspNetModuleDiagTransferEventTraceData>)value; }
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(16))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(16))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ContextId", ContextId);
            XmlAttrib(sb, "Uri", Uri);
            XmlAttrib(sb, "TraceWriteMsg", TraceWriteMsg);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ContextId", "Uri", "TraceWriteMsg" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ContextId;
                case 1:
                    return Uri;
                case 2:
                    return TraceWriteMsg;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AspNetModuleDiagTransferEventTraceData> Action;
        #endregion
    }

}
