using System;
using System.Diagnostics;
using System.Text;
using Address = System.UInt64;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    using Microsoft.Diagnostics.Tracing.Parsers.ETWClrProfiler;

    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
    public sealed class ETWClrProfilerTraceEventParser : TraceEventParser
    {
        public static string ProviderName = "ETWClrProfiler";
        public static Guid ProviderGuid = new Guid(unchecked((int)0x6652970f), unchecked((short)0x1756), unchecked((short)0x5d8d), 0x08, 0x05, 0xe9, 0xaa, 0xd1, 0x52, 0xaa, 0x84);
        public enum Keywords : long
        {
            GC = 0x1,
            GCHeap = 0x2,
            GCAlloc = 0x4,
            GCAllocSampled = 0x8,
            Call = 0x10,
            CallSampled = 0x20,
            DisableInlining = 0x40,
            Detach = 0x800000000000,
        };

        public ETWClrProfilerTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<CallEnterArgs> CallEnter
        {
            add
            {
                source.RegisterEventTemplate(CallEnterTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 29, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> CaptureStateStart
        {
            add
            {
                source.RegisterEventTemplate(CaptureStateStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 24, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> CaptureStateStop
        {
            add
            {
                source.RegisterEventTemplate(CaptureStateStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 25, ProviderGuid);
            }
        }
        public event Action<ClassIDDefintionArgs> ClassIDDefintion
        {
            add
            {
                source.RegisterEventTemplate(ClassIDDefintionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, ProviderGuid);
            }
        }
        public event Action<FinalizeableObjectQueuedArgs> FinalizeableObjectQueued
        {
            add
            {
                source.RegisterEventTemplate(FinalizeableObjectQueuedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, ProviderGuid);
            }
        }
        public event Action<GCStartArgs> GCStart
        {
            add
            {
                source.RegisterEventTemplate(GCStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 20, ProviderGuid);
            }
        }
        public event Action<GCStopArgs> GCStop
        {
            add
            {
                source.RegisterEventTemplate(GCStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 21, ProviderGuid);
            }
        }
        public event Action<HandleCreatedArgs> HandleCreated
        {
            add
            {
                source.RegisterEventTemplate(HandleCreatedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
            }
        }
        public event Action<HandleDestroyedArgs> HandleDestroyed
        {
            add
            {
                source.RegisterEventTemplate(HandleDestroyedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, ProviderGuid);
            }
        }
        public event Action<ModuleIDDefintionArgs> ModuleIDDefintion
        {
            add
            {
                source.RegisterEventTemplate(ModuleIDDefintionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, ProviderGuid);
            }
        }
        public event Action<ObjectAllocatedArgs> ObjectAllocated
        {
            add
            {
                source.RegisterEventTemplate(ObjectAllocatedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, ProviderGuid);
            }
        }
        public event Action<ObjectReferencesArgs> ObjectReferences
        {
            add
            {
                source.RegisterEventTemplate(ObjectReferencesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 16, ProviderGuid);
            }
        }
        public event Action<ObjectsMovedArgs> ObjectsMoved
        {
            add
            {
                source.RegisterEventTemplate(ObjectsMovedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 22, ProviderGuid);
            }
        }
        public event Action<ObjectsSurvivedArgs> ObjectsSurvived
        {
            add
            {
                source.RegisterEventTemplate(ObjectsSurvivedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 23, ProviderGuid);
            }
        }
        public event Action<ProfilerErrorArgs> ProfilerError
        {
            add
            {
                source.RegisterEventTemplate(ProfilerErrorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 26, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> ProfilerShutdown
        {
            add
            {
                source.RegisterEventTemplate(ProfilerShutdownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 27, ProviderGuid);
            }
        }
        public event Action<RootReferencesArgs> RootReferences
        {
            add
            {
                source.RegisterEventTemplate(RootReferencesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 15, ProviderGuid);
            }
        }
        public event Action<SamplingRateChangeArgs> SamplingRateChange
        {
            add
            {
                source.RegisterEventTemplate(SamplingRateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 28, ProviderGuid);
            }
        }
        public event Action<SendManifestArgs> SendManifest
        {
            add
            {
                source.RegisterEventTemplate(SendManifestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 65534, ProviderGuid);
            }
        }

        #region private
        protected override string GetProviderName() { return ProviderName; }

        static private CallEnterArgs CallEnterTemplate(Action<CallEnterArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new CallEnterArgs(action, 29, 29, "CallEnter", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData CaptureStateStartTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 24, 24, "CaptureState", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData CaptureStateStopTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 25, 24, "CaptureState", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private ClassIDDefintionArgs ClassIDDefintionTemplate(Action<ClassIDDefintionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ClassIDDefintionArgs(action, 1, 10, "ClassIDDefintion", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private FinalizeableObjectQueuedArgs FinalizeableObjectQueuedTemplate(Action<FinalizeableObjectQueuedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new FinalizeableObjectQueuedArgs(action, 11, 13, "FinalizeableObjectQueued", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private GCStartArgs GCStartTemplate(Action<GCStartArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new GCStartArgs(action, 20, 1, "GC", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private GCStopArgs GCStopTemplate(Action<GCStopArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new GCStopArgs(action, 21, 1, "GC", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private HandleCreatedArgs HandleCreatedTemplate(Action<HandleCreatedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new HandleCreatedArgs(action, 12, 14, "HandleCreated", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private HandleDestroyedArgs HandleDestroyedTemplate(Action<HandleDestroyedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new HandleDestroyedArgs(action, 13, 15, "HandleDestroyed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ModuleIDDefintionArgs ModuleIDDefintionTemplate(Action<ModuleIDDefintionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ModuleIDDefintionArgs(action, 2, 11, "ModuleIDDefintion", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ObjectAllocatedArgs ObjectAllocatedTemplate(Action<ObjectAllocatedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ObjectAllocatedArgs(action, 10, 12, "ObjectAllocated", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ObjectReferencesArgs ObjectReferencesTemplate(Action<ObjectReferencesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ObjectReferencesArgs(action, 16, 23, "ObjectReferences", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ObjectsMovedArgs ObjectsMovedTemplate(Action<ObjectsMovedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ObjectsMovedArgs(action, 22, 20, "ObjectsMoved", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ObjectsSurvivedArgs ObjectsSurvivedTemplate(Action<ObjectsSurvivedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ObjectsSurvivedArgs(action, 23, 21, "ObjectsSurvived", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private ProfilerErrorArgs ProfilerErrorTemplate(Action<ProfilerErrorArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ProfilerErrorArgs(action, 26, 26, "ProfilerError", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData ProfilerShutdownTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 27, 27, "ProfilerShutdown", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RootReferencesArgs RootReferencesTemplate(Action<RootReferencesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RootReferencesArgs(action, 15, 22, "RootReferences", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private SamplingRateChangeArgs SamplingRateChangeTemplate(Action<SamplingRateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new SamplingRateChangeArgs(action, 28, 28, "SamplingRateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private SendManifestArgs SendManifestTemplate(Action<SendManifestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new SendManifestArgs(action, 65534, 65534, "SendManifest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }

        static private volatile TraceEvent[] s_templates;
        protected override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[19];
                templates[0] = ClassIDDefintionTemplate(null);
                templates[1] = ModuleIDDefintionTemplate(null);
                templates[2] = ObjectAllocatedTemplate(null);
                templates[3] = FinalizeableObjectQueuedTemplate(null);
                templates[4] = HandleCreatedTemplate(null);
                templates[5] = HandleDestroyedTemplate(null);
                templates[6] = RootReferencesTemplate(null);
                templates[7] = ObjectReferencesTemplate(null);
                templates[8] = GCStartTemplate(null);
                templates[9] = GCStopTemplate(null);
                templates[10] = ObjectsMovedTemplate(null);
                templates[11] = ObjectsSurvivedTemplate(null);
                templates[12] = CaptureStateStartTemplate(null);
                templates[13] = CaptureStateStopTemplate(null);
                templates[14] = ProfilerErrorTemplate(null);
                templates[15] = ProfilerShutdownTemplate(null);
                templates[16] = SamplingRateChangeTemplate(null);
                templates[17] = CallEnterTemplate(null);
                templates[18] = SendManifestTemplate(null);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.ETWClrProfiler
{
    public sealed class CallEnterArgs : TraceEvent
    {
        public Address FunctionID { get { return (Address)GetInt64At(0); } }
        public int SamplingRate { get { if (EventDataLength >= 12) { return GetInt32At(8); } return 1; } }
        #region Private
        internal CallEnterArgs(Action<CallEnterArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<CallEnterArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "FunctionID", FunctionID);
            XmlAttrib(sb, "SamplingRate", SamplingRate);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "FunctionID", "SamplingRate" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return FunctionID;
                case 1:
                    return SamplingRate;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<CallEnterArgs> m_target;
        #endregion
    }
    public sealed class ClassIDDefintionArgs : TraceEvent
    {
        public Address ClassID { get { return (Address)GetInt64At(0); } }
        public int Token { get { return GetInt32At(8); } }
        public ClassDefinitionFlags Flags { get { return (ClassDefinitionFlags)GetInt32At(12); } }
        public Address ModuleID { get { return (Address)GetInt64At(16); } }
        public string Name { get { return GetUnicodeStringAt(24); } }

        #region Private
        internal ClassIDDefintionArgs(Action<ClassIDDefintionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(24)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(24)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ClassIDDefintionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClassID", ClassID);
            XmlAttrib(sb, "Token", Token);
            XmlAttrib(sb, "Flags", Flags);
            XmlAttrib(sb, "ModuleID", ModuleID);
            XmlAttrib(sb, "Name", Name);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClassID", "Token", "Flags", "ModuleID", "Name" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClassID;
                case 1:
                    return Token;
                case 2:
                    return Flags;
                case 3:
                    return ModuleID;
                case 4:
                    return Name;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ClassIDDefintionArgs> m_target;
        #endregion
    }
    public sealed class FinalizeableObjectQueuedArgs : TraceEvent
    {
        public long ObjectID { get { return GetInt64At(0); } }
        public long ClassID { get { return GetInt64At(8); } }

        #region Private
        internal FinalizeableObjectQueuedArgs(Action<FinalizeableObjectQueuedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<FinalizeableObjectQueuedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ObjectID", ObjectID);
            XmlAttrib(sb, "ClassID", ClassID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ObjectID", "ClassID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ObjectID;
                case 1:
                    return ClassID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FinalizeableObjectQueuedArgs> m_target;
        #endregion
    }
    public sealed class GCStartArgs : TraceEvent
    {
        public int GCID { get { return GetInt32At(0); } }
        public int Generation { get { return GetInt32At(4); } }
        public bool Induced { get { return GetInt32At(8) != 0; } }

        #region Private
        internal GCStartArgs(Action<GCStartArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<GCStartArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "GCID", GCID);
            XmlAttrib(sb, "Generation", Generation);
            XmlAttrib(sb, "Induced", Induced);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "GCID", "Generation", "Induced" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return GCID;
                case 1:
                    return Generation;
                case 2:
                    return Induced;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCStartArgs> m_target;
        #endregion
    }
    public sealed class GCStopArgs : TraceEvent
    {
        public int GCID { get { return GetInt32At(0); } }

        #region Private
        internal GCStopArgs(Action<GCStopArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4));
            Debug.Assert(!(Version > 0 && EventDataLength < 4));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<GCStopArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "GCID", GCID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "GCID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return GCID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<GCStopArgs> m_target;
        #endregion
    }
    public sealed class HandleCreatedArgs : TraceEvent
    {
        public long HandleID { get { return GetInt64At(0); } }
        public long InitialObjectID { get { return GetInt64At(8); } }

        #region Private
        internal HandleCreatedArgs(Action<HandleCreatedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<HandleCreatedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "HandleID", HandleID);
            XmlAttrib(sb, "InitialObjectID", InitialObjectID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HandleID", "InitialObjectID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HandleID;
                case 1:
                    return InitialObjectID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<HandleCreatedArgs> m_target;
        #endregion
    }
    public sealed class HandleDestroyedArgs : TraceEvent
    {
        public long HandleID { get { return GetInt64At(0); } }

        #region Private
        internal HandleDestroyedArgs(Action<HandleDestroyedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<HandleDestroyedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "HandleID", HandleID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HandleID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HandleID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<HandleDestroyedArgs> m_target;
        #endregion
    }
    public sealed class ModuleIDDefintionArgs : TraceEvent
    {
        public Address ModuleID { get { return (Address)GetInt64At(0); } }
        public Address AssemblyID { get { return (Address)GetInt64At(8); } }
        public string Path { get { return GetUnicodeStringAt(16); } }

        #region Private
        internal ModuleIDDefintionArgs(Action<ModuleIDDefintionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(16)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(16)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ModuleIDDefintionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ModuleID", ModuleID);
            XmlAttrib(sb, "AssemblyID", AssemblyID);
            XmlAttrib(sb, "Path", Path);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ModuleID", "AssemblyID", "Path" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ModuleID;
                case 1:
                    return AssemblyID;
                case 2:
                    return Path;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ModuleIDDefintionArgs> m_target;
        #endregion
    }
    public sealed class ObjectAllocatedArgs : TraceEvent
    {
        public Address ObjectID { get { return (Address)GetInt64At(0); } }
        public Address ClassID { get { return (Address)GetInt64At(8); } }
        public long Size { get { return GetInt64At(16); } }
        public long RepresentativeSize { get { return GetInt64At(24); } }

        #region Private
        internal ObjectAllocatedArgs(Action<ObjectAllocatedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 32));
            Debug.Assert(!(Version > 0 && EventDataLength < 32));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ObjectAllocatedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ObjectID", ObjectID);
            XmlAttrib(sb, "ClassID", ClassID);
            XmlAttrib(sb, "Size", Size);
            XmlAttrib(sb, "RepresentativeSize", RepresentativeSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ObjectID", "ClassID", "Size", "RepresentativeSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ObjectID;
                case 1:
                    return ClassID;
                case 2:
                    return Size;
                case 3:
                    return RepresentativeSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ObjectAllocatedArgs> m_target;
        #endregion
    }
    public sealed class ObjectReferencesArgs : TraceEvent
    {
        public long ObjectID { get { return GetInt64At(0); } }
        public long ClassID { get { return GetInt64At(8); } }
        public long Size { get { return GetInt64At(16); } }
        public int ObjectRefCount { get { return GetInt32At(24); } }
        public Address ObjectRefs(int arrayIndex) { return GetAddressAt(28 + (arrayIndex * PointerSize)); }

        #region Private
        internal ObjectReferencesArgs(Action<ObjectReferencesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (ObjectRefCount * 4) + 28, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (ObjectRefCount * 4) + 28, 1)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ObjectReferencesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ObjectID", ObjectID);
            XmlAttrib(sb, "ClassID", ClassID);
            XmlAttrib(sb, "Size", Size);
            XmlAttrib(sb, "ObjectRefCount", ObjectRefCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ObjectID", "ClassID", "Size", "ObjectRefCount", "ObjectRefs" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ObjectID;
                case 1:
                    return ClassID;
                case 2:
                    return Size;
                case 3:
                    return ObjectRefCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ObjectReferencesArgs> m_target;
        #endregion
    }
    public sealed class ObjectsMovedArgs : TraceEvent
    {
        public int Count { get { return GetInt32At(0); } }
        public Address RangeBases(int arrayIndex) { return GetAddressAt(4 + (PointerSize * arrayIndex)); }
        public Address TargetBases(int arrayIndex) { return GetAddressAt(4 + (PointerSize * Count) + (PointerSize * arrayIndex)); }
        public int Lengths(int arrayIndex) { return GetInt32At(4 + 2 * (PointerSize * Count) + (4 * arrayIndex)); }

        #region Private
        internal ObjectsMovedArgs(Action<ObjectsMovedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4 + 2 * (PointerSize * Count) + (4 * Count)));
            Debug.Assert(!(Version > 0 && EventDataLength < 4 + 2 * (PointerSize * Count) + (4 * Count)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ObjectsMovedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Count", "RangeBases", "TargetBases", "Lengths" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ObjectsMovedArgs> m_target;
        #endregion
    }
    public sealed class ObjectsSurvivedArgs : TraceEvent
    {
        public int Count { get { return GetInt32At(0); } }

        public Address RangeBases(int arrayIndex)
        {
            // The ranges are a block of pointer sized elements. that is after the 4 byte length field 
            return GetAddressAt(4 + (PointerSize * arrayIndex));
        }
        public int Lengths(int arrayIndex)
        {
            // The lengths are a blob of 32 bit integers that are after the RangeBases  
            return GetInt32At(4 + (PointerSize * Count) + (4 * arrayIndex));
        }

        #region Private
        internal ObjectsSurvivedArgs(Action<ObjectsSurvivedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4 + (PointerSize * Count) + (4 * Count)));
            Debug.Assert(!(Version > 0 && EventDataLength < 4 + (PointerSize * Count) + (4 * Count)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ObjectsSurvivedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Count", "RangeBases", "Lengths" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ObjectsSurvivedArgs> m_target;
        #endregion
    }
    public sealed class ProfilerErrorArgs : TraceEvent
    {
        public long ErrorCode { get { return GetInt64At(0); } }
        public string Message { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal ProfilerErrorArgs(Action<ProfilerErrorArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ProfilerErrorArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ErrorCode", ErrorCode);
            XmlAttrib(sb, "Message", Message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ErrorCode", "Message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ErrorCode;
                case 1:
                    return Message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProfilerErrorArgs> m_target;
        #endregion
    }
    public sealed class RootReferencesArgs : TraceEvent
    {
        public int Count { get { return GetInt32At(0); } }
        public Address ObjectIDs(int arrayIndex) { return GetAddressAt(4 + (PointerSize * arrayIndex)); }
        public GCRootKind GCRootKinds(int arrayIndex)
        {
            int ret = GetInt32At(4 + PointerSize * Count + (4 * arrayIndex));
            Debug.Assert((ret & 0xFFFFFF00) == 0);  // assert is is less than 256, we only use 4 bits so far.  
            return (GCRootKind)ret;
        }
        public GCRootFlags GCRootFlags(int arrayIndex)
        {
            int ret = GetInt32At(4 + PointerSize * Count + 4 * Count + 4 * arrayIndex);
            Debug.Assert((ret & 0xFFFFFFF0) == 0);  // assert is is less than 16, we only use 4 values so far. 

            return (GCRootFlags)ret;
        }
        public Address RootIDs(int arrayIndex) { return GetAddressAt(4 + PointerSize * Count + (2 * 4 * Count) + PointerSize * arrayIndex); }

        #region Private
        internal RootReferencesArgs(Action<RootReferencesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4 + (2 * PointerSize * Count) + (2 * 4 * Count)));
            Debug.Assert(!(Version > 0 && EventDataLength < 4 + (2 * PointerSize * Count) + (2 * 4 * Count)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RootReferencesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Count", Count);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Count", "ObjectIDs", "GCRootKinds", "GCRootFlags", "RootIDs" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Count;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RootReferencesArgs> m_target;
        #endregion
    }
    public sealed class SamplingRateChangeArgs : TraceEvent
    {
        public long ClassID { get { return GetInt64At(0); } }
        public string ClassName { get { return GetUnicodeStringAt(8); } }
        public int MSecDelta { get { return GetInt32At(SkipUnicodeString(8)); } }
        public int MinAllocPerMSec { get { return GetInt32At(SkipUnicodeString(8) + 4); } }
        public float NewAllocPerMSec { get { return GetSingleAt(SkipUnicodeString(8) + 8); } }
        public float AllocPerMSec { get { return GetSingleAt(SkipUnicodeString(8) + 12); } }
        public int SampleRate { get { return GetInt32At(SkipUnicodeString(8) + 16); } }

        #region Private
        internal SamplingRateChangeArgs(Action<SamplingRateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8) + 20));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8) + 20));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<SamplingRateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ClassID", ClassID);
            XmlAttrib(sb, "ClassName", ClassName);
            XmlAttrib(sb, "MSecDelta", MSecDelta);
            XmlAttrib(sb, "MinAllocPerMSec", MinAllocPerMSec);
            XmlAttrib(sb, "NewAllocPerMSec", NewAllocPerMSec);
            XmlAttrib(sb, "AllocPerMSec", AllocPerMSec);
            XmlAttrib(sb, "SampleRate", SampleRate);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ClassID", "ClassName", "MSecDelta", "MinAllocPerMSec", "NewAllocPerMSec", "AllocPerMSec", "SampleRate" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ClassID;
                case 1:
                    return ClassName;
                case 2:
                    return MSecDelta;
                case 3:
                    return MinAllocPerMSec;
                case 4:
                    return NewAllocPerMSec;
                case 5:
                    return AllocPerMSec;
                case 6:
                    return SampleRate;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SamplingRateChangeArgs> m_target;
        #endregion
    }
    public sealed class SendManifestArgs : TraceEvent
    {
        public int Format { get { return GetByteAt(0); } }
        public int MajorVersion { get { return GetByteAt(1); } }
        public int MinorVersion { get { return GetByteAt(2); } }
        public int Magic { get { return GetByteAt(3); } }
        public int TotalChunks { get { return GetInt16At(4); } }
        public int ChunkNumger { get { return GetInt16At(6); } }
        public string Data { get { return GetUTF8StringAt(8); } }

        #region Private
        internal SendManifestArgs(Action<SendManifestArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(8)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<SendManifestArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Format", Format);
            XmlAttrib(sb, "MajorVersion", MajorVersion);
            XmlAttrib(sb, "MinorVersion", MinorVersion);
            XmlAttrib(sb, "Magic", Magic);
            XmlAttrib(sb, "TotalChunks", TotalChunks);
            XmlAttrib(sb, "ChunkNumger", ChunkNumger);
            XmlAttrib(sb, "Data", Data);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Format", "MajorVersion", "MinorVersion", "Magic", "TotalChunks", "ChunkNumger", "Data" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Format;
                case 1:
                    return MajorVersion;
                case 2:
                    return MinorVersion;
                case 3:
                    return Magic;
                case 4:
                    return TotalChunks;
                case 5:
                    return ChunkNumger;
                case 6:
                    return Data;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SendManifestArgs> m_target;
        #endregion
    }
    [Flags]
    public enum ClassDefinitionFlags
    {
        ValueType = 0x1,
        Public = 0x2,
        Finalizable = 0x4,
    }
    [Flags]
    public enum GCRootFlags
    {
        Pinning = 0x1,
        WeakRef = 0x2,
        Interior = 0x4,
        RefCounted = 0x8,
    }
    public enum GCRootKind
    {
        Stack = 0x0,
        Finalizer = 0x1,
        Handle = 0x2,
        Other = 0x3,
    }
}
