﻿using System;
using System.Diagnostics;
using System.Text;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    using Microsoft.Diagnostics.Tracing.Parsers.PerfView;

    public sealed class PerfViewTraceEventParser : TraceEventParser
    {
        public static string ProviderName = "PerfView";
        public static Guid ProviderGuid = new Guid(unchecked((int)0xa8a71ac1), unchecked((short)0x040f), unchecked((short)0x54a2), 0x07, 0xca, 0x00, 0xa8, 0x9b, 0x5a, 0xb7, 0x61);
        public PerfViewTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<MarkTraceData> Mark
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new MarkTraceData(value, 1, 65533, "Mark", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> TracingStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 2, 1, "Tracing", new Guid(), 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> TracingStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 3, 1, "Tracing", new Guid(), 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> RundownStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 4, 2, "Rundown", new Guid(), 1, "Start", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> RundownStop
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 5, 2, "Rundown", new Guid(), 2, "Stop", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> WaitForIdle
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 6, 65528, "WaitForIdle", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 6, ProviderGuid);
            }
        }
        public event Action<CommandLineParametersTraceData> CommandLineParameters
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new CommandLineParametersTraceData(value, 10, 65524, "CommandLineParameters", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, ProviderGuid);
            }
        }
        public event Action<SessionParametersTraceData> SessionParameters
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new SessionParametersTraceData(value, 11, 65523, "SessionParameters", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, ProviderGuid);
            }
        }
        public event Action<KernelEnableParametersTraceData> KernelEnableParameters
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new KernelEnableParametersTraceData(value, 12, 65522, "KernelEnableParameters", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
            }
        }
        public event Action<ClrEnableParametersTraceData> ClrEnableParameters
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ClrEnableParametersTraceData(value, 13, 65521, "ClrEnableParameters", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, ProviderGuid);
            }
        }
        public event Action<ProviderEnableParametersTraceData> ProviderEnableParameters
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new ProviderEnableParametersTraceData(value, 14, 65520, "ProviderEnableParameters", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 14, ProviderGuid);
            }
        }
        public event Action<StartAndStopTimesTraceData> StartAndStopTimes
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new StartAndStopTimesTraceData(value, 15, 65519, "StartAndStopTimes", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 15, ProviderGuid);
            }
        }
        public event Action<DebugMessageTraceData> DebugMessage
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new DebugMessageTraceData(value, 16, 65518, "DebugMessage", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 16, ProviderGuid);
            }
        }
        public event Action<CpuCountersConfiguredTraceData> CpuCountersConfigured
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new CpuCountersConfiguredTraceData(value, 17, 65517, "CpuCountersConfigured", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 17, ProviderGuid);
            }
        }
        public event Action<TickTraceData> Tick
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TickTraceData(value, 18, 65516, "Tick", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 18, ProviderGuid);
            }
        }
        public event Action<StopReasonTraceData> StopReason
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new StopReasonTraceData(value, 19, 65515, "StopReason", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 19, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> StopTriggerSessionStart
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new EmptyTraceData(value, 20, 65514, "StopTriggerSessionStart", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 20, ProviderGuid);
            }
        }
        public event Action<StopTriggerDebugMessageTraceData> StopTriggerDebugMessage
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new StopTriggerDebugMessageTraceData(value, 21, 65513, "StopTriggerDebugMessage", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 21, ProviderGuid);
            }
        }
        public event Action<PerfViewLogTraceData> PerfViewLog
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new PerfViewLogTraceData(value, 22, 65512, "PerfViewLog", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 22, ProviderGuid);
            }
        }
        public event Action<TriggerHeapSnapshotTraceData> TriggerHeapSnapshot
        {
            add
            {
                // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
                source.RegisterEventTemplate(new TriggerHeapSnapshotTraceData(value, 23, 65511, "TriggerHeapSnapshot", new Guid(), 0, "", ProviderGuid, ProviderName));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 23, ProviderGuid);
            }
        }

        #region Event ID Definitions
        public const TraceEventID MarkEventID = (TraceEventID)1;
        public const TraceEventID TracingStartEventID = (TraceEventID)2;
        public const TraceEventID TracingStopEventID = (TraceEventID)3;
        public const TraceEventID RundownStartEventID = (TraceEventID)4;
        public const TraceEventID RundownStopEventID = (TraceEventID)5;
        public const TraceEventID WaitForIdleEventID = (TraceEventID)6;
        public const TraceEventID CommandLineParametersEventID = (TraceEventID)10;
        public const TraceEventID SessionParametersEventID = (TraceEventID)11;
        public const TraceEventID KernelEnableParametersEventID = (TraceEventID)12;
        public const TraceEventID ClrEnableParametersEventID = (TraceEventID)13;
        public const TraceEventID ProviderEnableParametersEventID = (TraceEventID)14;
        public const TraceEventID StartAndStopTimesEventID = (TraceEventID)15;
        public const TraceEventID DebugMessageEventID = (TraceEventID)16;
        public const TraceEventID CpuCountersConfiguredEventID = (TraceEventID)17;
        public const TraceEventID TickEventID = (TraceEventID)18;
        public const TraceEventID StopReasonEventID = (TraceEventID)19;
        public const TraceEventID StopTriggerSessionStartEventID = (TraceEventID)20;
        public const TraceEventID StopTriggerDebugMessageEventID = (TraceEventID)21;
        public const TraceEventID PerfViewLogEventID = (TraceEventID)22;
        public const TraceEventID TriggerHeapSnapshotEventID = (TraceEventID)23;
        #endregion

        #region private
        protected override string GetProviderName() { return ProviderName; }
        private static volatile TraceEvent[] s_templates;
        protected override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[20];
                templates[0] = new MarkTraceData(null, 1, 65533, "Mark", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[1] = new EmptyTraceData(null, 2, 1, "Tracing", new Guid(), 1, "Start", ProviderGuid, ProviderName);
                templates[2] = new EmptyTraceData(null, 3, 1, "Tracing", new Guid(), 2, "Stop", ProviderGuid, ProviderName);
                templates[3] = new EmptyTraceData(null, 4, 2, "Rundown", new Guid(), 1, "Start", ProviderGuid, ProviderName);
                templates[4] = new EmptyTraceData(null, 5, 2, "Rundown", new Guid(), 2, "Stop", ProviderGuid, ProviderName);
                templates[5] = new EmptyTraceData(null, 6, 65528, "WaitForIdle", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[6] = new CommandLineParametersTraceData(null, 10, 65524, "CommandLineParameters", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[7] = new SessionParametersTraceData(null, 11, 65523, "SessionParameters", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[8] = new KernelEnableParametersTraceData(null, 12, 65522, "KernelEnableParameters", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[9] = new ClrEnableParametersTraceData(null, 13, 65521, "ClrEnableParameters", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[10] = new ProviderEnableParametersTraceData(null, 14, 65520, "ProviderEnableParameters", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[11] = new StartAndStopTimesTraceData(null, 15, 65519, "StartAndStopTimes", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[12] = new DebugMessageTraceData(null, 16, 65518, "DebugMessage", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[13] = new CpuCountersConfiguredTraceData(null, 17, 65517, "CpuCountersConfigured", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[14] = new TickTraceData(null, 18, 65516, "Tick", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[15] = new StopReasonTraceData(null, 19, 65515, "StopReason", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[16] = new EmptyTraceData(null, 20, 65514, "StopTriggerSessionStart", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[17] = new StopTriggerDebugMessageTraceData(null, 21, 65513, "StopTriggerDebugMessage", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[18] = new PerfViewLogTraceData(null, 22, 65512, "PerfViewLog", new Guid(), 0, "", ProviderGuid, ProviderName);
                templates[19] = new TriggerHeapSnapshotTraceData(null, 23, 65511, "TriggerHeapSnapshot", new Guid(), 0, "", ProviderGuid, ProviderName);
                s_templates = templates;
            }
            foreach (var template in s_templates)
            {
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                {
                    callback(template);
                }
            }
        }
        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.PerfView
{
    public sealed class MarkTraceData : TraceEvent
    {
        public string message { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal MarkTraceData(Action<MarkTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<MarkTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "message", message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<MarkTraceData> Action;
        #endregion
    }
    public sealed class CommandLineParametersTraceData : TraceEvent
    {
        public string commandLine { get { return GetUnicodeStringAt(0); } }
        public string currentDirectory { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string version { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal CommandLineParametersTraceData(Action<CommandLineParametersTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<CommandLineParametersTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "commandLine", commandLine);
            XmlAttrib(sb, "currentDirectory", currentDirectory);
            XmlAttrib(sb, "version", version);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "commandLine", "currentDirectory", "version" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return commandLine;
                case 1:
                    return currentDirectory;
                case 2:
                    return version;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<CommandLineParametersTraceData> Action;
        #endregion
    }
    public sealed class SessionParametersTraceData : TraceEvent
    {
        public string sessionName { get { return GetUnicodeStringAt(0); } }
        public string sessionFileName { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public int bufferSizeMB { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0))); } }
        public int circularBuffSizeMB { get { return GetInt32At(SkipUnicodeString(SkipUnicodeString(0)) + 4); } }

        #region Private
        internal SessionParametersTraceData(Action<SessionParametersTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<SessionParametersTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0)) + 8));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0)) + 8));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "sessionName", sessionName);
            XmlAttrib(sb, "sessionFileName", sessionFileName);
            XmlAttrib(sb, "bufferSizeMB", bufferSizeMB);
            XmlAttrib(sb, "circularBuffSizeMB", circularBuffSizeMB);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "sessionName", "sessionFileName", "bufferSizeMB", "circularBuffSizeMB" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return sessionName;
                case 1:
                    return sessionFileName;
                case 2:
                    return bufferSizeMB;
                case 3:
                    return circularBuffSizeMB;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<SessionParametersTraceData> Action;
        #endregion
    }
    public sealed class KernelEnableParametersTraceData : TraceEvent
    {
        public Diagnostics_Tracing_Parsers_KernelTraceEventParser_Keywords keywords { get { return (Diagnostics_Tracing_Parsers_KernelTraceEventParser_Keywords)GetInt32At(0); } }
        public Diagnostics_Tracing_Parsers_KernelTraceEventParser_Keywords stacks { get { return (Diagnostics_Tracing_Parsers_KernelTraceEventParser_Keywords)GetInt32At(4); } }

        #region Private
        internal KernelEnableParametersTraceData(Action<KernelEnableParametersTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<KernelEnableParametersTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "keywords", keywords);
            XmlAttrib(sb, "stacks", stacks);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "keywords", "stacks" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return keywords;
                case 1:
                    return stacks;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<KernelEnableParametersTraceData> Action;
        #endregion
    }
    public sealed class ClrEnableParametersTraceData : TraceEvent
    {
        public long keywords { get { return GetInt64At(0); } }
        public Diagnostics_Tracing_TraceEventLevel level { get { return (Diagnostics_Tracing_TraceEventLevel)GetInt32At(8); } }

        #region Private
        internal ClrEnableParametersTraceData(Action<ClrEnableParametersTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ClrEnableParametersTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "keywords", keywords);
            XmlAttrib(sb, "level", level);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "keywords", "level" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return keywords;
                case 1:
                    return level;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ClrEnableParametersTraceData> Action;
        #endregion
    }
    public sealed class ProviderEnableParametersTraceData : TraceEvent
    {
        public string providerName { get { return GetUnicodeStringAt(0); } }
        public Guid providerGuid { get { return GetGuidAt(SkipUnicodeString(0)); } }
        public Diagnostics_Tracing_TraceEventLevel level { get { return (Diagnostics_Tracing_TraceEventLevel)GetInt32At(SkipUnicodeString(0) + 16); } }
        public long keywords { get { return GetInt64At(SkipUnicodeString(0) + 20); } }
        public Diagnostics_Tracing_TraceEventOptions options { get { return (Diagnostics_Tracing_TraceEventOptions)GetInt32At(SkipUnicodeString(0) + 28); } }
        public string values { get { return GetUnicodeStringAt(SkipUnicodeString(0) + 32); } }

        #region Private
        internal ProviderEnableParametersTraceData(Action<ProviderEnableParametersTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<ProviderEnableParametersTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0) + 32)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0) + 32)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "providerName", providerName);
            XmlAttrib(sb, "providerGuid", providerGuid);
            XmlAttrib(sb, "level", level);
            XmlAttrib(sb, "keywords", keywords);
            XmlAttrib(sb, "options", options);
            XmlAttrib(sb, "values", values);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "providerName", "providerGuid", "level", "keywords", "options", "values" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return providerName;
                case 1:
                    return providerGuid;
                case 2:
                    return level;
                case 3:
                    return keywords;
                case 4:
                    return options;
                case 5:
                    return values;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ProviderEnableParametersTraceData> Action;
        #endregion
    }
    public sealed class StartAndStopTimesTraceData : TraceEvent
    {
        public int startTimeRelMSec { get { return GetInt32At(0); } }
        public int stopTimeRelMSec { get { return GetInt32At(4); } }

        #region Private
        internal StartAndStopTimesTraceData(Action<StartAndStopTimesTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<StartAndStopTimesTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "startTimeRelMSec", startTimeRelMSec);
            XmlAttrib(sb, "stopTimeRelMSec", stopTimeRelMSec);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "startTimeRelMSec", "stopTimeRelMSec" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return startTimeRelMSec;
                case 1:
                    return stopTimeRelMSec;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<StartAndStopTimesTraceData> Action;
        #endregion
    }
    public sealed class DebugMessageTraceData : TraceEvent
    {
        public string message { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal DebugMessageTraceData(Action<DebugMessageTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<DebugMessageTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "message", message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<DebugMessageTraceData> Action;
        #endregion
    }
    public sealed class CpuCountersConfiguredTraceData : TraceEvent
    {
        public string profileSourceName { get { return GetUnicodeStringAt(0); } }
        public int profileSourceCount { get { return GetInt32At(SkipUnicodeString(0)); } }

        #region Private
        internal CpuCountersConfiguredTraceData(Action<CpuCountersConfiguredTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<CpuCountersConfiguredTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 4));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 4));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "profileSourceName", profileSourceName);
            XmlAttrib(sb, "profileSourceCount", profileSourceCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "profileSourceName", "profileSourceCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return profileSourceName;
                case 1:
                    return profileSourceCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<CpuCountersConfiguredTraceData> Action;
        #endregion
    }
    public sealed class TickTraceData : TraceEvent
    {
        public string message { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal TickTraceData(Action<TickTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TickTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "message", message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TickTraceData> Action;
        #endregion
    }
    public sealed class StopReasonTraceData : TraceEvent
    {
        public string message { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal StopReasonTraceData(Action<StopReasonTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<StopReasonTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "message", message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<StopReasonTraceData> Action;
        #endregion
    }
    public sealed class StopTriggerDebugMessageTraceData : TraceEvent
    {
        public double sessionRelMSec { get { return GetDoubleAt(0); } }
        public string message { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal StopTriggerDebugMessageTraceData(Action<StopTriggerDebugMessageTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<StopTriggerDebugMessageTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "sessionRelMSec", sessionRelMSec);
            XmlAttrib(sb, "message", message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "sessionRelMSec", "message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return sessionRelMSec;
                case 1:
                    return message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<StopTriggerDebugMessageTraceData> Action;
        #endregion
    }
    public sealed class PerfViewLogTraceData : TraceEvent
    {
        public string message { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal PerfViewLogTraceData(Action<PerfViewLogTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<PerfViewLogTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "message", message);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "message" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return message;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<PerfViewLogTraceData> Action;
        #endregion
    }
    public sealed class TriggerHeapSnapshotTraceData : TraceEvent
    {
        public string outputFile { get { return GetUnicodeStringAt(0); } }
        public string inputArg { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
        public string qualifiers { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

        #region Private
        internal TriggerHeapSnapshotTraceData(Action<TriggerHeapSnapshotTraceData> action, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            Action = action;
        }
        protected override Delegate Target
        {
            get { return Action; }
            set { Action = (Action<TriggerHeapSnapshotTraceData>)value; }
        }
        protected override void Dispatch()
        {
            Action(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "outputFile", outputFile);
            XmlAttrib(sb, "inputArg", inputArg);
            XmlAttrib(sb, "qualifiers", qualifiers);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "outputFile", "inputArg", "qualifiers" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return outputFile;
                case 1:
                    return inputArg;
                case 2:
                    return qualifiers;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TriggerHeapSnapshotTraceData> Action;
        #endregion
    }
    [Flags]
    public enum Diagnostics_Tracing_Parsers_KernelTraceEventParser_Keywords
    {
        None = 0x0,
        DiskFileIO = 0x200,
        DiskIO = 0x100,
        ImageLoad = 0x4,
        MemoryHardFaults = 0x2000,
        NetworkTCPIP = 0x10000,
        Process = 0x1,
        ProcessCounters = 0x8,
        Profile = 0x1000000,
        Thread = 0x2,
        ContextSwitch = 0x10,
        DiskIOInit = 0x400,
        Dispatcher = 0x800,
        FileIO = 0x2000000,
        FileIOInit = 0x4000000,
        MemoryPageFaults = 0x1000,
        Registry = 0x20000,
        SystemCall = 0x80,
        VirtualAlloc = 0x4000,
        AdvancedLocalProcedureCalls = 0x100000,
        DeferedProcedureCalls = 0x20,
        Driver = 0x800000,
        Interrupt = 0x40,
        SplitIO = 0x200000,
    }
    [Flags]
    public enum Diagnostics_Tracing_TraceEventOptions
    {
        None = 0x0,
        Stacks = 0x1,
    }
    public enum Diagnostics_Tracing_TraceEventLevel
    {
        Always = 0x0,
        Critical = 0x1,
        Error = 0x2,
        Warning = 0x3,
        Informational = 0x4,
        Verbose = 0x5,
    }
}

