﻿using System;
using System.Diagnostics;
using System.Text;
using Address = System.UInt64;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes. 
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    using Microsoft.Diagnostics.Tracing.Parsers.InteropEventProvider;

    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
    public sealed class InteropTraceEventParser : TraceEventParser
    {
        public static string ProviderName = "InteropEventProvider";
        public static Guid ProviderGuid = new Guid(unchecked((int)0xc4ac552a), unchecked((short)0xe1eb), unchecked((short)0x4fa2), 0xa6, 0x51, 0xb2, 0x00, 0xef, 0xd7, 0xaa, 0x91);
        public enum Keywords : long
        {
            Interop = 0x1,
        };

        public InteropTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<TaskCCWCreationArgs> TaskCCWCreation
        {
            add
            {
                source.RegisterEventTemplate(TaskCCWCreationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 20, ProviderGuid);
            }
        }
        public event Action<TaskCCWFinalizationArgs> TaskCCWFinalization
        {
            add
            {
                source.RegisterEventTemplate(TaskCCWFinalizationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 21, ProviderGuid);
            }
        }
        public event Action<TaskCCWQueryInterfaceFailureArgs> TaskCCWQueryInterfaceFailure
        {
            add
            {
                source.RegisterEventTemplate(TaskCCWQueryInterfaceFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 30, ProviderGuid);
            }
        }
        public event Action<TaskCCWQueryRuntimeClassNameArgs> TaskCCWQueryRuntimeClassName
        {
            add
            {
                source.RegisterEventTemplate(TaskCCWQueryRuntimeClassNameTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 24, ProviderGuid);
            }
        }
        public event Action<TaskCCWRefCountDecArgs> TaskCCWRefCountDec
        {
            add
            {
                source.RegisterEventTemplate(TaskCCWRefCountDecTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 23, ProviderGuid);
            }
        }
        public event Action<TaskCCWRefCountIncArgs> TaskCCWRefCountInc
        {
            add
            {
                source.RegisterEventTemplate(TaskCCWRefCountIncTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 22, ProviderGuid);
            }
        }
        public event Action<TaskCCWResolveFailureArgs> TaskCCWResolveFailure
        {
            add
            {
                source.RegisterEventTemplate(TaskCCWResolveFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 33, ProviderGuid);
            }
        }
        public event Action<TaskJupiterAddMemoryPressureArgs> TaskJupiterAddMemoryPressure
        {
            add
            {
                source.RegisterEventTemplate(TaskJupiterAddMemoryPressureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 42, ProviderGuid);
            }
        }
        public event Action<TaskJupiterCreateManagedReferenceArgs> TaskJupiterCreateManagedReference
        {
            add
            {
                source.RegisterEventTemplate(TaskJupiterCreateManagedReferenceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 44, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> TaskJupiterDisconnectRCWsInCurrentApartment
        {
            add
            {
                source.RegisterEventTemplate(TaskJupiterDisconnectRCWsInCurrentApartmentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 41, ProviderGuid);
            }
        }
        public event Action<EmptyTraceData> TaskJupiterGarbageCollect
        {
            add
            {
                source.RegisterEventTemplate(TaskJupiterGarbageCollectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 40, ProviderGuid);
            }
        }
        public event Action<TaskJupiterRemoveMemoryPressureArgs> TaskJupiterRemoveMemoryPressure
        {
            add
            {
                source.RegisterEventTemplate(TaskJupiterRemoveMemoryPressureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 43, ProviderGuid);
            }
        }
        public event Action<TaskRCWCreationArgs> TaskRCWCreation
        {
            add
            {
                source.RegisterEventTemplate(TaskRCWCreationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, ProviderGuid);
            }
        }
        public event Action<TaskRCWFinalizationArgs> TaskRCWFinalization
        {
            add
            {
                source.RegisterEventTemplate(TaskRCWFinalizationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, ProviderGuid);
            }
        }
        public event Action<TaskRCWQueryInterfaceFailureArgs> TaskRCWQueryInterfaceFailure
        {
            add
            {
                source.RegisterEventTemplate(TaskRCWQueryInterfaceFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 14, ProviderGuid);
            }
        }
        public event Action<TaskRCWRefCountDecArgs> TaskRCWRefCountDec
        {
            add
            {
                source.RegisterEventTemplate(TaskRCWRefCountDecTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, ProviderGuid);
            }
        }
        public event Action<TaskRCWRefCountIncArgs> TaskRCWRefCountInc
        {
            add
            {
                source.RegisterEventTemplate(TaskRCWRefCountIncTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
            }
        }

        #region private
        protected override string GetProviderName() { return ProviderName; }

        static private TaskCCWCreationArgs TaskCCWCreationTemplate(Action<TaskCCWCreationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCCWCreationArgs(action, 20, 65514, "TaskCCWCreation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskCCWFinalizationArgs TaskCCWFinalizationTemplate(Action<TaskCCWFinalizationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCCWFinalizationArgs(action, 21, 65513, "TaskCCWFinalization", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskCCWQueryInterfaceFailureArgs TaskCCWQueryInterfaceFailureTemplate(Action<TaskCCWQueryInterfaceFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCCWQueryInterfaceFailureArgs(action, 30, 65504, "TaskCCWQueryInterfaceFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskCCWQueryRuntimeClassNameArgs TaskCCWQueryRuntimeClassNameTemplate(Action<TaskCCWQueryRuntimeClassNameArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCCWQueryRuntimeClassNameArgs(action, 24, 65510, "TaskCCWQueryRuntimeClassName", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskCCWRefCountDecArgs TaskCCWRefCountDecTemplate(Action<TaskCCWRefCountDecArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCCWRefCountDecArgs(action, 23, 65511, "TaskCCWRefCountDec", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskCCWRefCountIncArgs TaskCCWRefCountIncTemplate(Action<TaskCCWRefCountIncArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCCWRefCountIncArgs(action, 22, 65512, "TaskCCWRefCountInc", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskCCWResolveFailureArgs TaskCCWResolveFailureTemplate(Action<TaskCCWResolveFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCCWResolveFailureArgs(action, 33, 65501, "TaskCCWResolveFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskJupiterAddMemoryPressureArgs TaskJupiterAddMemoryPressureTemplate(Action<TaskJupiterAddMemoryPressureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskJupiterAddMemoryPressureArgs(action, 42, 65492, "TaskJupiterAddMemoryPressure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskJupiterCreateManagedReferenceArgs TaskJupiterCreateManagedReferenceTemplate(Action<TaskJupiterCreateManagedReferenceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskJupiterCreateManagedReferenceArgs(action, 44, 65490, "TaskJupiterCreateManagedReference", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData TaskJupiterDisconnectRCWsInCurrentApartmentTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 41, 65493, "TaskJupiterDisconnectRCWsInCurrentApartment", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private EmptyTraceData TaskJupiterGarbageCollectTemplate(Action<EmptyTraceData> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new EmptyTraceData(action, 40, 65494, "TaskJupiterGarbageCollect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskJupiterRemoveMemoryPressureArgs TaskJupiterRemoveMemoryPressureTemplate(Action<TaskJupiterRemoveMemoryPressureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskJupiterRemoveMemoryPressureArgs(action, 43, 65491, "TaskJupiterRemoveMemoryPressure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskRCWCreationArgs TaskRCWCreationTemplate(Action<TaskRCWCreationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskRCWCreationArgs(action, 10, 65524, "TaskRCWCreation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskRCWFinalizationArgs TaskRCWFinalizationTemplate(Action<TaskRCWFinalizationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskRCWFinalizationArgs(action, 11, 65523, "TaskRCWFinalization", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskRCWQueryInterfaceFailureArgs TaskRCWQueryInterfaceFailureTemplate(Action<TaskRCWQueryInterfaceFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskRCWQueryInterfaceFailureArgs(action, 14, 65520, "TaskRCWQueryInterfaceFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskRCWRefCountDecArgs TaskRCWRefCountDecTemplate(Action<TaskRCWRefCountDecArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskRCWRefCountDecArgs(action, 13, 65521, "TaskRCWRefCountDec", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskRCWRefCountIncArgs TaskRCWRefCountIncTemplate(Action<TaskRCWRefCountIncArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskRCWRefCountIncArgs(action, 12, 65522, "TaskRCWRefCountInc", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }

        static private volatile TraceEvent[] s_templates;
        protected override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[17];
                templates[0] = TaskRCWCreationTemplate(null);
                templates[1] = TaskRCWRefCountIncTemplate(null);
                templates[2] = TaskRCWRefCountDecTemplate(null);
                templates[3] = TaskRCWFinalizationTemplate(null);
                templates[4] = TaskRCWQueryInterfaceFailureTemplate(null);
                templates[5] = TaskCCWCreationTemplate(null);
                templates[6] = TaskCCWFinalizationTemplate(null);
                templates[7] = TaskCCWRefCountIncTemplate(null);
                templates[8] = TaskCCWRefCountDecTemplate(null);
                templates[9] = TaskCCWQueryRuntimeClassNameTemplate(null);
                templates[10] = TaskCCWQueryInterfaceFailureTemplate(null);
                templates[11] = TaskCCWResolveFailureTemplate(null);
                templates[12] = TaskJupiterGarbageCollectTemplate(null);
                templates[13] = TaskJupiterDisconnectRCWsInCurrentApartmentTemplate(null);
                templates[14] = TaskJupiterAddMemoryPressureTemplate(null);
                templates[15] = TaskJupiterRemoveMemoryPressureTemplate(null);
                templates[16] = TaskJupiterCreateManagedReferenceTemplate(null);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.InteropEventProvider
{
    public sealed class TaskCCWCreationArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public long targetObjectID { get { return GetInt64At(8); } }
        public Address targetObjectIDType { get { return (Address)GetInt64At(16); } }

        #region Private
        internal TaskCCWCreationArgs(Action<TaskCCWCreationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCCWCreationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "targetObjectID", targetObjectID);
            XmlAttrib(sb, "targetObjectIDType", targetObjectIDType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "targetObjectID", "targetObjectIDType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return targetObjectID;
                case 2:
                    return targetObjectIDType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCCWCreationArgs> m_target;
        #endregion
    }
    public sealed class TaskCCWFinalizationArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public long refCount { get { return GetInt64At(8); } }

        #region Private
        internal TaskCCWFinalizationArgs(Action<TaskCCWFinalizationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCCWFinalizationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "refCount", refCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "refCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return refCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCCWFinalizationArgs> m_target;
        #endregion
    }
    public sealed class TaskCCWQueryInterfaceFailureArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public Guid interfaceIId { get { return GetGuidAt(8); } }

        #region Private
        internal TaskCCWQueryInterfaceFailureArgs(Action<TaskCCWQueryInterfaceFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCCWQueryInterfaceFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "interfaceIId", interfaceIId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "interfaceIId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return interfaceIId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCCWQueryInterfaceFailureArgs> m_target;
        #endregion
    }
    public sealed class TaskCCWQueryRuntimeClassNameArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public string runtimeClassName { get { return GetUnicodeStringAt(8); } }

        #region Private
        internal TaskCCWQueryRuntimeClassNameArgs(Action<TaskCCWQueryRuntimeClassNameArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8)));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCCWQueryRuntimeClassNameArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "runtimeClassName", runtimeClassName);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "runtimeClassName" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return runtimeClassName;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCCWQueryRuntimeClassNameArgs> m_target;
        #endregion
    }
    public sealed class TaskCCWRefCountDecArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public int refCount { get { return GetInt32At(8); } }
        public int jupiterRefCount { get { return GetInt32At(12); } }

        #region Private
        internal TaskCCWRefCountDecArgs(Action<TaskCCWRefCountDecArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCCWRefCountDecArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "refCount", refCount);
            XmlAttrib(sb, "jupiterRefCount", jupiterRefCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "refCount", "jupiterRefCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return refCount;
                case 2:
                    return jupiterRefCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCCWRefCountDecArgs> m_target;
        #endregion
    }
    public sealed class TaskCCWRefCountIncArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public int refCount { get { return GetInt32At(8); } }
        public int jupiterRefCount { get { return GetInt32At(12); } }

        #region Private
        internal TaskCCWRefCountIncArgs(Action<TaskCCWRefCountIncArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCCWRefCountIncArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "refCount", refCount);
            XmlAttrib(sb, "jupiterRefCount", jupiterRefCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "refCount", "jupiterRefCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return refCount;
                case 2:
                    return jupiterRefCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCCWRefCountIncArgs> m_target;
        #endregion
    }
    public sealed class TaskCCWResolveFailureArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public long interfaceAddress { get { return GetInt64At(8); } }
        public Guid interfaceIId { get { return GetGuidAt(16); } }
        public int rejectedReason { get { return GetInt32At(32); } }

        #region Private
        internal TaskCCWResolveFailureArgs(Action<TaskCCWResolveFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 36));
            Debug.Assert(!(Version > 0 && EventDataLength < 36));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCCWResolveFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "interfaceAddress", interfaceAddress);
            XmlAttrib(sb, "interfaceIId", interfaceIId);
            XmlAttrib(sb, "rejectedReason", rejectedReason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "interfaceAddress", "interfaceIId", "rejectedReason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return interfaceAddress;
                case 2:
                    return interfaceIId;
                case 3:
                    return rejectedReason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCCWResolveFailureArgs> m_target;
        #endregion
    }
    public sealed class TaskJupiterAddMemoryPressureArgs : TraceEvent
    {
        public long memorySize { get { return GetInt64At(0); } }

        #region Private
        internal TaskJupiterAddMemoryPressureArgs(Action<TaskJupiterAddMemoryPressureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskJupiterAddMemoryPressureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "memorySize", memorySize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "memorySize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return memorySize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskJupiterAddMemoryPressureArgs> m_target;
        #endregion
    }
    public sealed class TaskJupiterCreateManagedReferenceArgs : TraceEvent
    {
        public long IUnknown { get { return GetInt64At(0); } }
        public long objectType { get { return GetInt64At(8); } }

        #region Private
        internal TaskJupiterCreateManagedReferenceArgs(Action<TaskJupiterCreateManagedReferenceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskJupiterCreateManagedReferenceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IUnknown", IUnknown);
            XmlAttrib(sb, "objectType", objectType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IUnknown", "objectType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IUnknown;
                case 1:
                    return objectType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskJupiterCreateManagedReferenceArgs> m_target;
        #endregion
    }
    public sealed class TaskJupiterRemoveMemoryPressureArgs : TraceEvent
    {
        public long memorySize { get { return GetInt64At(0); } }

        #region Private
        internal TaskJupiterRemoveMemoryPressureArgs(Action<TaskJupiterRemoveMemoryPressureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskJupiterRemoveMemoryPressureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "memorySize", memorySize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "memorySize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return memorySize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskJupiterRemoveMemoryPressureArgs> m_target;
        #endregion
    }
    public sealed class TaskRCWCreationArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public long typeRawValue { get { return GetInt64At(8); } }
        public string runtimeClassName { get { return GetUnicodeStringAt(16); } }
        public long context { get { return GetInt64At(SkipUnicodeString(16)); } }
        public long flags { get { return GetInt64At(SkipUnicodeString(16) + 8); } }

        #region Private
        internal TaskRCWCreationArgs(Action<TaskRCWCreationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(16) + 16));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(16) + 16));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskRCWCreationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "typeRawValue", typeRawValue);
            XmlAttrib(sb, "runtimeClassName", runtimeClassName);
            XmlAttrib(sb, "context", context);
            XmlAttrib(sb, "flags", flags);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "typeRawValue", "runtimeClassName", "context", "flags" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return typeRawValue;
                case 2:
                    return runtimeClassName;
                case 3:
                    return context;
                case 4:
                    return flags;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskRCWCreationArgs> m_target;
        #endregion
    }
    public sealed class TaskRCWFinalizationArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public int refCount { get { return GetInt32At(8); } }

        #region Private
        internal TaskRCWFinalizationArgs(Action<TaskRCWFinalizationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskRCWFinalizationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "refCount", refCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "refCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return refCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskRCWFinalizationArgs> m_target;
        #endregion
    }
    public sealed class TaskRCWQueryInterfaceFailureArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public long context { get { return GetInt64At(8); } }
        public Guid interfaceIId { get { return GetGuidAt(16); } }
        public int reason { get { return GetInt32At(32); } }

        #region Private
        internal TaskRCWQueryInterfaceFailureArgs(Action<TaskRCWQueryInterfaceFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 36));
            Debug.Assert(!(Version > 0 && EventDataLength < 36));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskRCWQueryInterfaceFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "context", context);
            XmlAttrib(sb, "interfaceIId", interfaceIId);
            XmlAttrib(sb, "reason", reason);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "context", "interfaceIId", "reason" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return context;
                case 2:
                    return interfaceIId;
                case 3:
                    return reason;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskRCWQueryInterfaceFailureArgs> m_target;
        #endregion
    }
    public sealed class TaskRCWRefCountDecArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public int refCount { get { return GetInt32At(8); } }

        #region Private
        internal TaskRCWRefCountDecArgs(Action<TaskRCWRefCountDecArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskRCWRefCountDecArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "refCount", refCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "refCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return refCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskRCWRefCountDecArgs> m_target;
        #endregion
    }
    public sealed class TaskRCWRefCountIncArgs : TraceEvent
    {
        public long objectID { get { return GetInt64At(0); } }
        public int refCount { get { return GetInt32At(8); } }

        #region Private
        internal TaskRCWRefCountIncArgs(Action<TaskRCWRefCountIncArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected override void Dispatch()
        {
            m_target(this);
        }
        protected override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskRCWRefCountIncArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "objectID", objectID);
            XmlAttrib(sb, "refCount", refCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "objectID", "refCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return objectID;
                case 1:
                    return refCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskRCWRefCountIncArgs> m_target;
        #endregion
    }
}
