<!-- See ETWInterface.h (search for ETWClrProfiler.h) for the command to recompile this.
     This will generated the ETWClrProfiler.* files as well as the ETWClrProfiler.cs needed
     for reading the events in PerfView.    There is a file compileManifest.bat that 
     is also included in the source that does this.  -->
<instrumentationManifest xmlns="http://schemas.microsoft.com/win/2004/08/events">
  <instrumentation xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events">
    <events xmlns="http://schemas.microsoft.com/win/2004/08/events">
      <provider name="ETWClrProfiler" guid="{6652970f-1756-5d8d-0805-e9aad152aa84}" resourceFileName="C:\Users\vancem\Documents\etw\ETWClrProfiler\X.dll" messageFileName="C:\Users\vancem\Documents\etw\ETWClrProfiler\X.dll" symbol="ETWClrProfiler">
        <keywords>
          <keyword name="Detach"          mask="0x800000000000" symbol="DetachKeyword"/>
          <keyword name="GC"              mask="0x000000000001" symbol="GCKeyword"/>
          <keyword name="GCHeap"          mask="0x000000000002" symbol="GCHeapKeyword"/>
          <keyword name="GCAlloc"         mask="0x000000000004" symbol="GCAllocKeyword"/>
          <keyword name="GCAllocSampled"  mask="0x000000000008" symbol="GCAllocSampledKeyword"/>
          <keyword name="Call"            mask="0x000000000010" symbol="CallKeyword"/>
          <keyword name="CallSampled"     mask="0x000000000020" symbol="CallSampledKeyword"/>
          <keyword name="DisableInlining" mask="0x000000000040" symbol="DisableInliningKeyword"/>
        </keywords>
        <tasks>
          <task name="GC" value="1" message="$(string.task_GC)" />

          <task name="ClassIDDefintion" value="10"  message="$(string.task_ClassIDDefintion)" />
          <task name="ModuleIDDefintion" value="11"  message="$(string.task_ModuleIDDefintion)" />
          
          <task name="ObjectAllocated" value="12"  message="$(string.task_ObjectAllocated)" />
          <task name="FinalizeableObjectQueued" value="13"  message="$(string.task_FinalizeableObjectQueued)" />
          <task name="HandleCreated" value="14"  message="$(string.task_HandleCreated)" />
          <task name="HandleDestroyed" value="15"  message="$(string.task_HandleDestroyed)" />
          <task name="SamplingRateChange" value="28"  message="$(string.task_SamplingRateChange)" />
          
          <task name="ObjectsMoved" value="20"  message="$(string.task_ObjectsMoved)" />
          <task name="ObjectsSurvived" value="21"  message="$(string.task_ObjectsSurvived)" />
          <task name="RootReferences" value="22"  message="$(string.task_RootReferences)" />
          <task name="ObjectReferences" value="23"  message="$(string.task_ObjectReferences)" />

          <task name="CaptureState" value="24"  message="$(string.task_CaptureState)" />
          <task name="ProfilerError" value="26"  message="$(string.task_ProfilerError)" />
          <task name="ProfilerShutdown" value="27"  message="$(string.task_ProfilerShutdown)" />

          <task name="CallEnter" value="29"  message="$(string.task_CallEnter)" />

          <task name="SendManifest" value="65534"  message="$(string.task_SendManifest)" />
        </tasks>
        
        <maps>
          <!-- ValueMaps -->
          <valueMap name="GCRootKind">
            <map value="0" message="$(string.map_GCRootKind.Stack)"/>
            <map value="1" message="$(string.map_GCRootKind.Finalizer)"/>
            <map value="2" message="$(string.map_GCRootKind.Handle)"/>
            <map value="3" message="$(string.map_GCRootKind.Other)"/>
          </valueMap>

          <!-- BitMaps -->
          <bitMap name="GCRootFlags">
            <map value="0x1" message="$(string.map_GCRootFlags.Pinning)"/>
            <map value="0x2" message="$(string.map_GCRootFlags.WeakRef)"/>
            <map value="0x4" message="$(string.map_GCRootFlags.Interior)"/>
            <map value="0x8" message="$(string.map_GCRootFlags.RefCounted)"/>
          </bitMap>

          <bitMap name="ClassDefinitionFlags" symbol="ClassDefinitionFlags">
            <map value="0x1" message="$(string.map_ClassDefintionFlags.ValueType)"/>
            <map value="0x2" message="$(string.map_ClassDefintionFlags.Public)"/>
            <map value="0x4" message="$(string.map_ClassDefintionFlags.Finalizable)"/>
          </bitMap>
        </maps>
        <events>
          <event value="1"  version="0" keywords="GC GCAlloc GCAllocSampled GCHeap" level="win:Informational" symbol="ClassIDDefintionEvent" task="ClassIDDefintion" template="ClassIDDefintionArgs"/>
          <event value="2"  version="0" keywords="GC GCAlloc GCAllocSampled GCHeap" level="win:Informational" symbol="ModuleIDDefintionEvent" task="ModuleIDDefintion" template="ModuleIDDefintionArgs"/>
          <event value="10" version="0" keywords="GCAlloc GCAllocSampled"        level="win:Verbose"       symbol="ObjectAllocatedEvent" task="ObjectAllocated" template="ObjectAllocatedArgs"/>
          <event value="11" version="0" keywords="GC GCAlloc GCAllocSampled"     level="win:Informational" symbol="FinalizeableObjectQueuedEvent" task="FinalizeableObjectQueued" template="FinalizeableObjectQueuedArgs"/>
          <event value="12" version="0" keywords="GCHeap GCAlloc GCAllocSampled" level="win:Informational" symbol="HandleCreatedEvent" task="HandleCreated" template="HandleCreatedArgs"/>
          <event value="13" version="0" keywords="GCHeap GCAlloc GCAllocSampled" level="win:Informational" symbol="HandleDestroyedEvent" task="HandleDestroyed" template="HandleDestroyedArgs"/>

          <event value="15" version="0" keywords="GCHeap" level="win:Verbose" symbol="RootReferencesEvent" task="RootReferences" template="RootReferencesArgs"/>
          <event value="16" version="0" keywords="GCHeap" level="win:Verbose" symbol="ObjectReferencesEvent" task="ObjectReferences" template="ObjectReferencesArgs"/>

          <event value="20" version="0" keywords="GC GCHeap GCAlloc GCAllocSampled" level="win:Informational" symbol="GCStartEvent" task="GC" opcode="win:Start" template="GCStartArgs"/>
          <event value="21" version="0" keywords="GC GCHeap GCAlloc GCAllocSampled" level="win:Informational" symbol="GCStopEvent" task="GC" opcode="win:Stop" template="GCStopArgs"/>
          <event value="22" version="0" keywords="GC GCHeap GCAlloc GCAllocSampled" level="win:Informational" symbol="ObjectsMovedEvent" task="ObjectsMoved" template="ObjectsMovedArgs"/>
          <event value="23" version="0" keywords="GC GCHeap GCAlloc GCAllocSampled" level="win:Informational" symbol="ObjectsSurvivedEvent" task="ObjectsSurvived" template="ObjectsSurvivedArgs"/>
          <event value="24" version="0" keywords="Detach GC GCAlloc GCHeap GCAllocSampled" level="win:Warning" symbol="CaptureStateStart" task="CaptureState" opcode="win:Start" />
          <event value="25" version="0" keywords="Detach GC GCAlloc GCHeap GCAllocSampled" level="win:Warning" symbol="CaptureStateStop" task="CaptureState" opcode="win:Stop" />
          <event value="26" version="0" keywords="Detach GC GCAlloc GCHeap GCAllocSampled" level="win:Error" symbol="ProfilerError" task="ProfilerError" template="ProfilerErrorArgs" />
          <event value="27" version="0" keywords="Detach GC GCAlloc GCHeap GCAllocSampled" level="win:Error" symbol="ProfilerShutdown" task="ProfilerShutdown"/>
          <event value="28"  version="0" keywords="GCAllocSampled" level="win:Verbose" symbol="SamplingRateChange" task="SamplingRateChange" template="SamplingRateChangeArgs"/>

          <event value="29"  version="0" keywords="Call CallSampled" level="win:Verbose" symbol="CallEnterEvent" task="CallEnter" template="CallEnterArgs"/>

          <event value="65534" version="0" keywords="Detach GC GCAlloc GCHeap GCAllocSampled" task="SendManifest" level="win:LogAlways" symbol="SendManifestEvent" template="SendManifestArgs"/>
        </events>
        <templates>
          <template tid="ClassIDDefintionArgs">
            <data name="ClassID" inType="win:UInt64"/>
            <data name="Token" inType="win:UInt32"/>
            <data name="Flags" inType="win:UInt32" map="ClassDefinitionFlags"/>
            <data name="ModuleID" inType="win:UInt64"/>
            <data name="Name" inType="win:UnicodeString"/>
          </template>

          <template tid="ModuleIDDefintionArgs">
            <data name="ModuleID" inType="win:UInt64"/>
            <data name="AssemblyID" inType="win:UInt64"/>
            <data name="Path" inType="win:UnicodeString"/>
          </template>

          <template tid="ObjectAllocatedArgs">
            <data name="ObjectID" inType="win:UInt64"/>
            <data name="ClassID" inType="win:UInt64"/>
            <data name="Size" inType="win:UInt64"/>
            <!-- If we are sampling, then this sample actually represents more bytes than its actual size.  This is that number. -->
            <data name="RepresentativeSize" inType="win:UInt64"/>
          </template>

          <template tid="SamplingRateChangeArgs">
            <data name="ClassID" inType="win:UInt64"/>
            <data name="ClassName" inType="win:UnicodeString"/> 
            <data name="MSecDelta" inType="win:Int32"/>
            <data name="MinAllocPerMSec" inType="win:Int32"/>
            <data name="NewAllocPerMSec" inType="win:Float"/>
            <data name="AllocPerMSec" inType="win:Float"/>
            <data name="SampleRate" inType="win:Int32"/>
          </template>
            
          <template tid="GCStartArgs">
            <data name="GCID" inType="win:Int32"/>
            <data name="Generation" inType="win:Int32"/>
            <data name="Induced" inType="win:Boolean"/>
          </template>

          <template tid="GCStopArgs">
            <data name="GCID" inType="win:Int32"/>
          </template>

          <template tid="FinalizeableObjectQueuedArgs">
            <data name="ObjectID" inType="win:UInt64"/>
            <data name="ClassID" inType="win:UInt64"/>
          </template>

          <template tid="HandleCreatedArgs">
            <data name="HandleID" inType="win:UInt64"/>
            <data name="InitialObjectID" inType="win:UInt64"/>
          </template>

          <template tid="HandleDestroyedArgs">
            <data name="HandleID" inType="win:UInt64"/>
          </template>

          <template tid="ObjectsSurvivedArgs">
            <data name="Count" inType="win:UInt32" /> 
            <data name="RangeBases" count="Count" inType="win:Pointer" />
            <data name="Lengths" count="Count" inType="win:UInt32" />
          </template>

          <template tid="ObjectsMovedArgs">
            <data name="Count" inType="win:UInt32" />
            <data name="RangeBases" count="Count" inType="win:Pointer" />
            <data name="TargetBases" count="Count" inType="win:Pointer" />
            <data name="Lengths" count="Count" inType="win:UInt32" />
          </template>

          <template tid="RootReferencesArgs">
            <data name="Count" inType="win:UInt32" />
            <data name="ObjectIDs" count="Count" inType="win:Pointer" />
            <data name="GCRootKinds" count="Count" inType="win:UInt32" map="GCRootKind" />
            <data name="GCRootFlags" count="Count" inType="win:UInt32" map="GCRootFlags" />
            <data name="RootIDs" count="Count" inType="win:Pointer" />
          </template>

          <template tid="ObjectReferencesArgs">
            <data name="ObjectID" inType="win:UInt64" />
            <data name="ClassID" inType="win:UInt64" />
            <data name="Size" inType="win:UInt64"/>
            <data name="ObjectRefCount" inType="win:UInt32" />
            <data name="ObjectRefs" count="ObjectRefCount" inType="win:Pointer" />
          </template>

          <template tid="ProfilerErrorArgs">
            <data name="ErrorCode" inType="win:UInt64" />
            <data name="Message" inType="win:UnicodeString"/>
          </template>

          <template tid="CallEnterArgs">
            <data name="FunctionID" inType="win:UInt64" />
            <data name="SampleRate" inType="win:UInt32" />
          </template>
          
          <template tid="SendManifestArgs">
            <data name="Format" inType="win:UInt8" />
            <data name="MajorVersion" inType="win:UInt8" />
            <data name="MinorVersion" inType="win:UInt8" />
            <data name="Magic" inType="win:UInt8" />
            <data name="TotalChunks" inType="win:UInt16" />
            <data name="ChunkNumger" inType="win:UInt16" />
            <data name="Data" inType="win:AnsiString" />
          </template>
        </templates>
      </provider>
    </events>
  </instrumentation>

  <localization>
    <resources culture="en-US">
      <stringTable>
        <string id="map_GCRootKind.Stack" value="Stack"/>
        <string id="map_GCRootKind.Finalizer" value="Finalizer"/>
        <string id="map_GCRootKind.Handle" value="Handle"/>
        <string id="map_GCRootKind.Other" value="Other"/>

        <string id="map_GCRootFlags.None" value="None"/>
        <string id="map_GCRootFlags.Pinning" value="Pinning"/>
        <string id="map_GCRootFlags.WeakRef" value="WeakRef"/>
        <string id="map_GCRootFlags.Interior" value="Interior"/>
        <string id="map_GCRootFlags.RefCounted" value="RefCounted"/>

        <string id="map_ClassDefintionFlags.None" value="None"/>
        <string id="map_ClassDefintionFlags.ValueType" value="ValueType"/>
        <string id="map_ClassDefintionFlags.Public" value="Public"/>
        <string id="map_ClassDefintionFlags.Finalizable" value="Finalizable"/>

        <string id="task_GC" value="GC"/>
        <string id="task_ClassIDDefintion" value="ClassIDDefintion"/>
        <string id="task_ModuleIDDefintion" value="ModuleIDDefintion"/>
        <string id="task_ObjectAllocated" value="ObjectAllocated"/>
        <string id="task_FinalizeableObjectQueued" value="FinalizeableObjectQueued"/>
        <string id="task_HandleCreated" value="HandleCreated"/>
        <string id="task_HandleDestroyed" value="HandleDestroyed"/>
        <string id="task_SamplingRateChange" value="SamplingRateChange"/>
        <string id="task_ObjectsMoved" value="ObjectsMoved"/>
        <string id="task_ObjectsSurvived" value="ObjectsSurvived"/>
        <string id="task_RootReferences" value="RootReferences"/>
        <string id="task_ObjectReferences" value="ObjectReferences"/>
        <string id="task_SendManifest" value="SendManifest"/>
        <string id="task_CaptureState" value="CaptureState"/>
        <string id="task_ProfilerError" value="ProfilerError"/>
        <string id="task_ProfilerShutdown" value="ProfilerShutdown"/>
        <string id="task_CallEnter" value="CallEnter"/>
      </stringTable>
    </resources>
  </localization>

</instrumentationManifest>
