//**********************************************************************`
//* This is an include file generated by Message Compiler.             *`
//*                                                                    *`
//* Copyright (c) Microsoft Corporation. All Rights Reserved.          *`
//**********************************************************************`
#pragma once
#include <wmistr.h>
#include <evntrace.h>
#include "evntprov.h"
//
//  Initial Defs
//
#if !defined(ETW_INLINE)
#define ETW_INLINE DECLSPEC_NOINLINE __inline
#endif

#if defined(__cplusplus)
extern "C" {
#endif

//
// Allow disabling of code generation
//
#ifndef MCGEN_DISABLE_PROVIDER_CODE_GENERATION
#if  !defined(McGenDebug)
#define McGenDebug(a,b)
#endif
#ifndef MCGEN_EVENT_ENABLED
#define MCGEN_EVENT_ENABLED(EventName) EventEnabled##EventName()
#endif


#if !defined(MCGEN_TRACE_CONTEXT_DEF)
#define MCGEN_TRACE_CONTEXT_DEF
typedef struct _MCGEN_TRACE_CONTEXT
{
    TRACEHANDLE            RegistrationHandle;
    TRACEHANDLE            Logger;
    ULONGLONG              MatchAnyKeyword;
    ULONGLONG              MatchAllKeyword;
    ULONG                  Flags;
    ULONG                  IsEnabled;
    UCHAR                  Level;
    UCHAR                  Reserve;
    USHORT                 EnableBitsCount;
    PULONG                 EnableBitMask;
    const ULONGLONG*       EnableKeyWords;
    const UCHAR*           EnableLevel;
} MCGEN_TRACE_CONTEXT, *PMCGEN_TRACE_CONTEXT;
#endif

#if !defined(MCGEN_LEVEL_KEYWORD_ENABLED_DEF)
#define MCGEN_LEVEL_KEYWORD_ENABLED_DEF
FORCEINLINE
BOOLEAN
McGenLevelKeywordEnabled(
    _In_ PMCGEN_TRACE_CONTEXT EnableInfo,
    _In_ UCHAR Level,
    _In_ ULONGLONG Keyword
    )
{
    //
    // Check if the event Level is lower than the level at which
    // the channel is enabled.
    // If the event Level is 0 or the channel is enabled at level 0,
    // all levels are enabled.
    //

    if ((Level <= EnableInfo->Level) || // This also covers the case of Level == 0.
        (EnableInfo->Level == 0)) {

        //
        // Check if Keyword is enabled
        //

        if ((Keyword == (ULONGLONG)0) ||
            ((Keyword & EnableInfo->MatchAnyKeyword) &&
             ((Keyword & EnableInfo->MatchAllKeyword) == EnableInfo->MatchAllKeyword))) {
            return TRUE;
        }
    }

    return FALSE;

}
#endif

#if !defined(MCGEN_EVENT_ENABLED_DEF)
#define MCGEN_EVENT_ENABLED_DEF
FORCEINLINE
BOOLEAN
McGenEventEnabled(
    _In_ PMCGEN_TRACE_CONTEXT EnableInfo,
    _In_ PCEVENT_DESCRIPTOR EventDescriptor
    )
{

    return McGenLevelKeywordEnabled(EnableInfo, EventDescriptor->Level, EventDescriptor->Keyword);

}
#endif


//
// EnableCheckMacro
//
#ifndef MCGEN_ENABLE_CHECK
#define MCGEN_ENABLE_CHECK(Context, Descriptor) (Context.IsEnabled &&  McGenEventEnabled(&Context, &Descriptor))
#endif

#ifndef MCGEN_EVENTWRITE_UM
#define MCGEN_EVENTWRITE_UM EventWrite
#endif
#ifndef MCGEN_EVENTREGISTER_UM
#define MCGEN_EVENTREGISTER_UM EventRegister
#endif
#ifndef MCGEN_EVENTUNREGISTER_UM
#define MCGEN_EVENTUNREGISTER_UM EventUnregister
#endif

#if !defined(MCGEN_CONTROL_CALLBACK)
#define MCGEN_CONTROL_CALLBACK

DECLSPEC_NOINLINE __inline
VOID
__stdcall
McGenControlCallbackV2(
    _In_ LPCGUID SourceId,
    _In_ ULONG ControlCode,
    _In_ UCHAR Level,
    _In_ ULONGLONG MatchAnyKeyword,
    _In_ ULONGLONG MatchAllKeyword,
    _In_opt_ PEVENT_FILTER_DESCRIPTOR FilterData,
    _Inout_opt_ PVOID CallbackContext
    )
/*++

Routine Description:

    This is the notification callback for Windows Vista and later.

Arguments:

    SourceId - The GUID that identifies the session that enabled the provider.

    ControlCode - The parameter indicates whether the provider
                  is being enabled or disabled.

    Level - The level at which the event is enabled.

    MatchAnyKeyword - The bitmask of keywords that the provider uses to
                      determine the category of events that it writes.

    MatchAllKeyword - This bitmask additionally restricts the category
                      of events that the provider writes.

    FilterData - The provider-defined data.

    CallbackContext - The context of the callback that is defined when the provider
                      called EtwRegister to register itself.

Remarks:

    ETW calls this function to notify provider of enable/disable

--*/
{
    PMCGEN_TRACE_CONTEXT Ctx = (PMCGEN_TRACE_CONTEXT)CallbackContext;
    ULONG Ix;
#ifndef MCGEN_PRIVATE_ENABLE_CALLBACK_V2
    UNREFERENCED_PARAMETER(SourceId);
    UNREFERENCED_PARAMETER(FilterData);
#endif

    if (Ctx == NULL) {
        return;
    }

    switch (ControlCode) {

        case EVENT_CONTROL_CODE_ENABLE_PROVIDER:
            Ctx->Level = Level;
            Ctx->MatchAnyKeyword = MatchAnyKeyword;
            Ctx->MatchAllKeyword = MatchAllKeyword;
            Ctx->IsEnabled = EVENT_CONTROL_CODE_ENABLE_PROVIDER;

            for (Ix = 0; Ix < Ctx->EnableBitsCount; Ix += 1) {
                if (McGenLevelKeywordEnabled(Ctx, Ctx->EnableLevel[Ix], Ctx->EnableKeyWords[Ix]) != FALSE) {
                    Ctx->EnableBitMask[Ix >> 5] |= (1 << (Ix % 32));
                } else {
                    Ctx->EnableBitMask[Ix >> 5] &= ~(1 << (Ix % 32));
                }
            }
            break;

        case EVENT_CONTROL_CODE_DISABLE_PROVIDER:
            Ctx->IsEnabled = EVENT_CONTROL_CODE_DISABLE_PROVIDER;
            Ctx->Level = 0;
            Ctx->MatchAnyKeyword = 0;
            Ctx->MatchAllKeyword = 0;
            if (Ctx->EnableBitsCount > 0) {
                RtlZeroMemory(Ctx->EnableBitMask, (((Ctx->EnableBitsCount - 1) / 32) + 1) * sizeof(ULONG));
            }
            break;

        default:
            break;
    }

#ifdef MCGEN_PRIVATE_ENABLE_CALLBACK_V2
    //
    // Call user defined callback
    //
    MCGEN_PRIVATE_ENABLE_CALLBACK_V2(
        SourceId,
        ControlCode,
        Level,
        MatchAnyKeyword,
        MatchAllKeyword,
        FilterData,
        CallbackContext
        );
#endif

    return;
}

#endif

#ifndef McGenEventWriteUM_def
#define McGenEventWriteUM_def
DECLSPEC_NOINLINE __inline
ULONG __stdcall
McGenEventWriteUM(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_range_(1, 128) ULONG EventDataCount,
    _Inout_updates_(EventDataCount) EVENT_DATA_DESCRIPTOR* EventData
    )
{
    const USHORT UNALIGNED* Traits;
    UCHAR DisallowedChannel;
    ULONGLONG DescriptorCopy[2]; // ULONGLONG to suppress unnecessary cookie.

    Traits = (const USHORT UNALIGNED*)(UINT_PTR)Context->Logger;

    if (Traits == NULL) {
        EventDataCount -= 1;
        EventData += 1;
        if (EventDataCount == 0) {
            EventData = NULL;
        }
        DisallowedChannel = 12; // WINEVENT_CHANNEL_PROVIDERMETADATA
    } else {
        EventData[0].Ptr = (ULONG_PTR)Traits;
        EventData[0].Size = *Traits;
        EventData[0].Reserved = 2; // EVENT_DATA_DESCRIPTOR_TYPE_PROVIDER_METADATA
        DisallowedChannel = 0;
    }

    if (Descriptor->Channel == DisallowedChannel) {
        *(EVENT_DESCRIPTOR*)DescriptorCopy = *Descriptor;
        ((EVENT_DESCRIPTOR*)DescriptorCopy)->Channel = (UCHAR)((Traits == NULL) ? 0 : 12);
        Descriptor = (EVENT_DESCRIPTOR*)DescriptorCopy;
    }

    return MCGEN_EVENTWRITE_UM(Context->RegistrationHandle, Descriptor, EventDataCount, EventData);
}
#endif // McGenEventWriteUM_def

#endif // MCGEN_DISABLE_PROVIDER_CODE_GENERATION

//+
// Provider ETWClrProfiler Event Count 19
//+
EXTERN_C __declspec(selectany) const GUID ETWClrProfiler = {0x6652970f, 0x1756, 0x5d8d, {0x08, 0x05, 0xe9, 0xaa, 0xd1, 0x52, 0xaa, 0x84}};

//
// Tasks
//
#define ETWClrProfiler_TASK_GC 0x1
#define ETWClrProfiler_TASK_ClassIDDefintion 0xa
#define ETWClrProfiler_TASK_ModuleIDDefintion 0xb
#define ETWClrProfiler_TASK_ObjectAllocated 0xc
#define ETWClrProfiler_TASK_FinalizeableObjectQueued 0xd
#define ETWClrProfiler_TASK_HandleCreated 0xe
#define ETWClrProfiler_TASK_HandleDestroyed 0xf
#define ETWClrProfiler_TASK_SamplingRateChange 0x1c
#define ETWClrProfiler_TASK_ObjectsMoved 0x14
#define ETWClrProfiler_TASK_ObjectsSurvived 0x15
#define ETWClrProfiler_TASK_RootReferences 0x16
#define ETWClrProfiler_TASK_ObjectReferences 0x17
#define ETWClrProfiler_TASK_CaptureState 0x18
#define ETWClrProfiler_TASK_ProfilerError 0x1a
#define ETWClrProfiler_TASK_ProfilerShutdown 0x1b
#define ETWClrProfiler_TASK_CallEnter 0x1d
#define ETWClrProfiler_TASK_SendManifest 0xfffe
//
// Keyword
//
#define DetachKeyword 0x800000000000
#define GCKeyword 0x1
#define GCHeapKeyword 0x2
#define GCAllocKeyword 0x4
#define GCAllocSampledKeyword 0x8
#define CallKeyword 0x10
#define CallSampledKeyword 0x20
#define DisableInliningKeyword 0x40

//
// Event Descriptors
//
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ClassIDDefintionEvent = {0x1, 0x0, 0x0, 0x4, 0x0, 0xa, 0xf};
#define ClassIDDefintionEvent_value 0x1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ModuleIDDefintionEvent = {0x2, 0x0, 0x0, 0x4, 0x0, 0xb, 0xf};
#define ModuleIDDefintionEvent_value 0x2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ObjectAllocatedEvent = {0xa, 0x0, 0x0, 0x5, 0x0, 0xc, 0xc};
#define ObjectAllocatedEvent_value 0xa
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR FinalizeableObjectQueuedEvent = {0xb, 0x0, 0x0, 0x4, 0x0, 0xd, 0xd};
#define FinalizeableObjectQueuedEvent_value 0xb
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR HandleCreatedEvent = {0xc, 0x0, 0x0, 0x4, 0x0, 0xe, 0xe};
#define HandleCreatedEvent_value 0xc
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR HandleDestroyedEvent = {0xd, 0x0, 0x0, 0x4, 0x0, 0xf, 0xe};
#define HandleDestroyedEvent_value 0xd
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR RootReferencesEvent = {0xf, 0x0, 0x0, 0x5, 0x0, 0x16, 0x2};
#define RootReferencesEvent_value 0xf
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ObjectReferencesEvent = {0x10, 0x0, 0x0, 0x5, 0x0, 0x17, 0x2};
#define ObjectReferencesEvent_value 0x10
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GCStartEvent = {0x14, 0x0, 0x0, 0x4, 0x1, 0x1, 0xf};
#define GCStartEvent_value 0x14
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GCStopEvent = {0x15, 0x0, 0x0, 0x4, 0x2, 0x1, 0xf};
#define GCStopEvent_value 0x15
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ObjectsMovedEvent = {0x16, 0x0, 0x0, 0x4, 0x0, 0x14, 0xf};
#define ObjectsMovedEvent_value 0x16
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ObjectsSurvivedEvent = {0x17, 0x0, 0x0, 0x4, 0x0, 0x15, 0xf};
#define ObjectsSurvivedEvent_value 0x17
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CaptureStateStart = {0x18, 0x0, 0x0, 0x3, 0x1, 0x18, 0x80000000000f};
#define CaptureStateStart_value 0x18
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CaptureStateStop = {0x19, 0x0, 0x0, 0x3, 0x2, 0x18, 0x80000000000f};
#define CaptureStateStop_value 0x19
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ProfilerError = {0x1a, 0x0, 0x0, 0x2, 0x0, 0x1a, 0x80000000000f};
#define ProfilerError_value 0x1a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ProfilerShutdown = {0x1b, 0x0, 0x0, 0x2, 0x0, 0x1b, 0x80000000000f};
#define ProfilerShutdown_value 0x1b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR SamplingRateChange = {0x1c, 0x0, 0x0, 0x5, 0x0, 0x1c, 0x8};
#define SamplingRateChange_value 0x1c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CallEnterEvent = {0x1d, 0x0, 0x0, 0x5, 0x0, 0x1d, 0x30};
#define CallEnterEvent_value 0x1d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR SendManifestEvent = {0xfffe, 0x0, 0x0, 0x0, 0x0, 0xfffe, 0x80000000000f};
#define SendManifestEvent_value 0xfffe

//
// Note on Generate Code from Manifest for Windows Vista and above
//
//Structures :  are handled as a size and pointer pairs. The macro for the event will have an extra
//parameter for the size in bytes of the structure. Make sure that your structures have no extra padding.
//
//Strings: There are several cases that can be described in the manifest. For array of variable length
//strings, the generated code will take the count of characters for the whole array as an input parameter.
//
//SID No support for array of SIDs, the macro will take a pointer to the SID and use appropriate
//GetLengthSid function to get the length.
//

//
// Allow disabling of code generation
//
#ifndef MCGEN_DISABLE_PROVIDER_CODE_GENERATION

//
// Globals
//

#ifndef ETWClrProfiler_Traits
#define ETWClrProfiler_Traits NULL
#endif
#ifndef _ClassDefinitionFlags_def
#define _ClassDefinitionFlags_def
typedef enum _ClassDefinitionFlags
{
}ClassDefinitionFlags;
#endif


//
// Event Enablement Bits
//

EXTERN_C __declspec(selectany) DECLSPEC_CACHEALIGN ULONG ETWClrProfilerEnableBits[1];
EXTERN_C __declspec(selectany) const ULONGLONG ETWClrProfilerKeywords[10] = {0xf, 0xc, 0xd, 0xe, 0x2, 0x80000000000f, 0x80000000000f, 0x8, 0x30, 0x80000000000f};
EXTERN_C __declspec(selectany) const UCHAR ETWClrProfilerLevels[10] = {4, 5, 4, 4, 5, 3, 2, 5, 5, 0};
EXTERN_C __declspec(selectany) MCGEN_TRACE_CONTEXT ETWClrProfiler_Context = {0, (ULONG_PTR)ETWClrProfiler_Traits, 0, 0, 0, 0, 0, 0, 10, ETWClrProfilerEnableBits, ETWClrProfilerKeywords, ETWClrProfilerLevels};

#define ETWClrProfilerHandle (ETWClrProfiler_Context.RegistrationHandle)

#if !defined(McGenEventRegisterUnregister)
#define McGenEventRegisterUnregister
#pragma warning(push)
#pragma warning(disable:6103)
DECLSPEC_NOINLINE __inline
ULONG __stdcall
McGenEventRegister(
    _In_ LPCGUID ProviderId,
    _In_opt_ PENABLECALLBACK EnableCallback,
    _In_opt_ PVOID CallbackContext,
    _Inout_ PREGHANDLE RegHandle
    )
/*++

Routine Description:

    This function registers the provider with ETW USER mode.

Arguments:
    ProviderId - Provider ID to register with ETW.

    EnableCallback - Callback to be used.

    CallbackContext - Context for this provider.

    RegHandle - Pointer to registration handle.

Remarks:

    If the handle != NULL will return ERROR_SUCCESS

--*/
{
    ULONG Error;


    if (*RegHandle) {
        //
        // already registered
        //
        return ERROR_SUCCESS;
    }

    Error = MCGEN_EVENTREGISTER_UM( ProviderId, EnableCallback, CallbackContext, RegHandle);

    return Error;
}
#pragma warning(pop)


DECLSPEC_NOINLINE __inline
ULONG __stdcall
McGenEventUnregister(_Inout_ PREGHANDLE RegHandle)
/*++

Routine Description:

    Unregister from ETW USER mode

Arguments:
            RegHandle this is the pointer to the provider context
Remarks:
            If provider has not been registered, RegHandle == NULL,
            return ERROR_SUCCESS
--*/
{
    ULONG Error;


    if(!(*RegHandle)) {
        //
        // Provider has not registerd
        //
        return ERROR_SUCCESS;
    }

    Error = MCGEN_EVENTUNREGISTER_UM(*RegHandle);
    *RegHandle = (REGHANDLE)0;

    return Error;
}
#endif
//
// Register with ETW (Vista or later) using provider GUID determined from manifest
//
#ifndef EventRegisterETWClrProfiler
#define EventRegisterETWClrProfiler() McGenEventRegister(&ETWClrProfiler, McGenControlCallbackV2, &ETWClrProfiler_Context, &ETWClrProfilerHandle)
#endif

//
// Unregister with ETW
//
#ifndef EventUnregisterETWClrProfiler
#define EventUnregisterETWClrProfiler() McGenEventUnregister(&ETWClrProfilerHandle)
#endif

//
// Enablement check macro for ClassIDDefintionEvent
//

#define EventEnabledClassIDDefintionEvent() ((ETWClrProfilerEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for ClassIDDefintionEvent
//
#define EventWriteClassIDDefintionEvent(ClassID, Token, Flags, ModuleID, Name)\
        MCGEN_EVENT_ENABLED(ClassIDDefintionEvent) ?\
        McTemplateU0xqqxz(&ETWClrProfiler_Context, &ClassIDDefintionEvent, ClassID, Token, Flags, ModuleID, Name)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ModuleIDDefintionEvent
//

#define EventEnabledModuleIDDefintionEvent() ((ETWClrProfilerEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for ModuleIDDefintionEvent
//
#define EventWriteModuleIDDefintionEvent(ModuleID, AssemblyID, Path)\
        MCGEN_EVENT_ENABLED(ModuleIDDefintionEvent) ?\
        McTemplateU0xxz(&ETWClrProfiler_Context, &ModuleIDDefintionEvent, ModuleID, AssemblyID, Path)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ObjectAllocatedEvent
//

#define EventEnabledObjectAllocatedEvent() ((ETWClrProfilerEnableBits[0] & 0x00000002) != 0)

//
// Event Macro for ObjectAllocatedEvent
//
#define EventWriteObjectAllocatedEvent(ObjectID, ClassID, Size, RepresentativeSize)\
        MCGEN_EVENT_ENABLED(ObjectAllocatedEvent) ?\
        McTemplateU0xxxx(&ETWClrProfiler_Context, &ObjectAllocatedEvent, ObjectID, ClassID, Size, RepresentativeSize)\
        : ERROR_SUCCESS\

//
// Enablement check macro for FinalizeableObjectQueuedEvent
//

#define EventEnabledFinalizeableObjectQueuedEvent() ((ETWClrProfilerEnableBits[0] & 0x00000004) != 0)

//
// Event Macro for FinalizeableObjectQueuedEvent
//
#define EventWriteFinalizeableObjectQueuedEvent(ObjectID, ClassID)\
        MCGEN_EVENT_ENABLED(FinalizeableObjectQueuedEvent) ?\
        McTemplateU0xx(&ETWClrProfiler_Context, &FinalizeableObjectQueuedEvent, ObjectID, ClassID)\
        : ERROR_SUCCESS\

//
// Enablement check macro for HandleCreatedEvent
//

#define EventEnabledHandleCreatedEvent() ((ETWClrProfilerEnableBits[0] & 0x00000008) != 0)

//
// Event Macro for HandleCreatedEvent
//
#define EventWriteHandleCreatedEvent(HandleID, InitialObjectID)\
        MCGEN_EVENT_ENABLED(HandleCreatedEvent) ?\
        McTemplateU0xx(&ETWClrProfiler_Context, &HandleCreatedEvent, HandleID, InitialObjectID)\
        : ERROR_SUCCESS\

//
// Enablement check macro for HandleDestroyedEvent
//

#define EventEnabledHandleDestroyedEvent() ((ETWClrProfilerEnableBits[0] & 0x00000008) != 0)

//
// Event Macro for HandleDestroyedEvent
//
#define EventWriteHandleDestroyedEvent(HandleID)\
        MCGEN_EVENT_ENABLED(HandleDestroyedEvent) ?\
        McTemplateU0x(&ETWClrProfiler_Context, &HandleDestroyedEvent, HandleID)\
        : ERROR_SUCCESS\

//
// Enablement check macro for RootReferencesEvent
//

#define EventEnabledRootReferencesEvent() ((ETWClrProfilerEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for RootReferencesEvent
//
#define EventWriteRootReferencesEvent(Count, ObjectIDs, GCRootKinds, GCRootFlags, RootIDs)\
        MCGEN_EVENT_ENABLED(RootReferencesEvent) ?\
        McTemplateU0qPR0QR0QR0PR0(&ETWClrProfiler_Context, &RootReferencesEvent, Count, ObjectIDs, GCRootKinds, GCRootFlags, RootIDs)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ObjectReferencesEvent
//

#define EventEnabledObjectReferencesEvent() ((ETWClrProfilerEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for ObjectReferencesEvent
//
#define EventWriteObjectReferencesEvent(ObjectID, ClassID, Size, ObjectRefCount, ObjectRefs)\
        MCGEN_EVENT_ENABLED(ObjectReferencesEvent) ?\
        McTemplateU0xxxqPR3(&ETWClrProfiler_Context, &ObjectReferencesEvent, ObjectID, ClassID, Size, ObjectRefCount, ObjectRefs)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GCStartEvent
//

#define EventEnabledGCStartEvent() ((ETWClrProfilerEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for GCStartEvent
//
#define EventWriteGCStartEvent(GCID, Generation, Induced)\
        MCGEN_EVENT_ENABLED(GCStartEvent) ?\
        McTemplateU0ddt(&ETWClrProfiler_Context, &GCStartEvent, GCID, Generation, Induced)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GCStopEvent
//

#define EventEnabledGCStopEvent() ((ETWClrProfilerEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for GCStopEvent
//
#define EventWriteGCStopEvent(GCID)\
        MCGEN_EVENT_ENABLED(GCStopEvent) ?\
        McTemplateU0d(&ETWClrProfiler_Context, &GCStopEvent, GCID)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ObjectsMovedEvent
//

#define EventEnabledObjectsMovedEvent() ((ETWClrProfilerEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for ObjectsMovedEvent
//
#define EventWriteObjectsMovedEvent(Count, RangeBases, TargetBases, Lengths)\
        MCGEN_EVENT_ENABLED(ObjectsMovedEvent) ?\
        McTemplateU0qPR0PR0QR0(&ETWClrProfiler_Context, &ObjectsMovedEvent, Count, RangeBases, TargetBases, Lengths)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ObjectsSurvivedEvent
//

#define EventEnabledObjectsSurvivedEvent() ((ETWClrProfilerEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for ObjectsSurvivedEvent
//
#define EventWriteObjectsSurvivedEvent(Count, RangeBases, Lengths)\
        MCGEN_EVENT_ENABLED(ObjectsSurvivedEvent) ?\
        McTemplateU0qPR0QR0(&ETWClrProfiler_Context, &ObjectsSurvivedEvent, Count, RangeBases, Lengths)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CaptureStateStart
//

#define EventEnabledCaptureStateStart() ((ETWClrProfilerEnableBits[0] & 0x00000020) != 0)

//
// Event Macro for CaptureStateStart
//
#define EventWriteCaptureStateStart()\
        MCGEN_EVENT_ENABLED(CaptureStateStart) ?\
        McTemplateU0(&ETWClrProfiler_Context, &CaptureStateStart)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CaptureStateStop
//

#define EventEnabledCaptureStateStop() ((ETWClrProfilerEnableBits[0] & 0x00000020) != 0)

//
// Event Macro for CaptureStateStop
//
#define EventWriteCaptureStateStop()\
        MCGEN_EVENT_ENABLED(CaptureStateStop) ?\
        McTemplateU0(&ETWClrProfiler_Context, &CaptureStateStop)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ProfilerError
//

#define EventEnabledProfilerError() ((ETWClrProfilerEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for ProfilerError
//
#define EventWriteProfilerError(ErrorCode, Message)\
        MCGEN_EVENT_ENABLED(ProfilerError) ?\
        McTemplateU0xz(&ETWClrProfiler_Context, &ProfilerError, ErrorCode, Message)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ProfilerShutdown
//

#define EventEnabledProfilerShutdown() ((ETWClrProfilerEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for ProfilerShutdown
//
#define EventWriteProfilerShutdown()\
        MCGEN_EVENT_ENABLED(ProfilerShutdown) ?\
        McTemplateU0(&ETWClrProfiler_Context, &ProfilerShutdown)\
        : ERROR_SUCCESS\

//
// Enablement check macro for SamplingRateChange
//

#define EventEnabledSamplingRateChange() ((ETWClrProfilerEnableBits[0] & 0x00000080) != 0)

//
// Event Macro for SamplingRateChange
//
#define EventWriteSamplingRateChange(ClassID, ClassName, MSecDelta, MinAllocPerMSec, NewAllocPerMSec, AllocPerMSec, SampleRate)\
        MCGEN_EVENT_ENABLED(SamplingRateChange) ?\
        McTemplateU0xzddffd(&ETWClrProfiler_Context, &SamplingRateChange, ClassID, ClassName, MSecDelta, MinAllocPerMSec, NewAllocPerMSec, AllocPerMSec, SampleRate)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CallEnterEvent
//

#define EventEnabledCallEnterEvent() ((ETWClrProfilerEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for CallEnterEvent
//
#define EventWriteCallEnterEvent(FunctionID, SampleRate)\
        MCGEN_EVENT_ENABLED(CallEnterEvent) ?\
        McTemplateU0xq(&ETWClrProfiler_Context, &CallEnterEvent, FunctionID, SampleRate)\
        : ERROR_SUCCESS\

//
// Enablement check macro for SendManifestEvent
//

#define EventEnabledSendManifestEvent() ((ETWClrProfilerEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for SendManifestEvent
//
#define EventWriteSendManifestEvent(Format, MajorVersion, MinorVersion, Magic, TotalChunks, ChunkNumger, Data)\
        MCGEN_EVENT_ENABLED(SendManifestEvent) ?\
        McTemplateU0cccchhs(&ETWClrProfiler_Context, &SendManifestEvent, Format, MajorVersion, MinorVersion, Magic, TotalChunks, ChunkNumger, Data)\
        : ERROR_SUCCESS\

#endif // MCGEN_DISABLE_PROVIDER_CODE_GENERATION


//
// Allow Diasabling of code generation
//
#ifndef MCGEN_DISABLE_PROVIDER_CODE_GENERATION

//
// Template Functions
//
//
//Template from manifest : ClassIDDefintionArgs
//
#ifndef McTemplateU0xqqxz_def
#define McTemplateU0xqqxz_def
ETW_INLINE
ULONG
McTemplateU0xqqxz(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_ const unsigned int  _Arg1,
    _In_ const unsigned int  _Arg2,
    _In_ unsigned __int64  _Arg3,
    _In_opt_ PCWSTR  _Arg4
    )
{
#define McTemplateU0xqqxz_ARGCOUNT 5

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xqqxz_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[3],&_Arg2, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[4],&_Arg3, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[5],
                        (_Arg4 != NULL) ? _Arg4 : L"NULL",
                        (_Arg4 != NULL) ? (ULONG)((wcslen(_Arg4) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xqqxz_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : ModuleIDDefintionArgs
//
#ifndef McTemplateU0xxz_def
#define McTemplateU0xxz_def
ETW_INLINE
ULONG
McTemplateU0xxz(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_ unsigned __int64  _Arg1,
    _In_opt_ PCWSTR  _Arg2
    )
{
#define McTemplateU0xxz_ARGCOUNT 3

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xxz_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[3],
                        (_Arg2 != NULL) ? _Arg2 : L"NULL",
                        (_Arg2 != NULL) ? (ULONG)((wcslen(_Arg2) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xxz_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : ObjectAllocatedArgs
//
#ifndef McTemplateU0xxxx_def
#define McTemplateU0xxxx_def
ETW_INLINE
ULONG
McTemplateU0xxxx(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_ unsigned __int64  _Arg1,
    _In_ unsigned __int64  _Arg2,
    _In_ unsigned __int64  _Arg3
    )
{
#define McTemplateU0xxxx_ARGCOUNT 4

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xxxx_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[3],&_Arg2, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[4],&_Arg3, sizeof(unsigned __int64)  );

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xxxx_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : FinalizeableObjectQueuedArgs
//
#ifndef McTemplateU0xx_def
#define McTemplateU0xx_def
ETW_INLINE
ULONG
McTemplateU0xx(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_ unsigned __int64  _Arg1
    )
{
#define McTemplateU0xx_ARGCOUNT 2

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xx_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(unsigned __int64)  );

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xx_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : HandleDestroyedArgs
//
#ifndef McTemplateU0x_def
#define McTemplateU0x_def
ETW_INLINE
ULONG
McTemplateU0x(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0
    )
{
#define McTemplateU0x_ARGCOUNT 1

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0x_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0x_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : RootReferencesArgs
//
#ifndef McTemplateU0qPR0QR0QR0PR0_def
#define McTemplateU0qPR0QR0QR0PR0_def
ETW_INLINE
ULONG
McTemplateU0qPR0QR0QR0PR0(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ const unsigned int  _Arg0,
    _In_reads_(_Arg0) const void * *_Arg1,
    _In_reads_(_Arg0) const unsigned int *_Arg2,
    _In_reads_(_Arg0) const unsigned int *_Arg3,
    _In_reads_(_Arg0) const void * *_Arg4
    )
{
#define McTemplateU0qPR0QR0QR0PR0_ARGCOUNT 5

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0qPR0QR0QR0PR0_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[2], _Arg1, sizeof(PVOID)*_Arg0);

    EventDataDescCreate(&EventData[3], _Arg2, sizeof(const unsigned int)*_Arg0);

    EventDataDescCreate(&EventData[4], _Arg3, sizeof(const unsigned int)*_Arg0);

    EventDataDescCreate(&EventData[5], _Arg4, sizeof(PVOID)*_Arg0);

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0qPR0QR0QR0PR0_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : ObjectReferencesArgs
//
#ifndef McTemplateU0xxxqPR3_def
#define McTemplateU0xxxqPR3_def
ETW_INLINE
ULONG
McTemplateU0xxxqPR3(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_ unsigned __int64  _Arg1,
    _In_ unsigned __int64  _Arg2,
    _In_ const unsigned int  _Arg3,
    _In_reads_(_Arg3) const void * *_Arg4
    )
{
#define McTemplateU0xxxqPR3_ARGCOUNT 5

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xxxqPR3_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[3],&_Arg2, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[4],&_Arg3, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[5], _Arg4, sizeof(PVOID)*_Arg3);

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xxxqPR3_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : GCStartArgs
//
#ifndef McTemplateU0ddt_def
#define McTemplateU0ddt_def
ETW_INLINE
ULONG
McTemplateU0ddt(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ const signed int  _Arg0,
    _In_ const signed int  _Arg1,
    _In_ const BOOL  _Arg2
    )
{
#define McTemplateU0ddt_ARGCOUNT 3

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0ddt_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[3],&_Arg2, sizeof(const BOOL)  );

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0ddt_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : GCStopArgs
//
#ifndef McTemplateU0d_def
#define McTemplateU0d_def
ETW_INLINE
ULONG
McTemplateU0d(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ const signed int  _Arg0
    )
{
#define McTemplateU0d_ARGCOUNT 1

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0d_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(const signed int)  );

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0d_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : ObjectsMovedArgs
//
#ifndef McTemplateU0qPR0PR0QR0_def
#define McTemplateU0qPR0PR0QR0_def
ETW_INLINE
ULONG
McTemplateU0qPR0PR0QR0(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ const unsigned int  _Arg0,
    _In_reads_(_Arg0) const void * *_Arg1,
    _In_reads_(_Arg0) const void * *_Arg2,
    _In_reads_(_Arg0) const unsigned int *_Arg3
    )
{
#define McTemplateU0qPR0PR0QR0_ARGCOUNT 4

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0qPR0PR0QR0_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[2], _Arg1, sizeof(PVOID)*_Arg0);

    EventDataDescCreate(&EventData[3], _Arg2, sizeof(PVOID)*_Arg0);

    EventDataDescCreate(&EventData[4], _Arg3, sizeof(const unsigned int)*_Arg0);

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0qPR0PR0QR0_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : ObjectsSurvivedArgs
//
#ifndef McTemplateU0qPR0QR0_def
#define McTemplateU0qPR0QR0_def
ETW_INLINE
ULONG
McTemplateU0qPR0QR0(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ const unsigned int  _Arg0,
    _In_reads_(_Arg0) const void * *_Arg1,
    _In_reads_(_Arg0) const unsigned int *_Arg2
    )
{
#define McTemplateU0qPR0QR0_ARGCOUNT 3

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0qPR0QR0_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[2], _Arg1, sizeof(PVOID)*_Arg0);

    EventDataDescCreate(&EventData[3], _Arg2, sizeof(const unsigned int)*_Arg0);

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0qPR0QR0_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : (null)
//
#ifndef McTemplateU0_def
#define McTemplateU0_def
ETW_INLINE
ULONG
McTemplateU0(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor
    )
{
#define McTemplateU0_ARGCOUNT 0

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0_ARGCOUNT + 1];

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : ProfilerErrorArgs
//
#ifndef McTemplateU0xz_def
#define McTemplateU0xz_def
ETW_INLINE
ULONG
McTemplateU0xz(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_opt_ PCWSTR  _Arg1
    )
{
#define McTemplateU0xz_ARGCOUNT 2

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xz_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xz_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : SamplingRateChangeArgs
//
#ifndef McTemplateU0xzddffd_def
#define McTemplateU0xzddffd_def
ETW_INLINE
ULONG
McTemplateU0xzddffd(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_opt_ PCWSTR  _Arg1,
    _In_ const signed int  _Arg2,
    _In_ const signed int  _Arg3,
    _In_ const float  _Arg4,
    _In_ const float  _Arg5,
    _In_ const signed int  _Arg6
    )
{
#define McTemplateU0xzddffd_ARGCOUNT 7

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xzddffd_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    EventDataDescCreate(&EventData[3],&_Arg2, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[4],&_Arg3, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[5],&_Arg4, sizeof(const float)  );

    EventDataDescCreate(&EventData[6],&_Arg5, sizeof(const float)  );

    EventDataDescCreate(&EventData[7],&_Arg6, sizeof(const signed int)  );

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xzddffd_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : CallEnterArgs
//
#ifndef McTemplateU0xq_def
#define McTemplateU0xq_def
ETW_INLINE
ULONG
McTemplateU0xq(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ unsigned __int64  _Arg0,
    _In_ const unsigned int  _Arg1
    )
{
#define McTemplateU0xq_ARGCOUNT 2

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0xq_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(const unsigned int)  );

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0xq_ARGCOUNT + 1, EventData);
}
#endif

//
//Template from manifest : SendManifestArgs
//
#ifndef McTemplateU0cccchhs_def
#define McTemplateU0cccchhs_def
ETW_INLINE
ULONG
McTemplateU0cccchhs(
    _In_ PMCGEN_TRACE_CONTEXT Context,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_ const UCHAR  _Arg0,
    _In_ const UCHAR  _Arg1,
    _In_ const UCHAR  _Arg2,
    _In_ const UCHAR  _Arg3,
    _In_ const unsigned short  _Arg4,
    _In_ const unsigned short  _Arg5,
    _In_opt_ LPCSTR  _Arg6
    )
{
#define McTemplateU0cccchhs_ARGCOUNT 7

    EVENT_DATA_DESCRIPTOR EventData[McTemplateU0cccchhs_ARGCOUNT + 1];

    EventDataDescCreate(&EventData[1],&_Arg0, sizeof(const UCHAR)  );

    EventDataDescCreate(&EventData[2],&_Arg1, sizeof(const UCHAR)  );

    EventDataDescCreate(&EventData[3],&_Arg2, sizeof(const UCHAR)  );

    EventDataDescCreate(&EventData[4],&_Arg3, sizeof(const UCHAR)  );

    EventDataDescCreate(&EventData[5],&_Arg4, sizeof(const unsigned short)  );

    EventDataDescCreate(&EventData[6],&_Arg5, sizeof(const unsigned short)  );

    EventDataDescCreate(&EventData[7],
                        (_Arg6 != NULL) ? _Arg6 : "NULL",
                        (_Arg6 != NULL) ? (ULONG)((strlen(_Arg6) + 1) * sizeof(CHAR)) : (ULONG)sizeof("NULL"));

    return McGenEventWriteUM(Context, Descriptor, McTemplateU0cccchhs_ARGCOUNT + 1, EventData);
}
#endif

#endif // MCGEN_DISABLE_PROVIDER_CODE_GENERATION

#if defined(__cplusplus)
};
#endif

#define MSG_task_GC                          0x70000001L
#define MSG_task_ClassIDDefintion            0x7000000AL
#define MSG_task_ModuleIDDefintion           0x7000000BL
#define MSG_task_ObjectAllocated             0x7000000CL
#define MSG_task_FinalizeableObjectQueued    0x7000000DL
#define MSG_task_HandleCreated               0x7000000EL
#define MSG_task_HandleDestroyed             0x7000000FL
#define MSG_task_ObjectsMoved                0x70000014L
#define MSG_task_ObjectsSurvived             0x70000015L
#define MSG_task_RootReferences              0x70000016L
#define MSG_task_ObjectReferences            0x70000017L
#define MSG_task_CaptureState                0x70000018L
#define MSG_task_ProfilerError               0x7000001AL
#define MSG_task_ProfilerShutdown            0x7000001BL
#define MSG_task_SamplingRateChange          0x7000001CL
#define MSG_task_CallEnter                   0x7000001DL
#define MSG_task_SendManifest                0x7000FFFEL
#define MSG_map_GCRootKind_Stack             0xD0000001L
#define MSG_map_GCRootKind_Finalizer         0xD0000002L
#define MSG_map_GCRootKind_Handle            0xD0000003L
#define MSG_map_GCRootKind_Other             0xD0000004L
#define MSG_map_GCRootFlags_Pinning          0xF0000001L
#define MSG_map_GCRootFlags_WeakRef          0xF0000002L
#define MSG_map_GCRootFlags_Interior         0xF0000003L
#define MSG_map_GCRootFlags_RefCounted       0xF0000004L
#define MSG_map_ClassDefintionFlags_ValueType 0xF0000005L
#define MSG_map_ClassDefintionFlags_Public   0xF0000006L
#define MSG_map_ClassDefintionFlags_Finalizable 0xF0000007L
