var tl = require('azure-pipelines-task-lib/task');
var path = require('path');

function isExplicitVersion(versionSpec) {
    if(process.env["__implicit_version__"] === "true") {
        return false;
    }

    return true;
}
exports.isExplicitVersion = isExplicitVersion;

function prependPath(toolPath) {
    console.log("prepending path: " + toolPath);
}
exports.prependPath = prependPath;

function findLocalTool(toolName, versionSpec, arch) {
    console.log("Checking local tool for " + toolName + " and version " + versionSpec);
    if(process.env["__cache_hit__"] === "true") {
        return path.join(tl.getVariable('Agent.ToolsDirectory'), "oldCacheDir");
    }
    return null;
}
exports.findLocalTool = findLocalTool;

function downloadTool(url, fileName) {
    if( process.env["__primary_url_failed__"] === "true" && url === "https://primary-url") {
        throw "404 not found " + url;
    }

    console.log("Downloading tool from " + url);
    return path.join(tl.getVariable('Agent.TempDirectory'), "someArchieve");
}
exports.downloadTool = downloadTool;

function extractZip(file) {
    if( process.env["__extract_failed__"] === "true") {
        throw "unzip failed with some error";
    }

    console.log("Extracting zip archieve from " + file);
    return path.join(tl.getVariable('Agent.TempDirectory'), "someDir");
}
exports.extractZip = extractZip;

function extractTar(file) {
    console.log("Extracting tar archieve from " + file);
    return path.join(tl.getVariable('Agent.TempDirectory'), "someDir");
}
exports.extractTar = extractTar;

function cacheDir(sourceDir, tool, version, arch) {
    console.log("Caching dir " + sourceDir + " for tool " + tool + " version " + version);
    return path.join(tl.getVariable('Agent.ToolsDirectory'), "cacheDir");
}
exports.cacheDir = cacheDir;
