'use strict';
var util = require('util');
function VirtualMachineExtensions(client) {
    this.client = client;
}

VirtualMachineExtensions.prototype.list = (resourceGroupName, resourceName, resourceType, options, callback) => {
    console.log("virtualMachineExtensions.list is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }

    if(process.env["extensionListFailed"] === "true") {
        return callback("some error", []);
    }

    var result = [];
    var ext1 = {
        name: "CustomScriptExtension1",
        properties: {
            type: "CustomScriptExtension",
            publisher: "Microsoft.Compute",
            typeHandlerVersion: "1.5",
            autoUpgradeMinorVersion: true,
            settings: {
                "fileUris": [ "some-file.ps1" ]
            }
        }
    };

    var ext2 = {
        name: "Extension2",
        properties: {
            type: "SomeExtension",
            publisher: "Microsoft.Test",
            typeHandlerVersion: "1.8",
            autoUpgradeMinorVersion: true,
            settings: {
                "fileUris": [ "some-file.ps1" ]
            }
        }
    }

    result.push(ext1);
    result.push(ext2);

    if(process.env["noExistingExtension"] === "true") {
        result = [ext2];
    }

    if(!!(process.env["existingExtensionName"])) {
        ext1.name = process.env["existingExtensionName"];
    }
    
    return callback(null, result);
};
VirtualMachineExtensions.prototype.get = (resourceGroupName, vmName, extensionName, options, callback) => {
    console.log("virtualMachineExtensions.get is called on vm %s", vmName);

    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var expand = (options && options.expand !== undefined) ? options.expand : undefined;
    var apiVersion = '2016-03-30';

    var fileUris = [
        "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/201-vm-winrm-windows/ConfigureWinRM.ps1",
        "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/201-vm-winrm-windows/makecert.exe",
        "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/201-vm-winrm-windows/winrmconf.cmd"];
    var result = {
        properties: {
            "settings":
            {
                "fileUris": fileUris
            },
            "provisioningState": "Succeeded"
        }
    };
    if (resourceGroupName.includes("ExtensionNotPresent")) {
        return callback("Not found", null);
    }
    else if (resourceGroupName.includes("ExtensionPresent")) {
        if (resourceGroupName.includes("ProvisioningStateIsNotSucceeded")) {
            result["properties"]["provisioningState"] = "Failed";
        }
        if (resourceGroupName.includes("WinRMHttpsListenerNotEnabled")) {
            result["properties"]["settings"]["fileUris"] = ["https://something.com/something.ps1"];
        }
    }
    return callback(null, result);
};
VirtualMachineExtensions.prototype.createOrUpdate = (resourceGroupName, resourceName, resourceType, vmExtensionName, extensionParameters, callback) => {
    console.log("virtualMachineExtensions.createOrUpdate is called with resource %s and extension %s", resourceName, vmExtensionName);
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }

    console.log("custom script: " + extensionParameters.properties.settings.fileUris[0]);
    console.log("custom script: " + extensionParameters.properties.settings.fileUris[1]);

    var result = {
        properties: {
            "provisioningState": "Succeeded"
        }
    };
    if(process.env["extensionInstallFailed"] === "true") {
        return callback("some error occurred while creating extension");
    }
    return callback(null, result);
};
VirtualMachineExtensions.prototype.deleteMethod = (resourceGroupName, resourceName, resourceType, vmExtensionName, callback) => {
    console.log("virtualMachineExtensions.deleteMethod is called with resource %s and extension %s", resourceName, vmExtensionName);
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }

    if(process.env["extensionDeleteFailed"] === "true") {
        return callback("some error in removing extension");
    }

    console.log("Successfully removed the extension %s from the resource %s", vmExtensionName, resourceName);
    return callback(null, "Successfully removed the extension");
};
module.exports = VirtualMachineExtensions;
