/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

/* jshint latedef:false */
/* jshint forin:false */
/* jshint noempty:false */

'use strict';

var util = require('util');

var operations = require('./operations');

function ComputeManagementClient(credentials, subscriptionId, baseUri, options) {
  this.acceptLanguage = 'en-US';
  this.longRunningOperationRetryTimeout = 30;
  this.generateClientRequestId = true;
  if (credentials === null || credentials === undefined) {
    throw new Error('\'credentials\' cannot be null.');
  }
  if (subscriptionId === null || subscriptionId === undefined) {
    throw new Error('\'subscriptionId\' cannot be null.');
  }

  if (!options) options = {};

  this.baseUri = baseUri;
  if (!this.baseUri) {
    this.baseUri = 'https://management.azure.com';
  }
  this.credentials = credentials;
  this.subscriptionId = subscriptionId;

  if (options.acceptLanguage !== null && options.acceptLanguage !== undefined) {
    this.acceptLanguage = options.acceptLanguage;
  }
  if (options.longRunningOperationRetryTimeout !== null && options.longRunningOperationRetryTimeout !== undefined) {
    this.longRunningOperationRetryTimeout = options.longRunningOperationRetryTimeout;
  }
  if (options.generateClientRequestId !== null && options.generateClientRequestId !== undefined) {
    this.generateClientRequestId = options.generateClientRequestId;
  }
  this.virtualMachines = new operations.VirtualMachines(this);
  this.virtualMachineExtensions = new operations.VirtualMachineExtensions(this);
  this.virtualMachineScaleSets = new operations.VirtualMachineScaleSets(this);
}

module.exports.ComputeManagementClient = ComputeManagementClient;
