'use strict';

var util = require('util');

function StorageManagementClient(credentials, subscriptionId, baseUri, options) {
  this.acceptLanguage = 'en-US';
  this.longRunningOperationRetryTimeout = 30;
  this.generateClientRequestId = true;
  if (credentials === null || credentials === undefined) {
    throw new Error('\'credentials\' cannot be null.');
  }
  if (subscriptionId === null || subscriptionId === undefined) {
    throw new Error('\'subscriptionId\' cannot be null.');
  }

  if (!options) options = {};

  this.baseUri = baseUri;
  if (!this.baseUri) {
    this.baseUri = 'https://management.azure.com';
  }
  this.credentials = credentials;
  this.subscriptionId = subscriptionId;

  if (options.acceptLanguage !== null && options.acceptLanguage !== undefined) {
    this.acceptLanguage = options.acceptLanguage;
  }
  if (options.longRunningOperationRetryTimeout !== null && options.longRunningOperationRetryTimeout !== undefined) {
    this.longRunningOperationRetryTimeout = options.longRunningOperationRetryTimeout;
  }
  if (options.generateClientRequestId !== null && options.generateClientRequestId !== undefined) {
    this.generateClientRequestId = options.generateClientRequestId;
  }
  this.storageAccounts = new StorageAccounts(this);
}

module.exports.StorageManagementClient = StorageManagementClient;

function StorageAccounts(client) {
  this.client = client;
}

StorageAccounts.prototype.list = function (options) {
  console.log("storageAccounts.list is called");

  if (process.env["storageAccountsListFailed"] === "true") {
    return Promise.reject("Failed to fetch list of storage account");
  }

  var result = [];
  if (!(process.env["noMatchingStorageAccount"] === "true")) {
    var storage1 = {
      "id": "/subscriptions/id/resourceGroups/storagerg1/providers/Microsoft.Storage/storageAccounts/teststorage1",
      "kind": "Storage",
      "location": "eastus",
      "name": "teststorage1",
      "properties": {
        "primaryEndpoints": {
          "blob": "teststorage1.blob.core.windows.net/"
        }
      },
      "sku": {
        "name": "Standard_LRS",
        "tier": "Standard"
      },
      "type": "Microsoft.Storage/storageAccounts"
    };

    var storage2 = {
      "id": "/subscriptions/id/resourceGroups/storagerg2/providers/Microsoft.Storage/storageAccounts/teststorage2",
      "kind": "Storage",
      "location": "eastus",
      "name": "teststorage2",
      "properties": {
        "primaryEndpoints": {
          "blob": "teststorage2.blob.core.windows.net/"
        }
      },
      "sku": {
        "name": "Standard_LRS",
        "tier": "Standard"
      },
      "type": "Microsoft.Storage/storageAccounts"
    };

    result.push(storage1);
    result.push(storage2);
  }

  console.log("Storage List:");
  console.log(util.inspect(result, { depth: null }));
  return Promise.resolve(result);
}

StorageAccounts.prototype.listKeys = function (resourceGroupName, accountName, options) {
  console.log("storageAccounts.listKeys is called");

  if(process.env["_listAccessKeysFailed_"] === "true") {
    throw "You need permission to list keys";
  }

  return Promise.resolve(["key1", "key2"]);
}

StorageAccounts.prototype.get = function (storageAccountName) {
  var storage1 = {
    "id": "/subscriptions/id/resourceGroups/storagerg1/providers/Microsoft.Storage/storageAccounts/teststorage1",
    "kind": "Storage",
    "location": "eastus",
    "name": "teststorage1",
    "properties": {
      "primaryEndpoints": {
        "blob": "teststorage1.blob.core.windows.net/"
      }
    },
    "sku": {
      "name": "Standard_LRS",
      "tier": "Standard"
    },
    "type": "Microsoft.Storage/storageAccounts"
  };

  return storage1;
}

exports.StorageAccounts = StorageAccounts;