'use strict';

var util = require('util');

function VirtualMachineScaleSets(client) {
    this.client = client;
}

VirtualMachineScaleSets.prototype.list = function (options, callback) {
    console.log("virtualMachineScaleSets.list is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var apiVersion = '2016-03-30';
    // Validate
    try {
        if (this.client.subscriptionId === null || this.client.subscriptionId === undefined || typeof this.client.subscriptionId.valueOf() !== 'string') {
            throw new Error('this.client.subscriptionId cannot be null or undefined and it must be of type string.');
        }
    } catch (error) {
        return callback(error);
    }

    if(process.env["vmssListFailed"] === "true") {
        return callback("some error");
    }

    var result = [];
    if (!this.client.subscriptionId.includes("noVMSSs")) {
        var vmss1 = {
            "properties": {
                "virtualMachineProfile": {
                "storageProfile": {
                    "osDisk": {
                    "osType": "Windows",
                    "name": "bpdwinvmsosdisk",
                    "createOption": "FromImage",
                    "image": {
                        "uri": "http://old-url"
                    },
                    "caching": "ReadOnly"
                    }
                }
                },
            },
            "id": "/subscriptions/c00456c7-6c1f-4c03-9be1-6934a4c49682/resourceGroups/testrg1/providers/Microsoft.Compute/virtualMachineScaleSets/testvmss1",
            "name": "testvmss1"
        };

        var vmss2 = {
            "properties": {
                "virtualMachineProfile": {
                "storageProfile": {
                    "osDisk": {
                    "osType": "Linux",
                    "name": "bpdwinvmsosdisk",
                    "createOption": "FromImage",
                    "image": {
                        "uri": "https://bishpackrimaes.blob.core.windows.net/system/Microsoft.Compute/Images/vsts-buildimagetask/Release-1-osDisk.cf2fbaaf-9c90-453d-9dc0-eeb90ef4c7e2.vhd"
                    },
                    "caching": "ReadOnly"
                    }
                }
                },
            },
            "id": "/subscriptions/c00456c7-6c1f-4c03-9be1-6934a4c49682/resourceGroups/testrg2/providers/Microsoft.Compute/virtualMachineScaleSets/testvmss2",
            "name": "testvmss2"
        };

        result.push(vmss1);
        result.push(vmss2);
    }

    console.log("VMSS List:");
    console.log(util.inspect(result, { depth: null }));
    return callback(null, result);
};

VirtualMachineScaleSets.prototype.get = (resourceGroupName, vmssName, options, callback) => {
    console.log("virtualMachinesScaleSets.get is called with options: %s", util.inspect(options, { depth: null }));
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var expand = (options && options.expand !== undefined) ? options.expand : undefined;
    var apiVersion = '2016-03-30';
    var vmss1 = {
            "properties": {
                "virtualMachineProfile": {
                "storageProfile": {
                    "osDisk": {
                    "osType": "Windows",
                    "name": "bpdwinvmsosdisk",
                    "createOption": "FromImage",
                    "image": {
                        "uri": "http://old-url"
                    },
                    "caching": "ReadOnly"
                    }
                }
                },
            },
            "id": "/subscriptions/c00456c7-6c1f-4c03-9be1-6934a4c49682/resourceGroups/testrg1/providers/Microsoft.Compute/virtualMachineScaleSets/testvmss1",
            "name": "testvmss1"
        };
    return callback(null, vmss1);
};

VirtualMachineScaleSets.prototype.get = (resourceGroupName, vmssName, options, callback) => {
    console.log("virtualMachinesScaleSets.get is called with options: %s", util.inspect(options, { depth: null }));
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var expand = (options && options.expand !== undefined) ? options.expand : undefined;
    var apiVersion = '2016-03-30';
    var vmss1 = {
            "properties": {
                "virtualMachineProfile": {
                "storageProfile": {
                    "osDisk": {
                    "osType": "Windows",
                    "name": "bpdwinvmsosdisk",
                    "createOption": "FromImage",
                    "image": {
                        "uri": "https://bishpackrimages.blob.core.windows.net/system/Microsoft.Compute/Images/vsts-buildimagetask/Release-1-osDisk.cf2fbaaf-9c90-453d-9dc0-eeb90ef4c7e2.vhd"
                    },
                    "caching": "ReadOnly"
                    }
                }
                },
            },
            "id": "/subscriptions/c00456c7-6c1f-4c03-9be1-6934a4c49682/resourceGroups/testrg1/providers/Microsoft.Compute/virtualMachineScaleSets/testvmss1",
            "name": "testvmss1"
        };
    return callback(null, vmss1);
};

VirtualMachineScaleSets.prototype.updateImage = (resourceGroupName, vmssName, imageUrl, options, callback) => {
    console.log("virtualMachinesScaleSets.updateImage is called with options: %s", util.inspect(options, { depth: null }));
    console.log("virtualMachinesScaleSets.updateImage is called with RG: %s, VMSS: %s and imageurl : %s", resourceGroupName, vmssName, imageUrl);
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }

    if (imageUrl === null || imageUrl === undefined || typeof imageUrl.valueOf() !== 'string') {
        throw new Error("Image url must be a non empty string");
    }

    var expand = (options && options.expand !== undefined) ? options.expand : undefined;
    var apiVersion = '2016-03-30';

    if(process.env["imageUrlAlreadyUptoDate"] === "true") {
        console.log("VMSSImageAlreadyUptoDate", vmssName);
        return callback(null, null);
    }

    if(process.env["imageUpdateFailed"] === "true") {
        return callback("some error");
    }

    return callback(null, null);
};

module.exports = VirtualMachineScaleSets;