'use strict';
var util = require('util');
function VirtualMachineExtensions(client) {
    this.client = client;
}
VirtualMachineExtensions.prototype.list = (resourceGroupName, resourceName, resourceType, options, callback) => {
    console.log("virtualMachineExtensions.list is called");
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error(tl.loc("CallbackCannotBeNull"));
    }

    var result = [];
    if (resourceGroupName.includes("ExtensionNotPresent")) {
        return callback(null, result);
    }
    var extension = {
        properties: {
            publisher: "Microsoft.Compute",
            type: "CustomScriptExtension",
            typeHandlerVersion: "1.7",
            autoUpgradeMinorVersion: false,
            settings: {
                fileUris: [
                    "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/501dc7d24537e820df7c80bce51aba9674233b2b/201-vm-winrm-windows/ConfigureWinRM.ps1",
                    "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/501dc7d24537e820df7c80bce51aba9674233b2b/201-vm-winrm-windows/makecert.exe"
                ],
                commandToExecute: "powershell.exe -ExecutionPolicy RemoteSigned -File ConfigureWinRM.ps1 aydeydns2016ns.eastasia.cloudapp.azure.com"
            },
            provisioningState: "Succeeded"
        },
        type: "Microsoft.Compute/virtualMachines/extensions",
        location: "eastasia",
        name: "WinRMCustomScriptExtension"
    };

    if (resourceGroupName.includes("ProvisioningStateIsNotSucceeded")) {
        extension["properties"]["provisioningState"] = "Failed";
    }
    if (resourceGroupName.includes("WinRMHttpsListenerNotEnabled")) {
        extension["properties"]["settings"]["fileUris"] = ["https://something.com/something.ps1"];
    }
    if(resourceGroupName.includes("SomeOtherCustomScriptExtensionPresent")){
        extension["name"] = "SomeCustomScriptExtension";
    }
    result = [extension];
    return callback(null, result);
}

VirtualMachineExtensions.prototype.get = (resourceGroupName, vmName, resourceType, extensionName, options, callback) => {
    console.log("virtualMachineExtensions.get is called on vm %s", vmName);

    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var expand = (options && options.expand !== undefined) ? options.expand : undefined;
    var apiVersion = '2016-03-30';

    var fileUris = [
        "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/501dc7d24537e820df7c80bce51aba9674233b2b/201-vm-winrm-windows/ConfigureWinRM.ps1",
        "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/501dc7d24537e820df7c80bce51aba9674233b2b/201-vm-winrm-windows/makecert.exe"];
    var result = {
        properties: {
            "settings":
            {
                "fileUris": fileUris
            },
            "provisioningState": "Succeeded"
        }
    };
    if (resourceGroupName.includes("ExtensionNotPresent")) {
        return callback("Not found", null);
    }
    else if (resourceGroupName.includes("ExtensionPresent")) {
        if (resourceGroupName.includes("ProvisioningStateIsNotSucceeded")) {
            result["properties"]["provisioningState"] = "Failed";
        }
        if (resourceGroupName.includes("WinRMHttpsListenerNotEnabled")) {
            result["properties"]["settings"]["fileUris"] = ["https://something.com/something.ps1"];
        }
    }
    return callback(null, result);
};
VirtualMachineExtensions.prototype.createOrUpdate = (resourceGroupName, vmName, resourcetype, extensionName, parameters, options, callback) => {
    console.log("virtualMachineExtensions.createOrUpdate is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }

    console.log("virtualMachineExtensions.createOrUpdate is called");
    var result = {
        properties: {
            "provisioningState": "Succeeded"
        }
    };
    if (resourceGroupName.includes("ProvisioningOfExtensionFailed")) {
        result["properties"]["provisioningState"] = "Failed";
    }
    if (resourceGroupName.includes("ProvisioningOfDeploymentGroupExtensionFailed")) {
        result["properties"]["provisioningState"] = "Failed";
        return callback(result)
    }
    if (resourceGroupName.includes("IncorrectPat")) {
        result["properties"]["provisioningState"] = "Failed";
        return callback(result)
    }
    return callback(null, result);
};
VirtualMachineExtensions.prototype.deleteMethod = (resourceGroupName, vmName, resourcetype, extensionName, callback) => {
    console.log("virtualMachineExtensions.deleteMethod is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    if (resourceGroupName.includes("StoppedVM")) {
        return callback("Could not delete extension from stopped vm");
    }
    console.log("Successfully removed the extension from the vm %s", vmName);
    return callback(null, "Successfully removed the extension");
};
module.exports = VirtualMachineExtensions;
