/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * 
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

'use strict';

var util = require('util');

/**
 * @class
 * PublicIPAddresses
 * __NOTE__: An instance of this class is automatically created for an
 * instance of the NetworkManagementClient.
 * Initializes a new instance of the PublicIPAddresses class.
 * @constructor
 *
 * @param {NetworkManagementClient} client Reference to the service client.
 */
function PublicIPAddresses(client) {
  this.client = client;
}

PublicIPAddresses.prototype.list = function (resourceGroupName, options, callback) {
  console.log("publicIPAddresses.list is called");
  var client = this.client;
  if (!callback && typeof options === 'function') {
    callback = options;
    options = null;
  }
  if (!callback) {
    throw new Error('callback cannot be null.');
  }
  // Validate
  try {
    if (resourceGroupName === null || resourceGroupName === undefined || typeof resourceGroupName.valueOf() !== 'string') {
      throw new Error('resourceGroupName cannot be null or undefined and it must be of type string.');
    }
    if (this.client.apiVersion === null || this.client.apiVersion === undefined || typeof this.client.apiVersion.valueOf() !== 'string') {
      throw new Error('this.client.apiVersion cannot be null or undefined and it must be of type string.');
    }
    if (this.client.subscriptionId === null || this.client.subscriptionId === undefined || typeof this.client.subscriptionId.valueOf() !== 'string') {
      throw new Error('this.client.subscriptionId cannot be null or undefined and it must be of type string.');
    }
    if (this.client.acceptLanguage !== null && this.client.acceptLanguage !== undefined && typeof this.client.acceptLanguage.valueOf() !== 'string') {
      throw new Error('this.client.acceptLanguage must be of type string.');
    }
  } catch (error) {
    return callback(error);
  }

  var PublicIPAddress = {
    id: "pId",
    properties: { ipAddress: "0.0.0.0" }
  }
  if (resourceGroupName.includes("InboundNatRules")) {
    PublicIPAddress = {
      id: "1",
      properties: { ipAddress: "0.0.0.0" }
    }
  }
  return callback(null, [PublicIPAddress]);
};

module.exports = PublicIPAddresses;
