'use strict';

var util = require('util');

var operations = require('./operations');

function NetworkManagementClient(credentials, subscriptionId, baseUri, options) {
  this.apiVersion = '2016-09-01';
  this.acceptLanguage = 'en-US';
  this.longRunningOperationRetryTimeout = 30;
  this.generateClientRequestId = true;
  if (credentials === null || credentials === undefined) {
    throw new Error('\'credentials\' cannot be null.');
  }
  if (subscriptionId === null || subscriptionId === undefined) {
    throw new Error('\'subscriptionId\' cannot be null.');
  }

  if (!options) options = {};

  this.baseUri = baseUri;
  if (!this.baseUri) {
    this.baseUri = 'https://management.azure.com';
  }
  this.credentials = credentials;
  this.subscriptionId = subscriptionId;

  if(options.apiVersion !== null && options.apiVersion !== undefined) { 
    this.apiVersion = options.apiVersion;
  }
  if(options.acceptLanguage !== null && options.acceptLanguage !== undefined) { 
    this.acceptLanguage = options.acceptLanguage;
  }
  if(options.longRunningOperationRetryTimeout !== null && options.longRunningOperationRetryTimeout !== undefined) { 
    this.longRunningOperationRetryTimeout = options.longRunningOperationRetryTimeout;
  }
  if(options.generateClientRequestId !== null && options.generateClientRequestId !== undefined) { 
    this.generateClientRequestId = options.generateClientRequestId;
  }
  this.networkInterfaces = new operations.NetworkInterfaces(this);
  this.publicIPAddresses = new operations.PublicIPAddresses(this);
  this.loadBalancers = new operations.LoadBalancers(this);
  this.networkSecurityGroups = new operations.NetworkSecurityGroups(this);
  this.securityRules = new operations.SecurityRules(this);
}

module.exports.NetworkManagementClient = NetworkManagementClient;
