'use strict';

class KeyVaultClient {
    private credentials;
    private subscriptionId;
    private keyVaultName;
    private keyVaultUrl;

    constructor(credentials, subscriptionId, keyVaultName, keyVaultUrl) {
        this.credentials = credentials;
        this.subscriptionId = subscriptionId;
        this.keyVaultName = keyVaultName;
        this.keyVaultUrl = keyVaultUrl;
    }

    getSecrets = function (nextLink, callback) {
        console.log("keyVaultClient.getSecrets is called");
        if (!callback) {
        throw new Error('callback cannot be null.');
        }
        // Validate
        try {
        if (this.keyVaultName === null || this.keyVaultName === undefined || typeof this.keyVaultName.valueOf() !== 'string') {
            throw new Error('keyVaultName cannot be null or undefined and it must be of type string.');
        }
        if (this.keyVaultUrl === null || this.keyVaultUrl === undefined || typeof this.keyVaultUrl.valueOf() !== 'string') {
            throw new Error('keyVaultUrl cannot be null or undefined and it must be of type string.');
        }
        } catch (error) {
        callback(error);
        }
    
        let secrets = [
                        {
                            name: "secret1",
                            enabled: true,
                            expires: null,
                            contentType: "secret"
                        },
                        {
                            name: "secret2",
                            enabled: true,
                            expires: null,
                            contentType: "secret"
                        },
                        {
                            name: "secret3",
                            enabled: true,
                            expires: null,
                            contentType: "certificate"
                        },
                        {
                            name: "secret4",
                            enabled: false,
                            expires: null,
                            contentType: "certificate"
                        }
                    ];
        callback(null, secrets);
    };
  
    getSecretValue = function (secretName, callback) {
        console.log("getSecretValue is called for " + secretName);
    
        if (!callback) {
        throw new Error('callback cannot be null.');
        }
        if (secretName === null || secretName === undefined || typeof secretName.valueOf() !== 'string') {
        throw new Error('secretName cannot be null or undefined and it must be of type string.');
        }
    
        callback(null, secretName + "-value");
    };
}

exports.KeyVaultClient = KeyVaultClient;