'use strict';

class GraphManagementClient {
    constructor(credentials, subscriptionId, baseUri, options) {
        this.credentials = credentials;
        this.apiVersion = '1.6';
        this.acceptLanguage = 'en-US';
        this.generateClientRequestId = true;
        if (!options)
            options = {};
        if (baseUri) {
            this.baseUri = baseUri;
        }
        if (options.acceptLanguage) {
            this.acceptLanguage = options.acceptLanguage;
        }
        if (options.longRunningOperationRetryTimeout) {
            this.longRunningOperationRetryTimeout = options.longRunningOperationRetryTimeout;
        }
        if (options.generateClientRequestId) {
            this.generateClientRequestId = options.generateClientRequestId;
        }
        this.servicePrincipals = new ServicePrincipals(this);
    }

    getCredentials() {
        return this.credentials;
    }
}
exports.GraphManagementClient = GraphManagementClient;
class ServicePrincipals {
    constructor(graphClient) {
        this.client = graphClient;
    }
    GetServicePrincipal(options) {
        return {
            "objectId": "oId"
        }
    }
}
exports.ServicePrincipals = ServicePrincipals;
