import ma = require('azure-pipelines-task-lib/mock-answer');
import tmrm = require('azure-pipelines-task-lib/mock-run');
import path = require('path');
import util = require('../NugetMockHelper');

let taskPath = path.join(__dirname, '../..', 'nugetcommandmain.js');
let tmr: tmrm.TaskMockRunner = new tmrm.TaskMockRunner(taskPath);
let nmh: util.NugetMockHelper = new util.NugetMockHelper(tmr);

nmh.setNugetVersionInputDefault();
tmr.setInput('command', 'custom');
tmr.setInput('arguments', 'these are my arguments');

let a: ma.TaskLibAnswers = <ma.TaskLibAnswers>{
    "osType": {},
    "checkPath": {},
    "which": {},
    "exec": {
        "c:\\from\\tool\\installer\\nuget.exe these are my arguments -NonInteractive": {
            "code": 1,
            "stdout": "",
            "stderr": "stderr output is here"
        }
    },
    "exist": {},
    "stats": {}
};
nmh.setAnswers(a);

nmh.registerNugetUtilityMock(["<empty>"]);
nmh.registerDefaultNugetVersionMock();
nmh.registerToolRunnerMock();
nmh.registerNugetConfigMock();

tmr.run();
