import * as path from "path";

import { TaskLibAnswers } from "azure-pipelines-task-lib/mock-answer";
import { TaskMockRunner } from "azure-pipelines-task-lib/mock-run";

import { getTempDir, initializeTest, MavenTaskInputs, setInputs } from "./TestUtils";

const taskPath = path.join(__dirname, "..", "maventask.js");

const taskRunner = new TaskMockRunner(taskPath);

// Common initial setup
initializeTest(taskRunner);

const optionsWithEscaping = `-DoptWithEscaping="{\\\"serverUri\\\": \\\"http://elasticsearch:9200\\\",\\\"username\\\": \\\"elastic\\\", \\\"password\\\": \\\"changeme\\\", \\\"connectionTimeout\\\": 30000}"`;
const optionsWithoutEscaping = `-DoptWithEscaping={\"serverUri\": \"http://elasticsearch:9200\",\"username\": \"elastic\", \"password\": \"changeme\", \"connectionTimeout\": 30000}`;
// Set Inputs
const inputs: MavenTaskInputs = {
    mavenVersionSelection: "Default",
    mavenPOMFile: "pom.xml",
    options: optionsWithEscaping,
    goals: "package",
    javaHomeSelection: "JDKVersion",
    jdkVersion: "default",
    publishJUnitResults: true,
    testResultsFiles: "**/TEST-*.xml",
    mavenOpts: "-Xmx2048m",
    checkstyleAnalysisEnabled: false,
    pmdAnalysisEnabled: false,
    findbugsAnalysisEnabled: false,
    mavenFeedAuthenticate: true
};
setInputs(taskRunner, inputs);

// Set up environment variables (task-lib does not support mocking getVariable)
// Env vars in the mock framework must replace '.' with '_'
delete process.env['M2_HOME'] // Remove in case process running this test has it already set

// Provide answers for task mock
const answers: TaskLibAnswers = {
    which: {
        mvn: "/home/bin/maven/bin/mvn"
    },
    checkPath: {
        "/home/bin/maven/bin/mvn": true,
        "pom.xml": true
    },
    exec: {
        "/home/bin/maven/bin/mvn -version": {
            code: 0,
            stdout: "Maven version 1.0.0"
        },
        
        [`/home/bin/maven/bin/mvn -f pom.xml help:effective-pom ${optionsWithoutEscaping}`]: {
            code: 0,
            stdout:
            "Effective POMs, after inheritance, interpolation, and profiles are applied:\r\n \r\n <!-- ====================================================================== -->\r\n <!--                                                                        -->\r\n <!-- Generated by Maven Help Plugin on 2017-06-28T04:25:34                  -->\r\n <!-- See: http:\/\/maven.apache.org\/plugins\/maven-help-plugin\/                -->\r\n <!--                                                                        -->\r\n <!-- ====================================================================== -->\r\n \r\n <!-- ====================================================================== -->\r\n <!--                                                                        -->\r\n <!-- Effective POM for project                                              -->\r\n <!-- 'com.microsoft.xplatalm:xplatalmApp:jar:1.0-SNAPSHOT'                  -->\r\n <!--                                                                        -->\r\n <!-- ====================================================================== -->\r\n \r\n <project xmlns=\"http:\/\/maven.apache.org\/POM\/4.0.0\" xmlns:xsi=\"http:\/\/www.w3.org\/2001\/XMLSchema-instance\" xsi:schemaLocation=\"http:\/\/maven.apache.org\/POM\/4.0.0 http:\/\/maven.apache.org\/xsd\/maven-4.0.0.xsd\">\r\n   <modelVersion>4.0.0<\/modelVersion>\r\n   <groupId>com.microsoft.xplatalm<\/groupId>\r\n   <artifactId>xplatalmApp<\/artifactId>\r\n   <version>1.0-SNAPSHOT<\/version>\r\n   <name>xplatalmApp<\/name>\r\n   <url>http:\/\/maven.apache.org<\/url>\r\n   <properties>\r\n     <project.build.sourceEncoding>UTF-8<\/project.build.sourceEncoding>\r\n   <\/properties>\r\n   <dependencies>\r\n     <dependency>\r\n       <groupId>junit<\/groupId>\r\n       <artifactId>junit<\/artifactId>\r\n       <version>3.8.1<\/version>\r\n       <scope>test<\/scope>\r\n     <\/dependency>\r\n     <dependency>\r\n       <groupId>com.microsoft.xplatalm<\/groupId>\r\n       <artifactId>xplatalmUtil<\/artifactId>\r\n       <version>1.0-SNAPSHOT<\/version>\r\n       <scope>compile<\/scope>\r\n     <\/dependency>\r\n     <dependency>\r\n       <groupId>com.google.code.findbugs<\/groupId>\r\n       <artifactId>findbugs<\/artifactId>\r\n       <version>3.0.0<\/version>\r\n       <scope>compile<\/scope>\r\n     <\/dependency>\r\n   <\/dependencies>\r\n   <repositories>\r\n     <repository>\r\n       <releases>\r\n         <enabled>true<\/enabled>\r\n       <\/releases>\r\n       <snapshots>\r\n         <enabled>true<\/enabled>\r\n       <\/snapshots>\r\n       <id>xplatalm-visualstudio.com-xplatmaven<\/id>\r\n       <url>https:\/\/xplatalm.visualstudio.com\/_packaging\/XPlatMaven\/maven\/v1<\/url>\r\n     <\/repository>\r\n     <repository>\r\n       <snapshots>\r\n         <enabled>false<\/enabled>\r\n       <\/snapshots>\r\n       <id>central<\/id>\r\n       <name>Central Repository<\/name>\r\n       <url>https:\/\/repo.maven.apache.org\/maven2<\/url>\r\n     <\/repository>\r\n   <\/repositories>\r\n   <pluginRepositories>\r\n     <pluginRepository>\r\n       <releases>\r\n         <updatePolicy>never<\/updatePolicy>\r\n       <\/releases>\r\n       <snapshots>\r\n         <enabled>false<\/enabled>\r\n       <\/snapshots>\r\n       <id>central<\/id>\r\n       <name>Central Repository<\/name>\r\n       <url>https:\/\/repo.maven.apache.org\/maven2<\/url>\r\n     <\/pluginRepository>\r\n   <\/pluginRepositories>\r\n   <build>\r\n     <sourceDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\src\\main\\java<\/sourceDirectory>\r\n     <scriptSourceDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\src\\main\\scripts<\/scriptSourceDirectory>\r\n     <testSourceDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\src\\test\\java<\/testSourceDirectory>\r\n     <outputDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\target\\classes<\/outputDirectory>\r\n     <testOutputDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\target\\test-classes<\/testOutputDirectory>\r\n     <resources>\r\n       <resource>\r\n         <directory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\src\\main\\resources<\/directory>\r\n       <\/resource>\r\n     <\/resources>\r\n     <testResources>\r\n       <testResource>\r\n         <directory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\src\\test\\resources<\/directory>\r\n       <\/testResource>\r\n     <\/testResources>\r\n     <directory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\target<\/directory>\r\n     <finalName>xplatalmApp-1.0-SNAPSHOT<\/finalName>\r\n     <pluginManagement>\r\n       <plugins>\r\n         <plugin>\r\n           <artifactId>maven-antrun-plugin<\/artifactId>\r\n           <version>1.3<\/version>\r\n         <\/plugin>\r\n         <plugin>\r\n           <artifactId>maven-assembly-plugin<\/artifactId>\r\n           <version>2.2-beta-5<\/version>\r\n         <\/plugin>\r\n         <plugin>\r\n           <artifactId>maven-dependency-plugin<\/artifactId>\r\n           <version>2.8<\/version>\r\n         <\/plugin>\r\n         <plugin>\r\n           <artifactId>maven-release-plugin<\/artifactId>\r\n           <version>2.3.2<\/version>\r\n         <\/plugin>\r\n       <\/plugins>\r\n     <\/pluginManagement>\r\n     <plugins>\r\n       <plugin>\r\n         <artifactId>maven-clean-plugin<\/artifactId>\r\n         <version>2.5<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-clean<\/id>\r\n             <phase>clean<\/phase>\r\n             <goals>\r\n               <goal>clean<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n         <\/executions>\r\n       <\/plugin>\r\n       <plugin>\r\n         <artifactId>maven-resources-plugin<\/artifactId>\r\n         <version>2.6<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-testResources<\/id>\r\n             <phase>process-test-resources<\/phase>\r\n             <goals>\r\n               <goal>testResources<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n           <execution>\r\n             <id>default-resources<\/id>\r\n             <phase>process-resources<\/phase>\r\n             <goals>\r\n               <goal>resources<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n         <\/executions>\r\n       <\/plugin>\r\n       <plugin>\r\n         <artifactId>maven-jar-plugin<\/artifactId>\r\n         <version>2.4<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-jar<\/id>\r\n             <phase>package<\/phase>\r\n             <goals>\r\n               <goal>jar<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n         <\/executions>\r\n       <\/plugin>\r\n       <plugin>\r\n         <artifactId>maven-compiler-plugin<\/artifactId>\r\n         <version>3.1<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-compile<\/id>\r\n             <phase>compile<\/phase>\r\n             <goals>\r\n               <goal>compile<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n           <execution>\r\n             <id>default-testCompile<\/id>\r\n             <phase>test-compile<\/phase>\r\n             <goals>\r\n               <goal>testCompile<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n         <\/executions>\r\n       <\/plugin>\r\n       <plugin>\r\n         <artifactId>maven-surefire-plugin<\/artifactId>\r\n         <version>2.12.4<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-test<\/id>\r\n             <phase>test<\/phase>\r\n             <goals>\r\n               <goal>test<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n         <\/executions>\r\n       <\/plugin>\r\n       <plugin>\r\n         <artifactId>maven-install-plugin<\/artifactId>\r\n         <version>2.4<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-install<\/id>\r\n             <phase>install<\/phase>\r\n             <goals>\r\n               <goal>install<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n         <\/executions>\r\n       <\/plugin>\r\n       <plugin>\r\n         <artifactId>maven-deploy-plugin<\/artifactId>\r\n         <version>2.7<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-deploy<\/id>\r\n             <phase>deploy<\/phase>\r\n             <goals>\r\n               <goal>deploy<\/goal>\r\n             <\/goals>\r\n           <\/execution>\r\n         <\/executions>\r\n       <\/plugin>\r\n       <plugin>\r\n         <artifactId>maven-site-plugin<\/artifactId>\r\n         <version>3.3<\/version>\r\n         <executions>\r\n           <execution>\r\n             <id>default-site<\/id>\r\n             <phase>site<\/phase>\r\n             <goals>\r\n               <goal>site<\/goal>\r\n             <\/goals>\r\n             <configuration>\r\n               <outputDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\target\\site<\/outputDirectory>\r\n               <reportPlugins>\r\n                 <reportPlugin>\r\n                   <groupId>org.apache.maven.plugins<\/groupId>\r\n                   <artifactId>maven-project-info-reports-plugin<\/artifactId>\r\n                 <\/reportPlugin>\r\n               <\/reportPlugins>\r\n             <\/configuration>\r\n           <\/execution>\r\n           <execution>\r\n             <id>default-deploy<\/id>\r\n             <phase>site-deploy<\/phase>\r\n             <goals>\r\n               <goal>deploy<\/goal>\r\n             <\/goals>\r\n             <configuration>\r\n               <outputDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\target\\site<\/outputDirectory>\r\n               <reportPlugins>\r\n                 <reportPlugin>\r\n                   <groupId>org.apache.maven.plugins<\/groupId>\r\n                   <artifactId>maven-project-info-reports-plugin<\/artifactId>\r\n                 <\/reportPlugin>\r\n               <\/reportPlugins>\r\n             <\/configuration>\r\n           <\/execution>\r\n         <\/executions>\r\n         <configuration>\r\n           <outputDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\target\\site<\/outputDirectory>\r\n           <reportPlugins>\r\n             <reportPlugin>\r\n               <groupId>org.apache.maven.plugins<\/groupId>\r\n               <artifactId>maven-project-info-reports-plugin<\/artifactId>\r\n             <\/reportPlugin>\r\n           <\/reportPlugins>\r\n         <\/configuration>\r\n       <\/plugin>\r\n     <\/plugins>\r\n   <\/build>\r\n   <reporting>\r\n     <outputDirectory>D:\\VSTS-Agent\\_work\\12\\s\\xplatalmApp\\target\\site<\/outputDirectory>\r\n   <\/reporting>\r\n <\/project>\r\n \r\n [INFO] ------------------------------------------------------------------------\r\n [INFO] BUILD SUCCESS\r\n [INFO] ------------------------------------------------------------------------\r\n [INFO] Total time: 0.651 s\r\n [INFO] Finished at: 2017-06-28T16:25:34-04:00\r\n [INFO] Final Memory: 7M\/18M\r\n [INFO] ------------------------------------------------------------------------"
        },
        [`/home/bin/maven/bin/mvn -f pom.xml -s ${path.join(getTempDir(), "settings.xml")} ${optionsWithoutEscaping} package`]: {
            code: 0,
            stdout: "Maven package done"
        },
    },
    findMatch: {
        "**/TEST-*.xml": [
            "/user/build/fun/test-123.xml"
        ]
    },
    exist: {
        [path.join(getTempDir(), ".mavenInfo")] : true
    },
    cwd: {
        "cwd": "/home"
    }
};

taskRunner.setAnswers(answers);

// Run task
taskRunner.run();
