'use strict';

var util = require('util');

function BlobService(storageAccountName, storageAccessKey,host,useCredential,endpoint) {
  this._storageAccountName = storageAccountName;
  this._storageAccessKey = storageAccessKey;
  this._host = host;
  this._useCredential = useCredential;
  this._endpoint = endpoint;

}

BlobService.prototype.uploadBlobs = function (source, destUrlOrContainer) {
  console.log("blobService.uploadBlobs is called with source " + source + " and dest " + destUrlOrContainer);
  if (process.env["_uploadingFails_"] === "true") {
    throw "Error while uploading blobs: some error";
  }

  var uploadedUris = [];
  uploadedUris.push(this._storageAccountName + ".blob.core.windows.net/vststasks/100-12345/200/5/folder1/file1");
  uploadedUris.push(this._storageAccountName + ".blob.core.windows.net/vststasks/100-12345/200/5/folder1/folder2/file2");

  return Promise.resolve(uploadedUris);
}

module.exports.BlobService = BlobService;

