/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

'use strict';

var util = require('util');

/**
 * @class
 * ResourceGroup
 * __NOTE__: An instance of this class is automatically created for an
 * instance of the ResourceManagementClient.
 * Initializes a new instance of the ResourceGroup class.
 * @constructor
 *
 * @param {ResourceManagementClient} client Reference to the service client.
 */
function ResourceGroup(client) {
  this.client = client;
}

ResourceGroup.prototype.createOrUpdate = function (parameters, options, callback) {
  console.log("resourceGroup.createOrUpdate is called")
  var client = this.client;
  if(!callback && typeof options === 'function') {
    callback = options;
    options = null;
  }
  if (!callback) {
    throw new Error('callback cannot be null.');
  }
  // Validate
  try {
    if (client.resourceGroupName === null || client.resourceGroupName === undefined || typeof client.resourceGroupName.valueOf() !== 'string') {
      throw new Error('client.resourceGroupName cannot be null or undefined and it must be of type string.');
    }
    if (client.resourceGroupName !== null && client.resourceGroupName !== undefined) {
      if (client.resourceGroupName.length > 90)
      {
        throw new Error('"client.resourceGroupName" should satisfy the constraint - "MaxLength": 90');
      }
      if (client.resourceGroupName.length < 1)
      {
        throw new Error('"client.resourceGroupName" should satisfy the constraint - "MinLength": 1');
      }
      if (client.resourceGroupName.match(/^[-\w\._\(\)]+$/) === null)
      {
        throw new Error('"client.resourceGroupName" should satisfy the constraint - "Pattern": /^[-\w\._\(\)]+$/');
      }
    }
    if (parameters === null || parameters === undefined) {
      throw new Error('parameters cannot be null or undefined.');
    }
    if (this.client.apiVersion === null || this.client.apiVersion === undefined || typeof this.client.apiVersion.valueOf() !== 'string') {
      throw new Error('this.client.apiVersion cannot be null or undefined and it must be of type string.');
    }
    if (this.client.subscriptionId === null || this.client.subscriptionId === undefined || typeof this.client.subscriptionId.valueOf() !== 'string') {
      throw new Error('this.client.subscriptionId cannot be null or undefined and it must be of type string.');
    }
    if (this.client.acceptLanguage !== null && this.client.acceptLanguage !== undefined && typeof this.client.acceptLanguage.valueOf() !== 'string') {
      throw new Error('this.client.acceptLanguage must be of type string.');
    }
  } catch (error) {
    return callback(error);
  }
  callback(null, true);
};

ResourceGroup.prototype.deleteMethod = function (callback) {
  console.log("resourceGroup.deleteMethod is called")
  var client = this.client;

  if (!callback) {
    throw new Error('callback cannot be null.');
  }

};

ResourceGroup.prototype.checkExistence = function (callback) {
  console.log("resourceGroup.checkExistence is called")
  return callback(null, true);
}

module.exports = ResourceGroup;
