'use strict';
var util = require('util');

function NetworkInterfaces(client) {
    this.client = client;
}
NetworkInterfaces.prototype.list = (resourceGroupName, options, callback) => {
    console.log("networkInterfaces.list is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var apiVersion = '2016-03-30';
    // Validate

    var result = [];
    if (resourceGroupName.includes("OneVM")) {
        var NetworkInterface = { "id": "1", properties: { "ipConfigurations": [{ "id": "1", properties: { "publicIPAddress": { "id": "1" } } }] } };
        if (resourceGroupName.includes("InboundNatRulesPresent")) {
            if (resourceGroupName.includes("VMAttached")) {
                NetworkInterface = {
                    "id": "1",
                    "name": "1",
                    properties:
                    {
                        "ipConfigurations":
                        [
                            {
                                "id": "1",
                                properties:
                                {
                                    "publicIPAddress":
                                    {
                                        "id": "1"
                                    },
                                    loadBalancerInboundNatRules:
                                    [
                                        {
                                            "id": "1"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                };
            }
            else {
                NetworkInterface = {
                    "id": "1",
                    "name": "1",
                    properties:
                    {
                        "ipConfigurations":
                        [
                            {
                                "id": "1",
                                properties:
                                {
                                    loadBalancerInboundNatRules:
                                    [
                                        {
                                            "id": "1"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                };
            }
        }
        else {

        }
        result.push(NetworkInterface);
    }
    else if (resourceGroupName.includes("TwoVMs")) {
        var NetworkInterface1 = { "id": "1", properties: { "ipConfigurations": [{ "id": "1", properties: { "publicIPAddress": { "id": "1" } } }] } };
        var NetworkInterface2 = { "id": "2", properties: { "ipConfigurations": [{ "id": "2", properties: { "publicIPAddress": { "id": "2" } } }] } };
        if (resourceGroupName.includes("InboundNatRulesPresent")) {
            if (resourceGroupName.includes("VMsAttached")) {
                NetworkInterface1 = {
                    "id": "1",
                    "name": "1",
                    properties:
                    {
                        "ipConfigurations":
                        [
                            {
                                "id": "1",
                                properties:
                                {
                                    "publicIPAddress":
                                    {
                                        "id": "1"
                                    },
                                    loadBalancerInboundNatRules:
                                    [
                                        {
                                            "id": "1"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                };
                NetworkInterface2 = {
                    "id": "2",
                    "name": "2",
                    properties:
                    {
                        "ipConfigurations":
                        [
                            {
                                "id": "2",
                                properties:
                                {
                                    "publicIPAddress":
                                    {
                                        "id": "2"
                                    },
                                    loadBalancerInboundNatRules:
                                    [
                                        {
                                            "id": "2"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                };
            }
            else{
                NetworkInterface1 = {
                    "id": "1",
                    "name": "1",
                    properties:
                    {
                        "ipConfigurations":
                        [
                            {
                                "id": "1",
                                properties:
                                {
                                    loadBalancerInboundNatRules:
                                    [
                                        {
                                            "id": "1"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                };
                NetworkInterface2 = {
                    "id": "2",
                    "name": "2",
                    properties:
                    {
                        "ipConfigurations":
                        [
                            {
                                "id": "2",
                                properties:
                                {
                                    loadBalancerInboundNatRules:
                                    [
                                        {
                                            "id": "2"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                };
            }
        }
        result.push(NetworkInterface1);
        result.push(NetworkInterface2);
    }
    else {
        var NetworkInterface = { "id": "1", "name": "1", properties: { "ipConfigurations": [{ "id": "1", properties: { "publicIPAddress": { "id": "1" } } }] } };
        result.push(NetworkInterface);
    }
    console.log("result:");
    console.log(util.inspect(result, { depth: null }));
    return callback(null, result);
};
NetworkInterfaces.prototype.createOrUpdate = (resourceGroupName, networkInterfaceName, parameters, options, callback) => {
    console.log("networkInterfaces.createOrUpdate is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    return callback(null, "Successfully Updated NIC");
};
module.exports = NetworkInterfaces;
