/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
'use strict';
var util = require('util');

function LoadBalancers(client) {
    this.client = client;
}
LoadBalancers.prototype.list = (resourceGroupName, options, callback) => {
    console.log("loadBalancers.list is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var apiVersion = '2016-03-30';
    var result = [];
    if (resourceGroupName.includes("OneLBOneVM")) {
        var lb = {
            "name": "LB",
            "id": 1,
            properties:
            {
                "backendAddressPools":
                [
                    {
                        properties: {
                            "backendIPConfigurations":
                            [
                                {
                                    "id": "1",
                                    properties: {}
                                }
                            ]
                        }
                    }
                ],
                "frontendIPConfigurations":
                [
                    {
                        "id": "1",
                        properties: {
                            "publicIPAddress": {
                                "id": "1"
                            }
                        }
                    }
                ],
                "inboundNatRules":
                [

                ]
            }
        };
        if (resourceGroupName.includes("InboundNatRulesPresent")) {
            lb = {
                "name": "LB",
                "id": 1,
                properties:
                {
                    "backendAddressPools":
                    [
                        {
                            properties:
                            {
                                "backendIPConfigurations":
                                [
                                    {
                                        "id": "1",
                                        properties: {}
                                    }
                                ]
                            }
                        }
                    ],
                    "frontendIPConfigurations":
                    [
                        {
                            "id": "1",
                            properties: {
                                "publicIPAddress": {
                                    "id": "1"
                                }
                            }
                        }
                    ],
                    "inboundNatRules":
                    [
                        {
                            "id": "1",
                            properties:
                            {
                                "frontendPort": 5986,
                                "backendPort": 5986
                            }
                        }
                    ]
                }
            };
            if (resourceGroupName.includes("VMAttached")) {
                lb = {
                    "name": "LB",
                    "id": 1,
                    properties:
                    {
                        "backendAddressPools":
                        [
                            {
                                properties:
                                {
                                    "backendIPConfigurations":
                                    [
                                        {
                                            "id": "1",
                                            properties: {}
                                        }
                                    ]
                                }
                            }
                        ],
                        "frontendIPConfigurations":
                        [
                            {
                                "id": "1",
                                properties: {
                                    "publicIPAddress": {
                                        "id": "1"
                                    }
                                }
                            }
                        ],
                        "inboundNatRules": [
                            {
                                "id": "1",
                                properties:
                                {
                                    "frontendPort": 5986,
                                    "backendPort": 5986,
                                    "backendIPConfiguration": {
                                        "id": "1",
                                        properties: {}
                                    }
                                }
                            }
                        ]
                    }
                };
            }
        }
        result.push(lb);
    }
    else if (resourceGroupName.includes("OneLBTwoVMs")) {
        var lb = {
            "name": "LB",
            "id": 1,
            properties:
            {
                "backendAddressPools":
                [
                    {
                        properties:
                        {
                            "backendIPConfigurations":
                            [
                                {
                                    "id": "1",
                                    properties: {}
                                },
                                {
                                    "id": "2",
                                    properties: {}
                                }
                            ]
                        }
                    }
                ],
                "frontendIPConfigurations":
                [
                    {
                        "id": "1",
                        properties: {
                            "publicIPAddress": {
                                "id": "1"
                            }
                        }
                    }
                ],
                "inboundNatRules":
                [

                ]
            }
        };
        if (resourceGroupName.includes("InboundNatRulesPresent")) {
            lb = {
                "name": "LB",
                "id": 1,
                properties:
                {
                    "backendAddressPools":
                    [
                        {
                            properties: {
                                "backendIPConfigurations":
                                [
                                    {
                                        "id": "1",
                                        properties: {}
                                    },
                                    {
                                        "id": "2",
                                        properties: {}
                                    }
                                ]
                            }
                        }
                    ],
                    "frontendIPConfigurations":
                    [
                        {
                            "id": "1",
                            properties: {
                                "publicIPAddress": {
                                    "id": "1"
                                }
                            }
                        }
                    ],
                    "inboundNatRules":
                    [
                        {
                            "id": "1",
                            properties: {
                                "frontendPort": 5986,
                                "backendPort": 5986
                            }
                        },
                        {
                            "id": "2",
                            properties: {
                                "frontendPort": 5987,
                                "backendPort": 5986
                            }
                        }
                    ]
                }
            };
            if (resourceGroupName.includes("VMsAttached")) {
                lb = {
                    "name": "LB",
                    "id": 1,
                    properties:
                    {
                        "backendAddressPools":
                        [
                            {
                                properties: {
                                    "backendIPConfigurations":
                                    [
                                        {
                                            "id": "1",
                                            properties: {}
                                        },
                                        {
                                            "id": "2",
                                            properties: {}
                                        }
                                    ]
                                }
                            }
                        ],
                        "frontendIPConfigurations":
                        [
                            {
                                "id": "1",
                                properties: {
                                    "publicIPAddress": {
                                        "id": "1"
                                    }
                                }
                            }
                        ],
                        "inboundNatRules":
                        [
                            {
                                "id": "1",
                                properties: {
                                    "frontendPort": 5986,
                                    "backendPort": 5986,
                                    "backendIPConfiguration":
                                    {
                                        "id": "1",
                                        properties: {}
                                    }
                                }
                            },
                            {
                                "id": "2",
                                properties: {
                                    "frontendPort": 5987,
                                    "backendPort": 5986,
                                    "backendIPConfiguration":
                                    {
                                        "id": "2",
                                        properties: {}
                                    }
                                }
                            }
                        ]
                    }
                };
            }
        }
        result.push(lb);
    }
    console.log("Returning result from LB:");
    console.log(util.inspect(result, {depth: null}));
    return callback(null, result);
};
LoadBalancers.prototype.get = (resourceGroupName, lbName, options, callback) => {
    console.log("loadBalancers.get is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var result;
    if (resourceGroupName.includes("OneLBOneVM")) {
        var lb = {
            "id": 1,
            properties: {
                "inboundNatRules":
                [
                    {
                        properties: {
                            "backendPort": 5986,
                            "backendIPConfiguration":
                            {
                                "id": "1"
                            },
                            "frontendPort": 5986
                        }
                    }
                ],
                "frontendIPConfigurations": "127.0.0.1",
                "location": "location",
                "backendAddressPools":
                [
                    {
                        properties: {
                            "backendIPConfigurations":
                            [
                                {
                                    "id": "1"
                                }
                            ]
                        }
                    }
                ]
            }
        };
        result = lb;
    }
    else if (resourceGroupName.includes("OneLBTwoVMs")) {
        var lb = {
            "id": 1,
            properties: {
                "inboundNatRules":
                [
                    {
                        properties: {
                            "backendPort": 5986,
                            "backendIPConfiguration":
                            {
                                "id": "1"
                            },
                            "frontendPort": 5986
                        }
                    },
                    {
                        properties: {
                            "backendPort": 5986,
                            "backendIPConfiguration":
                            {
                                "id": "2"
                            },
                            "frontendPort": 5987
                        }
                    }
                ],
                "frontendIPConfigurations": "127.0.0.1",
                "location": "location",
                "backendAddressPools":
                [
                    {
                        properties: {
                            "backendIPConfigurations":
                            [
                                { "id": "1" },
                                { "id": "2" }
                            ]
                        }
                    }
                ]
            }
        };
        result = lb;
    }
    else if (resourceGroupName.includes("NoLB")) {
        return callback("Details cannot be fetched", null);
    }
    return callback(null, result);
};
LoadBalancers.prototype.createOrUpdate = (resourceGroupName, lbName, parameters, options, callback) => {
    console.log("loadBalancers.createOrUpdate is called");
    console.log("Parameters: %s", util.inspect(parameters, { depth: null }));
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }

    var inboundNatRules = [];
    var count = 1;
    for (var rule of parameters["properties"]["inboundNatRules"]) {
        console.log("Added inbound Nat Rule: %s", util.inspect(rule, { depth: null }));
        var ruleAdded = {
            id: count,
            properties: {
                "frontendPort": rule["properties"]["frontendPort"]
            }
        };
        inboundNatRules.push(ruleAdded);
        count++;
    }
    var result = {
        properties: {
            "inboundNatRules": inboundNatRules
        }
    };
    return callback(null, result);
};
module.exports = LoadBalancers;
