'use strict';

var util = require('util');

function VirtualMachines(client) {
    this.client = client;
}

VirtualMachines.prototype.list = function (resourceGroupName, options, callback) {
    console.log("virtualMachines.list is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var apiVersion = '2016-03-30';
    // Validate
    try {
        if (resourceGroupName === null || resourceGroupName === undefined || typeof resourceGroupName.valueOf() !== 'string') {
            throw new Error('resourceGroupName cannot be null or undefined and it must be of type string.');
        }
        if (this.client.subscriptionId === null || this.client.subscriptionId === undefined || typeof this.client.subscriptionId.valueOf() !== 'string') {
            throw new Error('this.client.subscriptionId cannot be null or undefined and it must be of type string.');
        }
        if (this.client.acceptLanguage !== null && this.client.acceptLanguage !== undefined && typeof this.client.acceptLanguage.valueOf() !== 'string') {
            throw new Error('this.client.acceptLanguage must be of type string.');
        }
    } catch (error) {
        return callback(error);
    }
    var result = [];
    if (!resourceGroupName.includes("noVMs")) {
        var vm = {
            name: "customVM",
            properties: {
                networkProfile: {
                    networkInterfaces: [
                        {
                            id: "1"
                        }
                    ]
                },
                "storageProfile": {
                    "osDisk": {
                        "osType": "Windows"
                    }
                }
            },
            tags: {
                a: 'b',
                c: 'd'
            }
        }

        if (resourceGroupName.includes("NonWindowsVM")) {
            console.log("herer");
            vm = {
                name: "customVM",
                properties: {
                    networkProfile: {
                        networkInterfaces: [
                            {
                                id: "1"
                            }
                        ]
                    },
                    "storageProfile": {
                        "osDisk": {
                            "osType": "Linux"
                        }
                    },
                },
                tags: {
                    a: 'b',
                    c: 'd'
                }
            };
        }
        result.push(vm);
        if (resourceGroupName.includes("2VMs")) {
            var vm2 = {
                name: "customVM",
                properties: {
                    networkProfile: {
                        networkInterfaces: [
                            {
                                id: "1"
                            }
                        ]
                    },
                    "storageProfile": {
                        "osDisk": {
                            "osType": "Windows"
                        }
                    }
                }
            }
            result.push(vm2);
        }
    }

    console.log("VM List:");
    console.log(util.inspect(result, { depth: null }));
    return callback(null, result);
};

VirtualMachines.prototype.start = function (resourceGroupName, vmName, options, callback) {
    console.log("virtualMachines.start is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }

    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    return callback(null);
}

VirtualMachines.prototype.restart = function (resourceGroupName, vmName, options, callback) {
    console.log("virtualMachines.restart is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }

    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    return callback(null);
}

VirtualMachines.prototype.powerOff = function (resourceGroupName, vmName, options, callback) {
    console.log("virtualMachines.powerOff is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }

    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    return callback(null);
}

VirtualMachines.prototype.deallocate = function (resourceGroupName, vmName, options, callback) {
    console.log("virtualMachines.deallocate is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }

    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    return callback(null);
}

VirtualMachines.prototype.deleteMethod = function (resourceGroupName, vmName, options, callback) {
    console.log("virtualMachines.deleteMethod is called");
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }

    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    return callback(null);
}

VirtualMachines.prototype.get = (resourceGroupName, vmName, options, callback) => {
    console.log("virtualMachines.get is called with options: %s", util.inspect(options, { depth: null }));
    var client = this.client;
    if (!callback && typeof options === 'function') {
        callback = options;
        options = null;
    }
    if (!callback) {
        throw new Error('callback cannot be null.');
    }
    var expand = (options && options.expand !== undefined) ? options.expand : undefined;
    var apiVersion = '2016-03-30';
    var result = {
        properties: {
            "instanceView":
            {
                "extensions": [
                    {
                        "name": "WinRMCustomScriptExtension",
                        "substatuses":
                        [
                            {
                                "message": "Valid"
                            }
                        ]
                    }
                ],
                "statuses": [
                    {
                        "code": "PowerState/running"
                    }
                ]
            }
        }
    };
    if (resourceGroupName.includes("InvalidSubstatus")) {
        result = {
            "name": "WinRMCustomScriptExtension",
            properties: {
                "instanceView":
                {
                    "extensions": [
                        {
                            "name": "WinRMCustomScriptExtension",
                            "substatuses":
                            [
                                {
                                    "code": "ComponentStatus/StdErr/failed",
                                    "message": "Failed"
                                }
                            ]
                        }
                    ]
                }
            }
        };
    }
    if (resourceGroupName.includes("StoppedVM")) {
        result = {
            "name": "WinRMCustomScriptExtension",
            properties: {
                "instanceView":
                {
                    "extensions": [
                        {
                            "name": "WinRMCustomScriptExtension",
                        }
                    ],
                    "statuses":
                    [
                        {
                            "code": "PowerState/deallocated"
                        }
                    ]
                }
            }
        };
    }
    if (resourceGroupName.includes("TransitioningVM")) {
        result = {
            "name": "WinRMCustomScriptExtension",
            properties: {
                "instanceView":
                {
                    "extensions": [
                        {
                            "name": "WinRMCustomScriptExtension",
                        }],
                    "statuses":
                    [
                        {
                            "code": "PowerState/starting"
                        }
                    ]

                }
            }
        };
    }
    return callback(null, result);
};

module.exports = VirtualMachines;