/**
 * Mock App config Client, that throws an 403 status code 
*/
import { RestError } from "@azure/core-rest-pipeline";
import { SnapshotInfo, CreateSnapshotOptions, CreateSnapshotResponse } from "@azure/app-configuration";

 class ForbiddenAppConfigurationClient {

    public async beginCreateSnapshotAndWait(snapshot: SnapshotInfo, options?: CreateSnapshotOptions): Promise<CreateSnapshotResponse>  {
      
      return Promise.reject(new RestError('', {statusCode: 403}));
    }
}

export { KnownSnapshotComposition } from "@azure/app-configuration";
exports.AppConfigurationClient = ForbiddenAppConfigurationClient;