import { SnapshotInfo, CreateSnapshotOptions, CreateSnapshotResponse } from "@azure/app-configuration";
import { RestError } from "@azure/core-rest-pipeline";

class ConflictAppConfigurationClient {
    public async beginCreateSnapshotAndWait(snapshot: SnapshotInfo, options?: CreateSnapshotOptions): Promise<CreateSnapshotResponse>  {
        return Promise.reject(new RestError("Snapshot already exists", {statusCode: 409}));
    }
} 

export { KnownSnapshotComposition } from "@azure/app-configuration";

exports.AppConfigurationClient = ConflictAppConfigurationClient;