import { SnapshotInfo, CreateSnapshotOptions, CreateSnapshotResponse } from "@azure/app-configuration";

export class AppConfigurationClient {

    public async beginCreateSnapshotAndWait(snapshot: SnapshotInfo, options?: CreateSnapshotOptions): Promise<CreateSnapshotResponse> {
        return Promise.resolve({
            name: snapshot.name,
            id: "id",
            eTag: "etag",
            lastModified: new Date(),
            contentType: "application/json",
            sizeInBytes: 1000,
            createdOn: new Date(),
            itemCount: 1,
            status: "ready",
            filters: snapshot.filters,
            retentionPeriodInSeconds: snapshot.retentionPeriodInSeconds
        });
    }
}
 
export { KnownSnapshotComposition } from "@azure/app-configuration";