import { ListConfigurationSettingsOptions, ConfigurationSetting } from "@azure/app-configuration";
import { RestError } from "@azure/core-rest-pipeline";

class ForbiddenAppConfigurationClient {

    public listConfigurationSettings(options?: ListConfigurationSettingsOptions) {

        // Polyfill Symbol.asyncIterator,Since the property is readonly, only assign it when it doesn't exist:
        if (typeof (Symbol as any).asyncIterator === 'undefined') {
            (Symbol as any).asyncIterator = Symbol.asyncIterator || Symbol('asyncIterator');
        }
        const iter = this.getListConfigurationSettingsIterator();

        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
        }
    }

    private async *getListConfigurationSettingsIterator(): AsyncIterableIterator<ConfigurationSetting> {
        return Promise.reject(new RestError('', { statusCode: 403 }));
    }
}

exports.AppConfigurationClient = ForbiddenAppConfigurationClient;