/**
 * Mock App config Client
 */
import { SetConfigurationSettingResponse, ListConfigurationSettingsOptions, ConfigurationSetting } from '@azure/app-configuration';

export class AppConfigurationClient {

    public setConfigurationSetting(configurationSetting): SetConfigurationSettingResponse {

        const response: SetConfigurationSettingResponse = {
            key: configurationSetting.key,
            label: configurationSetting.label,
            contentType: null,
            value: null,
            lastModified: null,
            tags: {},
            isReadOnly: false,
            syncToken: "testToken",
            etag: null,
            _response: null
        }

        return response
    }

    public listConfigurationSettings(options?: ListConfigurationSettingsOptions) {

        // Polyfill Symbol.asyncIterator,Since the property is readonly, only assign it when it doesn't exist:
        if (typeof (Symbol as any).asyncIterator === 'undefined') {
            (Symbol as any).asyncIterator = Symbol.asyncIterator || Symbol('asyncIterator');
        }
        const iter = this.getListConfigurationSettingsIterator();

        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
        }
    }

    private async *getListConfigurationSettingsIterator(): AsyncIterableIterator<ConfigurationSetting> {

        let items: Array<ConfigurationSetting> = [
            {
                etag: "",
                key: "Mvc:FontColor",
                label: "development",
                contentType: "media",
                value: "orange",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Mvc:BackGroundColor",
                label: "",
                contentType: "media",
                value: "white",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Message",
                label: "",
                contentType: "media",
                value: "Test 1",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Message1",
                label: " ",
                contentType: "media",
                value: "Test 1",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Settings:KeyVault:Message",
                label: " ",
                contentType: "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8",
                value: JSON.stringify({ uri: "https://vaultName.vault.azure.net/secrets/TestMessage" }), //secret url to key vault
                lastModified: null,
                isReadOnly: false
            },
        ]
        for (let setting of items) {

            yield setting
        }
    }
}
