
import { KeyVaultSecretIdentifier, KeyVaultSecret, GetSecretOptions } from "@azure/keyvault-secrets";


export function parseKeyVaultSecretIdentifier(id: string): KeyVaultSecretIdentifier {
    return {
        sourceId: "https://my-vault.vault.azure.net/secrets/TestMessage/1234678",
        vaultUrl: "https://my-vault.vault.azure.net",
        version: "1234678",
        name: "TestMessage"
    }
}

export class SecretClient {
    public getSecret(secretName: string, options?: GetSecretOptions): Promise<KeyVaultSecret> {
        return Promise.resolve({
            properties: {
                enabled: true,
                recoverableDays: 90,
                id: "https://my-vault.vault.azure.net/secrets/TestMessage/1234678",
                vaultUrl: "https://my-vault.vault.azure.net",
                name: "TestMessage"
            },
            value: "Hello from keyvault",
            name: "TestMessage"
        })
    }
}
