/**
 * Mock SecretClient, that throws an 403 status code 
*/
import { KeyVaultSecret, GetSecretOptions, KeyVaultSecretIdentifier } from "@azure/keyvault-secrets"
import { RestError, PipelineRequest, HttpHeaders, RawHttpHeaders, createHttpHeaders } from "@azure/core-rest-pipeline";

class ForbiddenSecretClient {
    public getSecret(secretName: string, options?: GetSecretOptions): Promise<KeyVaultSecret> {
        const rawHttpHeaders: RawHttpHeaders = {
            "x-ms-client-request-id": "12345908"
        };

        const httpHeaders: HttpHeaders = createHttpHeaders(rawHttpHeaders);

        const request: PipelineRequest = {
            url: "https://my-vault.vault.azure.net/secrets/TestMessage",
            method: "GET",
            headers: httpHeaders,
            timeout: 1000,
            withCredentials: false,
            requestId: "request-id"
        }
        return Promise.reject(new RestError('', { statusCode: 403, request: request }));
    }
}

export function parseKeyVaultSecretIdentifier(id: string): KeyVaultSecretIdentifier {
    return {
        sourceId: "https://my-vault.vault.azure.net/secrets/TestMessage/1234678",
        vaultUrl: "https://my-vault.vault.azure.net",
        version: "1234678",
        name: "TestMessage"
    }
}

exports.SecretClient = ForbiddenSecretClient;