/**
 * Mock App config Client, that throws an 403=1 status code 
*/
import { ConfigurationSetting, ListConfigurationSettingsOptions } from "@azure/app-configuration";
import { RestError, RawHttpHeaders, PipelineRequest, createHttpHeaders, HttpHeaders } from "@azure/core-rest-pipeline";

class UnauthorizedAppConfigurationClient {

    public listConfigurationSettings(options?: ListConfigurationSettingsOptions) {

        // Polyfill Symbol.asyncIterator,Since the property is readonly, only assign it when it doesn't exist:
        if (typeof (Symbol as any).asyncIterator === 'undefined') {
            (Symbol as any).asyncIterator = Symbol.asyncIterator || Symbol('asyncIterator');
        }
        const iter = this.getListConfigurationSettingsIterator();

        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
        }
    }

    private async *getListConfigurationSettingsIterator(): AsyncIterableIterator<ConfigurationSetting> {
        const rawHttpHeaders: RawHttpHeaders = {
            "user-agent": "AzurePipelines.AzureAppConfiguration.Pull",
            "x-ms-client-request-id": "12345908",
            "www-authenticate":"HMAC"
        };
        
        const httpHeaders: HttpHeaders = createHttpHeaders(rawHttpHeaders);
        const request: PipelineRequest = {
            url: "https://test.azconfig.io",
            method: "GET", 
            headers: httpHeaders,
            timeout: 1000,
            withCredentials: false,
            requestId: "request-id"
        }

        return Promise.reject(new RestError('', { statusCode: 401, 
            request: request,
            response: {
                headers: httpHeaders,
                status: 401,
                request: request
            }
        }));
    }
}

exports.AppConfigurationClient = UnauthorizedAppConfigurationClient;