import { AppConfigurationClient } from "./appConfigurationClient";
import { GetSnapshotResponse, KnownSnapshotComposition, ConfigurationSetting, SecretReferenceValue } from "@azure/app-configuration";

class SnapshotAppConfigurationClient extends AppConfigurationClient {
    public async getSnapshot(snapshotName: string) : Promise<GetSnapshotResponse> {
        return {
            name: snapshotName,
            filters: [
                { keyFilter: "Message" },
                { keyFilter: "Mvc:BackGroundColor" },
                { keyFilter: "Settings:KeyVault:Message" }
            ],
            compositionType: KnownSnapshotComposition.KeyLabel,
            status: "ready"
        }
    }
}

export function isSecretReference(setting: ConfigurationSetting<string>) {
    const KeyVaultType = "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8";
    if (setting.contentType == KeyVaultType) {
        return true;
    } else {
        return false;
    }
}

export function parseSecretReference(setting: ConfigurationSetting): ConfigurationSetting<SecretReferenceValue> {
    return {
        etag: "",
        key: "Settings:KeyVault:Message",
        label: " ",
        contentType: "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8",
        value: {
            secretId: "https://vaultName.vault.azure.net/secrets/TestMessage"
        },
        lastModified: null,
        isReadOnly: false
    }
}

exports.AppConfigurationClient = SnapshotAppConfigurationClient;

export { KnownSnapshotComposition }