import { ListConfigurationSettingsOptions, ConfigurationSetting, SecretReferenceValue } from "@azure/app-configuration";

class InvalidAppConfigurationClient {

    public listConfigurationSettings(options?: ListConfigurationSettingsOptions) {

        // Polyfill Symbol.asyncIterator,Since the property is readonly, only assign it when it doesn't exist:
        if (typeof (Symbol as any).asyncIterator === 'undefined') {
            (Symbol as any).asyncIterator = Symbol.asyncIterator || Symbol('asyncIterator');
        }
        const iter = this.getListConfigurationSettingsIterator();

        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
        }
    }

    private async *getListConfigurationSettingsIterator(): AsyncIterableIterator<ConfigurationSetting> {

        let items: Array<ConfigurationSetting> = [
            {
                etag: "",
                key: "Settings:KeyVault:Message",
                label: " ",
                contentType: "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8",
                value: JSON.stringify({ uri: "url" }), //secret url to key vault
                lastModified: null,
                isReadOnly: false
            },
        ];

        for (let setting of items) {
            yield setting;
        }
    }
}

export function isSecretReference(setting: ConfigurationSetting<string>) {
    const KeyVaultType = "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8";
    if (setting.contentType == KeyVaultType) {
        return true;
    } else {
        return false;
    }
}

export function parseSecretReference(setting: ConfigurationSetting): ConfigurationSetting<SecretReferenceValue> {
    return {
        etag: "",
        key: "Settings:KeyVault:Message",
        label: " ",
        contentType: "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8",
        value: {
            secretId: "url"
        },
        lastModified: null,
        isReadOnly: false
    }
}

exports.AppConfigurationClient = InvalidAppConfigurationClient