import { ConfigurationSetting, ListConfigurationSettingsOptions, SecretReferenceValue, GetSnapshotResponse, KnownSnapshotComposition } from '@azure/app-configuration';

export class AppConfigurationClient {

    public listConfigurationSettings(options?: ListConfigurationSettingsOptions) {

        // Polyfill Symbol.asyncIterator,Since the property is readonly, only assign it when it doesn't exist:
        if (typeof (Symbol as any).asyncIterator === 'undefined') {
            (Symbol as any).asyncIterator = Symbol.asyncIterator || Symbol('asyncIterator');
        }
        const iter = this.getListConfigurationSettingsIterator();

        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
        }
    }

    public listConfigurationSettingsForSnapshot(options?: ListConfigurationSettingsOptions) {
        // Polyfill Symbol.asyncIterator,Since the property is readonly, only assign it when it doesn't exist:
        if (typeof (Symbol as any).asyncIterator === 'undefined') {
            (Symbol as any).asyncIterator = Symbol.asyncIterator || Symbol('asyncIterator');
        }
        const iter = this.getConfigurationSettingsFromSnapshotIterator();

        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
        }
    }

    public async getSnapshot(snapshotName: string): Promise<GetSnapshotResponse> {
        return {
            name: snapshotName,
            filters: [
                { keyFilter: "Message" },
                { keyFilter: "Mvc:BackGroundColor" },
                { keyFilter: "Settings:KeyVault:Message" }
            ],
            compositionType: KnownSnapshotComposition.Key,
            status: "ready"
        }
    }

    private async *getListConfigurationSettingsIterator(): AsyncIterableIterator<ConfigurationSetting> {

        let items: Array<ConfigurationSetting> = [
            {
                etag: "",
                key: "Mvc:FontColor",
                label: "development",
                contentType: "media",
                value: "orange",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Mvc:BackGroundColor",
                label: "",
                contentType: "media",
                value: "white",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Message",
                label: "",
                contentType: "media",
                value: "Test 1",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Message1",
                label: " ",
                contentType: "media",
                value: "Test 1",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Settings:KeyVault:Message",
                label: " ",
                contentType: "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8",
                value: JSON.stringify({ uri: "https://vaultName.vault.azure.net/secrets/TestMessage" }), //secret url to key vault
                lastModified: null,
                isReadOnly: false
            },
        ]
        for (let setting of items) {

            yield setting
        }
    }

    private async *getConfigurationSettingsFromSnapshotIterator(): AsyncIterableIterator<ConfigurationSetting> {

        let items: Array<ConfigurationSetting> = [
            {
                etag: "",
                key: "Message",
                label: "development",
                contentType: "media",
                value: "orange",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Mvc:BackGroundColor",
                label: "",
                contentType: "media",
                value: "white",
                lastModified: null,
                isReadOnly: false
            },
            {
                etag: "",
                key: "Settings:KeyVault:Message",
                label: " ",
                contentType: "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8",
                value: JSON.stringify({ uri: "https://my-vault.vault.azure.net/secrets/Message" }), //secret url to key vault
                lastModified: null,
                isReadOnly: false
            },
        ]
        for (let setting of items) {

            yield setting
        }
    }
}

export function isSecretReference(setting: ConfigurationSetting<string>) {
    const KeyVaultType = "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8";
    if (setting.contentType == KeyVaultType) {
        return true;
    } else {
        return false;
    }
}

export function parseSecretReference(setting: ConfigurationSetting): ConfigurationSetting<SecretReferenceValue> {
    return {
        etag: "",
        key: "Settings:KeyVault:Message",
        label: " ",
        contentType: "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8",
        value: {
            secretId: "https://vaultName.vault.azure.net/secrets/TestMessage"
        },
        lastModified: null,
        isReadOnly: false
    }
}
export { KnownSnapshotComposition }