/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.javalib.util;

import com.tencent.matrix.javalib.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    public static final int LOG_LEVEL_VERBOSE = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_INFO = 2;
    public static final int LOG_LEVEL_WARN = 3;
    public static final int LOG_LEVEL_ERROR = 4;
    private static LogImp debugLog;
    private static LogImp logImp;
    private static int level;
    private static final String[][] LOG_LEVELS;

    private Log() {
    }

    public static void setLogImp(LogImp imp) {
        logImp = imp;
    }

    public static LogImp getImpl() {
        return logImp;
    }

    public static void setLogLevel(String logLevel) {
        for (String[] pattern : LOG_LEVELS) {
            if (!pattern[0].equalsIgnoreCase(logLevel) && !pattern[1].equalsIgnoreCase(logLevel)) continue;
            level = Integer.parseInt(pattern[2]);
        }
        Log.getImpl().setLogLevel(level);
    }

    public static void v(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.v(tag, msg, obj);
        }
    }

    public static void e(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.e(tag, msg, obj);
        }
    }

    public static void w(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.w(tag, msg, obj);
        }
    }

    public static void i(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.i(tag, msg, obj);
        }
    }

    public static void d(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.d(tag, msg, obj);
        }
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        if (logImp != null) {
            logImp.printErrStackTrace(tag, tr, format, obj);
        }
    }

    static {
        logImp = debugLog = new LogImp(){
            private int level = 2;

            @Override
            public void v(String tag, String msg, Object ... obj) {
                if (this.level == 0) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[V][%s] %s", tag, Util.capitalize(log)));
                }
            }

            @Override
            public void d(String tag, String msg, Object ... obj) {
                if (this.level <= 1) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[D][%s] %s", tag, Util.capitalize(log)));
                }
            }

            @Override
            public void i(String tag, String msg, Object ... obj) {
                if (this.level <= 2) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[I][%s] %s", tag, Util.capitalize(log)));
                }
            }

            @Override
            public void w(String tag, String msg, Object ... obj) {
                if (this.level <= 3) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[W][%s] %s", tag, Util.capitalize(log)));
                }
            }

            @Override
            public void e(String tag, String msg, Object ... obj) {
                if (this.level <= 4) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[E][%s] %s", tag, Util.capitalize(log)));
                }
            }

            @Override
            public void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
                String log;
                String string = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                tr.printStackTrace(pw);
                log = log + "  " + sw.toString();
                System.out.println(String.format("[E][%s] %s", tag, Util.capitalize(log)));
            }

            @Override
            public void setLogLevel(int logLevel) {
                this.level = logLevel;
            }
        };
        level = 2;
        LOG_LEVELS = new String[][]{{"V", "VERBOSE", "0"}, {"D", "DEBUG", "1"}, {"I", "INFO", "2"}, {"W", "WARN", "3"}, {"E", "ERROR", "4"}};
    }

    public static interface LogImp {
        public void v(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);

        public void setLogLevel(int var1);
    }
}

