/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task.util;

import brut.androlib.AndrolibException;
import brut.androlib.res.decoder.ResStreamDecoder;
import com.tencent.matrix.javalib.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlPullResourceRefDecoder
implements ResStreamDecoder {
    private static final String TAG = "Matrix.XmlPullResourceRefDecoder";
    private final Set<String> resourceRefSet = new HashSet<String>();
    private final XmlPullParser mParser;

    public XmlPullResourceRefDecoder(XmlPullParser parser) {
        this.mParser = parser;
    }

    @Override
    public void decode(InputStream inputStream, OutputStream outputStream) throws AndrolibException {
        try {
            this.mParser.setInput(inputStream, null);
            int token = this.mParser.next();
            while (token != 1) {
                switch (token) {
                    case 2: {
                        this.handleElement();
                        break;
                    }
                    case 4: {
                        this.handleContent();
                        break;
                    }
                }
                token = this.mParser.next();
            }
            inputStream.close();
        }
        catch (XmlPullParserException var7) {
            throw new AndrolibException("Could not decode XML," + var7.getMessage(), var7);
        }
        catch (IOException e) {
            throw new AndrolibException("Parse xml error," + e.getMessage(), e);
        }
    }

    private void handleElement() {
        String tagName = this.mParser.getName();
        int pointIndex = tagName.lastIndexOf(46);
        if (pointIndex >= 0) {
            tagName = tagName.substring(pointIndex + 1);
        }
        if (!Util.isNullOrNil(tagName)) {
            for (int i = 0; i < this.mParser.getAttributeCount(); ++i) {
                int index;
                String value = this.mParser.getAttributeValue(i);
                if (Util.isNullOrNil(value)) continue;
                if (value.startsWith("@")) {
                    index = value.indexOf(47);
                    if (index <= 1) continue;
                    String type = value.substring(1, index);
                    this.resourceRefSet.add("R." + type + "." + value.substring(index + 1).replace('.', '_'));
                    continue;
                }
                if (!value.startsWith("?")) continue;
                index = value.indexOf(47);
                if (index > 1) {
                    this.resourceRefSet.add("R.attr.." + value.substring(index + 1).replace('.', '_'));
                    continue;
                }
                int colonIndex = value.indexOf(58);
                if (colonIndex > 1) {
                    this.resourceRefSet.add("R.attr." + value.substring(colonIndex + 1).replace('.', '_'));
                    continue;
                }
                this.resourceRefSet.add("R.attr." + value.substring(1).replace('.', '_'));
            }
        }
    }

    private void handleContent() {
        String text = this.mParser.getText();
        if (!Util.isNullOrNil(text)) {
            int index;
            if (text.startsWith("@")) {
                int index2 = text.indexOf(47);
                if (index2 > 1) {
                    String type = text.substring(1, index2);
                    this.resourceRefSet.add("R." + type + "." + text.substring(index2 + 1).replace('.', '_'));
                }
            } else if (text.startsWith("?") && (index = text.indexOf(47)) > 1) {
                this.resourceRefSet.add("R.attr.." + text.substring(index + 1).replace('.', '_'));
            }
        }
    }

    public Set<String> getResourceRefSet() {
        return this.resourceRefSet;
    }
}

