/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task.util;

import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResguardUtil {
    private static final String TAG = "Matrix.ResguardUtil";
    private static final Pattern RESOURCE_ID_PATTERN = Pattern.compile("^(\\S+\\.)*R\\.(\\S+?)\\.(\\S+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readResMappingTxtFile(File resMappingTxt, Map<String, String> resDirMap, Map<String, String> resguardMap) throws IOException {
        if (resMappingTxt != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(resMappingTxt));){
                String line = bufferedReader.readLine();
                boolean readResStart = false;
                boolean readPathStart = false;
                while (line != null) {
                    String after;
                    String before;
                    String[] columns;
                    if (line.trim().equals("res path mapping:")) {
                        readPathStart = true;
                    } else if (line.trim().equals("res id mapping:")) {
                        readResStart = true;
                        readPathStart = false;
                    } else if (readPathStart && resDirMap != null) {
                        columns = line.split("->");
                        if (columns.length == 2) {
                            before = columns[0].trim();
                            after = columns[1].trim();
                            if (!Util.isNullOrNil(before) && !Util.isNullOrNil(after)) {
                                Log.d(TAG, "%s->%s", before, after);
                                resDirMap.put(after, before);
                            }
                        }
                    } else if (readResStart && resguardMap != null && (columns = line.split("->")).length == 2) {
                        before = ResguardUtil.parseResourceNameFromResguard(columns[0].trim());
                        after = ResguardUtil.parseResourceNameFromResguard(columns[1].trim());
                        if (!Util.isNullOrNil(before) && !Util.isNullOrNil(after)) {
                            Log.d(TAG, "%s->%s", before, after);
                            resguardMap.put(after, before);
                        }
                    }
                    line = bufferedReader.readLine();
                }
            }
        }
    }

    private static String parseResourceNameFromResguard(String resName) {
        if (Util.isNullOrNil(resName)) {
            return "";
        }
        Matcher matcher = RESOURCE_ID_PATTERN.matcher(resName);
        if (matcher.find()) {
            StringBuilder builder = new StringBuilder();
            builder.append("R.");
            builder.append(matcher.group(2));
            builder.append('.');
            builder.append(matcher.group(3).replace('.', '_'));
            return builder.toString();
        }
        return "";
    }
}

