/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task.util;

import brut.androlib.AndrolibException;
import brut.androlib.res.decoder.AXmlResourceParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.task.util.ApkResourceDecoder;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Stack;

public class ManifestParser {
    private static final String ROOTTAG = "manifest";
    private final AXmlResourceParser resourceParser;
    private File manifestFile;
    private boolean isParseStarted;
    private final Stack<JsonObject> jsonStack = new Stack();
    private JsonObject result;

    public ManifestParser(String path) {
        this.manifestFile = new File(path);
        this.resourceParser = ApkResourceDecoder.createAXmlParser();
    }

    public ManifestParser(File manifestFile) {
        if (manifestFile != null) {
            this.manifestFile = manifestFile;
        }
        this.resourceParser = ApkResourceDecoder.createAXmlParser();
    }

    public ManifestParser(File manifestFile, File arscFile) throws IOException, AndrolibException {
        if (manifestFile != null) {
            this.manifestFile = manifestFile;
        }
        this.resourceParser = ApkResourceDecoder.createAXmlParser(arscFile);
    }

    public JsonObject parse() throws Exception {
        FileInputStream inputStream = null;
        inputStream = new FileInputStream(this.manifestFile);
        try {
            this.resourceParser.open(inputStream);
            int token = this.resourceParser.nextToken();
            while (token != 1) {
                token = this.resourceParser.next();
                if (token == 2) {
                    this.handleStartElement();
                    continue;
                }
                if (token == 4) {
                    this.handleElementContent();
                    continue;
                }
                if (token != 3) continue;
                this.handleEndElement();
            }
        }
        finally {
            this.resourceParser.close();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return this.result;
    }

    private void handleStartElement() {
        String name = this.resourceParser.getName();
        if (name.equals(ROOTTAG)) {
            this.isParseStarted = true;
        }
        if (this.isParseStarted) {
            JsonObject jsonObject = new JsonObject();
            for (int i = 0; i < this.resourceParser.getAttributeCount(); ++i) {
                if (!Util.isNullOrNil(this.resourceParser.getAttributePrefix(i))) {
                    jsonObject.addProperty(this.resourceParser.getAttributePrefix(i) + ":" + this.resourceParser.getAttributeName(i), this.resourceParser.getAttributeValue(i));
                    continue;
                }
                jsonObject.addProperty(this.resourceParser.getAttributeName(i), this.resourceParser.getAttributeValue(i));
            }
            this.jsonStack.push(jsonObject);
        }
    }

    private void handleElementContent() {
    }

    private void handleEndElement() {
        String name = this.resourceParser.getName();
        JsonObject jsonObject = this.jsonStack.pop();
        if (this.jsonStack.isEmpty()) {
            this.result = jsonObject;
        } else {
            JsonObject preObject = this.jsonStack.peek();
            JsonArray jsonArray = null;
            if (preObject.has(name)) {
                jsonArray = preObject.getAsJsonArray(name);
                jsonArray.add(jsonObject);
            } else {
                jsonArray = new JsonArray();
                jsonArray.add(jsonObject);
                preObject.add(name, jsonArray);
            }
        }
    }
}

