/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task.util;

import com.android.dexdeps.Output;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.baksmali.formatter.BaksmaliWriter;
import org.jf.dexlib2.iface.ClassDef;

public class ApkUtil {
    private static final String TAG = "Matrix.ApkUtil";

    public static String getNormalClassName(String name) {
        if (!Util.isNullOrNil(name)) {
            String className = Output.descriptorToDot(name);
            if (className.endsWith("[]")) {
                className = className.substring(0, className.indexOf("[]"));
            }
            return className;
        }
        return "";
    }

    public static String getPackageName(String className) {
        if (!Util.isNullOrNil(className)) {
            int index = className.lastIndexOf(46);
            if (index >= 0) {
                return className.substring(0, index);
            }
            Log.d(TAG, "default package class: %s", className);
            return "<default>";
        }
        return "";
    }

    public static String getPureClassName(String classname) {
        String name = "";
        if (!Util.isNullOrNil(classname)) {
            int index = classname.lastIndexOf(46);
            name = index != -1 ? classname.substring(index + 1) : classname;
        }
        return name;
    }

    public static boolean isRClassName(String className) {
        Pattern pattern = Pattern.compile("^R\\$\\w+");
        return pattern.matcher(className).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] disassembleClass(ClassDef classDef, BaksmaliOptions options) {
        String classDescriptor = classDef.getType();
        if (classDescriptor.charAt(0) != 'L' || classDescriptor.charAt(classDescriptor.length() - 1) != ';') {
            Log.e(TAG, "Unrecognized class descriptor - " + classDescriptor + " - skipping class", new Object[0]);
            return null;
        }
        ClassDefinition classDefinition = new ClassDefinition(options, classDef);
        Writer writer = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
            writer = new BaksmaliWriter(bufWriter, classDef.getType());
            classDefinition.writeTo((BaksmaliWriter)writer);
            writer.flush();
            String[] stringArray = baos.toString().split("\n");
            return stringArray;
        }
        catch (Exception ex) {
            Log.e(TAG, "\n\nError occurred while disassembling class " + classDescriptor.replace('/', '.') + " - skipping class", new Object[0]);
            ex.printStackTrace();
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

