/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task.util;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.util.ExtMXSerializer;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import com.tencent.matrix.apk.model.task.util.XmlPullResourceRefDecoder;
import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ApkResourceDecoder {
    private static final String TAG = "Matrix.ApkResourceDecoder";
    public static final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    public static final String PROPERTY_SERIALIZER_LINE_SEPARATOR = "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator";
    public static final String PROPERTY_DEFAULT_ENCNDING = "DEFAULT_ENCODING";

    public static AXmlResourceParser createAXmlParser() {
        AXmlResourceParser resourceParser = new AXmlResourceParser();
        ResTable resTable = new ResTable();
        resourceParser.setAttrDecoder(new ResAttrDecoder());
        resourceParser.getAttrDecoder().setCurrentPackage(new ResPackage(resTable, 0, null));
        return resourceParser;
    }

    public static AXmlResourceParser createAXmlParser(File arscFile) throws IOException, AndrolibException {
        AXmlResourceParser resourceParser = ApkResourceDecoder.createAXmlParser();
        ResTable resTable = new ResTable();
        ApkResourceDecoder.decodeArscFile(arscFile, resTable);
        resourceParser.getAttrDecoder().setCurrentPackage(resTable.listMainPackages().iterator().next());
        return resourceParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeArscFile(File file, ResTable resTable) throws IOException, AndrolibException {
        if (file != null && FileUtil.isLegalFile(file)) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                ResPackage[] frameworkPackages;
                ResPackage[] resPackages = ARSCDecoder.decode(inputStream, false, true, resTable).getPackages();
                ResPackage mainPackage = ApkResourceDecoder.getMainPackage(resPackages);
                if (mainPackage != null) {
                    resTable.addPackage(mainPackage, true);
                }
                for (ResPackage sysPackage : frameworkPackages = ApkResourceDecoder.loadFrameworkPackage(resTable)) {
                    resTable.addPackage(sysPackage, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResPackage[] loadFrameworkPackage(ResTable resTable) throws IOException, AndrolibException {
        ResPackage[] resPackages = new ResPackage[]{};
        ZipInputStream zipInputStream = new ZipInputStream(ApkResourceDecoder.class.getResourceAsStream("/android/android-framework.jar"));
        ZipEntry entry = zipInputStream.getNextEntry();
        try (BufferedInputStream bufInputStream = null;){
            while (entry != null) {
                if (entry.getName().equals("resources.arsc")) {
                    bufInputStream = new BufferedInputStream(zipInputStream);
                    resPackages = ARSCDecoder.decode(bufInputStream, false, true, resTable).getPackages();
                    break;
                }
                entry = zipInputStream.getNextEntry();
            }
        }
        return resPackages;
    }

    private static ResPackage getMainPackage(ResPackage[] resPackages) {
        ResPackage pkg = null;
        if (resPackages != null && resPackages.length > 0) {
            if (resPackages.length == 1) {
                pkg = resPackages[0];
            } else {
                int id = 0;
                int value = 0;
                int index = 0;
                for (int i = 0; i < resPackages.length; ++i) {
                    ResPackage resPackage = resPackages[i];
                    if (resPackage.getResSpecCount() <= value || resPackage.getName().equalsIgnoreCase("android")) continue;
                    value = resPackage.getResSpecCount();
                    id = resPackage.getId();
                    index = i;
                }
                return id == 0 ? resPackages[0] : resPackages[index];
            }
        }
        return pkg;
    }

    private static void decodeResResource(ResResource res, File inDir, AXmlResourceParser xmlParser, Map<String, Set<String>> nonValueReferences) throws AndrolibException, IOException {
        ResFileValue fileValue = (ResFileValue)res.getValue();
        String inFileName = fileValue.getStrippedPath();
        String typeName = res.getResSpec().getType().getName();
        try {
            File inFile = new File(inDir, inFileName);
            if (!FileUtil.isLegalFile(inFile)) {
                return;
            }
            if (!inFileName.endsWith(".xml")) {
                return;
            }
            FileInputStream inputStream = new FileInputStream(inFile);
            XmlPullResourceRefDecoder xmlDecoder = new XmlPullResourceRefDecoder(xmlParser);
            xmlDecoder.decode(inputStream, null);
            String resource = "R." + typeName + "." + inFile.getName().substring(0, inFile.getName().lastIndexOf(46));
            if (!nonValueReferences.containsKey(resource)) {
                nonValueReferences.put(resource, xmlDecoder.getResourceRefSet());
            } else {
                nonValueReferences.get(resource).addAll(xmlDecoder.getResourceRefSet());
            }
        }
        catch (AndrolibException ex) {
            Log.e(TAG, ex.getMessage(), new Object[0]);
        }
    }

    private static void decodeResValues(ResValuesFile resValuesFile, XmlPullParser xmlParser, ExtMXSerializer serializer, Set<String> references) throws IOException, AndrolibException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        serializer.setOutput(outStream, null);
        serializer.startDocument(null, null);
        serializer.startTag(null, "resources");
        for (ResResource res : resValuesFile.listResources()) {
            if (resValuesFile.isSynthesized(res)) continue;
            ((ResValuesXmlSerializable)((Object)res.getValue())).serializeToResValuesXml(serializer, res);
        }
        serializer.endTag(null, "resources");
        serializer.newLine();
        serializer.endDocument();
        serializer.flush();
        outStream.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
        XmlPullResourceRefDecoder xmlDecoder = new XmlPullResourceRefDecoder(xmlParser);
        xmlDecoder.decode(inputStream, null);
        references.addAll(xmlDecoder.getResourceRefSet());
    }

    public static void decodeResourcesRef(File manifestFile, File arscFile, File resDir, Map<String, Set<String>> nonValueReferences, Set<String> valueReferences) throws IOException, AndrolibException, XmlPullParserException {
        if (!FileUtil.isLegalFile(manifestFile)) {
            Log.w(TAG, "File %s is illegal!", "AndroidManifest.xml");
            return;
        }
        if (!FileUtil.isLegalFile(arscFile)) {
            Log.w(TAG, "File %s is illegal!", "resources.arsc");
            return;
        }
        if (resDir != null && resDir.exists() && resDir.isDirectory()) {
            ResTable resTable = new ResTable();
            ApkResourceDecoder.decodeArscFile(arscFile, resTable);
            AXmlResourceParser aXmlResourceParser = ApkResourceDecoder.createAXmlParser(arscFile);
            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            ExtMXSerializer serializer = ApkResourceDecoder.createXmlSerializer();
            for (ResPackage pkg : resTable.listMainPackages()) {
                aXmlResourceParser.getAttrDecoder().setCurrentPackage(pkg);
                for (ResResource resSource : pkg.listFiles()) {
                    ApkResourceDecoder.decodeResResource(resSource, resDir, aXmlResourceParser, nonValueReferences);
                }
                for (ResValuesFile valuesFile : pkg.listValuesFiles()) {
                    ApkResourceDecoder.decodeResValues(valuesFile, xmlPullParser, serializer, valueReferences);
                }
            }
            XmlPullResourceRefDecoder xmlDecoder = new XmlPullResourceRefDecoder(aXmlResourceParser);
            FileInputStream inputStream = new FileInputStream(manifestFile);
            xmlDecoder.decode(inputStream, null);
            valueReferences.addAll(xmlDecoder.getResourceRefSet());
        } else {
            Log.w(TAG, "Res dir is illegal!", new Object[0]);
        }
    }

    private static ExtMXSerializer createXmlSerializer() {
        ExtMXSerializer serializer = new ExtMXSerializer();
        serializer.setProperty(PROPERTY_SERIALIZER_INDENTATION, "   ");
        serializer.setProperty(PROPERTY_SERIALIZER_LINE_SEPARATOR, System.lineSeparator());
        serializer.setProperty(PROPERTY_DEFAULT_ENCNDING, "utf-8");
        serializer.setDisabledAttrEscape(true);
        return serializer;
    }
}

