/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.utils.Pair;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.util.ResguardUtil;
import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class UnzipTask
extends ApkTask {
    private static final String TAG = "Matrix.UnZipTask";
    private File inputFile;
    private File outputFile;
    private File mappingTxt;
    private File resMappingTxt;
    private final Map<String, String> proguardClassMap;
    private final Map<String, String> resguardMap;
    private final Map<String, String> resDirMap;
    private final Map<String, String> entryNameMap;
    private final Map<String, Pair<Long, Long>> entrySizeMap;

    public UnzipTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 1;
        this.proguardClassMap = new HashMap<String, String>();
        this.resguardMap = new HashMap<String, String>();
        this.resDirMap = new HashMap<String, String>();
        this.entryNameMap = new HashMap<String, String>();
        this.entrySizeMap = new HashMap<String, Pair<Long, Long>>();
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        if (Util.isNullOrNil(this.config.getApkPath())) {
            throw new TaskInitException("Matrix.UnZipTask---APK-FILE-PATH can not be null!");
        }
        Log.i(TAG, "inputPath:%s", this.config.getApkPath());
        this.inputFile = new File(this.config.getApkPath());
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.UnZipTask---'" + this.config.getApkPath() + "' is not exist!");
        }
        if (Util.isNullOrNil(this.config.getUnzipPath())) {
            throw new TaskInitException("Matrix.UnZipTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "outputPath:%s", this.config.getUnzipPath());
        this.outputFile = new File(this.config.getUnzipPath());
        if (!Util.isNullOrNil(this.config.getMappingFilePath())) {
            this.mappingTxt = new File(this.config.getMappingFilePath());
            if (!FileUtil.isLegalFile(this.mappingTxt)) {
                throw new TaskInitException("Matrix.UnZipTask---mapping file " + this.config.getMappingFilePath() + " is not legal!");
            }
        }
        if (!Util.isNullOrNil(this.config.getResMappingFilePath())) {
            this.resMappingTxt = new File(this.config.getResMappingFilePath());
            if (!FileUtil.isLegalFile(this.resMappingTxt)) {
                throw new TaskInitException("Matrix.UnZipTask---resguard mapping file " + this.config.getResMappingFilePath() + " is not legal!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMappingTxtFile() throws IOException {
        if (this.mappingTxt != null) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.mappingTxt));
            String line = bufferedReader.readLine();
            String beforeClass = "";
            String afterClass = "";
            try {
                while (line != null) {
                    String[] pair;
                    if (!line.startsWith(" ") && (pair = line.split("->")).length == 2) {
                        beforeClass = pair[0].trim();
                        afterClass = pair[1].trim();
                        afterClass = afterClass.substring(0, afterClass.length() - 1);
                        if (!Util.isNullOrNil(beforeClass) && !Util.isNullOrNil(afterClass)) {
                            Log.d(TAG, "before:%s,after:%s", beforeClass, afterClass);
                            this.proguardClassMap.put(afterClass, beforeClass);
                        }
                    }
                    line = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
    }

    private String parseResourceNameFromPath(String dir, String filename) {
        if (Util.isNullOrNil(dir) || Util.isNullOrNil(filename)) {
            return "";
        }
        String type = dir.substring(dir.indexOf(47) + 1);
        int index = type.indexOf(45);
        if (index >= 0) {
            type = type.substring(0, index);
        }
        if ((index = filename.indexOf(46)) >= 0) {
            filename = filename.substring(0, index);
        }
        return "R." + type + "." + filename;
    }

    private String reverseResguard(String dirName, String filename) {
        String outEntryName = "";
        if (this.resDirMap.containsKey(dirName)) {
            int lastIndex;
            String newDirName = this.resDirMap.get(dirName);
            String resource = this.parseResourceNameFromPath(newDirName, filename);
            int suffixIndex = filename.indexOf(46);
            String suffix = "";
            if (suffixIndex >= 0) {
                suffix = filename.substring(suffixIndex);
            }
            if (this.resguardMap.containsKey(resource) && (lastIndex = this.resguardMap.get(resource).lastIndexOf(46)) >= 0) {
                filename = this.resguardMap.get(resource).substring(lastIndex + 1) + suffix;
            }
            outEntryName = newDirName + "/" + filename;
        }
        return outEntryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeEntry(ZipFile zipFile, ZipEntry entry) throws IOException {
        String outEntryName;
        block15: {
            String entryName = entry.getName();
            if (Util.preventZipSlip(this.outputFile, entryName)) {
                Log.e(TAG, "writeEntry entry %s failed!", entryName);
                return null;
            }
            byte[] readBuffer = new byte[4096];
            FilterOutputStream bufferedOutput = null;
            InputStream zipInputStream = null;
            outEntryName = null;
            File file = null;
            int index = entryName.lastIndexOf(47);
            if (index >= 0) {
                String filename = entryName.substring(index + 1);
                String dirName = entryName.substring(0, index);
                File dir = new File(this.outputFile, dirName);
                if (!dir.exists() && !dir.mkdirs()) {
                    Log.e(TAG, "%s mkdirs failed!", dir.getAbsolutePath());
                    return null;
                }
                if (!Util.isNullOrNil(filename)) {
                    file = new File(dir, filename);
                    outEntryName = this.reverseResguard(dirName, filename);
                    if (Util.isNullOrNil(outEntryName)) {
                        outEntryName = entryName;
                    }
                }
            } else {
                file = new File(this.outputFile, entryName);
                outEntryName = entryName;
            }
            try {
                String string;
                if (file != null) {
                    int readSize;
                    if (!file.createNewFile()) {
                        Log.e(TAG, "create file %s failed!", file.getAbsolutePath());
                        string = null;
                        return string;
                    }
                    bufferedOutput = new BufferedOutputStream(new FileOutputStream(file));
                    zipInputStream = zipFile.getInputStream(entry);
                    while ((readSize = zipInputStream.read(readBuffer)) != -1) {
                        ((BufferedOutputStream)bufferedOutput).write(readBuffer, 0, readSize);
                    }
                    break block15;
                }
                string = null;
                return string;
            }
            finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (bufferedOutput != null) {
                    bufferedOutput.close();
                }
            }
        }
        return outEntryName;
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.inputFile);
            if (this.outputFile.isDirectory() && this.outputFile.exists()) {
                Log.i(TAG, "%s exists, delete it.", this.outputFile.getAbsolutePath());
                FileUtils.deleteDirectory(this.outputFile);
            } else if (this.outputFile.isFile()) {
                throw new TaskExecuteException("Matrix.UnZipTask---File '" + this.outputFile.getAbsolutePath() + "' is already exists!");
            }
            TaskResult taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            if (taskResult == null) {
                TaskResult taskResult2 = null;
                return taskResult2;
            }
            long startTime = System.currentTimeMillis();
            if (!this.outputFile.mkdir()) {
                throw new TaskExecuteException("Matrix.UnZipTask---Create directory '" + this.outputFile.getAbsolutePath() + "' failed!");
            }
            ((TaskJsonResult)taskResult).add("total-size", this.inputFile.length());
            this.readMappingTxtFile();
            this.config.setProguardClassMap(this.proguardClassMap);
            ResguardUtil.readResMappingTxtFile(this.resMappingTxt, this.resDirMap, this.resguardMap);
            this.config.setResguardMap(this.resguardMap);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            JsonArray jsonArray = new JsonArray();
            String outEntryName = "";
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                outEntryName = this.writeEntry(zipFile, entry);
                if (Util.isNullOrNil(outEntryName)) continue;
                JsonObject fileItem = new JsonObject();
                fileItem.addProperty("entry-name", outEntryName);
                fileItem.addProperty("entry-size", entry.getCompressedSize());
                jsonArray.add(fileItem);
                this.entrySizeMap.put(outEntryName, Pair.of(entry.getSize(), entry.getCompressedSize()));
                this.entryNameMap.put(entry.getName(), outEntryName);
            }
            this.config.setEntrySizeMap(this.entrySizeMap);
            this.config.setEntryNameMap(this.entryNameMap);
            ((TaskJsonResult)taskResult).add("entries", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            TaskResult taskResult3 = taskResult;
            return taskResult3;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

