/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import brut.androlib.AndrolibException;
import com.google.common.collect.Ordering;
import com.google.gson.JsonArray;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.util.ApkResourceDecoder;
import com.tencent.matrix.apk.model.task.util.ApkUtil;
import com.tencent.matrix.apk.model.task.util.ResguardUtil;
import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.xmlpull.v1.XmlPullParserException;

public class UnusedResourcesTask
extends ApkTask {
    private static final String TAG = "Matrix.UnusedResourcesTask";
    private File inputFile;
    private File resourceTxt;
    private File mappingTxt;
    private File resMappingTxt;
    private final List<String> dexFileNameList;
    private final Map<String, String> rclassProguardMap;
    private final Map<String, String> resguardMap;
    private final Map<String, String> resourceDefMap;
    private final Map<String, Set<String>> styleableMap;
    private final Set<String> resourceRefSet;
    private final Set<String> unusedResSet;
    private final Set<String> ignoreSet;
    private final Map<String, Set<String>> nonValueReferences;
    private Stack<String> visitPath;
    private static final Pattern sRClassPattern = Pattern.compile("(([a-zA-Z0-9_]*\\.)*)R\\$([a-z]+)");

    public UnusedResourcesTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 12;
        this.dexFileNameList = new ArrayList<String>();
        this.ignoreSet = new HashSet<String>();
        this.rclassProguardMap = new HashMap<String, String>();
        this.resguardMap = new HashMap<String, String>();
        this.resourceDefMap = new HashMap<String, String>();
        this.styleableMap = new HashMap<String, Set<String>>();
        this.resourceRefSet = new HashSet<String>();
        this.unusedResSet = new HashSet<String>();
        this.nonValueReferences = new HashMap<String, Set<String>>();
        this.visitPath = new Stack();
    }

    @Override
    public void init() throws TaskInitException {
        File[] files;
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.UnusedResourcesTask---APK-UNZIP-PATH can not be null!");
        }
        if (!this.params.containsKey("--rTxt") || Util.isNullOrNil((String)this.params.get("--rTxt"))) {
            throw new TaskInitException("Matrix.UnusedResourcesTask---The File 'R.txt' can not be null!");
        }
        this.resourceTxt = new File((String)this.params.get("--rTxt"));
        if (!FileUtil.isLegalFile(this.resourceTxt)) {
            throw new TaskInitException("Matrix.UnusedResourcesTask---The Resource declarations file 'R.txt' is not legal!");
        }
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.UnusedResourcesTask---APK-UNZIP-PATH '" + inputPath + "' is not exist!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.UnusedResourcesTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        if (!Util.isNullOrNil(this.config.getMappingFilePath())) {
            this.mappingTxt = new File(this.config.getMappingFilePath());
            if (!FileUtil.isLegalFile(this.mappingTxt)) {
                throw new TaskInitException("Matrix.UnusedResourcesTask---The Proguard mapping file 'mapping.txt' is not legal!");
            }
        }
        if (this.params.containsKey("--ignoreResources") && !Util.isNullOrNil((String)this.params.get("--ignoreResources"))) {
            String[] ignoreRes = ((String)this.params.get("--ignoreResources")).split(",");
            for (String ignore : ignoreRes) {
                this.ignoreSet.add(Util.globToRegexp(ignore));
            }
        }
        if (!Util.isNullOrNil(this.config.getResMappingFilePath())) {
            this.resMappingTxt = new File(this.config.getResMappingFilePath());
            if (!FileUtil.isLegalFile(this.resMappingTxt)) {
                throw new TaskInitException("Matrix.UnusedResourcesTask---The Resguard mapping file 'resguard-mapping.txt' is not legal!");
            }
        }
        if ((files = this.inputFile.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                this.dexFileNameList.add(file.getName());
            }
        }
    }

    private String parseResourceId(String resId) {
        if (!Util.isNullOrNil(resId) && resId.startsWith("0x")) {
            if (resId.length() == 10) {
                return resId;
            }
            if (resId.length() < 10) {
                StringBuilder strBuilder = new StringBuilder(resId);
                for (int i = 0; i < 10 - resId.length(); ++i) {
                    strBuilder.append('0');
                }
                return strBuilder.toString();
            }
        }
        return "";
    }

    private String parseResourceNameFromProguard(String entry) {
        int index;
        String[] columns;
        if (!Util.isNullOrNil(entry) && (columns = entry.split("->")).length == 2 && (index = columns[1].indexOf(58)) >= 0) {
            String className = ApkUtil.getNormalClassName(columns[0]);
            String fieldName = columns[1].substring(0, index);
            if (!this.rclassProguardMap.isEmpty()) {
                String resource = className.replace('$', '.') + "." + fieldName;
                if (this.rclassProguardMap.containsKey(resource)) {
                    return this.rclassProguardMap.get(resource);
                }
                Matcher matcher = sRClassPattern.matcher(className);
                if (matcher.find()) {
                    StringBuilder resultBuilder = new StringBuilder();
                    resultBuilder.append("R.");
                    resultBuilder.append(matcher.group(3));
                    resultBuilder.append(".");
                    resultBuilder.append(fieldName);
                    return resultBuilder.toString();
                }
                return "";
            }
            if (ApkUtil.isRClassName(ApkUtil.getPureClassName(className))) {
                return (ApkUtil.getPureClassName(className) + "." + fieldName).replace('$', '.');
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readResourceTxtFile() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.resourceTxt));
        String line = bufferedReader.readLine();
        try {
            while (line != null) {
                String[] columns = line.split(" ");
                if (columns.length >= 4) {
                    String resourceName = "R." + columns[1] + "." + columns[2];
                    if (!columns[0].endsWith("[]") && columns[3].startsWith("0x")) {
                        if (columns[3].startsWith("0x01")) {
                            Log.d(TAG, "ignore system resource %s", resourceName);
                        } else {
                            String resId = this.parseResourceId(columns[3]);
                            if (!Util.isNullOrNil(resId)) {
                                this.resourceDefMap.put(resId, resourceName);
                            }
                        }
                    } else {
                        Log.d(TAG, "ignore resource %s", resourceName);
                        if (columns[0].endsWith("[]") && columns.length > 5) {
                            HashSet<String> attrReferences = new HashSet<String>();
                            for (int i = 4; i < columns.length; ++i) {
                                if (columns[i].endsWith(",")) {
                                    attrReferences.add(columns[i].substring(0, columns[i].length() - 1));
                                    continue;
                                }
                                attrReferences.add(columns[i]);
                            }
                            this.styleableMap.put(resourceName, attrReferences);
                        }
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMappingTxtFile() throws IOException {
        if (this.mappingTxt != null) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.mappingTxt));
            String line = bufferedReader.readLine();
            boolean readRField = false;
            String beforeClass = "";
            String afterClass = "";
            try {
                while (line != null) {
                    String[] entry;
                    if (!line.startsWith(" ")) {
                        String[] pair = line.split("->");
                        if (pair.length == 2) {
                            beforeClass = pair[0].trim();
                            afterClass = pair[1].trim();
                            afterClass = afterClass.substring(0, afterClass.length() - 1);
                            if (!Util.isNullOrNil(beforeClass) && !Util.isNullOrNil(afterClass) && ApkUtil.isRClassName(ApkUtil.getPureClassName(beforeClass))) {
                                Log.d(TAG, "before:%s,after:%s", beforeClass, afterClass);
                                readRField = true;
                            } else {
                                readRField = false;
                            }
                        } else {
                            readRField = false;
                        }
                    } else if (readRField && (entry = line.split("->")).length == 2) {
                        String[] field;
                        String key = entry[0].trim();
                        String value = entry[1].trim();
                        if (!Util.isNullOrNil(key) && !Util.isNullOrNil(value) && (field = key.split(" ")).length == 2) {
                            Log.d(TAG, "%s -> %s", afterClass.replace('$', '.') + "." + value, ApkUtil.getPureClassName(beforeClass).replace('$', '.') + "." + field[1]);
                            this.rclassProguardMap.put(afterClass.replace('$', '.') + "." + value, ApkUtil.getPureClassName(beforeClass).replace('$', '.') + "." + field[1]);
                        }
                    }
                    line = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
    }

    private void decodeCode() throws IOException {
        for (String dexFileName : this.dexFileNameList) {
            MultiDexContainer<? extends DexBackedDexFile> dexFiles = DexFileFactory.loadDexContainer(new File(this.inputFile, dexFileName), Opcodes.forApi(15));
            for (String dexEntryName : dexFiles.getDexEntryNames()) {
                MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry = dexFiles.getEntry(dexEntryName);
                BaksmaliOptions options = new BaksmaliOptions();
                List<? extends DexBackedClassDef> classDefs = Ordering.natural().sortedCopy(dexEntry.getDexFile().getClasses());
                for (ClassDef classDef : classDefs) {
                    String[] lines = ApkUtil.disassembleClass(classDef, options);
                    if (lines == null) continue;
                    this.readSmaliLines(lines);
                }
            }
        }
    }

    private void readSmaliLines(String[] lines) {
        if (lines == null) {
            return;
        }
        boolean arrayData = false;
        for (String line : lines) {
            String resId;
            String[] columns;
            if (Util.isNullOrNil(line = line.trim())) continue;
            if (line.startsWith("const")) {
                columns = line.split(" ");
                if (columns.length < 3 || Util.isNullOrNil(resId = this.parseResourceId(columns[2].trim())) || !this.resourceDefMap.containsKey(resId)) continue;
                this.resourceRefSet.add(this.resourceDefMap.get(resId));
                continue;
            }
            if (line.startsWith("sget")) {
                String resourceRef;
                columns = line.split(" ");
                if (columns.length < 3 || Util.isNullOrNil(resourceRef = this.parseResourceNameFromProguard(columns[2].trim()))) continue;
                Log.d(TAG, "find resource reference %s", resourceRef);
                if (this.styleableMap.containsKey(resourceRef)) {
                    for (String attr : this.styleableMap.get(resourceRef)) {
                        this.resourceRefSet.add(this.resourceDefMap.get(attr));
                    }
                    continue;
                }
                this.resourceRefSet.add(resourceRef);
                continue;
            }
            if (line.startsWith(".array-data 4")) {
                arrayData = true;
                continue;
            }
            if (line.startsWith(".end array-data")) {
                arrayData = false;
                continue;
            }
            if (!arrayData) continue;
            columns = line.split(" ");
            if (columns.length > 0 && !Util.isNullOrNil(resId = this.parseResourceId(columns[0].trim())) && this.resourceDefMap.containsKey(resId)) {
                Log.d(TAG, "array field resource, %s", resId);
                this.resourceRefSet.add(this.resourceDefMap.get(resId));
            }
            if (!line.trim().startsWith("0x") || Util.isNullOrNil(resId = this.parseResourceId(line.trim())) || !this.resourceDefMap.containsKey(resId)) continue;
            Log.d(TAG, "array field resource, %s", resId);
            this.resourceRefSet.add(this.resourceDefMap.get(resId));
        }
    }

    private void decodeResources() throws IOException, InterruptedException, AndrolibException, XmlPullParserException {
        File manifestFile = new File(this.inputFile, "AndroidManifest.xml");
        File arscFile = new File(this.inputFile, "resources.arsc");
        File resDir = new File(this.inputFile, "res");
        if (!resDir.exists()) {
            resDir = new File(this.inputFile, "r");
        }
        HashMap<String, Set<String>> fileResMap = new HashMap<String, Set<String>>();
        HashSet<String> valuesReferences = new HashSet<String>();
        ApkResourceDecoder.decodeResourcesRef(manifestFile, arscFile, resDir, fileResMap, valuesReferences);
        for (String resource : fileResMap.keySet()) {
            HashSet<String> result = new HashSet<String>();
            for (String resName : (Set)fileResMap.get(resource)) {
                if (this.resguardMap.containsKey(resName)) {
                    result.add(this.resguardMap.get(resName));
                    continue;
                }
                result.add(resName);
            }
            if (this.resguardMap.containsKey(resource)) {
                this.nonValueReferences.put(this.resguardMap.get(resource), result);
                continue;
            }
            this.nonValueReferences.put(resource, result);
        }
        for (String resource : valuesReferences) {
            if (this.resguardMap.containsKey(resource)) {
                this.resourceRefSet.add(this.resguardMap.get(resource));
                continue;
            }
            this.resourceRefSet.add(resource);
        }
        for (String resource : this.unusedResSet) {
            if (!this.ignoreResource(resource)) continue;
            this.resourceRefSet.add(resource);
        }
        for (String resource : this.resourceRefSet) {
            this.readChildReference(resource);
        }
    }

    private boolean ignoreResource(String name) {
        for (String pattern : this.ignoreSet) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private void readChildReference(String resource) throws IllegalStateException {
        if (this.nonValueReferences.containsKey(resource)) {
            this.visitPath.push(resource);
            Set<String> childReference = this.nonValueReferences.get(resource);
            this.unusedResSet.removeAll(childReference);
            for (String reference : childReference) {
                if (!this.visitPath.contains(reference)) {
                    this.readChildReference(reference);
                    continue;
                }
                this.visitPath.push(reference);
                throw new IllegalStateException("Found resource cycle! " + this.visitPath.toString());
            }
            this.visitPath.pop();
        }
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.type, "json", this.config);
            long startTime = System.currentTimeMillis();
            this.readMappingTxtFile();
            this.readResourceTxtFile();
            ResguardUtil.readResMappingTxtFile(this.resMappingTxt, null, this.resguardMap);
            this.unusedResSet.addAll(this.resourceDefMap.values());
            Log.i(TAG, "find resource declarations %d items.", this.unusedResSet.size());
            this.decodeCode();
            Log.i(TAG, "find resource references in classes: %d items.", this.resourceRefSet.size());
            this.decodeResources();
            Log.i(TAG, "find resource references %d items.", this.resourceRefSet.size());
            this.unusedResSet.removeAll(this.resourceRefSet);
            Log.i(TAG, "find unused references %d items", this.unusedResSet.size());
            Log.d(TAG, "find unused references %s", this.unusedResSet.toString());
            JsonArray jsonArray = new JsonArray();
            for (String name : this.unusedResSet) {
                jsonArray.add(name);
            }
            ((TaskJsonResult)taskResult).add("unused-resources", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

