/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.google.common.collect.Ordering;
import com.google.gson.JsonArray;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.util.ApkUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.MultiDexContainer;

public class UnusedAssetsTask
extends ApkTask {
    private static final String TAG = "Matrix.UnusedAssetsTask";
    private File inputFile;
    private final List<String> dexFileNameList;
    private final Set<String> ignoreSet;
    private final Set<String> assetsPathSet;
    private final Set<String> assetRefSet;

    public UnusedAssetsTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 13;
        this.dexFileNameList = new ArrayList<String>();
        this.ignoreSet = new HashSet<String>();
        this.assetsPathSet = new HashSet<String>();
        this.assetRefSet = new HashSet<String>();
    }

    @Override
    public void init() throws TaskInitException {
        File[] files;
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.UnusedAssetsTask---APK-UNZIP-PATH can not be null!");
        }
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.UnusedAssetsTask---APK-UNZIP-PATH '" + inputPath + "' is not exist!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.UnusedAssetsTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        if (this.params.containsKey("--ignoreAssets") && !Util.isNullOrNil((String)this.params.get("--ignoreAssets"))) {
            String[] ignoreAssets = ((String)this.params.get("--ignoreAssets")).split(",");
            Log.i(TAG, "ignore assets %d", ignoreAssets.length);
            for (String ignore : ignoreAssets) {
                this.ignoreSet.add(Util.globToRegexp(ignore));
            }
        }
        if ((files = this.inputFile.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                this.dexFileNameList.add(file.getName());
            }
        }
    }

    private void findAssetsFile(File dir) throws IOException {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    this.findAssetsFile(file);
                    continue;
                }
                Log.d(TAG, "find asset file %s", file.getAbsolutePath());
                this.assetsPathSet.add(file.getAbsolutePath());
            }
        }
    }

    private void decodeCode() throws IOException {
        for (String dexFileName : this.dexFileNameList) {
            MultiDexContainer<? extends DexBackedDexFile> dexFiles = DexFileFactory.loadDexContainer(new File(this.inputFile, dexFileName), Opcodes.forApi(15));
            for (String dexEntryName : dexFiles.getDexEntryNames()) {
                MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry = dexFiles.getEntry(dexEntryName);
                BaksmaliOptions options = new BaksmaliOptions();
                List<? extends DexBackedClassDef> classDefs = Ordering.natural().sortedCopy(dexEntry.getDexFile().getClasses());
                for (ClassDef classDef : classDefs) {
                    String[] lines = ApkUtil.disassembleClass(classDef, options);
                    if (lines == null) continue;
                    this.readSmaliLines(lines);
                }
            }
        }
    }

    private void readSmaliLines(String[] lines) {
        if (lines == null) {
            return;
        }
        for (String line : lines) {
            String[] columns;
            if (Util.isNullOrNil(line = line.trim()) || !line.startsWith("const-string") || (columns = line.split(",")).length != 2) continue;
            String assetFileName = columns[1].trim();
            if (Util.isNullOrNil(assetFileName = assetFileName.substring(1, assetFileName.length() - 1))) continue;
            for (String path : this.assetsPathSet) {
                if (!assetFileName.endsWith(path)) continue;
                this.assetRefSet.add(path);
            }
        }
    }

    private boolean ignoreAsset(String name) {
        for (String pattern : this.ignoreSet) {
            Log.d(TAG, "pattern %s", pattern);
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private void generateAssetsSet(String rootPath) {
        HashSet<String> relativeAssetsSet = new HashSet<String>();
        for (String path : this.assetsPathSet) {
            int index = path.indexOf(rootPath);
            if (index < 0) continue;
            String relativePath = path.substring(index + rootPath.length() + 1);
            Log.d(TAG, "assets %s", relativePath);
            relativeAssetsSet.add(relativePath);
            if (!this.ignoreAsset(relativePath)) continue;
            Log.d(TAG, "ignore assets %s", relativePath);
            this.assetRefSet.add(relativePath);
        }
        this.assetsPathSet.clear();
        this.assetsPathSet.addAll(relativeAssetsSet);
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.type, "json", this.config);
            long startTime = System.currentTimeMillis();
            File assetDir = new File(this.inputFile, "assets");
            this.findAssetsFile(assetDir);
            this.generateAssetsSet(assetDir.getAbsolutePath());
            Log.i(TAG, "find all assets count: %d", this.assetsPathSet.size());
            this.decodeCode();
            Log.i(TAG, "find reference assets count: %d", this.assetRefSet.size());
            this.assetsPathSet.removeAll(this.assetRefSet);
            JsonArray jsonArray = new JsonArray();
            for (String name : this.assetsPathSet) {
                jsonArray.add(name);
            }
            ((TaskJsonResult)taskResult).add("unused-assets", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

